package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class DuplicateChunk extends Task {

	public DuplicateChunk() {
		super("DuplicateChunk");
	}

	/**
	 *  List of camera keys to copy.
	 */
	public void setCameras(int[] value) {
		setParameter("cameras", (Object) value);
	}

	/**
	 *  List of camera keys to copy.
	 */
	public int[] getCameras() {
		return (int[]) getParameter("cameras");
	}

	/**
	 *  Chunk to copy.
	 */
	public void setChunk(int value) {
		setParameter("chunk", (Object) value);
	}

	/**
	 *  Chunk to copy.
	 */
	public int getChunk() {
		return (int) getParameter("chunk");
	}

	/**
	 *  Copy depth maps.
	 */
	public void setCopyDepthMaps(boolean value) {
		setParameter("copy_depth_maps", (Object) value);
	}

	/**
	 *  Copy depth maps.
	 */
	public boolean getCopyDepthMaps() {
		return (boolean) getParameter("copy_depth_maps");
	}

	/**
	 *  Copy DEMs.
	 */
	public void setCopyElevations(boolean value) {
		setParameter("copy_elevations", (Object) value);
	}

	/**
	 *  Copy DEMs.
	 */
	public boolean getCopyElevations() {
		return (boolean) getParameter("copy_elevations");
	}

	/**
	 *  Copy keypoints.
	 */
	public void setCopyKeypoints(boolean value) {
		setParameter("copy_keypoints", (Object) value);
	}

	/**
	 *  Copy keypoints.
	 */
	public boolean getCopyKeypoints() {
		return (boolean) getParameter("copy_keypoints");
	}

	/**
	 *  Copy laser scans.
	 */
	public void setCopyLaserScans(boolean value) {
		setParameter("copy_laser_scans", (Object) value);
	}

	/**
	 *  Copy laser scans.
	 */
	public boolean getCopyLaserScans() {
		return (boolean) getParameter("copy_laser_scans");
	}

	/**
	 *  Copy masks.
	 */
	public void setCopyMasks(boolean value) {
		setParameter("copy_masks", (Object) value);
	}

	/**
	 *  Copy masks.
	 */
	public boolean getCopyMasks() {
		return (boolean) getParameter("copy_masks");
	}

	/**
	 *  Copy models.
	 */
	public void setCopyModels(boolean value) {
		setParameter("copy_models", (Object) value);
	}

	/**
	 *  Copy models.
	 */
	public boolean getCopyModels() {
		return (boolean) getParameter("copy_models");
	}

	/**
	 *  Copy orthomosaics.
	 */
	public void setCopyOrthomosaics(boolean value) {
		setParameter("copy_orthomosaics", (Object) value);
	}

	/**
	 *  Copy orthomosaics.
	 */
	public boolean getCopyOrthomosaics() {
		return (boolean) getParameter("copy_orthomosaics");
	}

	/**
	 *  Copy point clouds.
	 */
	public void setCopyPointClouds(boolean value) {
		setParameter("copy_point_clouds", (Object) value);
	}

	/**
	 *  Copy point clouds.
	 */
	public boolean getCopyPointClouds() {
		return (boolean) getParameter("copy_point_clouds");
	}

	/**
	 *  Copy tiled models.
	 */
	public void setCopyTiledModels(boolean value) {
		setParameter("copy_tiled_models", (Object) value);
	}

	/**
	 *  Copy tiled models.
	 */
	public boolean getCopyTiledModels() {
		return (boolean) getParameter("copy_tiled_models");
	}

	/**
	 *  List of frame keys to copy.
	 */
	public void setFrames(int[] value) {
		setParameter("frames", (Object) value);
	}

	/**
	 *  List of frame keys to copy.
	 */
	public int[] getFrames() {
		return (int[]) getParameter("frames");
	}

	/**
	 *  New chunk label.
	 */
	public void setLabel(String value) {
		setParameter("label", (Object) value);
	}

	/**
	 *  New chunk label.
	 */
	public String getLabel() {
		return (String) getParameter("label");
	}

	/**
	 *  List of laser scan keys to copy.
	 */
	public void setLaserScans(int[] value) {
		setParameter("laser_scans", (Object) value);
	}

	/**
	 *  List of laser scan keys to copy.
	 */
	public int[] getLaserScans() {
		return (int[]) getParameter("laser_scans");
	}

}
