/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.1
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.agisoft.metashape;

import java.lang.AutoCloseable;
import java.util.Optional;
import java.util.Map;

/**
 * CloudClient class provides access to the Agisoft Cloud processing service and allows<br>
 * to create and manage cloud projects.
 */
public class CloudClient implements AutoCloseable {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected CloudClient(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(CloudClient obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(CloudClient obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        MetashapeJNI.delete_CloudClient(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  @Override
  public void close() {
    delete();
  }

  static public class ProcessingStatus {

    private String status;
    private double progress;
    private String error;

    public void setStatus(String status) {
      this.status = status;
    }

    public String getStatus() {
      return this.status;
    }

    public void setProgress(double progress) {
      this.progress = progress;
    }

    public double getProgress() {
      return progress;
    }

    public void setError(String error) {
      this.error = error;
    }

    public String getError() {
      return this.error;
    }

  }

  static public class ProjectInfo {

    private String project_id;
    private String project_name;
    private String creation_date;
    private long project_size;
    private long photos_size;
    private boolean shared_with_me;

    public void setProjectId(String value) {
      this.project_id = value;
    }

    public String getProjectId() {
      return project_id;
    }

    public void setProjectName(String value) {
      this.project_name = value;
    }

    public String getProjectName() {
      return project_name;
    }

    public void setCreationDate(String value) {
      this.creation_date = value;
    }

    public String getCreationDate() {
      return creation_date;
    }

    public void setProjectSize(long value) {
      this.project_size = value;
    }

    public long getProjectSize() {
      return project_size;
    }

    public void setPhotosSize(long value) {
      this.photos_size = value;
    }

    public long getPhotosSize() {
      return photos_size;
    }

    public void setSharedWithMe(boolean value) {
      this.shared_with_me = value;
    }

    public boolean getSharedWithMe() {
      return shared_with_me;
    }

  }

  /**
   * Set cloud account username.<br>
   * @param username Username.
   */
  public void setUsername(String username) {
    MetashapeJNI.CloudClient_setUsername(swigCPtr, this, username);
  }

  /**
   * Get cloud account username.<br>
   * @return Username.
   */
  public String getUsername() {
    return MetashapeJNI.CloudClient_getUsername(swigCPtr, this);
  }

  /**
   * Set cloud account password.<br>
   * @param password User password.
   */
  public void setPassword(String password) {
    MetashapeJNI.CloudClient_setPassword(swigCPtr, this, password);
  }

  /**
   * Get cloud account password.<br>
   * @return User password.
   */
  public String getPassword() {
    return MetashapeJNI.CloudClient_getPassword(swigCPtr, this);
  }

  /**
   * Set client software id (optional).<br>
   * @param client_id Client software id.
   */
  public void setClientId(String client_id) {
    MetashapeJNI.CloudClient_setClientId(swigCPtr, this, client_id);
  }

  /**
   * Get client software id (optional).<br>
   * @return Client software id.
   */
  public String getClientId() {
    return MetashapeJNI.CloudClient_getClientId(swigCPtr, this);
  }

  /**
   * Set client software secret (optional).<br>
   * @param client_secret Client software secret.
   */
  public void setClientSecret(String client_secret) {
    MetashapeJNI.CloudClient_setClientSecret(swigCPtr, this, client_secret);
  }

  /**
   * Get client software secret (optional).<br>
   * @return Client software secret.
   */
  public String getClientSecret() {
    return MetashapeJNI.CloudClient_getClientSecret(swigCPtr, this);
  }

  /**
   * Upload project to the cloud.<br>
   * @param document Project to upload.<br>
   * @param progress Progress callback.
   */
  public void uploadProject(Document document, Progress progress) {
    MetashapeJNI.CloudClient_uploadProject(swigCPtr, this, Document.getCPtr(document), document, progress);
  }

  /**
   * Download project from the cloud.<br>
   * @param document Project to download.<br>
   * @param progress Progress callback.
   */
  public void downloadProject(Document document, Progress progress) {
    MetashapeJNI.CloudClient_downloadProject(swigCPtr, this, Document.getCPtr(document), document, progress);
  }

  /**
   * Start processing in the cloud.<br>
   * @param document Project to process.<br>
   * @param tasks List of processing tasks to execute.
   */
  public void processProject(Document document, NetworkTask[] tasks) {
    MetashapeJNI.CloudClient_processProject(swigCPtr, this, Document.getCPtr(document), document, tasks);
  }

  /**
   * Get processing status.<br>
   * @param document Project being processed.<br>
   * @return Processing status.
   */
  public CloudClient.ProcessingStatus getProcessingStatus(Document document) { return MetashapeJNI.CloudClient_getProcessingStatus(swigCPtr, this, Document.getCPtr(document), document); }

  /**
   * Cancel processing.<br>
   * @param document Project to cancel.
   */
  public void abortProcessing(Document document) {
    MetashapeJNI.CloudClient_abortProcessing(swigCPtr, this, Document.getCPtr(document), document);
  }

  /**
   * Get list of projects in the cloud.<br>
   * @return List of projects.
   */
  public CloudClient.ProjectInfo[] getProjectList() { return MetashapeJNI.CloudClient_getProjectList(swigCPtr, this); }

  public CloudClient() {
    this(MetashapeJNI.new_CloudClient(), true);
  }

}
