/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.1
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.agisoft.metashape;

import java.lang.AutoCloseable;
import java.util.Optional;
import java.util.Map;

/**
 * A set of generated depth maps.
 */
public class DepthMaps implements AutoCloseable {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected DepthMaps(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(DepthMaps obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(DepthMaps obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        MetashapeJNI.delete_DepthMaps(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  @Override
  public void close() {
    delete();
  }

  public DepthMaps(DepthMaps depth_maps) {
    this(MetashapeJNI.new_DepthMaps(DepthMaps.getCPtr(depth_maps), depth_maps), true);
  }

  /**
   *  Depth maps identifier.
   */
  public int getKey() {
    return MetashapeJNI.DepthMaps_getKey(swigCPtr, this);
  }

  /**
   *  Chunk container, may be null.
   */
  public Optional<Chunk> getChunk() {
    long ptr = MetashapeJNI.DepthMaps_getChunk(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Chunk(ptr, true));
  }

  /**
   *  Depth maps label.
   */
  public void setLabel(String label) {
    MetashapeJNI.DepthMaps_setLabel(swigCPtr, this, label);
  }

  /**
   *  Depth maps label.
   */
  public String getLabel() {
    return MetashapeJNI.DepthMaps_getLabel(swigCPtr, this);
  }

  /**
   *  Depth map for the camera, may be null.
   */
  public void setDepthMap(int camera, DepthMap depth_map) {
    MetashapeJNI.DepthMaps_setDepthMap(swigCPtr, this, camera, depth_map == null ? 0 : DepthMap.getCPtr(depth_map), depth_map);
  }

  /**
   *  Depth map for the camera, may be null.
   */
  public Optional<DepthMap> getDepthMap(int camera) {
    long ptr = MetashapeJNI.DepthMaps_getDepthMap(swigCPtr, this, camera);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new DepthMap(ptr, true));
  }

  /**
   *  Path to depth maps file.
   */
  public String getPath() {
    return MetashapeJNI.DepthMaps_getPath(swigCPtr, this);
  }

  /**
   *  Depth maps meta data.
   */
  public void setMeta(Map<String,String> meta) {
    MetashapeJNI.DepthMaps_setMeta(swigCPtr, this, meta);
  }

  /**
   *  Depth maps meta data.
   */
  public Map<String,String> getMeta() { return MetashapeJNI.DepthMaps_getMeta(swigCPtr, this); }

}
