/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.1
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.agisoft.metashape;

import java.lang.AutoCloseable;
import java.util.Optional;
import java.util.Map;

/**
 * Point cloud.
 */
public class PointCloud implements AutoCloseable {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected PointCloud(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(PointCloud obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(PointCloud obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        MetashapeJNI.delete_PointCloud(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  @Override
  public void close() {
    delete();
  }

  public PointCloud(PointCloud point_cloud) {
    this(MetashapeJNI.new_PointCloud(PointCloud.getCPtr(point_cloud), point_cloud), true);
  }

  /**
   *  Point cloud identifier.
   */
  public int getKey() {
    return MetashapeJNI.PointCloud_getKey(swigCPtr, this);
  }

  /**
   *  Chunk container, may be null.
   */
  public Optional<Chunk> getChunk() {
    long ptr = MetashapeJNI.PointCloud_getChunk(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Chunk(ptr, true));
  }

  /**
   *  Point cloud label.
   */
  public void setLabel(String label) {
    MetashapeJNI.PointCloud_setLabel(swigCPtr, this, label);
  }

  /**
   *  Point cloud label.
   */
  public String getLabel() {
    return MetashapeJNI.PointCloud_getLabel(swigCPtr, this);
  }

  /**
   *  Enables/disables the point cloud.
   */
  public void setEnabled(boolean state) {
    MetashapeJNI.PointCloud_setEnabled(swigCPtr, this, state);
  }

  /**
   *  Enables/disables the point cloud.
   */
  public boolean isEnabled() {
    return MetashapeJNI.PointCloud_isEnabled(swigCPtr, this);
  }

  /**
   *  Selects/deselects the point cloud.
   */
  public void setSelected(boolean state) {
    MetashapeJNI.PointCloud_setSelected(swigCPtr, this, state);
  }

  /**
   *  Selects/deselects the point cloud.
   */
  public boolean isSelected() {
    return MetashapeJNI.PointCloud_isSelected(swigCPtr, this);
  }

  /**
   *  Point cloud group, may be null.
   */
  public void setGroup(PointCloudGroup group) {
    MetashapeJNI.PointCloud_setGroup(swigCPtr, this, group == null ? 0 : PointCloudGroup.getCPtr(group), group);
  }

  /**
   *  Point cloud group, may be null.
   */
  public Optional<PointCloudGroup> getGroup() {
    long ptr = MetashapeJNI.PointCloud_getGroup(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new PointCloudGroup(ptr, true));
  }

  /**
   *  Point cloud trajectory, may be null.
   */
  public void setTrajectory(Trajectory trajectory) {
    MetashapeJNI.PointCloud_setTrajectory(swigCPtr, this, trajectory == null ? 0 : Trajectory.getCPtr(trajectory), trajectory);
  }

  /**
   *  Point cloud trajectory, may be null.
   */
  public Optional<Trajectory> getTrajectory() {
    long ptr = MetashapeJNI.PointCloud_getTrajectory(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Trajectory(ptr, true));
  }

  /**
   *  Path to point cloud file.
   */
  public String getPath() {
    return MetashapeJNI.PointCloud_getPath(swigCPtr, this);
  }

  /**
   *  Number of points in point cloud.
   */
  public long getPointCount() {
    return MetashapeJNI.PointCloud_getPointCount(swigCPtr, this);
  }

  /**
   *  Point cloud meta data.
   */
  public void setMeta(Map<String,String> meta) {
    MetashapeJNI.PointCloud_setMeta(swigCPtr, this, meta);
  }

  /**
   *  Point cloud meta data.
   */
  public Map<String,String> getMeta() { return MetashapeJNI.PointCloud_getMeta(swigCPtr, this); }

  /**
   *  4x4 point cloud transformation matrix.
   */
  public void setTransform(Matrix transform) {
    MetashapeJNI.PointCloud_setTransform(swigCPtr, this, transform);
  }

  /**
   *  4x4 point cloud transformation matrix.
   */
  public Matrix getTransform() { return MetashapeJNI.PointCloud_getTransform(swigCPtr, this); }

  /**
   *  Reference coordinate system, may be null.
   */
  public void setCoordinateSystem(CoordinateSystem crs) {
    MetashapeJNI.PointCloud_setCoordinateSystem(swigCPtr, this, crs == null ? 0 : CoordinateSystem.getCPtr(crs), crs);
  }

  /**
   *  Reference coordinate system, may be null.
   */
  public Optional<CoordinateSystem> getCoordinateSystem() {
    long ptr = MetashapeJNI.PointCloud_getCoordinateSystem(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new CoordinateSystem(ptr, true));
  }

  /**
   * Returns ray intersection with the point cloud.<br>
   * @param origin Ray origin.<br>
   * @param target Point on the ray.<br>
   * @return Coordinates of the intersection point, may be null.
   */
  public Optional<Vector> pickPoint(Vector origin, Vector target) {
	Vector values = MetashapeJNI.PointCloud_pickPoint(swigCPtr, this, origin, target);
	return values == null ? Optional.empty() : Optional.of(values); }

  /**
   * Permanently removes deleted points from point cloud.<br>
   * @param progress Progress callback.
   */
  public void compactPoints(Progress progress) {
    MetashapeJNI.PointCloud_compactPoints(swigCPtr, this, progress);
  }

  /**
   * Remove points.<br>
   * @param point_classes Classes of points to be removed.<br>
   * @param progress Progress callback.
   */
  public void removePoints(int[] point_classes, Progress progress) {
    MetashapeJNI.PointCloud_removePoints(swigCPtr, this, point_classes, progress);
  }

  /**
   * Restore deleted points.<br>
   * @param point_classes Classes of points to be restored.<br>
   * @param progress Progress callback.
   */
  public void restorePoints(int[] point_classes, Progress progress) {
    MetashapeJNI.PointCloud_restorePoints(swigCPtr, this, point_classes, progress);
  }

  /**
   * Assign class to points.<br>
   * @param target Target class.<br>
   * @param source Classes of points to be replaced.<br>
   * @param progress Progress callback.
   */
  public void assignClass(int target, int[] source, Progress progress) {
    MetashapeJNI.PointCloud_assignClass(swigCPtr, this, target, source, progress);
  }

  /**
   * Generate point cloud preview image.<br>
   * @param width Preview image width.<br>
   * @param height Preview image height.<br>
   * @param transform 4x4 viewpoint transformation matrix.<br>
   * @param point_size Point size.<br>
   * @return Preview image.
   */
  public Image renderPreview(long width, long height, Matrix transform, int point_size, Progress progress) {
    return new Image(MetashapeJNI.PointCloud_renderPreview(swigCPtr, this, width, height, transform, point_size, progress), true);
  }

  public enum Criterion {
    ScanAngle,
    Confidence;
  }

}
