/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.1
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.agisoft.metashape;

import java.lang.AutoCloseable;
import java.util.Optional;
import java.util.Map;

/**
 * PointCloudGroup objects define groups of multiple laser scans. The grouping is established by<br>
 * assignment of a PointCloudGroup instance to the PointCloud.group attribute of participating point clouds.
 */
public class PointCloudGroup implements AutoCloseable {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected PointCloudGroup(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(PointCloudGroup obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(PointCloudGroup obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        MetashapeJNI.delete_PointCloudGroup(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  @Override
  public void close() {
    delete();
  }

  public PointCloudGroup(PointCloudGroup camera_group) {
    this(MetashapeJNI.new_PointCloudGroup(PointCloudGroup.getCPtr(camera_group), camera_group), true);
  }

  /**
   *  Point cloud group key.
   */
  public int getKey() {
    return MetashapeJNI.PointCloudGroup_getKey(swigCPtr, this);
  }

  /**
   *  Chunk container, may be null.
   */
  public Optional<Chunk> getChunk() {
    long ptr = MetashapeJNI.PointCloudGroup_getChunk(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Chunk(ptr, true));
  }

  /**
   *  Point cloud group type.
   */
  public void setFixed(boolean on) {
    MetashapeJNI.PointCloudGroup_setFixed(swigCPtr, this, on);
  }

  /**
   *  Point cloud group type.
   */
  public boolean getFixed() {
    return MetashapeJNI.PointCloudGroup_getFixed(swigCPtr, this);
  }

  /**
   *  Point cloud group label.
   */
  public void setLabel(String label) {
    MetashapeJNI.PointCloudGroup_setLabel(swigCPtr, this, label);
  }

  /**
   *  Point cloud group label.
   */
  public String getLabel() {
    return MetashapeJNI.PointCloudGroup_getLabel(swigCPtr, this);
  }

  /**
   *  Current selection state.
   */
  public void setSelected(boolean state) {
    MetashapeJNI.PointCloudGroup_setSelected(swigCPtr, this, state);
  }

  /**
   *  Current selection state.
   */
  public boolean isSelected() {
    return MetashapeJNI.PointCloudGroup_isSelected(swigCPtr, this);
  }

  /**
   *  Point cloud group meta data.
   */
  public void setMeta(Map<String,String> meta) {
    MetashapeJNI.PointCloudGroup_setMeta(swigCPtr, this, meta);
  }

  /**
   *  Point cloud group meta data.
   */
  public Map<String,String> getMeta() { return MetashapeJNI.PointCloudGroup_getMeta(swigCPtr, this); }

  /**
   *  4x4 point cloud group transformation matrix.
   */
  public void setTransform(Matrix transform) {
    MetashapeJNI.PointCloudGroup_setTransform(swigCPtr, this, transform);
  }

  /**
   *  4x4 point cloud group transformation matrix.
   */
  public Matrix getTransform() { return MetashapeJNI.PointCloudGroup_getTransform(swigCPtr, this); }

  /**
   *  Reference coordinate system, may be null.
   */
  public void setCoordinateSystem(CoordinateSystem crs) {
    MetashapeJNI.PointCloudGroup_setCoordinateSystem(swigCPtr, this, crs == null ? 0 : CoordinateSystem.getCPtr(crs), crs);
  }

  /**
   *  Reference coordinate system, may be null.
   */
  public Optional<CoordinateSystem> getCoordinateSystem() {
    long ptr = MetashapeJNI.PointCloudGroup_getCoordinateSystem(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new CoordinateSystem(ptr, true));
  }

}
