/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.1
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.agisoft.metashape;

import java.lang.AutoCloseable;
import java.util.Optional;
import java.util.Map;

/**
 * Trajectory.
 */
public class Trajectory implements AutoCloseable {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected Trajectory(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(Trajectory obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(Trajectory obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        MetashapeJNI.delete_Trajectory(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  @Override
  public void close() {
    delete();
  }

  public Trajectory(Trajectory trajectory) {
    this(MetashapeJNI.new_Trajectory(Trajectory.getCPtr(trajectory), trajectory), true);
  }

  /**
   *  Trajectory identifier.
   */
  public int getKey() {
    return MetashapeJNI.Trajectory_getKey(swigCPtr, this);
  }

  /**
   *  Chunk container, may be null.
   */
  public Optional<Chunk> getChunk() {
    long ptr = MetashapeJNI.Trajectory_getChunk(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Chunk(ptr, true));
  }

  /**
   *  Trajectory label.
   */
  public void setLabel(String label) {
    MetashapeJNI.Trajectory_setLabel(swigCPtr, this, label);
  }

  /**
   *  Trajectory label.
   */
  public String getLabel() {
    return MetashapeJNI.Trajectory_getLabel(swigCPtr, this);
  }

  /**
   *  Selects/deselects the trajectory.
   */
  public void setSelected(boolean state) {
    MetashapeJNI.Trajectory_setSelected(swigCPtr, this, state);
  }

  /**
   *  Selects/deselects the trajectory.
   */
  public boolean isSelected() {
    return MetashapeJNI.Trajectory_isSelected(swigCPtr, this);
  }

  /**
   *  Path to trajectory file.
   */
  public String getPath() {
    return MetashapeJNI.Trajectory_getPath(swigCPtr, this);
  }

  /**
   *  Number of positions in trajectory.
   */
  public long getPositionCount() {
    return MetashapeJNI.Trajectory_getPositionCount(swigCPtr, this);
  }

  /**
   *  GPS antenna correction.
   */
  public void setAntenna(Antenna antenna) {
    MetashapeJNI.Trajectory_setAntenna(swigCPtr, this, antenna);
  }

  /**
   *  GPS antenna correction.
   */
  public Antenna getAntenna() { return MetashapeJNI.Trajectory_getAntenna(swigCPtr, this); }

  /**
   *  Trajectory meta data.
   */
  public void setMeta(Map<String,String> meta) {
    MetashapeJNI.Trajectory_setMeta(swigCPtr, this, meta);
  }

  /**
   *  Trajectory meta data.
   */
  public Map<String,String> getMeta() { return MetashapeJNI.Trajectory_getMeta(swigCPtr, this); }

  /**
   *  4x4 trajectory transformation matrix.
   */
  public void setTransform(Matrix transform) {
    MetashapeJNI.Trajectory_setTransform(swigCPtr, this, transform);
  }

  /**
   *  4x4 trajectory transformation matrix.
   */
  public Matrix getTransform() { return MetashapeJNI.Trajectory_getTransform(swigCPtr, this); }

  /**
   *  Reference coordinate system, may be null.
   */
  public void setCoordinateSystem(CoordinateSystem crs) {
    MetashapeJNI.Trajectory_setCoordinateSystem(swigCPtr, this, crs == null ? 0 : CoordinateSystem.getCPtr(crs), crs);
  }

  /**
   *  Reference coordinate system, may be null.
   */
  public Optional<CoordinateSystem> getCoordinateSystem() {
    long ptr = MetashapeJNI.Trajectory_getCoordinateSystem(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new CoordinateSystem(ptr, true));
  }

}
