package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class BuildPointCloud extends Task {

	public BuildPointCloud() {
		super("BuildPointCloud");
	}

	/**
	 *  Asset to process.
	 */
	public void setAsset(int value) {
		setParameter("asset", (Object) value);
	}

	/**
	 *  Asset to process.
	 */
	public int getAsset() {
		return (int) getParameter("asset");
	}

	/**
	 *  List of frames to process.
	 */
	public void setFrames(int[] value) {
		setParameter("frames", (Object) value);
	}

	/**
	 *  List of frames to process.
	 */
	public int[] getFrames() {
		return (int[]) getParameter("frames");
	}

	/**
	 *  Enable store depth maps option.
	 */
	public void setKeepDepth(boolean value) {
		setParameter("keep_depth", (Object) value);
	}

	/**
	 *  Enable store depth maps option.
	 */
	public boolean getKeepDepth() {
		return (boolean) getParameter("keep_depth");
	}

	/**
	 *  Maximum number of neighbor images to use for depth map filtering. Default: 100
	 */
	public void setMaxNeighbors(int value) {
		setParameter("max_neighbors", (Object) value);
	}

	/**
	 *  Maximum number of neighbor images to use for depth map filtering. Default: 100
	 */
	public int getMaxNeighbors() {
		return (int) getParameter("max_neighbors");
	}

	/**
	 *  Maximum workgroup size. Default: 100
	 */
	public void setMaxWorkgroupSize(int value) {
		setParameter("max_workgroup_size", (Object) value);
	}

	/**
	 *  Maximum workgroup size. Default: 100
	 */
	public int getMaxWorkgroupSize() {
		return (int) getParameter("max_workgroup_size");
	}

	/**
	 *  Enable point colors calculation.
	 */
	public void setPointColors(boolean value) {
		setParameter("point_colors", (Object) value);
	}

	/**
	 *  Enable point colors calculation.
	 */
	public boolean getPointColors() {
		return (boolean) getParameter("point_colors");
	}

	/**
	 *  Enable point confidence calculation.
	 */
	public void setPointConfidence(boolean value) {
		setParameter("point_confidence", (Object) value);
	}

	/**
	 *  Enable point confidence calculation.
	 */
	public boolean getPointConfidence() {
		return (boolean) getParameter("point_confidence");
	}

	/**
	 *  Desired point spacing (m). Default: 0.1
	 */
	public void setPointsSpacing(double value) {
		setParameter("points_spacing", (Object) value);
	}

	/**
	 *  Desired point spacing (m). Default: 0.1
	 */
	public double getPointsSpacing() {
		return (double) getParameter("points_spacing");
	}

	/**
	 *  Replace default asset with generated point cloud.
	 */
	public void setReplaceAsset(boolean value) {
		setParameter("replace_asset", (Object) value);
	}

	/**
	 *  Replace default asset with generated point cloud.
	 */
	public boolean getReplaceAsset() {
		return (boolean) getParameter("replace_asset");
	}

	/**
	 *  Source data to extract points from. Default: DataSource.DepthMapsData
	 */
	public void setSourceData(DataSource value) {
		setParameter("source_data", (Object) value);
	}

	/**
	 *  Source data to extract points from. Default: DataSource.DepthMapsData
	 */
	public DataSource getSourceData() {
		return (DataSource) getParameter("source_data");
	}

	/**
	 *  Enable fine-level task subdivision.
	 */
	public void setSubdivideTask(boolean value) {
		setParameter("subdivide_task", (Object) value);
	}

	/**
	 *  Enable fine-level task subdivision.
	 */
	public boolean getSubdivideTask() {
		return (boolean) getParameter("subdivide_task");
	}

	/**
	 *  Enable uniform point sampling.
	 */
	public void setUniformSampling(boolean value) {
		setParameter("uniform_sampling", (Object) value);
	}

	/**
	 *  Enable uniform point sampling.
	 */
	public boolean getUniformSampling() {
		return (boolean) getParameter("uniform_sampling");
	}

	/**
	 *  Number of cameras in a workitem. Default: 20
	 */
	public void setWorkitemSizeCameras(int value) {
		setParameter("workitem_size_cameras", (Object) value);
	}

	/**
	 *  Number of cameras in a workitem. Default: 20
	 */
	public int getWorkitemSizeCameras() {
		return (int) getParameter("workitem_size_cameras");
	}

}
