package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class CalculatePointNormals extends Task {

	public CalculatePointNormals() {
		super("CalculatePointNormals");
	}

	/**
	 *  List of frames to process.
	 */
	public void setFrames(int[] value) {
		setParameter("frames", (Object) value);
	}

	/**
	 *  List of frames to process.
	 */
	public int[] getFrames() {
		return (int[]) getParameter("frames");
	}

	/**
	 *  Point cloud key to process.
	 */
	public void setPointCloud(int value) {
		setParameter("point_cloud", (Object) value);
	}

	/**
	 *  Point cloud key to process.
	 */
	public int getPointCloud() {
		return (int) getParameter("point_cloud");
	}

	/**
	 *  List of point clouds to process.
	 */
	public void setPointClouds(int[] value) {
		setParameter("point_clouds", (Object) value);
	}

	/**
	 *  List of point clouds to process.
	 */
	public int[] getPointClouds() {
		return (int[]) getParameter("point_clouds");
	}

	/**
	 *  Number of point neighbors to use for normal estimation. Default: 28
	 */
	public void setPointNeighbors(int value) {
		setParameter("point_neighbors", (Object) value);
	}

	/**
	 *  Number of point neighbors to use for normal estimation. Default: 28
	 */
	public int getPointNeighbors() {
		return (int) getParameter("point_neighbors");
	}

	/**
	 *  Replace source point cloud with processed one.
	 */
	public void setReplaceAsset(boolean value) {
		setParameter("replace_asset", (Object) value);
	}

	/**
	 *  Replace source point cloud with processed one.
	 */
	public boolean getReplaceAsset() {
		return (boolean) getParameter("replace_asset");
	}

}
