package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class CleanPointCloud extends Task {

	public CleanPointCloud() {
		super("CleanPointCloud");
	}

	/**
	 *  Point cloud filtering criterion. Default: PointCloud.Criterion.Confidence
	 */
	public void setCriterion(PointCloud.Criterion value) {
		setParameter("criterion", (Object) value);
	}

	/**
	 *  Point cloud filtering criterion. Default: PointCloud.Criterion.Confidence
	 */
	public PointCloud.Criterion getCriterion() {
		return (PointCloud.Criterion) getParameter("criterion");
	}

	/**
	 *  List of frames to process.
	 */
	public void setFrames(int[] value) {
		setParameter("frames", (Object) value);
	}

	/**
	 *  List of frames to process.
	 */
	public int[] getFrames() {
		return (int[]) getParameter("frames");
	}

	/**
	 *  Point cloud key to filter.
	 */
	public void setPointCloud(int value) {
		setParameter("point_cloud", (Object) value);
	}

	/**
	 *  Point cloud key to filter.
	 */
	public int getPointCloud() {
		return (int) getParameter("point_cloud");
	}

	/**
	 *  List of point clouds to filter.
	 */
	public void setPointClouds(int[] value) {
		setParameter("point_clouds", (Object) value);
	}

	/**
	 *  List of point clouds to filter.
	 */
	public int[] getPointClouds() {
		return (int[]) getParameter("point_clouds");
	}

	/**
	 *  Filtering threshold. Default: 0.0
	 */
	public void setThreshold(double value) {
		setParameter("threshold", (Object) value);
	}

	/**
	 *  Filtering threshold. Default: 0.0
	 */
	public double getThreshold() {
		return (double) getParameter("threshold");
	}

}
