package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class CleanTiePoints extends Task {

	public CleanTiePoints() {
		super("CleanTiePoints");
	}

	/**
	 *  Tie points filtering criterion. Default: TiePoints.Criterion.ReprojectionError
	 */
	public void setCriterion(TiePoints.Criterion value) {
		setParameter("criterion", (Object) value);
	}

	/**
	 *  Tie points filtering criterion. Default: TiePoints.Criterion.ReprojectionError
	 */
	public TiePoints.Criterion getCriterion() {
		return (TiePoints.Criterion) getParameter("criterion");
	}

	/**
	 *  Filtering threshold. Default: 0.0
	 */
	public void setThreshold(double value) {
		setParameter("threshold", (Object) value);
	}

	/**
	 *  Filtering threshold. Default: 0.0
	 */
	public double getThreshold() {
		return (double) getParameter("threshold");
	}

}
