package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class DetectFiducials extends Task {

	public DetectFiducials() {
		super("DetectFiducials");
	}

	/**
	 *  List of cameras to process.
	 */
	public void setCameras(int[] value) {
		setParameter("cameras", (Object) value);
	}

	/**
	 *  List of cameras to process.
	 */
	public int[] getCameras() {
		return (int[]) getParameter("cameras");
	}

	/**
	 *  Search corners for fiducials.
	 */
	public void setFiducialsPositionCorners(boolean value) {
		setParameter("fiducials_position_corners", (Object) value);
	}

	/**
	 *  Search corners for fiducials.
	 */
	public boolean getFiducialsPositionCorners() {
		return (boolean) getParameter("fiducials_position_corners");
	}

	/**
	 *  Search sides for fiducials.
	 */
	public void setFiducialsPositionSides(boolean value) {
		setParameter("fiducials_position_sides", (Object) value);
	}

	/**
	 *  Search sides for fiducials.
	 */
	public boolean getFiducialsPositionSides() {
		return (boolean) getParameter("fiducials_position_sides");
	}

	/**
	 *  Detect frame.
	 */
	public void setFrameDetector(boolean value) {
		setParameter("frame_detector", (Object) value);
	}

	/**
	 *  Detect frame.
	 */
	public boolean getFrameDetector() {
		return (boolean) getParameter("frame_detector");
	}

	/**
	 *  List of frames to process.
	 */
	public void setFrames(int[] value) {
		setParameter("frames", (Object) value);
	}

	/**
	 *  List of frames to process.
	 */
	public int[] getFrames() {
		return (int[]) getParameter("frames");
	}

	/**
	 *  Generate background masks.
	 */
	public void setGenerateMasks(boolean value) {
		setParameter("generate_masks", (Object) value);
	}

	/**
	 *  Generate background masks.
	 */
	public boolean getGenerateMasks() {
		return (boolean) getParameter("generate_masks");
	}

	/**
	 *  Use generic detector.
	 */
	public void setGenericDetector(boolean value) {
		setParameter("generic_detector", (Object) value);
	}

	/**
	 *  Use generic detector.
	 */
	public boolean getGenericDetector() {
		return (boolean) getParameter("generic_detector");
	}

	/**
	 *  Mask out dark pixels near frame edge.
	 */
	public void setMaskDarkPixels(boolean value) {
		setParameter("mask_dark_pixels", (Object) value);
	}

	/**
	 *  Mask out dark pixels near frame edge.
	 */
	public boolean getMaskDarkPixels() {
		return (boolean) getParameter("mask_dark_pixels");
	}

	/**
	 *  Use right angle detector.
	 */
	public void setRightAngleDetector(boolean value) {
		setParameter("right_angle_detector", (Object) value);
	}

	/**
	 *  Use right angle detector.
	 */
	public boolean getRightAngleDetector() {
		return (boolean) getParameter("right_angle_detector");
	}

	/**
	 *  Detect V-shape fiducials.
	 */
	public void setVShapeDetector(boolean value) {
		setParameter("v_shape_detector", (Object) value);
	}

	/**
	 *  Detect V-shape fiducials.
	 */
	public boolean getVShapeDetector() {
		return (boolean) getParameter("v_shape_detector");
	}

}
