package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class ExportReference extends Task {

	public ExportReference() {
		super("ExportReference");
	}

	/**
	 *  Column order in CSV format (n - label, o - enabled flag, x/y/z - coordinates, X/Y/Z - coordinate accuracy, a/b/c - rotation angles, A/B/C - rotation angle accuracy, u/v/w - estimated coordinates, U/V/W - coordinate errors, d/e/f - estimated orientation angles, D/E/F - orientation errors, p/q/r - estimated coordinates variance, i/j/k - estimated orientation angles variance, [] - group of multiple values, | - column separator within group).
	 */
	public void setColumns(String value) {
		setParameter("columns", (Object) value);
	}

	/**
	 *  Column order in CSV format (n - label, o - enabled flag, x/y/z - coordinates, X/Y/Z - coordinate accuracy, a/b/c - rotation angles, A/B/C - rotation angle accuracy, u/v/w - estimated coordinates, U/V/W - coordinate errors, d/e/f - estimated orientation angles, D/E/F - orientation errors, p/q/r - estimated coordinates variance, i/j/k - estimated orientation angles variance, [] - group of multiple values, | - column separator within group).
	 */
	public String getColumns() {
		return (String) getParameter("columns");
	}

	/**
	 *  Column delimiter (CSV format only).
	 */
	public void setDelimiter(String value) {
		setParameter("delimiter", (Object) value);
	}

	/**
	 *  Column delimiter (CSV format only).
	 */
	public String getDelimiter() {
		return (String) getParameter("delimiter");
	}

	/**
	 *  Export format. Default: ReferenceFormat.ReferenceFormatNone
	 */
	public void setFormat(ReferenceFormat value) {
		setParameter("format", (Object) value);
	}

	/**
	 *  Export format. Default: ReferenceFormat.ReferenceFormatNone
	 */
	public ReferenceFormat getFormat() {
		return (ReferenceFormat) getParameter("format");
	}

	/**
	 *  Items to export (CSV format only). Default: ReferenceItems.ReferenceItemsCameras
	 */
	public void setItems(ReferenceItems value) {
		setParameter("items", (Object) value);
	}

	/**
	 *  Items to export (CSV format only). Default: ReferenceItems.ReferenceItemsCameras
	 */
	public ReferenceItems getItems() {
		return (ReferenceItems) getParameter("items");
	}

	/**
	 *  Path to the output file.
	 */
	public void setPath(String value) {
		setParameter("path", (Object) value);
	}

	/**
	 *  Path to the output file.
	 */
	public String getPath() {
		return (String) getParameter("path");
	}

	/**
	 *  Number of digits after the decimal point (CSV format only). Default: 6
	 */
	public void setPrecision(int value) {
		setParameter("precision", (Object) value);
	}

	/**
	 *  Number of digits after the decimal point (CSV format only). Default: 6
	 */
	public int getPrecision() {
		return (int) getParameter("precision");
	}

	/**
	 *  Save enabled flag (CSV format only).
	 */
	public void setSaveEnabled(boolean value) {
		setParameter("save_enabled", (Object) value);
	}

	/**
	 *  Save enabled flag (CSV format only).
	 */
	public boolean getSaveEnabled() {
		return (boolean) getParameter("save_enabled");
	}

	/**
	 *  Save errors (CSV format only).
	 */
	public void setSaveErrors(boolean value) {
		setParameter("save_errors", (Object) value);
	}

	/**
	 *  Save errors (CSV format only).
	 */
	public boolean getSaveErrors() {
		return (boolean) getParameter("save_errors");
	}

	/**
	 *  Save estimated values (CSV format only).
	 */
	public void setSaveEstimated(boolean value) {
		setParameter("save_estimated", (Object) value);
	}

	/**
	 *  Save estimated values (CSV format only).
	 */
	public boolean getSaveEstimated() {
		return (boolean) getParameter("save_estimated");
	}

	/**
	 *  Save location accuracy (CSV format only).
	 */
	public void setSaveLocationAccuracy(boolean value) {
		setParameter("save_location_accuracy", (Object) value);
	}

	/**
	 *  Save location accuracy (CSV format only).
	 */
	public boolean getSaveLocationAccuracy() {
		return (boolean) getParameter("save_location_accuracy");
	}

	/**
	 *  Save rotation angles (CSV format only).
	 */
	public void setSaveRotation(boolean value) {
		setParameter("save_rotation", (Object) value);
	}

	/**
	 *  Save rotation angles (CSV format only).
	 */
	public boolean getSaveRotation() {
		return (boolean) getParameter("save_rotation");
	}

	/**
	 *  Save rotation accuracy (CSV format only).
	 */
	public void setSaveRotationAccuracy(boolean value) {
		setParameter("save_rotation_accuracy", (Object) value);
	}

	/**
	 *  Save rotation accuracy (CSV format only).
	 */
	public boolean getSaveRotationAccuracy() {
		return (boolean) getParameter("save_rotation_accuracy");
	}

	/**
	 *  Save variance (CSV format only).
	 */
	public void setSaveVariance(boolean value) {
		setParameter("save_variance", (Object) value);
	}

	/**
	 *  Save variance (CSV format only).
	 */
	public boolean getSaveVariance() {
		return (boolean) getParameter("save_variance");
	}

}
