package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class ImportModel extends Task {

	public ImportModel() {
		super("ImportModel");
	}

	/**
	 *  Model coordinate system.
	 */
	public void setCRS(CoordinateSystem value) {
		setParameter("crs", (Object) value);
	}

	/**
	 *  Model coordinate system.
	 */
	public CoordinateSystem getCRS() {
		return (CoordinateSystem) getParameter("crs");
	}

	/**
	 *  Load UDIM texture layout.
	 */
	public void setDecodeUdim(boolean value) {
		setParameter("decode_udim", (Object) value);
	}

	/**
	 *  Load UDIM texture layout.
	 */
	public boolean getDecodeUdim() {
		return (boolean) getParameter("decode_udim");
	}

	/**
	 *  Model format. Default: ModelFormat.ModelFormatNone
	 */
	public void setFormat(ModelFormat value) {
		setParameter("format", (Object) value);
	}

	/**
	 *  Model format. Default: ModelFormat.ModelFormatNone
	 */
	public ModelFormat getFormat() {
		return (ModelFormat) getParameter("format");
	}

	/**
	 *  List of model paths to import in each frame of a multiframe chunk.
	 */
	public void setFramePaths(String[] value) {
		setParameter("frame_paths", (Object) value);
	}

	/**
	 *  List of model paths to import in each frame of a multiframe chunk.
	 */
	public String[] getFramePaths() {
		return (String[]) getParameter("frame_paths");
	}

	/**
	 *  Path to model.
	 */
	public void setPath(String value) {
		setParameter("path", (Object) value);
	}

	/**
	 *  Path to model.
	 */
	public String getPath() {
		return (String) getParameter("path");
	}

	/**
	 *  Replace default asset with imported model.
	 */
	public void setReplaceAsset(boolean value) {
		setParameter("replace_asset", (Object) value);
	}

	/**
	 *  Replace default asset with imported model.
	 */
	public boolean getReplaceAsset() {
		return (boolean) getParameter("replace_asset");
	}

	/**
	 *  Optional shift to be applied to vertex coordinates.
	 */
	public void setShift(Vector value) {
		setParameter("shift", (Object) value);
	}

	/**
	 *  Optional shift to be applied to vertex coordinates.
	 */
	public Vector getShift() {
		return (Vector) getParameter("shift");
	}

}
