package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class ImportReference extends Task {

	public ImportReference() {
		super("ImportReference");
	}

	/**
	 *  1st rotation angle column (CSV format only). Default: 5
	 */
	public void setColumnA(int value) {
		setParameter("column_a", (Object) value);
	}

	/**
	 *  1st rotation angle column (CSV format only). Default: 5
	 */
	public int getColumnA() {
		return (int) getParameter("column_a");
	}

	/**
	 *  2nd rotation angle column (CSV format only). Default: 6
	 */
	public void setColumnB(int value) {
		setParameter("column_b", (Object) value);
	}

	/**
	 *  2nd rotation angle column (CSV format only). Default: 6
	 */
	public int getColumnB() {
		return (int) getParameter("column_b");
	}

	/**
	 *  3rd rotation angle column (CSV format only). Default: 7
	 */
	public void setColumnC(int value) {
		setParameter("column_c", (Object) value);
	}

	/**
	 *  3rd rotation angle column (CSV format only). Default: 7
	 */
	public int getColumnC() {
		return (int) getParameter("column_c");
	}

	/**
	 *  Enabled flag column (CSV format only). Default: 10
	 */
	public void setColumnEnabled(int value) {
		setParameter("column_enabled", (Object) value);
	}

	/**
	 *  Enabled flag column (CSV format only). Default: 10
	 */
	public int getColumnEnabled() {
		return (int) getParameter("column_enabled");
	}

	/**
	 *  Label column (CSV format only). Default: 1
	 */
	public void setColumnLabel(int value) {
		setParameter("column_label", (Object) value);
	}

	/**
	 *  Label column (CSV format only). Default: 1
	 */
	public int getColumnLabel() {
		return (int) getParameter("column_label");
	}

	/**
	 *  1st rotation angle accuracy column (CSV format only). Default: 9
	 */
	public void setColumnSa(int value) {
		setParameter("column_sa", (Object) value);
	}

	/**
	 *  1st rotation angle accuracy column (CSV format only). Default: 9
	 */
	public int getColumnSa() {
		return (int) getParameter("column_sa");
	}

	/**
	 *  2nd rotation angle accuracy column (CSV format only). Default: 9
	 */
	public void setColumnSb(int value) {
		setParameter("column_sb", (Object) value);
	}

	/**
	 *  2nd rotation angle accuracy column (CSV format only). Default: 9
	 */
	public int getColumnSb() {
		return (int) getParameter("column_sb");
	}

	/**
	 *  3rd rotation angle accuracy column (CSV format only). Default: 9
	 */
	public void setColumnSc(int value) {
		setParameter("column_sc", (Object) value);
	}

	/**
	 *  3rd rotation angle accuracy column (CSV format only). Default: 9
	 */
	public int getColumnSc() {
		return (int) getParameter("column_sc");
	}

	/**
	 *  X coordinate accuracy column (CSV format only). Default: 8
	 */
	public void setColumnSx(int value) {
		setParameter("column_sx", (Object) value);
	}

	/**
	 *  X coordinate accuracy column (CSV format only). Default: 8
	 */
	public int getColumnSx() {
		return (int) getParameter("column_sx");
	}

	/**
	 *  Y coordinate accuracy column (CSV format only). Default: 8
	 */
	public void setColumnSy(int value) {
		setParameter("column_sy", (Object) value);
	}

	/**
	 *  Y coordinate accuracy column (CSV format only). Default: 8
	 */
	public int getColumnSy() {
		return (int) getParameter("column_sy");
	}

	/**
	 *  Z coordinate accuracy column (CSV format only). Default: 8
	 */
	public void setColumnSz(int value) {
		setParameter("column_sz", (Object) value);
	}

	/**
	 *  Z coordinate accuracy column (CSV format only). Default: 8
	 */
	public int getColumnSz() {
		return (int) getParameter("column_sz");
	}

	/**
	 *  X coordinate column (CSV format only). Default: 2
	 */
	public void setColumnX(int value) {
		setParameter("column_x", (Object) value);
	}

	/**
	 *  X coordinate column (CSV format only). Default: 2
	 */
	public int getColumnX() {
		return (int) getParameter("column_x");
	}

	/**
	 *  Y coordinate column (CSV format only). Default: 3
	 */
	public void setColumnY(int value) {
		setParameter("column_y", (Object) value);
	}

	/**
	 *  Y coordinate column (CSV format only). Default: 3
	 */
	public int getColumnY() {
		return (int) getParameter("column_y");
	}

	/**
	 *  Z coordinate column (CSV format only). Default: 4
	 */
	public void setColumnZ(int value) {
		setParameter("column_z", (Object) value);
	}

	/**
	 *  Z coordinate column (CSV format only). Default: 4
	 */
	public int getColumnZ() {
		return (int) getParameter("column_z");
	}

	/**
	 *  Column order in CSV format (n - label, o - enabled flag, x/y/z - coordinates, X/Y/Z - coordinate accuracy, a/b/c - rotation angles, A/B/C - rotation angle accuracy, [] - group of multiple values, | - column separator within group).
	 */
	public void setColumns(String value) {
		setParameter("columns", (Object) value);
	}

	/**
	 *  Column order in CSV format (n - label, o - enabled flag, x/y/z - coordinates, X/Y/Z - coordinate accuracy, a/b/c - rotation angles, A/B/C - rotation angle accuracy, [] - group of multiple values, | - column separator within group).
	 */
	public String getColumns() {
		return (String) getParameter("columns");
	}

	/**
	 *  Create markers for missing entries (CSV format only).
	 */
	public void setCreateMarkers(boolean value) {
		setParameter("create_markers", (Object) value);
	}

	/**
	 *  Create markers for missing entries (CSV format only).
	 */
	public boolean getCreateMarkers() {
		return (boolean) getParameter("create_markers");
	}

	/**
	 *  Reference data coordinate system (CSV format only).
	 */
	public void setCRS(CoordinateSystem value) {
		setParameter("crs", (Object) value);
	}

	/**
	 *  Reference data coordinate system (CSV format only).
	 */
	public CoordinateSystem getCRS() {
		return (CoordinateSystem) getParameter("crs");
	}

	/**
	 *  Column delimiter (CSV format only).
	 */
	public void setDelimiter(String value) {
		setParameter("delimiter", (Object) value);
	}

	/**
	 *  Column delimiter (CSV format only).
	 */
	public String getDelimiter() {
		return (String) getParameter("delimiter");
	}

	/**
	 *  File format. Default: ReferenceFormat.ReferenceFormatCSV
	 */
	public void setFormat(ReferenceFormat value) {
		setParameter("format", (Object) value);
	}

	/**
	 *  File format. Default: ReferenceFormat.ReferenceFormatCSV
	 */
	public ReferenceFormat getFormat() {
		return (ReferenceFormat) getParameter("format");
	}

	/**
	 *  Combine consecutive delimiters (CSV format only).
	 */
	public void setGroupDelimiters(boolean value) {
		setParameter("group_delimiters", (Object) value);
	}

	/**
	 *  Combine consecutive delimiters (CSV format only).
	 */
	public boolean getGroupDelimiters() {
		return (boolean) getParameter("group_delimiters");
	}

	/**
	 *  Matches reference data based on coordinates alone (CSV format only).
	 */
	public void setIgnoreLabels(boolean value) {
		setParameter("ignore_labels", (Object) value);
	}

	/**
	 *  Matches reference data based on coordinates alone (CSV format only).
	 */
	public boolean getIgnoreLabels() {
		return (boolean) getParameter("ignore_labels");
	}

	/**
	 *  Items to load reference for (CSV format only). Default: ReferenceItems.ReferenceItemsAll
	 */
	public void setItems(ReferenceItems value) {
		setParameter("items", (Object) value);
	}

	/**
	 *  Items to load reference for (CSV format only). Default: ReferenceItems.ReferenceItemsAll
	 */
	public ReferenceItems getItems() {
		return (ReferenceItems) getParameter("items");
	}

	/**
	 *  Load enabled flag (CSV format only).
	 */
	public void setLoadEnabled(boolean value) {
		setParameter("load_enabled", (Object) value);
	}

	/**
	 *  Load enabled flag (CSV format only).
	 */
	public boolean getLoadEnabled() {
		return (boolean) getParameter("load_enabled");
	}

	/**
	 *  Load location accuracy (CSV format only).
	 */
	public void setLoadLocationAccuracy(boolean value) {
		setParameter("load_location_accuracy", (Object) value);
	}

	/**
	 *  Load location accuracy (CSV format only).
	 */
	public boolean getLoadLocationAccuracy() {
		return (boolean) getParameter("load_location_accuracy");
	}

	/**
	 *  Load rotation angles (CSV format only).
	 */
	public void setLoadRotation(boolean value) {
		setParameter("load_rotation", (Object) value);
	}

	/**
	 *  Load rotation angles (CSV format only).
	 */
	public boolean getLoadRotation() {
		return (boolean) getParameter("load_rotation");
	}

	/**
	 *  Load rotation accuracy (CSV format only).
	 */
	public void setLoadRotationAccuracy(boolean value) {
		setParameter("load_rotation_accuracy", (Object) value);
	}

	/**
	 *  Load rotation accuracy (CSV format only).
	 */
	public boolean getLoadRotationAccuracy() {
		return (boolean) getParameter("load_rotation_accuracy");
	}

	/**
	 *  Path to the file with reference data.
	 */
	public void setPath(String value) {
		setParameter("path", (Object) value);
	}

	/**
	 *  Path to the file with reference data.
	 */
	public String getPath() {
		return (String) getParameter("path");
	}

	/**
	 *  Euler angles triplet used for rotation reference (CSV format only). Default: EulerAngles.EulerAnglesUndefined
	 */
	public void setRotationAngles(EulerAngles value) {
		setParameter("rotation_angles", (Object) value);
	}

	/**
	 *  Euler angles triplet used for rotation reference (CSV format only). Default: EulerAngles.EulerAnglesUndefined
	 */
	public EulerAngles getRotationAngles() {
		return (EulerAngles) getParameter("rotation_angles");
	}

	/**
	 *  Shutter lag in seconds (APM format only). Default: 0.0
	 */
	public void setShutterLag(double value) {
		setParameter("shutter_lag", (Object) value);
	}

	/**
	 *  Shutter lag in seconds (APM format only). Default: 0.0
	 */
	public double getShutterLag() {
		return (double) getParameter("shutter_lag");
	}

	/**
	 *  Number of rows to skip (CSV format only). Default: 0
	 */
	public void setSkipRows(int value) {
		setParameter("skip_rows", (Object) value);
	}

	/**
	 *  Number of rows to skip (CSV format only). Default: 0
	 */
	public int getSkipRows() {
		return (int) getParameter("skip_rows");
	}

	/**
	 *  Error threshold in meters used when ignore_labels is set (CSV format only). Default: 0.1
	 */
	public void setThreshold(double value) {
		setParameter("threshold", (Object) value);
	}

	/**
	 *  Error threshold in meters used when ignore_labels is set (CSV format only). Default: 0.1
	 */
	public double getThreshold() {
		return (double) getParameter("threshold");
	}

}
