package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class MergeChunks extends Task {

	public MergeChunks() {
		super("MergeChunks");
	}

	/**
	 *  List of chunks to process.
	 */
	public void setChunks(int[] value) {
		setParameter("chunks", (Object) value);
	}

	/**
	 *  List of chunks to process.
	 */
	public int[] getChunks() {
		return (int[]) getParameter("chunks");
	}

	/**
	 *  Copy depth maps.
	 */
	public void setCopyDepthMaps(boolean value) {
		setParameter("copy_depth_maps", (Object) value);
	}

	/**
	 *  Copy depth maps.
	 */
	public boolean getCopyDepthMaps() {
		return (boolean) getParameter("copy_depth_maps");
	}

	/**
	 *  Copy DEMs.
	 */
	public void setCopyElevations(boolean value) {
		setParameter("copy_elevations", (Object) value);
	}

	/**
	 *  Copy DEMs.
	 */
	public boolean getCopyElevations() {
		return (boolean) getParameter("copy_elevations");
	}

	/**
	 *  Copy laser scans.
	 */
	public void setCopyLaserScans(boolean value) {
		setParameter("copy_laser_scans", (Object) value);
	}

	/**
	 *  Copy laser scans.
	 */
	public boolean getCopyLaserScans() {
		return (boolean) getParameter("copy_laser_scans");
	}

	/**
	 *  Copy masks.
	 */
	public void setCopyMasks(boolean value) {
		setParameter("copy_masks", (Object) value);
	}

	/**
	 *  Copy masks.
	 */
	public boolean getCopyMasks() {
		return (boolean) getParameter("copy_masks");
	}

	/**
	 *  Copy models.
	 */
	public void setCopyModels(boolean value) {
		setParameter("copy_models", (Object) value);
	}

	/**
	 *  Copy models.
	 */
	public boolean getCopyModels() {
		return (boolean) getParameter("copy_models");
	}

	/**
	 *  Copy orthomosaics.
	 */
	public void setCopyOrthomosaics(boolean value) {
		setParameter("copy_orthomosaics", (Object) value);
	}

	/**
	 *  Copy orthomosaics.
	 */
	public boolean getCopyOrthomosaics() {
		return (boolean) getParameter("copy_orthomosaics");
	}

	/**
	 *  Copy point clouds.
	 */
	public void setCopyPointClouds(boolean value) {
		setParameter("copy_point_clouds", (Object) value);
	}

	/**
	 *  Copy point clouds.
	 */
	public boolean getCopyPointClouds() {
		return (boolean) getParameter("copy_point_clouds");
	}

	/**
	 *  Copy tiled models.
	 */
	public void setCopyTiledModels(boolean value) {
		setParameter("copy_tiled_models", (Object) value);
	}

	/**
	 *  Copy tiled models.
	 */
	public boolean getCopyTiledModels() {
		return (boolean) getParameter("copy_tiled_models");
	}

	/**
	 *  Merge default assets.
	 */
	public void setMergeAssets(boolean value) {
		setParameter("merge_assets", (Object) value);
	}

	/**
	 *  Merge default assets.
	 */
	public boolean getMergeAssets() {
		return (boolean) getParameter("merge_assets");
	}

	/**
	 *  Merge markers.
	 */
	public void setMergeMarkers(boolean value) {
		setParameter("merge_markers", (Object) value);
	}

	/**
	 *  Merge markers.
	 */
	public boolean getMergeMarkers() {
		return (boolean) getParameter("merge_markers");
	}

	/**
	 *  Merge tie points.
	 */
	public void setMergeTiepoints(boolean value) {
		setParameter("merge_tiepoints", (Object) value);
	}

	/**
	 *  Merge tie points.
	 */
	public boolean getMergeTiepoints() {
		return (boolean) getParameter("merge_tiepoints");
	}

}
