package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class PansharpenOrthomosaic extends Task {

	public PansharpenOrthomosaic() {
		super("PansharpenOrthomosaic");
	}

	/**
	 *  Orthomosaic channel mask (boolean flags, e.g. 0b0010 means only 1st channel is used and the rest ignored). Default: 0
	 */
	public void setChannels(int value) {
		setParameter("channels", (Object) value);
	}

	/**
	 *  Orthomosaic channel mask (boolean flags, e.g. 0b0010 means only 1st channel is used and the rest ignored). Default: 0
	 */
	public int getChannels() {
		return (int) getParameter("channels");
	}

	/**
	 *  Clip result to high resolution orthomosaic.
	 */
	public void setClipToPanData(boolean value) {
		setParameter("clip_to_pan_data", (Object) value);
	}

	/**
	 *  Clip result to high resolution orthomosaic.
	 */
	public boolean getClipToPanData() {
		return (boolean) getParameter("clip_to_pan_data");
	}

	/**
	 *  List of frames to process.
	 */
	public void setFrames(int[] value) {
		setParameter("frames", (Object) value);
	}

	/**
	 *  List of frames to process.
	 */
	public int[] getFrames() {
		return (int[]) getParameter("frames");
	}

	/**
	 *  Orthomosaic to pansharpen.
	 */
	public void setOrthomosaic(int value) {
		setParameter("orthomosaic", (Object) value);
	}

	/**
	 *  Orthomosaic to pansharpen.
	 */
	public int getOrthomosaic() {
		return (int) getParameter("orthomosaic");
	}

	/**
	 *  Detailed orthomosaic channel mask (boolean flags, e.g. 0b0010 means only 1st channel is used and the rest ignored). Default: 0
	 */
	public void setPanChannels(int value) {
		setParameter("pan_channels", (Object) value);
	}

	/**
	 *  Detailed orthomosaic channel mask (boolean flags, e.g. 0b0010 means only 1st channel is used and the rest ignored). Default: 0
	 */
	public int getPanChannels() {
		return (int) getParameter("pan_channels");
	}

	/**
	 *  Detailed orthomosaic.
	 */
	public void setPanOrthomosaic(int value) {
		setParameter("pan_orthomosaic", (Object) value);
	}

	/**
	 *  Detailed orthomosaic.
	 */
	public int getPanOrthomosaic() {
		return (int) getParameter("pan_orthomosaic");
	}

	/**
	 *  Replace source orthomosaic with pansharpened result.
	 */
	public void setReplaceAsset(boolean value) {
		setParameter("replace_asset", (Object) value);
	}

	/**
	 *  Replace source orthomosaic with pansharpened result.
	 */
	public boolean getReplaceAsset() {
		return (boolean) getParameter("replace_asset");
	}

}
