package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class RefineModel extends Task {

	public RefineModel() {
		super("RefineModel");
	}

	/**
	 *  List of cameras to process.
	 */
	public void setCameras(int[] value) {
		setParameter("cameras", (Object) value);
	}

	/**
	 *  List of cameras to process.
	 */
	public int[] getCameras() {
		return (int[]) getParameter("cameras");
	}

	/**
	 *  Refinement quality (1 - Ultra high, 2 - High, 4 - Medium, 8 - Low, 16 - Lowest). Default: 4
	 */
	public void setDownscale(int value) {
		setParameter("downscale", (Object) value);
	}

	/**
	 *  Refinement quality (1 - Ultra high, 2 - High, 4 - Medium, 8 - Low, 16 - Lowest). Default: 4
	 */
	public int getDownscale() {
		return (int) getParameter("downscale");
	}

	/**
	 *  List of frames to process.
	 */
	public void setFrames(int[] value) {
		setParameter("frames", (Object) value);
	}

	/**
	 *  List of frames to process.
	 */
	public int[] getFrames() {
		return (int[]) getParameter("frames");
	}

	/**
	 *  Number of refinement iterations. Default: 10
	 */
	public void setIterations(int value) {
		setParameter("iterations", (Object) value);
	}

	/**
	 *  Number of refinement iterations. Default: 10
	 */
	public int getIterations() {
		return (int) getParameter("iterations");
	}

	/**
	 *  Model to process.
	 */
	public void setModel(int value) {
		setParameter("model", (Object) value);
	}

	/**
	 *  Model to process.
	 */
	public int getModel() {
		return (int) getParameter("model");
	}

	/**
	 *  Replace default asset with refined model.
	 */
	public void setReplaceAsset(boolean value) {
		setParameter("replace_asset", (Object) value);
	}

	/**
	 *  Replace default asset with refined model.
	 */
	public boolean getReplaceAsset() {
		return (boolean) getParameter("replace_asset");
	}

	/**
	 *  Smoothing strength. Should be in range [0, 1]. Default: 0.5
	 */
	public void setSmoothness(double value) {
		setParameter("smoothness", (Object) value);
	}

	/**
	 *  Smoothing strength. Should be in range [0, 1]. Default: 0.5
	 */
	public double getSmoothness() {
		return (double) getParameter("smoothness");
	}

}
