#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtCore, except for defaults which are replaced by "...".
"""

# Module PySide2.QtCore
import PySide2
try:
    import typing
except ImportError:
    from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

from shiboken2 import Shiboken

import PySide2.QtCore


class ClassInfo(object): ...

    def __init__(self, **info: typing.Dict[str, str]) -> None: ...


class MetaFunction(object): ...


class MetaSignal(type): ...


class Property(object): ...

    def __init__(self, type: type, fget: typing.Optional[typing.Callable] = ..., fset: typing.Optional[typing.Callable] = ..., freset: typing.Optional[typing.Callable] = ..., fdel: typing.Optional[typing.Callable] = ..., doc: str = ..., notify: typing.Optional[typing.Callable] = ..., designable: bool = ..., scriptable: bool = ..., stored: bool = ..., user: bool = ..., constant: bool = ..., final: bool = ...) -> PySide2.QtCore.Property: ...


class QAbstractAnimation(PySide2.QtCore.QObject):
    KeepWhenStopped          : QAbstractAnimation.DeletionPolicy = ... # 0x0
    DeleteWhenStopped        : QAbstractAnimation.DeletionPolicy = ... # 0x1
    Forward                  : QAbstractAnimation.Direction = ... # 0x0
    Backward                 : QAbstractAnimation.Direction = ... # 0x1
    Stopped                  : QAbstractAnimation.State = ... # 0x0
    Paused                   : QAbstractAnimation.State = ... # 0x1
    Running                  : QAbstractAnimation.State = ... # 0x2

    class DeletionPolicy(Shiboken.Enum):
        KeepWhenStopped          : QAbstractAnimation.DeletionPolicy = ... # 0x0
        DeleteWhenStopped        : QAbstractAnimation.DeletionPolicy = ... # 0x1

    class Direction(Shiboken.Enum):
        Forward                  : QAbstractAnimation.Direction = ... # 0x0
        Backward                 : QAbstractAnimation.Direction = ... # 0x1

    class State(Shiboken.Enum):
        Stopped                  : QAbstractAnimation.State = ... # 0x0
        Paused                   : QAbstractAnimation.State = ... # 0x1
        Running                  : QAbstractAnimation.State = ... # 0x2

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QAbstractEventDispatcher(PySide2.QtCore.QObject):

    class TimerInfo(Shiboken.Object):

        def __init__(self, id: int, i: int, t: PySide2.QtCore.Qt.TimerType) -> None: ...


    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QAbstractItemModel(PySide2.QtCore.QObject):
    NoLayoutChangeHint       : QAbstractItemModel.LayoutChangeHint = ... # 0x0
    VerticalSortHint         : QAbstractItemModel.LayoutChangeHint = ... # 0x1
    HorizontalSortHint       : QAbstractItemModel.LayoutChangeHint = ... # 0x2

    class CheckIndexOption(Shiboken.Enum):
        NoOption                 : QAbstractItemModel.CheckIndexOption = ... # 0x0
        IndexIsValid             : QAbstractItemModel.CheckIndexOption = ... # 0x1
        DoNotUseParent           : QAbstractItemModel.CheckIndexOption = ... # 0x2
        ParentIsInvalid          : QAbstractItemModel.CheckIndexOption = ... # 0x4

    class CheckIndexOptions(object): ...

    class LayoutChangeHint(Shiboken.Enum):
        NoLayoutChangeHint       : QAbstractItemModel.LayoutChangeHint = ... # 0x0
        VerticalSortHint         : QAbstractItemModel.LayoutChangeHint = ... # 0x1
        HorizontalSortHint       : QAbstractItemModel.LayoutChangeHint = ... # 0x2

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QAbstractListModel(PySide2.QtCore.QAbstractItemModel):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QAbstractNativeEventFilter(Shiboken.Object):

    def __init__(self) -> None: ...


class QAbstractProxyModel(PySide2.QtCore.QAbstractItemModel):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QAbstractState(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QState] = ...) -> None: ...


class QAbstractTableModel(PySide2.QtCore.QAbstractItemModel):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QAbstractTransition(PySide2.QtCore.QObject):
    ExternalTransition       : QAbstractTransition.TransitionType = ... # 0x0
    InternalTransition       : QAbstractTransition.TransitionType = ... # 0x1

    class TransitionType(Shiboken.Enum):
        ExternalTransition       : QAbstractTransition.TransitionType = ... # 0x0
        InternalTransition       : QAbstractTransition.TransitionType = ... # 0x1

    def __init__(self, sourceState: typing.Optional[PySide2.QtCore.QState] = ...) -> None: ...


class QAnimationGroup(PySide2.QtCore.QAbstractAnimation):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QBasicMutex(Shiboken.Object):

    def __init__(self) -> None: ...


class QBasicTimer(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QBasicTimer) -> None: ...


class QBitArray(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QBitArray) -> None: ...
    @typing.overload
    def __init__(self, size: int, val: bool = ...) -> None: ...


class QBuffer(PySide2.QtCore.QIODevice):

    @typing.overload
    def __init__(self, buf: PySide2.QtCore.QByteArray, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QByteArray(Shiboken.Object):
    Base64Encoding           : QByteArray.Base64Option = ... # 0x0
    IgnoreBase64DecodingErrors: QByteArray.Base64Option = ... # 0x0
    KeepTrailingEquals       : QByteArray.Base64Option = ... # 0x0
    Base64UrlEncoding        : QByteArray.Base64Option = ... # 0x1
    OmitTrailingEquals       : QByteArray.Base64Option = ... # 0x2
    AbortOnBase64DecodingErrors: QByteArray.Base64Option = ... # 0x4

    class Base64DecodingStatus(Shiboken.Enum):
        Ok                       : QByteArray.Base64DecodingStatus = ... # 0x0
        IllegalInputLength       : QByteArray.Base64DecodingStatus = ... # 0x1
        IllegalCharacter         : QByteArray.Base64DecodingStatus = ... # 0x2
        IllegalPadding           : QByteArray.Base64DecodingStatus = ... # 0x3

    class Base64Option(Shiboken.Enum):
        Base64Encoding           : QByteArray.Base64Option = ... # 0x0
        IgnoreBase64DecodingErrors: QByteArray.Base64Option = ... # 0x0
        KeepTrailingEquals       : QByteArray.Base64Option = ... # 0x0
        Base64UrlEncoding        : QByteArray.Base64Option = ... # 0x1
        OmitTrailingEquals       : QByteArray.Base64Option = ... # 0x2
        AbortOnBase64DecodingErrors: QByteArray.Base64Option = ... # 0x4

    class Base64Options(object): ...

    class FromBase64Result(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, FromBase64Result: PySide2.QtCore.QByteArray.FromBase64Result) -> None: ...


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: bytearray) -> None: ...
    @typing.overload
    def __init__(self, arg__1: bytes) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QByteArray) -> None: ...
    @typing.overload
    def __init__(self, size: int, c: int) -> None: ...


class QByteArrayMatcher(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QByteArrayMatcher) -> None: ...
    @typing.overload
    def __init__(self, pattern: PySide2.QtCore.QByteArray) -> None: ...
    @typing.overload
    def __init__(self, pattern: bytes, length: int) -> None: ...


class QCalendar(Shiboken.Object):

    class System(Shiboken.Enum):
        User                     : QCalendar.System = ... # -0x1
        Gregorian                : QCalendar.System = ... # 0x0
        Julian                   : QCalendar.System = ... # 0x8
        Milankovic               : QCalendar.System = ... # 0x9
        Jalali                   : QCalendar.System = ... # 0xa
        IslamicCivil             : QCalendar.System = ... # 0xb
        Last                     : QCalendar.System = ... # 0xb

    class YearMonthDay(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, YearMonthDay: PySide2.QtCore.QCalendar.YearMonthDay) -> None: ...
        @typing.overload
        def __init__(self, y: int, m: int = ..., d: int = ...) -> None: ...


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, system: PySide2.QtCore.QCalendar.System) -> None: ...


class QCborArray(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QCborArray) -> None: ...


class QCborError(Shiboken.Object):
    NoError                  : QCborError.Code = ... # 0x0
    UnknownError             : QCborError.Code = ... # 0x1
    AdvancePastEnd           : QCborError.Code = ... # 0x3
    InputOutputError         : QCborError.Code = ... # 0x4
    GarbageAtEnd             : QCborError.Code = ... # 0x100
    EndOfFile                : QCborError.Code = ... # 0x101
    UnexpectedBreak          : QCborError.Code = ... # 0x102
    UnknownType              : QCborError.Code = ... # 0x103
    IllegalType              : QCborError.Code = ... # 0x104
    IllegalNumber            : QCborError.Code = ... # 0x105
    IllegalSimpleType        : QCborError.Code = ... # 0x106
    InvalidUtf8String        : QCborError.Code = ... # 0x204
    DataTooLarge             : QCborError.Code = ... # 0x400
    NestingTooDeep           : QCborError.Code = ... # 0x401
    UnsupportedType          : QCborError.Code = ... # 0x402

    class Code(Shiboken.Enum):
        NoError                  : QCborError.Code = ... # 0x0
        UnknownError             : QCborError.Code = ... # 0x1
        AdvancePastEnd           : QCborError.Code = ... # 0x3
        InputOutputError         : QCborError.Code = ... # 0x4
        GarbageAtEnd             : QCborError.Code = ... # 0x100
        EndOfFile                : QCborError.Code = ... # 0x101
        UnexpectedBreak          : QCborError.Code = ... # 0x102
        UnknownType              : QCborError.Code = ... # 0x103
        IllegalType              : QCborError.Code = ... # 0x104
        IllegalNumber            : QCborError.Code = ... # 0x105
        IllegalSimpleType        : QCborError.Code = ... # 0x106
        InvalidUtf8String        : QCborError.Code = ... # 0x204
        DataTooLarge             : QCborError.Code = ... # 0x400
        NestingTooDeep           : QCborError.Code = ... # 0x401
        UnsupportedType          : QCborError.Code = ... # 0x402

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QCborError: PySide2.QtCore.QCborError) -> None: ...


class QCborKnownTags(Shiboken.Enum):
    DateTimeString           : QCborKnownTags = ... # 0x0
    UnixTime_t               : QCborKnownTags = ... # 0x1
    PositiveBignum           : QCborKnownTags = ... # 0x2
    NegativeBignum           : QCborKnownTags = ... # 0x3
    Decimal                  : QCborKnownTags = ... # 0x4
    Bigfloat                 : QCborKnownTags = ... # 0x5
    COSE_Encrypt0            : QCborKnownTags = ... # 0x10
    COSE_Mac0                : QCborKnownTags = ... # 0x11
    COSE_Sign1               : QCborKnownTags = ... # 0x12
    ExpectedBase64url        : QCborKnownTags = ... # 0x15
    ExpectedBase64           : QCborKnownTags = ... # 0x16
    ExpectedBase16           : QCborKnownTags = ... # 0x17
    EncodedCbor              : QCborKnownTags = ... # 0x18
    Url                      : QCborKnownTags = ... # 0x20
    Base64url                : QCborKnownTags = ... # 0x21
    Base64                   : QCborKnownTags = ... # 0x22
    RegularExpression        : QCborKnownTags = ... # 0x23
    MimeMessage              : QCborKnownTags = ... # 0x24
    Uuid                     : QCborKnownTags = ... # 0x25
    COSE_Encrypt             : QCborKnownTags = ... # 0x60
    COSE_Mac                 : QCborKnownTags = ... # 0x61
    COSE_Sign                : QCborKnownTags = ... # 0x62
    Signature                : QCborKnownTags = ... # 0xd9f7


class QCborMap(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QCborMap) -> None: ...


class QCborParserError(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QCborParserError: PySide2.QtCore.QCborParserError) -> None: ...


class QCborSimpleType(Shiboken.Enum):
    False_                   : QCborSimpleType = ... # 0x14
    True_                    : QCborSimpleType = ... # 0x15
    Null                     : QCborSimpleType = ... # 0x16
    Undefined                : QCborSimpleType = ... # 0x17


class QCborStreamReader(Shiboken.Object):
    Error                    : QCborStreamReader.StringResultCode = ... # -0x1
    EndOfString              : QCborStreamReader.StringResultCode = ... # 0x0
    Ok                       : QCborStreamReader.StringResultCode = ... # 0x1
    UnsignedInteger          : QCborStreamReader.Type = ... # 0x0
    NegativeInteger          : QCborStreamReader.Type = ... # 0x20
    ByteArray                : QCborStreamReader.Type = ... # 0x40
    ByteString               : QCborStreamReader.Type = ... # 0x40
    String                   : QCborStreamReader.Type = ... # 0x60
    TextString               : QCborStreamReader.Type = ... # 0x60
    Array                    : QCborStreamReader.Type = ... # 0x80
    Map                      : QCborStreamReader.Type = ... # 0xa0
    Tag                      : QCborStreamReader.Type = ... # 0xc0
    SimpleType               : QCborStreamReader.Type = ... # 0xe0
    Float16                  : QCborStreamReader.Type = ... # 0xf9
    HalfFloat                : QCborStreamReader.Type = ... # 0xf9
    Float                    : QCborStreamReader.Type = ... # 0xfa
    Double                   : QCborStreamReader.Type = ... # 0xfb
    Invalid                  : QCborStreamReader.Type = ... # 0xff

    class StringResultCode(Shiboken.Enum):
        Error                    : QCborStreamReader.StringResultCode = ... # -0x1
        EndOfString              : QCborStreamReader.StringResultCode = ... # 0x0
        Ok                       : QCborStreamReader.StringResultCode = ... # 0x1

    class Type(Shiboken.Enum):
        UnsignedInteger          : QCborStreamReader.Type = ... # 0x0
        NegativeInteger          : QCborStreamReader.Type = ... # 0x20
        ByteArray                : QCborStreamReader.Type = ... # 0x40
        ByteString               : QCborStreamReader.Type = ... # 0x40
        String                   : QCborStreamReader.Type = ... # 0x60
        TextString               : QCborStreamReader.Type = ... # 0x60
        Array                    : QCborStreamReader.Type = ... # 0x80
        Map                      : QCborStreamReader.Type = ... # 0xa0
        Tag                      : QCborStreamReader.Type = ... # 0xc0
        SimpleType               : QCborStreamReader.Type = ... # 0xe0
        Float16                  : QCborStreamReader.Type = ... # 0xf9
        HalfFloat                : QCborStreamReader.Type = ... # 0xf9
        Float                    : QCborStreamReader.Type = ... # 0xfa
        Double                   : QCborStreamReader.Type = ... # 0xfb
        Invalid                  : QCborStreamReader.Type = ... # 0xff

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, data: PySide2.QtCore.QByteArray) -> None: ...
    @typing.overload
    def __init__(self, data: bytes, len: int) -> None: ...
    @typing.overload
    def __init__(self, data: bytearray, len: int) -> None: ...
    @typing.overload
    def __init__(self, device: PySide2.QtCore.QIODevice) -> None: ...


class QCborStreamWriter(Shiboken.Object):

    @typing.overload
    def __init__(self, data: PySide2.QtCore.QByteArray) -> None: ...
    @typing.overload
    def __init__(self, device: PySide2.QtCore.QIODevice) -> None: ...


class QCborStringResultByteArray(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QCborStringResultByteArray: PySide2.QtCore.QCborStringResultByteArray) -> None: ...


class QCborStringResultString(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QCborStringResultString: PySide2.QtCore.QCborStringResultString) -> None: ...


class QCborValue(Shiboken.Object):
    Compact                  : QCborValue.DiagnosticNotationOption = ... # 0x0
    LineWrapped              : QCborValue.DiagnosticNotationOption = ... # 0x1
    ExtendedFormat           : QCborValue.DiagnosticNotationOption = ... # 0x2
    NoTransformation         : QCborValue.EncodingOption = ... # 0x0
    SortKeysInMaps           : QCborValue.EncodingOption = ... # 0x1
    UseFloat                 : QCborValue.EncodingOption = ... # 0x2
    UseFloat16               : QCborValue.EncodingOption = ... # 0x6
    UseIntegers              : QCborValue.EncodingOption = ... # 0x8
    Invalid                  : QCborValue.Type = ... # -0x1
    Integer                  : QCborValue.Type = ... # 0x0
    ByteArray                : QCborValue.Type = ... # 0x40
    String                   : QCborValue.Type = ... # 0x60
    Array                    : QCborValue.Type = ... # 0x80
    Map                      : QCborValue.Type = ... # 0xa0
    Tag                      : QCborValue.Type = ... # 0xc0
    SimpleType               : QCborValue.Type = ... # 0x100
    False_                   : QCborValue.Type = ... # 0x114
    True_                    : QCborValue.Type = ... # 0x115
    Null                     : QCborValue.Type = ... # 0x116
    Undefined                : QCborValue.Type = ... # 0x117
    Double                   : QCborValue.Type = ... # 0x202
    DateTime                 : QCborValue.Type = ... # 0x10000
    Url                      : QCborValue.Type = ... # 0x10020
    RegularExpression        : QCborValue.Type = ... # 0x10023
    Uuid                     : QCborValue.Type = ... # 0x10025

    class DiagnosticNotationOption(Shiboken.Enum):
        Compact                  : QCborValue.DiagnosticNotationOption = ... # 0x0
        LineWrapped              : QCborValue.DiagnosticNotationOption = ... # 0x1
        ExtendedFormat           : QCborValue.DiagnosticNotationOption = ... # 0x2

    class DiagnosticNotationOptions(object): ...

    class EncodingOption(Shiboken.Enum):
        NoTransformation         : QCborValue.EncodingOption = ... # 0x0
        SortKeysInMaps           : QCborValue.EncodingOption = ... # 0x1
        UseFloat                 : QCborValue.EncodingOption = ... # 0x2
        UseFloat16               : QCborValue.EncodingOption = ... # 0x6
        UseIntegers              : QCborValue.EncodingOption = ... # 0x8

    class EncodingOptions(object): ...

    class Type(Shiboken.Enum):
        Invalid                  : QCborValue.Type = ... # -0x1
        Integer                  : QCborValue.Type = ... # 0x0
        ByteArray                : QCborValue.Type = ... # 0x40
        String                   : QCborValue.Type = ... # 0x60
        Array                    : QCborValue.Type = ... # 0x80
        Map                      : QCborValue.Type = ... # 0xa0
        Tag                      : QCborValue.Type = ... # 0xc0
        SimpleType               : QCborValue.Type = ... # 0x100
        False_                   : QCborValue.Type = ... # 0x114
        True_                    : QCborValue.Type = ... # 0x115
        Null                     : QCborValue.Type = ... # 0x116
        Undefined                : QCborValue.Type = ... # 0x117
        Double                   : QCborValue.Type = ... # 0x202
        DateTime                 : QCborValue.Type = ... # 0x10000
        Url                      : QCborValue.Type = ... # 0x10020
        RegularExpression        : QCborValue.Type = ... # 0x10023
        Uuid                     : QCborValue.Type = ... # 0x10025

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a: PySide2.QtCore.QCborArray) -> None: ...
    @typing.overload
    def __init__(self, b_: bool) -> None: ...
    @typing.overload
    def __init__(self, ba: PySide2.QtCore.QByteArray) -> None: ...
    @typing.overload
    def __init__(self, dt: PySide2.QtCore.QDateTime) -> None: ...
    @typing.overload
    def __init__(self, i: int) -> None: ...
    @typing.overload
    def __init__(self, i: int) -> None: ...
    @typing.overload
    def __init__(self, m: PySide2.QtCore.QCborMap) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QCborValue) -> None: ...
    @typing.overload
    def __init__(self, rx: PySide2.QtCore.QRegularExpression) -> None: ...
    @typing.overload
    def __init__(self, s: str) -> None: ...
    @typing.overload
    def __init__(self, s: bytes) -> None: ...
    @typing.overload
    def __init__(self, st: PySide2.QtCore.QCborSimpleType) -> None: ...
    @typing.overload
    def __init__(self, t_: PySide2.QtCore.QCborKnownTags, tv: PySide2.QtCore.QCborValue = ...) -> None: ...
    @typing.overload
    def __init__(self, t_: PySide2.QtCore.QCborValue.Type) -> None: ...
    @typing.overload
    def __init__(self, u: int) -> None: ...
    @typing.overload
    def __init__(self, url: PySide2.QtCore.QUrl) -> None: ...
    @typing.overload
    def __init__(self, uuid: PySide2.QtCore.QUuid) -> None: ...
    @typing.overload
    def __init__(self, v: float) -> None: ...


class QChildEvent(PySide2.QtCore.QEvent):

    def __init__(self, type: PySide2.QtCore.QEvent.Type, child: PySide2.QtCore.QObject) -> None: ...


class QCollator(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QCollator) -> None: ...
    @typing.overload
    def __init__(self, locale: PySide2.QtCore.QLocale) -> None: ...


class QCollatorSortKey(Shiboken.Object):

    def __init__(self, other: PySide2.QtCore.QCollatorSortKey) -> None: ...


class QCommandLineOption(Shiboken.Object):
    HiddenFromHelp           : QCommandLineOption.Flag = ... # 0x1
    ShortOptionStyle         : QCommandLineOption.Flag = ... # 0x2

    class Flag(Shiboken.Enum):
        HiddenFromHelp           : QCommandLineOption.Flag = ... # 0x1
        ShortOptionStyle         : QCommandLineOption.Flag = ... # 0x2

    class Flags(object): ...

    @typing.overload
    def __init__(self, name: str) -> None: ...
    @typing.overload
    def __init__(self, name: str, description: str, valueName: str = ..., defaultValue: str = ...) -> None: ...
    @typing.overload
    def __init__(self, names: typing.Sequence[str]) -> None: ...
    @typing.overload
    def __init__(self, names: typing.Sequence[str], description: str, valueName: str = ..., defaultValue: str = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QCommandLineOption) -> None: ...


class QCommandLineParser(Shiboken.Object):
    ParseAsOptions           : QCommandLineParser.OptionsAfterPositionalArgumentsMode = ... # 0x0
    ParseAsPositionalArguments: QCommandLineParser.OptionsAfterPositionalArgumentsMode = ... # 0x1
    ParseAsCompactedShortOptions: QCommandLineParser.SingleDashWordOptionMode = ... # 0x0
    ParseAsLongOptions       : QCommandLineParser.SingleDashWordOptionMode = ... # 0x1

    class OptionsAfterPositionalArgumentsMode(Shiboken.Enum):
        ParseAsOptions           : QCommandLineParser.OptionsAfterPositionalArgumentsMode = ... # 0x0
        ParseAsPositionalArguments: QCommandLineParser.OptionsAfterPositionalArgumentsMode = ... # 0x1

    class SingleDashWordOptionMode(Shiboken.Enum):
        ParseAsCompactedShortOptions: QCommandLineParser.SingleDashWordOptionMode = ... # 0x0
        ParseAsLongOptions       : QCommandLineParser.SingleDashWordOptionMode = ... # 0x1

    def __init__(self) -> None: ...


class QConcatenateTablesProxyModel(PySide2.QtCore.QAbstractItemModel):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QCoreApplication(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: typing.Sequence[str]) -> None: ...


class QCryptographicHash(Shiboken.Object):
    Md4                      : QCryptographicHash.Algorithm = ... # 0x0
    Md5                      : QCryptographicHash.Algorithm = ... # 0x1
    Sha1                     : QCryptographicHash.Algorithm = ... # 0x2
    Sha224                   : QCryptographicHash.Algorithm = ... # 0x3
    Sha256                   : QCryptographicHash.Algorithm = ... # 0x4
    Sha384                   : QCryptographicHash.Algorithm = ... # 0x5
    Sha512                   : QCryptographicHash.Algorithm = ... # 0x6
    Keccak_224               : QCryptographicHash.Algorithm = ... # 0x7
    Keccak_256               : QCryptographicHash.Algorithm = ... # 0x8
    Keccak_384               : QCryptographicHash.Algorithm = ... # 0x9
    Keccak_512               : QCryptographicHash.Algorithm = ... # 0xa
    RealSha3_224             : QCryptographicHash.Algorithm = ... # 0xb
    Sha3_224                 : QCryptographicHash.Algorithm = ... # 0xb
    RealSha3_256             : QCryptographicHash.Algorithm = ... # 0xc
    Sha3_256                 : QCryptographicHash.Algorithm = ... # 0xc
    RealSha3_384             : QCryptographicHash.Algorithm = ... # 0xd
    Sha3_384                 : QCryptographicHash.Algorithm = ... # 0xd
    RealSha3_512             : QCryptographicHash.Algorithm = ... # 0xe
    Sha3_512                 : QCryptographicHash.Algorithm = ... # 0xe

    class Algorithm(Shiboken.Enum):
        Md4                      : QCryptographicHash.Algorithm = ... # 0x0
        Md5                      : QCryptographicHash.Algorithm = ... # 0x1
        Sha1                     : QCryptographicHash.Algorithm = ... # 0x2
        Sha224                   : QCryptographicHash.Algorithm = ... # 0x3
        Sha256                   : QCryptographicHash.Algorithm = ... # 0x4
        Sha384                   : QCryptographicHash.Algorithm = ... # 0x5
        Sha512                   : QCryptographicHash.Algorithm = ... # 0x6
        Keccak_224               : QCryptographicHash.Algorithm = ... # 0x7
        Keccak_256               : QCryptographicHash.Algorithm = ... # 0x8
        Keccak_384               : QCryptographicHash.Algorithm = ... # 0x9
        Keccak_512               : QCryptographicHash.Algorithm = ... # 0xa
        RealSha3_224             : QCryptographicHash.Algorithm = ... # 0xb
        Sha3_224                 : QCryptographicHash.Algorithm = ... # 0xb
        RealSha3_256             : QCryptographicHash.Algorithm = ... # 0xc
        Sha3_256                 : QCryptographicHash.Algorithm = ... # 0xc
        RealSha3_384             : QCryptographicHash.Algorithm = ... # 0xd
        Sha3_384                 : QCryptographicHash.Algorithm = ... # 0xd
        RealSha3_512             : QCryptographicHash.Algorithm = ... # 0xe
        Sha3_512                 : QCryptographicHash.Algorithm = ... # 0xe

    def __init__(self, method: PySide2.QtCore.QCryptographicHash.Algorithm) -> None: ...


class QDataStream(Shiboken.Object):
    BigEndian                : QDataStream.ByteOrder = ... # 0x0
    LittleEndian             : QDataStream.ByteOrder = ... # 0x1
    SinglePrecision          : QDataStream.FloatingPointPrecision = ... # 0x0
    DoublePrecision          : QDataStream.FloatingPointPrecision = ... # 0x1
    Ok                       : QDataStream.Status = ... # 0x0
    ReadPastEnd              : QDataStream.Status = ... # 0x1
    ReadCorruptData          : QDataStream.Status = ... # 0x2
    WriteFailed              : QDataStream.Status = ... # 0x3
    Qt_1_0                   : QDataStream.Version = ... # 0x1
    Qt_2_0                   : QDataStream.Version = ... # 0x2
    Qt_2_1                   : QDataStream.Version = ... # 0x3
    Qt_3_0                   : QDataStream.Version = ... # 0x4
    Qt_3_1                   : QDataStream.Version = ... # 0x5
    Qt_3_3                   : QDataStream.Version = ... # 0x6
    Qt_4_0                   : QDataStream.Version = ... # 0x7
    Qt_4_1                   : QDataStream.Version = ... # 0x7
    Qt_4_2                   : QDataStream.Version = ... # 0x8
    Qt_4_3                   : QDataStream.Version = ... # 0x9
    Qt_4_4                   : QDataStream.Version = ... # 0xa
    Qt_4_5                   : QDataStream.Version = ... # 0xb
    Qt_4_6                   : QDataStream.Version = ... # 0xc
    Qt_4_7                   : QDataStream.Version = ... # 0xc
    Qt_4_8                   : QDataStream.Version = ... # 0xc
    Qt_4_9                   : QDataStream.Version = ... # 0xc
    Qt_5_0                   : QDataStream.Version = ... # 0xd
    Qt_5_1                   : QDataStream.Version = ... # 0xe
    Qt_5_2                   : QDataStream.Version = ... # 0xf
    Qt_5_3                   : QDataStream.Version = ... # 0xf
    Qt_5_4                   : QDataStream.Version = ... # 0x10
    Qt_5_5                   : QDataStream.Version = ... # 0x10
    Qt_5_10                  : QDataStream.Version = ... # 0x11
    Qt_5_11                  : QDataStream.Version = ... # 0x11
    Qt_5_6                   : QDataStream.Version = ... # 0x11
    Qt_5_7                   : QDataStream.Version = ... # 0x11
    Qt_5_8                   : QDataStream.Version = ... # 0x11
    Qt_5_9                   : QDataStream.Version = ... # 0x11
    Qt_5_12                  : QDataStream.Version = ... # 0x12
    Qt_5_13                  : QDataStream.Version = ... # 0x13
    Qt_5_14                  : QDataStream.Version = ... # 0x13
    Qt_5_15                  : QDataStream.Version = ... # 0x13
    Qt_DefaultCompiledVersion: QDataStream.Version = ... # 0x13

    class ByteOrder(Shiboken.Enum):
        BigEndian                : QDataStream.ByteOrder = ... # 0x0
        LittleEndian             : QDataStream.ByteOrder = ... # 0x1

    class FloatingPointPrecision(Shiboken.Enum):
        SinglePrecision          : QDataStream.FloatingPointPrecision = ... # 0x0
        DoublePrecision          : QDataStream.FloatingPointPrecision = ... # 0x1

    class Status(Shiboken.Enum):
        Ok                       : QDataStream.Status = ... # 0x0
        ReadPastEnd              : QDataStream.Status = ... # 0x1
        ReadCorruptData          : QDataStream.Status = ... # 0x2
        WriteFailed              : QDataStream.Status = ... # 0x3

    class Version(Shiboken.Enum):
        Qt_1_0                   : QDataStream.Version = ... # 0x1
        Qt_2_0                   : QDataStream.Version = ... # 0x2
        Qt_2_1                   : QDataStream.Version = ... # 0x3
        Qt_3_0                   : QDataStream.Version = ... # 0x4
        Qt_3_1                   : QDataStream.Version = ... # 0x5
        Qt_3_3                   : QDataStream.Version = ... # 0x6
        Qt_4_0                   : QDataStream.Version = ... # 0x7
        Qt_4_1                   : QDataStream.Version = ... # 0x7
        Qt_4_2                   : QDataStream.Version = ... # 0x8
        Qt_4_3                   : QDataStream.Version = ... # 0x9
        Qt_4_4                   : QDataStream.Version = ... # 0xa
        Qt_4_5                   : QDataStream.Version = ... # 0xb
        Qt_4_6                   : QDataStream.Version = ... # 0xc
        Qt_4_7                   : QDataStream.Version = ... # 0xc
        Qt_4_8                   : QDataStream.Version = ... # 0xc
        Qt_4_9                   : QDataStream.Version = ... # 0xc
        Qt_5_0                   : QDataStream.Version = ... # 0xd
        Qt_5_1                   : QDataStream.Version = ... # 0xe
        Qt_5_2                   : QDataStream.Version = ... # 0xf
        Qt_5_3                   : QDataStream.Version = ... # 0xf
        Qt_5_4                   : QDataStream.Version = ... # 0x10
        Qt_5_5                   : QDataStream.Version = ... # 0x10
        Qt_5_10                  : QDataStream.Version = ... # 0x11
        Qt_5_11                  : QDataStream.Version = ... # 0x11
        Qt_5_6                   : QDataStream.Version = ... # 0x11
        Qt_5_7                   : QDataStream.Version = ... # 0x11
        Qt_5_8                   : QDataStream.Version = ... # 0x11
        Qt_5_9                   : QDataStream.Version = ... # 0x11
        Qt_5_12                  : QDataStream.Version = ... # 0x12
        Qt_5_13                  : QDataStream.Version = ... # 0x13
        Qt_5_14                  : QDataStream.Version = ... # 0x13
        Qt_5_15                  : QDataStream.Version = ... # 0x13
        Qt_DefaultCompiledVersion: QDataStream.Version = ... # 0x13

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QByteArray) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QByteArray, flags: PySide2.QtCore.QIODevice.OpenMode) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QIODevice) -> None: ...


class QDate(Shiboken.Object):
    DateFormat               : QDate.MonthNameType = ... # 0x0
    StandaloneFormat         : QDate.MonthNameType = ... # 0x1

    class MonthNameType(Shiboken.Enum):
        DateFormat               : QDate.MonthNameType = ... # 0x0
        StandaloneFormat         : QDate.MonthNameType = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QDate: PySide2.QtCore.QDate) -> None: ...
    @typing.overload
    def __init__(self, y: int, m: int, d: int) -> None: ...
    @typing.overload
    def __init__(self, y: int, m: int, d: int, cal: PySide2.QtCore.QCalendar) -> None: ...


class QDateTime(Shiboken.Object):

    class YearRange(Shiboken.Enum):
        First                    : QDateTime.YearRange = ... # -0x116bc370
        Last                     : QDateTime.YearRange = ... # 0x116bd2d2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QDate) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QDate, arg__2: PySide2.QtCore.QTime, spec: PySide2.QtCore.Qt.TimeSpec = ...) -> None: ...
    @typing.overload
    def __init__(self, arg__1: int, arg__2: int, arg__3: int, arg__4: int, arg__5: int, arg__6: int) -> None: ...
    @typing.overload
    def __init__(self, arg__1: int, arg__2: int, arg__3: int, arg__4: int, arg__5: int, arg__6: int, arg__7: int, arg__8: int = ...) -> None: ...
    @typing.overload
    def __init__(self, date: PySide2.QtCore.QDate, time: PySide2.QtCore.QTime, spec: PySide2.QtCore.Qt.TimeSpec, offsetSeconds: int) -> None: ...
    @typing.overload
    def __init__(self, date: PySide2.QtCore.QDate, time: PySide2.QtCore.QTime, timeZone: PySide2.QtCore.QTimeZone) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QDateTime) -> None: ...


class QDeadlineTimer(Shiboken.Object):
    Forever                  : QDeadlineTimer.ForeverConstant = ... # 0x0

    class ForeverConstant(Shiboken.Enum):
        Forever                  : QDeadlineTimer.ForeverConstant = ... # 0x0

    @typing.overload
    def __init__(self, QDeadlineTimer: PySide2.QtCore.QDeadlineTimer) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QDeadlineTimer.ForeverConstant, type_: PySide2.QtCore.Qt.TimerType = ...) -> None: ...
    @typing.overload
    def __init__(self, msecs: int, type: PySide2.QtCore.Qt.TimerType = ...) -> None: ...
    @typing.overload
    def __init__(self, type_: PySide2.QtCore.Qt.TimerType = ...) -> None: ...


class QDir(Shiboken.Object):
    NoFilter                 : QDir.Filter = ... # -0x1
    Dirs                     : QDir.Filter = ... # 0x1
    Files                    : QDir.Filter = ... # 0x2
    Drives                   : QDir.Filter = ... # 0x4
    AllEntries               : QDir.Filter = ... # 0x7
    NoSymLinks               : QDir.Filter = ... # 0x8
    TypeMask                 : QDir.Filter = ... # 0xf
    Readable                 : QDir.Filter = ... # 0x10
    Writable                 : QDir.Filter = ... # 0x20
    Executable               : QDir.Filter = ... # 0x40
    PermissionMask           : QDir.Filter = ... # 0x70
    Modified                 : QDir.Filter = ... # 0x80
    Hidden                   : QDir.Filter = ... # 0x100
    System                   : QDir.Filter = ... # 0x200
    AccessMask               : QDir.Filter = ... # 0x3f0
    AllDirs                  : QDir.Filter = ... # 0x400
    CaseSensitive            : QDir.Filter = ... # 0x800
    NoDot                    : QDir.Filter = ... # 0x2000
    NoDotDot                 : QDir.Filter = ... # 0x4000
    NoDotAndDotDot           : QDir.Filter = ... # 0x6000
    NoSort                   : QDir.SortFlag = ... # -0x1
    Name                     : QDir.SortFlag = ... # 0x0
    Time                     : QDir.SortFlag = ... # 0x1
    Size                     : QDir.SortFlag = ... # 0x2
    SortByMask               : QDir.SortFlag = ... # 0x3
    Unsorted                 : QDir.SortFlag = ... # 0x3
    DirsFirst                : QDir.SortFlag = ... # 0x4
    Reversed                 : QDir.SortFlag = ... # 0x8
    IgnoreCase               : QDir.SortFlag = ... # 0x10
    DirsLast                 : QDir.SortFlag = ... # 0x20
    LocaleAware              : QDir.SortFlag = ... # 0x40
    Type                     : QDir.SortFlag = ... # 0x80

    class Filter(Shiboken.Enum):
        NoFilter                 : QDir.Filter = ... # -0x1
        Dirs                     : QDir.Filter = ... # 0x1
        Files                    : QDir.Filter = ... # 0x2
        Drives                   : QDir.Filter = ... # 0x4
        AllEntries               : QDir.Filter = ... # 0x7
        NoSymLinks               : QDir.Filter = ... # 0x8
        TypeMask                 : QDir.Filter = ... # 0xf
        Readable                 : QDir.Filter = ... # 0x10
        Writable                 : QDir.Filter = ... # 0x20
        Executable               : QDir.Filter = ... # 0x40
        PermissionMask           : QDir.Filter = ... # 0x70
        Modified                 : QDir.Filter = ... # 0x80
        Hidden                   : QDir.Filter = ... # 0x100
        System                   : QDir.Filter = ... # 0x200
        AccessMask               : QDir.Filter = ... # 0x3f0
        AllDirs                  : QDir.Filter = ... # 0x400
        CaseSensitive            : QDir.Filter = ... # 0x800
        NoDot                    : QDir.Filter = ... # 0x2000
        NoDotDot                 : QDir.Filter = ... # 0x4000
        NoDotAndDotDot           : QDir.Filter = ... # 0x6000

    class Filters(object): ...

    class SortFlag(Shiboken.Enum):
        NoSort                   : QDir.SortFlag = ... # -0x1
        Name                     : QDir.SortFlag = ... # 0x0
        Time                     : QDir.SortFlag = ... # 0x1
        Size                     : QDir.SortFlag = ... # 0x2
        SortByMask               : QDir.SortFlag = ... # 0x3
        Unsorted                 : QDir.SortFlag = ... # 0x3
        DirsFirst                : QDir.SortFlag = ... # 0x4
        Reversed                 : QDir.SortFlag = ... # 0x8
        IgnoreCase               : QDir.SortFlag = ... # 0x10
        DirsLast                 : QDir.SortFlag = ... # 0x20
        LocaleAware              : QDir.SortFlag = ... # 0x40
        Type                     : QDir.SortFlag = ... # 0x80

    class SortFlags(object): ...

    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QDir) -> None: ...
    @typing.overload
    def __init__(self, path: str, nameFilter: str, sort: PySide2.QtCore.QDir.SortFlags = ..., filter: PySide2.QtCore.QDir.Filters = ...) -> None: ...
    @typing.overload
    def __init__(self, path: str = ...) -> None: ...


class QDirIterator(Shiboken.Object):
    NoIteratorFlags          : QDirIterator.IteratorFlag = ... # 0x0
    FollowSymlinks           : QDirIterator.IteratorFlag = ... # 0x1
    Subdirectories           : QDirIterator.IteratorFlag = ... # 0x2

    class IteratorFlag(Shiboken.Enum):
        NoIteratorFlags          : QDirIterator.IteratorFlag = ... # 0x0
        FollowSymlinks           : QDirIterator.IteratorFlag = ... # 0x1
        Subdirectories           : QDirIterator.IteratorFlag = ... # 0x2

    class IteratorFlags(object): ...

    @typing.overload
    def __init__(self, dir: PySide2.QtCore.QDir, flags: PySide2.QtCore.QDirIterator.IteratorFlags = ...) -> None: ...
    @typing.overload
    def __init__(self, path: str, filter: PySide2.QtCore.QDir.Filters, flags: PySide2.QtCore.QDirIterator.IteratorFlags = ...) -> None: ...
    @typing.overload
    def __init__(self, path: str, flags: PySide2.QtCore.QDirIterator.IteratorFlags = ...) -> None: ...
    @typing.overload
    def __init__(self, path: str, nameFilters: typing.Sequence[str], filters: PySide2.QtCore.QDir.Filters = ..., flags: PySide2.QtCore.QDirIterator.IteratorFlags = ...) -> None: ...


class QDynamicPropertyChangeEvent(PySide2.QtCore.QEvent):

    def __init__(self, name: PySide2.QtCore.QByteArray) -> None: ...


class QEasingCurve(Shiboken.Object):
    Linear                   : QEasingCurve.Type = ... # 0x0
    InQuad                   : QEasingCurve.Type = ... # 0x1
    OutQuad                  : QEasingCurve.Type = ... # 0x2
    InOutQuad                : QEasingCurve.Type = ... # 0x3
    OutInQuad                : QEasingCurve.Type = ... # 0x4
    InCubic                  : QEasingCurve.Type = ... # 0x5
    OutCubic                 : QEasingCurve.Type = ... # 0x6
    InOutCubic               : QEasingCurve.Type = ... # 0x7
    OutInCubic               : QEasingCurve.Type = ... # 0x8
    InQuart                  : QEasingCurve.Type = ... # 0x9
    OutQuart                 : QEasingCurve.Type = ... # 0xa
    InOutQuart               : QEasingCurve.Type = ... # 0xb
    OutInQuart               : QEasingCurve.Type = ... # 0xc
    InQuint                  : QEasingCurve.Type = ... # 0xd
    OutQuint                 : QEasingCurve.Type = ... # 0xe
    InOutQuint               : QEasingCurve.Type = ... # 0xf
    OutInQuint               : QEasingCurve.Type = ... # 0x10
    InSine                   : QEasingCurve.Type = ... # 0x11
    OutSine                  : QEasingCurve.Type = ... # 0x12
    InOutSine                : QEasingCurve.Type = ... # 0x13
    OutInSine                : QEasingCurve.Type = ... # 0x14
    InExpo                   : QEasingCurve.Type = ... # 0x15
    OutExpo                  : QEasingCurve.Type = ... # 0x16
    InOutExpo                : QEasingCurve.Type = ... # 0x17
    OutInExpo                : QEasingCurve.Type = ... # 0x18
    InCirc                   : QEasingCurve.Type = ... # 0x19
    OutCirc                  : QEasingCurve.Type = ... # 0x1a
    InOutCirc                : QEasingCurve.Type = ... # 0x1b
    OutInCirc                : QEasingCurve.Type = ... # 0x1c
    InElastic                : QEasingCurve.Type = ... # 0x1d
    OutElastic               : QEasingCurve.Type = ... # 0x1e
    InOutElastic             : QEasingCurve.Type = ... # 0x1f
    OutInElastic             : QEasingCurve.Type = ... # 0x20
    InBack                   : QEasingCurve.Type = ... # 0x21
    OutBack                  : QEasingCurve.Type = ... # 0x22
    InOutBack                : QEasingCurve.Type = ... # 0x23
    OutInBack                : QEasingCurve.Type = ... # 0x24
    InBounce                 : QEasingCurve.Type = ... # 0x25
    OutBounce                : QEasingCurve.Type = ... # 0x26
    InOutBounce              : QEasingCurve.Type = ... # 0x27
    OutInBounce              : QEasingCurve.Type = ... # 0x28
    InCurve                  : QEasingCurve.Type = ... # 0x29
    OutCurve                 : QEasingCurve.Type = ... # 0x2a
    SineCurve                : QEasingCurve.Type = ... # 0x2b
    CosineCurve              : QEasingCurve.Type = ... # 0x2c
    BezierSpline             : QEasingCurve.Type = ... # 0x2d
    TCBSpline                : QEasingCurve.Type = ... # 0x2e
    Custom                   : QEasingCurve.Type = ... # 0x2f
    NCurveTypes              : QEasingCurve.Type = ... # 0x30

    class Type(Shiboken.Enum):
        Linear                   : QEasingCurve.Type = ... # 0x0
        InQuad                   : QEasingCurve.Type = ... # 0x1
        OutQuad                  : QEasingCurve.Type = ... # 0x2
        InOutQuad                : QEasingCurve.Type = ... # 0x3
        OutInQuad                : QEasingCurve.Type = ... # 0x4
        InCubic                  : QEasingCurve.Type = ... # 0x5
        OutCubic                 : QEasingCurve.Type = ... # 0x6
        InOutCubic               : QEasingCurve.Type = ... # 0x7
        OutInCubic               : QEasingCurve.Type = ... # 0x8
        InQuart                  : QEasingCurve.Type = ... # 0x9
        OutQuart                 : QEasingCurve.Type = ... # 0xa
        InOutQuart               : QEasingCurve.Type = ... # 0xb
        OutInQuart               : QEasingCurve.Type = ... # 0xc
        InQuint                  : QEasingCurve.Type = ... # 0xd
        OutQuint                 : QEasingCurve.Type = ... # 0xe
        InOutQuint               : QEasingCurve.Type = ... # 0xf
        OutInQuint               : QEasingCurve.Type = ... # 0x10
        InSine                   : QEasingCurve.Type = ... # 0x11
        OutSine                  : QEasingCurve.Type = ... # 0x12
        InOutSine                : QEasingCurve.Type = ... # 0x13
        OutInSine                : QEasingCurve.Type = ... # 0x14
        InExpo                   : QEasingCurve.Type = ... # 0x15
        OutExpo                  : QEasingCurve.Type = ... # 0x16
        InOutExpo                : QEasingCurve.Type = ... # 0x17
        OutInExpo                : QEasingCurve.Type = ... # 0x18
        InCirc                   : QEasingCurve.Type = ... # 0x19
        OutCirc                  : QEasingCurve.Type = ... # 0x1a
        InOutCirc                : QEasingCurve.Type = ... # 0x1b
        OutInCirc                : QEasingCurve.Type = ... # 0x1c
        InElastic                : QEasingCurve.Type = ... # 0x1d
        OutElastic               : QEasingCurve.Type = ... # 0x1e
        InOutElastic             : QEasingCurve.Type = ... # 0x1f
        OutInElastic             : QEasingCurve.Type = ... # 0x20
        InBack                   : QEasingCurve.Type = ... # 0x21
        OutBack                  : QEasingCurve.Type = ... # 0x22
        InOutBack                : QEasingCurve.Type = ... # 0x23
        OutInBack                : QEasingCurve.Type = ... # 0x24
        InBounce                 : QEasingCurve.Type = ... # 0x25
        OutBounce                : QEasingCurve.Type = ... # 0x26
        InOutBounce              : QEasingCurve.Type = ... # 0x27
        OutInBounce              : QEasingCurve.Type = ... # 0x28
        InCurve                  : QEasingCurve.Type = ... # 0x29
        OutCurve                 : QEasingCurve.Type = ... # 0x2a
        SineCurve                : QEasingCurve.Type = ... # 0x2b
        CosineCurve              : QEasingCurve.Type = ... # 0x2c
        BezierSpline             : QEasingCurve.Type = ... # 0x2d
        TCBSpline                : QEasingCurve.Type = ... # 0x2e
        Custom                   : QEasingCurve.Type = ... # 0x2f
        NCurveTypes              : QEasingCurve.Type = ... # 0x30

    @typing.overload
    def __init__(self, other: PySide2.QtCore.QEasingCurve) -> None: ...
    @typing.overload
    def __init__(self, type: PySide2.QtCore.QEasingCurve.Type = ...) -> None: ...


class QElapsedTimer(Shiboken.Object):
    SystemTime               : QElapsedTimer.ClockType = ... # 0x0
    MonotonicClock           : QElapsedTimer.ClockType = ... # 0x1
    TickCounter              : QElapsedTimer.ClockType = ... # 0x2
    MachAbsoluteTime         : QElapsedTimer.ClockType = ... # 0x3
    PerformanceCounter       : QElapsedTimer.ClockType = ... # 0x4

    class ClockType(Shiboken.Enum):
        SystemTime               : QElapsedTimer.ClockType = ... # 0x0
        MonotonicClock           : QElapsedTimer.ClockType = ... # 0x1
        TickCounter              : QElapsedTimer.ClockType = ... # 0x2
        MachAbsoluteTime         : QElapsedTimer.ClockType = ... # 0x3
        PerformanceCounter       : QElapsedTimer.ClockType = ... # 0x4

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QElapsedTimer: PySide2.QtCore.QElapsedTimer) -> None: ...


class QEvent(Shiboken.Object):
    None_                    : QEvent.Type = ... # 0x0
    Timer                    : QEvent.Type = ... # 0x1
    MouseButtonPress         : QEvent.Type = ... # 0x2
    MouseButtonRelease       : QEvent.Type = ... # 0x3
    MouseButtonDblClick      : QEvent.Type = ... # 0x4
    MouseMove                : QEvent.Type = ... # 0x5
    KeyPress                 : QEvent.Type = ... # 0x6
    KeyRelease               : QEvent.Type = ... # 0x7
    FocusIn                  : QEvent.Type = ... # 0x8
    FocusOut                 : QEvent.Type = ... # 0x9
    Enter                    : QEvent.Type = ... # 0xa
    Leave                    : QEvent.Type = ... # 0xb
    Paint                    : QEvent.Type = ... # 0xc
    Move                     : QEvent.Type = ... # 0xd
    Resize                   : QEvent.Type = ... # 0xe
    Create                   : QEvent.Type = ... # 0xf
    Destroy                  : QEvent.Type = ... # 0x10
    Show                     : QEvent.Type = ... # 0x11
    Hide                     : QEvent.Type = ... # 0x12
    Close                    : QEvent.Type = ... # 0x13
    Quit                     : QEvent.Type = ... # 0x14
    ParentChange             : QEvent.Type = ... # 0x15
    ThreadChange             : QEvent.Type = ... # 0x16
    FocusAboutToChange       : QEvent.Type = ... # 0x17
    WindowActivate           : QEvent.Type = ... # 0x18
    WindowDeactivate         : QEvent.Type = ... # 0x19
    ShowToParent             : QEvent.Type = ... # 0x1a
    HideToParent             : QEvent.Type = ... # 0x1b
    Wheel                    : QEvent.Type = ... # 0x1f
    WindowTitleChange        : QEvent.Type = ... # 0x21
    WindowIconChange         : QEvent.Type = ... # 0x22
    ApplicationWindowIconChange: QEvent.Type = ... # 0x23
    ApplicationFontChange    : QEvent.Type = ... # 0x24
    ApplicationLayoutDirectionChange: QEvent.Type = ... # 0x25
    ApplicationPaletteChange : QEvent.Type = ... # 0x26
    PaletteChange            : QEvent.Type = ... # 0x27
    Clipboard                : QEvent.Type = ... # 0x28
    Speech                   : QEvent.Type = ... # 0x2a
    MetaCall                 : QEvent.Type = ... # 0x2b
    SockAct                  : QEvent.Type = ... # 0x32
    ShortcutOverride         : QEvent.Type = ... # 0x33
    DeferredDelete           : QEvent.Type = ... # 0x34
    DragEnter                : QEvent.Type = ... # 0x3c
    DragMove                 : QEvent.Type = ... # 0x3d
    DragLeave                : QEvent.Type = ... # 0x3e
    Drop                     : QEvent.Type = ... # 0x3f
    DragResponse             : QEvent.Type = ... # 0x40
    ChildAdded               : QEvent.Type = ... # 0x44
    ChildPolished            : QEvent.Type = ... # 0x45
    ChildRemoved             : QEvent.Type = ... # 0x47
    ShowWindowRequest        : QEvent.Type = ... # 0x49
    PolishRequest            : QEvent.Type = ... # 0x4a
    Polish                   : QEvent.Type = ... # 0x4b
    LayoutRequest            : QEvent.Type = ... # 0x4c
    UpdateRequest            : QEvent.Type = ... # 0x4d
    UpdateLater              : QEvent.Type = ... # 0x4e
    EmbeddingControl         : QEvent.Type = ... # 0x4f
    ActivateControl          : QEvent.Type = ... # 0x50
    DeactivateControl        : QEvent.Type = ... # 0x51
    ContextMenu              : QEvent.Type = ... # 0x52
    InputMethod              : QEvent.Type = ... # 0x53
    TabletMove               : QEvent.Type = ... # 0x57
    LocaleChange             : QEvent.Type = ... # 0x58
    LanguageChange           : QEvent.Type = ... # 0x59
    LayoutDirectionChange    : QEvent.Type = ... # 0x5a
    Style                    : QEvent.Type = ... # 0x5b
    TabletPress              : QEvent.Type = ... # 0x5c
    TabletRelease            : QEvent.Type = ... # 0x5d
    OkRequest                : QEvent.Type = ... # 0x5e
    HelpRequest              : QEvent.Type = ... # 0x5f
    IconDrag                 : QEvent.Type = ... # 0x60
    FontChange               : QEvent.Type = ... # 0x61
    EnabledChange            : QEvent.Type = ... # 0x62
    ActivationChange         : QEvent.Type = ... # 0x63
    StyleChange              : QEvent.Type = ... # 0x64
    IconTextChange           : QEvent.Type = ... # 0x65
    ModifiedChange           : QEvent.Type = ... # 0x66
    WindowBlocked            : QEvent.Type = ... # 0x67
    WindowUnblocked          : QEvent.Type = ... # 0x68
    WindowStateChange        : QEvent.Type = ... # 0x69
    ReadOnlyChange           : QEvent.Type = ... # 0x6a
    MouseTrackingChange      : QEvent.Type = ... # 0x6d
    ToolTip                  : QEvent.Type = ... # 0x6e
    WhatsThis                : QEvent.Type = ... # 0x6f
    StatusTip                : QEvent.Type = ... # 0x70
    ActionChanged            : QEvent.Type = ... # 0x71
    ActionAdded              : QEvent.Type = ... # 0x72
    ActionRemoved            : QEvent.Type = ... # 0x73
    FileOpen                 : QEvent.Type = ... # 0x74
    Shortcut                 : QEvent.Type = ... # 0x75
    WhatsThisClicked         : QEvent.Type = ... # 0x76
    ToolBarChange            : QEvent.Type = ... # 0x78
    ApplicationActivate      : QEvent.Type = ... # 0x79
    ApplicationActivated     : QEvent.Type = ... # 0x79
    ApplicationDeactivate    : QEvent.Type = ... # 0x7a
    ApplicationDeactivated   : QEvent.Type = ... # 0x7a
    QueryWhatsThis           : QEvent.Type = ... # 0x7b
    EnterWhatsThisMode       : QEvent.Type = ... # 0x7c
    LeaveWhatsThisMode       : QEvent.Type = ... # 0x7d
    ZOrderChange             : QEvent.Type = ... # 0x7e
    HoverEnter               : QEvent.Type = ... # 0x7f
    HoverLeave               : QEvent.Type = ... # 0x80
    HoverMove                : QEvent.Type = ... # 0x81
    ParentAboutToChange      : QEvent.Type = ... # 0x83
    WinEventAct              : QEvent.Type = ... # 0x84
    AcceptDropsChange        : QEvent.Type = ... # 0x98
    ZeroTimerEvent           : QEvent.Type = ... # 0x9a
    GraphicsSceneMouseMove   : QEvent.Type = ... # 0x9b
    GraphicsSceneMousePress  : QEvent.Type = ... # 0x9c
    GraphicsSceneMouseRelease: QEvent.Type = ... # 0x9d
    GraphicsSceneMouseDoubleClick: QEvent.Type = ... # 0x9e
    GraphicsSceneContextMenu : QEvent.Type = ... # 0x9f
    GraphicsSceneHoverEnter  : QEvent.Type = ... # 0xa0
    GraphicsSceneHoverMove   : QEvent.Type = ... # 0xa1
    GraphicsSceneHoverLeave  : QEvent.Type = ... # 0xa2
    GraphicsSceneHelp        : QEvent.Type = ... # 0xa3
    GraphicsSceneDragEnter   : QEvent.Type = ... # 0xa4
    GraphicsSceneDragMove    : QEvent.Type = ... # 0xa5
    GraphicsSceneDragLeave   : QEvent.Type = ... # 0xa6
    GraphicsSceneDrop        : QEvent.Type = ... # 0xa7
    GraphicsSceneWheel       : QEvent.Type = ... # 0xa8
    KeyboardLayoutChange     : QEvent.Type = ... # 0xa9
    DynamicPropertyChange    : QEvent.Type = ... # 0xaa
    TabletEnterProximity     : QEvent.Type = ... # 0xab
    TabletLeaveProximity     : QEvent.Type = ... # 0xac
    NonClientAreaMouseMove   : QEvent.Type = ... # 0xad
    NonClientAreaMouseButtonPress: QEvent.Type = ... # 0xae
    NonClientAreaMouseButtonRelease: QEvent.Type = ... # 0xaf
    NonClientAreaMouseButtonDblClick: QEvent.Type = ... # 0xb0
    MacSizeChange            : QEvent.Type = ... # 0xb1
    ContentsRectChange       : QEvent.Type = ... # 0xb2
    MacGLWindowChange        : QEvent.Type = ... # 0xb3
    FutureCallOut            : QEvent.Type = ... # 0xb4
    GraphicsSceneResize      : QEvent.Type = ... # 0xb5
    GraphicsSceneMove        : QEvent.Type = ... # 0xb6
    CursorChange             : QEvent.Type = ... # 0xb7
    ToolTipChange            : QEvent.Type = ... # 0xb8
    NetworkReplyUpdated      : QEvent.Type = ... # 0xb9
    GrabMouse                : QEvent.Type = ... # 0xba
    UngrabMouse              : QEvent.Type = ... # 0xbb
    GrabKeyboard             : QEvent.Type = ... # 0xbc
    UngrabKeyboard           : QEvent.Type = ... # 0xbd
    MacGLClearDrawable       : QEvent.Type = ... # 0xbf
    StateMachineSignal       : QEvent.Type = ... # 0xc0
    StateMachineWrapped      : QEvent.Type = ... # 0xc1
    TouchBegin               : QEvent.Type = ... # 0xc2
    TouchUpdate              : QEvent.Type = ... # 0xc3
    TouchEnd                 : QEvent.Type = ... # 0xc4
    NativeGesture            : QEvent.Type = ... # 0xc5
    Gesture                  : QEvent.Type = ... # 0xc6
    RequestSoftwareInputPanel: QEvent.Type = ... # 0xc7
    CloseSoftwareInputPanel  : QEvent.Type = ... # 0xc8
    GestureOverride          : QEvent.Type = ... # 0xca
    WinIdChange              : QEvent.Type = ... # 0xcb
    ScrollPrepare            : QEvent.Type = ... # 0xcc
    Scroll                   : QEvent.Type = ... # 0xcd
    Expose                   : QEvent.Type = ... # 0xce
    InputMethodQuery         : QEvent.Type = ... # 0xcf
    OrientationChange        : QEvent.Type = ... # 0xd0
    TouchCancel              : QEvent.Type = ... # 0xd1
    ThemeChange              : QEvent.Type = ... # 0xd2
    SockClose                : QEvent.Type = ... # 0xd3
    PlatformPanel            : QEvent.Type = ... # 0xd4
    StyleAnimationUpdate     : QEvent.Type = ... # 0xd5
    ApplicationStateChange   : QEvent.Type = ... # 0xd6
    WindowChangeInternal     : QEvent.Type = ... # 0xd7
    ScreenChangeInternal     : QEvent.Type = ... # 0xd8
    PlatformSurface          : QEvent.Type = ... # 0xd9
    Pointer                  : QEvent.Type = ... # 0xda
    TabletTrackingChange     : QEvent.Type = ... # 0xdb
    User                     : QEvent.Type = ... # 0x3e8
    MaxUser                  : QEvent.Type = ... # 0xffff

    class Type(Shiboken.Enum):
        None_                    : QEvent.Type = ... # 0x0
        Timer                    : QEvent.Type = ... # 0x1
        MouseButtonPress         : QEvent.Type = ... # 0x2
        MouseButtonRelease       : QEvent.Type = ... # 0x3
        MouseButtonDblClick      : QEvent.Type = ... # 0x4
        MouseMove                : QEvent.Type = ... # 0x5
        KeyPress                 : QEvent.Type = ... # 0x6
        KeyRelease               : QEvent.Type = ... # 0x7
        FocusIn                  : QEvent.Type = ... # 0x8
        FocusOut                 : QEvent.Type = ... # 0x9
        Enter                    : QEvent.Type = ... # 0xa
        Leave                    : QEvent.Type = ... # 0xb
        Paint                    : QEvent.Type = ... # 0xc
        Move                     : QEvent.Type = ... # 0xd
        Resize                   : QEvent.Type = ... # 0xe
        Create                   : QEvent.Type = ... # 0xf
        Destroy                  : QEvent.Type = ... # 0x10
        Show                     : QEvent.Type = ... # 0x11
        Hide                     : QEvent.Type = ... # 0x12
        Close                    : QEvent.Type = ... # 0x13
        Quit                     : QEvent.Type = ... # 0x14
        ParentChange             : QEvent.Type = ... # 0x15
        ThreadChange             : QEvent.Type = ... # 0x16
        FocusAboutToChange       : QEvent.Type = ... # 0x17
        WindowActivate           : QEvent.Type = ... # 0x18
        WindowDeactivate         : QEvent.Type = ... # 0x19
        ShowToParent             : QEvent.Type = ... # 0x1a
        HideToParent             : QEvent.Type = ... # 0x1b
        Wheel                    : QEvent.Type = ... # 0x1f
        WindowTitleChange        : QEvent.Type = ... # 0x21
        WindowIconChange         : QEvent.Type = ... # 0x22
        ApplicationWindowIconChange: QEvent.Type = ... # 0x23
        ApplicationFontChange    : QEvent.Type = ... # 0x24
        ApplicationLayoutDirectionChange: QEvent.Type = ... # 0x25
        ApplicationPaletteChange : QEvent.Type = ... # 0x26
        PaletteChange            : QEvent.Type = ... # 0x27
        Clipboard                : QEvent.Type = ... # 0x28
        Speech                   : QEvent.Type = ... # 0x2a
        MetaCall                 : QEvent.Type = ... # 0x2b
        SockAct                  : QEvent.Type = ... # 0x32
        ShortcutOverride         : QEvent.Type = ... # 0x33
        DeferredDelete           : QEvent.Type = ... # 0x34
        DragEnter                : QEvent.Type = ... # 0x3c
        DragMove                 : QEvent.Type = ... # 0x3d
        DragLeave                : QEvent.Type = ... # 0x3e
        Drop                     : QEvent.Type = ... # 0x3f
        DragResponse             : QEvent.Type = ... # 0x40
        ChildAdded               : QEvent.Type = ... # 0x44
        ChildPolished            : QEvent.Type = ... # 0x45
        ChildRemoved             : QEvent.Type = ... # 0x47
        ShowWindowRequest        : QEvent.Type = ... # 0x49
        PolishRequest            : QEvent.Type = ... # 0x4a
        Polish                   : QEvent.Type = ... # 0x4b
        LayoutRequest            : QEvent.Type = ... # 0x4c
        UpdateRequest            : QEvent.Type = ... # 0x4d
        UpdateLater              : QEvent.Type = ... # 0x4e
        EmbeddingControl         : QEvent.Type = ... # 0x4f
        ActivateControl          : QEvent.Type = ... # 0x50
        DeactivateControl        : QEvent.Type = ... # 0x51
        ContextMenu              : QEvent.Type = ... # 0x52
        InputMethod              : QEvent.Type = ... # 0x53
        TabletMove               : QEvent.Type = ... # 0x57
        LocaleChange             : QEvent.Type = ... # 0x58
        LanguageChange           : QEvent.Type = ... # 0x59
        LayoutDirectionChange    : QEvent.Type = ... # 0x5a
        Style                    : QEvent.Type = ... # 0x5b
        TabletPress              : QEvent.Type = ... # 0x5c
        TabletRelease            : QEvent.Type = ... # 0x5d
        OkRequest                : QEvent.Type = ... # 0x5e
        HelpRequest              : QEvent.Type = ... # 0x5f
        IconDrag                 : QEvent.Type = ... # 0x60
        FontChange               : QEvent.Type = ... # 0x61
        EnabledChange            : QEvent.Type = ... # 0x62
        ActivationChange         : QEvent.Type = ... # 0x63
        StyleChange              : QEvent.Type = ... # 0x64
        IconTextChange           : QEvent.Type = ... # 0x65
        ModifiedChange           : QEvent.Type = ... # 0x66
        WindowBlocked            : QEvent.Type = ... # 0x67
        WindowUnblocked          : QEvent.Type = ... # 0x68
        WindowStateChange        : QEvent.Type = ... # 0x69
        ReadOnlyChange           : QEvent.Type = ... # 0x6a
        MouseTrackingChange      : QEvent.Type = ... # 0x6d
        ToolTip                  : QEvent.Type = ... # 0x6e
        WhatsThis                : QEvent.Type = ... # 0x6f
        StatusTip                : QEvent.Type = ... # 0x70
        ActionChanged            : QEvent.Type = ... # 0x71
        ActionAdded              : QEvent.Type = ... # 0x72
        ActionRemoved            : QEvent.Type = ... # 0x73
        FileOpen                 : QEvent.Type = ... # 0x74
        Shortcut                 : QEvent.Type = ... # 0x75
        WhatsThisClicked         : QEvent.Type = ... # 0x76
        ToolBarChange            : QEvent.Type = ... # 0x78
        ApplicationActivate      : QEvent.Type = ... # 0x79
        ApplicationActivated     : QEvent.Type = ... # 0x79
        ApplicationDeactivate    : QEvent.Type = ... # 0x7a
        ApplicationDeactivated   : QEvent.Type = ... # 0x7a
        QueryWhatsThis           : QEvent.Type = ... # 0x7b
        EnterWhatsThisMode       : QEvent.Type = ... # 0x7c
        LeaveWhatsThisMode       : QEvent.Type = ... # 0x7d
        ZOrderChange             : QEvent.Type = ... # 0x7e
        HoverEnter               : QEvent.Type = ... # 0x7f
        HoverLeave               : QEvent.Type = ... # 0x80
        HoverMove                : QEvent.Type = ... # 0x81
        ParentAboutToChange      : QEvent.Type = ... # 0x83
        WinEventAct              : QEvent.Type = ... # 0x84
        AcceptDropsChange        : QEvent.Type = ... # 0x98
        ZeroTimerEvent           : QEvent.Type = ... # 0x9a
        GraphicsSceneMouseMove   : QEvent.Type = ... # 0x9b
        GraphicsSceneMousePress  : QEvent.Type = ... # 0x9c
        GraphicsSceneMouseRelease: QEvent.Type = ... # 0x9d
        GraphicsSceneMouseDoubleClick: QEvent.Type = ... # 0x9e
        GraphicsSceneContextMenu : QEvent.Type = ... # 0x9f
        GraphicsSceneHoverEnter  : QEvent.Type = ... # 0xa0
        GraphicsSceneHoverMove   : QEvent.Type = ... # 0xa1
        GraphicsSceneHoverLeave  : QEvent.Type = ... # 0xa2
        GraphicsSceneHelp        : QEvent.Type = ... # 0xa3
        GraphicsSceneDragEnter   : QEvent.Type = ... # 0xa4
        GraphicsSceneDragMove    : QEvent.Type = ... # 0xa5
        GraphicsSceneDragLeave   : QEvent.Type = ... # 0xa6
        GraphicsSceneDrop        : QEvent.Type = ... # 0xa7
        GraphicsSceneWheel       : QEvent.Type = ... # 0xa8
        KeyboardLayoutChange     : QEvent.Type = ... # 0xa9
        DynamicPropertyChange    : QEvent.Type = ... # 0xaa
        TabletEnterProximity     : QEvent.Type = ... # 0xab
        TabletLeaveProximity     : QEvent.Type = ... # 0xac
        NonClientAreaMouseMove   : QEvent.Type = ... # 0xad
        NonClientAreaMouseButtonPress: QEvent.Type = ... # 0xae
        NonClientAreaMouseButtonRelease: QEvent.Type = ... # 0xaf
        NonClientAreaMouseButtonDblClick: QEvent.Type = ... # 0xb0
        MacSizeChange            : QEvent.Type = ... # 0xb1
        ContentsRectChange       : QEvent.Type = ... # 0xb2
        MacGLWindowChange        : QEvent.Type = ... # 0xb3
        FutureCallOut            : QEvent.Type = ... # 0xb4
        GraphicsSceneResize      : QEvent.Type = ... # 0xb5
        GraphicsSceneMove        : QEvent.Type = ... # 0xb6
        CursorChange             : QEvent.Type = ... # 0xb7
        ToolTipChange            : QEvent.Type = ... # 0xb8
        NetworkReplyUpdated      : QEvent.Type = ... # 0xb9
        GrabMouse                : QEvent.Type = ... # 0xba
        UngrabMouse              : QEvent.Type = ... # 0xbb
        GrabKeyboard             : QEvent.Type = ... # 0xbc
        UngrabKeyboard           : QEvent.Type = ... # 0xbd
        MacGLClearDrawable       : QEvent.Type = ... # 0xbf
        StateMachineSignal       : QEvent.Type = ... # 0xc0
        StateMachineWrapped      : QEvent.Type = ... # 0xc1
        TouchBegin               : QEvent.Type = ... # 0xc2
        TouchUpdate              : QEvent.Type = ... # 0xc3
        TouchEnd                 : QEvent.Type = ... # 0xc4
        NativeGesture            : QEvent.Type = ... # 0xc5
        Gesture                  : QEvent.Type = ... # 0xc6
        RequestSoftwareInputPanel: QEvent.Type = ... # 0xc7
        CloseSoftwareInputPanel  : QEvent.Type = ... # 0xc8
        GestureOverride          : QEvent.Type = ... # 0xca
        WinIdChange              : QEvent.Type = ... # 0xcb
        ScrollPrepare            : QEvent.Type = ... # 0xcc
        Scroll                   : QEvent.Type = ... # 0xcd
        Expose                   : QEvent.Type = ... # 0xce
        InputMethodQuery         : QEvent.Type = ... # 0xcf
        OrientationChange        : QEvent.Type = ... # 0xd0
        TouchCancel              : QEvent.Type = ... # 0xd1
        ThemeChange              : QEvent.Type = ... # 0xd2
        SockClose                : QEvent.Type = ... # 0xd3
        PlatformPanel            : QEvent.Type = ... # 0xd4
        StyleAnimationUpdate     : QEvent.Type = ... # 0xd5
        ApplicationStateChange   : QEvent.Type = ... # 0xd6
        WindowChangeInternal     : QEvent.Type = ... # 0xd7
        ScreenChangeInternal     : QEvent.Type = ... # 0xd8
        PlatformSurface          : QEvent.Type = ... # 0xd9
        Pointer                  : QEvent.Type = ... # 0xda
        TabletTrackingChange     : QEvent.Type = ... # 0xdb
        User                     : QEvent.Type = ... # 0x3e8
        MaxUser                  : QEvent.Type = ... # 0xffff

    @typing.overload
    def __init__(self, other: PySide2.QtCore.QEvent) -> None: ...
    @typing.overload
    def __init__(self, type: PySide2.QtCore.QEvent.Type) -> None: ...


class QEventLoop(PySide2.QtCore.QObject):
    AllEvents                : QEventLoop.ProcessEventsFlag = ... # 0x0
    ExcludeUserInputEvents   : QEventLoop.ProcessEventsFlag = ... # 0x1
    ExcludeSocketNotifiers   : QEventLoop.ProcessEventsFlag = ... # 0x2
    WaitForMoreEvents        : QEventLoop.ProcessEventsFlag = ... # 0x4
    X11ExcludeTimers         : QEventLoop.ProcessEventsFlag = ... # 0x8
    EventLoopExec            : QEventLoop.ProcessEventsFlag = ... # 0x20
    DialogExec               : QEventLoop.ProcessEventsFlag = ... # 0x40

    class ProcessEventsFlag(Shiboken.Enum):
        AllEvents                : QEventLoop.ProcessEventsFlag = ... # 0x0
        ExcludeUserInputEvents   : QEventLoop.ProcessEventsFlag = ... # 0x1
        ExcludeSocketNotifiers   : QEventLoop.ProcessEventsFlag = ... # 0x2
        WaitForMoreEvents        : QEventLoop.ProcessEventsFlag = ... # 0x4
        X11ExcludeTimers         : QEventLoop.ProcessEventsFlag = ... # 0x8
        EventLoopExec            : QEventLoop.ProcessEventsFlag = ... # 0x20
        DialogExec               : QEventLoop.ProcessEventsFlag = ... # 0x40

    class ProcessEventsFlags(object): ...

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QEventTransition(PySide2.QtCore.QAbstractTransition):

    @typing.overload
    def __init__(self, object: PySide2.QtCore.QObject, type: PySide2.QtCore.QEvent.Type, sourceState: typing.Optional[PySide2.QtCore.QState] = ...) -> None: ...
    @typing.overload
    def __init__(self, sourceState: typing.Optional[PySide2.QtCore.QState] = ...) -> None: ...


class QFactoryInterface(Shiboken.Object):

    def __init__(self) -> None: ...


class QFile(PySide2.QtCore.QFileDevice):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, name: str) -> None: ...
    @typing.overload
    def __init__(self, name: str, parent: PySide2.QtCore.QObject) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject) -> None: ...


class QFileDevice(PySide2.QtCore.QIODevice):
    NoError                  : QFileDevice.FileError = ... # 0x0
    ReadError                : QFileDevice.FileError = ... # 0x1
    WriteError               : QFileDevice.FileError = ... # 0x2
    FatalError               : QFileDevice.FileError = ... # 0x3
    ResourceError            : QFileDevice.FileError = ... # 0x4
    OpenError                : QFileDevice.FileError = ... # 0x5
    AbortError               : QFileDevice.FileError = ... # 0x6
    TimeOutError             : QFileDevice.FileError = ... # 0x7
    UnspecifiedError         : QFileDevice.FileError = ... # 0x8
    RemoveError              : QFileDevice.FileError = ... # 0x9
    RenameError              : QFileDevice.FileError = ... # 0xa
    PositionError            : QFileDevice.FileError = ... # 0xb
    ResizeError              : QFileDevice.FileError = ... # 0xc
    PermissionsError         : QFileDevice.FileError = ... # 0xd
    CopyError                : QFileDevice.FileError = ... # 0xe
    DontCloseHandle          : QFileDevice.FileHandleFlag = ... # 0x0
    AutoCloseHandle          : QFileDevice.FileHandleFlag = ... # 0x1
    FileAccessTime           : QFileDevice.FileTime = ... # 0x0
    FileBirthTime            : QFileDevice.FileTime = ... # 0x1
    FileMetadataChangeTime   : QFileDevice.FileTime = ... # 0x2
    FileModificationTime     : QFileDevice.FileTime = ... # 0x3
    NoOptions                : QFileDevice.MemoryMapFlags = ... # 0x0
    MapPrivateOption         : QFileDevice.MemoryMapFlags = ... # 0x1
    ExeOther                 : QFileDevice.Permission = ... # 0x1
    WriteOther               : QFileDevice.Permission = ... # 0x2
    ReadOther                : QFileDevice.Permission = ... # 0x4
    ExeGroup                 : QFileDevice.Permission = ... # 0x10
    WriteGroup               : QFileDevice.Permission = ... # 0x20
    ReadGroup                : QFileDevice.Permission = ... # 0x40
    ExeUser                  : QFileDevice.Permission = ... # 0x100
    WriteUser                : QFileDevice.Permission = ... # 0x200
    ReadUser                 : QFileDevice.Permission = ... # 0x400
    ExeOwner                 : QFileDevice.Permission = ... # 0x1000
    WriteOwner               : QFileDevice.Permission = ... # 0x2000
    ReadOwner                : QFileDevice.Permission = ... # 0x4000

    class FileError(Shiboken.Enum):
        NoError                  : QFileDevice.FileError = ... # 0x0
        ReadError                : QFileDevice.FileError = ... # 0x1
        WriteError               : QFileDevice.FileError = ... # 0x2
        FatalError               : QFileDevice.FileError = ... # 0x3
        ResourceError            : QFileDevice.FileError = ... # 0x4
        OpenError                : QFileDevice.FileError = ... # 0x5
        AbortError               : QFileDevice.FileError = ... # 0x6
        TimeOutError             : QFileDevice.FileError = ... # 0x7
        UnspecifiedError         : QFileDevice.FileError = ... # 0x8
        RemoveError              : QFileDevice.FileError = ... # 0x9
        RenameError              : QFileDevice.FileError = ... # 0xa
        PositionError            : QFileDevice.FileError = ... # 0xb
        ResizeError              : QFileDevice.FileError = ... # 0xc
        PermissionsError         : QFileDevice.FileError = ... # 0xd
        CopyError                : QFileDevice.FileError = ... # 0xe

    class FileHandleFlag(Shiboken.Enum):
        DontCloseHandle          : QFileDevice.FileHandleFlag = ... # 0x0
        AutoCloseHandle          : QFileDevice.FileHandleFlag = ... # 0x1

    class FileHandleFlags(object): ...

    class FileTime(Shiboken.Enum):
        FileAccessTime           : QFileDevice.FileTime = ... # 0x0
        FileBirthTime            : QFileDevice.FileTime = ... # 0x1
        FileMetadataChangeTime   : QFileDevice.FileTime = ... # 0x2
        FileModificationTime     : QFileDevice.FileTime = ... # 0x3

    class MemoryMapFlags(Shiboken.Enum):
        NoOptions                : QFileDevice.MemoryMapFlags = ... # 0x0
        MapPrivateOption         : QFileDevice.MemoryMapFlags = ... # 0x1

    class Permission(Shiboken.Enum):
        ExeOther                 : QFileDevice.Permission = ... # 0x1
        WriteOther               : QFileDevice.Permission = ... # 0x2
        ReadOther                : QFileDevice.Permission = ... # 0x4
        ExeGroup                 : QFileDevice.Permission = ... # 0x10
        WriteGroup               : QFileDevice.Permission = ... # 0x20
        ReadGroup                : QFileDevice.Permission = ... # 0x40
        ExeUser                  : QFileDevice.Permission = ... # 0x100
        WriteUser                : QFileDevice.Permission = ... # 0x200
        ReadUser                 : QFileDevice.Permission = ... # 0x400
        ExeOwner                 : QFileDevice.Permission = ... # 0x1000
        WriteOwner               : QFileDevice.Permission = ... # 0x2000
        ReadOwner                : QFileDevice.Permission = ... # 0x4000

    class Permissions(object): ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject) -> None: ...


class QFileInfo(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, dir: PySide2.QtCore.QDir, file: str) -> None: ...
    @typing.overload
    def __init__(self, file: PySide2.QtCore.QFile) -> None: ...
    @typing.overload
    def __init__(self, file: str) -> None: ...
    @typing.overload
    def __init__(self, fileinfo: PySide2.QtCore.QFileInfo) -> None: ...


class QFileSelector(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QFileSystemWatcher(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, paths: typing.Sequence[str], parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QFinalState(PySide2.QtCore.QAbstractState):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QState] = ...) -> None: ...


class QFutureInterfaceBase(Shiboken.Object):
    NoState                  : QFutureInterfaceBase.State = ... # 0x0
    Running                  : QFutureInterfaceBase.State = ... # 0x1
    Started                  : QFutureInterfaceBase.State = ... # 0x2
    Finished                 : QFutureInterfaceBase.State = ... # 0x4
    Canceled                 : QFutureInterfaceBase.State = ... # 0x8
    Paused                   : QFutureInterfaceBase.State = ... # 0x10
    Throttled                : QFutureInterfaceBase.State = ... # 0x20

    class State(Shiboken.Enum):
        NoState                  : QFutureInterfaceBase.State = ... # 0x0
        Running                  : QFutureInterfaceBase.State = ... # 0x1
        Started                  : QFutureInterfaceBase.State = ... # 0x2
        Finished                 : QFutureInterfaceBase.State = ... # 0x4
        Canceled                 : QFutureInterfaceBase.State = ... # 0x8
        Paused                   : QFutureInterfaceBase.State = ... # 0x10
        Throttled                : QFutureInterfaceBase.State = ... # 0x20

    @typing.overload
    def __init__(self, initialState: PySide2.QtCore.QFutureInterfaceBase.State = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QFutureInterfaceBase) -> None: ...


class QGenericArgument(Shiboken.Object):

    @typing.overload
    def __init__(self, QGenericArgument: PySide2.QtCore.QGenericArgument) -> None: ...
    @typing.overload
    def __init__(self, aName: typing.Optional[bytes] = ..., aData: typing.Optional[int] = ...) -> None: ...


class QGenericReturnArgument(PySide2.QtCore.QGenericArgument):

    @typing.overload
    def __init__(self, QGenericReturnArgument: PySide2.QtCore.QGenericReturnArgument) -> None: ...
    @typing.overload
    def __init__(self, aName: typing.Optional[bytes] = ..., aData: typing.Optional[int] = ...) -> None: ...


class QHistoryState(PySide2.QtCore.QAbstractState):
    ShallowHistory           : QHistoryState.HistoryType = ... # 0x0
    DeepHistory              : QHistoryState.HistoryType = ... # 0x1

    class HistoryType(Shiboken.Enum):
        ShallowHistory           : QHistoryState.HistoryType = ... # 0x0
        DeepHistory              : QHistoryState.HistoryType = ... # 0x1

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QState] = ...) -> None: ...
    @typing.overload
    def __init__(self, type: PySide2.QtCore.QHistoryState.HistoryType, parent: typing.Optional[PySide2.QtCore.QState] = ...) -> None: ...


class QIODevice(PySide2.QtCore.QObject):
    NotOpen                  : QIODevice.OpenModeFlag = ... # 0x0
    ReadOnly                 : QIODevice.OpenModeFlag = ... # 0x1
    WriteOnly                : QIODevice.OpenModeFlag = ... # 0x2
    ReadWrite                : QIODevice.OpenModeFlag = ... # 0x3
    Append                   : QIODevice.OpenModeFlag = ... # 0x4
    Truncate                 : QIODevice.OpenModeFlag = ... # 0x8
    Text                     : QIODevice.OpenModeFlag = ... # 0x10
    Unbuffered               : QIODevice.OpenModeFlag = ... # 0x20
    NewOnly                  : QIODevice.OpenModeFlag = ... # 0x40
    ExistingOnly             : QIODevice.OpenModeFlag = ... # 0x80

    class OpenMode(object): ...

    class OpenModeFlag(Shiboken.Enum):
        NotOpen                  : QIODevice.OpenModeFlag = ... # 0x0
        ReadOnly                 : QIODevice.OpenModeFlag = ... # 0x1
        WriteOnly                : QIODevice.OpenModeFlag = ... # 0x2
        ReadWrite                : QIODevice.OpenModeFlag = ... # 0x3
        Append                   : QIODevice.OpenModeFlag = ... # 0x4
        Truncate                 : QIODevice.OpenModeFlag = ... # 0x8
        Text                     : QIODevice.OpenModeFlag = ... # 0x10
        Unbuffered               : QIODevice.OpenModeFlag = ... # 0x20
        NewOnly                  : QIODevice.OpenModeFlag = ... # 0x40
        ExistingOnly             : QIODevice.OpenModeFlag = ... # 0x80

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject) -> None: ...


class QIdentityProxyModel(PySide2.QtCore.QAbstractProxyModel):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QItemSelection(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QItemSelection: PySide2.QtCore.QItemSelection) -> None: ...
    @typing.overload
    def __init__(self, topLeft: PySide2.QtCore.QModelIndex, bottomRight: PySide2.QtCore.QModelIndex) -> None: ...


class QItemSelectionModel(PySide2.QtCore.QObject):
    NoUpdate                 : QItemSelectionModel.SelectionFlag = ... # 0x0
    Clear                    : QItemSelectionModel.SelectionFlag = ... # 0x1
    Select                   : QItemSelectionModel.SelectionFlag = ... # 0x2
    ClearAndSelect           : QItemSelectionModel.SelectionFlag = ... # 0x3
    Deselect                 : QItemSelectionModel.SelectionFlag = ... # 0x4
    Toggle                   : QItemSelectionModel.SelectionFlag = ... # 0x8
    Current                  : QItemSelectionModel.SelectionFlag = ... # 0x10
    SelectCurrent            : QItemSelectionModel.SelectionFlag = ... # 0x12
    ToggleCurrent            : QItemSelectionModel.SelectionFlag = ... # 0x18
    Rows                     : QItemSelectionModel.SelectionFlag = ... # 0x20
    Columns                  : QItemSelectionModel.SelectionFlag = ... # 0x40

    class SelectionFlag(Shiboken.Enum):
        NoUpdate                 : QItemSelectionModel.SelectionFlag = ... # 0x0
        Clear                    : QItemSelectionModel.SelectionFlag = ... # 0x1
        Select                   : QItemSelectionModel.SelectionFlag = ... # 0x2
        ClearAndSelect           : QItemSelectionModel.SelectionFlag = ... # 0x3
        Deselect                 : QItemSelectionModel.SelectionFlag = ... # 0x4
        Toggle                   : QItemSelectionModel.SelectionFlag = ... # 0x8
        Current                  : QItemSelectionModel.SelectionFlag = ... # 0x10
        SelectCurrent            : QItemSelectionModel.SelectionFlag = ... # 0x12
        ToggleCurrent            : QItemSelectionModel.SelectionFlag = ... # 0x18
        Rows                     : QItemSelectionModel.SelectionFlag = ... # 0x20
        Columns                  : QItemSelectionModel.SelectionFlag = ... # 0x40

    class SelectionFlags(object): ...

    @typing.overload
    def __init__(self, model: PySide2.QtCore.QAbstractItemModel, parent: PySide2.QtCore.QObject) -> None: ...
    @typing.overload
    def __init__(self, model: typing.Optional[PySide2.QtCore.QAbstractItemModel] = ...) -> None: ...


class QItemSelectionRange(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QItemSelectionRange) -> None: ...
    @typing.overload
    def __init__(self, topL: PySide2.QtCore.QModelIndex, bottomR: PySide2.QtCore.QModelIndex) -> None: ...


class QJsonArray(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QJsonArray) -> None: ...


class QJsonDocument(Shiboken.Object):
    Validate                 : QJsonDocument.DataValidation = ... # 0x0
    BypassValidation         : QJsonDocument.DataValidation = ... # 0x1
    Indented                 : QJsonDocument.JsonFormat = ... # 0x0
    Compact                  : QJsonDocument.JsonFormat = ... # 0x1

    class DataValidation(Shiboken.Enum):
        Validate                 : QJsonDocument.DataValidation = ... # 0x0
        BypassValidation         : QJsonDocument.DataValidation = ... # 0x1

    class JsonFormat(Shiboken.Enum):
        Indented                 : QJsonDocument.JsonFormat = ... # 0x0
        Compact                  : QJsonDocument.JsonFormat = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, array: PySide2.QtCore.QJsonArray) -> None: ...
    @typing.overload
    def __init__(self, object: typing.Dict[str, PySide2.QtCore.QJsonValue]) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QJsonDocument) -> None: ...


class QJsonParseError(Shiboken.Object):
    NoError                  : QJsonParseError.ParseError = ... # 0x0
    UnterminatedObject       : QJsonParseError.ParseError = ... # 0x1
    MissingNameSeparator     : QJsonParseError.ParseError = ... # 0x2
    UnterminatedArray        : QJsonParseError.ParseError = ... # 0x3
    MissingValueSeparator    : QJsonParseError.ParseError = ... # 0x4
    IllegalValue             : QJsonParseError.ParseError = ... # 0x5
    TerminationByNumber      : QJsonParseError.ParseError = ... # 0x6
    IllegalNumber            : QJsonParseError.ParseError = ... # 0x7
    IllegalEscapeSequence    : QJsonParseError.ParseError = ... # 0x8
    IllegalUTF8String        : QJsonParseError.ParseError = ... # 0x9
    UnterminatedString       : QJsonParseError.ParseError = ... # 0xa
    MissingObject            : QJsonParseError.ParseError = ... # 0xb
    DeepNesting              : QJsonParseError.ParseError = ... # 0xc
    DocumentTooLarge         : QJsonParseError.ParseError = ... # 0xd
    GarbageAtEnd             : QJsonParseError.ParseError = ... # 0xe

    class ParseError(Shiboken.Enum):
        NoError                  : QJsonParseError.ParseError = ... # 0x0
        UnterminatedObject       : QJsonParseError.ParseError = ... # 0x1
        MissingNameSeparator     : QJsonParseError.ParseError = ... # 0x2
        UnterminatedArray        : QJsonParseError.ParseError = ... # 0x3
        MissingValueSeparator    : QJsonParseError.ParseError = ... # 0x4
        IllegalValue             : QJsonParseError.ParseError = ... # 0x5
        TerminationByNumber      : QJsonParseError.ParseError = ... # 0x6
        IllegalNumber            : QJsonParseError.ParseError = ... # 0x7
        IllegalEscapeSequence    : QJsonParseError.ParseError = ... # 0x8
        IllegalUTF8String        : QJsonParseError.ParseError = ... # 0x9
        UnterminatedString       : QJsonParseError.ParseError = ... # 0xa
        MissingObject            : QJsonParseError.ParseError = ... # 0xb
        DeepNesting              : QJsonParseError.ParseError = ... # 0xc
        DocumentTooLarge         : QJsonParseError.ParseError = ... # 0xd
        GarbageAtEnd             : QJsonParseError.ParseError = ... # 0xe

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QJsonParseError: PySide2.QtCore.QJsonParseError) -> None: ...


class QJsonValue(Shiboken.Object):
    Null                     : QJsonValue.Type = ... # 0x0
    Bool                     : QJsonValue.Type = ... # 0x1
    Double                   : QJsonValue.Type = ... # 0x2
    String                   : QJsonValue.Type = ... # 0x3
    Array                    : QJsonValue.Type = ... # 0x4
    Object                   : QJsonValue.Type = ... # 0x5
    Undefined                : QJsonValue.Type = ... # 0x80

    class Type(Shiboken.Enum):
        Null                     : QJsonValue.Type = ... # 0x0
        Bool                     : QJsonValue.Type = ... # 0x1
        Double                   : QJsonValue.Type = ... # 0x2
        String                   : QJsonValue.Type = ... # 0x3
        Array                    : QJsonValue.Type = ... # 0x4
        Object                   : QJsonValue.Type = ... # 0x5
        Undefined                : QJsonValue.Type = ... # 0x80

    @typing.overload
    def __init__(self, a: PySide2.QtCore.QJsonArray) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QJsonValue.Type = ...) -> None: ...
    @typing.overload
    def __init__(self, b: bool) -> None: ...
    @typing.overload
    def __init__(self, n: float) -> None: ...
    @typing.overload
    def __init__(self, n: int) -> None: ...
    @typing.overload
    def __init__(self, o: typing.Dict[str, PySide2.QtCore.QJsonValue]) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QJsonValue) -> None: ...
    @typing.overload
    def __init__(self, s: str) -> None: ...
    @typing.overload
    def __init__(self, s: bytes) -> None: ...
    @typing.overload
    def __init__(self, v: int) -> None: ...


class QLibraryInfo(Shiboken.Object):
    PrefixPath               : QLibraryInfo.LibraryLocation = ... # 0x0
    DocumentationPath        : QLibraryInfo.LibraryLocation = ... # 0x1
    HeadersPath              : QLibraryInfo.LibraryLocation = ... # 0x2
    LibrariesPath            : QLibraryInfo.LibraryLocation = ... # 0x3
    LibraryExecutablesPath   : QLibraryInfo.LibraryLocation = ... # 0x4
    BinariesPath             : QLibraryInfo.LibraryLocation = ... # 0x5
    PluginsPath              : QLibraryInfo.LibraryLocation = ... # 0x6
    ImportsPath              : QLibraryInfo.LibraryLocation = ... # 0x7
    Qml2ImportsPath          : QLibraryInfo.LibraryLocation = ... # 0x8
    ArchDataPath             : QLibraryInfo.LibraryLocation = ... # 0x9
    DataPath                 : QLibraryInfo.LibraryLocation = ... # 0xa
    TranslationsPath         : QLibraryInfo.LibraryLocation = ... # 0xb
    ExamplesPath             : QLibraryInfo.LibraryLocation = ... # 0xc
    TestsPath                : QLibraryInfo.LibraryLocation = ... # 0xd
    SettingsPath             : QLibraryInfo.LibraryLocation = ... # 0x64

    class LibraryLocation(Shiboken.Enum):
        PrefixPath               : QLibraryInfo.LibraryLocation = ... # 0x0
        DocumentationPath        : QLibraryInfo.LibraryLocation = ... # 0x1
        HeadersPath              : QLibraryInfo.LibraryLocation = ... # 0x2
        LibrariesPath            : QLibraryInfo.LibraryLocation = ... # 0x3
        LibraryExecutablesPath   : QLibraryInfo.LibraryLocation = ... # 0x4
        BinariesPath             : QLibraryInfo.LibraryLocation = ... # 0x5
        PluginsPath              : QLibraryInfo.LibraryLocation = ... # 0x6
        ImportsPath              : QLibraryInfo.LibraryLocation = ... # 0x7
        Qml2ImportsPath          : QLibraryInfo.LibraryLocation = ... # 0x8
        ArchDataPath             : QLibraryInfo.LibraryLocation = ... # 0x9
        DataPath                 : QLibraryInfo.LibraryLocation = ... # 0xa
        TranslationsPath         : QLibraryInfo.LibraryLocation = ... # 0xb
        ExamplesPath             : QLibraryInfo.LibraryLocation = ... # 0xc
        TestsPath                : QLibraryInfo.LibraryLocation = ... # 0xd
        SettingsPath             : QLibraryInfo.LibraryLocation = ... # 0x64


class QLine(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QLine: PySide2.QtCore.QLine) -> None: ...
    @typing.overload
    def __init__(self, pt1: PySide2.QtCore.QPoint, pt2: PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, x1: int, y1: int, x2: int, y2: int) -> None: ...


class QLineF(Shiboken.Object):
    NoIntersection           : QLineF.IntersectType = ... # 0x0
    BoundedIntersection      : QLineF.IntersectType = ... # 0x1
    UnboundedIntersection    : QLineF.IntersectType = ... # 0x2

    class IntersectType(Shiboken.Enum):
        NoIntersection           : QLineF.IntersectType = ... # 0x0
        BoundedIntersection      : QLineF.IntersectType = ... # 0x1
        UnboundedIntersection    : QLineF.IntersectType = ... # 0x2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QLineF: PySide2.QtCore.QLineF) -> None: ...
    @typing.overload
    def __init__(self, line: PySide2.QtCore.QLine) -> None: ...
    @typing.overload
    def __init__(self, pt1: PySide2.QtCore.QPointF, pt2: PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def __init__(self, x1: float, y1: float, x2: float, y2: float) -> None: ...


class QLocale(Shiboken.Object):
    AnyCountry               : QLocale.Country = ... # 0x0
    Afghanistan              : QLocale.Country = ... # 0x1
    Albania                  : QLocale.Country = ... # 0x2
    Algeria                  : QLocale.Country = ... # 0x3
    AmericanSamoa            : QLocale.Country = ... # 0x4
    Andorra                  : QLocale.Country = ... # 0x5
    Angola                   : QLocale.Country = ... # 0x6
    Anguilla                 : QLocale.Country = ... # 0x7
    Antarctica               : QLocale.Country = ... # 0x8
    AntiguaAndBarbuda        : QLocale.Country = ... # 0x9
    Argentina                : QLocale.Country = ... # 0xa
    Armenia                  : QLocale.Country = ... # 0xb
    Aruba                    : QLocale.Country = ... # 0xc
    Australia                : QLocale.Country = ... # 0xd
    Austria                  : QLocale.Country = ... # 0xe
    Azerbaijan               : QLocale.Country = ... # 0xf
    Bahamas                  : QLocale.Country = ... # 0x10
    Bahrain                  : QLocale.Country = ... # 0x11
    Bangladesh               : QLocale.Country = ... # 0x12
    Barbados                 : QLocale.Country = ... # 0x13
    Belarus                  : QLocale.Country = ... # 0x14
    Belgium                  : QLocale.Country = ... # 0x15
    Belize                   : QLocale.Country = ... # 0x16
    Benin                    : QLocale.Country = ... # 0x17
    Bermuda                  : QLocale.Country = ... # 0x18
    Bhutan                   : QLocale.Country = ... # 0x19
    Bolivia                  : QLocale.Country = ... # 0x1a
    BosniaAndHerzegowina     : QLocale.Country = ... # 0x1b
    Botswana                 : QLocale.Country = ... # 0x1c
    BouvetIsland             : QLocale.Country = ... # 0x1d
    Brazil                   : QLocale.Country = ... # 0x1e
    BritishIndianOceanTerritory: QLocale.Country = ... # 0x1f
    Brunei                   : QLocale.Country = ... # 0x20
    Bulgaria                 : QLocale.Country = ... # 0x21
    BurkinaFaso              : QLocale.Country = ... # 0x22
    Burundi                  : QLocale.Country = ... # 0x23
    Cambodia                 : QLocale.Country = ... # 0x24
    Cameroon                 : QLocale.Country = ... # 0x25
    Canada                   : QLocale.Country = ... # 0x26
    CapeVerde                : QLocale.Country = ... # 0x27
    CaymanIslands            : QLocale.Country = ... # 0x28
    CentralAfricanRepublic   : QLocale.Country = ... # 0x29
    Chad                     : QLocale.Country = ... # 0x2a
    Chile                    : QLocale.Country = ... # 0x2b
    China                    : QLocale.Country = ... # 0x2c
    ChristmasIsland          : QLocale.Country = ... # 0x2d
    CocosIslands             : QLocale.Country = ... # 0x2e
    Colombia                 : QLocale.Country = ... # 0x2f
    Comoros                  : QLocale.Country = ... # 0x30
    CongoKinshasa            : QLocale.Country = ... # 0x31
    DemocraticRepublicOfCongo: QLocale.Country = ... # 0x31
    CongoBrazzaville         : QLocale.Country = ... # 0x32
    PeoplesRepublicOfCongo   : QLocale.Country = ... # 0x32
    CookIslands              : QLocale.Country = ... # 0x33
    CostaRica                : QLocale.Country = ... # 0x34
    IvoryCoast               : QLocale.Country = ... # 0x35
    Croatia                  : QLocale.Country = ... # 0x36
    Cuba                     : QLocale.Country = ... # 0x37
    Cyprus                   : QLocale.Country = ... # 0x38
    CzechRepublic            : QLocale.Country = ... # 0x39
    Denmark                  : QLocale.Country = ... # 0x3a
    Djibouti                 : QLocale.Country = ... # 0x3b
    Dominica                 : QLocale.Country = ... # 0x3c
    DominicanRepublic        : QLocale.Country = ... # 0x3d
    EastTimor                : QLocale.Country = ... # 0x3e
    Ecuador                  : QLocale.Country = ... # 0x3f
    Egypt                    : QLocale.Country = ... # 0x40
    ElSalvador               : QLocale.Country = ... # 0x41
    EquatorialGuinea         : QLocale.Country = ... # 0x42
    Eritrea                  : QLocale.Country = ... # 0x43
    Estonia                  : QLocale.Country = ... # 0x44
    Ethiopia                 : QLocale.Country = ... # 0x45
    FalklandIslands          : QLocale.Country = ... # 0x46
    FaroeIslands             : QLocale.Country = ... # 0x47
    Fiji                     : QLocale.Country = ... # 0x48
    Finland                  : QLocale.Country = ... # 0x49
    France                   : QLocale.Country = ... # 0x4a
    Guernsey                 : QLocale.Country = ... # 0x4b
    FrenchGuiana             : QLocale.Country = ... # 0x4c
    FrenchPolynesia          : QLocale.Country = ... # 0x4d
    FrenchSouthernTerritories: QLocale.Country = ... # 0x4e
    Gabon                    : QLocale.Country = ... # 0x4f
    Gambia                   : QLocale.Country = ... # 0x50
    Georgia                  : QLocale.Country = ... # 0x51
    Germany                  : QLocale.Country = ... # 0x52
    Ghana                    : QLocale.Country = ... # 0x53
    Gibraltar                : QLocale.Country = ... # 0x54
    Greece                   : QLocale.Country = ... # 0x55
    Greenland                : QLocale.Country = ... # 0x56
    Grenada                  : QLocale.Country = ... # 0x57
    Guadeloupe               : QLocale.Country = ... # 0x58
    Guam                     : QLocale.Country = ... # 0x59
    Guatemala                : QLocale.Country = ... # 0x5a
    Guinea                   : QLocale.Country = ... # 0x5b
    GuineaBissau             : QLocale.Country = ... # 0x5c
    Guyana                   : QLocale.Country = ... # 0x5d
    Haiti                    : QLocale.Country = ... # 0x5e
    HeardAndMcDonaldIslands  : QLocale.Country = ... # 0x5f
    Honduras                 : QLocale.Country = ... # 0x60
    HongKong                 : QLocale.Country = ... # 0x61
    Hungary                  : QLocale.Country = ... # 0x62
    Iceland                  : QLocale.Country = ... # 0x63
    India                    : QLocale.Country = ... # 0x64
    Indonesia                : QLocale.Country = ... # 0x65
    Iran                     : QLocale.Country = ... # 0x66
    Iraq                     : QLocale.Country = ... # 0x67
    Ireland                  : QLocale.Country = ... # 0x68
    Israel                   : QLocale.Country = ... # 0x69
    Italy                    : QLocale.Country = ... # 0x6a
    Jamaica                  : QLocale.Country = ... # 0x6b
    Japan                    : QLocale.Country = ... # 0x6c
    Jordan                   : QLocale.Country = ... # 0x6d
    Kazakhstan               : QLocale.Country = ... # 0x6e
    Kenya                    : QLocale.Country = ... # 0x6f
    Kiribati                 : QLocale.Country = ... # 0x70
    DemocraticRepublicOfKorea: QLocale.Country = ... # 0x71
    NorthKorea               : QLocale.Country = ... # 0x71
    RepublicOfKorea          : QLocale.Country = ... # 0x72
    SouthKorea               : QLocale.Country = ... # 0x72
    Kuwait                   : QLocale.Country = ... # 0x73
    Kyrgyzstan               : QLocale.Country = ... # 0x74
    Laos                     : QLocale.Country = ... # 0x75
    Latvia                   : QLocale.Country = ... # 0x76
    Lebanon                  : QLocale.Country = ... # 0x77
    Lesotho                  : QLocale.Country = ... # 0x78
    Liberia                  : QLocale.Country = ... # 0x79
    Libya                    : QLocale.Country = ... # 0x7a
    Liechtenstein            : QLocale.Country = ... # 0x7b
    Lithuania                : QLocale.Country = ... # 0x7c
    Luxembourg               : QLocale.Country = ... # 0x7d
    Macau                    : QLocale.Country = ... # 0x7e
    Macedonia                : QLocale.Country = ... # 0x7f
    Madagascar               : QLocale.Country = ... # 0x80
    Malawi                   : QLocale.Country = ... # 0x81
    Malaysia                 : QLocale.Country = ... # 0x82
    Maldives                 : QLocale.Country = ... # 0x83
    Mali                     : QLocale.Country = ... # 0x84
    Malta                    : QLocale.Country = ... # 0x85
    MarshallIslands          : QLocale.Country = ... # 0x86
    Martinique               : QLocale.Country = ... # 0x87
    Mauritania               : QLocale.Country = ... # 0x88
    Mauritius                : QLocale.Country = ... # 0x89
    Mayotte                  : QLocale.Country = ... # 0x8a
    Mexico                   : QLocale.Country = ... # 0x8b
    Micronesia               : QLocale.Country = ... # 0x8c
    Moldova                  : QLocale.Country = ... # 0x8d
    Monaco                   : QLocale.Country = ... # 0x8e
    Mongolia                 : QLocale.Country = ... # 0x8f
    Montserrat               : QLocale.Country = ... # 0x90
    Morocco                  : QLocale.Country = ... # 0x91
    Mozambique               : QLocale.Country = ... # 0x92
    Myanmar                  : QLocale.Country = ... # 0x93
    Namibia                  : QLocale.Country = ... # 0x94
    NauruCountry             : QLocale.Country = ... # 0x95
    Nepal                    : QLocale.Country = ... # 0x96
    Netherlands              : QLocale.Country = ... # 0x97
    CuraSao                  : QLocale.Country = ... # 0x98
    NewCaledonia             : QLocale.Country = ... # 0x99
    NewZealand               : QLocale.Country = ... # 0x9a
    Nicaragua                : QLocale.Country = ... # 0x9b
    Niger                    : QLocale.Country = ... # 0x9c
    Nigeria                  : QLocale.Country = ... # 0x9d
    Niue                     : QLocale.Country = ... # 0x9e
    NorfolkIsland            : QLocale.Country = ... # 0x9f
    NorthernMarianaIslands   : QLocale.Country = ... # 0xa0
    Norway                   : QLocale.Country = ... # 0xa1
    Oman                     : QLocale.Country = ... # 0xa2
    Pakistan                 : QLocale.Country = ... # 0xa3
    Palau                    : QLocale.Country = ... # 0xa4
    PalestinianTerritories   : QLocale.Country = ... # 0xa5
    Panama                   : QLocale.Country = ... # 0xa6
    PapuaNewGuinea           : QLocale.Country = ... # 0xa7
    Paraguay                 : QLocale.Country = ... # 0xa8
    Peru                     : QLocale.Country = ... # 0xa9
    Philippines              : QLocale.Country = ... # 0xaa
    Pitcairn                 : QLocale.Country = ... # 0xab
    Poland                   : QLocale.Country = ... # 0xac
    Portugal                 : QLocale.Country = ... # 0xad
    PuertoRico               : QLocale.Country = ... # 0xae
    Qatar                    : QLocale.Country = ... # 0xaf
    Reunion                  : QLocale.Country = ... # 0xb0
    Romania                  : QLocale.Country = ... # 0xb1
    Russia                   : QLocale.Country = ... # 0xb2
    RussianFederation        : QLocale.Country = ... # 0xb2
    Rwanda                   : QLocale.Country = ... # 0xb3
    SaintKittsAndNevis       : QLocale.Country = ... # 0xb4
    SaintLucia               : QLocale.Country = ... # 0xb5
    SaintVincentAndTheGrenadines: QLocale.Country = ... # 0xb6
    Samoa                    : QLocale.Country = ... # 0xb7
    SanMarino                : QLocale.Country = ... # 0xb8
    SaoTomeAndPrincipe       : QLocale.Country = ... # 0xb9
    SaudiArabia              : QLocale.Country = ... # 0xba
    Senegal                  : QLocale.Country = ... # 0xbb
    Seychelles               : QLocale.Country = ... # 0xbc
    SierraLeone              : QLocale.Country = ... # 0xbd
    Singapore                : QLocale.Country = ... # 0xbe
    Slovakia                 : QLocale.Country = ... # 0xbf
    Slovenia                 : QLocale.Country = ... # 0xc0
    SolomonIslands           : QLocale.Country = ... # 0xc1
    Somalia                  : QLocale.Country = ... # 0xc2
    SouthAfrica              : QLocale.Country = ... # 0xc3
    SouthGeorgiaAndTheSouthSandwichIslands: QLocale.Country = ... # 0xc4
    Spain                    : QLocale.Country = ... # 0xc5
    SriLanka                 : QLocale.Country = ... # 0xc6
    SaintHelena              : QLocale.Country = ... # 0xc7
    SaintPierreAndMiquelon   : QLocale.Country = ... # 0xc8
    Sudan                    : QLocale.Country = ... # 0xc9
    Suriname                 : QLocale.Country = ... # 0xca
    SvalbardAndJanMayenIslands: QLocale.Country = ... # 0xcb
    Swaziland                : QLocale.Country = ... # 0xcc
    Sweden                   : QLocale.Country = ... # 0xcd
    Switzerland              : QLocale.Country = ... # 0xce
    Syria                    : QLocale.Country = ... # 0xcf
    SyrianArabRepublic       : QLocale.Country = ... # 0xcf
    Taiwan                   : QLocale.Country = ... # 0xd0
    Tajikistan               : QLocale.Country = ... # 0xd1
    Tanzania                 : QLocale.Country = ... # 0xd2
    Thailand                 : QLocale.Country = ... # 0xd3
    Togo                     : QLocale.Country = ... # 0xd4
    Tokelau                  : QLocale.Country = ... # 0xd5
    TokelauCountry           : QLocale.Country = ... # 0xd5
    Tonga                    : QLocale.Country = ... # 0xd6
    TrinidadAndTobago        : QLocale.Country = ... # 0xd7
    Tunisia                  : QLocale.Country = ... # 0xd8
    Turkey                   : QLocale.Country = ... # 0xd9
    Turkmenistan             : QLocale.Country = ... # 0xda
    TurksAndCaicosIslands    : QLocale.Country = ... # 0xdb
    Tuvalu                   : QLocale.Country = ... # 0xdc
    TuvaluCountry            : QLocale.Country = ... # 0xdc
    Uganda                   : QLocale.Country = ... # 0xdd
    Ukraine                  : QLocale.Country = ... # 0xde
    UnitedArabEmirates       : QLocale.Country = ... # 0xdf
    UnitedKingdom            : QLocale.Country = ... # 0xe0
    UnitedStates             : QLocale.Country = ... # 0xe1
    UnitedStatesMinorOutlyingIslands: QLocale.Country = ... # 0xe2
    Uruguay                  : QLocale.Country = ... # 0xe3
    Uzbekistan               : QLocale.Country = ... # 0xe4
    Vanuatu                  : QLocale.Country = ... # 0xe5
    VaticanCityState         : QLocale.Country = ... # 0xe6
    Venezuela                : QLocale.Country = ... # 0xe7
    Vietnam                  : QLocale.Country = ... # 0xe8
    BritishVirginIslands     : QLocale.Country = ... # 0xe9
    UnitedStatesVirginIslands: QLocale.Country = ... # 0xea
    WallisAndFutunaIslands   : QLocale.Country = ... # 0xeb
    WesternSahara            : QLocale.Country = ... # 0xec
    Yemen                    : QLocale.Country = ... # 0xed
    CanaryIslands            : QLocale.Country = ... # 0xee
    Zambia                   : QLocale.Country = ... # 0xef
    Zimbabwe                 : QLocale.Country = ... # 0xf0
    ClippertonIsland         : QLocale.Country = ... # 0xf1
    Montenegro               : QLocale.Country = ... # 0xf2
    Serbia                   : QLocale.Country = ... # 0xf3
    SaintBarthelemy          : QLocale.Country = ... # 0xf4
    SaintMartin              : QLocale.Country = ... # 0xf5
    LatinAmerica             : QLocale.Country = ... # 0xf6
    LatinAmericaAndTheCaribbean: QLocale.Country = ... # 0xf6
    AscensionIsland          : QLocale.Country = ... # 0xf7
    AlandIslands             : QLocale.Country = ... # 0xf8
    DiegoGarcia              : QLocale.Country = ... # 0xf9
    CeutaAndMelilla          : QLocale.Country = ... # 0xfa
    IsleOfMan                : QLocale.Country = ... # 0xfb
    Jersey                   : QLocale.Country = ... # 0xfc
    TristanDaCunha           : QLocale.Country = ... # 0xfd
    SouthSudan               : QLocale.Country = ... # 0xfe
    Bonaire                  : QLocale.Country = ... # 0xff
    SintMaarten              : QLocale.Country = ... # 0x100
    Kosovo                   : QLocale.Country = ... # 0x101
    EuropeanUnion            : QLocale.Country = ... # 0x102
    OutlyingOceania          : QLocale.Country = ... # 0x103
    World                    : QLocale.Country = ... # 0x104
    Europe                   : QLocale.Country = ... # 0x105
    LastCountry              : QLocale.Country = ... # 0x105
    CurrencyIsoCode          : QLocale.CurrencySymbolFormat = ... # 0x0
    CurrencySymbol           : QLocale.CurrencySymbolFormat = ... # 0x1
    CurrencyDisplayName      : QLocale.CurrencySymbolFormat = ... # 0x2
    DataSizeIecFormat        : QLocale.DataSizeFormat = ... # 0x0
    DataSizeBase1000         : QLocale.DataSizeFormat = ... # 0x1
    DataSizeSIQuantifiers    : QLocale.DataSizeFormat = ... # 0x2
    DataSizeTraditionalFormat: QLocale.DataSizeFormat = ... # 0x2
    DataSizeSIFormat         : QLocale.DataSizeFormat = ... # 0x3
    FloatingPointShortest    : QLocale.FloatingPointPrecisionOption = ... # -0x80
    LongFormat               : QLocale.FormatType = ... # 0x0
    ShortFormat              : QLocale.FormatType = ... # 0x1
    NarrowFormat             : QLocale.FormatType = ... # 0x2
    AnyLanguage              : QLocale.Language = ... # 0x0
    C                        : QLocale.Language = ... # 0x1
    Abkhazian                : QLocale.Language = ... # 0x2
    Afan                     : QLocale.Language = ... # 0x3
    Oromo                    : QLocale.Language = ... # 0x3
    Afar                     : QLocale.Language = ... # 0x4
    Afrikaans                : QLocale.Language = ... # 0x5
    Albanian                 : QLocale.Language = ... # 0x6
    Amharic                  : QLocale.Language = ... # 0x7
    Arabic                   : QLocale.Language = ... # 0x8
    Armenian                 : QLocale.Language = ... # 0x9
    Assamese                 : QLocale.Language = ... # 0xa
    Aymara                   : QLocale.Language = ... # 0xb
    Azerbaijani              : QLocale.Language = ... # 0xc
    Bashkir                  : QLocale.Language = ... # 0xd
    Basque                   : QLocale.Language = ... # 0xe
    Bengali                  : QLocale.Language = ... # 0xf
    Bhutani                  : QLocale.Language = ... # 0x10
    Dzongkha                 : QLocale.Language = ... # 0x10
    Bihari                   : QLocale.Language = ... # 0x11
    Bislama                  : QLocale.Language = ... # 0x12
    Breton                   : QLocale.Language = ... # 0x13
    Bulgarian                : QLocale.Language = ... # 0x14
    Burmese                  : QLocale.Language = ... # 0x15
    Belarusian               : QLocale.Language = ... # 0x16
    Byelorussian             : QLocale.Language = ... # 0x16
    Cambodian                : QLocale.Language = ... # 0x17
    Khmer                    : QLocale.Language = ... # 0x17
    Catalan                  : QLocale.Language = ... # 0x18
    Chinese                  : QLocale.Language = ... # 0x19
    Corsican                 : QLocale.Language = ... # 0x1a
    Croatian                 : QLocale.Language = ... # 0x1b
    Czech                    : QLocale.Language = ... # 0x1c
    Danish                   : QLocale.Language = ... # 0x1d
    Dutch                    : QLocale.Language = ... # 0x1e
    English                  : QLocale.Language = ... # 0x1f
    Esperanto                : QLocale.Language = ... # 0x20
    Estonian                 : QLocale.Language = ... # 0x21
    Faroese                  : QLocale.Language = ... # 0x22
    Fijian                   : QLocale.Language = ... # 0x23
    Finnish                  : QLocale.Language = ... # 0x24
    French                   : QLocale.Language = ... # 0x25
    Frisian                  : QLocale.Language = ... # 0x26
    WesternFrisian           : QLocale.Language = ... # 0x26
    Gaelic                   : QLocale.Language = ... # 0x27
    Galician                 : QLocale.Language = ... # 0x28
    Georgian                 : QLocale.Language = ... # 0x29
    German                   : QLocale.Language = ... # 0x2a
    Greek                    : QLocale.Language = ... # 0x2b
    Greenlandic              : QLocale.Language = ... # 0x2c
    Guarani                  : QLocale.Language = ... # 0x2d
    Gujarati                 : QLocale.Language = ... # 0x2e
    Hausa                    : QLocale.Language = ... # 0x2f
    Hebrew                   : QLocale.Language = ... # 0x30
    Hindi                    : QLocale.Language = ... # 0x31
    Hungarian                : QLocale.Language = ... # 0x32
    Icelandic                : QLocale.Language = ... # 0x33
    Indonesian               : QLocale.Language = ... # 0x34
    Interlingua              : QLocale.Language = ... # 0x35
    Interlingue              : QLocale.Language = ... # 0x36
    Inuktitut                : QLocale.Language = ... # 0x37
    Inupiak                  : QLocale.Language = ... # 0x38
    Irish                    : QLocale.Language = ... # 0x39
    Italian                  : QLocale.Language = ... # 0x3a
    Japanese                 : QLocale.Language = ... # 0x3b
    Javanese                 : QLocale.Language = ... # 0x3c
    Kannada                  : QLocale.Language = ... # 0x3d
    Kashmiri                 : QLocale.Language = ... # 0x3e
    Kazakh                   : QLocale.Language = ... # 0x3f
    Kinyarwanda              : QLocale.Language = ... # 0x40
    Kirghiz                  : QLocale.Language = ... # 0x41
    Korean                   : QLocale.Language = ... # 0x42
    Kurdish                  : QLocale.Language = ... # 0x43
    Kurundi                  : QLocale.Language = ... # 0x44
    Rundi                    : QLocale.Language = ... # 0x44
    Lao                      : QLocale.Language = ... # 0x45
    Latin                    : QLocale.Language = ... # 0x46
    Latvian                  : QLocale.Language = ... # 0x47
    Lingala                  : QLocale.Language = ... # 0x48
    Lithuanian               : QLocale.Language = ... # 0x49
    Macedonian               : QLocale.Language = ... # 0x4a
    Malagasy                 : QLocale.Language = ... # 0x4b
    Malay                    : QLocale.Language = ... # 0x4c
    Malayalam                : QLocale.Language = ... # 0x4d
    Maltese                  : QLocale.Language = ... # 0x4e
    Maori                    : QLocale.Language = ... # 0x4f
    Marathi                  : QLocale.Language = ... # 0x50
    Marshallese              : QLocale.Language = ... # 0x51
    Mongolian                : QLocale.Language = ... # 0x52
    NauruLanguage            : QLocale.Language = ... # 0x53
    Nepali                   : QLocale.Language = ... # 0x54
    Norwegian                : QLocale.Language = ... # 0x55
    NorwegianBokmal          : QLocale.Language = ... # 0x55
    Occitan                  : QLocale.Language = ... # 0x56
    Oriya                    : QLocale.Language = ... # 0x57
    Pashto                   : QLocale.Language = ... # 0x58
    Persian                  : QLocale.Language = ... # 0x59
    Polish                   : QLocale.Language = ... # 0x5a
    Portuguese               : QLocale.Language = ... # 0x5b
    Punjabi                  : QLocale.Language = ... # 0x5c
    Quechua                  : QLocale.Language = ... # 0x5d
    RhaetoRomance            : QLocale.Language = ... # 0x5e
    Romansh                  : QLocale.Language = ... # 0x5e
    Moldavian                : QLocale.Language = ... # 0x5f
    Romanian                 : QLocale.Language = ... # 0x5f
    Russian                  : QLocale.Language = ... # 0x60
    Samoan                   : QLocale.Language = ... # 0x61
    Sango                    : QLocale.Language = ... # 0x62
    Sanskrit                 : QLocale.Language = ... # 0x63
    Serbian                  : QLocale.Language = ... # 0x64
    SerboCroatian            : QLocale.Language = ... # 0x64
    Ossetic                  : QLocale.Language = ... # 0x65
    SouthernSotho            : QLocale.Language = ... # 0x66
    Tswana                   : QLocale.Language = ... # 0x67
    Shona                    : QLocale.Language = ... # 0x68
    Sindhi                   : QLocale.Language = ... # 0x69
    Sinhala                  : QLocale.Language = ... # 0x6a
    Swati                    : QLocale.Language = ... # 0x6b
    Slovak                   : QLocale.Language = ... # 0x6c
    Slovenian                : QLocale.Language = ... # 0x6d
    Somali                   : QLocale.Language = ... # 0x6e
    Spanish                  : QLocale.Language = ... # 0x6f
    Sundanese                : QLocale.Language = ... # 0x70
    Swahili                  : QLocale.Language = ... # 0x71
    Swedish                  : QLocale.Language = ... # 0x72
    Sardinian                : QLocale.Language = ... # 0x73
    Tajik                    : QLocale.Language = ... # 0x74
    Tamil                    : QLocale.Language = ... # 0x75
    Tatar                    : QLocale.Language = ... # 0x76
    Telugu                   : QLocale.Language = ... # 0x77
    Thai                     : QLocale.Language = ... # 0x78
    Tibetan                  : QLocale.Language = ... # 0x79
    Tigrinya                 : QLocale.Language = ... # 0x7a
    Tongan                   : QLocale.Language = ... # 0x7b
    Tsonga                   : QLocale.Language = ... # 0x7c
    Turkish                  : QLocale.Language = ... # 0x7d
    Turkmen                  : QLocale.Language = ... # 0x7e
    Tahitian                 : QLocale.Language = ... # 0x7f
    Uighur                   : QLocale.Language = ... # 0x80
    Uigur                    : QLocale.Language = ... # 0x80
    Ukrainian                : QLocale.Language = ... # 0x81
    Urdu                     : QLocale.Language = ... # 0x82
    Uzbek                    : QLocale.Language = ... # 0x83
    Vietnamese               : QLocale.Language = ... # 0x84
    Volapuk                  : QLocale.Language = ... # 0x85
    Welsh                    : QLocale.Language = ... # 0x86
    Wolof                    : QLocale.Language = ... # 0x87
    Xhosa                    : QLocale.Language = ... # 0x88
    Yiddish                  : QLocale.Language = ... # 0x89
    Yoruba                   : QLocale.Language = ... # 0x8a
    Zhuang                   : QLocale.Language = ... # 0x8b
    Zulu                     : QLocale.Language = ... # 0x8c
    NorwegianNynorsk         : QLocale.Language = ... # 0x8d
    Bosnian                  : QLocale.Language = ... # 0x8e
    Divehi                   : QLocale.Language = ... # 0x8f
    Manx                     : QLocale.Language = ... # 0x90
    Cornish                  : QLocale.Language = ... # 0x91
    Akan                     : QLocale.Language = ... # 0x92
    Twi                      : QLocale.Language = ... # 0x92
    Konkani                  : QLocale.Language = ... # 0x93
    Ga                       : QLocale.Language = ... # 0x94
    Igbo                     : QLocale.Language = ... # 0x95
    Kamba                    : QLocale.Language = ... # 0x96
    Syriac                   : QLocale.Language = ... # 0x97
    Blin                     : QLocale.Language = ... # 0x98
    Geez                     : QLocale.Language = ... # 0x99
    Koro                     : QLocale.Language = ... # 0x9a
    Sidamo                   : QLocale.Language = ... # 0x9b
    Atsam                    : QLocale.Language = ... # 0x9c
    Tigre                    : QLocale.Language = ... # 0x9d
    Jju                      : QLocale.Language = ... # 0x9e
    Friulian                 : QLocale.Language = ... # 0x9f
    Venda                    : QLocale.Language = ... # 0xa0
    Ewe                      : QLocale.Language = ... # 0xa1
    Walamo                   : QLocale.Language = ... # 0xa2
    Hawaiian                 : QLocale.Language = ... # 0xa3
    Tyap                     : QLocale.Language = ... # 0xa4
    Chewa                    : QLocale.Language = ... # 0xa5
    Nyanja                   : QLocale.Language = ... # 0xa5
    Filipino                 : QLocale.Language = ... # 0xa6
    Tagalog                  : QLocale.Language = ... # 0xa6
    SwissGerman              : QLocale.Language = ... # 0xa7
    SichuanYi                : QLocale.Language = ... # 0xa8
    Kpelle                   : QLocale.Language = ... # 0xa9
    LowGerman                : QLocale.Language = ... # 0xaa
    SouthNdebele             : QLocale.Language = ... # 0xab
    NorthernSotho            : QLocale.Language = ... # 0xac
    NorthernSami             : QLocale.Language = ... # 0xad
    Taroko                   : QLocale.Language = ... # 0xae
    Gusii                    : QLocale.Language = ... # 0xaf
    Taita                    : QLocale.Language = ... # 0xb0
    Fulah                    : QLocale.Language = ... # 0xb1
    Kikuyu                   : QLocale.Language = ... # 0xb2
    Samburu                  : QLocale.Language = ... # 0xb3
    Sena                     : QLocale.Language = ... # 0xb4
    NorthNdebele             : QLocale.Language = ... # 0xb5
    Rombo                    : QLocale.Language = ... # 0xb6
    Tachelhit                : QLocale.Language = ... # 0xb7
    Kabyle                   : QLocale.Language = ... # 0xb8
    Nyankole                 : QLocale.Language = ... # 0xb9
    Bena                     : QLocale.Language = ... # 0xba
    Vunjo                    : QLocale.Language = ... # 0xbb
    Bambara                  : QLocale.Language = ... # 0xbc
    Embu                     : QLocale.Language = ... # 0xbd
    Cherokee                 : QLocale.Language = ... # 0xbe
    Morisyen                 : QLocale.Language = ... # 0xbf
    Makonde                  : QLocale.Language = ... # 0xc0
    Langi                    : QLocale.Language = ... # 0xc1
    Ganda                    : QLocale.Language = ... # 0xc2
    Bemba                    : QLocale.Language = ... # 0xc3
    Kabuverdianu             : QLocale.Language = ... # 0xc4
    Meru                     : QLocale.Language = ... # 0xc5
    Kalenjin                 : QLocale.Language = ... # 0xc6
    Nama                     : QLocale.Language = ... # 0xc7
    Machame                  : QLocale.Language = ... # 0xc8
    Colognian                : QLocale.Language = ... # 0xc9
    Masai                    : QLocale.Language = ... # 0xca
    Soga                     : QLocale.Language = ... # 0xcb
    Luyia                    : QLocale.Language = ... # 0xcc
    Asu                      : QLocale.Language = ... # 0xcd
    Teso                     : QLocale.Language = ... # 0xce
    Saho                     : QLocale.Language = ... # 0xcf
    KoyraChiini              : QLocale.Language = ... # 0xd0
    Rwa                      : QLocale.Language = ... # 0xd1
    Luo                      : QLocale.Language = ... # 0xd2
    Chiga                    : QLocale.Language = ... # 0xd3
    CentralMoroccoTamazight  : QLocale.Language = ... # 0xd4
    KoyraboroSenni           : QLocale.Language = ... # 0xd5
    Shambala                 : QLocale.Language = ... # 0xd6
    Bodo                     : QLocale.Language = ... # 0xd7
    Avaric                   : QLocale.Language = ... # 0xd8
    Chamorro                 : QLocale.Language = ... # 0xd9
    Chechen                  : QLocale.Language = ... # 0xda
    Church                   : QLocale.Language = ... # 0xdb
    Chuvash                  : QLocale.Language = ... # 0xdc
    Cree                     : QLocale.Language = ... # 0xdd
    Haitian                  : QLocale.Language = ... # 0xde
    Herero                   : QLocale.Language = ... # 0xdf
    HiriMotu                 : QLocale.Language = ... # 0xe0
    Kanuri                   : QLocale.Language = ... # 0xe1
    Komi                     : QLocale.Language = ... # 0xe2
    Kongo                    : QLocale.Language = ... # 0xe3
    Kwanyama                 : QLocale.Language = ... # 0xe4
    Limburgish               : QLocale.Language = ... # 0xe5
    LubaKatanga              : QLocale.Language = ... # 0xe6
    Luxembourgish            : QLocale.Language = ... # 0xe7
    Navaho                   : QLocale.Language = ... # 0xe8
    Ndonga                   : QLocale.Language = ... # 0xe9
    Ojibwa                   : QLocale.Language = ... # 0xea
    Pali                     : QLocale.Language = ... # 0xeb
    Walloon                  : QLocale.Language = ... # 0xec
    Aghem                    : QLocale.Language = ... # 0xed
    Basaa                    : QLocale.Language = ... # 0xee
    Zarma                    : QLocale.Language = ... # 0xef
    Duala                    : QLocale.Language = ... # 0xf0
    JolaFonyi                : QLocale.Language = ... # 0xf1
    Ewondo                   : QLocale.Language = ... # 0xf2
    Bafia                    : QLocale.Language = ... # 0xf3
    MakhuwaMeetto            : QLocale.Language = ... # 0xf4
    Mundang                  : QLocale.Language = ... # 0xf5
    Kwasio                   : QLocale.Language = ... # 0xf6
    Nuer                     : QLocale.Language = ... # 0xf7
    Sakha                    : QLocale.Language = ... # 0xf8
    Sangu                    : QLocale.Language = ... # 0xf9
    CongoSwahili             : QLocale.Language = ... # 0xfa
    Tasawaq                  : QLocale.Language = ... # 0xfb
    Vai                      : QLocale.Language = ... # 0xfc
    Walser                   : QLocale.Language = ... # 0xfd
    Yangben                  : QLocale.Language = ... # 0xfe
    Avestan                  : QLocale.Language = ... # 0xff
    Asturian                 : QLocale.Language = ... # 0x100
    Ngomba                   : QLocale.Language = ... # 0x101
    Kako                     : QLocale.Language = ... # 0x102
    Meta                     : QLocale.Language = ... # 0x103
    Ngiemboon                : QLocale.Language = ... # 0x104
    Aragonese                : QLocale.Language = ... # 0x105
    Akkadian                 : QLocale.Language = ... # 0x106
    AncientEgyptian          : QLocale.Language = ... # 0x107
    AncientGreek             : QLocale.Language = ... # 0x108
    Aramaic                  : QLocale.Language = ... # 0x109
    Balinese                 : QLocale.Language = ... # 0x10a
    Bamun                    : QLocale.Language = ... # 0x10b
    BatakToba                : QLocale.Language = ... # 0x10c
    Buginese                 : QLocale.Language = ... # 0x10d
    Buhid                    : QLocale.Language = ... # 0x10e
    Carian                   : QLocale.Language = ... # 0x10f
    Chakma                   : QLocale.Language = ... # 0x110
    ClassicalMandaic         : QLocale.Language = ... # 0x111
    Coptic                   : QLocale.Language = ... # 0x112
    Dogri                    : QLocale.Language = ... # 0x113
    EasternCham              : QLocale.Language = ... # 0x114
    EasternKayah             : QLocale.Language = ... # 0x115
    Etruscan                 : QLocale.Language = ... # 0x116
    Gothic                   : QLocale.Language = ... # 0x117
    Hanunoo                  : QLocale.Language = ... # 0x118
    Ingush                   : QLocale.Language = ... # 0x119
    LargeFloweryMiao         : QLocale.Language = ... # 0x11a
    Lepcha                   : QLocale.Language = ... # 0x11b
    Limbu                    : QLocale.Language = ... # 0x11c
    Lisu                     : QLocale.Language = ... # 0x11d
    Lu                       : QLocale.Language = ... # 0x11e
    Lycian                   : QLocale.Language = ... # 0x11f
    Lydian                   : QLocale.Language = ... # 0x120
    Mandingo                 : QLocale.Language = ... # 0x121
    Manipuri                 : QLocale.Language = ... # 0x122
    Meroitic                 : QLocale.Language = ... # 0x123
    NorthernThai             : QLocale.Language = ... # 0x124
    OldIrish                 : QLocale.Language = ... # 0x125
    OldNorse                 : QLocale.Language = ... # 0x126
    OldPersian               : QLocale.Language = ... # 0x127
    OldTurkish               : QLocale.Language = ... # 0x128
    Pahlavi                  : QLocale.Language = ... # 0x129
    Parthian                 : QLocale.Language = ... # 0x12a
    Phoenician               : QLocale.Language = ... # 0x12b
    PrakritLanguage          : QLocale.Language = ... # 0x12c
    Rejang                   : QLocale.Language = ... # 0x12d
    Sabaean                  : QLocale.Language = ... # 0x12e
    Samaritan                : QLocale.Language = ... # 0x12f
    Santali                  : QLocale.Language = ... # 0x130
    Saurashtra               : QLocale.Language = ... # 0x131
    Sora                     : QLocale.Language = ... # 0x132
    Sylheti                  : QLocale.Language = ... # 0x133
    Tagbanwa                 : QLocale.Language = ... # 0x134
    TaiDam                   : QLocale.Language = ... # 0x135
    TaiNua                   : QLocale.Language = ... # 0x136
    Ugaritic                 : QLocale.Language = ... # 0x137
    Akoose                   : QLocale.Language = ... # 0x138
    Lakota                   : QLocale.Language = ... # 0x139
    StandardMoroccanTamazight: QLocale.Language = ... # 0x13a
    Mapuche                  : QLocale.Language = ... # 0x13b
    CentralKurdish           : QLocale.Language = ... # 0x13c
    LowerSorbian             : QLocale.Language = ... # 0x13d
    UpperSorbian             : QLocale.Language = ... # 0x13e
    Kenyang                  : QLocale.Language = ... # 0x13f
    Mohawk                   : QLocale.Language = ... # 0x140
    Nko                      : QLocale.Language = ... # 0x141
    Prussian                 : QLocale.Language = ... # 0x142
    Kiche                    : QLocale.Language = ... # 0x143
    SouthernSami             : QLocale.Language = ... # 0x144
    LuleSami                 : QLocale.Language = ... # 0x145
    InariSami                : QLocale.Language = ... # 0x146
    SkoltSami                : QLocale.Language = ... # 0x147
    Warlpiri                 : QLocale.Language = ... # 0x148
    ManichaeanMiddlePersian  : QLocale.Language = ... # 0x149
    Mende                    : QLocale.Language = ... # 0x14a
    AncientNorthArabian      : QLocale.Language = ... # 0x14b
    LinearA                  : QLocale.Language = ... # 0x14c
    HmongNjua                : QLocale.Language = ... # 0x14d
    Ho                       : QLocale.Language = ... # 0x14e
    Lezghian                 : QLocale.Language = ... # 0x14f
    Bassa                    : QLocale.Language = ... # 0x150
    Mono                     : QLocale.Language = ... # 0x151
    TedimChin                : QLocale.Language = ... # 0x152
    Maithili                 : QLocale.Language = ... # 0x153
    Ahom                     : QLocale.Language = ... # 0x154
    AmericanSignLanguage     : QLocale.Language = ... # 0x155
    ArdhamagadhiPrakrit      : QLocale.Language = ... # 0x156
    Bhojpuri                 : QLocale.Language = ... # 0x157
    HieroglyphicLuwian       : QLocale.Language = ... # 0x158
    LiteraryChinese          : QLocale.Language = ... # 0x159
    Mazanderani              : QLocale.Language = ... # 0x15a
    Mru                      : QLocale.Language = ... # 0x15b
    Newari                   : QLocale.Language = ... # 0x15c
    NorthernLuri             : QLocale.Language = ... # 0x15d
    Palauan                  : QLocale.Language = ... # 0x15e
    Papiamento               : QLocale.Language = ... # 0x15f
    Saraiki                  : QLocale.Language = ... # 0x160
    TokelauLanguage          : QLocale.Language = ... # 0x161
    TokPisin                 : QLocale.Language = ... # 0x162
    TuvaluLanguage           : QLocale.Language = ... # 0x163
    UncodedLanguages         : QLocale.Language = ... # 0x164
    Cantonese                : QLocale.Language = ... # 0x165
    Osage                    : QLocale.Language = ... # 0x166
    Tangut                   : QLocale.Language = ... # 0x167
    Ido                      : QLocale.Language = ... # 0x168
    Lojban                   : QLocale.Language = ... # 0x169
    Sicilian                 : QLocale.Language = ... # 0x16a
    SouthernKurdish          : QLocale.Language = ... # 0x16b
    WesternBalochi           : QLocale.Language = ... # 0x16c
    Cebuano                  : QLocale.Language = ... # 0x16d
    Erzya                    : QLocale.Language = ... # 0x16e
    Chickasaw                : QLocale.Language = ... # 0x16f
    Muscogee                 : QLocale.Language = ... # 0x170
    Silesian                 : QLocale.Language = ... # 0x171
    LastLanguage             : QLocale.Language = ... # 0x172
    NigerianPidgin           : QLocale.Language = ... # 0x172
    MetricSystem             : QLocale.MeasurementSystem = ... # 0x0
    ImperialSystem           : QLocale.MeasurementSystem = ... # 0x1
    ImperialUSSystem         : QLocale.MeasurementSystem = ... # 0x1
    ImperialUKSystem         : QLocale.MeasurementSystem = ... # 0x2
    DefaultNumberOptions     : QLocale.NumberOption = ... # 0x0
    OmitGroupSeparator       : QLocale.NumberOption = ... # 0x1
    RejectGroupSeparator     : QLocale.NumberOption = ... # 0x2
    OmitLeadingZeroInExponent: QLocale.NumberOption = ... # 0x4
    RejectLeadingZeroInExponent: QLocale.NumberOption = ... # 0x8
    IncludeTrailingZeroesAfterDot: QLocale.NumberOption = ... # 0x10
    RejectTrailingZeroesAfterDot: QLocale.NumberOption = ... # 0x20
    StandardQuotation        : QLocale.QuotationStyle = ... # 0x0
    AlternateQuotation       : QLocale.QuotationStyle = ... # 0x1
    AnyScript                : QLocale.Script = ... # 0x0
    ArabicScript             : QLocale.Script = ... # 0x1
    CyrillicScript           : QLocale.Script = ... # 0x2
    DeseretScript            : QLocale.Script = ... # 0x3
    GurmukhiScript           : QLocale.Script = ... # 0x4
    SimplifiedChineseScript  : QLocale.Script = ... # 0x5
    SimplifiedHanScript      : QLocale.Script = ... # 0x5
    TraditionalChineseScript : QLocale.Script = ... # 0x6
    TraditionalHanScript     : QLocale.Script = ... # 0x6
    LatinScript              : QLocale.Script = ... # 0x7
    MongolianScript          : QLocale.Script = ... # 0x8
    TifinaghScript           : QLocale.Script = ... # 0x9
    ArmenianScript           : QLocale.Script = ... # 0xa
    BengaliScript            : QLocale.Script = ... # 0xb
    CherokeeScript           : QLocale.Script = ... # 0xc
    DevanagariScript         : QLocale.Script = ... # 0xd
    EthiopicScript           : QLocale.Script = ... # 0xe
    GeorgianScript           : QLocale.Script = ... # 0xf
    GreekScript              : QLocale.Script = ... # 0x10
    GujaratiScript           : QLocale.Script = ... # 0x11
    HebrewScript             : QLocale.Script = ... # 0x12
    JapaneseScript           : QLocale.Script = ... # 0x13
    KhmerScript              : QLocale.Script = ... # 0x14
    KannadaScript            : QLocale.Script = ... # 0x15
    KoreanScript             : QLocale.Script = ... # 0x16
    LaoScript                : QLocale.Script = ... # 0x17
    MalayalamScript          : QLocale.Script = ... # 0x18
    MyanmarScript            : QLocale.Script = ... # 0x19
    OriyaScript              : QLocale.Script = ... # 0x1a
    TamilScript              : QLocale.Script = ... # 0x1b
    TeluguScript             : QLocale.Script = ... # 0x1c
    ThaanaScript             : QLocale.Script = ... # 0x1d
    ThaiScript               : QLocale.Script = ... # 0x1e
    TibetanScript            : QLocale.Script = ... # 0x1f
    SinhalaScript            : QLocale.Script = ... # 0x20
    SyriacScript             : QLocale.Script = ... # 0x21
    YiScript                 : QLocale.Script = ... # 0x22
    VaiScript                : QLocale.Script = ... # 0x23
    AvestanScript            : QLocale.Script = ... # 0x24
    BalineseScript           : QLocale.Script = ... # 0x25
    BamumScript              : QLocale.Script = ... # 0x26
    BatakScript              : QLocale.Script = ... # 0x27
    BopomofoScript           : QLocale.Script = ... # 0x28
    BrahmiScript             : QLocale.Script = ... # 0x29
    BugineseScript           : QLocale.Script = ... # 0x2a
    BuhidScript              : QLocale.Script = ... # 0x2b
    CanadianAboriginalScript : QLocale.Script = ... # 0x2c
    CarianScript             : QLocale.Script = ... # 0x2d
    ChakmaScript             : QLocale.Script = ... # 0x2e
    ChamScript               : QLocale.Script = ... # 0x2f
    CopticScript             : QLocale.Script = ... # 0x30
    CypriotScript            : QLocale.Script = ... # 0x31
    EgyptianHieroglyphsScript: QLocale.Script = ... # 0x32
    FraserScript             : QLocale.Script = ... # 0x33
    GlagoliticScript         : QLocale.Script = ... # 0x34
    GothicScript             : QLocale.Script = ... # 0x35
    HanScript                : QLocale.Script = ... # 0x36
    HangulScript             : QLocale.Script = ... # 0x37
    HanunooScript            : QLocale.Script = ... # 0x38
    ImperialAramaicScript    : QLocale.Script = ... # 0x39
    InscriptionalPahlaviScript: QLocale.Script = ... # 0x3a
    InscriptionalParthianScript: QLocale.Script = ... # 0x3b
    JavaneseScript           : QLocale.Script = ... # 0x3c
    KaithiScript             : QLocale.Script = ... # 0x3d
    KatakanaScript           : QLocale.Script = ... # 0x3e
    KayahLiScript            : QLocale.Script = ... # 0x3f
    KharoshthiScript         : QLocale.Script = ... # 0x40
    LannaScript              : QLocale.Script = ... # 0x41
    LepchaScript             : QLocale.Script = ... # 0x42
    LimbuScript              : QLocale.Script = ... # 0x43
    LinearBScript            : QLocale.Script = ... # 0x44
    LycianScript             : QLocale.Script = ... # 0x45
    LydianScript             : QLocale.Script = ... # 0x46
    MandaeanScript           : QLocale.Script = ... # 0x47
    MeiteiMayekScript        : QLocale.Script = ... # 0x48
    MeroiticScript           : QLocale.Script = ... # 0x49
    MeroiticCursiveScript    : QLocale.Script = ... # 0x4a
    NkoScript                : QLocale.Script = ... # 0x4b
    NewTaiLueScript          : QLocale.Script = ... # 0x4c
    OghamScript              : QLocale.Script = ... # 0x4d
    OlChikiScript            : QLocale.Script = ... # 0x4e
    OldItalicScript          : QLocale.Script = ... # 0x4f
    OldPersianScript         : QLocale.Script = ... # 0x50
    OldSouthArabianScript    : QLocale.Script = ... # 0x51
    OrkhonScript             : QLocale.Script = ... # 0x52
    OsmanyaScript            : QLocale.Script = ... # 0x53
    PhagsPaScript            : QLocale.Script = ... # 0x54
    PhoenicianScript         : QLocale.Script = ... # 0x55
    PollardPhoneticScript    : QLocale.Script = ... # 0x56
    RejangScript             : QLocale.Script = ... # 0x57
    RunicScript              : QLocale.Script = ... # 0x58
    SamaritanScript          : QLocale.Script = ... # 0x59
    SaurashtraScript         : QLocale.Script = ... # 0x5a
    SharadaScript            : QLocale.Script = ... # 0x5b
    ShavianScript            : QLocale.Script = ... # 0x5c
    SoraSompengScript        : QLocale.Script = ... # 0x5d
    CuneiformScript          : QLocale.Script = ... # 0x5e
    SundaneseScript          : QLocale.Script = ... # 0x5f
    SylotiNagriScript        : QLocale.Script = ... # 0x60
    TagalogScript            : QLocale.Script = ... # 0x61
    TagbanwaScript           : QLocale.Script = ... # 0x62
    TaiLeScript              : QLocale.Script = ... # 0x63
    TaiVietScript            : QLocale.Script = ... # 0x64
    TakriScript              : QLocale.Script = ... # 0x65
    UgariticScript           : QLocale.Script = ... # 0x66
    BrailleScript            : QLocale.Script = ... # 0x67
    HiraganaScript           : QLocale.Script = ... # 0x68
    CaucasianAlbanianScript  : QLocale.Script = ... # 0x69
    BassaVahScript           : QLocale.Script = ... # 0x6a
    DuployanScript           : QLocale.Script = ... # 0x6b
    ElbasanScript            : QLocale.Script = ... # 0x6c
    GranthaScript            : QLocale.Script = ... # 0x6d
    PahawhHmongScript        : QLocale.Script = ... # 0x6e
    KhojkiScript             : QLocale.Script = ... # 0x6f
    LinearAScript            : QLocale.Script = ... # 0x70
    MahajaniScript           : QLocale.Script = ... # 0x71
    ManichaeanScript         : QLocale.Script = ... # 0x72
    MendeKikakuiScript       : QLocale.Script = ... # 0x73
    ModiScript               : QLocale.Script = ... # 0x74
    MroScript                : QLocale.Script = ... # 0x75
    OldNorthArabianScript    : QLocale.Script = ... # 0x76
    NabataeanScript          : QLocale.Script = ... # 0x77
    PalmyreneScript          : QLocale.Script = ... # 0x78
    PauCinHauScript          : QLocale.Script = ... # 0x79
    OldPermicScript          : QLocale.Script = ... # 0x7a
    PsalterPahlaviScript     : QLocale.Script = ... # 0x7b
    SiddhamScript            : QLocale.Script = ... # 0x7c
    KhudawadiScript          : QLocale.Script = ... # 0x7d
    TirhutaScript            : QLocale.Script = ... # 0x7e
    VarangKshitiScript       : QLocale.Script = ... # 0x7f
    AhomScript               : QLocale.Script = ... # 0x80
    AnatolianHieroglyphsScript: QLocale.Script = ... # 0x81
    HatranScript             : QLocale.Script = ... # 0x82
    MultaniScript            : QLocale.Script = ... # 0x83
    OldHungarianScript       : QLocale.Script = ... # 0x84
    SignWritingScript        : QLocale.Script = ... # 0x85
    AdlamScript              : QLocale.Script = ... # 0x86
    BhaiksukiScript          : QLocale.Script = ... # 0x87
    MarchenScript            : QLocale.Script = ... # 0x88
    NewaScript               : QLocale.Script = ... # 0x89
    OsageScript              : QLocale.Script = ... # 0x8a
    TangutScript             : QLocale.Script = ... # 0x8b
    HanWithBopomofoScript    : QLocale.Script = ... # 0x8c
    JamoScript               : QLocale.Script = ... # 0x8d
    LastScript               : QLocale.Script = ... # 0x8d

    class Country(Shiboken.Enum):
        AnyCountry               : QLocale.Country = ... # 0x0
        Afghanistan              : QLocale.Country = ... # 0x1
        Albania                  : QLocale.Country = ... # 0x2
        Algeria                  : QLocale.Country = ... # 0x3
        AmericanSamoa            : QLocale.Country = ... # 0x4
        Andorra                  : QLocale.Country = ... # 0x5
        Angola                   : QLocale.Country = ... # 0x6
        Anguilla                 : QLocale.Country = ... # 0x7
        Antarctica               : QLocale.Country = ... # 0x8
        AntiguaAndBarbuda        : QLocale.Country = ... # 0x9
        Argentina                : QLocale.Country = ... # 0xa
        Armenia                  : QLocale.Country = ... # 0xb
        Aruba                    : QLocale.Country = ... # 0xc
        Australia                : QLocale.Country = ... # 0xd
        Austria                  : QLocale.Country = ... # 0xe
        Azerbaijan               : QLocale.Country = ... # 0xf
        Bahamas                  : QLocale.Country = ... # 0x10
        Bahrain                  : QLocale.Country = ... # 0x11
        Bangladesh               : QLocale.Country = ... # 0x12
        Barbados                 : QLocale.Country = ... # 0x13
        Belarus                  : QLocale.Country = ... # 0x14
        Belgium                  : QLocale.Country = ... # 0x15
        Belize                   : QLocale.Country = ... # 0x16
        Benin                    : QLocale.Country = ... # 0x17
        Bermuda                  : QLocale.Country = ... # 0x18
        Bhutan                   : QLocale.Country = ... # 0x19
        Bolivia                  : QLocale.Country = ... # 0x1a
        BosniaAndHerzegowina     : QLocale.Country = ... # 0x1b
        Botswana                 : QLocale.Country = ... # 0x1c
        BouvetIsland             : QLocale.Country = ... # 0x1d
        Brazil                   : QLocale.Country = ... # 0x1e
        BritishIndianOceanTerritory: QLocale.Country = ... # 0x1f
        Brunei                   : QLocale.Country = ... # 0x20
        Bulgaria                 : QLocale.Country = ... # 0x21
        BurkinaFaso              : QLocale.Country = ... # 0x22
        Burundi                  : QLocale.Country = ... # 0x23
        Cambodia                 : QLocale.Country = ... # 0x24
        Cameroon                 : QLocale.Country = ... # 0x25
        Canada                   : QLocale.Country = ... # 0x26
        CapeVerde                : QLocale.Country = ... # 0x27
        CaymanIslands            : QLocale.Country = ... # 0x28
        CentralAfricanRepublic   : QLocale.Country = ... # 0x29
        Chad                     : QLocale.Country = ... # 0x2a
        Chile                    : QLocale.Country = ... # 0x2b
        China                    : QLocale.Country = ... # 0x2c
        ChristmasIsland          : QLocale.Country = ... # 0x2d
        CocosIslands             : QLocale.Country = ... # 0x2e
        Colombia                 : QLocale.Country = ... # 0x2f
        Comoros                  : QLocale.Country = ... # 0x30
        CongoKinshasa            : QLocale.Country = ... # 0x31
        DemocraticRepublicOfCongo: QLocale.Country = ... # 0x31
        CongoBrazzaville         : QLocale.Country = ... # 0x32
        PeoplesRepublicOfCongo   : QLocale.Country = ... # 0x32
        CookIslands              : QLocale.Country = ... # 0x33
        CostaRica                : QLocale.Country = ... # 0x34
        IvoryCoast               : QLocale.Country = ... # 0x35
        Croatia                  : QLocale.Country = ... # 0x36
        Cuba                     : QLocale.Country = ... # 0x37
        Cyprus                   : QLocale.Country = ... # 0x38
        CzechRepublic            : QLocale.Country = ... # 0x39
        Denmark                  : QLocale.Country = ... # 0x3a
        Djibouti                 : QLocale.Country = ... # 0x3b
        Dominica                 : QLocale.Country = ... # 0x3c
        DominicanRepublic        : QLocale.Country = ... # 0x3d
        EastTimor                : QLocale.Country = ... # 0x3e
        Ecuador                  : QLocale.Country = ... # 0x3f
        Egypt                    : QLocale.Country = ... # 0x40
        ElSalvador               : QLocale.Country = ... # 0x41
        EquatorialGuinea         : QLocale.Country = ... # 0x42
        Eritrea                  : QLocale.Country = ... # 0x43
        Estonia                  : QLocale.Country = ... # 0x44
        Ethiopia                 : QLocale.Country = ... # 0x45
        FalklandIslands          : QLocale.Country = ... # 0x46
        FaroeIslands             : QLocale.Country = ... # 0x47
        Fiji                     : QLocale.Country = ... # 0x48
        Finland                  : QLocale.Country = ... # 0x49
        France                   : QLocale.Country = ... # 0x4a
        Guernsey                 : QLocale.Country = ... # 0x4b
        FrenchGuiana             : QLocale.Country = ... # 0x4c
        FrenchPolynesia          : QLocale.Country = ... # 0x4d
        FrenchSouthernTerritories: QLocale.Country = ... # 0x4e
        Gabon                    : QLocale.Country = ... # 0x4f
        Gambia                   : QLocale.Country = ... # 0x50
        Georgia                  : QLocale.Country = ... # 0x51
        Germany                  : QLocale.Country = ... # 0x52
        Ghana                    : QLocale.Country = ... # 0x53
        Gibraltar                : QLocale.Country = ... # 0x54
        Greece                   : QLocale.Country = ... # 0x55
        Greenland                : QLocale.Country = ... # 0x56
        Grenada                  : QLocale.Country = ... # 0x57
        Guadeloupe               : QLocale.Country = ... # 0x58
        Guam                     : QLocale.Country = ... # 0x59
        Guatemala                : QLocale.Country = ... # 0x5a
        Guinea                   : QLocale.Country = ... # 0x5b
        GuineaBissau             : QLocale.Country = ... # 0x5c
        Guyana                   : QLocale.Country = ... # 0x5d
        Haiti                    : QLocale.Country = ... # 0x5e
        HeardAndMcDonaldIslands  : QLocale.Country = ... # 0x5f
        Honduras                 : QLocale.Country = ... # 0x60
        HongKong                 : QLocale.Country = ... # 0x61
        Hungary                  : QLocale.Country = ... # 0x62
        Iceland                  : QLocale.Country = ... # 0x63
        India                    : QLocale.Country = ... # 0x64
        Indonesia                : QLocale.Country = ... # 0x65
        Iran                     : QLocale.Country = ... # 0x66
        Iraq                     : QLocale.Country = ... # 0x67
        Ireland                  : QLocale.Country = ... # 0x68
        Israel                   : QLocale.Country = ... # 0x69
        Italy                    : QLocale.Country = ... # 0x6a
        Jamaica                  : QLocale.Country = ... # 0x6b
        Japan                    : QLocale.Country = ... # 0x6c
        Jordan                   : QLocale.Country = ... # 0x6d
        Kazakhstan               : QLocale.Country = ... # 0x6e
        Kenya                    : QLocale.Country = ... # 0x6f
        Kiribati                 : QLocale.Country = ... # 0x70
        DemocraticRepublicOfKorea: QLocale.Country = ... # 0x71
        NorthKorea               : QLocale.Country = ... # 0x71
        RepublicOfKorea          : QLocale.Country = ... # 0x72
        SouthKorea               : QLocale.Country = ... # 0x72
        Kuwait                   : QLocale.Country = ... # 0x73
        Kyrgyzstan               : QLocale.Country = ... # 0x74
        Laos                     : QLocale.Country = ... # 0x75
        Latvia                   : QLocale.Country = ... # 0x76
        Lebanon                  : QLocale.Country = ... # 0x77
        Lesotho                  : QLocale.Country = ... # 0x78
        Liberia                  : QLocale.Country = ... # 0x79
        Libya                    : QLocale.Country = ... # 0x7a
        Liechtenstein            : QLocale.Country = ... # 0x7b
        Lithuania                : QLocale.Country = ... # 0x7c
        Luxembourg               : QLocale.Country = ... # 0x7d
        Macau                    : QLocale.Country = ... # 0x7e
        Macedonia                : QLocale.Country = ... # 0x7f
        Madagascar               : QLocale.Country = ... # 0x80
        Malawi                   : QLocale.Country = ... # 0x81
        Malaysia                 : QLocale.Country = ... # 0x82
        Maldives                 : QLocale.Country = ... # 0x83
        Mali                     : QLocale.Country = ... # 0x84
        Malta                    : QLocale.Country = ... # 0x85
        MarshallIslands          : QLocale.Country = ... # 0x86
        Martinique               : QLocale.Country = ... # 0x87
        Mauritania               : QLocale.Country = ... # 0x88
        Mauritius                : QLocale.Country = ... # 0x89
        Mayotte                  : QLocale.Country = ... # 0x8a
        Mexico                   : QLocale.Country = ... # 0x8b
        Micronesia               : QLocale.Country = ... # 0x8c
        Moldova                  : QLocale.Country = ... # 0x8d
        Monaco                   : QLocale.Country = ... # 0x8e
        Mongolia                 : QLocale.Country = ... # 0x8f
        Montserrat               : QLocale.Country = ... # 0x90
        Morocco                  : QLocale.Country = ... # 0x91
        Mozambique               : QLocale.Country = ... # 0x92
        Myanmar                  : QLocale.Country = ... # 0x93
        Namibia                  : QLocale.Country = ... # 0x94
        NauruCountry             : QLocale.Country = ... # 0x95
        Nepal                    : QLocale.Country = ... # 0x96
        Netherlands              : QLocale.Country = ... # 0x97
        CuraSao                  : QLocale.Country = ... # 0x98
        NewCaledonia             : QLocale.Country = ... # 0x99
        NewZealand               : QLocale.Country = ... # 0x9a
        Nicaragua                : QLocale.Country = ... # 0x9b
        Niger                    : QLocale.Country = ... # 0x9c
        Nigeria                  : QLocale.Country = ... # 0x9d
        Niue                     : QLocale.Country = ... # 0x9e
        NorfolkIsland            : QLocale.Country = ... # 0x9f
        NorthernMarianaIslands   : QLocale.Country = ... # 0xa0
        Norway                   : QLocale.Country = ... # 0xa1
        Oman                     : QLocale.Country = ... # 0xa2
        Pakistan                 : QLocale.Country = ... # 0xa3
        Palau                    : QLocale.Country = ... # 0xa4
        PalestinianTerritories   : QLocale.Country = ... # 0xa5
        Panama                   : QLocale.Country = ... # 0xa6
        PapuaNewGuinea           : QLocale.Country = ... # 0xa7
        Paraguay                 : QLocale.Country = ... # 0xa8
        Peru                     : QLocale.Country = ... # 0xa9
        Philippines              : QLocale.Country = ... # 0xaa
        Pitcairn                 : QLocale.Country = ... # 0xab
        Poland                   : QLocale.Country = ... # 0xac
        Portugal                 : QLocale.Country = ... # 0xad
        PuertoRico               : QLocale.Country = ... # 0xae
        Qatar                    : QLocale.Country = ... # 0xaf
        Reunion                  : QLocale.Country = ... # 0xb0
        Romania                  : QLocale.Country = ... # 0xb1
        Russia                   : QLocale.Country = ... # 0xb2
        RussianFederation        : QLocale.Country = ... # 0xb2
        Rwanda                   : QLocale.Country = ... # 0xb3
        SaintKittsAndNevis       : QLocale.Country = ... # 0xb4
        SaintLucia               : QLocale.Country = ... # 0xb5
        SaintVincentAndTheGrenadines: QLocale.Country = ... # 0xb6
        Samoa                    : QLocale.Country = ... # 0xb7
        SanMarino                : QLocale.Country = ... # 0xb8
        SaoTomeAndPrincipe       : QLocale.Country = ... # 0xb9
        SaudiArabia              : QLocale.Country = ... # 0xba
        Senegal                  : QLocale.Country = ... # 0xbb
        Seychelles               : QLocale.Country = ... # 0xbc
        SierraLeone              : QLocale.Country = ... # 0xbd
        Singapore                : QLocale.Country = ... # 0xbe
        Slovakia                 : QLocale.Country = ... # 0xbf
        Slovenia                 : QLocale.Country = ... # 0xc0
        SolomonIslands           : QLocale.Country = ... # 0xc1
        Somalia                  : QLocale.Country = ... # 0xc2
        SouthAfrica              : QLocale.Country = ... # 0xc3
        SouthGeorgiaAndTheSouthSandwichIslands: QLocale.Country = ... # 0xc4
        Spain                    : QLocale.Country = ... # 0xc5
        SriLanka                 : QLocale.Country = ... # 0xc6
        SaintHelena              : QLocale.Country = ... # 0xc7
        SaintPierreAndMiquelon   : QLocale.Country = ... # 0xc8
        Sudan                    : QLocale.Country = ... # 0xc9
        Suriname                 : QLocale.Country = ... # 0xca
        SvalbardAndJanMayenIslands: QLocale.Country = ... # 0xcb
        Swaziland                : QLocale.Country = ... # 0xcc
        Sweden                   : QLocale.Country = ... # 0xcd
        Switzerland              : QLocale.Country = ... # 0xce
        Syria                    : QLocale.Country = ... # 0xcf
        SyrianArabRepublic       : QLocale.Country = ... # 0xcf
        Taiwan                   : QLocale.Country = ... # 0xd0
        Tajikistan               : QLocale.Country = ... # 0xd1
        Tanzania                 : QLocale.Country = ... # 0xd2
        Thailand                 : QLocale.Country = ... # 0xd3
        Togo                     : QLocale.Country = ... # 0xd4
        Tokelau                  : QLocale.Country = ... # 0xd5
        TokelauCountry           : QLocale.Country = ... # 0xd5
        Tonga                    : QLocale.Country = ... # 0xd6
        TrinidadAndTobago        : QLocale.Country = ... # 0xd7
        Tunisia                  : QLocale.Country = ... # 0xd8
        Turkey                   : QLocale.Country = ... # 0xd9
        Turkmenistan             : QLocale.Country = ... # 0xda
        TurksAndCaicosIslands    : QLocale.Country = ... # 0xdb
        Tuvalu                   : QLocale.Country = ... # 0xdc
        TuvaluCountry            : QLocale.Country = ... # 0xdc
        Uganda                   : QLocale.Country = ... # 0xdd
        Ukraine                  : QLocale.Country = ... # 0xde
        UnitedArabEmirates       : QLocale.Country = ... # 0xdf
        UnitedKingdom            : QLocale.Country = ... # 0xe0
        UnitedStates             : QLocale.Country = ... # 0xe1
        UnitedStatesMinorOutlyingIslands: QLocale.Country = ... # 0xe2
        Uruguay                  : QLocale.Country = ... # 0xe3
        Uzbekistan               : QLocale.Country = ... # 0xe4
        Vanuatu                  : QLocale.Country = ... # 0xe5
        VaticanCityState         : QLocale.Country = ... # 0xe6
        Venezuela                : QLocale.Country = ... # 0xe7
        Vietnam                  : QLocale.Country = ... # 0xe8
        BritishVirginIslands     : QLocale.Country = ... # 0xe9
        UnitedStatesVirginIslands: QLocale.Country = ... # 0xea
        WallisAndFutunaIslands   : QLocale.Country = ... # 0xeb
        WesternSahara            : QLocale.Country = ... # 0xec
        Yemen                    : QLocale.Country = ... # 0xed
        CanaryIslands            : QLocale.Country = ... # 0xee
        Zambia                   : QLocale.Country = ... # 0xef
        Zimbabwe                 : QLocale.Country = ... # 0xf0
        ClippertonIsland         : QLocale.Country = ... # 0xf1
        Montenegro               : QLocale.Country = ... # 0xf2
        Serbia                   : QLocale.Country = ... # 0xf3
        SaintBarthelemy          : QLocale.Country = ... # 0xf4
        SaintMartin              : QLocale.Country = ... # 0xf5
        LatinAmerica             : QLocale.Country = ... # 0xf6
        LatinAmericaAndTheCaribbean: QLocale.Country = ... # 0xf6
        AscensionIsland          : QLocale.Country = ... # 0xf7
        AlandIslands             : QLocale.Country = ... # 0xf8
        DiegoGarcia              : QLocale.Country = ... # 0xf9
        CeutaAndMelilla          : QLocale.Country = ... # 0xfa
        IsleOfMan                : QLocale.Country = ... # 0xfb
        Jersey                   : QLocale.Country = ... # 0xfc
        TristanDaCunha           : QLocale.Country = ... # 0xfd
        SouthSudan               : QLocale.Country = ... # 0xfe
        Bonaire                  : QLocale.Country = ... # 0xff
        SintMaarten              : QLocale.Country = ... # 0x100
        Kosovo                   : QLocale.Country = ... # 0x101
        EuropeanUnion            : QLocale.Country = ... # 0x102
        OutlyingOceania          : QLocale.Country = ... # 0x103
        World                    : QLocale.Country = ... # 0x104
        Europe                   : QLocale.Country = ... # 0x105
        LastCountry              : QLocale.Country = ... # 0x105

    class CurrencySymbolFormat(Shiboken.Enum):
        CurrencyIsoCode          : QLocale.CurrencySymbolFormat = ... # 0x0
        CurrencySymbol           : QLocale.CurrencySymbolFormat = ... # 0x1
        CurrencyDisplayName      : QLocale.CurrencySymbolFormat = ... # 0x2

    class DataSizeFormat(Shiboken.Enum):
        DataSizeIecFormat        : QLocale.DataSizeFormat = ... # 0x0
        DataSizeBase1000         : QLocale.DataSizeFormat = ... # 0x1
        DataSizeSIQuantifiers    : QLocale.DataSizeFormat = ... # 0x2
        DataSizeTraditionalFormat: QLocale.DataSizeFormat = ... # 0x2
        DataSizeSIFormat         : QLocale.DataSizeFormat = ... # 0x3

    class DataSizeFormats(object): ...

    class FloatingPointPrecisionOption(Shiboken.Enum):
        FloatingPointShortest    : QLocale.FloatingPointPrecisionOption = ... # -0x80

    class FormatType(Shiboken.Enum):
        LongFormat               : QLocale.FormatType = ... # 0x0
        ShortFormat              : QLocale.FormatType = ... # 0x1
        NarrowFormat             : QLocale.FormatType = ... # 0x2

    class Language(Shiboken.Enum):
        AnyLanguage              : QLocale.Language = ... # 0x0
        C                        : QLocale.Language = ... # 0x1
        Abkhazian                : QLocale.Language = ... # 0x2
        Afan                     : QLocale.Language = ... # 0x3
        Oromo                    : QLocale.Language = ... # 0x3
        Afar                     : QLocale.Language = ... # 0x4
        Afrikaans                : QLocale.Language = ... # 0x5
        Albanian                 : QLocale.Language = ... # 0x6
        Amharic                  : QLocale.Language = ... # 0x7
        Arabic                   : QLocale.Language = ... # 0x8
        Armenian                 : QLocale.Language = ... # 0x9
        Assamese                 : QLocale.Language = ... # 0xa
        Aymara                   : QLocale.Language = ... # 0xb
        Azerbaijani              : QLocale.Language = ... # 0xc
        Bashkir                  : QLocale.Language = ... # 0xd
        Basque                   : QLocale.Language = ... # 0xe
        Bengali                  : QLocale.Language = ... # 0xf
        Bhutani                  : QLocale.Language = ... # 0x10
        Dzongkha                 : QLocale.Language = ... # 0x10
        Bihari                   : QLocale.Language = ... # 0x11
        Bislama                  : QLocale.Language = ... # 0x12
        Breton                   : QLocale.Language = ... # 0x13
        Bulgarian                : QLocale.Language = ... # 0x14
        Burmese                  : QLocale.Language = ... # 0x15
        Belarusian               : QLocale.Language = ... # 0x16
        Byelorussian             : QLocale.Language = ... # 0x16
        Cambodian                : QLocale.Language = ... # 0x17
        Khmer                    : QLocale.Language = ... # 0x17
        Catalan                  : QLocale.Language = ... # 0x18
        Chinese                  : QLocale.Language = ... # 0x19
        Corsican                 : QLocale.Language = ... # 0x1a
        Croatian                 : QLocale.Language = ... # 0x1b
        Czech                    : QLocale.Language = ... # 0x1c
        Danish                   : QLocale.Language = ... # 0x1d
        Dutch                    : QLocale.Language = ... # 0x1e
        English                  : QLocale.Language = ... # 0x1f
        Esperanto                : QLocale.Language = ... # 0x20
        Estonian                 : QLocale.Language = ... # 0x21
        Faroese                  : QLocale.Language = ... # 0x22
        Fijian                   : QLocale.Language = ... # 0x23
        Finnish                  : QLocale.Language = ... # 0x24
        French                   : QLocale.Language = ... # 0x25
        Frisian                  : QLocale.Language = ... # 0x26
        WesternFrisian           : QLocale.Language = ... # 0x26
        Gaelic                   : QLocale.Language = ... # 0x27
        Galician                 : QLocale.Language = ... # 0x28
        Georgian                 : QLocale.Language = ... # 0x29
        German                   : QLocale.Language = ... # 0x2a
        Greek                    : QLocale.Language = ... # 0x2b
        Greenlandic              : QLocale.Language = ... # 0x2c
        Guarani                  : QLocale.Language = ... # 0x2d
        Gujarati                 : QLocale.Language = ... # 0x2e
        Hausa                    : QLocale.Language = ... # 0x2f
        Hebrew                   : QLocale.Language = ... # 0x30
        Hindi                    : QLocale.Language = ... # 0x31
        Hungarian                : QLocale.Language = ... # 0x32
        Icelandic                : QLocale.Language = ... # 0x33
        Indonesian               : QLocale.Language = ... # 0x34
        Interlingua              : QLocale.Language = ... # 0x35
        Interlingue              : QLocale.Language = ... # 0x36
        Inuktitut                : QLocale.Language = ... # 0x37
        Inupiak                  : QLocale.Language = ... # 0x38
        Irish                    : QLocale.Language = ... # 0x39
        Italian                  : QLocale.Language = ... # 0x3a
        Japanese                 : QLocale.Language = ... # 0x3b
        Javanese                 : QLocale.Language = ... # 0x3c
        Kannada                  : QLocale.Language = ... # 0x3d
        Kashmiri                 : QLocale.Language = ... # 0x3e
        Kazakh                   : QLocale.Language = ... # 0x3f
        Kinyarwanda              : QLocale.Language = ... # 0x40
        Kirghiz                  : QLocale.Language = ... # 0x41
        Korean                   : QLocale.Language = ... # 0x42
        Kurdish                  : QLocale.Language = ... # 0x43
        Kurundi                  : QLocale.Language = ... # 0x44
        Rundi                    : QLocale.Language = ... # 0x44
        Lao                      : QLocale.Language = ... # 0x45
        Latin                    : QLocale.Language = ... # 0x46
        Latvian                  : QLocale.Language = ... # 0x47
        Lingala                  : QLocale.Language = ... # 0x48
        Lithuanian               : QLocale.Language = ... # 0x49
        Macedonian               : QLocale.Language = ... # 0x4a
        Malagasy                 : QLocale.Language = ... # 0x4b
        Malay                    : QLocale.Language = ... # 0x4c
        Malayalam                : QLocale.Language = ... # 0x4d
        Maltese                  : QLocale.Language = ... # 0x4e
        Maori                    : QLocale.Language = ... # 0x4f
        Marathi                  : QLocale.Language = ... # 0x50
        Marshallese              : QLocale.Language = ... # 0x51
        Mongolian                : QLocale.Language = ... # 0x52
        NauruLanguage            : QLocale.Language = ... # 0x53
        Nepali                   : QLocale.Language = ... # 0x54
        Norwegian                : QLocale.Language = ... # 0x55
        NorwegianBokmal          : QLocale.Language = ... # 0x55
        Occitan                  : QLocale.Language = ... # 0x56
        Oriya                    : QLocale.Language = ... # 0x57
        Pashto                   : QLocale.Language = ... # 0x58
        Persian                  : QLocale.Language = ... # 0x59
        Polish                   : QLocale.Language = ... # 0x5a
        Portuguese               : QLocale.Language = ... # 0x5b
        Punjabi                  : QLocale.Language = ... # 0x5c
        Quechua                  : QLocale.Language = ... # 0x5d
        RhaetoRomance            : QLocale.Language = ... # 0x5e
        Romansh                  : QLocale.Language = ... # 0x5e
        Moldavian                : QLocale.Language = ... # 0x5f
        Romanian                 : QLocale.Language = ... # 0x5f
        Russian                  : QLocale.Language = ... # 0x60
        Samoan                   : QLocale.Language = ... # 0x61
        Sango                    : QLocale.Language = ... # 0x62
        Sanskrit                 : QLocale.Language = ... # 0x63
        Serbian                  : QLocale.Language = ... # 0x64
        SerboCroatian            : QLocale.Language = ... # 0x64
        Ossetic                  : QLocale.Language = ... # 0x65
        SouthernSotho            : QLocale.Language = ... # 0x66
        Tswana                   : QLocale.Language = ... # 0x67
        Shona                    : QLocale.Language = ... # 0x68
        Sindhi                   : QLocale.Language = ... # 0x69
        Sinhala                  : QLocale.Language = ... # 0x6a
        Swati                    : QLocale.Language = ... # 0x6b
        Slovak                   : QLocale.Language = ... # 0x6c
        Slovenian                : QLocale.Language = ... # 0x6d
        Somali                   : QLocale.Language = ... # 0x6e
        Spanish                  : QLocale.Language = ... # 0x6f
        Sundanese                : QLocale.Language = ... # 0x70
        Swahili                  : QLocale.Language = ... # 0x71
        Swedish                  : QLocale.Language = ... # 0x72
        Sardinian                : QLocale.Language = ... # 0x73
        Tajik                    : QLocale.Language = ... # 0x74
        Tamil                    : QLocale.Language = ... # 0x75
        Tatar                    : QLocale.Language = ... # 0x76
        Telugu                   : QLocale.Language = ... # 0x77
        Thai                     : QLocale.Language = ... # 0x78
        Tibetan                  : QLocale.Language = ... # 0x79
        Tigrinya                 : QLocale.Language = ... # 0x7a
        Tongan                   : QLocale.Language = ... # 0x7b
        Tsonga                   : QLocale.Language = ... # 0x7c
        Turkish                  : QLocale.Language = ... # 0x7d
        Turkmen                  : QLocale.Language = ... # 0x7e
        Tahitian                 : QLocale.Language = ... # 0x7f
        Uighur                   : QLocale.Language = ... # 0x80
        Uigur                    : QLocale.Language = ... # 0x80
        Ukrainian                : QLocale.Language = ... # 0x81
        Urdu                     : QLocale.Language = ... # 0x82
        Uzbek                    : QLocale.Language = ... # 0x83
        Vietnamese               : QLocale.Language = ... # 0x84
        Volapuk                  : QLocale.Language = ... # 0x85
        Welsh                    : QLocale.Language = ... # 0x86
        Wolof                    : QLocale.Language = ... # 0x87
        Xhosa                    : QLocale.Language = ... # 0x88
        Yiddish                  : QLocale.Language = ... # 0x89
        Yoruba                   : QLocale.Language = ... # 0x8a
        Zhuang                   : QLocale.Language = ... # 0x8b
        Zulu                     : QLocale.Language = ... # 0x8c
        NorwegianNynorsk         : QLocale.Language = ... # 0x8d
        Bosnian                  : QLocale.Language = ... # 0x8e
        Divehi                   : QLocale.Language = ... # 0x8f
        Manx                     : QLocale.Language = ... # 0x90
        Cornish                  : QLocale.Language = ... # 0x91
        Akan                     : QLocale.Language = ... # 0x92
        Twi                      : QLocale.Language = ... # 0x92
        Konkani                  : QLocale.Language = ... # 0x93
        Ga                       : QLocale.Language = ... # 0x94
        Igbo                     : QLocale.Language = ... # 0x95
        Kamba                    : QLocale.Language = ... # 0x96
        Syriac                   : QLocale.Language = ... # 0x97
        Blin                     : QLocale.Language = ... # 0x98
        Geez                     : QLocale.Language = ... # 0x99
        Koro                     : QLocale.Language = ... # 0x9a
        Sidamo                   : QLocale.Language = ... # 0x9b
        Atsam                    : QLocale.Language = ... # 0x9c
        Tigre                    : QLocale.Language = ... # 0x9d
        Jju                      : QLocale.Language = ... # 0x9e
        Friulian                 : QLocale.Language = ... # 0x9f
        Venda                    : QLocale.Language = ... # 0xa0
        Ewe                      : QLocale.Language = ... # 0xa1
        Walamo                   : QLocale.Language = ... # 0xa2
        Hawaiian                 : QLocale.Language = ... # 0xa3
        Tyap                     : QLocale.Language = ... # 0xa4
        Chewa                    : QLocale.Language = ... # 0xa5
        Nyanja                   : QLocale.Language = ... # 0xa5
        Filipino                 : QLocale.Language = ... # 0xa6
        Tagalog                  : QLocale.Language = ... # 0xa6
        SwissGerman              : QLocale.Language = ... # 0xa7
        SichuanYi                : QLocale.Language = ... # 0xa8
        Kpelle                   : QLocale.Language = ... # 0xa9
        LowGerman                : QLocale.Language = ... # 0xaa
        SouthNdebele             : QLocale.Language = ... # 0xab
        NorthernSotho            : QLocale.Language = ... # 0xac
        NorthernSami             : QLocale.Language = ... # 0xad
        Taroko                   : QLocale.Language = ... # 0xae
        Gusii                    : QLocale.Language = ... # 0xaf
        Taita                    : QLocale.Language = ... # 0xb0
        Fulah                    : QLocale.Language = ... # 0xb1
        Kikuyu                   : QLocale.Language = ... # 0xb2
        Samburu                  : QLocale.Language = ... # 0xb3
        Sena                     : QLocale.Language = ... # 0xb4
        NorthNdebele             : QLocale.Language = ... # 0xb5
        Rombo                    : QLocale.Language = ... # 0xb6
        Tachelhit                : QLocale.Language = ... # 0xb7
        Kabyle                   : QLocale.Language = ... # 0xb8
        Nyankole                 : QLocale.Language = ... # 0xb9
        Bena                     : QLocale.Language = ... # 0xba
        Vunjo                    : QLocale.Language = ... # 0xbb
        Bambara                  : QLocale.Language = ... # 0xbc
        Embu                     : QLocale.Language = ... # 0xbd
        Cherokee                 : QLocale.Language = ... # 0xbe
        Morisyen                 : QLocale.Language = ... # 0xbf
        Makonde                  : QLocale.Language = ... # 0xc0
        Langi                    : QLocale.Language = ... # 0xc1
        Ganda                    : QLocale.Language = ... # 0xc2
        Bemba                    : QLocale.Language = ... # 0xc3
        Kabuverdianu             : QLocale.Language = ... # 0xc4
        Meru                     : QLocale.Language = ... # 0xc5
        Kalenjin                 : QLocale.Language = ... # 0xc6
        Nama                     : QLocale.Language = ... # 0xc7
        Machame                  : QLocale.Language = ... # 0xc8
        Colognian                : QLocale.Language = ... # 0xc9
        Masai                    : QLocale.Language = ... # 0xca
        Soga                     : QLocale.Language = ... # 0xcb
        Luyia                    : QLocale.Language = ... # 0xcc
        Asu                      : QLocale.Language = ... # 0xcd
        Teso                     : QLocale.Language = ... # 0xce
        Saho                     : QLocale.Language = ... # 0xcf
        KoyraChiini              : QLocale.Language = ... # 0xd0
        Rwa                      : QLocale.Language = ... # 0xd1
        Luo                      : QLocale.Language = ... # 0xd2
        Chiga                    : QLocale.Language = ... # 0xd3
        CentralMoroccoTamazight  : QLocale.Language = ... # 0xd4
        KoyraboroSenni           : QLocale.Language = ... # 0xd5
        Shambala                 : QLocale.Language = ... # 0xd6
        Bodo                     : QLocale.Language = ... # 0xd7
        Avaric                   : QLocale.Language = ... # 0xd8
        Chamorro                 : QLocale.Language = ... # 0xd9
        Chechen                  : QLocale.Language = ... # 0xda
        Church                   : QLocale.Language = ... # 0xdb
        Chuvash                  : QLocale.Language = ... # 0xdc
        Cree                     : QLocale.Language = ... # 0xdd
        Haitian                  : QLocale.Language = ... # 0xde
        Herero                   : QLocale.Language = ... # 0xdf
        HiriMotu                 : QLocale.Language = ... # 0xe0
        Kanuri                   : QLocale.Language = ... # 0xe1
        Komi                     : QLocale.Language = ... # 0xe2
        Kongo                    : QLocale.Language = ... # 0xe3
        Kwanyama                 : QLocale.Language = ... # 0xe4
        Limburgish               : QLocale.Language = ... # 0xe5
        LubaKatanga              : QLocale.Language = ... # 0xe6
        Luxembourgish            : QLocale.Language = ... # 0xe7
        Navaho                   : QLocale.Language = ... # 0xe8
        Ndonga                   : QLocale.Language = ... # 0xe9
        Ojibwa                   : QLocale.Language = ... # 0xea
        Pali                     : QLocale.Language = ... # 0xeb
        Walloon                  : QLocale.Language = ... # 0xec
        Aghem                    : QLocale.Language = ... # 0xed
        Basaa                    : QLocale.Language = ... # 0xee
        Zarma                    : QLocale.Language = ... # 0xef
        Duala                    : QLocale.Language = ... # 0xf0
        JolaFonyi                : QLocale.Language = ... # 0xf1
        Ewondo                   : QLocale.Language = ... # 0xf2
        Bafia                    : QLocale.Language = ... # 0xf3
        MakhuwaMeetto            : QLocale.Language = ... # 0xf4
        Mundang                  : QLocale.Language = ... # 0xf5
        Kwasio                   : QLocale.Language = ... # 0xf6
        Nuer                     : QLocale.Language = ... # 0xf7
        Sakha                    : QLocale.Language = ... # 0xf8
        Sangu                    : QLocale.Language = ... # 0xf9
        CongoSwahili             : QLocale.Language = ... # 0xfa
        Tasawaq                  : QLocale.Language = ... # 0xfb
        Vai                      : QLocale.Language = ... # 0xfc
        Walser                   : QLocale.Language = ... # 0xfd
        Yangben                  : QLocale.Language = ... # 0xfe
        Avestan                  : QLocale.Language = ... # 0xff
        Asturian                 : QLocale.Language = ... # 0x100
        Ngomba                   : QLocale.Language = ... # 0x101
        Kako                     : QLocale.Language = ... # 0x102
        Meta                     : QLocale.Language = ... # 0x103
        Ngiemboon                : QLocale.Language = ... # 0x104
        Aragonese                : QLocale.Language = ... # 0x105
        Akkadian                 : QLocale.Language = ... # 0x106
        AncientEgyptian          : QLocale.Language = ... # 0x107
        AncientGreek             : QLocale.Language = ... # 0x108
        Aramaic                  : QLocale.Language = ... # 0x109
        Balinese                 : QLocale.Language = ... # 0x10a
        Bamun                    : QLocale.Language = ... # 0x10b
        BatakToba                : QLocale.Language = ... # 0x10c
        Buginese                 : QLocale.Language = ... # 0x10d
        Buhid                    : QLocale.Language = ... # 0x10e
        Carian                   : QLocale.Language = ... # 0x10f
        Chakma                   : QLocale.Language = ... # 0x110
        ClassicalMandaic         : QLocale.Language = ... # 0x111
        Coptic                   : QLocale.Language = ... # 0x112
        Dogri                    : QLocale.Language = ... # 0x113
        EasternCham              : QLocale.Language = ... # 0x114
        EasternKayah             : QLocale.Language = ... # 0x115
        Etruscan                 : QLocale.Language = ... # 0x116
        Gothic                   : QLocale.Language = ... # 0x117
        Hanunoo                  : QLocale.Language = ... # 0x118
        Ingush                   : QLocale.Language = ... # 0x119
        LargeFloweryMiao         : QLocale.Language = ... # 0x11a
        Lepcha                   : QLocale.Language = ... # 0x11b
        Limbu                    : QLocale.Language = ... # 0x11c
        Lisu                     : QLocale.Language = ... # 0x11d
        Lu                       : QLocale.Language = ... # 0x11e
        Lycian                   : QLocale.Language = ... # 0x11f
        Lydian                   : QLocale.Language = ... # 0x120
        Mandingo                 : QLocale.Language = ... # 0x121
        Manipuri                 : QLocale.Language = ... # 0x122
        Meroitic                 : QLocale.Language = ... # 0x123
        NorthernThai             : QLocale.Language = ... # 0x124
        OldIrish                 : QLocale.Language = ... # 0x125
        OldNorse                 : QLocale.Language = ... # 0x126
        OldPersian               : QLocale.Language = ... # 0x127
        OldTurkish               : QLocale.Language = ... # 0x128
        Pahlavi                  : QLocale.Language = ... # 0x129
        Parthian                 : QLocale.Language = ... # 0x12a
        Phoenician               : QLocale.Language = ... # 0x12b
        PrakritLanguage          : QLocale.Language = ... # 0x12c
        Rejang                   : QLocale.Language = ... # 0x12d
        Sabaean                  : QLocale.Language = ... # 0x12e
        Samaritan                : QLocale.Language = ... # 0x12f
        Santali                  : QLocale.Language = ... # 0x130
        Saurashtra               : QLocale.Language = ... # 0x131
        Sora                     : QLocale.Language = ... # 0x132
        Sylheti                  : QLocale.Language = ... # 0x133
        Tagbanwa                 : QLocale.Language = ... # 0x134
        TaiDam                   : QLocale.Language = ... # 0x135
        TaiNua                   : QLocale.Language = ... # 0x136
        Ugaritic                 : QLocale.Language = ... # 0x137
        Akoose                   : QLocale.Language = ... # 0x138
        Lakota                   : QLocale.Language = ... # 0x139
        StandardMoroccanTamazight: QLocale.Language = ... # 0x13a
        Mapuche                  : QLocale.Language = ... # 0x13b
        CentralKurdish           : QLocale.Language = ... # 0x13c
        LowerSorbian             : QLocale.Language = ... # 0x13d
        UpperSorbian             : QLocale.Language = ... # 0x13e
        Kenyang                  : QLocale.Language = ... # 0x13f
        Mohawk                   : QLocale.Language = ... # 0x140
        Nko                      : QLocale.Language = ... # 0x141
        Prussian                 : QLocale.Language = ... # 0x142
        Kiche                    : QLocale.Language = ... # 0x143
        SouthernSami             : QLocale.Language = ... # 0x144
        LuleSami                 : QLocale.Language = ... # 0x145
        InariSami                : QLocale.Language = ... # 0x146
        SkoltSami                : QLocale.Language = ... # 0x147
        Warlpiri                 : QLocale.Language = ... # 0x148
        ManichaeanMiddlePersian  : QLocale.Language = ... # 0x149
        Mende                    : QLocale.Language = ... # 0x14a
        AncientNorthArabian      : QLocale.Language = ... # 0x14b
        LinearA                  : QLocale.Language = ... # 0x14c
        HmongNjua                : QLocale.Language = ... # 0x14d
        Ho                       : QLocale.Language = ... # 0x14e
        Lezghian                 : QLocale.Language = ... # 0x14f
        Bassa                    : QLocale.Language = ... # 0x150
        Mono                     : QLocale.Language = ... # 0x151
        TedimChin                : QLocale.Language = ... # 0x152
        Maithili                 : QLocale.Language = ... # 0x153
        Ahom                     : QLocale.Language = ... # 0x154
        AmericanSignLanguage     : QLocale.Language = ... # 0x155
        ArdhamagadhiPrakrit      : QLocale.Language = ... # 0x156
        Bhojpuri                 : QLocale.Language = ... # 0x157
        HieroglyphicLuwian       : QLocale.Language = ... # 0x158
        LiteraryChinese          : QLocale.Language = ... # 0x159
        Mazanderani              : QLocale.Language = ... # 0x15a
        Mru                      : QLocale.Language = ... # 0x15b
        Newari                   : QLocale.Language = ... # 0x15c
        NorthernLuri             : QLocale.Language = ... # 0x15d
        Palauan                  : QLocale.Language = ... # 0x15e
        Papiamento               : QLocale.Language = ... # 0x15f
        Saraiki                  : QLocale.Language = ... # 0x160
        TokelauLanguage          : QLocale.Language = ... # 0x161
        TokPisin                 : QLocale.Language = ... # 0x162
        TuvaluLanguage           : QLocale.Language = ... # 0x163
        UncodedLanguages         : QLocale.Language = ... # 0x164
        Cantonese                : QLocale.Language = ... # 0x165
        Osage                    : QLocale.Language = ... # 0x166
        Tangut                   : QLocale.Language = ... # 0x167
        Ido                      : QLocale.Language = ... # 0x168
        Lojban                   : QLocale.Language = ... # 0x169
        Sicilian                 : QLocale.Language = ... # 0x16a
        SouthernKurdish          : QLocale.Language = ... # 0x16b
        WesternBalochi           : QLocale.Language = ... # 0x16c
        Cebuano                  : QLocale.Language = ... # 0x16d
        Erzya                    : QLocale.Language = ... # 0x16e
        Chickasaw                : QLocale.Language = ... # 0x16f
        Muscogee                 : QLocale.Language = ... # 0x170
        Silesian                 : QLocale.Language = ... # 0x171
        LastLanguage             : QLocale.Language = ... # 0x172
        NigerianPidgin           : QLocale.Language = ... # 0x172

    class MeasurementSystem(Shiboken.Enum):
        MetricSystem             : QLocale.MeasurementSystem = ... # 0x0
        ImperialSystem           : QLocale.MeasurementSystem = ... # 0x1
        ImperialUSSystem         : QLocale.MeasurementSystem = ... # 0x1
        ImperialUKSystem         : QLocale.MeasurementSystem = ... # 0x2

    class NumberOption(Shiboken.Enum):
        DefaultNumberOptions     : QLocale.NumberOption = ... # 0x0
        OmitGroupSeparator       : QLocale.NumberOption = ... # 0x1
        RejectGroupSeparator     : QLocale.NumberOption = ... # 0x2
        OmitLeadingZeroInExponent: QLocale.NumberOption = ... # 0x4
        RejectLeadingZeroInExponent: QLocale.NumberOption = ... # 0x8
        IncludeTrailingZeroesAfterDot: QLocale.NumberOption = ... # 0x10
        RejectTrailingZeroesAfterDot: QLocale.NumberOption = ... # 0x20

    class NumberOptions(object): ...

    class QuotationStyle(Shiboken.Enum):
        StandardQuotation        : QLocale.QuotationStyle = ... # 0x0
        AlternateQuotation       : QLocale.QuotationStyle = ... # 0x1

    class Script(Shiboken.Enum):
        AnyScript                : QLocale.Script = ... # 0x0
        ArabicScript             : QLocale.Script = ... # 0x1
        CyrillicScript           : QLocale.Script = ... # 0x2
        DeseretScript            : QLocale.Script = ... # 0x3
        GurmukhiScript           : QLocale.Script = ... # 0x4
        SimplifiedChineseScript  : QLocale.Script = ... # 0x5
        SimplifiedHanScript      : QLocale.Script = ... # 0x5
        TraditionalChineseScript : QLocale.Script = ... # 0x6
        TraditionalHanScript     : QLocale.Script = ... # 0x6
        LatinScript              : QLocale.Script = ... # 0x7
        MongolianScript          : QLocale.Script = ... # 0x8
        TifinaghScript           : QLocale.Script = ... # 0x9
        ArmenianScript           : QLocale.Script = ... # 0xa
        BengaliScript            : QLocale.Script = ... # 0xb
        CherokeeScript           : QLocale.Script = ... # 0xc
        DevanagariScript         : QLocale.Script = ... # 0xd
        EthiopicScript           : QLocale.Script = ... # 0xe
        GeorgianScript           : QLocale.Script = ... # 0xf
        GreekScript              : QLocale.Script = ... # 0x10
        GujaratiScript           : QLocale.Script = ... # 0x11
        HebrewScript             : QLocale.Script = ... # 0x12
        JapaneseScript           : QLocale.Script = ... # 0x13
        KhmerScript              : QLocale.Script = ... # 0x14
        KannadaScript            : QLocale.Script = ... # 0x15
        KoreanScript             : QLocale.Script = ... # 0x16
        LaoScript                : QLocale.Script = ... # 0x17
        MalayalamScript          : QLocale.Script = ... # 0x18
        MyanmarScript            : QLocale.Script = ... # 0x19
        OriyaScript              : QLocale.Script = ... # 0x1a
        TamilScript              : QLocale.Script = ... # 0x1b
        TeluguScript             : QLocale.Script = ... # 0x1c
        ThaanaScript             : QLocale.Script = ... # 0x1d
        ThaiScript               : QLocale.Script = ... # 0x1e
        TibetanScript            : QLocale.Script = ... # 0x1f
        SinhalaScript            : QLocale.Script = ... # 0x20
        SyriacScript             : QLocale.Script = ... # 0x21
        YiScript                 : QLocale.Script = ... # 0x22
        VaiScript                : QLocale.Script = ... # 0x23
        AvestanScript            : QLocale.Script = ... # 0x24
        BalineseScript           : QLocale.Script = ... # 0x25
        BamumScript              : QLocale.Script = ... # 0x26
        BatakScript              : QLocale.Script = ... # 0x27
        BopomofoScript           : QLocale.Script = ... # 0x28
        BrahmiScript             : QLocale.Script = ... # 0x29
        BugineseScript           : QLocale.Script = ... # 0x2a
        BuhidScript              : QLocale.Script = ... # 0x2b
        CanadianAboriginalScript : QLocale.Script = ... # 0x2c
        CarianScript             : QLocale.Script = ... # 0x2d
        ChakmaScript             : QLocale.Script = ... # 0x2e
        ChamScript               : QLocale.Script = ... # 0x2f
        CopticScript             : QLocale.Script = ... # 0x30
        CypriotScript            : QLocale.Script = ... # 0x31
        EgyptianHieroglyphsScript: QLocale.Script = ... # 0x32
        FraserScript             : QLocale.Script = ... # 0x33
        GlagoliticScript         : QLocale.Script = ... # 0x34
        GothicScript             : QLocale.Script = ... # 0x35
        HanScript                : QLocale.Script = ... # 0x36
        HangulScript             : QLocale.Script = ... # 0x37
        HanunooScript            : QLocale.Script = ... # 0x38
        ImperialAramaicScript    : QLocale.Script = ... # 0x39
        InscriptionalPahlaviScript: QLocale.Script = ... # 0x3a
        InscriptionalParthianScript: QLocale.Script = ... # 0x3b
        JavaneseScript           : QLocale.Script = ... # 0x3c
        KaithiScript             : QLocale.Script = ... # 0x3d
        KatakanaScript           : QLocale.Script = ... # 0x3e
        KayahLiScript            : QLocale.Script = ... # 0x3f
        KharoshthiScript         : QLocale.Script = ... # 0x40
        LannaScript              : QLocale.Script = ... # 0x41
        LepchaScript             : QLocale.Script = ... # 0x42
        LimbuScript              : QLocale.Script = ... # 0x43
        LinearBScript            : QLocale.Script = ... # 0x44
        LycianScript             : QLocale.Script = ... # 0x45
        LydianScript             : QLocale.Script = ... # 0x46
        MandaeanScript           : QLocale.Script = ... # 0x47
        MeiteiMayekScript        : QLocale.Script = ... # 0x48
        MeroiticScript           : QLocale.Script = ... # 0x49
        MeroiticCursiveScript    : QLocale.Script = ... # 0x4a
        NkoScript                : QLocale.Script = ... # 0x4b
        NewTaiLueScript          : QLocale.Script = ... # 0x4c
        OghamScript              : QLocale.Script = ... # 0x4d
        OlChikiScript            : QLocale.Script = ... # 0x4e
        OldItalicScript          : QLocale.Script = ... # 0x4f
        OldPersianScript         : QLocale.Script = ... # 0x50
        OldSouthArabianScript    : QLocale.Script = ... # 0x51
        OrkhonScript             : QLocale.Script = ... # 0x52
        OsmanyaScript            : QLocale.Script = ... # 0x53
        PhagsPaScript            : QLocale.Script = ... # 0x54
        PhoenicianScript         : QLocale.Script = ... # 0x55
        PollardPhoneticScript    : QLocale.Script = ... # 0x56
        RejangScript             : QLocale.Script = ... # 0x57
        RunicScript              : QLocale.Script = ... # 0x58
        SamaritanScript          : QLocale.Script = ... # 0x59
        SaurashtraScript         : QLocale.Script = ... # 0x5a
        SharadaScript            : QLocale.Script = ... # 0x5b
        ShavianScript            : QLocale.Script = ... # 0x5c
        SoraSompengScript        : QLocale.Script = ... # 0x5d
        CuneiformScript          : QLocale.Script = ... # 0x5e
        SundaneseScript          : QLocale.Script = ... # 0x5f
        SylotiNagriScript        : QLocale.Script = ... # 0x60
        TagalogScript            : QLocale.Script = ... # 0x61
        TagbanwaScript           : QLocale.Script = ... # 0x62
        TaiLeScript              : QLocale.Script = ... # 0x63
        TaiVietScript            : QLocale.Script = ... # 0x64
        TakriScript              : QLocale.Script = ... # 0x65
        UgariticScript           : QLocale.Script = ... # 0x66
        BrailleScript            : QLocale.Script = ... # 0x67
        HiraganaScript           : QLocale.Script = ... # 0x68
        CaucasianAlbanianScript  : QLocale.Script = ... # 0x69
        BassaVahScript           : QLocale.Script = ... # 0x6a
        DuployanScript           : QLocale.Script = ... # 0x6b
        ElbasanScript            : QLocale.Script = ... # 0x6c
        GranthaScript            : QLocale.Script = ... # 0x6d
        PahawhHmongScript        : QLocale.Script = ... # 0x6e
        KhojkiScript             : QLocale.Script = ... # 0x6f
        LinearAScript            : QLocale.Script = ... # 0x70
        MahajaniScript           : QLocale.Script = ... # 0x71
        ManichaeanScript         : QLocale.Script = ... # 0x72
        MendeKikakuiScript       : QLocale.Script = ... # 0x73
        ModiScript               : QLocale.Script = ... # 0x74
        MroScript                : QLocale.Script = ... # 0x75
        OldNorthArabianScript    : QLocale.Script = ... # 0x76
        NabataeanScript          : QLocale.Script = ... # 0x77
        PalmyreneScript          : QLocale.Script = ... # 0x78
        PauCinHauScript          : QLocale.Script = ... # 0x79
        OldPermicScript          : QLocale.Script = ... # 0x7a
        PsalterPahlaviScript     : QLocale.Script = ... # 0x7b
        SiddhamScript            : QLocale.Script = ... # 0x7c
        KhudawadiScript          : QLocale.Script = ... # 0x7d
        TirhutaScript            : QLocale.Script = ... # 0x7e
        VarangKshitiScript       : QLocale.Script = ... # 0x7f
        AhomScript               : QLocale.Script = ... # 0x80
        AnatolianHieroglyphsScript: QLocale.Script = ... # 0x81
        HatranScript             : QLocale.Script = ... # 0x82
        MultaniScript            : QLocale.Script = ... # 0x83
        OldHungarianScript       : QLocale.Script = ... # 0x84
        SignWritingScript        : QLocale.Script = ... # 0x85
        AdlamScript              : QLocale.Script = ... # 0x86
        BhaiksukiScript          : QLocale.Script = ... # 0x87
        MarchenScript            : QLocale.Script = ... # 0x88
        NewaScript               : QLocale.Script = ... # 0x89
        OsageScript              : QLocale.Script = ... # 0x8a
        TangutScript             : QLocale.Script = ... # 0x8b
        HanWithBopomofoScript    : QLocale.Script = ... # 0x8c
        JamoScript               : QLocale.Script = ... # 0x8d
        LastScript               : QLocale.Script = ... # 0x8d

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, language: PySide2.QtCore.QLocale.Language, country: PySide2.QtCore.QLocale.Country = ...) -> None: ...
    @typing.overload
    def __init__(self, language: PySide2.QtCore.QLocale.Language, script: PySide2.QtCore.QLocale.Script, country: PySide2.QtCore.QLocale.Country) -> None: ...
    @typing.overload
    def __init__(self, name: str) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QLocale) -> None: ...


class QLockFile(Shiboken.Object):
    NoError                  : QLockFile.LockError = ... # 0x0
    LockFailedError          : QLockFile.LockError = ... # 0x1
    PermissionError          : QLockFile.LockError = ... # 0x2
    UnknownError             : QLockFile.LockError = ... # 0x3

    class LockError(Shiboken.Enum):
        NoError                  : QLockFile.LockError = ... # 0x0
        LockFailedError          : QLockFile.LockError = ... # 0x1
        PermissionError          : QLockFile.LockError = ... # 0x2
        UnknownError             : QLockFile.LockError = ... # 0x3

    def __init__(self, fileName: str) -> None: ...


class QMargins(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMargins: PySide2.QtCore.QMargins) -> None: ...
    @typing.overload
    def __init__(self, left: int, top: int, right: int, bottom: int) -> None: ...


class QMarginsF(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMarginsF: PySide2.QtCore.QMarginsF) -> None: ...
    @typing.overload
    def __init__(self, left: float, top: float, right: float, bottom: float) -> None: ...
    @typing.overload
    def __init__(self, margins: PySide2.QtCore.QMargins) -> None: ...


class QMessageAuthenticationCode(Shiboken.Object):

    def __init__(self, method: PySide2.QtCore.QCryptographicHash.Algorithm, key: PySide2.QtCore.QByteArray = ...) -> None: ...


class QMessageLogContext(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, fileName: bytes, lineNumber: int, functionName: bytes, categoryName: bytes) -> None: ...


class QMetaClassInfo(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMetaClassInfo: PySide2.QtCore.QMetaClassInfo) -> None: ...


class QMetaEnum(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMetaEnum: PySide2.QtCore.QMetaEnum) -> None: ...


class QMetaMethod(Shiboken.Object):
    Private                  : QMetaMethod.Access = ... # 0x0
    Protected                : QMetaMethod.Access = ... # 0x1
    Public                   : QMetaMethod.Access = ... # 0x2
    Method                   : QMetaMethod.MethodType = ... # 0x0
    Signal                   : QMetaMethod.MethodType = ... # 0x1
    Slot                     : QMetaMethod.MethodType = ... # 0x2
    Constructor              : QMetaMethod.MethodType = ... # 0x3

    class Access(Shiboken.Enum):
        Private                  : QMetaMethod.Access = ... # 0x0
        Protected                : QMetaMethod.Access = ... # 0x1
        Public                   : QMetaMethod.Access = ... # 0x2

    class MethodType(Shiboken.Enum):
        Method                   : QMetaMethod.MethodType = ... # 0x0
        Signal                   : QMetaMethod.MethodType = ... # 0x1
        Slot                     : QMetaMethod.MethodType = ... # 0x2
        Constructor              : QMetaMethod.MethodType = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMetaMethod: PySide2.QtCore.QMetaMethod) -> None: ...


class QMetaObject(Shiboken.Object):
    InvokeMetaMethod         : QMetaObject.Call = ... # 0x0
    ReadProperty             : QMetaObject.Call = ... # 0x1
    WriteProperty            : QMetaObject.Call = ... # 0x2
    ResetProperty            : QMetaObject.Call = ... # 0x3
    QueryPropertyDesignable  : QMetaObject.Call = ... # 0x4
    QueryPropertyScriptable  : QMetaObject.Call = ... # 0x5
    QueryPropertyStored      : QMetaObject.Call = ... # 0x6
    QueryPropertyEditable    : QMetaObject.Call = ... # 0x7
    QueryPropertyUser        : QMetaObject.Call = ... # 0x8
    CreateInstance           : QMetaObject.Call = ... # 0x9
    IndexOfMethod            : QMetaObject.Call = ... # 0xa
    RegisterPropertyMetaType : QMetaObject.Call = ... # 0xb
    RegisterMethodArgumentMetaType: QMetaObject.Call = ... # 0xc

    class Call(Shiboken.Enum):
        InvokeMetaMethod         : QMetaObject.Call = ... # 0x0
        ReadProperty             : QMetaObject.Call = ... # 0x1
        WriteProperty            : QMetaObject.Call = ... # 0x2
        ResetProperty            : QMetaObject.Call = ... # 0x3
        QueryPropertyDesignable  : QMetaObject.Call = ... # 0x4
        QueryPropertyScriptable  : QMetaObject.Call = ... # 0x5
        QueryPropertyStored      : QMetaObject.Call = ... # 0x6
        QueryPropertyEditable    : QMetaObject.Call = ... # 0x7
        QueryPropertyUser        : QMetaObject.Call = ... # 0x8
        CreateInstance           : QMetaObject.Call = ... # 0x9
        IndexOfMethod            : QMetaObject.Call = ... # 0xa
        RegisterPropertyMetaType : QMetaObject.Call = ... # 0xb
        RegisterMethodArgumentMetaType: QMetaObject.Call = ... # 0xc

    class Connection(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, other: PySide2.QtCore.QMetaObject.Connection) -> None: ...


    def __init__(self) -> None: ...


class QMetaProperty(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMetaProperty: PySide2.QtCore.QMetaProperty) -> None: ...


class QMimeData(PySide2.QtCore.QObject):

    def __init__(self) -> None: ...


class QMimeDatabase(Shiboken.Object):
    MatchDefault             : QMimeDatabase.MatchMode = ... # 0x0
    MatchExtension           : QMimeDatabase.MatchMode = ... # 0x1
    MatchContent             : QMimeDatabase.MatchMode = ... # 0x2

    class MatchMode(Shiboken.Enum):
        MatchDefault             : QMimeDatabase.MatchMode = ... # 0x0
        MatchExtension           : QMimeDatabase.MatchMode = ... # 0x1
        MatchContent             : QMimeDatabase.MatchMode = ... # 0x2

    def __init__(self) -> None: ...


class QMimeType(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QMimeType) -> None: ...


class QModelIndex(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QModelIndex: PySide2.QtCore.QModelIndex) -> None: ...


class QMutex(PySide2.QtCore.QBasicMutex):
    NonRecursive             : QMutex.RecursionMode = ... # 0x0
    Recursive                : QMutex.RecursionMode = ... # 0x1

    class RecursionMode(Shiboken.Enum):
        NonRecursive             : QMutex.RecursionMode = ... # 0x0
        Recursive                : QMutex.RecursionMode = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, mode: PySide2.QtCore.QMutex.RecursionMode) -> None: ...


class QMutexLocker(Shiboken.Object):

    @typing.overload
    def __init__(self, m: PySide2.QtCore.QBasicMutex) -> None: ...
    @typing.overload
    def __init__(self, m: PySide2.QtCore.QRecursiveMutex) -> None: ...


class QObject(Shiboken.Object):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QOperatingSystemVersion(Shiboken.Object):
    Unknown                  : QOperatingSystemVersion.OSType = ... # 0x0
    Windows                  : QOperatingSystemVersion.OSType = ... # 0x1
    MacOS                    : QOperatingSystemVersion.OSType = ... # 0x2
    IOS                      : QOperatingSystemVersion.OSType = ... # 0x3
    TvOS                     : QOperatingSystemVersion.OSType = ... # 0x4
    WatchOS                  : QOperatingSystemVersion.OSType = ... # 0x5
    Android                  : QOperatingSystemVersion.OSType = ... # 0x6

    class OSType(Shiboken.Enum):
        Unknown                  : QOperatingSystemVersion.OSType = ... # 0x0
        Windows                  : QOperatingSystemVersion.OSType = ... # 0x1
        MacOS                    : QOperatingSystemVersion.OSType = ... # 0x2
        IOS                      : QOperatingSystemVersion.OSType = ... # 0x3
        TvOS                     : QOperatingSystemVersion.OSType = ... # 0x4
        WatchOS                  : QOperatingSystemVersion.OSType = ... # 0x5
        Android                  : QOperatingSystemVersion.OSType = ... # 0x6

    @typing.overload
    def __init__(self, QOperatingSystemVersion: PySide2.QtCore.QOperatingSystemVersion) -> None: ...
    @typing.overload
    def __init__(self, osType: PySide2.QtCore.QOperatingSystemVersion.OSType, vmajor: int, vminor: int = ..., vmicro: int = ...) -> None: ...


class QParallelAnimationGroup(PySide2.QtCore.QAnimationGroup):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QPauseAnimation(PySide2.QtCore.QAbstractAnimation):

    @typing.overload
    def __init__(self, msecs: int, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QPersistentModelIndex(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QPersistentModelIndex) -> None: ...


class QPluginLoader(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, fileName: str, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QPoint(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QPoint: PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, xpos: int, ypos: int) -> None: ...


class QPointF(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QPointF: PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def __init__(self, p: PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, xpos: float, ypos: float) -> None: ...


class QProcess(PySide2.QtCore.QIODevice):
    NormalExit               : QProcess.ExitStatus = ... # 0x0
    CrashExit                : QProcess.ExitStatus = ... # 0x1
    ManagedInputChannel      : QProcess.InputChannelMode = ... # 0x0
    ForwardedInputChannel    : QProcess.InputChannelMode = ... # 0x1
    StandardOutput           : QProcess.ProcessChannel = ... # 0x0
    StandardError            : QProcess.ProcessChannel = ... # 0x1
    SeparateChannels         : QProcess.ProcessChannelMode = ... # 0x0
    MergedChannels           : QProcess.ProcessChannelMode = ... # 0x1
    ForwardedChannels        : QProcess.ProcessChannelMode = ... # 0x2
    ForwardedOutputChannel   : QProcess.ProcessChannelMode = ... # 0x3
    ForwardedErrorChannel    : QProcess.ProcessChannelMode = ... # 0x4
    FailedToStart            : QProcess.ProcessError = ... # 0x0
    Crashed                  : QProcess.ProcessError = ... # 0x1
    Timedout                 : QProcess.ProcessError = ... # 0x2
    ReadError                : QProcess.ProcessError = ... # 0x3
    WriteError               : QProcess.ProcessError = ... # 0x4
    UnknownError             : QProcess.ProcessError = ... # 0x5
    NotRunning               : QProcess.ProcessState = ... # 0x0
    Starting                 : QProcess.ProcessState = ... # 0x1
    Running                  : QProcess.ProcessState = ... # 0x2

    class ExitStatus(Shiboken.Enum):
        NormalExit               : QProcess.ExitStatus = ... # 0x0
        CrashExit                : QProcess.ExitStatus = ... # 0x1

    class InputChannelMode(Shiboken.Enum):
        ManagedInputChannel      : QProcess.InputChannelMode = ... # 0x0
        ForwardedInputChannel    : QProcess.InputChannelMode = ... # 0x1

    class ProcessChannel(Shiboken.Enum):
        StandardOutput           : QProcess.ProcessChannel = ... # 0x0
        StandardError            : QProcess.ProcessChannel = ... # 0x1

    class ProcessChannelMode(Shiboken.Enum):
        SeparateChannels         : QProcess.ProcessChannelMode = ... # 0x0
        MergedChannels           : QProcess.ProcessChannelMode = ... # 0x1
        ForwardedChannels        : QProcess.ProcessChannelMode = ... # 0x2
        ForwardedOutputChannel   : QProcess.ProcessChannelMode = ... # 0x3
        ForwardedErrorChannel    : QProcess.ProcessChannelMode = ... # 0x4

    class ProcessError(Shiboken.Enum):
        FailedToStart            : QProcess.ProcessError = ... # 0x0
        Crashed                  : QProcess.ProcessError = ... # 0x1
        Timedout                 : QProcess.ProcessError = ... # 0x2
        ReadError                : QProcess.ProcessError = ... # 0x3
        WriteError               : QProcess.ProcessError = ... # 0x4
        UnknownError             : QProcess.ProcessError = ... # 0x5

    class ProcessState(Shiboken.Enum):
        NotRunning               : QProcess.ProcessState = ... # 0x0
        Starting                 : QProcess.ProcessState = ... # 0x1
        Running                  : QProcess.ProcessState = ... # 0x2

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QProcessEnvironment(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QProcessEnvironment) -> None: ...


class QPropertyAnimation(PySide2.QtCore.QVariantAnimation):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, target: PySide2.QtCore.QObject, propertyName: PySide2.QtCore.QByteArray, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QRandomGenerator(Shiboken.Object):

    @typing.overload
    def __init__(self, begin: int, end: int) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QRandomGenerator) -> None: ...
    @typing.overload
    def __init__(self, seedBuffer: int, len: int) -> None: ...
    @typing.overload
    def __init__(self, seedValue: int = ...) -> None: ...


class QRandomGenerator64(PySide2.QtCore.QRandomGenerator):

    @typing.overload
    def __init__(self, begin: int, end: int) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QRandomGenerator) -> None: ...
    @typing.overload
    def __init__(self, seedBuffer: int, len: int) -> None: ...
    @typing.overload
    def __init__(self, seedValue: int = ...) -> None: ...


class QReadLocker(Shiboken.Object):

    def __init__(self, readWriteLock: PySide2.QtCore.QReadWriteLock) -> None: ...


class QReadWriteLock(Shiboken.Object):
    NonRecursive             : QReadWriteLock.RecursionMode = ... # 0x0
    Recursive                : QReadWriteLock.RecursionMode = ... # 0x1

    class RecursionMode(Shiboken.Enum):
        NonRecursive             : QReadWriteLock.RecursionMode = ... # 0x0
        Recursive                : QReadWriteLock.RecursionMode = ... # 0x1

    def __init__(self, recursionMode: PySide2.QtCore.QReadWriteLock.RecursionMode = ...) -> None: ...


class QRect(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QRect: PySide2.QtCore.QRect) -> None: ...
    @typing.overload
    def __init__(self, left: int, top: int, width: int, height: int) -> None: ...
    @typing.overload
    def __init__(self, topleft: PySide2.QtCore.QPoint, bottomright: PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, topleft: PySide2.QtCore.QPoint, size: PySide2.QtCore.QSize) -> None: ...


class QRectF(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QRectF: PySide2.QtCore.QRectF) -> None: ...
    @typing.overload
    def __init__(self, left: float, top: float, width: float, height: float) -> None: ...
    @typing.overload
    def __init__(self, rect: PySide2.QtCore.QRect) -> None: ...
    @typing.overload
    def __init__(self, topleft: PySide2.QtCore.QPointF, bottomRight: PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def __init__(self, topleft: PySide2.QtCore.QPointF, size: PySide2.QtCore.QSizeF) -> None: ...


class QRecursiveMutex(Shiboken.Object):

    def __init__(self) -> None: ...


class QRegExp(Shiboken.Object):
    CaretAtZero              : QRegExp.CaretMode = ... # 0x0
    CaretAtOffset            : QRegExp.CaretMode = ... # 0x1
    CaretWontMatch           : QRegExp.CaretMode = ... # 0x2
    RegExp                   : QRegExp.PatternSyntax = ... # 0x0
    Wildcard                 : QRegExp.PatternSyntax = ... # 0x1
    FixedString              : QRegExp.PatternSyntax = ... # 0x2
    RegExp2                  : QRegExp.PatternSyntax = ... # 0x3
    WildcardUnix             : QRegExp.PatternSyntax = ... # 0x4
    W3CXmlSchema11           : QRegExp.PatternSyntax = ... # 0x5

    class CaretMode(Shiboken.Enum):
        CaretAtZero              : QRegExp.CaretMode = ... # 0x0
        CaretAtOffset            : QRegExp.CaretMode = ... # 0x1
        CaretWontMatch           : QRegExp.CaretMode = ... # 0x2

    class PatternSyntax(Shiboken.Enum):
        RegExp                   : QRegExp.PatternSyntax = ... # 0x0
        Wildcard                 : QRegExp.PatternSyntax = ... # 0x1
        FixedString              : QRegExp.PatternSyntax = ... # 0x2
        RegExp2                  : QRegExp.PatternSyntax = ... # 0x3
        WildcardUnix             : QRegExp.PatternSyntax = ... # 0x4
        W3CXmlSchema11           : QRegExp.PatternSyntax = ... # 0x5

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, pattern: str, cs: PySide2.QtCore.Qt.CaseSensitivity = ..., syntax: PySide2.QtCore.QRegExp.PatternSyntax = ...) -> None: ...
    @typing.overload
    def __init__(self, rx: PySide2.QtCore.QRegExp) -> None: ...


class QRegularExpression(Shiboken.Object):
    NoMatchOption            : QRegularExpression.MatchOption = ... # 0x0
    AnchoredMatchOption      : QRegularExpression.MatchOption = ... # 0x1
    DontCheckSubjectStringMatchOption: QRegularExpression.MatchOption = ... # 0x2
    NormalMatch              : QRegularExpression.MatchType = ... # 0x0
    PartialPreferCompleteMatch: QRegularExpression.MatchType = ... # 0x1
    PartialPreferFirstMatch  : QRegularExpression.MatchType = ... # 0x2
    NoMatch                  : QRegularExpression.MatchType = ... # 0x3
    NoPatternOption          : QRegularExpression.PatternOption = ... # 0x0
    CaseInsensitiveOption    : QRegularExpression.PatternOption = ... # 0x1
    DotMatchesEverythingOption: QRegularExpression.PatternOption = ... # 0x2
    MultilineOption          : QRegularExpression.PatternOption = ... # 0x4
    ExtendedPatternSyntaxOption: QRegularExpression.PatternOption = ... # 0x8
    InvertedGreedinessOption : QRegularExpression.PatternOption = ... # 0x10
    DontCaptureOption        : QRegularExpression.PatternOption = ... # 0x20
    UseUnicodePropertiesOption: QRegularExpression.PatternOption = ... # 0x40
    OptimizeOnFirstUsageOption: QRegularExpression.PatternOption = ... # 0x80
    DontAutomaticallyOptimizeOption: QRegularExpression.PatternOption = ... # 0x100

    class MatchOption(Shiboken.Enum):
        NoMatchOption            : QRegularExpression.MatchOption = ... # 0x0
        AnchoredMatchOption      : QRegularExpression.MatchOption = ... # 0x1
        DontCheckSubjectStringMatchOption: QRegularExpression.MatchOption = ... # 0x2

    class MatchOptions(object): ...

    class MatchType(Shiboken.Enum):
        NormalMatch              : QRegularExpression.MatchType = ... # 0x0
        PartialPreferCompleteMatch: QRegularExpression.MatchType = ... # 0x1
        PartialPreferFirstMatch  : QRegularExpression.MatchType = ... # 0x2
        NoMatch                  : QRegularExpression.MatchType = ... # 0x3

    class PatternOption(Shiboken.Enum):
        NoPatternOption          : QRegularExpression.PatternOption = ... # 0x0
        CaseInsensitiveOption    : QRegularExpression.PatternOption = ... # 0x1
        DotMatchesEverythingOption: QRegularExpression.PatternOption = ... # 0x2
        MultilineOption          : QRegularExpression.PatternOption = ... # 0x4
        ExtendedPatternSyntaxOption: QRegularExpression.PatternOption = ... # 0x8
        InvertedGreedinessOption : QRegularExpression.PatternOption = ... # 0x10
        DontCaptureOption        : QRegularExpression.PatternOption = ... # 0x20
        UseUnicodePropertiesOption: QRegularExpression.PatternOption = ... # 0x40
        OptimizeOnFirstUsageOption: QRegularExpression.PatternOption = ... # 0x80
        DontAutomaticallyOptimizeOption: QRegularExpression.PatternOption = ... # 0x100

    class PatternOptions(object): ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, pattern: str, options: PySide2.QtCore.QRegularExpression.PatternOptions = ...) -> None: ...
    @typing.overload
    def __init__(self, re: PySide2.QtCore.QRegularExpression) -> None: ...


class QRegularExpressionMatch(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, match: PySide2.QtCore.QRegularExpressionMatch) -> None: ...


class QRegularExpressionMatchIterator(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, iterator: PySide2.QtCore.QRegularExpressionMatchIterator) -> None: ...


class QResource(Shiboken.Object):
    NoCompression            : QResource.Compression = ... # 0x0
    ZlibCompression          : QResource.Compression = ... # 0x1
    ZstdCompression          : QResource.Compression = ... # 0x2

    class Compression(Shiboken.Enum):
        NoCompression            : QResource.Compression = ... # 0x0
        ZlibCompression          : QResource.Compression = ... # 0x1
        ZstdCompression          : QResource.Compression = ... # 0x2

    def __init__(self, file: str = ..., locale: PySide2.QtCore.QLocale = ...) -> None: ...


class QRunnable(Shiboken.Object):

    def __init__(self) -> None: ...


class QSaveFile(PySide2.QtCore.QFileDevice):

    @typing.overload
    def __init__(self, name: str) -> None: ...
    @typing.overload
    def __init__(self, name: str, parent: PySide2.QtCore.QObject) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QSemaphore(Shiboken.Object):

    def __init__(self, n: int = ...) -> None: ...


class QSemaphoreReleaser(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, sem: PySide2.QtCore.QSemaphore, n: int = ...) -> None: ...


class QSequentialAnimationGroup(PySide2.QtCore.QAnimationGroup):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QSettings(PySide2.QtCore.QObject):
    NativeFormat             : QSettings.Format = ... # 0x0
    IniFormat                : QSettings.Format = ... # 0x1
    InvalidFormat            : QSettings.Format = ... # 0x10
    CustomFormat1            : QSettings.Format = ... # 0x11
    CustomFormat2            : QSettings.Format = ... # 0x12
    CustomFormat3            : QSettings.Format = ... # 0x13
    CustomFormat4            : QSettings.Format = ... # 0x14
    CustomFormat5            : QSettings.Format = ... # 0x15
    CustomFormat6            : QSettings.Format = ... # 0x16
    CustomFormat7            : QSettings.Format = ... # 0x17
    CustomFormat8            : QSettings.Format = ... # 0x18
    CustomFormat9            : QSettings.Format = ... # 0x19
    CustomFormat10           : QSettings.Format = ... # 0x1a
    CustomFormat11           : QSettings.Format = ... # 0x1b
    CustomFormat12           : QSettings.Format = ... # 0x1c
    CustomFormat13           : QSettings.Format = ... # 0x1d
    CustomFormat14           : QSettings.Format = ... # 0x1e
    CustomFormat15           : QSettings.Format = ... # 0x1f
    CustomFormat16           : QSettings.Format = ... # 0x20
    UserScope                : QSettings.Scope = ... # 0x0
    SystemScope              : QSettings.Scope = ... # 0x1
    NoError                  : QSettings.Status = ... # 0x0
    AccessError              : QSettings.Status = ... # 0x1
    FormatError              : QSettings.Status = ... # 0x2

    class Format(Shiboken.Enum):
        NativeFormat             : QSettings.Format = ... # 0x0
        IniFormat                : QSettings.Format = ... # 0x1
        InvalidFormat            : QSettings.Format = ... # 0x10
        CustomFormat1            : QSettings.Format = ... # 0x11
        CustomFormat2            : QSettings.Format = ... # 0x12
        CustomFormat3            : QSettings.Format = ... # 0x13
        CustomFormat4            : QSettings.Format = ... # 0x14
        CustomFormat5            : QSettings.Format = ... # 0x15
        CustomFormat6            : QSettings.Format = ... # 0x16
        CustomFormat7            : QSettings.Format = ... # 0x17
        CustomFormat8            : QSettings.Format = ... # 0x18
        CustomFormat9            : QSettings.Format = ... # 0x19
        CustomFormat10           : QSettings.Format = ... # 0x1a
        CustomFormat11           : QSettings.Format = ... # 0x1b
        CustomFormat12           : QSettings.Format = ... # 0x1c
        CustomFormat13           : QSettings.Format = ... # 0x1d
        CustomFormat14           : QSettings.Format = ... # 0x1e
        CustomFormat15           : QSettings.Format = ... # 0x1f
        CustomFormat16           : QSettings.Format = ... # 0x20

    class Scope(Shiboken.Enum):
        UserScope                : QSettings.Scope = ... # 0x0
        SystemScope              : QSettings.Scope = ... # 0x1

    class Status(Shiboken.Enum):
        NoError                  : QSettings.Status = ... # 0x0
        AccessError              : QSettings.Status = ... # 0x1
        FormatError              : QSettings.Status = ... # 0x2

    @typing.overload
    def __init__(self, fileName: str, format: PySide2.QtCore.QSettings.Format, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, format: PySide2.QtCore.QSettings.Format, scope: PySide2.QtCore.QSettings.Scope, organization: str, application: str = ..., parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, organization: str, application: str = ..., parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, scope: PySide2.QtCore.QSettings.Scope, organization: str, application: str = ..., parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, scope: PySide2.QtCore.QSettings.Scope, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QSignalBlocker(Shiboken.Object):

    def __init__(self, o: PySide2.QtCore.QObject) -> None: ...


class QSignalMapper(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QSignalTransition(PySide2.QtCore.QAbstractTransition):

    @typing.overload
    def __init__(self, arg__1: object, arg__2: typing.Optional[PySide2.QtCore.QState] = ...) -> PySide2.QtCore.QSignalTransition: ...
    @typing.overload
    def __init__(self, sender: PySide2.QtCore.QObject, signal: bytes, sourceState: typing.Optional[PySide2.QtCore.QState] = ...) -> None: ...
    @typing.overload
    def __init__(self, sourceState: typing.Optional[PySide2.QtCore.QState] = ...) -> None: ...


class QSize(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QSize: PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def __init__(self, w: int, h: int) -> None: ...


class QSizeF(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QSizeF: PySide2.QtCore.QSizeF) -> None: ...
    @typing.overload
    def __init__(self, sz: PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def __init__(self, w: float, h: float) -> None: ...


class QSocketDescriptor(Shiboken.Object):

    @typing.overload
    def __init__(self, QSocketDescriptor: PySide2.QtCore.QSocketDescriptor) -> None: ...
    @typing.overload
    def __init__(self, descriptor: int = ...) -> None: ...


class QSocketNotifier(PySide2.QtCore.QObject):
    Read                     : QSocketNotifier.Type = ... # 0x0
    Write                    : QSocketNotifier.Type = ... # 0x1
    Exception                : QSocketNotifier.Type = ... # 0x2

    class Type(Shiboken.Enum):
        Read                     : QSocketNotifier.Type = ... # 0x0
        Write                    : QSocketNotifier.Type = ... # 0x1
        Exception                : QSocketNotifier.Type = ... # 0x2

    @typing.overload
    def __init__(self, arg__1: object, arg__2: PySide2.QtCore.QSocketNotifier.Type, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, socket: int, arg__2: PySide2.QtCore.QSocketNotifier.Type, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QSortFilterProxyModel(PySide2.QtCore.QAbstractProxyModel):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QStandardPaths(Shiboken.Object):
    LocateFile               : QStandardPaths.LocateOption = ... # 0x0
    LocateDirectory          : QStandardPaths.LocateOption = ... # 0x1
    DesktopLocation          : QStandardPaths.StandardLocation = ... # 0x0
    DocumentsLocation        : QStandardPaths.StandardLocation = ... # 0x1
    FontsLocation            : QStandardPaths.StandardLocation = ... # 0x2
    ApplicationsLocation     : QStandardPaths.StandardLocation = ... # 0x3
    MusicLocation            : QStandardPaths.StandardLocation = ... # 0x4
    MoviesLocation           : QStandardPaths.StandardLocation = ... # 0x5
    PicturesLocation         : QStandardPaths.StandardLocation = ... # 0x6
    TempLocation             : QStandardPaths.StandardLocation = ... # 0x7
    HomeLocation             : QStandardPaths.StandardLocation = ... # 0x8
    AppLocalDataLocation     : QStandardPaths.StandardLocation = ... # 0x9
    DataLocation             : QStandardPaths.StandardLocation = ... # 0x9
    CacheLocation            : QStandardPaths.StandardLocation = ... # 0xa
    GenericDataLocation      : QStandardPaths.StandardLocation = ... # 0xb
    RuntimeLocation          : QStandardPaths.StandardLocation = ... # 0xc
    ConfigLocation           : QStandardPaths.StandardLocation = ... # 0xd
    DownloadLocation         : QStandardPaths.StandardLocation = ... # 0xe
    GenericCacheLocation     : QStandardPaths.StandardLocation = ... # 0xf
    GenericConfigLocation    : QStandardPaths.StandardLocation = ... # 0x10
    AppDataLocation          : QStandardPaths.StandardLocation = ... # 0x11
    AppConfigLocation        : QStandardPaths.StandardLocation = ... # 0x12

    class LocateOption(Shiboken.Enum):
        LocateFile               : QStandardPaths.LocateOption = ... # 0x0
        LocateDirectory          : QStandardPaths.LocateOption = ... # 0x1

    class LocateOptions(object): ...

    class StandardLocation(Shiboken.Enum):
        DesktopLocation          : QStandardPaths.StandardLocation = ... # 0x0
        DocumentsLocation        : QStandardPaths.StandardLocation = ... # 0x1
        FontsLocation            : QStandardPaths.StandardLocation = ... # 0x2
        ApplicationsLocation     : QStandardPaths.StandardLocation = ... # 0x3
        MusicLocation            : QStandardPaths.StandardLocation = ... # 0x4
        MoviesLocation           : QStandardPaths.StandardLocation = ... # 0x5
        PicturesLocation         : QStandardPaths.StandardLocation = ... # 0x6
        TempLocation             : QStandardPaths.StandardLocation = ... # 0x7
        HomeLocation             : QStandardPaths.StandardLocation = ... # 0x8
        AppLocalDataLocation     : QStandardPaths.StandardLocation = ... # 0x9
        DataLocation             : QStandardPaths.StandardLocation = ... # 0x9
        CacheLocation            : QStandardPaths.StandardLocation = ... # 0xa
        GenericDataLocation      : QStandardPaths.StandardLocation = ... # 0xb
        RuntimeLocation          : QStandardPaths.StandardLocation = ... # 0xc
        ConfigLocation           : QStandardPaths.StandardLocation = ... # 0xd
        DownloadLocation         : QStandardPaths.StandardLocation = ... # 0xe
        GenericCacheLocation     : QStandardPaths.StandardLocation = ... # 0xf
        GenericConfigLocation    : QStandardPaths.StandardLocation = ... # 0x10
        AppDataLocation          : QStandardPaths.StandardLocation = ... # 0x11
        AppConfigLocation        : QStandardPaths.StandardLocation = ... # 0x12


class QState(PySide2.QtCore.QAbstractState):
    ExclusiveStates          : QState.ChildMode = ... # 0x0
    ParallelStates           : QState.ChildMode = ... # 0x1
    DontRestoreProperties    : QState.RestorePolicy = ... # 0x0
    RestoreProperties        : QState.RestorePolicy = ... # 0x1

    class ChildMode(Shiboken.Enum):
        ExclusiveStates          : QState.ChildMode = ... # 0x0
        ParallelStates           : QState.ChildMode = ... # 0x1

    class RestorePolicy(Shiboken.Enum):
        DontRestoreProperties    : QState.RestorePolicy = ... # 0x0
        RestoreProperties        : QState.RestorePolicy = ... # 0x1

    @typing.overload
    def __init__(self, childMode: PySide2.QtCore.QState.ChildMode, parent: typing.Optional[PySide2.QtCore.QState] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QState] = ...) -> None: ...


class QStateMachine(PySide2.QtCore.QState):
    NoError                  : QStateMachine.Error = ... # 0x0
    NoInitialStateError      : QStateMachine.Error = ... # 0x1
    NoDefaultStateInHistoryStateError: QStateMachine.Error = ... # 0x2
    NoCommonAncestorForTransitionError: QStateMachine.Error = ... # 0x3
    StateMachineChildModeSetToParallelError: QStateMachine.Error = ... # 0x4
    NormalPriority           : QStateMachine.EventPriority = ... # 0x0
    HighPriority             : QStateMachine.EventPriority = ... # 0x1

    class Error(Shiboken.Enum):
        NoError                  : QStateMachine.Error = ... # 0x0
        NoInitialStateError      : QStateMachine.Error = ... # 0x1
        NoDefaultStateInHistoryStateError: QStateMachine.Error = ... # 0x2
        NoCommonAncestorForTransitionError: QStateMachine.Error = ... # 0x3
        StateMachineChildModeSetToParallelError: QStateMachine.Error = ... # 0x4

    class EventPriority(Shiboken.Enum):
        NormalPriority           : QStateMachine.EventPriority = ... # 0x0
        HighPriority             : QStateMachine.EventPriority = ... # 0x1

    class SignalEvent(PySide2.QtCore.QEvent):

        @typing.overload
        def __init__(self, SignalEvent: PySide2.QtCore.QStateMachine.SignalEvent) -> None: ...
        @typing.overload
        def __init__(self, sender: PySide2.QtCore.QObject, signalIndex: int, arguments: typing.Sequence[typing.Any]) -> None: ...


    class WrappedEvent(PySide2.QtCore.QEvent):

        @typing.overload
        def __init__(self, WrappedEvent: PySide2.QtCore.QStateMachine.WrappedEvent) -> None: ...
        @typing.overload
        def __init__(self, object: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> None: ...


    @typing.overload
    def __init__(self, childMode: PySide2.QtCore.QState.ChildMode, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QStorageInfo(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, dir: PySide2.QtCore.QDir) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QStorageInfo) -> None: ...
    @typing.overload
    def __init__(self, path: str) -> None: ...


class QStringListModel(PySide2.QtCore.QAbstractListModel):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, strings: typing.Sequence[str], parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QSysInfo(Shiboken.Object):
    BigEndian                : QSysInfo.Endian = ... # 0x0
    ByteOrder                : QSysInfo.Endian = ... # 0x1
    LittleEndian             : QSysInfo.Endian = ... # 0x1
    WordSize                 : QSysInfo.Sizes = ... # 0x40

    class Endian(Shiboken.Enum):
        BigEndian                : QSysInfo.Endian = ... # 0x0
        ByteOrder                : QSysInfo.Endian = ... # 0x1
        LittleEndian             : QSysInfo.Endian = ... # 0x1

    class Sizes(Shiboken.Enum):
        WordSize                 : QSysInfo.Sizes = ... # 0x40

    def __init__(self) -> None: ...


class QSystemSemaphore(Shiboken.Object):
    Open                     : QSystemSemaphore.AccessMode = ... # 0x0
    Create                   : QSystemSemaphore.AccessMode = ... # 0x1
    NoError                  : QSystemSemaphore.SystemSemaphoreError = ... # 0x0
    PermissionDenied         : QSystemSemaphore.SystemSemaphoreError = ... # 0x1
    KeyError                 : QSystemSemaphore.SystemSemaphoreError = ... # 0x2
    AlreadyExists            : QSystemSemaphore.SystemSemaphoreError = ... # 0x3
    NotFound                 : QSystemSemaphore.SystemSemaphoreError = ... # 0x4
    OutOfResources           : QSystemSemaphore.SystemSemaphoreError = ... # 0x5
    UnknownError             : QSystemSemaphore.SystemSemaphoreError = ... # 0x6

    class AccessMode(Shiboken.Enum):
        Open                     : QSystemSemaphore.AccessMode = ... # 0x0
        Create                   : QSystemSemaphore.AccessMode = ... # 0x1

    class SystemSemaphoreError(Shiboken.Enum):
        NoError                  : QSystemSemaphore.SystemSemaphoreError = ... # 0x0
        PermissionDenied         : QSystemSemaphore.SystemSemaphoreError = ... # 0x1
        KeyError                 : QSystemSemaphore.SystemSemaphoreError = ... # 0x2
        AlreadyExists            : QSystemSemaphore.SystemSemaphoreError = ... # 0x3
        NotFound                 : QSystemSemaphore.SystemSemaphoreError = ... # 0x4
        OutOfResources           : QSystemSemaphore.SystemSemaphoreError = ... # 0x5
        UnknownError             : QSystemSemaphore.SystemSemaphoreError = ... # 0x6

    def __init__(self, key: str, initialValue: int = ..., mode: PySide2.QtCore.QSystemSemaphore.AccessMode = ...) -> None: ...


class QTemporaryDir(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, templateName: str) -> None: ...


class QTemporaryFile(PySide2.QtCore.QFile):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject) -> None: ...
    @typing.overload
    def __init__(self, templateName: str) -> None: ...
    @typing.overload
    def __init__(self, templateName: str, parent: PySide2.QtCore.QObject) -> None: ...


class QTextBoundaryFinder(Shiboken.Object):
    NotAtBoundary            : QTextBoundaryFinder.BoundaryReason = ... # 0x0
    BreakOpportunity         : QTextBoundaryFinder.BoundaryReason = ... # 0x1f
    StartOfItem              : QTextBoundaryFinder.BoundaryReason = ... # 0x20
    EndOfItem                : QTextBoundaryFinder.BoundaryReason = ... # 0x40
    MandatoryBreak           : QTextBoundaryFinder.BoundaryReason = ... # 0x80
    SoftHyphen               : QTextBoundaryFinder.BoundaryReason = ... # 0x100
    Grapheme                 : QTextBoundaryFinder.BoundaryType = ... # 0x0
    Word                     : QTextBoundaryFinder.BoundaryType = ... # 0x1
    Sentence                 : QTextBoundaryFinder.BoundaryType = ... # 0x2
    Line                     : QTextBoundaryFinder.BoundaryType = ... # 0x3

    class BoundaryReason(Shiboken.Enum):
        NotAtBoundary            : QTextBoundaryFinder.BoundaryReason = ... # 0x0
        BreakOpportunity         : QTextBoundaryFinder.BoundaryReason = ... # 0x1f
        StartOfItem              : QTextBoundaryFinder.BoundaryReason = ... # 0x20
        EndOfItem                : QTextBoundaryFinder.BoundaryReason = ... # 0x40
        MandatoryBreak           : QTextBoundaryFinder.BoundaryReason = ... # 0x80
        SoftHyphen               : QTextBoundaryFinder.BoundaryReason = ... # 0x100

    class BoundaryReasons(object): ...

    class BoundaryType(Shiboken.Enum):
        Grapheme                 : QTextBoundaryFinder.BoundaryType = ... # 0x0
        Word                     : QTextBoundaryFinder.BoundaryType = ... # 0x1
        Sentence                 : QTextBoundaryFinder.BoundaryType = ... # 0x2
        Line                     : QTextBoundaryFinder.BoundaryType = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QTextBoundaryFinder) -> None: ...
    @typing.overload
    def __init__(self, type: PySide2.QtCore.QTextBoundaryFinder.BoundaryType, string: str) -> None: ...


class QTextCodec(Shiboken.Object):
    DefaultConversion        : QTextCodec.ConversionFlag = ... # 0x0
    IgnoreHeader             : QTextCodec.ConversionFlag = ... # 0x1
    FreeFunction             : QTextCodec.ConversionFlag = ... # 0x2
    ConvertInvalidToNull     : QTextCodec.ConversionFlag = ... # -0x80000000

    class ConversionFlag(Shiboken.Enum):
        DefaultConversion        : QTextCodec.ConversionFlag = ... # 0x0
        IgnoreHeader             : QTextCodec.ConversionFlag = ... # 0x1
        FreeFunction             : QTextCodec.ConversionFlag = ... # 0x2
        ConvertInvalidToNull     : QTextCodec.ConversionFlag = ... # -0x80000000

    class ConversionFlags(object): ...

    class ConverterState(Shiboken.Object):

        def __init__(self, f: PySide2.QtCore.QTextCodec.ConversionFlags = ...) -> None: ...


    def __init__(self) -> None: ...


class QTextDecoder(Shiboken.Object):

    @typing.overload
    def __init__(self, codec: PySide2.QtCore.QTextCodec) -> None: ...
    @typing.overload
    def __init__(self, codec: PySide2.QtCore.QTextCodec, flags: PySide2.QtCore.QTextCodec.ConversionFlags) -> None: ...


class QTextEncoder(Shiboken.Object):

    @typing.overload
    def __init__(self, codec: PySide2.QtCore.QTextCodec) -> None: ...
    @typing.overload
    def __init__(self, codec: PySide2.QtCore.QTextCodec, flags: PySide2.QtCore.QTextCodec.ConversionFlags) -> None: ...


class QTextStream(Shiboken.Object):
    AlignLeft                : QTextStream.FieldAlignment = ... # 0x0
    AlignRight               : QTextStream.FieldAlignment = ... # 0x1
    AlignCenter              : QTextStream.FieldAlignment = ... # 0x2
    AlignAccountingStyle     : QTextStream.FieldAlignment = ... # 0x3
    ShowBase                 : QTextStream.NumberFlag = ... # 0x1
    ForcePoint               : QTextStream.NumberFlag = ... # 0x2
    ForceSign                : QTextStream.NumberFlag = ... # 0x4
    UppercaseBase            : QTextStream.NumberFlag = ... # 0x8
    UppercaseDigits          : QTextStream.NumberFlag = ... # 0x10
    SmartNotation            : QTextStream.RealNumberNotation = ... # 0x0
    FixedNotation            : QTextStream.RealNumberNotation = ... # 0x1
    ScientificNotation       : QTextStream.RealNumberNotation = ... # 0x2
    Ok                       : QTextStream.Status = ... # 0x0
    ReadPastEnd              : QTextStream.Status = ... # 0x1
    ReadCorruptData          : QTextStream.Status = ... # 0x2
    WriteFailed              : QTextStream.Status = ... # 0x3

    class FieldAlignment(Shiboken.Enum):
        AlignLeft                : QTextStream.FieldAlignment = ... # 0x0
        AlignRight               : QTextStream.FieldAlignment = ... # 0x1
        AlignCenter              : QTextStream.FieldAlignment = ... # 0x2
        AlignAccountingStyle     : QTextStream.FieldAlignment = ... # 0x3

    class NumberFlag(Shiboken.Enum):
        ShowBase                 : QTextStream.NumberFlag = ... # 0x1
        ForcePoint               : QTextStream.NumberFlag = ... # 0x2
        ForceSign                : QTextStream.NumberFlag = ... # 0x4
        UppercaseBase            : QTextStream.NumberFlag = ... # 0x8
        UppercaseDigits          : QTextStream.NumberFlag = ... # 0x10

    class NumberFlags(object): ...

    class RealNumberNotation(Shiboken.Enum):
        SmartNotation            : QTextStream.RealNumberNotation = ... # 0x0
        FixedNotation            : QTextStream.RealNumberNotation = ... # 0x1
        ScientificNotation       : QTextStream.RealNumberNotation = ... # 0x2

    class Status(Shiboken.Enum):
        Ok                       : QTextStream.Status = ... # 0x0
        ReadPastEnd              : QTextStream.Status = ... # 0x1
        ReadCorruptData          : QTextStream.Status = ... # 0x2
        WriteFailed              : QTextStream.Status = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, array: PySide2.QtCore.QByteArray, openMode: PySide2.QtCore.QIODevice.OpenMode = ...) -> None: ...
    @typing.overload
    def __init__(self, device: PySide2.QtCore.QIODevice) -> None: ...


class QTextStreamManipulator(Shiboken.Object): ...


class QThread(PySide2.QtCore.QObject):
    IdlePriority             : QThread.Priority = ... # 0x0
    LowestPriority           : QThread.Priority = ... # 0x1
    LowPriority              : QThread.Priority = ... # 0x2
    NormalPriority           : QThread.Priority = ... # 0x3
    HighPriority             : QThread.Priority = ... # 0x4
    HighestPriority          : QThread.Priority = ... # 0x5
    TimeCriticalPriority     : QThread.Priority = ... # 0x6
    InheritPriority          : QThread.Priority = ... # 0x7

    class Priority(Shiboken.Enum):
        IdlePriority             : QThread.Priority = ... # 0x0
        LowestPriority           : QThread.Priority = ... # 0x1
        LowPriority              : QThread.Priority = ... # 0x2
        NormalPriority           : QThread.Priority = ... # 0x3
        HighPriority             : QThread.Priority = ... # 0x4
        HighestPriority          : QThread.Priority = ... # 0x5
        TimeCriticalPriority     : QThread.Priority = ... # 0x6
        InheritPriority          : QThread.Priority = ... # 0x7

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QThreadPool(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QTime(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QTime: PySide2.QtCore.QTime) -> None: ...
    @typing.overload
    def __init__(self, h: int, m: int, s: int = ..., ms: int = ...) -> None: ...


class QTimeLine(PySide2.QtCore.QObject):
    EaseInCurve              : QTimeLine.CurveShape = ... # 0x0
    EaseOutCurve             : QTimeLine.CurveShape = ... # 0x1
    EaseInOutCurve           : QTimeLine.CurveShape = ... # 0x2
    LinearCurve              : QTimeLine.CurveShape = ... # 0x3
    SineCurve                : QTimeLine.CurveShape = ... # 0x4
    CosineCurve              : QTimeLine.CurveShape = ... # 0x5
    Forward                  : QTimeLine.Direction = ... # 0x0
    Backward                 : QTimeLine.Direction = ... # 0x1
    NotRunning               : QTimeLine.State = ... # 0x0
    Paused                   : QTimeLine.State = ... # 0x1
    Running                  : QTimeLine.State = ... # 0x2

    class CurveShape(Shiboken.Enum):
        EaseInCurve              : QTimeLine.CurveShape = ... # 0x0
        EaseOutCurve             : QTimeLine.CurveShape = ... # 0x1
        EaseInOutCurve           : QTimeLine.CurveShape = ... # 0x2
        LinearCurve              : QTimeLine.CurveShape = ... # 0x3
        SineCurve                : QTimeLine.CurveShape = ... # 0x4
        CosineCurve              : QTimeLine.CurveShape = ... # 0x5

    class Direction(Shiboken.Enum):
        Forward                  : QTimeLine.Direction = ... # 0x0
        Backward                 : QTimeLine.Direction = ... # 0x1

    class State(Shiboken.Enum):
        NotRunning               : QTimeLine.State = ... # 0x0
        Paused                   : QTimeLine.State = ... # 0x1
        Running                  : QTimeLine.State = ... # 0x2

    def __init__(self, duration: int = ..., parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QTimeZone(Shiboken.Object):
    DefaultName              : QTimeZone.NameType = ... # 0x0
    LongName                 : QTimeZone.NameType = ... # 0x1
    ShortName                : QTimeZone.NameType = ... # 0x2
    OffsetName               : QTimeZone.NameType = ... # 0x3
    StandardTime             : QTimeZone.TimeType = ... # 0x0
    DaylightTime             : QTimeZone.TimeType = ... # 0x1
    GenericTime              : QTimeZone.TimeType = ... # 0x2

    class NameType(Shiboken.Enum):
        DefaultName              : QTimeZone.NameType = ... # 0x0
        LongName                 : QTimeZone.NameType = ... # 0x1
        ShortName                : QTimeZone.NameType = ... # 0x2
        OffsetName               : QTimeZone.NameType = ... # 0x3

    class OffsetData(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, OffsetData: PySide2.QtCore.QTimeZone.OffsetData) -> None: ...


    class TimeType(Shiboken.Enum):
        StandardTime             : QTimeZone.TimeType = ... # 0x0
        DaylightTime             : QTimeZone.TimeType = ... # 0x1
        GenericTime              : QTimeZone.TimeType = ... # 0x2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, ianaId: PySide2.QtCore.QByteArray) -> None: ...
    @typing.overload
    def __init__(self, offsetSeconds: int) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QTimeZone) -> None: ...
    @typing.overload
    def __init__(self, zoneId: PySide2.QtCore.QByteArray, offsetSeconds: int, name: str, abbreviation: str, country: PySide2.QtCore.QLocale.Country = ..., comment: str = ...) -> None: ...


class QTimer(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QTimerEvent(PySide2.QtCore.QEvent):

    def __init__(self, timerId: int) -> None: ...


class QTranslator(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QTransposeProxyModel(PySide2.QtCore.QAbstractProxyModel):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QUrl(Shiboken.Object):
    PrettyDecoded            : QUrl.ComponentFormattingOption = ... # 0x0
    EncodeSpaces             : QUrl.ComponentFormattingOption = ... # 0x100000
    EncodeUnicode            : QUrl.ComponentFormattingOption = ... # 0x200000
    EncodeDelimiters         : QUrl.ComponentFormattingOption = ... # 0xc00000
    EncodeReserved           : QUrl.ComponentFormattingOption = ... # 0x1000000
    FullyEncoded             : QUrl.ComponentFormattingOption = ... # 0x1f00000
    DecodeReserved           : QUrl.ComponentFormattingOption = ... # 0x2000000
    FullyDecoded             : QUrl.ComponentFormattingOption = ... # 0x7f00000
    TolerantMode             : QUrl.ParsingMode = ... # 0x0
    StrictMode               : QUrl.ParsingMode = ... # 0x1
    DecodedMode              : QUrl.ParsingMode = ... # 0x2
    None_                    : QUrl.UrlFormattingOption = ... # 0x0
    RemoveScheme             : QUrl.UrlFormattingOption = ... # 0x1
    RemovePassword           : QUrl.UrlFormattingOption = ... # 0x2
    RemoveUserInfo           : QUrl.UrlFormattingOption = ... # 0x6
    RemovePort               : QUrl.UrlFormattingOption = ... # 0x8
    RemoveAuthority          : QUrl.UrlFormattingOption = ... # 0x1e
    RemovePath               : QUrl.UrlFormattingOption = ... # 0x20
    RemoveQuery              : QUrl.UrlFormattingOption = ... # 0x40
    RemoveFragment           : QUrl.UrlFormattingOption = ... # 0x80
    PreferLocalFile          : QUrl.UrlFormattingOption = ... # 0x200
    StripTrailingSlash       : QUrl.UrlFormattingOption = ... # 0x400
    RemoveFilename           : QUrl.UrlFormattingOption = ... # 0x800
    NormalizePathSegments    : QUrl.UrlFormattingOption = ... # 0x1000
    DefaultResolution        : QUrl.UserInputResolutionOption = ... # 0x0
    AssumeLocalFile          : QUrl.UserInputResolutionOption = ... # 0x1

    class ComponentFormattingOption(Shiboken.Enum):
        PrettyDecoded            : QUrl.ComponentFormattingOption = ... # 0x0
        EncodeSpaces             : QUrl.ComponentFormattingOption = ... # 0x100000
        EncodeUnicode            : QUrl.ComponentFormattingOption = ... # 0x200000
        EncodeDelimiters         : QUrl.ComponentFormattingOption = ... # 0xc00000
        EncodeReserved           : QUrl.ComponentFormattingOption = ... # 0x1000000
        FullyEncoded             : QUrl.ComponentFormattingOption = ... # 0x1f00000
        DecodeReserved           : QUrl.ComponentFormattingOption = ... # 0x2000000
        FullyDecoded             : QUrl.ComponentFormattingOption = ... # 0x7f00000

    class FormattingOptions(object): ...

    class ParsingMode(Shiboken.Enum):
        TolerantMode             : QUrl.ParsingMode = ... # 0x0
        StrictMode               : QUrl.ParsingMode = ... # 0x1
        DecodedMode              : QUrl.ParsingMode = ... # 0x2

    class UrlFormattingOption(Shiboken.Enum):
        None_                    : QUrl.UrlFormattingOption = ... # 0x0
        RemoveScheme             : QUrl.UrlFormattingOption = ... # 0x1
        RemovePassword           : QUrl.UrlFormattingOption = ... # 0x2
        RemoveUserInfo           : QUrl.UrlFormattingOption = ... # 0x6
        RemovePort               : QUrl.UrlFormattingOption = ... # 0x8
        RemoveAuthority          : QUrl.UrlFormattingOption = ... # 0x1e
        RemovePath               : QUrl.UrlFormattingOption = ... # 0x20
        RemoveQuery              : QUrl.UrlFormattingOption = ... # 0x40
        RemoveFragment           : QUrl.UrlFormattingOption = ... # 0x80
        PreferLocalFile          : QUrl.UrlFormattingOption = ... # 0x200
        StripTrailingSlash       : QUrl.UrlFormattingOption = ... # 0x400
        RemoveFilename           : QUrl.UrlFormattingOption = ... # 0x800
        NormalizePathSegments    : QUrl.UrlFormattingOption = ... # 0x1000

    class UserInputResolutionOption(Shiboken.Enum):
        DefaultResolution        : QUrl.UserInputResolutionOption = ... # 0x0
        AssumeLocalFile          : QUrl.UserInputResolutionOption = ... # 0x1

    class UserInputResolutionOptions(object): ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, copy: PySide2.QtCore.QUrl) -> None: ...
    @typing.overload
    def __init__(self, url: str, mode: PySide2.QtCore.QUrl.ParsingMode = ...) -> None: ...


class QUrlQuery(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtCore.QUrlQuery) -> None: ...
    @typing.overload
    def __init__(self, queryString: str) -> None: ...
    @typing.overload
    def __init__(self, url: PySide2.QtCore.QUrl) -> None: ...


class QUuid(Shiboken.Object):
    WithBraces               : QUuid.StringFormat = ... # 0x0
    WithoutBraces            : QUuid.StringFormat = ... # 0x1
    Id128                    : QUuid.StringFormat = ... # 0x3
    VarUnknown               : QUuid.Variant = ... # -0x1
    NCS                      : QUuid.Variant = ... # 0x0
    DCE                      : QUuid.Variant = ... # 0x2
    Microsoft                : QUuid.Variant = ... # 0x6
    Reserved                 : QUuid.Variant = ... # 0x7
    VerUnknown               : QUuid.Version = ... # -0x1
    Time                     : QUuid.Version = ... # 0x1
    EmbeddedPOSIX            : QUuid.Version = ... # 0x2
    Md5                      : QUuid.Version = ... # 0x3
    Name                     : QUuid.Version = ... # 0x3
    Random                   : QUuid.Version = ... # 0x4
    Sha1                     : QUuid.Version = ... # 0x5

    class StringFormat(Shiboken.Enum):
        WithBraces               : QUuid.StringFormat = ... # 0x0
        WithoutBraces            : QUuid.StringFormat = ... # 0x1
        Id128                    : QUuid.StringFormat = ... # 0x3

    class Variant(Shiboken.Enum):
        VarUnknown               : QUuid.Variant = ... # -0x1
        NCS                      : QUuid.Variant = ... # 0x0
        DCE                      : QUuid.Variant = ... # 0x2
        Microsoft                : QUuid.Variant = ... # 0x6
        Reserved                 : QUuid.Variant = ... # 0x7

    class Version(Shiboken.Enum):
        VerUnknown               : QUuid.Version = ... # -0x1
        Time                     : QUuid.Version = ... # 0x1
        EmbeddedPOSIX            : QUuid.Version = ... # 0x2
        Md5                      : QUuid.Version = ... # 0x3
        Name                     : QUuid.Version = ... # 0x3
        Random                   : QUuid.Version = ... # 0x4
        Sha1                     : QUuid.Version = ... # 0x5

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QByteArray) -> None: ...
    @typing.overload
    def __init__(self, arg__1: str) -> None: ...
    @typing.overload
    def __init__(self, arg__1: bytes) -> None: ...
    @typing.overload
    def __init__(self, l: int, w1: int, w2: int, b1: int, b2: int, b3: int, b4: int, b5: int, b6: int, b7: int, b8: int) -> None: ...


class QVariantAnimation(PySide2.QtCore.QAbstractAnimation):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QVersionNumber(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, maj: int) -> None: ...
    @typing.overload
    def __init__(self, maj: int, min: int) -> None: ...
    @typing.overload
    def __init__(self, maj: int, min: int, mic: int) -> None: ...
    @typing.overload
    def __init__(self, seg: typing.List[int]) -> None: ...


class QWaitCondition(Shiboken.Object):

    def __init__(self) -> None: ...


class QWriteLocker(Shiboken.Object):

    def __init__(self, readWriteLock: PySide2.QtCore.QReadWriteLock) -> None: ...


class QXmlStreamAttribute(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QXmlStreamAttribute) -> None: ...
    @typing.overload
    def __init__(self, namespaceUri: str, name: str, value: str) -> None: ...
    @typing.overload
    def __init__(self, qualifiedName: str, value: str) -> None: ...


class QXmlStreamAttributes(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QXmlStreamAttributes: PySide2.QtCore.QXmlStreamAttributes) -> None: ...


class QXmlStreamEntityDeclaration(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QXmlStreamEntityDeclaration) -> None: ...


class QXmlStreamEntityResolver(Shiboken.Object):

    def __init__(self) -> None: ...


class QXmlStreamNamespaceDeclaration(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QXmlStreamNamespaceDeclaration) -> None: ...
    @typing.overload
    def __init__(self, prefix: str, namespaceUri: str) -> None: ...


class QXmlStreamNotationDeclaration(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QXmlStreamNotationDeclaration) -> None: ...


class QXmlStreamReader(Shiboken.Object):
    NoError                  : QXmlStreamReader.Error = ... # 0x0
    UnexpectedElementError   : QXmlStreamReader.Error = ... # 0x1
    CustomError              : QXmlStreamReader.Error = ... # 0x2
    NotWellFormedError       : QXmlStreamReader.Error = ... # 0x3
    PrematureEndOfDocumentError: QXmlStreamReader.Error = ... # 0x4
    ErrorOnUnexpectedElement : QXmlStreamReader.ReadElementTextBehaviour = ... # 0x0
    IncludeChildElements     : QXmlStreamReader.ReadElementTextBehaviour = ... # 0x1
    SkipChildElements        : QXmlStreamReader.ReadElementTextBehaviour = ... # 0x2
    NoToken                  : QXmlStreamReader.TokenType = ... # 0x0
    Invalid                  : QXmlStreamReader.TokenType = ... # 0x1
    StartDocument            : QXmlStreamReader.TokenType = ... # 0x2
    EndDocument              : QXmlStreamReader.TokenType = ... # 0x3
    StartElement             : QXmlStreamReader.TokenType = ... # 0x4
    EndElement               : QXmlStreamReader.TokenType = ... # 0x5
    Characters               : QXmlStreamReader.TokenType = ... # 0x6
    Comment                  : QXmlStreamReader.TokenType = ... # 0x7
    DTD                      : QXmlStreamReader.TokenType = ... # 0x8
    EntityReference          : QXmlStreamReader.TokenType = ... # 0x9
    ProcessingInstruction    : QXmlStreamReader.TokenType = ... # 0xa

    class Error(Shiboken.Enum):
        NoError                  : QXmlStreamReader.Error = ... # 0x0
        UnexpectedElementError   : QXmlStreamReader.Error = ... # 0x1
        CustomError              : QXmlStreamReader.Error = ... # 0x2
        NotWellFormedError       : QXmlStreamReader.Error = ... # 0x3
        PrematureEndOfDocumentError: QXmlStreamReader.Error = ... # 0x4

    class ReadElementTextBehaviour(Shiboken.Enum):
        ErrorOnUnexpectedElement : QXmlStreamReader.ReadElementTextBehaviour = ... # 0x0
        IncludeChildElements     : QXmlStreamReader.ReadElementTextBehaviour = ... # 0x1
        SkipChildElements        : QXmlStreamReader.ReadElementTextBehaviour = ... # 0x2

    class TokenType(Shiboken.Enum):
        NoToken                  : QXmlStreamReader.TokenType = ... # 0x0
        Invalid                  : QXmlStreamReader.TokenType = ... # 0x1
        StartDocument            : QXmlStreamReader.TokenType = ... # 0x2
        EndDocument              : QXmlStreamReader.TokenType = ... # 0x3
        StartElement             : QXmlStreamReader.TokenType = ... # 0x4
        EndElement               : QXmlStreamReader.TokenType = ... # 0x5
        Characters               : QXmlStreamReader.TokenType = ... # 0x6
        Comment                  : QXmlStreamReader.TokenType = ... # 0x7
        DTD                      : QXmlStreamReader.TokenType = ... # 0x8
        EntityReference          : QXmlStreamReader.TokenType = ... # 0x9
        ProcessingInstruction    : QXmlStreamReader.TokenType = ... # 0xa

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, data: PySide2.QtCore.QByteArray) -> None: ...
    @typing.overload
    def __init__(self, data: str) -> None: ...
    @typing.overload
    def __init__(self, data: bytes) -> None: ...
    @typing.overload
    def __init__(self, device: PySide2.QtCore.QIODevice) -> None: ...


class QXmlStreamWriter(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, array: PySide2.QtCore.QByteArray) -> None: ...
    @typing.overload
    def __init__(self, device: PySide2.QtCore.QIODevice) -> None: ...


class Qt(Shiboken.Object):
    AlignLeading             : Qt.AlignmentFlag = ... # 0x1
    AlignLeft                : Qt.AlignmentFlag = ... # 0x1
    AlignRight               : Qt.AlignmentFlag = ... # 0x2
    AlignTrailing            : Qt.AlignmentFlag = ... # 0x2
    AlignHCenter             : Qt.AlignmentFlag = ... # 0x4
    AlignJustify             : Qt.AlignmentFlag = ... # 0x8
    AlignAbsolute            : Qt.AlignmentFlag = ... # 0x10
    AlignHorizontal_Mask     : Qt.AlignmentFlag = ... # 0x1f
    AlignTop                 : Qt.AlignmentFlag = ... # 0x20
    AlignBottom              : Qt.AlignmentFlag = ... # 0x40
    AlignVCenter             : Qt.AlignmentFlag = ... # 0x80
    AlignCenter              : Qt.AlignmentFlag = ... # 0x84
    AlignBaseline            : Qt.AlignmentFlag = ... # 0x100
    AlignVertical_Mask       : Qt.AlignmentFlag = ... # 0x1e0
    AnchorLeft               : Qt.AnchorPoint = ... # 0x0
    AnchorHorizontalCenter   : Qt.AnchorPoint = ... # 0x1
    AnchorRight              : Qt.AnchorPoint = ... # 0x2
    AnchorTop                : Qt.AnchorPoint = ... # 0x3
    AnchorVerticalCenter     : Qt.AnchorPoint = ... # 0x4
    AnchorBottom             : Qt.AnchorPoint = ... # 0x5
    AA_ImmediateWidgetCreation: Qt.ApplicationAttribute = ... # 0x0
    AA_MSWindowsUseDirect3DByDefault: Qt.ApplicationAttribute = ... # 0x1
    AA_DontShowIconsInMenus  : Qt.ApplicationAttribute = ... # 0x2
    AA_NativeWindows         : Qt.ApplicationAttribute = ... # 0x3
    AA_DontCreateNativeWidgetSiblings: Qt.ApplicationAttribute = ... # 0x4
    AA_MacPluginApplication  : Qt.ApplicationAttribute = ... # 0x5
    AA_PluginApplication     : Qt.ApplicationAttribute = ... # 0x5
    AA_DontUseNativeMenuBar  : Qt.ApplicationAttribute = ... # 0x6
    AA_MacDontSwapCtrlAndMeta: Qt.ApplicationAttribute = ... # 0x7
    AA_Use96Dpi              : Qt.ApplicationAttribute = ... # 0x8
    AA_DisableNativeVirtualKeyboard: Qt.ApplicationAttribute = ... # 0x9
    AA_X11InitThreads        : Qt.ApplicationAttribute = ... # 0xa
    AA_SynthesizeTouchForUnhandledMouseEvents: Qt.ApplicationAttribute = ... # 0xb
    AA_SynthesizeMouseForUnhandledTouchEvents: Qt.ApplicationAttribute = ... # 0xc
    AA_UseHighDpiPixmaps     : Qt.ApplicationAttribute = ... # 0xd
    AA_ForceRasterWidgets    : Qt.ApplicationAttribute = ... # 0xe
    AA_UseDesktopOpenGL      : Qt.ApplicationAttribute = ... # 0xf
    AA_UseOpenGLES           : Qt.ApplicationAttribute = ... # 0x10
    AA_UseSoftwareOpenGL     : Qt.ApplicationAttribute = ... # 0x11
    AA_ShareOpenGLContexts   : Qt.ApplicationAttribute = ... # 0x12
    AA_SetPalette            : Qt.ApplicationAttribute = ... # 0x13
    AA_EnableHighDpiScaling  : Qt.ApplicationAttribute = ... # 0x14
    AA_DisableHighDpiScaling : Qt.ApplicationAttribute = ... # 0x15
    AA_UseStyleSheetPropagationInWidgetStyles: Qt.ApplicationAttribute = ... # 0x16
    AA_DontUseNativeDialogs  : Qt.ApplicationAttribute = ... # 0x17
    AA_SynthesizeMouseForUnhandledTabletEvents: Qt.ApplicationAttribute = ... # 0x18
    AA_CompressHighFrequencyEvents: Qt.ApplicationAttribute = ... # 0x19
    AA_DontCheckOpenGLContextThreadAffinity: Qt.ApplicationAttribute = ... # 0x1a
    AA_DisableShaderDiskCache: Qt.ApplicationAttribute = ... # 0x1b
    AA_DontShowShortcutsInContextMenus: Qt.ApplicationAttribute = ... # 0x1c
    AA_CompressTabletEvents  : Qt.ApplicationAttribute = ... # 0x1d
    AA_DisableWindowContextHelpButton: Qt.ApplicationAttribute = ... # 0x1e
    AA_DisableSessionManager : Qt.ApplicationAttribute = ... # 0x1f
    AA_AttributeCount        : Qt.ApplicationAttribute = ... # 0x20
    ApplicationSuspended     : Qt.ApplicationState = ... # 0x0
    ApplicationHidden        : Qt.ApplicationState = ... # 0x1
    ApplicationInactive      : Qt.ApplicationState = ... # 0x2
    ApplicationActive        : Qt.ApplicationState = ... # 0x4
    NoArrow                  : Qt.ArrowType = ... # 0x0
    UpArrow                  : Qt.ArrowType = ... # 0x1
    DownArrow                : Qt.ArrowType = ... # 0x2
    LeftArrow                : Qt.ArrowType = ... # 0x3
    RightArrow               : Qt.ArrowType = ... # 0x4
    IgnoreAspectRatio        : Qt.AspectRatioMode = ... # 0x0
    KeepAspectRatio          : Qt.AspectRatioMode = ... # 0x1
    KeepAspectRatioByExpanding: Qt.AspectRatioMode = ... # 0x2
    XAxis                    : Qt.Axis = ... # 0x0
    YAxis                    : Qt.Axis = ... # 0x1
    ZAxis                    : Qt.Axis = ... # 0x2
    TransparentMode          : Qt.BGMode = ... # 0x0
    OpaqueMode               : Qt.BGMode = ... # 0x1
    NoBrush                  : Qt.BrushStyle = ... # 0x0
    SolidPattern             : Qt.BrushStyle = ... # 0x1
    Dense1Pattern            : Qt.BrushStyle = ... # 0x2
    Dense2Pattern            : Qt.BrushStyle = ... # 0x3
    Dense3Pattern            : Qt.BrushStyle = ... # 0x4
    Dense4Pattern            : Qt.BrushStyle = ... # 0x5
    Dense5Pattern            : Qt.BrushStyle = ... # 0x6
    Dense6Pattern            : Qt.BrushStyle = ... # 0x7
    Dense7Pattern            : Qt.BrushStyle = ... # 0x8
    HorPattern               : Qt.BrushStyle = ... # 0x9
    VerPattern               : Qt.BrushStyle = ... # 0xa
    CrossPattern             : Qt.BrushStyle = ... # 0xb
    BDiagPattern             : Qt.BrushStyle = ... # 0xc
    FDiagPattern             : Qt.BrushStyle = ... # 0xd
    DiagCrossPattern         : Qt.BrushStyle = ... # 0xe
    LinearGradientPattern    : Qt.BrushStyle = ... # 0xf
    RadialGradientPattern    : Qt.BrushStyle = ... # 0x10
    ConicalGradientPattern   : Qt.BrushStyle = ... # 0x11
    TexturePattern           : Qt.BrushStyle = ... # 0x18
    CaseInsensitive          : Qt.CaseSensitivity = ... # 0x0
    CaseSensitive            : Qt.CaseSensitivity = ... # 0x1
    Unchecked                : Qt.CheckState = ... # 0x0
    PartiallyChecked         : Qt.CheckState = ... # 0x1
    Checked                  : Qt.CheckState = ... # 0x2
    ChecksumIso3309          : Qt.ChecksumType = ... # 0x0
    ChecksumItuV41           : Qt.ChecksumType = ... # 0x1
    NoClip                   : Qt.ClipOperation = ... # 0x0
    ReplaceClip              : Qt.ClipOperation = ... # 0x1
    IntersectClip            : Qt.ClipOperation = ... # 0x2
    AutoConnection           : Qt.ConnectionType = ... # 0x0
    DirectConnection         : Qt.ConnectionType = ... # 0x1
    QueuedConnection         : Qt.ConnectionType = ... # 0x2
    BlockingQueuedConnection : Qt.ConnectionType = ... # 0x3
    UniqueConnection         : Qt.ConnectionType = ... # 0x80
    NoContextMenu            : Qt.ContextMenuPolicy = ... # 0x0
    DefaultContextMenu       : Qt.ContextMenuPolicy = ... # 0x1
    ActionsContextMenu       : Qt.ContextMenuPolicy = ... # 0x2
    CustomContextMenu        : Qt.ContextMenuPolicy = ... # 0x3
    PreventContextMenu       : Qt.ContextMenuPolicy = ... # 0x4
    DeviceCoordinates        : Qt.CoordinateSystem = ... # 0x0
    LogicalCoordinates       : Qt.CoordinateSystem = ... # 0x1
    TopLeftCorner            : Qt.Corner = ... # 0x0
    TopRightCorner           : Qt.Corner = ... # 0x1
    BottomLeftCorner         : Qt.Corner = ... # 0x2
    BottomRightCorner        : Qt.Corner = ... # 0x3
    LogicalMoveStyle         : Qt.CursorMoveStyle = ... # 0x0
    VisualMoveStyle          : Qt.CursorMoveStyle = ... # 0x1
    ArrowCursor              : Qt.CursorShape = ... # 0x0
    UpArrowCursor            : Qt.CursorShape = ... # 0x1
    CrossCursor              : Qt.CursorShape = ... # 0x2
    WaitCursor               : Qt.CursorShape = ... # 0x3
    IBeamCursor              : Qt.CursorShape = ... # 0x4
    SizeVerCursor            : Qt.CursorShape = ... # 0x5
    SizeHorCursor            : Qt.CursorShape = ... # 0x6
    SizeBDiagCursor          : Qt.CursorShape = ... # 0x7
    SizeFDiagCursor          : Qt.CursorShape = ... # 0x8
    SizeAllCursor            : Qt.CursorShape = ... # 0x9
    BlankCursor              : Qt.CursorShape = ... # 0xa
    SplitVCursor             : Qt.CursorShape = ... # 0xb
    SplitHCursor             : Qt.CursorShape = ... # 0xc
    PointingHandCursor       : Qt.CursorShape = ... # 0xd
    ForbiddenCursor          : Qt.CursorShape = ... # 0xe
    WhatsThisCursor          : Qt.CursorShape = ... # 0xf
    BusyCursor               : Qt.CursorShape = ... # 0x10
    OpenHandCursor           : Qt.CursorShape = ... # 0x11
    ClosedHandCursor         : Qt.CursorShape = ... # 0x12
    DragCopyCursor           : Qt.CursorShape = ... # 0x13
    DragMoveCursor           : Qt.CursorShape = ... # 0x14
    DragLinkCursor           : Qt.CursorShape = ... # 0x15
    LastCursor               : Qt.CursorShape = ... # 0x15
    BitmapCursor             : Qt.CursorShape = ... # 0x18
    CustomCursor             : Qt.CursorShape = ... # 0x19
    TextDate                 : Qt.DateFormat = ... # 0x0
    ISODate                  : Qt.DateFormat = ... # 0x1
    LocalDate                : Qt.DateFormat = ... # 0x2
    SystemLocaleDate         : Qt.DateFormat = ... # 0x2
    LocaleDate               : Qt.DateFormat = ... # 0x3
    SystemLocaleShortDate    : Qt.DateFormat = ... # 0x4
    SystemLocaleLongDate     : Qt.DateFormat = ... # 0x5
    DefaultLocaleShortDate   : Qt.DateFormat = ... # 0x6
    DefaultLocaleLongDate    : Qt.DateFormat = ... # 0x7
    RFC2822Date              : Qt.DateFormat = ... # 0x8
    ISODateWithMs            : Qt.DateFormat = ... # 0x9
    Monday                   : Qt.DayOfWeek = ... # 0x1
    Tuesday                  : Qt.DayOfWeek = ... # 0x2
    Wednesday                : Qt.DayOfWeek = ... # 0x3
    Thursday                 : Qt.DayOfWeek = ... # 0x4
    Friday                   : Qt.DayOfWeek = ... # 0x5
    Saturday                 : Qt.DayOfWeek = ... # 0x6
    Sunday                   : Qt.DayOfWeek = ... # 0x7
    NoDockWidgetArea         : Qt.DockWidgetArea = ... # 0x0
    LeftDockWidgetArea       : Qt.DockWidgetArea = ... # 0x1
    RightDockWidgetArea      : Qt.DockWidgetArea = ... # 0x2
    TopDockWidgetArea        : Qt.DockWidgetArea = ... # 0x4
    BottomDockWidgetArea     : Qt.DockWidgetArea = ... # 0x8
    AllDockWidgetAreas       : Qt.DockWidgetArea = ... # 0xf
    DockWidgetArea_Mask      : Qt.DockWidgetArea = ... # 0xf
    NDockWidgetAreas         : Qt.DockWidgetAreaSizes = ... # 0x4
    IgnoreAction             : Qt.DropAction = ... # 0x0
    CopyAction               : Qt.DropAction = ... # 0x1
    MoveAction               : Qt.DropAction = ... # 0x2
    LinkAction               : Qt.DropAction = ... # 0x4
    ActionMask               : Qt.DropAction = ... # 0xff
    TargetMoveAction         : Qt.DropAction = ... # 0x8002
    TopEdge                  : Qt.Edge = ... # 0x1
    LeftEdge                 : Qt.Edge = ... # 0x2
    RightEdge                : Qt.Edge = ... # 0x4
    BottomEdge               : Qt.Edge = ... # 0x8
    EnterKeyDefault          : Qt.EnterKeyType = ... # 0x0
    EnterKeyReturn           : Qt.EnterKeyType = ... # 0x1
    EnterKeyDone             : Qt.EnterKeyType = ... # 0x2
    EnterKeyGo               : Qt.EnterKeyType = ... # 0x3
    EnterKeySend             : Qt.EnterKeyType = ... # 0x4
    EnterKeySearch           : Qt.EnterKeyType = ... # 0x5
    EnterKeyNext             : Qt.EnterKeyType = ... # 0x6
    EnterKeyPrevious         : Qt.EnterKeyType = ... # 0x7
    LowEventPriority         : Qt.EventPriority = ... # -0x1
    NormalEventPriority      : Qt.EventPriority = ... # 0x0
    HighEventPriority        : Qt.EventPriority = ... # 0x1
    OddEvenFill              : Qt.FillRule = ... # 0x0
    WindingFill              : Qt.FillRule = ... # 0x1
    FindDirectChildrenOnly   : Qt.FindChildOption = ... # 0x0
    FindChildrenRecursively  : Qt.FindChildOption = ... # 0x1
    NoFocus                  : Qt.FocusPolicy = ... # 0x0
    TabFocus                 : Qt.FocusPolicy = ... # 0x1
    ClickFocus               : Qt.FocusPolicy = ... # 0x2
    StrongFocus              : Qt.FocusPolicy = ... # 0xb
    WheelFocus               : Qt.FocusPolicy = ... # 0xf
    MouseFocusReason         : Qt.FocusReason = ... # 0x0
    TabFocusReason           : Qt.FocusReason = ... # 0x1
    BacktabFocusReason       : Qt.FocusReason = ... # 0x2
    ActiveWindowFocusReason  : Qt.FocusReason = ... # 0x3
    PopupFocusReason         : Qt.FocusReason = ... # 0x4
    ShortcutFocusReason      : Qt.FocusReason = ... # 0x5
    MenuBarFocusReason       : Qt.FocusReason = ... # 0x6
    OtherFocusReason         : Qt.FocusReason = ... # 0x7
    NoFocusReason            : Qt.FocusReason = ... # 0x8
    DontStartGestureOnChildren: Qt.GestureFlag = ... # 0x1
    ReceivePartialGestures   : Qt.GestureFlag = ... # 0x2
    IgnoredGesturesPropagateToParent: Qt.GestureFlag = ... # 0x4
    NoGesture                : Qt.GestureState = ... # 0x0
    GestureStarted           : Qt.GestureState = ... # 0x1
    GestureUpdated           : Qt.GestureState = ... # 0x2
    GestureFinished          : Qt.GestureState = ... # 0x3
    GestureCanceled          : Qt.GestureState = ... # 0x4
    TapGesture               : Qt.GestureType = ... # 0x1
    TapAndHoldGesture        : Qt.GestureType = ... # 0x2
    PanGesture               : Qt.GestureType = ... # 0x3
    PinchGesture             : Qt.GestureType = ... # 0x4
    SwipeGesture             : Qt.GestureType = ... # 0x5
    CustomGesture            : Qt.GestureType = ... # 0x100
    LastGestureType          : Qt.GestureType = ... # 0xffffffff
    color0                   : Qt.GlobalColor = ... # 0x0
    color1                   : Qt.GlobalColor = ... # 0x1
    black                    : Qt.GlobalColor = ... # 0x2
    white                    : Qt.GlobalColor = ... # 0x3
    darkGray                 : Qt.GlobalColor = ... # 0x4
    gray                     : Qt.GlobalColor = ... # 0x5
    lightGray                : Qt.GlobalColor = ... # 0x6
    red                      : Qt.GlobalColor = ... # 0x7
    green                    : Qt.GlobalColor = ... # 0x8
    blue                     : Qt.GlobalColor = ... # 0x9
    cyan                     : Qt.GlobalColor = ... # 0xa
    magenta                  : Qt.GlobalColor = ... # 0xb
    yellow                   : Qt.GlobalColor = ... # 0xc
    darkRed                  : Qt.GlobalColor = ... # 0xd
    darkGreen                : Qt.GlobalColor = ... # 0xe
    darkBlue                 : Qt.GlobalColor = ... # 0xf
    darkCyan                 : Qt.GlobalColor = ... # 0x10
    darkMagenta              : Qt.GlobalColor = ... # 0x11
    darkYellow               : Qt.GlobalColor = ... # 0x12
    transparent              : Qt.GlobalColor = ... # 0x13
    ExactHit                 : Qt.HitTestAccuracy = ... # 0x0
    FuzzyHit                 : Qt.HitTestAccuracy = ... # 0x1
    AutoColor                : Qt.ImageConversionFlag = ... # 0x0
    AutoDither               : Qt.ImageConversionFlag = ... # 0x0
    DiffuseDither            : Qt.ImageConversionFlag = ... # 0x0
    ThresholdAlphaDither     : Qt.ImageConversionFlag = ... # 0x0
    MonoOnly                 : Qt.ImageConversionFlag = ... # 0x2
    ColorMode_Mask           : Qt.ImageConversionFlag = ... # 0x3
    ColorOnly                : Qt.ImageConversionFlag = ... # 0x3
    OrderedAlphaDither       : Qt.ImageConversionFlag = ... # 0x4
    DiffuseAlphaDither       : Qt.ImageConversionFlag = ... # 0x8
    AlphaDither_Mask         : Qt.ImageConversionFlag = ... # 0xc
    NoAlpha                  : Qt.ImageConversionFlag = ... # 0xc
    OrderedDither            : Qt.ImageConversionFlag = ... # 0x10
    ThresholdDither          : Qt.ImageConversionFlag = ... # 0x20
    Dither_Mask              : Qt.ImageConversionFlag = ... # 0x30
    PreferDither             : Qt.ImageConversionFlag = ... # 0x40
    AvoidDither              : Qt.ImageConversionFlag = ... # 0x80
    DitherMode_Mask          : Qt.ImageConversionFlag = ... # 0xc0
    NoOpaqueDetection        : Qt.ImageConversionFlag = ... # 0x100
    NoFormatConversion       : Qt.ImageConversionFlag = ... # 0x200
    ImhNone                  : Qt.InputMethodHint = ... # 0x0
    ImhHiddenText            : Qt.InputMethodHint = ... # 0x1
    ImhSensitiveData         : Qt.InputMethodHint = ... # 0x2
    ImhNoAutoUppercase       : Qt.InputMethodHint = ... # 0x4
    ImhPreferNumbers         : Qt.InputMethodHint = ... # 0x8
    ImhPreferUppercase       : Qt.InputMethodHint = ... # 0x10
    ImhPreferLowercase       : Qt.InputMethodHint = ... # 0x20
    ImhNoPredictiveText      : Qt.InputMethodHint = ... # 0x40
    ImhDate                  : Qt.InputMethodHint = ... # 0x80
    ImhTime                  : Qt.InputMethodHint = ... # 0x100
    ImhPreferLatin           : Qt.InputMethodHint = ... # 0x200
    ImhMultiLine             : Qt.InputMethodHint = ... # 0x400
    ImhNoEditMenu            : Qt.InputMethodHint = ... # 0x800
    ImhNoTextHandles         : Qt.InputMethodHint = ... # 0x1000
    ImhDigitsOnly            : Qt.InputMethodHint = ... # 0x10000
    ImhFormattedNumbersOnly  : Qt.InputMethodHint = ... # 0x20000
    ImhUppercaseOnly         : Qt.InputMethodHint = ... # 0x40000
    ImhLowercaseOnly         : Qt.InputMethodHint = ... # 0x80000
    ImhDialableCharactersOnly: Qt.InputMethodHint = ... # 0x100000
    ImhEmailCharactersOnly   : Qt.InputMethodHint = ... # 0x200000
    ImhUrlCharactersOnly     : Qt.InputMethodHint = ... # 0x400000
    ImhLatinOnly             : Qt.InputMethodHint = ... # 0x800000
    ImhExclusiveInputMask    : Qt.InputMethodHint = ... # -0x10000
    ImEnabled                : Qt.InputMethodQuery = ... # 0x1
    ImCursorRectangle        : Qt.InputMethodQuery = ... # 0x2
    ImMicroFocus             : Qt.InputMethodQuery = ... # 0x2
    ImFont                   : Qt.InputMethodQuery = ... # 0x4
    ImCursorPosition         : Qt.InputMethodQuery = ... # 0x8
    ImSurroundingText        : Qt.InputMethodQuery = ... # 0x10
    ImCurrentSelection       : Qt.InputMethodQuery = ... # 0x20
    ImMaximumTextLength      : Qt.InputMethodQuery = ... # 0x40
    ImAnchorPosition         : Qt.InputMethodQuery = ... # 0x80
    ImHints                  : Qt.InputMethodQuery = ... # 0x100
    ImPreferredLanguage      : Qt.InputMethodQuery = ... # 0x200
    ImAbsolutePosition       : Qt.InputMethodQuery = ... # 0x400
    ImTextBeforeCursor       : Qt.InputMethodQuery = ... # 0x800
    ImTextAfterCursor        : Qt.InputMethodQuery = ... # 0x1000
    ImEnterKeyType           : Qt.InputMethodQuery = ... # 0x2000
    ImAnchorRectangle        : Qt.InputMethodQuery = ... # 0x4000
    ImQueryInput             : Qt.InputMethodQuery = ... # 0x40ba
    ImInputItemClipRectangle : Qt.InputMethodQuery = ... # 0x8000
    ImPlatformData           : Qt.InputMethodQuery = ... # -0x80000000
    ImQueryAll               : Qt.InputMethodQuery = ... # -0x1
    DisplayRole              : Qt.ItemDataRole = ... # 0x0
    DecorationRole           : Qt.ItemDataRole = ... # 0x1
    EditRole                 : Qt.ItemDataRole = ... # 0x2
    ToolTipRole              : Qt.ItemDataRole = ... # 0x3
    StatusTipRole            : Qt.ItemDataRole = ... # 0x4
    WhatsThisRole            : Qt.ItemDataRole = ... # 0x5
    FontRole                 : Qt.ItemDataRole = ... # 0x6
    TextAlignmentRole        : Qt.ItemDataRole = ... # 0x7
    BackgroundColorRole      : Qt.ItemDataRole = ... # 0x8
    BackgroundRole           : Qt.ItemDataRole = ... # 0x8
    ForegroundRole           : Qt.ItemDataRole = ... # 0x9
    TextColorRole            : Qt.ItemDataRole = ... # 0x9
    CheckStateRole           : Qt.ItemDataRole = ... # 0xa
    AccessibleTextRole       : Qt.ItemDataRole = ... # 0xb
    AccessibleDescriptionRole: Qt.ItemDataRole = ... # 0xc
    SizeHintRole             : Qt.ItemDataRole = ... # 0xd
    InitialSortOrderRole     : Qt.ItemDataRole = ... # 0xe
    DisplayPropertyRole      : Qt.ItemDataRole = ... # 0x1b
    DecorationPropertyRole   : Qt.ItemDataRole = ... # 0x1c
    ToolTipPropertyRole      : Qt.ItemDataRole = ... # 0x1d
    StatusTipPropertyRole    : Qt.ItemDataRole = ... # 0x1e
    WhatsThisPropertyRole    : Qt.ItemDataRole = ... # 0x1f
    UserRole                 : Qt.ItemDataRole = ... # 0x100
    NoItemFlags              : Qt.ItemFlag = ... # 0x0
    ItemIsSelectable         : Qt.ItemFlag = ... # 0x1
    ItemIsEditable           : Qt.ItemFlag = ... # 0x2
    ItemIsDragEnabled        : Qt.ItemFlag = ... # 0x4
    ItemIsDropEnabled        : Qt.ItemFlag = ... # 0x8
    ItemIsUserCheckable      : Qt.ItemFlag = ... # 0x10
    ItemIsEnabled            : Qt.ItemFlag = ... # 0x20
    ItemIsAutoTristate       : Qt.ItemFlag = ... # 0x40
    ItemIsTristate           : Qt.ItemFlag = ... # 0x40
    ItemNeverHasChildren     : Qt.ItemFlag = ... # 0x80
    ItemIsUserTristate       : Qt.ItemFlag = ... # 0x100
    ContainsItemShape        : Qt.ItemSelectionMode = ... # 0x0
    IntersectsItemShape      : Qt.ItemSelectionMode = ... # 0x1
    ContainsItemBoundingRect : Qt.ItemSelectionMode = ... # 0x2
    IntersectsItemBoundingRect: Qt.ItemSelectionMode = ... # 0x3
    ReplaceSelection         : Qt.ItemSelectionOperation = ... # 0x0
    AddToSelection           : Qt.ItemSelectionOperation = ... # 0x1
    Key_Any                  : Qt.Key = ... # 0x20
    Key_Space                : Qt.Key = ... # 0x20
    Key_Exclam               : Qt.Key = ... # 0x21
    Key_QuoteDbl             : Qt.Key = ... # 0x22
    Key_NumberSign           : Qt.Key = ... # 0x23
    Key_Dollar               : Qt.Key = ... # 0x24
    Key_Percent              : Qt.Key = ... # 0x25
    Key_Ampersand            : Qt.Key = ... # 0x26
    Key_Apostrophe           : Qt.Key = ... # 0x27
    Key_ParenLeft            : Qt.Key = ... # 0x28
    Key_ParenRight           : Qt.Key = ... # 0x29
    Key_Asterisk             : Qt.Key = ... # 0x2a
    Key_Plus                 : Qt.Key = ... # 0x2b
    Key_Comma                : Qt.Key = ... # 0x2c
    Key_Minus                : Qt.Key = ... # 0x2d
    Key_Period               : Qt.Key = ... # 0x2e
    Key_Slash                : Qt.Key = ... # 0x2f
    Key_0                    : Qt.Key = ... # 0x30
    Key_1                    : Qt.Key = ... # 0x31
    Key_2                    : Qt.Key = ... # 0x32
    Key_3                    : Qt.Key = ... # 0x33
    Key_4                    : Qt.Key = ... # 0x34
    Key_5                    : Qt.Key = ... # 0x35
    Key_6                    : Qt.Key = ... # 0x36
    Key_7                    : Qt.Key = ... # 0x37
    Key_8                    : Qt.Key = ... # 0x38
    Key_9                    : Qt.Key = ... # 0x39
    Key_Colon                : Qt.Key = ... # 0x3a
    Key_Semicolon            : Qt.Key = ... # 0x3b
    Key_Less                 : Qt.Key = ... # 0x3c
    Key_Equal                : Qt.Key = ... # 0x3d
    Key_Greater              : Qt.Key = ... # 0x3e
    Key_Question             : Qt.Key = ... # 0x3f
    Key_At                   : Qt.Key = ... # 0x40
    Key_A                    : Qt.Key = ... # 0x41
    Key_B                    : Qt.Key = ... # 0x42
    Key_C                    : Qt.Key = ... # 0x43
    Key_D                    : Qt.Key = ... # 0x44
    Key_E                    : Qt.Key = ... # 0x45
    Key_F                    : Qt.Key = ... # 0x46
    Key_G                    : Qt.Key = ... # 0x47
    Key_H                    : Qt.Key = ... # 0x48
    Key_I                    : Qt.Key = ... # 0x49
    Key_J                    : Qt.Key = ... # 0x4a
    Key_K                    : Qt.Key = ... # 0x4b
    Key_L                    : Qt.Key = ... # 0x4c
    Key_M                    : Qt.Key = ... # 0x4d
    Key_N                    : Qt.Key = ... # 0x4e
    Key_O                    : Qt.Key = ... # 0x4f
    Key_P                    : Qt.Key = ... # 0x50
    Key_Q                    : Qt.Key = ... # 0x51
    Key_R                    : Qt.Key = ... # 0x52
    Key_S                    : Qt.Key = ... # 0x53
    Key_T                    : Qt.Key = ... # 0x54
    Key_U                    : Qt.Key = ... # 0x55
    Key_V                    : Qt.Key = ... # 0x56
    Key_W                    : Qt.Key = ... # 0x57
    Key_X                    : Qt.Key = ... # 0x58
    Key_Y                    : Qt.Key = ... # 0x59
    Key_Z                    : Qt.Key = ... # 0x5a
    Key_BracketLeft          : Qt.Key = ... # 0x5b
    Key_Backslash            : Qt.Key = ... # 0x5c
    Key_BracketRight         : Qt.Key = ... # 0x5d
    Key_AsciiCircum          : Qt.Key = ... # 0x5e
    Key_Underscore           : Qt.Key = ... # 0x5f
    Key_QuoteLeft            : Qt.Key = ... # 0x60
    Key_BraceLeft            : Qt.Key = ... # 0x7b
    Key_Bar                  : Qt.Key = ... # 0x7c
    Key_BraceRight           : Qt.Key = ... # 0x7d
    Key_AsciiTilde           : Qt.Key = ... # 0x7e
    Key_nobreakspace         : Qt.Key = ... # 0xa0
    Key_exclamdown           : Qt.Key = ... # 0xa1
    Key_cent                 : Qt.Key = ... # 0xa2
    Key_sterling             : Qt.Key = ... # 0xa3
    Key_currency             : Qt.Key = ... # 0xa4
    Key_yen                  : Qt.Key = ... # 0xa5
    Key_brokenbar            : Qt.Key = ... # 0xa6
    Key_section              : Qt.Key = ... # 0xa7
    Key_diaeresis            : Qt.Key = ... # 0xa8
    Key_copyright            : Qt.Key = ... # 0xa9
    Key_ordfeminine          : Qt.Key = ... # 0xaa
    Key_guillemotleft        : Qt.Key = ... # 0xab
    Key_notsign              : Qt.Key = ... # 0xac
    Key_hyphen               : Qt.Key = ... # 0xad
    Key_registered           : Qt.Key = ... # 0xae
    Key_macron               : Qt.Key = ... # 0xaf
    Key_degree               : Qt.Key = ... # 0xb0
    Key_plusminus            : Qt.Key = ... # 0xb1
    Key_twosuperior          : Qt.Key = ... # 0xb2
    Key_threesuperior        : Qt.Key = ... # 0xb3
    Key_acute                : Qt.Key = ... # 0xb4
    Key_mu                   : Qt.Key = ... # 0xb5
    Key_paragraph            : Qt.Key = ... # 0xb6
    Key_periodcentered       : Qt.Key = ... # 0xb7
    Key_cedilla              : Qt.Key = ... # 0xb8
    Key_onesuperior          : Qt.Key = ... # 0xb9
    Key_masculine            : Qt.Key = ... # 0xba
    Key_guillemotright       : Qt.Key = ... # 0xbb
    Key_onequarter           : Qt.Key = ... # 0xbc
    Key_onehalf              : Qt.Key = ... # 0xbd
    Key_threequarters        : Qt.Key = ... # 0xbe
    Key_questiondown         : Qt.Key = ... # 0xbf
    Key_Agrave               : Qt.Key = ... # 0xc0
    Key_Aacute               : Qt.Key = ... # 0xc1
    Key_Acircumflex          : Qt.Key = ... # 0xc2
    Key_Atilde               : Qt.Key = ... # 0xc3
    Key_Adiaeresis           : Qt.Key = ... # 0xc4
    Key_Aring                : Qt.Key = ... # 0xc5
    Key_AE                   : Qt.Key = ... # 0xc6
    Key_Ccedilla             : Qt.Key = ... # 0xc7
    Key_Egrave               : Qt.Key = ... # 0xc8
    Key_Eacute               : Qt.Key = ... # 0xc9
    Key_Ecircumflex          : Qt.Key = ... # 0xca
    Key_Ediaeresis           : Qt.Key = ... # 0xcb
    Key_Igrave               : Qt.Key = ... # 0xcc
    Key_Iacute               : Qt.Key = ... # 0xcd
    Key_Icircumflex          : Qt.Key = ... # 0xce
    Key_Idiaeresis           : Qt.Key = ... # 0xcf
    Key_ETH                  : Qt.Key = ... # 0xd0
    Key_Ntilde               : Qt.Key = ... # 0xd1
    Key_Ograve               : Qt.Key = ... # 0xd2
    Key_Oacute               : Qt.Key = ... # 0xd3
    Key_Ocircumflex          : Qt.Key = ... # 0xd4
    Key_Otilde               : Qt.Key = ... # 0xd5
    Key_Odiaeresis           : Qt.Key = ... # 0xd6
    Key_multiply             : Qt.Key = ... # 0xd7
    Key_Ooblique             : Qt.Key = ... # 0xd8
    Key_Ugrave               : Qt.Key = ... # 0xd9
    Key_Uacute               : Qt.Key = ... # 0xda
    Key_Ucircumflex          : Qt.Key = ... # 0xdb
    Key_Udiaeresis           : Qt.Key = ... # 0xdc
    Key_Yacute               : Qt.Key = ... # 0xdd
    Key_THORN                : Qt.Key = ... # 0xde
    Key_ssharp               : Qt.Key = ... # 0xdf
    Key_division             : Qt.Key = ... # 0xf7
    Key_ydiaeresis           : Qt.Key = ... # 0xff
    Key_Escape               : Qt.Key = ... # 0x1000000
    Key_Tab                  : Qt.Key = ... # 0x1000001
    Key_Backtab              : Qt.Key = ... # 0x1000002
    Key_Backspace            : Qt.Key = ... # 0x1000003
    Key_Return               : Qt.Key = ... # 0x1000004
    Key_Enter                : Qt.Key = ... # 0x1000005
    Key_Insert               : Qt.Key = ... # 0x1000006
    Key_Delete               : Qt.Key = ... # 0x1000007
    Key_Pause                : Qt.Key = ... # 0x1000008
    Key_Print                : Qt.Key = ... # 0x1000009
    Key_SysReq               : Qt.Key = ... # 0x100000a
    Key_Clear                : Qt.Key = ... # 0x100000b
    Key_Home                 : Qt.Key = ... # 0x1000010
    Key_End                  : Qt.Key = ... # 0x1000011
    Key_Left                 : Qt.Key = ... # 0x1000012
    Key_Up                   : Qt.Key = ... # 0x1000013
    Key_Right                : Qt.Key = ... # 0x1000014
    Key_Down                 : Qt.Key = ... # 0x1000015
    Key_PageUp               : Qt.Key = ... # 0x1000016
    Key_PageDown             : Qt.Key = ... # 0x1000017
    Key_Shift                : Qt.Key = ... # 0x1000020
    Key_Control              : Qt.Key = ... # 0x1000021
    Key_Meta                 : Qt.Key = ... # 0x1000022
    Key_Alt                  : Qt.Key = ... # 0x1000023
    Key_CapsLock             : Qt.Key = ... # 0x1000024
    Key_NumLock              : Qt.Key = ... # 0x1000025
    Key_ScrollLock           : Qt.Key = ... # 0x1000026
    Key_F1                   : Qt.Key = ... # 0x1000030
    Key_F2                   : Qt.Key = ... # 0x1000031
    Key_F3                   : Qt.Key = ... # 0x1000032
    Key_F4                   : Qt.Key = ... # 0x1000033
    Key_F5                   : Qt.Key = ... # 0x1000034
    Key_F6                   : Qt.Key = ... # 0x1000035
    Key_F7                   : Qt.Key = ... # 0x1000036
    Key_F8                   : Qt.Key = ... # 0x1000037
    Key_F9                   : Qt.Key = ... # 0x1000038
    Key_F10                  : Qt.Key = ... # 0x1000039
    Key_F11                  : Qt.Key = ... # 0x100003a
    Key_F12                  : Qt.Key = ... # 0x100003b
    Key_F13                  : Qt.Key = ... # 0x100003c
    Key_F14                  : Qt.Key = ... # 0x100003d
    Key_F15                  : Qt.Key = ... # 0x100003e
    Key_F16                  : Qt.Key = ... # 0x100003f
    Key_F17                  : Qt.Key = ... # 0x1000040
    Key_F18                  : Qt.Key = ... # 0x1000041
    Key_F19                  : Qt.Key = ... # 0x1000042
    Key_F20                  : Qt.Key = ... # 0x1000043
    Key_F21                  : Qt.Key = ... # 0x1000044
    Key_F22                  : Qt.Key = ... # 0x1000045
    Key_F23                  : Qt.Key = ... # 0x1000046
    Key_F24                  : Qt.Key = ... # 0x1000047
    Key_F25                  : Qt.Key = ... # 0x1000048
    Key_F26                  : Qt.Key = ... # 0x1000049
    Key_F27                  : Qt.Key = ... # 0x100004a
    Key_F28                  : Qt.Key = ... # 0x100004b
    Key_F29                  : Qt.Key = ... # 0x100004c
    Key_F30                  : Qt.Key = ... # 0x100004d
    Key_F31                  : Qt.Key = ... # 0x100004e
    Key_F32                  : Qt.Key = ... # 0x100004f
    Key_F33                  : Qt.Key = ... # 0x1000050
    Key_F34                  : Qt.Key = ... # 0x1000051
    Key_F35                  : Qt.Key = ... # 0x1000052
    Key_Super_L              : Qt.Key = ... # 0x1000053
    Key_Super_R              : Qt.Key = ... # 0x1000054
    Key_Menu                 : Qt.Key = ... # 0x1000055
    Key_Hyper_L              : Qt.Key = ... # 0x1000056
    Key_Hyper_R              : Qt.Key = ... # 0x1000057
    Key_Help                 : Qt.Key = ... # 0x1000058
    Key_Direction_L          : Qt.Key = ... # 0x1000059
    Key_Direction_R          : Qt.Key = ... # 0x1000060
    Key_Back                 : Qt.Key = ... # 0x1000061
    Key_Forward              : Qt.Key = ... # 0x1000062
    Key_Stop                 : Qt.Key = ... # 0x1000063
    Key_Refresh              : Qt.Key = ... # 0x1000064
    Key_VolumeDown           : Qt.Key = ... # 0x1000070
    Key_VolumeMute           : Qt.Key = ... # 0x1000071
    Key_VolumeUp             : Qt.Key = ... # 0x1000072
    Key_BassBoost            : Qt.Key = ... # 0x1000073
    Key_BassUp               : Qt.Key = ... # 0x1000074
    Key_BassDown             : Qt.Key = ... # 0x1000075
    Key_TrebleUp             : Qt.Key = ... # 0x1000076
    Key_TrebleDown           : Qt.Key = ... # 0x1000077
    Key_MediaPlay            : Qt.Key = ... # 0x1000080
    Key_MediaStop            : Qt.Key = ... # 0x1000081
    Key_MediaPrevious        : Qt.Key = ... # 0x1000082
    Key_MediaNext            : Qt.Key = ... # 0x1000083
    Key_MediaRecord          : Qt.Key = ... # 0x1000084
    Key_MediaPause           : Qt.Key = ... # 0x1000085
    Key_MediaTogglePlayPause : Qt.Key = ... # 0x1000086
    Key_HomePage             : Qt.Key = ... # 0x1000090
    Key_Favorites            : Qt.Key = ... # 0x1000091
    Key_Search               : Qt.Key = ... # 0x1000092
    Key_Standby              : Qt.Key = ... # 0x1000093
    Key_OpenUrl              : Qt.Key = ... # 0x1000094
    Key_LaunchMail           : Qt.Key = ... # 0x10000a0
    Key_LaunchMedia          : Qt.Key = ... # 0x10000a1
    Key_Launch0              : Qt.Key = ... # 0x10000a2
    Key_Launch1              : Qt.Key = ... # 0x10000a3
    Key_Launch2              : Qt.Key = ... # 0x10000a4
    Key_Launch3              : Qt.Key = ... # 0x10000a5
    Key_Launch4              : Qt.Key = ... # 0x10000a6
    Key_Launch5              : Qt.Key = ... # 0x10000a7
    Key_Launch6              : Qt.Key = ... # 0x10000a8
    Key_Launch7              : Qt.Key = ... # 0x10000a9
    Key_Launch8              : Qt.Key = ... # 0x10000aa
    Key_Launch9              : Qt.Key = ... # 0x10000ab
    Key_LaunchA              : Qt.Key = ... # 0x10000ac
    Key_LaunchB              : Qt.Key = ... # 0x10000ad
    Key_LaunchC              : Qt.Key = ... # 0x10000ae
    Key_LaunchD              : Qt.Key = ... # 0x10000af
    Key_LaunchE              : Qt.Key = ... # 0x10000b0
    Key_LaunchF              : Qt.Key = ... # 0x10000b1
    Key_MonBrightnessUp      : Qt.Key = ... # 0x10000b2
    Key_MonBrightnessDown    : Qt.Key = ... # 0x10000b3
    Key_KeyboardLightOnOff   : Qt.Key = ... # 0x10000b4
    Key_KeyboardBrightnessUp : Qt.Key = ... # 0x10000b5
    Key_KeyboardBrightnessDown: Qt.Key = ... # 0x10000b6
    Key_PowerOff             : Qt.Key = ... # 0x10000b7
    Key_WakeUp               : Qt.Key = ... # 0x10000b8
    Key_Eject                : Qt.Key = ... # 0x10000b9
    Key_ScreenSaver          : Qt.Key = ... # 0x10000ba
    Key_WWW                  : Qt.Key = ... # 0x10000bb
    Key_Memo                 : Qt.Key = ... # 0x10000bc
    Key_LightBulb            : Qt.Key = ... # 0x10000bd
    Key_Shop                 : Qt.Key = ... # 0x10000be
    Key_History              : Qt.Key = ... # 0x10000bf
    Key_AddFavorite          : Qt.Key = ... # 0x10000c0
    Key_HotLinks             : Qt.Key = ... # 0x10000c1
    Key_BrightnessAdjust     : Qt.Key = ... # 0x10000c2
    Key_Finance              : Qt.Key = ... # 0x10000c3
    Key_Community            : Qt.Key = ... # 0x10000c4
    Key_AudioRewind          : Qt.Key = ... # 0x10000c5
    Key_BackForward          : Qt.Key = ... # 0x10000c6
    Key_ApplicationLeft      : Qt.Key = ... # 0x10000c7
    Key_ApplicationRight     : Qt.Key = ... # 0x10000c8
    Key_Book                 : Qt.Key = ... # 0x10000c9
    Key_CD                   : Qt.Key = ... # 0x10000ca
    Key_Calculator           : Qt.Key = ... # 0x10000cb
    Key_ToDoList             : Qt.Key = ... # 0x10000cc
    Key_ClearGrab            : Qt.Key = ... # 0x10000cd
    Key_Close                : Qt.Key = ... # 0x10000ce
    Key_Copy                 : Qt.Key = ... # 0x10000cf
    Key_Cut                  : Qt.Key = ... # 0x10000d0
    Key_Display              : Qt.Key = ... # 0x10000d1
    Key_DOS                  : Qt.Key = ... # 0x10000d2
    Key_Documents            : Qt.Key = ... # 0x10000d3
    Key_Excel                : Qt.Key = ... # 0x10000d4
    Key_Explorer             : Qt.Key = ... # 0x10000d5
    Key_Game                 : Qt.Key = ... # 0x10000d6
    Key_Go                   : Qt.Key = ... # 0x10000d7
    Key_iTouch               : Qt.Key = ... # 0x10000d8
    Key_LogOff               : Qt.Key = ... # 0x10000d9
    Key_Market               : Qt.Key = ... # 0x10000da
    Key_Meeting              : Qt.Key = ... # 0x10000db
    Key_MenuKB               : Qt.Key = ... # 0x10000dc
    Key_MenuPB               : Qt.Key = ... # 0x10000dd
    Key_MySites              : Qt.Key = ... # 0x10000de
    Key_News                 : Qt.Key = ... # 0x10000df
    Key_OfficeHome           : Qt.Key = ... # 0x10000e0
    Key_Option               : Qt.Key = ... # 0x10000e1
    Key_Paste                : Qt.Key = ... # 0x10000e2
    Key_Phone                : Qt.Key = ... # 0x10000e3
    Key_Calendar             : Qt.Key = ... # 0x10000e4
    Key_Reply                : Qt.Key = ... # 0x10000e5
    Key_Reload               : Qt.Key = ... # 0x10000e6
    Key_RotateWindows        : Qt.Key = ... # 0x10000e7
    Key_RotationPB           : Qt.Key = ... # 0x10000e8
    Key_RotationKB           : Qt.Key = ... # 0x10000e9
    Key_Save                 : Qt.Key = ... # 0x10000ea
    Key_Send                 : Qt.Key = ... # 0x10000eb
    Key_Spell                : Qt.Key = ... # 0x10000ec
    Key_SplitScreen          : Qt.Key = ... # 0x10000ed
    Key_Support              : Qt.Key = ... # 0x10000ee
    Key_TaskPane             : Qt.Key = ... # 0x10000ef
    Key_Terminal             : Qt.Key = ... # 0x10000f0
    Key_Tools                : Qt.Key = ... # 0x10000f1
    Key_Travel               : Qt.Key = ... # 0x10000f2
    Key_Video                : Qt.Key = ... # 0x10000f3
    Key_Word                 : Qt.Key = ... # 0x10000f4
    Key_Xfer                 : Qt.Key = ... # 0x10000f5
    Key_ZoomIn               : Qt.Key = ... # 0x10000f6
    Key_ZoomOut              : Qt.Key = ... # 0x10000f7
    Key_Away                 : Qt.Key = ... # 0x10000f8
    Key_Messenger            : Qt.Key = ... # 0x10000f9
    Key_WebCam               : Qt.Key = ... # 0x10000fa
    Key_MailForward          : Qt.Key = ... # 0x10000fb
    Key_Pictures             : Qt.Key = ... # 0x10000fc
    Key_Music                : Qt.Key = ... # 0x10000fd
    Key_Battery              : Qt.Key = ... # 0x10000fe
    Key_Bluetooth            : Qt.Key = ... # 0x10000ff
    Key_WLAN                 : Qt.Key = ... # 0x1000100
    Key_UWB                  : Qt.Key = ... # 0x1000101
    Key_AudioForward         : Qt.Key = ... # 0x1000102
    Key_AudioRepeat          : Qt.Key = ... # 0x1000103
    Key_AudioRandomPlay      : Qt.Key = ... # 0x1000104
    Key_Subtitle             : Qt.Key = ... # 0x1000105
    Key_AudioCycleTrack      : Qt.Key = ... # 0x1000106
    Key_Time                 : Qt.Key = ... # 0x1000107
    Key_Hibernate            : Qt.Key = ... # 0x1000108
    Key_View                 : Qt.Key = ... # 0x1000109
    Key_TopMenu              : Qt.Key = ... # 0x100010a
    Key_PowerDown            : Qt.Key = ... # 0x100010b
    Key_Suspend              : Qt.Key = ... # 0x100010c
    Key_ContrastAdjust       : Qt.Key = ... # 0x100010d
    Key_LaunchG              : Qt.Key = ... # 0x100010e
    Key_LaunchH              : Qt.Key = ... # 0x100010f
    Key_TouchpadToggle       : Qt.Key = ... # 0x1000110
    Key_TouchpadOn           : Qt.Key = ... # 0x1000111
    Key_TouchpadOff          : Qt.Key = ... # 0x1000112
    Key_MicMute              : Qt.Key = ... # 0x1000113
    Key_Red                  : Qt.Key = ... # 0x1000114
    Key_Green                : Qt.Key = ... # 0x1000115
    Key_Yellow               : Qt.Key = ... # 0x1000116
    Key_Blue                 : Qt.Key = ... # 0x1000117
    Key_ChannelUp            : Qt.Key = ... # 0x1000118
    Key_ChannelDown          : Qt.Key = ... # 0x1000119
    Key_Guide                : Qt.Key = ... # 0x100011a
    Key_Info                 : Qt.Key = ... # 0x100011b
    Key_Settings             : Qt.Key = ... # 0x100011c
    Key_MicVolumeUp          : Qt.Key = ... # 0x100011d
    Key_MicVolumeDown        : Qt.Key = ... # 0x100011e
    Key_New                  : Qt.Key = ... # 0x1000120
    Key_Open                 : Qt.Key = ... # 0x1000121
    Key_Find                 : Qt.Key = ... # 0x1000122
    Key_Undo                 : Qt.Key = ... # 0x1000123
    Key_Redo                 : Qt.Key = ... # 0x1000124
    Key_AltGr                : Qt.Key = ... # 0x1001103
    Key_Multi_key            : Qt.Key = ... # 0x1001120
    Key_Kanji                : Qt.Key = ... # 0x1001121
    Key_Muhenkan             : Qt.Key = ... # 0x1001122
    Key_Henkan               : Qt.Key = ... # 0x1001123
    Key_Romaji               : Qt.Key = ... # 0x1001124
    Key_Hiragana             : Qt.Key = ... # 0x1001125
    Key_Katakana             : Qt.Key = ... # 0x1001126
    Key_Hiragana_Katakana    : Qt.Key = ... # 0x1001127
    Key_Zenkaku              : Qt.Key = ... # 0x1001128
    Key_Hankaku              : Qt.Key = ... # 0x1001129
    Key_Zenkaku_Hankaku      : Qt.Key = ... # 0x100112a
    Key_Touroku              : Qt.Key = ... # 0x100112b
    Key_Massyo               : Qt.Key = ... # 0x100112c
    Key_Kana_Lock            : Qt.Key = ... # 0x100112d
    Key_Kana_Shift           : Qt.Key = ... # 0x100112e
    Key_Eisu_Shift           : Qt.Key = ... # 0x100112f
    Key_Eisu_toggle          : Qt.Key = ... # 0x1001130
    Key_Hangul               : Qt.Key = ... # 0x1001131
    Key_Hangul_Start         : Qt.Key = ... # 0x1001132
    Key_Hangul_End           : Qt.Key = ... # 0x1001133
    Key_Hangul_Hanja         : Qt.Key = ... # 0x1001134
    Key_Hangul_Jamo          : Qt.Key = ... # 0x1001135
    Key_Hangul_Romaja        : Qt.Key = ... # 0x1001136
    Key_Codeinput            : Qt.Key = ... # 0x1001137
    Key_Hangul_Jeonja        : Qt.Key = ... # 0x1001138
    Key_Hangul_Banja         : Qt.Key = ... # 0x1001139
    Key_Hangul_PreHanja      : Qt.Key = ... # 0x100113a
    Key_Hangul_PostHanja     : Qt.Key = ... # 0x100113b
    Key_SingleCandidate      : Qt.Key = ... # 0x100113c
    Key_MultipleCandidate    : Qt.Key = ... # 0x100113d
    Key_PreviousCandidate    : Qt.Key = ... # 0x100113e
    Key_Hangul_Special       : Qt.Key = ... # 0x100113f
    Key_Mode_switch          : Qt.Key = ... # 0x100117e
    Key_Dead_Grave           : Qt.Key = ... # 0x1001250
    Key_Dead_Acute           : Qt.Key = ... # 0x1001251
    Key_Dead_Circumflex      : Qt.Key = ... # 0x1001252
    Key_Dead_Tilde           : Qt.Key = ... # 0x1001253
    Key_Dead_Macron          : Qt.Key = ... # 0x1001254
    Key_Dead_Breve           : Qt.Key = ... # 0x1001255
    Key_Dead_Abovedot        : Qt.Key = ... # 0x1001256
    Key_Dead_Diaeresis       : Qt.Key = ... # 0x1001257
    Key_Dead_Abovering       : Qt.Key = ... # 0x1001258
    Key_Dead_Doubleacute     : Qt.Key = ... # 0x1001259
    Key_Dead_Caron           : Qt.Key = ... # 0x100125a
    Key_Dead_Cedilla         : Qt.Key = ... # 0x100125b
    Key_Dead_Ogonek          : Qt.Key = ... # 0x100125c
    Key_Dead_Iota            : Qt.Key = ... # 0x100125d
    Key_Dead_Voiced_Sound    : Qt.Key = ... # 0x100125e
    Key_Dead_Semivoiced_Sound: Qt.Key = ... # 0x100125f
    Key_Dead_Belowdot        : Qt.Key = ... # 0x1001260
    Key_Dead_Hook            : Qt.Key = ... # 0x1001261
    Key_Dead_Horn            : Qt.Key = ... # 0x1001262
    Key_Dead_Stroke          : Qt.Key = ... # 0x1001263
    Key_Dead_Abovecomma      : Qt.Key = ... # 0x1001264
    Key_Dead_Abovereversedcomma: Qt.Key = ... # 0x1001265
    Key_Dead_Doublegrave     : Qt.Key = ... # 0x1001266
    Key_Dead_Belowring       : Qt.Key = ... # 0x1001267
    Key_Dead_Belowmacron     : Qt.Key = ... # 0x1001268
    Key_Dead_Belowcircumflex : Qt.Key = ... # 0x1001269
    Key_Dead_Belowtilde      : Qt.Key = ... # 0x100126a
    Key_Dead_Belowbreve      : Qt.Key = ... # 0x100126b
    Key_Dead_Belowdiaeresis  : Qt.Key = ... # 0x100126c
    Key_Dead_Invertedbreve   : Qt.Key = ... # 0x100126d
    Key_Dead_Belowcomma      : Qt.Key = ... # 0x100126e
    Key_Dead_Currency        : Qt.Key = ... # 0x100126f
    Key_Dead_a               : Qt.Key = ... # 0x1001280
    Key_Dead_A               : Qt.Key = ... # 0x1001281
    Key_Dead_e               : Qt.Key = ... # 0x1001282
    Key_Dead_E               : Qt.Key = ... # 0x1001283
    Key_Dead_i               : Qt.Key = ... # 0x1001284
    Key_Dead_I               : Qt.Key = ... # 0x1001285
    Key_Dead_o               : Qt.Key = ... # 0x1001286
    Key_Dead_O               : Qt.Key = ... # 0x1001287
    Key_Dead_u               : Qt.Key = ... # 0x1001288
    Key_Dead_U               : Qt.Key = ... # 0x1001289
    Key_Dead_Small_Schwa     : Qt.Key = ... # 0x100128a
    Key_Dead_Capital_Schwa   : Qt.Key = ... # 0x100128b
    Key_Dead_Greek           : Qt.Key = ... # 0x100128c
    Key_Dead_Lowline         : Qt.Key = ... # 0x1001290
    Key_Dead_Aboveverticalline: Qt.Key = ... # 0x1001291
    Key_Dead_Belowverticalline: Qt.Key = ... # 0x1001292
    Key_Dead_Longsolidusoverlay: Qt.Key = ... # 0x1001293
    Key_MediaLast            : Qt.Key = ... # 0x100ffff
    Key_Select               : Qt.Key = ... # 0x1010000
    Key_Yes                  : Qt.Key = ... # 0x1010001
    Key_No                   : Qt.Key = ... # 0x1010002
    Key_Cancel               : Qt.Key = ... # 0x1020001
    Key_Printer              : Qt.Key = ... # 0x1020002
    Key_Execute              : Qt.Key = ... # 0x1020003
    Key_Sleep                : Qt.Key = ... # 0x1020004
    Key_Play                 : Qt.Key = ... # 0x1020005
    Key_Zoom                 : Qt.Key = ... # 0x1020006
    Key_Exit                 : Qt.Key = ... # 0x102000a
    Key_Context1             : Qt.Key = ... # 0x1100000
    Key_Context2             : Qt.Key = ... # 0x1100001
    Key_Context3             : Qt.Key = ... # 0x1100002
    Key_Context4             : Qt.Key = ... # 0x1100003
    Key_Call                 : Qt.Key = ... # 0x1100004
    Key_Hangup               : Qt.Key = ... # 0x1100005
    Key_Flip                 : Qt.Key = ... # 0x1100006
    Key_ToggleCallHangup     : Qt.Key = ... # 0x1100007
    Key_VoiceDial            : Qt.Key = ... # 0x1100008
    Key_LastNumberRedial     : Qt.Key = ... # 0x1100009
    Key_Camera               : Qt.Key = ... # 0x1100020
    Key_CameraFocus          : Qt.Key = ... # 0x1100021
    Key_unknown              : Qt.Key = ... # 0x1ffffff
    NoModifier               : Qt.KeyboardModifier = ... # 0x0
    ShiftModifier            : Qt.KeyboardModifier = ... # 0x2000000
    ControlModifier          : Qt.KeyboardModifier = ... # 0x4000000
    AltModifier              : Qt.KeyboardModifier = ... # 0x8000000
    MetaModifier             : Qt.KeyboardModifier = ... # 0x10000000
    KeypadModifier           : Qt.KeyboardModifier = ... # 0x20000000
    GroupSwitchModifier      : Qt.KeyboardModifier = ... # 0x40000000
    KeyboardModifierMask     : Qt.KeyboardModifier = ... # -0x2000000
    LeftToRight              : Qt.LayoutDirection = ... # 0x0
    RightToLeft              : Qt.LayoutDirection = ... # 0x1
    LayoutDirectionAuto      : Qt.LayoutDirection = ... # 0x2
    MaskInColor              : Qt.MaskMode = ... # 0x0
    MaskOutColor             : Qt.MaskMode = ... # 0x1
    MatchExactly             : Qt.MatchFlag = ... # 0x0
    MatchContains            : Qt.MatchFlag = ... # 0x1
    MatchStartsWith          : Qt.MatchFlag = ... # 0x2
    MatchEndsWith            : Qt.MatchFlag = ... # 0x3
    MatchRegExp              : Qt.MatchFlag = ... # 0x4
    MatchWildcard            : Qt.MatchFlag = ... # 0x5
    MatchFixedString         : Qt.MatchFlag = ... # 0x8
    MatchRegularExpression   : Qt.MatchFlag = ... # 0x9
    MatchCaseSensitive       : Qt.MatchFlag = ... # 0x10
    MatchWrap                : Qt.MatchFlag = ... # 0x20
    MatchRecursive           : Qt.MatchFlag = ... # 0x40
    UNICODE_ACCEL            : Qt.Modifier = ... # 0x0
    SHIFT                    : Qt.Modifier = ... # 0x2000000
    CTRL                     : Qt.Modifier = ... # 0x4000000
    ALT                      : Qt.Modifier = ... # 0x8000000
    META                     : Qt.Modifier = ... # 0x10000000
    MODIFIER_MASK            : Qt.Modifier = ... # 0xfe000000
    NoButton                 : Qt.MouseButton = ... # 0x0
    LeftButton               : Qt.MouseButton = ... # 0x1
    RightButton              : Qt.MouseButton = ... # 0x2
    MidButton                : Qt.MouseButton = ... # 0x4
    MiddleButton             : Qt.MouseButton = ... # 0x4
    BackButton               : Qt.MouseButton = ... # 0x8
    ExtraButton1             : Qt.MouseButton = ... # 0x8
    XButton1                 : Qt.MouseButton = ... # 0x8
    ExtraButton2             : Qt.MouseButton = ... # 0x10
    ForwardButton            : Qt.MouseButton = ... # 0x10
    XButton2                 : Qt.MouseButton = ... # 0x10
    ExtraButton3             : Qt.MouseButton = ... # 0x20
    TaskButton               : Qt.MouseButton = ... # 0x20
    ExtraButton4             : Qt.MouseButton = ... # 0x40
    ExtraButton5             : Qt.MouseButton = ... # 0x80
    ExtraButton6             : Qt.MouseButton = ... # 0x100
    ExtraButton7             : Qt.MouseButton = ... # 0x200
    ExtraButton8             : Qt.MouseButton = ... # 0x400
    ExtraButton9             : Qt.MouseButton = ... # 0x800
    ExtraButton10            : Qt.MouseButton = ... # 0x1000
    ExtraButton11            : Qt.MouseButton = ... # 0x2000
    ExtraButton12            : Qt.MouseButton = ... # 0x4000
    ExtraButton13            : Qt.MouseButton = ... # 0x8000
    ExtraButton14            : Qt.MouseButton = ... # 0x10000
    ExtraButton15            : Qt.MouseButton = ... # 0x20000
    ExtraButton16            : Qt.MouseButton = ... # 0x40000
    ExtraButton17            : Qt.MouseButton = ... # 0x80000
    ExtraButton18            : Qt.MouseButton = ... # 0x100000
    ExtraButton19            : Qt.MouseButton = ... # 0x200000
    ExtraButton20            : Qt.MouseButton = ... # 0x400000
    ExtraButton21            : Qt.MouseButton = ... # 0x800000
    ExtraButton22            : Qt.MouseButton = ... # 0x1000000
    ExtraButton23            : Qt.MouseButton = ... # 0x2000000
    ExtraButton24            : Qt.MouseButton = ... # 0x4000000
    MaxMouseButton           : Qt.MouseButton = ... # 0x4000000
    AllButtons               : Qt.MouseButton = ... # 0x7ffffff
    MouseButtonMask          : Qt.MouseButton = ... # -0x1
    MouseEventCreatedDoubleClick: Qt.MouseEventFlag = ... # 0x1
    MouseEventFlagMask       : Qt.MouseEventFlag = ... # 0xff
    MouseEventNotSynthesized : Qt.MouseEventSource = ... # 0x0
    MouseEventSynthesizedBySystem: Qt.MouseEventSource = ... # 0x1
    MouseEventSynthesizedByQt: Qt.MouseEventSource = ... # 0x2
    MouseEventSynthesizedByApplication: Qt.MouseEventSource = ... # 0x3
    BeginNativeGesture       : Qt.NativeGestureType = ... # 0x0
    EndNativeGesture         : Qt.NativeGestureType = ... # 0x1
    PanNativeGesture         : Qt.NativeGestureType = ... # 0x2
    ZoomNativeGesture        : Qt.NativeGestureType = ... # 0x3
    SmartZoomNativeGesture   : Qt.NativeGestureType = ... # 0x4
    RotateNativeGesture      : Qt.NativeGestureType = ... # 0x5
    SwipeNativeGesture       : Qt.NativeGestureType = ... # 0x6
    NavigationModeNone       : Qt.NavigationMode = ... # 0x0
    NavigationModeKeypadTabOrder: Qt.NavigationMode = ... # 0x1
    NavigationModeKeypadDirectional: Qt.NavigationMode = ... # 0x2
    NavigationModeCursorAuto : Qt.NavigationMode = ... # 0x3
    NavigationModeCursorForceVisible: Qt.NavigationMode = ... # 0x4
    Horizontal               : Qt.Orientation = ... # 0x1
    Vertical                 : Qt.Orientation = ... # 0x2
    FlatCap                  : Qt.PenCapStyle = ... # 0x0
    SquareCap                : Qt.PenCapStyle = ... # 0x10
    RoundCap                 : Qt.PenCapStyle = ... # 0x20
    MPenCapStyle             : Qt.PenCapStyle = ... # 0x30
    MiterJoin                : Qt.PenJoinStyle = ... # 0x0
    BevelJoin                : Qt.PenJoinStyle = ... # 0x40
    RoundJoin                : Qt.PenJoinStyle = ... # 0x80
    SvgMiterJoin             : Qt.PenJoinStyle = ... # 0x100
    MPenJoinStyle            : Qt.PenJoinStyle = ... # 0x1c0
    NoPen                    : Qt.PenStyle = ... # 0x0
    SolidLine                : Qt.PenStyle = ... # 0x1
    DashLine                 : Qt.PenStyle = ... # 0x2
    DotLine                  : Qt.PenStyle = ... # 0x3
    DashDotLine              : Qt.PenStyle = ... # 0x4
    DashDotDotLine           : Qt.PenStyle = ... # 0x5
    CustomDashLine           : Qt.PenStyle = ... # 0x6
    MPenStyle                : Qt.PenStyle = ... # 0xf
    PrimaryOrientation       : Qt.ScreenOrientation = ... # 0x0
    PortraitOrientation      : Qt.ScreenOrientation = ... # 0x1
    LandscapeOrientation     : Qt.ScreenOrientation = ... # 0x2
    InvertedPortraitOrientation: Qt.ScreenOrientation = ... # 0x4
    InvertedLandscapeOrientation: Qt.ScreenOrientation = ... # 0x8
    ScrollBarAsNeeded        : Qt.ScrollBarPolicy = ... # 0x0
    ScrollBarAlwaysOff       : Qt.ScrollBarPolicy = ... # 0x1
    ScrollBarAlwaysOn        : Qt.ScrollBarPolicy = ... # 0x2
    NoScrollPhase            : Qt.ScrollPhase = ... # 0x0
    ScrollBegin              : Qt.ScrollPhase = ... # 0x1
    ScrollUpdate             : Qt.ScrollPhase = ... # 0x2
    ScrollEnd                : Qt.ScrollPhase = ... # 0x3
    ScrollMomentum           : Qt.ScrollPhase = ... # 0x4
    WidgetShortcut           : Qt.ShortcutContext = ... # 0x0
    WindowShortcut           : Qt.ShortcutContext = ... # 0x1
    ApplicationShortcut      : Qt.ShortcutContext = ... # 0x2
    WidgetWithChildrenShortcut: Qt.ShortcutContext = ... # 0x3
    MinimumSize              : Qt.SizeHint = ... # 0x0
    PreferredSize            : Qt.SizeHint = ... # 0x1
    MaximumSize              : Qt.SizeHint = ... # 0x2
    MinimumDescent           : Qt.SizeHint = ... # 0x3
    NSizeHints               : Qt.SizeHint = ... # 0x4
    AbsoluteSize             : Qt.SizeMode = ... # 0x0
    RelativeSize             : Qt.SizeMode = ... # 0x1
    AscendingOrder           : Qt.SortOrder = ... # 0x0
    DescendingOrder          : Qt.SortOrder = ... # 0x1
    KeepEmptyParts           : Qt.SplitBehaviorFlags = ... # 0x0
    SkipEmptyParts           : Qt.SplitBehaviorFlags = ... # 0x1
    NoTabFocus               : Qt.TabFocusBehavior = ... # 0x0
    TabFocusTextControls     : Qt.TabFocusBehavior = ... # 0x1
    TabFocusListControls     : Qt.TabFocusBehavior = ... # 0x2
    TabFocusAllControls      : Qt.TabFocusBehavior = ... # 0xff
    ElideLeft                : Qt.TextElideMode = ... # 0x0
    ElideRight               : Qt.TextElideMode = ... # 0x1
    ElideMiddle              : Qt.TextElideMode = ... # 0x2
    ElideNone                : Qt.TextElideMode = ... # 0x3
    TextSingleLine           : Qt.TextFlag = ... # 0x100
    TextDontClip             : Qt.TextFlag = ... # 0x200
    TextExpandTabs           : Qt.TextFlag = ... # 0x400
    TextShowMnemonic         : Qt.TextFlag = ... # 0x800
    TextWordWrap             : Qt.TextFlag = ... # 0x1000
    TextWrapAnywhere         : Qt.TextFlag = ... # 0x2000
    TextDontPrint            : Qt.TextFlag = ... # 0x4000
    TextHideMnemonic         : Qt.TextFlag = ... # 0x8000
    TextJustificationForced  : Qt.TextFlag = ... # 0x10000
    TextForceLeftToRight     : Qt.TextFlag = ... # 0x20000
    TextForceRightToLeft     : Qt.TextFlag = ... # 0x40000
    TextLongestVariant       : Qt.TextFlag = ... # 0x80000
    TextBypassShaping        : Qt.TextFlag = ... # 0x100000
    TextIncludeTrailingSpaces: Qt.TextFlag = ... # 0x8000000
    PlainText                : Qt.TextFormat = ... # 0x0
    RichText                 : Qt.TextFormat = ... # 0x1
    AutoText                 : Qt.TextFormat = ... # 0x2
    MarkdownText             : Qt.TextFormat = ... # 0x3
    NoTextInteraction        : Qt.TextInteractionFlag = ... # 0x0
    TextSelectableByMouse    : Qt.TextInteractionFlag = ... # 0x1
    TextSelectableByKeyboard : Qt.TextInteractionFlag = ... # 0x2
    LinksAccessibleByMouse   : Qt.TextInteractionFlag = ... # 0x4
    LinksAccessibleByKeyboard: Qt.TextInteractionFlag = ... # 0x8
    TextBrowserInteraction   : Qt.TextInteractionFlag = ... # 0xd
    TextEditable             : Qt.TextInteractionFlag = ... # 0x10
    TextEditorInteraction    : Qt.TextInteractionFlag = ... # 0x13
    StretchTile              : Qt.TileRule = ... # 0x0
    RepeatTile               : Qt.TileRule = ... # 0x1
    RoundTile                : Qt.TileRule = ... # 0x2
    LocalTime                : Qt.TimeSpec = ... # 0x0
    UTC                      : Qt.TimeSpec = ... # 0x1
    OffsetFromUTC            : Qt.TimeSpec = ... # 0x2
    TimeZone                 : Qt.TimeSpec = ... # 0x3
    PreciseTimer             : Qt.TimerType = ... # 0x0
    CoarseTimer              : Qt.TimerType = ... # 0x1
    VeryCoarseTimer          : Qt.TimerType = ... # 0x2
    NoToolBarArea            : Qt.ToolBarArea = ... # 0x0
    LeftToolBarArea          : Qt.ToolBarArea = ... # 0x1
    RightToolBarArea         : Qt.ToolBarArea = ... # 0x2
    TopToolBarArea           : Qt.ToolBarArea = ... # 0x4
    BottomToolBarArea        : Qt.ToolBarArea = ... # 0x8
    AllToolBarAreas          : Qt.ToolBarArea = ... # 0xf
    ToolBarArea_Mask         : Qt.ToolBarArea = ... # 0xf
    NToolBarAreas            : Qt.ToolBarAreaSizes = ... # 0x4
    ToolButtonIconOnly       : Qt.ToolButtonStyle = ... # 0x0
    ToolButtonTextOnly       : Qt.ToolButtonStyle = ... # 0x1
    ToolButtonTextBesideIcon : Qt.ToolButtonStyle = ... # 0x2
    ToolButtonTextUnderIcon  : Qt.ToolButtonStyle = ... # 0x3
    ToolButtonFollowStyle    : Qt.ToolButtonStyle = ... # 0x4
    TouchPointPressed        : Qt.TouchPointState = ... # 0x1
    TouchPointMoved          : Qt.TouchPointState = ... # 0x2
    TouchPointStationary     : Qt.TouchPointState = ... # 0x4
    TouchPointReleased       : Qt.TouchPointState = ... # 0x8
    FastTransformation       : Qt.TransformationMode = ... # 0x0
    SmoothTransformation     : Qt.TransformationMode = ... # 0x1
    UI_General               : Qt.UIEffect = ... # 0x0
    UI_AnimateMenu           : Qt.UIEffect = ... # 0x1
    UI_FadeMenu              : Qt.UIEffect = ... # 0x2
    UI_AnimateCombo          : Qt.UIEffect = ... # 0x3
    UI_AnimateTooltip        : Qt.UIEffect = ... # 0x4
    UI_FadeTooltip           : Qt.UIEffect = ... # 0x5
    UI_AnimateToolBox        : Qt.UIEffect = ... # 0x6
    WhiteSpaceModeUndefined  : Qt.WhiteSpaceMode = ... # -0x1
    WhiteSpaceNormal         : Qt.WhiteSpaceMode = ... # 0x0
    WhiteSpacePre            : Qt.WhiteSpaceMode = ... # 0x1
    WhiteSpaceNoWrap         : Qt.WhiteSpaceMode = ... # 0x2
    WA_Disabled              : Qt.WidgetAttribute = ... # 0x0
    WA_UnderMouse            : Qt.WidgetAttribute = ... # 0x1
    WA_MouseTracking         : Qt.WidgetAttribute = ... # 0x2
    WA_ContentsPropagated    : Qt.WidgetAttribute = ... # 0x3
    WA_NoBackground          : Qt.WidgetAttribute = ... # 0x4
    WA_OpaquePaintEvent      : Qt.WidgetAttribute = ... # 0x4
    WA_StaticContents        : Qt.WidgetAttribute = ... # 0x5
    WA_LaidOut               : Qt.WidgetAttribute = ... # 0x7
    WA_PaintOnScreen         : Qt.WidgetAttribute = ... # 0x8
    WA_NoSystemBackground    : Qt.WidgetAttribute = ... # 0x9
    WA_UpdatesDisabled       : Qt.WidgetAttribute = ... # 0xa
    WA_Mapped                : Qt.WidgetAttribute = ... # 0xb
    WA_MacNoClickThrough     : Qt.WidgetAttribute = ... # 0xc
    WA_InputMethodEnabled    : Qt.WidgetAttribute = ... # 0xe
    WA_WState_Visible        : Qt.WidgetAttribute = ... # 0xf
    WA_WState_Hidden         : Qt.WidgetAttribute = ... # 0x10
    WA_ForceDisabled         : Qt.WidgetAttribute = ... # 0x20
    WA_KeyCompression        : Qt.WidgetAttribute = ... # 0x21
    WA_PendingMoveEvent      : Qt.WidgetAttribute = ... # 0x22
    WA_PendingResizeEvent    : Qt.WidgetAttribute = ... # 0x23
    WA_SetPalette            : Qt.WidgetAttribute = ... # 0x24
    WA_SetFont               : Qt.WidgetAttribute = ... # 0x25
    WA_SetCursor             : Qt.WidgetAttribute = ... # 0x26
    WA_NoChildEventsFromChildren: Qt.WidgetAttribute = ... # 0x27
    WA_WindowModified        : Qt.WidgetAttribute = ... # 0x29
    WA_Resized               : Qt.WidgetAttribute = ... # 0x2a
    WA_Moved                 : Qt.WidgetAttribute = ... # 0x2b
    WA_PendingUpdate         : Qt.WidgetAttribute = ... # 0x2c
    WA_InvalidSize           : Qt.WidgetAttribute = ... # 0x2d
    WA_MacBrushedMetal       : Qt.WidgetAttribute = ... # 0x2e
    WA_MacMetalStyle         : Qt.WidgetAttribute = ... # 0x2e
    WA_CustomWhatsThis       : Qt.WidgetAttribute = ... # 0x2f
    WA_LayoutOnEntireRect    : Qt.WidgetAttribute = ... # 0x30
    WA_OutsideWSRange        : Qt.WidgetAttribute = ... # 0x31
    WA_GrabbedShortcut       : Qt.WidgetAttribute = ... # 0x32
    WA_TransparentForMouseEvents: Qt.WidgetAttribute = ... # 0x33
    WA_PaintUnclipped        : Qt.WidgetAttribute = ... # 0x34
    WA_SetWindowIcon         : Qt.WidgetAttribute = ... # 0x35
    WA_NoMouseReplay         : Qt.WidgetAttribute = ... # 0x36
    WA_DeleteOnClose         : Qt.WidgetAttribute = ... # 0x37
    WA_RightToLeft           : Qt.WidgetAttribute = ... # 0x38
    WA_SetLayoutDirection    : Qt.WidgetAttribute = ... # 0x39
    WA_NoChildEventsForParent: Qt.WidgetAttribute = ... # 0x3a
    WA_ForceUpdatesDisabled  : Qt.WidgetAttribute = ... # 0x3b
    WA_WState_Created        : Qt.WidgetAttribute = ... # 0x3c
    WA_WState_CompressKeys   : Qt.WidgetAttribute = ... # 0x3d
    WA_WState_InPaintEvent   : Qt.WidgetAttribute = ... # 0x3e
    WA_WState_Reparented     : Qt.WidgetAttribute = ... # 0x3f
    WA_WState_ConfigPending  : Qt.WidgetAttribute = ... # 0x40
    WA_WState_Polished       : Qt.WidgetAttribute = ... # 0x42
    WA_WState_DND            : Qt.WidgetAttribute = ... # 0x43
    WA_WState_OwnSizePolicy  : Qt.WidgetAttribute = ... # 0x44
    WA_WState_ExplicitShowHide: Qt.WidgetAttribute = ... # 0x45
    WA_ShowModal             : Qt.WidgetAttribute = ... # 0x46
    WA_MouseNoMask           : Qt.WidgetAttribute = ... # 0x47
    WA_GroupLeader           : Qt.WidgetAttribute = ... # 0x48
    WA_NoMousePropagation    : Qt.WidgetAttribute = ... # 0x49
    WA_Hover                 : Qt.WidgetAttribute = ... # 0x4a
    WA_InputMethodTransparent: Qt.WidgetAttribute = ... # 0x4b
    WA_QuitOnClose           : Qt.WidgetAttribute = ... # 0x4c
    WA_KeyboardFocusChange   : Qt.WidgetAttribute = ... # 0x4d
    WA_AcceptDrops           : Qt.WidgetAttribute = ... # 0x4e
    WA_DropSiteRegistered    : Qt.WidgetAttribute = ... # 0x4f
    WA_ForceAcceptDrops      : Qt.WidgetAttribute = ... # 0x4f
    WA_WindowPropagation     : Qt.WidgetAttribute = ... # 0x50
    WA_NoX11EventCompression : Qt.WidgetAttribute = ... # 0x51
    WA_TintedBackground      : Qt.WidgetAttribute = ... # 0x52
    WA_X11OpenGLOverlay      : Qt.WidgetAttribute = ... # 0x53
    WA_AlwaysShowToolTips    : Qt.WidgetAttribute = ... # 0x54
    WA_MacOpaqueSizeGrip     : Qt.WidgetAttribute = ... # 0x55
    WA_SetStyle              : Qt.WidgetAttribute = ... # 0x56
    WA_SetLocale             : Qt.WidgetAttribute = ... # 0x57
    WA_MacShowFocusRect      : Qt.WidgetAttribute = ... # 0x58
    WA_MacNormalSize         : Qt.WidgetAttribute = ... # 0x59
    WA_MacSmallSize          : Qt.WidgetAttribute = ... # 0x5a
    WA_MacMiniSize           : Qt.WidgetAttribute = ... # 0x5b
    WA_LayoutUsesWidgetRect  : Qt.WidgetAttribute = ... # 0x5c
    WA_StyledBackground      : Qt.WidgetAttribute = ... # 0x5d
    WA_MSWindowsUseDirect3D  : Qt.WidgetAttribute = ... # 0x5e
    WA_CanHostQMdiSubWindowTitleBar: Qt.WidgetAttribute = ... # 0x5f
    WA_MacAlwaysShowToolWindow: Qt.WidgetAttribute = ... # 0x60
    WA_StyleSheet            : Qt.WidgetAttribute = ... # 0x61
    WA_ShowWithoutActivating : Qt.WidgetAttribute = ... # 0x62
    WA_X11BypassTransientForHint: Qt.WidgetAttribute = ... # 0x63
    WA_NativeWindow          : Qt.WidgetAttribute = ... # 0x64
    WA_DontCreateNativeAncestors: Qt.WidgetAttribute = ... # 0x65
    WA_MacVariableSize       : Qt.WidgetAttribute = ... # 0x66
    WA_DontShowOnScreen      : Qt.WidgetAttribute = ... # 0x67
    WA_X11NetWmWindowTypeDesktop: Qt.WidgetAttribute = ... # 0x68
    WA_X11NetWmWindowTypeDock: Qt.WidgetAttribute = ... # 0x69
    WA_X11NetWmWindowTypeToolBar: Qt.WidgetAttribute = ... # 0x6a
    WA_X11NetWmWindowTypeMenu: Qt.WidgetAttribute = ... # 0x6b
    WA_X11NetWmWindowTypeUtility: Qt.WidgetAttribute = ... # 0x6c
    WA_X11NetWmWindowTypeSplash: Qt.WidgetAttribute = ... # 0x6d
    WA_X11NetWmWindowTypeDialog: Qt.WidgetAttribute = ... # 0x6e
    WA_X11NetWmWindowTypeDropDownMenu: Qt.WidgetAttribute = ... # 0x6f
    WA_X11NetWmWindowTypePopupMenu: Qt.WidgetAttribute = ... # 0x70
    WA_X11NetWmWindowTypeToolTip: Qt.WidgetAttribute = ... # 0x71
    WA_X11NetWmWindowTypeNotification: Qt.WidgetAttribute = ... # 0x72
    WA_X11NetWmWindowTypeCombo: Qt.WidgetAttribute = ... # 0x73
    WA_X11NetWmWindowTypeDND : Qt.WidgetAttribute = ... # 0x74
    WA_MacFrameworkScaled    : Qt.WidgetAttribute = ... # 0x75
    WA_SetWindowModality     : Qt.WidgetAttribute = ... # 0x76
    WA_WState_WindowOpacitySet: Qt.WidgetAttribute = ... # 0x77
    WA_TranslucentBackground : Qt.WidgetAttribute = ... # 0x78
    WA_AcceptTouchEvents     : Qt.WidgetAttribute = ... # 0x79
    WA_WState_AcceptedTouchBeginEvent: Qt.WidgetAttribute = ... # 0x7a
    WA_TouchPadAcceptSingleTouchEvents: Qt.WidgetAttribute = ... # 0x7b
    WA_X11DoNotAcceptFocus   : Qt.WidgetAttribute = ... # 0x7e
    WA_MacNoShadow           : Qt.WidgetAttribute = ... # 0x7f
    WA_AlwaysStackOnTop      : Qt.WidgetAttribute = ... # 0x80
    WA_TabletTracking        : Qt.WidgetAttribute = ... # 0x81
    WA_ContentsMarginsRespectsSafeArea: Qt.WidgetAttribute = ... # 0x82
    WA_StyleSheetTarget      : Qt.WidgetAttribute = ... # 0x83
    WA_AttributeCount        : Qt.WidgetAttribute = ... # 0x84
    NoSection                : Qt.WindowFrameSection = ... # 0x0
    LeftSection              : Qt.WindowFrameSection = ... # 0x1
    TopLeftSection           : Qt.WindowFrameSection = ... # 0x2
    TopSection               : Qt.WindowFrameSection = ... # 0x3
    TopRightSection          : Qt.WindowFrameSection = ... # 0x4
    RightSection             : Qt.WindowFrameSection = ... # 0x5
    BottomRightSection       : Qt.WindowFrameSection = ... # 0x6
    BottomSection            : Qt.WindowFrameSection = ... # 0x7
    BottomLeftSection        : Qt.WindowFrameSection = ... # 0x8
    TitleBarArea             : Qt.WindowFrameSection = ... # 0x9
    NonModal                 : Qt.WindowModality = ... # 0x0
    WindowModal              : Qt.WindowModality = ... # 0x1
    ApplicationModal         : Qt.WindowModality = ... # 0x2
    WindowNoState            : Qt.WindowState = ... # 0x0
    WindowMinimized          : Qt.WindowState = ... # 0x1
    WindowMaximized          : Qt.WindowState = ... # 0x2
    WindowFullScreen         : Qt.WindowState = ... # 0x4
    WindowActive             : Qt.WindowState = ... # 0x8
    Widget                   : Qt.WindowType = ... # 0x0
    Window                   : Qt.WindowType = ... # 0x1
    Dialog                   : Qt.WindowType = ... # 0x3
    Sheet                    : Qt.WindowType = ... # 0x5
    Drawer                   : Qt.WindowType = ... # 0x7
    Popup                    : Qt.WindowType = ... # 0x9
    Tool                     : Qt.WindowType = ... # 0xb
    ToolTip                  : Qt.WindowType = ... # 0xd
    SplashScreen             : Qt.WindowType = ... # 0xf
    Desktop                  : Qt.WindowType = ... # 0x11
    SubWindow                : Qt.WindowType = ... # 0x12
    ForeignWindow            : Qt.WindowType = ... # 0x21
    CoverWindow              : Qt.WindowType = ... # 0x41
    WindowType_Mask          : Qt.WindowType = ... # 0xff
    MSWindowsFixedSizeDialogHint: Qt.WindowType = ... # 0x100
    MSWindowsOwnDC           : Qt.WindowType = ... # 0x200
    BypassWindowManagerHint  : Qt.WindowType = ... # 0x400
    X11BypassWindowManagerHint: Qt.WindowType = ... # 0x400
    FramelessWindowHint      : Qt.WindowType = ... # 0x800
    WindowTitleHint          : Qt.WindowType = ... # 0x1000
    WindowSystemMenuHint     : Qt.WindowType = ... # 0x2000
    WindowMinimizeButtonHint : Qt.WindowType = ... # 0x4000
    WindowMaximizeButtonHint : Qt.WindowType = ... # 0x8000
    WindowMinMaxButtonsHint  : Qt.WindowType = ... # 0xc000
    WindowContextHelpButtonHint: Qt.WindowType = ... # 0x10000
    WindowShadeButtonHint    : Qt.WindowType = ... # 0x20000
    WindowStaysOnTopHint     : Qt.WindowType = ... # 0x40000
    WindowTransparentForInput: Qt.WindowType = ... # 0x80000
    WindowOverridesSystemGestures: Qt.WindowType = ... # 0x100000
    WindowDoesNotAcceptFocus : Qt.WindowType = ... # 0x200000
    MaximizeUsingFullscreenGeometryHint: Qt.WindowType = ... # 0x400000
    CustomizeWindowHint      : Qt.WindowType = ... # 0x2000000
    WindowStaysOnBottomHint  : Qt.WindowType = ... # 0x4000000
    WindowCloseButtonHint    : Qt.WindowType = ... # 0x8000000
    MacWindowToolBarButtonHint: Qt.WindowType = ... # 0x10000000
    BypassGraphicsProxyWidget: Qt.WindowType = ... # 0x20000000
    NoDropShadowWindowHint   : Qt.WindowType = ... # 0x40000000
    WindowFullscreenButtonHint: Qt.WindowType = ... # -0x80000000

    class Alignment(object): ...

    class AlignmentFlag(Shiboken.Enum):
        AlignLeading             : Qt.AlignmentFlag = ... # 0x1
        AlignLeft                : Qt.AlignmentFlag = ... # 0x1
        AlignRight               : Qt.AlignmentFlag = ... # 0x2
        AlignTrailing            : Qt.AlignmentFlag = ... # 0x2
        AlignHCenter             : Qt.AlignmentFlag = ... # 0x4
        AlignJustify             : Qt.AlignmentFlag = ... # 0x8
        AlignAbsolute            : Qt.AlignmentFlag = ... # 0x10
        AlignHorizontal_Mask     : Qt.AlignmentFlag = ... # 0x1f
        AlignTop                 : Qt.AlignmentFlag = ... # 0x20
        AlignBottom              : Qt.AlignmentFlag = ... # 0x40
        AlignVCenter             : Qt.AlignmentFlag = ... # 0x80
        AlignCenter              : Qt.AlignmentFlag = ... # 0x84
        AlignBaseline            : Qt.AlignmentFlag = ... # 0x100
        AlignVertical_Mask       : Qt.AlignmentFlag = ... # 0x1e0

    class AnchorPoint(Shiboken.Enum):
        AnchorLeft               : Qt.AnchorPoint = ... # 0x0
        AnchorHorizontalCenter   : Qt.AnchorPoint = ... # 0x1
        AnchorRight              : Qt.AnchorPoint = ... # 0x2
        AnchorTop                : Qt.AnchorPoint = ... # 0x3
        AnchorVerticalCenter     : Qt.AnchorPoint = ... # 0x4
        AnchorBottom             : Qt.AnchorPoint = ... # 0x5

    class ApplicationAttribute(Shiboken.Enum):
        AA_ImmediateWidgetCreation: Qt.ApplicationAttribute = ... # 0x0
        AA_MSWindowsUseDirect3DByDefault: Qt.ApplicationAttribute = ... # 0x1
        AA_DontShowIconsInMenus  : Qt.ApplicationAttribute = ... # 0x2
        AA_NativeWindows         : Qt.ApplicationAttribute = ... # 0x3
        AA_DontCreateNativeWidgetSiblings: Qt.ApplicationAttribute = ... # 0x4
        AA_MacPluginApplication  : Qt.ApplicationAttribute = ... # 0x5
        AA_PluginApplication     : Qt.ApplicationAttribute = ... # 0x5
        AA_DontUseNativeMenuBar  : Qt.ApplicationAttribute = ... # 0x6
        AA_MacDontSwapCtrlAndMeta: Qt.ApplicationAttribute = ... # 0x7
        AA_Use96Dpi              : Qt.ApplicationAttribute = ... # 0x8
        AA_DisableNativeVirtualKeyboard: Qt.ApplicationAttribute = ... # 0x9
        AA_X11InitThreads        : Qt.ApplicationAttribute = ... # 0xa
        AA_SynthesizeTouchForUnhandledMouseEvents: Qt.ApplicationAttribute = ... # 0xb
        AA_SynthesizeMouseForUnhandledTouchEvents: Qt.ApplicationAttribute = ... # 0xc
        AA_UseHighDpiPixmaps     : Qt.ApplicationAttribute = ... # 0xd
        AA_ForceRasterWidgets    : Qt.ApplicationAttribute = ... # 0xe
        AA_UseDesktopOpenGL      : Qt.ApplicationAttribute = ... # 0xf
        AA_UseOpenGLES           : Qt.ApplicationAttribute = ... # 0x10
        AA_UseSoftwareOpenGL     : Qt.ApplicationAttribute = ... # 0x11
        AA_ShareOpenGLContexts   : Qt.ApplicationAttribute = ... # 0x12
        AA_SetPalette            : Qt.ApplicationAttribute = ... # 0x13
        AA_EnableHighDpiScaling  : Qt.ApplicationAttribute = ... # 0x14
        AA_DisableHighDpiScaling : Qt.ApplicationAttribute = ... # 0x15
        AA_UseStyleSheetPropagationInWidgetStyles: Qt.ApplicationAttribute = ... # 0x16
        AA_DontUseNativeDialogs  : Qt.ApplicationAttribute = ... # 0x17
        AA_SynthesizeMouseForUnhandledTabletEvents: Qt.ApplicationAttribute = ... # 0x18
        AA_CompressHighFrequencyEvents: Qt.ApplicationAttribute = ... # 0x19
        AA_DontCheckOpenGLContextThreadAffinity: Qt.ApplicationAttribute = ... # 0x1a
        AA_DisableShaderDiskCache: Qt.ApplicationAttribute = ... # 0x1b
        AA_DontShowShortcutsInContextMenus: Qt.ApplicationAttribute = ... # 0x1c
        AA_CompressTabletEvents  : Qt.ApplicationAttribute = ... # 0x1d
        AA_DisableWindowContextHelpButton: Qt.ApplicationAttribute = ... # 0x1e
        AA_DisableSessionManager : Qt.ApplicationAttribute = ... # 0x1f
        AA_AttributeCount        : Qt.ApplicationAttribute = ... # 0x20

    class ApplicationState(Shiboken.Enum):
        ApplicationSuspended     : Qt.ApplicationState = ... # 0x0
        ApplicationHidden        : Qt.ApplicationState = ... # 0x1
        ApplicationInactive      : Qt.ApplicationState = ... # 0x2
        ApplicationActive        : Qt.ApplicationState = ... # 0x4

    class ApplicationStates(object): ...

    class ArrowType(Shiboken.Enum):
        NoArrow                  : Qt.ArrowType = ... # 0x0
        UpArrow                  : Qt.ArrowType = ... # 0x1
        DownArrow                : Qt.ArrowType = ... # 0x2
        LeftArrow                : Qt.ArrowType = ... # 0x3
        RightArrow               : Qt.ArrowType = ... # 0x4

    class AspectRatioMode(Shiboken.Enum):
        IgnoreAspectRatio        : Qt.AspectRatioMode = ... # 0x0
        KeepAspectRatio          : Qt.AspectRatioMode = ... # 0x1
        KeepAspectRatioByExpanding: Qt.AspectRatioMode = ... # 0x2

    class Axis(Shiboken.Enum):
        XAxis                    : Qt.Axis = ... # 0x0
        YAxis                    : Qt.Axis = ... # 0x1
        ZAxis                    : Qt.Axis = ... # 0x2

    class BGMode(Shiboken.Enum):
        TransparentMode          : Qt.BGMode = ... # 0x0
        OpaqueMode               : Qt.BGMode = ... # 0x1

    class BrushStyle(Shiboken.Enum):
        NoBrush                  : Qt.BrushStyle = ... # 0x0
        SolidPattern             : Qt.BrushStyle = ... # 0x1
        Dense1Pattern            : Qt.BrushStyle = ... # 0x2
        Dense2Pattern            : Qt.BrushStyle = ... # 0x3
        Dense3Pattern            : Qt.BrushStyle = ... # 0x4
        Dense4Pattern            : Qt.BrushStyle = ... # 0x5
        Dense5Pattern            : Qt.BrushStyle = ... # 0x6
        Dense6Pattern            : Qt.BrushStyle = ... # 0x7
        Dense7Pattern            : Qt.BrushStyle = ... # 0x8
        HorPattern               : Qt.BrushStyle = ... # 0x9
        VerPattern               : Qt.BrushStyle = ... # 0xa
        CrossPattern             : Qt.BrushStyle = ... # 0xb
        BDiagPattern             : Qt.BrushStyle = ... # 0xc
        FDiagPattern             : Qt.BrushStyle = ... # 0xd
        DiagCrossPattern         : Qt.BrushStyle = ... # 0xe
        LinearGradientPattern    : Qt.BrushStyle = ... # 0xf
        RadialGradientPattern    : Qt.BrushStyle = ... # 0x10
        ConicalGradientPattern   : Qt.BrushStyle = ... # 0x11
        TexturePattern           : Qt.BrushStyle = ... # 0x18

    class CaseSensitivity(Shiboken.Enum):
        CaseInsensitive          : Qt.CaseSensitivity = ... # 0x0
        CaseSensitive            : Qt.CaseSensitivity = ... # 0x1

    class CheckState(Shiboken.Enum):
        Unchecked                : Qt.CheckState = ... # 0x0
        PartiallyChecked         : Qt.CheckState = ... # 0x1
        Checked                  : Qt.CheckState = ... # 0x2

    class ChecksumType(Shiboken.Enum):
        ChecksumIso3309          : Qt.ChecksumType = ... # 0x0
        ChecksumItuV41           : Qt.ChecksumType = ... # 0x1

    class ClipOperation(Shiboken.Enum):
        NoClip                   : Qt.ClipOperation = ... # 0x0
        ReplaceClip              : Qt.ClipOperation = ... # 0x1
        IntersectClip            : Qt.ClipOperation = ... # 0x2

    class ConnectionType(Shiboken.Enum):
        AutoConnection           : Qt.ConnectionType = ... # 0x0
        DirectConnection         : Qt.ConnectionType = ... # 0x1
        QueuedConnection         : Qt.ConnectionType = ... # 0x2
        BlockingQueuedConnection : Qt.ConnectionType = ... # 0x3
        UniqueConnection         : Qt.ConnectionType = ... # 0x80

    class ContextMenuPolicy(Shiboken.Enum):
        NoContextMenu            : Qt.ContextMenuPolicy = ... # 0x0
        DefaultContextMenu       : Qt.ContextMenuPolicy = ... # 0x1
        ActionsContextMenu       : Qt.ContextMenuPolicy = ... # 0x2
        CustomContextMenu        : Qt.ContextMenuPolicy = ... # 0x3
        PreventContextMenu       : Qt.ContextMenuPolicy = ... # 0x4

    class CoordinateSystem(Shiboken.Enum):
        DeviceCoordinates        : Qt.CoordinateSystem = ... # 0x0
        LogicalCoordinates       : Qt.CoordinateSystem = ... # 0x1

    class Corner(Shiboken.Enum):
        TopLeftCorner            : Qt.Corner = ... # 0x0
        TopRightCorner           : Qt.Corner = ... # 0x1
        BottomLeftCorner         : Qt.Corner = ... # 0x2
        BottomRightCorner        : Qt.Corner = ... # 0x3

    class CursorMoveStyle(Shiboken.Enum):
        LogicalMoveStyle         : Qt.CursorMoveStyle = ... # 0x0
        VisualMoveStyle          : Qt.CursorMoveStyle = ... # 0x1

    class CursorShape(Shiboken.Enum):
        ArrowCursor              : Qt.CursorShape = ... # 0x0
        UpArrowCursor            : Qt.CursorShape = ... # 0x1
        CrossCursor              : Qt.CursorShape = ... # 0x2
        WaitCursor               : Qt.CursorShape = ... # 0x3
        IBeamCursor              : Qt.CursorShape = ... # 0x4
        SizeVerCursor            : Qt.CursorShape = ... # 0x5
        SizeHorCursor            : Qt.CursorShape = ... # 0x6
        SizeBDiagCursor          : Qt.CursorShape = ... # 0x7
        SizeFDiagCursor          : Qt.CursorShape = ... # 0x8
        SizeAllCursor            : Qt.CursorShape = ... # 0x9
        BlankCursor              : Qt.CursorShape = ... # 0xa
        SplitVCursor             : Qt.CursorShape = ... # 0xb
        SplitHCursor             : Qt.CursorShape = ... # 0xc
        PointingHandCursor       : Qt.CursorShape = ... # 0xd
        ForbiddenCursor          : Qt.CursorShape = ... # 0xe
        WhatsThisCursor          : Qt.CursorShape = ... # 0xf
        BusyCursor               : Qt.CursorShape = ... # 0x10
        OpenHandCursor           : Qt.CursorShape = ... # 0x11
        ClosedHandCursor         : Qt.CursorShape = ... # 0x12
        DragCopyCursor           : Qt.CursorShape = ... # 0x13
        DragMoveCursor           : Qt.CursorShape = ... # 0x14
        DragLinkCursor           : Qt.CursorShape = ... # 0x15
        LastCursor               : Qt.CursorShape = ... # 0x15
        BitmapCursor             : Qt.CursorShape = ... # 0x18
        CustomCursor             : Qt.CursorShape = ... # 0x19

    class DateFormat(Shiboken.Enum):
        TextDate                 : Qt.DateFormat = ... # 0x0
        ISODate                  : Qt.DateFormat = ... # 0x1
        LocalDate                : Qt.DateFormat = ... # 0x2
        SystemLocaleDate         : Qt.DateFormat = ... # 0x2
        LocaleDate               : Qt.DateFormat = ... # 0x3
        SystemLocaleShortDate    : Qt.DateFormat = ... # 0x4
        SystemLocaleLongDate     : Qt.DateFormat = ... # 0x5
        DefaultLocaleShortDate   : Qt.DateFormat = ... # 0x6
        DefaultLocaleLongDate    : Qt.DateFormat = ... # 0x7
        RFC2822Date              : Qt.DateFormat = ... # 0x8
        ISODateWithMs            : Qt.DateFormat = ... # 0x9

    class DayOfWeek(Shiboken.Enum):
        Monday                   : Qt.DayOfWeek = ... # 0x1
        Tuesday                  : Qt.DayOfWeek = ... # 0x2
        Wednesday                : Qt.DayOfWeek = ... # 0x3
        Thursday                 : Qt.DayOfWeek = ... # 0x4
        Friday                   : Qt.DayOfWeek = ... # 0x5
        Saturday                 : Qt.DayOfWeek = ... # 0x6
        Sunday                   : Qt.DayOfWeek = ... # 0x7

    class DockWidgetArea(Shiboken.Enum):
        NoDockWidgetArea         : Qt.DockWidgetArea = ... # 0x0
        LeftDockWidgetArea       : Qt.DockWidgetArea = ... # 0x1
        RightDockWidgetArea      : Qt.DockWidgetArea = ... # 0x2
        TopDockWidgetArea        : Qt.DockWidgetArea = ... # 0x4
        BottomDockWidgetArea     : Qt.DockWidgetArea = ... # 0x8
        AllDockWidgetAreas       : Qt.DockWidgetArea = ... # 0xf
        DockWidgetArea_Mask      : Qt.DockWidgetArea = ... # 0xf

    class DockWidgetAreaSizes(Shiboken.Enum):
        NDockWidgetAreas         : Qt.DockWidgetAreaSizes = ... # 0x4

    class DockWidgetAreas(object): ...

    class DropAction(Shiboken.Enum):
        IgnoreAction             : Qt.DropAction = ... # 0x0
        CopyAction               : Qt.DropAction = ... # 0x1
        MoveAction               : Qt.DropAction = ... # 0x2
        LinkAction               : Qt.DropAction = ... # 0x4
        ActionMask               : Qt.DropAction = ... # 0xff
        TargetMoveAction         : Qt.DropAction = ... # 0x8002

    class DropActions(object): ...

    class Edge(Shiboken.Enum):
        TopEdge                  : Qt.Edge = ... # 0x1
        LeftEdge                 : Qt.Edge = ... # 0x2
        RightEdge                : Qt.Edge = ... # 0x4
        BottomEdge               : Qt.Edge = ... # 0x8

    class Edges(object): ...

    class EnterKeyType(Shiboken.Enum):
        EnterKeyDefault          : Qt.EnterKeyType = ... # 0x0
        EnterKeyReturn           : Qt.EnterKeyType = ... # 0x1
        EnterKeyDone             : Qt.EnterKeyType = ... # 0x2
        EnterKeyGo               : Qt.EnterKeyType = ... # 0x3
        EnterKeySend             : Qt.EnterKeyType = ... # 0x4
        EnterKeySearch           : Qt.EnterKeyType = ... # 0x5
        EnterKeyNext             : Qt.EnterKeyType = ... # 0x6
        EnterKeyPrevious         : Qt.EnterKeyType = ... # 0x7

    class EventPriority(Shiboken.Enum):
        LowEventPriority         : Qt.EventPriority = ... # -0x1
        NormalEventPriority      : Qt.EventPriority = ... # 0x0
        HighEventPriority        : Qt.EventPriority = ... # 0x1

    class FillRule(Shiboken.Enum):
        OddEvenFill              : Qt.FillRule = ... # 0x0
        WindingFill              : Qt.FillRule = ... # 0x1

    class FindChildOption(Shiboken.Enum):
        FindDirectChildrenOnly   : Qt.FindChildOption = ... # 0x0
        FindChildrenRecursively  : Qt.FindChildOption = ... # 0x1

    class FindChildOptions(object): ...

    class FocusPolicy(Shiboken.Enum):
        NoFocus                  : Qt.FocusPolicy = ... # 0x0
        TabFocus                 : Qt.FocusPolicy = ... # 0x1
        ClickFocus               : Qt.FocusPolicy = ... # 0x2
        StrongFocus              : Qt.FocusPolicy = ... # 0xb
        WheelFocus               : Qt.FocusPolicy = ... # 0xf

    class FocusReason(Shiboken.Enum):
        MouseFocusReason         : Qt.FocusReason = ... # 0x0
        TabFocusReason           : Qt.FocusReason = ... # 0x1
        BacktabFocusReason       : Qt.FocusReason = ... # 0x2
        ActiveWindowFocusReason  : Qt.FocusReason = ... # 0x3
        PopupFocusReason         : Qt.FocusReason = ... # 0x4
        ShortcutFocusReason      : Qt.FocusReason = ... # 0x5
        MenuBarFocusReason       : Qt.FocusReason = ... # 0x6
        OtherFocusReason         : Qt.FocusReason = ... # 0x7
        NoFocusReason            : Qt.FocusReason = ... # 0x8

    class GestureFlag(Shiboken.Enum):
        DontStartGestureOnChildren: Qt.GestureFlag = ... # 0x1
        ReceivePartialGestures   : Qt.GestureFlag = ... # 0x2
        IgnoredGesturesPropagateToParent: Qt.GestureFlag = ... # 0x4

    class GestureFlags(object): ...

    class GestureState(Shiboken.Enum):
        NoGesture                : Qt.GestureState = ... # 0x0
        GestureStarted           : Qt.GestureState = ... # 0x1
        GestureUpdated           : Qt.GestureState = ... # 0x2
        GestureFinished          : Qt.GestureState = ... # 0x3
        GestureCanceled          : Qt.GestureState = ... # 0x4

    class GestureType(Shiboken.Enum):
        TapGesture               : Qt.GestureType = ... # 0x1
        TapAndHoldGesture        : Qt.GestureType = ... # 0x2
        PanGesture               : Qt.GestureType = ... # 0x3
        PinchGesture             : Qt.GestureType = ... # 0x4
        SwipeGesture             : Qt.GestureType = ... # 0x5
        CustomGesture            : Qt.GestureType = ... # 0x100
        LastGestureType          : Qt.GestureType = ... # 0xffffffff

    class GlobalColor(Shiboken.Enum):
        color0                   : Qt.GlobalColor = ... # 0x0
        color1                   : Qt.GlobalColor = ... # 0x1
        black                    : Qt.GlobalColor = ... # 0x2
        white                    : Qt.GlobalColor = ... # 0x3
        darkGray                 : Qt.GlobalColor = ... # 0x4
        gray                     : Qt.GlobalColor = ... # 0x5
        lightGray                : Qt.GlobalColor = ... # 0x6
        red                      : Qt.GlobalColor = ... # 0x7
        green                    : Qt.GlobalColor = ... # 0x8
        blue                     : Qt.GlobalColor = ... # 0x9
        cyan                     : Qt.GlobalColor = ... # 0xa
        magenta                  : Qt.GlobalColor = ... # 0xb
        yellow                   : Qt.GlobalColor = ... # 0xc
        darkRed                  : Qt.GlobalColor = ... # 0xd
        darkGreen                : Qt.GlobalColor = ... # 0xe
        darkBlue                 : Qt.GlobalColor = ... # 0xf
        darkCyan                 : Qt.GlobalColor = ... # 0x10
        darkMagenta              : Qt.GlobalColor = ... # 0x11
        darkYellow               : Qt.GlobalColor = ... # 0x12
        transparent              : Qt.GlobalColor = ... # 0x13

    class HighDpiScaleFactorRoundingPolicy(Shiboken.Enum):
        Unset                    : Qt.HighDpiScaleFactorRoundingPolicy = ... # 0x0
        Round                    : Qt.HighDpiScaleFactorRoundingPolicy = ... # 0x1
        Ceil                     : Qt.HighDpiScaleFactorRoundingPolicy = ... # 0x2
        Floor                    : Qt.HighDpiScaleFactorRoundingPolicy = ... # 0x3
        RoundPreferFloor         : Qt.HighDpiScaleFactorRoundingPolicy = ... # 0x4
        PassThrough              : Qt.HighDpiScaleFactorRoundingPolicy = ... # 0x5

    class HitTestAccuracy(Shiboken.Enum):
        ExactHit                 : Qt.HitTestAccuracy = ... # 0x0
        FuzzyHit                 : Qt.HitTestAccuracy = ... # 0x1

    class ImageConversionFlag(Shiboken.Enum):
        AutoColor                : Qt.ImageConversionFlag = ... # 0x0
        AutoDither               : Qt.ImageConversionFlag = ... # 0x0
        DiffuseDither            : Qt.ImageConversionFlag = ... # 0x0
        ThresholdAlphaDither     : Qt.ImageConversionFlag = ... # 0x0
        MonoOnly                 : Qt.ImageConversionFlag = ... # 0x2
        ColorMode_Mask           : Qt.ImageConversionFlag = ... # 0x3
        ColorOnly                : Qt.ImageConversionFlag = ... # 0x3
        OrderedAlphaDither       : Qt.ImageConversionFlag = ... # 0x4
        DiffuseAlphaDither       : Qt.ImageConversionFlag = ... # 0x8
        AlphaDither_Mask         : Qt.ImageConversionFlag = ... # 0xc
        NoAlpha                  : Qt.ImageConversionFlag = ... # 0xc
        OrderedDither            : Qt.ImageConversionFlag = ... # 0x10
        ThresholdDither          : Qt.ImageConversionFlag = ... # 0x20
        Dither_Mask              : Qt.ImageConversionFlag = ... # 0x30
        PreferDither             : Qt.ImageConversionFlag = ... # 0x40
        AvoidDither              : Qt.ImageConversionFlag = ... # 0x80
        DitherMode_Mask          : Qt.ImageConversionFlag = ... # 0xc0
        NoOpaqueDetection        : Qt.ImageConversionFlag = ... # 0x100
        NoFormatConversion       : Qt.ImageConversionFlag = ... # 0x200

    class ImageConversionFlags(object): ...

    class InputMethodHint(Shiboken.Enum):
        ImhNone                  : Qt.InputMethodHint = ... # 0x0
        ImhHiddenText            : Qt.InputMethodHint = ... # 0x1
        ImhSensitiveData         : Qt.InputMethodHint = ... # 0x2
        ImhNoAutoUppercase       : Qt.InputMethodHint = ... # 0x4
        ImhPreferNumbers         : Qt.InputMethodHint = ... # 0x8
        ImhPreferUppercase       : Qt.InputMethodHint = ... # 0x10
        ImhPreferLowercase       : Qt.InputMethodHint = ... # 0x20
        ImhNoPredictiveText      : Qt.InputMethodHint = ... # 0x40
        ImhDate                  : Qt.InputMethodHint = ... # 0x80
        ImhTime                  : Qt.InputMethodHint = ... # 0x100
        ImhPreferLatin           : Qt.InputMethodHint = ... # 0x200
        ImhMultiLine             : Qt.InputMethodHint = ... # 0x400
        ImhNoEditMenu            : Qt.InputMethodHint = ... # 0x800
        ImhNoTextHandles         : Qt.InputMethodHint = ... # 0x1000
        ImhDigitsOnly            : Qt.InputMethodHint = ... # 0x10000
        ImhFormattedNumbersOnly  : Qt.InputMethodHint = ... # 0x20000
        ImhUppercaseOnly         : Qt.InputMethodHint = ... # 0x40000
        ImhLowercaseOnly         : Qt.InputMethodHint = ... # 0x80000
        ImhDialableCharactersOnly: Qt.InputMethodHint = ... # 0x100000
        ImhEmailCharactersOnly   : Qt.InputMethodHint = ... # 0x200000
        ImhUrlCharactersOnly     : Qt.InputMethodHint = ... # 0x400000
        ImhLatinOnly             : Qt.InputMethodHint = ... # 0x800000
        ImhExclusiveInputMask    : Qt.InputMethodHint = ... # -0x10000

    class InputMethodHints(object): ...

    class InputMethodQueries(object): ...

    class InputMethodQuery(Shiboken.Enum):
        ImEnabled                : Qt.InputMethodQuery = ... # 0x1
        ImCursorRectangle        : Qt.InputMethodQuery = ... # 0x2
        ImMicroFocus             : Qt.InputMethodQuery = ... # 0x2
        ImFont                   : Qt.InputMethodQuery = ... # 0x4
        ImCursorPosition         : Qt.InputMethodQuery = ... # 0x8
        ImSurroundingText        : Qt.InputMethodQuery = ... # 0x10
        ImCurrentSelection       : Qt.InputMethodQuery = ... # 0x20
        ImMaximumTextLength      : Qt.InputMethodQuery = ... # 0x40
        ImAnchorPosition         : Qt.InputMethodQuery = ... # 0x80
        ImHints                  : Qt.InputMethodQuery = ... # 0x100
        ImPreferredLanguage      : Qt.InputMethodQuery = ... # 0x200
        ImAbsolutePosition       : Qt.InputMethodQuery = ... # 0x400
        ImTextBeforeCursor       : Qt.InputMethodQuery = ... # 0x800
        ImTextAfterCursor        : Qt.InputMethodQuery = ... # 0x1000
        ImEnterKeyType           : Qt.InputMethodQuery = ... # 0x2000
        ImAnchorRectangle        : Qt.InputMethodQuery = ... # 0x4000
        ImQueryInput             : Qt.InputMethodQuery = ... # 0x40ba
        ImInputItemClipRectangle : Qt.InputMethodQuery = ... # 0x8000
        ImPlatformData           : Qt.InputMethodQuery = ... # -0x80000000
        ImQueryAll               : Qt.InputMethodQuery = ... # -0x1

    class ItemDataRole(Shiboken.Enum):
        DisplayRole              : Qt.ItemDataRole = ... # 0x0
        DecorationRole           : Qt.ItemDataRole = ... # 0x1
        EditRole                 : Qt.ItemDataRole = ... # 0x2
        ToolTipRole              : Qt.ItemDataRole = ... # 0x3
        StatusTipRole            : Qt.ItemDataRole = ... # 0x4
        WhatsThisRole            : Qt.ItemDataRole = ... # 0x5
        FontRole                 : Qt.ItemDataRole = ... # 0x6
        TextAlignmentRole        : Qt.ItemDataRole = ... # 0x7
        BackgroundColorRole      : Qt.ItemDataRole = ... # 0x8
        BackgroundRole           : Qt.ItemDataRole = ... # 0x8
        ForegroundRole           : Qt.ItemDataRole = ... # 0x9
        TextColorRole            : Qt.ItemDataRole = ... # 0x9
        CheckStateRole           : Qt.ItemDataRole = ... # 0xa
        AccessibleTextRole       : Qt.ItemDataRole = ... # 0xb
        AccessibleDescriptionRole: Qt.ItemDataRole = ... # 0xc
        SizeHintRole             : Qt.ItemDataRole = ... # 0xd
        InitialSortOrderRole     : Qt.ItemDataRole = ... # 0xe
        DisplayPropertyRole      : Qt.ItemDataRole = ... # 0x1b
        DecorationPropertyRole   : Qt.ItemDataRole = ... # 0x1c
        ToolTipPropertyRole      : Qt.ItemDataRole = ... # 0x1d
        StatusTipPropertyRole    : Qt.ItemDataRole = ... # 0x1e
        WhatsThisPropertyRole    : Qt.ItemDataRole = ... # 0x1f
        UserRole                 : Qt.ItemDataRole = ... # 0x100

    class ItemFlag(Shiboken.Enum):
        NoItemFlags              : Qt.ItemFlag = ... # 0x0
        ItemIsSelectable         : Qt.ItemFlag = ... # 0x1
        ItemIsEditable           : Qt.ItemFlag = ... # 0x2
        ItemIsDragEnabled        : Qt.ItemFlag = ... # 0x4
        ItemIsDropEnabled        : Qt.ItemFlag = ... # 0x8
        ItemIsUserCheckable      : Qt.ItemFlag = ... # 0x10
        ItemIsEnabled            : Qt.ItemFlag = ... # 0x20
        ItemIsAutoTristate       : Qt.ItemFlag = ... # 0x40
        ItemIsTristate           : Qt.ItemFlag = ... # 0x40
        ItemNeverHasChildren     : Qt.ItemFlag = ... # 0x80
        ItemIsUserTristate       : Qt.ItemFlag = ... # 0x100

    class ItemFlags(object): ...

    class ItemSelectionMode(Shiboken.Enum):
        ContainsItemShape        : Qt.ItemSelectionMode = ... # 0x0
        IntersectsItemShape      : Qt.ItemSelectionMode = ... # 0x1
        ContainsItemBoundingRect : Qt.ItemSelectionMode = ... # 0x2
        IntersectsItemBoundingRect: Qt.ItemSelectionMode = ... # 0x3

    class ItemSelectionOperation(Shiboken.Enum):
        ReplaceSelection         : Qt.ItemSelectionOperation = ... # 0x0
        AddToSelection           : Qt.ItemSelectionOperation = ... # 0x1

    class Key(Shiboken.Enum):
        Key_Any                  : Qt.Key = ... # 0x20
        Key_Space                : Qt.Key = ... # 0x20
        Key_Exclam               : Qt.Key = ... # 0x21
        Key_QuoteDbl             : Qt.Key = ... # 0x22
        Key_NumberSign           : Qt.Key = ... # 0x23
        Key_Dollar               : Qt.Key = ... # 0x24
        Key_Percent              : Qt.Key = ... # 0x25
        Key_Ampersand            : Qt.Key = ... # 0x26
        Key_Apostrophe           : Qt.Key = ... # 0x27
        Key_ParenLeft            : Qt.Key = ... # 0x28
        Key_ParenRight           : Qt.Key = ... # 0x29
        Key_Asterisk             : Qt.Key = ... # 0x2a
        Key_Plus                 : Qt.Key = ... # 0x2b
        Key_Comma                : Qt.Key = ... # 0x2c
        Key_Minus                : Qt.Key = ... # 0x2d
        Key_Period               : Qt.Key = ... # 0x2e
        Key_Slash                : Qt.Key = ... # 0x2f
        Key_0                    : Qt.Key = ... # 0x30
        Key_1                    : Qt.Key = ... # 0x31
        Key_2                    : Qt.Key = ... # 0x32
        Key_3                    : Qt.Key = ... # 0x33
        Key_4                    : Qt.Key = ... # 0x34
        Key_5                    : Qt.Key = ... # 0x35
        Key_6                    : Qt.Key = ... # 0x36
        Key_7                    : Qt.Key = ... # 0x37
        Key_8                    : Qt.Key = ... # 0x38
        Key_9                    : Qt.Key = ... # 0x39
        Key_Colon                : Qt.Key = ... # 0x3a
        Key_Semicolon            : Qt.Key = ... # 0x3b
        Key_Less                 : Qt.Key = ... # 0x3c
        Key_Equal                : Qt.Key = ... # 0x3d
        Key_Greater              : Qt.Key = ... # 0x3e
        Key_Question             : Qt.Key = ... # 0x3f
        Key_At                   : Qt.Key = ... # 0x40
        Key_A                    : Qt.Key = ... # 0x41
        Key_B                    : Qt.Key = ... # 0x42
        Key_C                    : Qt.Key = ... # 0x43
        Key_D                    : Qt.Key = ... # 0x44
        Key_E                    : Qt.Key = ... # 0x45
        Key_F                    : Qt.Key = ... # 0x46
        Key_G                    : Qt.Key = ... # 0x47
        Key_H                    : Qt.Key = ... # 0x48
        Key_I                    : Qt.Key = ... # 0x49
        Key_J                    : Qt.Key = ... # 0x4a
        Key_K                    : Qt.Key = ... # 0x4b
        Key_L                    : Qt.Key = ... # 0x4c
        Key_M                    : Qt.Key = ... # 0x4d
        Key_N                    : Qt.Key = ... # 0x4e
        Key_O                    : Qt.Key = ... # 0x4f
        Key_P                    : Qt.Key = ... # 0x50
        Key_Q                    : Qt.Key = ... # 0x51
        Key_R                    : Qt.Key = ... # 0x52
        Key_S                    : Qt.Key = ... # 0x53
        Key_T                    : Qt.Key = ... # 0x54
        Key_U                    : Qt.Key = ... # 0x55
        Key_V                    : Qt.Key = ... # 0x56
        Key_W                    : Qt.Key = ... # 0x57
        Key_X                    : Qt.Key = ... # 0x58
        Key_Y                    : Qt.Key = ... # 0x59
        Key_Z                    : Qt.Key = ... # 0x5a
        Key_BracketLeft          : Qt.Key = ... # 0x5b
        Key_Backslash            : Qt.Key = ... # 0x5c
        Key_BracketRight         : Qt.Key = ... # 0x5d
        Key_AsciiCircum          : Qt.Key = ... # 0x5e
        Key_Underscore           : Qt.Key = ... # 0x5f
        Key_QuoteLeft            : Qt.Key = ... # 0x60
        Key_BraceLeft            : Qt.Key = ... # 0x7b
        Key_Bar                  : Qt.Key = ... # 0x7c
        Key_BraceRight           : Qt.Key = ... # 0x7d
        Key_AsciiTilde           : Qt.Key = ... # 0x7e
        Key_nobreakspace         : Qt.Key = ... # 0xa0
        Key_exclamdown           : Qt.Key = ... # 0xa1
        Key_cent                 : Qt.Key = ... # 0xa2
        Key_sterling             : Qt.Key = ... # 0xa3
        Key_currency             : Qt.Key = ... # 0xa4
        Key_yen                  : Qt.Key = ... # 0xa5
        Key_brokenbar            : Qt.Key = ... # 0xa6
        Key_section              : Qt.Key = ... # 0xa7
        Key_diaeresis            : Qt.Key = ... # 0xa8
        Key_copyright            : Qt.Key = ... # 0xa9
        Key_ordfeminine          : Qt.Key = ... # 0xaa
        Key_guillemotleft        : Qt.Key = ... # 0xab
        Key_notsign              : Qt.Key = ... # 0xac
        Key_hyphen               : Qt.Key = ... # 0xad
        Key_registered           : Qt.Key = ... # 0xae
        Key_macron               : Qt.Key = ... # 0xaf
        Key_degree               : Qt.Key = ... # 0xb0
        Key_plusminus            : Qt.Key = ... # 0xb1
        Key_twosuperior          : Qt.Key = ... # 0xb2
        Key_threesuperior        : Qt.Key = ... # 0xb3
        Key_acute                : Qt.Key = ... # 0xb4
        Key_mu                   : Qt.Key = ... # 0xb5
        Key_paragraph            : Qt.Key = ... # 0xb6
        Key_periodcentered       : Qt.Key = ... # 0xb7
        Key_cedilla              : Qt.Key = ... # 0xb8
        Key_onesuperior          : Qt.Key = ... # 0xb9
        Key_masculine            : Qt.Key = ... # 0xba
        Key_guillemotright       : Qt.Key = ... # 0xbb
        Key_onequarter           : Qt.Key = ... # 0xbc
        Key_onehalf              : Qt.Key = ... # 0xbd
        Key_threequarters        : Qt.Key = ... # 0xbe
        Key_questiondown         : Qt.Key = ... # 0xbf
        Key_Agrave               : Qt.Key = ... # 0xc0
        Key_Aacute               : Qt.Key = ... # 0xc1
        Key_Acircumflex          : Qt.Key = ... # 0xc2
        Key_Atilde               : Qt.Key = ... # 0xc3
        Key_Adiaeresis           : Qt.Key = ... # 0xc4
        Key_Aring                : Qt.Key = ... # 0xc5
        Key_AE                   : Qt.Key = ... # 0xc6
        Key_Ccedilla             : Qt.Key = ... # 0xc7
        Key_Egrave               : Qt.Key = ... # 0xc8
        Key_Eacute               : Qt.Key = ... # 0xc9
        Key_Ecircumflex          : Qt.Key = ... # 0xca
        Key_Ediaeresis           : Qt.Key = ... # 0xcb
        Key_Igrave               : Qt.Key = ... # 0xcc
        Key_Iacute               : Qt.Key = ... # 0xcd
        Key_Icircumflex          : Qt.Key = ... # 0xce
        Key_Idiaeresis           : Qt.Key = ... # 0xcf
        Key_ETH                  : Qt.Key = ... # 0xd0
        Key_Ntilde               : Qt.Key = ... # 0xd1
        Key_Ograve               : Qt.Key = ... # 0xd2
        Key_Oacute               : Qt.Key = ... # 0xd3
        Key_Ocircumflex          : Qt.Key = ... # 0xd4
        Key_Otilde               : Qt.Key = ... # 0xd5
        Key_Odiaeresis           : Qt.Key = ... # 0xd6
        Key_multiply             : Qt.Key = ... # 0xd7
        Key_Ooblique             : Qt.Key = ... # 0xd8
        Key_Ugrave               : Qt.Key = ... # 0xd9
        Key_Uacute               : Qt.Key = ... # 0xda
        Key_Ucircumflex          : Qt.Key = ... # 0xdb
        Key_Udiaeresis           : Qt.Key = ... # 0xdc
        Key_Yacute               : Qt.Key = ... # 0xdd
        Key_THORN                : Qt.Key = ... # 0xde
        Key_ssharp               : Qt.Key = ... # 0xdf
        Key_division             : Qt.Key = ... # 0xf7
        Key_ydiaeresis           : Qt.Key = ... # 0xff
        Key_Escape               : Qt.Key = ... # 0x1000000
        Key_Tab                  : Qt.Key = ... # 0x1000001
        Key_Backtab              : Qt.Key = ... # 0x1000002
        Key_Backspace            : Qt.Key = ... # 0x1000003
        Key_Return               : Qt.Key = ... # 0x1000004
        Key_Enter                : Qt.Key = ... # 0x1000005
        Key_Insert               : Qt.Key = ... # 0x1000006
        Key_Delete               : Qt.Key = ... # 0x1000007
        Key_Pause                : Qt.Key = ... # 0x1000008
        Key_Print                : Qt.Key = ... # 0x1000009
        Key_SysReq               : Qt.Key = ... # 0x100000a
        Key_Clear                : Qt.Key = ... # 0x100000b
        Key_Home                 : Qt.Key = ... # 0x1000010
        Key_End                  : Qt.Key = ... # 0x1000011
        Key_Left                 : Qt.Key = ... # 0x1000012
        Key_Up                   : Qt.Key = ... # 0x1000013
        Key_Right                : Qt.Key = ... # 0x1000014
        Key_Down                 : Qt.Key = ... # 0x1000015
        Key_PageUp               : Qt.Key = ... # 0x1000016
        Key_PageDown             : Qt.Key = ... # 0x1000017
        Key_Shift                : Qt.Key = ... # 0x1000020
        Key_Control              : Qt.Key = ... # 0x1000021
        Key_Meta                 : Qt.Key = ... # 0x1000022
        Key_Alt                  : Qt.Key = ... # 0x1000023
        Key_CapsLock             : Qt.Key = ... # 0x1000024
        Key_NumLock              : Qt.Key = ... # 0x1000025
        Key_ScrollLock           : Qt.Key = ... # 0x1000026
        Key_F1                   : Qt.Key = ... # 0x1000030
        Key_F2                   : Qt.Key = ... # 0x1000031
        Key_F3                   : Qt.Key = ... # 0x1000032
        Key_F4                   : Qt.Key = ... # 0x1000033
        Key_F5                   : Qt.Key = ... # 0x1000034
        Key_F6                   : Qt.Key = ... # 0x1000035
        Key_F7                   : Qt.Key = ... # 0x1000036
        Key_F8                   : Qt.Key = ... # 0x1000037
        Key_F9                   : Qt.Key = ... # 0x1000038
        Key_F10                  : Qt.Key = ... # 0x1000039
        Key_F11                  : Qt.Key = ... # 0x100003a
        Key_F12                  : Qt.Key = ... # 0x100003b
        Key_F13                  : Qt.Key = ... # 0x100003c
        Key_F14                  : Qt.Key = ... # 0x100003d
        Key_F15                  : Qt.Key = ... # 0x100003e
        Key_F16                  : Qt.Key = ... # 0x100003f
        Key_F17                  : Qt.Key = ... # 0x1000040
        Key_F18                  : Qt.Key = ... # 0x1000041
        Key_F19                  : Qt.Key = ... # 0x1000042
        Key_F20                  : Qt.Key = ... # 0x1000043
        Key_F21                  : Qt.Key = ... # 0x1000044
        Key_F22                  : Qt.Key = ... # 0x1000045
        Key_F23                  : Qt.Key = ... # 0x1000046
        Key_F24                  : Qt.Key = ... # 0x1000047
        Key_F25                  : Qt.Key = ... # 0x1000048
        Key_F26                  : Qt.Key = ... # 0x1000049
        Key_F27                  : Qt.Key = ... # 0x100004a
        Key_F28                  : Qt.Key = ... # 0x100004b
        Key_F29                  : Qt.Key = ... # 0x100004c
        Key_F30                  : Qt.Key = ... # 0x100004d
        Key_F31                  : Qt.Key = ... # 0x100004e
        Key_F32                  : Qt.Key = ... # 0x100004f
        Key_F33                  : Qt.Key = ... # 0x1000050
        Key_F34                  : Qt.Key = ... # 0x1000051
        Key_F35                  : Qt.Key = ... # 0x1000052
        Key_Super_L              : Qt.Key = ... # 0x1000053
        Key_Super_R              : Qt.Key = ... # 0x1000054
        Key_Menu                 : Qt.Key = ... # 0x1000055
        Key_Hyper_L              : Qt.Key = ... # 0x1000056
        Key_Hyper_R              : Qt.Key = ... # 0x1000057
        Key_Help                 : Qt.Key = ... # 0x1000058
        Key_Direction_L          : Qt.Key = ... # 0x1000059
        Key_Direction_R          : Qt.Key = ... # 0x1000060
        Key_Back                 : Qt.Key = ... # 0x1000061
        Key_Forward              : Qt.Key = ... # 0x1000062
        Key_Stop                 : Qt.Key = ... # 0x1000063
        Key_Refresh              : Qt.Key = ... # 0x1000064
        Key_VolumeDown           : Qt.Key = ... # 0x1000070
        Key_VolumeMute           : Qt.Key = ... # 0x1000071
        Key_VolumeUp             : Qt.Key = ... # 0x1000072
        Key_BassBoost            : Qt.Key = ... # 0x1000073
        Key_BassUp               : Qt.Key = ... # 0x1000074
        Key_BassDown             : Qt.Key = ... # 0x1000075
        Key_TrebleUp             : Qt.Key = ... # 0x1000076
        Key_TrebleDown           : Qt.Key = ... # 0x1000077
        Key_MediaPlay            : Qt.Key = ... # 0x1000080
        Key_MediaStop            : Qt.Key = ... # 0x1000081
        Key_MediaPrevious        : Qt.Key = ... # 0x1000082
        Key_MediaNext            : Qt.Key = ... # 0x1000083
        Key_MediaRecord          : Qt.Key = ... # 0x1000084
        Key_MediaPause           : Qt.Key = ... # 0x1000085
        Key_MediaTogglePlayPause : Qt.Key = ... # 0x1000086
        Key_HomePage             : Qt.Key = ... # 0x1000090
        Key_Favorites            : Qt.Key = ... # 0x1000091
        Key_Search               : Qt.Key = ... # 0x1000092
        Key_Standby              : Qt.Key = ... # 0x1000093
        Key_OpenUrl              : Qt.Key = ... # 0x1000094
        Key_LaunchMail           : Qt.Key = ... # 0x10000a0
        Key_LaunchMedia          : Qt.Key = ... # 0x10000a1
        Key_Launch0              : Qt.Key = ... # 0x10000a2
        Key_Launch1              : Qt.Key = ... # 0x10000a3
        Key_Launch2              : Qt.Key = ... # 0x10000a4
        Key_Launch3              : Qt.Key = ... # 0x10000a5
        Key_Launch4              : Qt.Key = ... # 0x10000a6
        Key_Launch5              : Qt.Key = ... # 0x10000a7
        Key_Launch6              : Qt.Key = ... # 0x10000a8
        Key_Launch7              : Qt.Key = ... # 0x10000a9
        Key_Launch8              : Qt.Key = ... # 0x10000aa
        Key_Launch9              : Qt.Key = ... # 0x10000ab
        Key_LaunchA              : Qt.Key = ... # 0x10000ac
        Key_LaunchB              : Qt.Key = ... # 0x10000ad
        Key_LaunchC              : Qt.Key = ... # 0x10000ae
        Key_LaunchD              : Qt.Key = ... # 0x10000af
        Key_LaunchE              : Qt.Key = ... # 0x10000b0
        Key_LaunchF              : Qt.Key = ... # 0x10000b1
        Key_MonBrightnessUp      : Qt.Key = ... # 0x10000b2
        Key_MonBrightnessDown    : Qt.Key = ... # 0x10000b3
        Key_KeyboardLightOnOff   : Qt.Key = ... # 0x10000b4
        Key_KeyboardBrightnessUp : Qt.Key = ... # 0x10000b5
        Key_KeyboardBrightnessDown: Qt.Key = ... # 0x10000b6
        Key_PowerOff             : Qt.Key = ... # 0x10000b7
        Key_WakeUp               : Qt.Key = ... # 0x10000b8
        Key_Eject                : Qt.Key = ... # 0x10000b9
        Key_ScreenSaver          : Qt.Key = ... # 0x10000ba
        Key_WWW                  : Qt.Key = ... # 0x10000bb
        Key_Memo                 : Qt.Key = ... # 0x10000bc
        Key_LightBulb            : Qt.Key = ... # 0x10000bd
        Key_Shop                 : Qt.Key = ... # 0x10000be
        Key_History              : Qt.Key = ... # 0x10000bf
        Key_AddFavorite          : Qt.Key = ... # 0x10000c0
        Key_HotLinks             : Qt.Key = ... # 0x10000c1
        Key_BrightnessAdjust     : Qt.Key = ... # 0x10000c2
        Key_Finance              : Qt.Key = ... # 0x10000c3
        Key_Community            : Qt.Key = ... # 0x10000c4
        Key_AudioRewind          : Qt.Key = ... # 0x10000c5
        Key_BackForward          : Qt.Key = ... # 0x10000c6
        Key_ApplicationLeft      : Qt.Key = ... # 0x10000c7
        Key_ApplicationRight     : Qt.Key = ... # 0x10000c8
        Key_Book                 : Qt.Key = ... # 0x10000c9
        Key_CD                   : Qt.Key = ... # 0x10000ca
        Key_Calculator           : Qt.Key = ... # 0x10000cb
        Key_ToDoList             : Qt.Key = ... # 0x10000cc
        Key_ClearGrab            : Qt.Key = ... # 0x10000cd
        Key_Close                : Qt.Key = ... # 0x10000ce
        Key_Copy                 : Qt.Key = ... # 0x10000cf
        Key_Cut                  : Qt.Key = ... # 0x10000d0
        Key_Display              : Qt.Key = ... # 0x10000d1
        Key_DOS                  : Qt.Key = ... # 0x10000d2
        Key_Documents            : Qt.Key = ... # 0x10000d3
        Key_Excel                : Qt.Key = ... # 0x10000d4
        Key_Explorer             : Qt.Key = ... # 0x10000d5
        Key_Game                 : Qt.Key = ... # 0x10000d6
        Key_Go                   : Qt.Key = ... # 0x10000d7
        Key_iTouch               : Qt.Key = ... # 0x10000d8
        Key_LogOff               : Qt.Key = ... # 0x10000d9
        Key_Market               : Qt.Key = ... # 0x10000da
        Key_Meeting              : Qt.Key = ... # 0x10000db
        Key_MenuKB               : Qt.Key = ... # 0x10000dc
        Key_MenuPB               : Qt.Key = ... # 0x10000dd
        Key_MySites              : Qt.Key = ... # 0x10000de
        Key_News                 : Qt.Key = ... # 0x10000df
        Key_OfficeHome           : Qt.Key = ... # 0x10000e0
        Key_Option               : Qt.Key = ... # 0x10000e1
        Key_Paste                : Qt.Key = ... # 0x10000e2
        Key_Phone                : Qt.Key = ... # 0x10000e3
        Key_Calendar             : Qt.Key = ... # 0x10000e4
        Key_Reply                : Qt.Key = ... # 0x10000e5
        Key_Reload               : Qt.Key = ... # 0x10000e6
        Key_RotateWindows        : Qt.Key = ... # 0x10000e7
        Key_RotationPB           : Qt.Key = ... # 0x10000e8
        Key_RotationKB           : Qt.Key = ... # 0x10000e9
        Key_Save                 : Qt.Key = ... # 0x10000ea
        Key_Send                 : Qt.Key = ... # 0x10000eb
        Key_Spell                : Qt.Key = ... # 0x10000ec
        Key_SplitScreen          : Qt.Key = ... # 0x10000ed
        Key_Support              : Qt.Key = ... # 0x10000ee
        Key_TaskPane             : Qt.Key = ... # 0x10000ef
        Key_Terminal             : Qt.Key = ... # 0x10000f0
        Key_Tools                : Qt.Key = ... # 0x10000f1
        Key_Travel               : Qt.Key = ... # 0x10000f2
        Key_Video                : Qt.Key = ... # 0x10000f3
        Key_Word                 : Qt.Key = ... # 0x10000f4
        Key_Xfer                 : Qt.Key = ... # 0x10000f5
        Key_ZoomIn               : Qt.Key = ... # 0x10000f6
        Key_ZoomOut              : Qt.Key = ... # 0x10000f7
        Key_Away                 : Qt.Key = ... # 0x10000f8
        Key_Messenger            : Qt.Key = ... # 0x10000f9
        Key_WebCam               : Qt.Key = ... # 0x10000fa
        Key_MailForward          : Qt.Key = ... # 0x10000fb
        Key_Pictures             : Qt.Key = ... # 0x10000fc
        Key_Music                : Qt.Key = ... # 0x10000fd
        Key_Battery              : Qt.Key = ... # 0x10000fe
        Key_Bluetooth            : Qt.Key = ... # 0x10000ff
        Key_WLAN                 : Qt.Key = ... # 0x1000100
        Key_UWB                  : Qt.Key = ... # 0x1000101
        Key_AudioForward         : Qt.Key = ... # 0x1000102
        Key_AudioRepeat          : Qt.Key = ... # 0x1000103
        Key_AudioRandomPlay      : Qt.Key = ... # 0x1000104
        Key_Subtitle             : Qt.Key = ... # 0x1000105
        Key_AudioCycleTrack      : Qt.Key = ... # 0x1000106
        Key_Time                 : Qt.Key = ... # 0x1000107
        Key_Hibernate            : Qt.Key = ... # 0x1000108
        Key_View                 : Qt.Key = ... # 0x1000109
        Key_TopMenu              : Qt.Key = ... # 0x100010a
        Key_PowerDown            : Qt.Key = ... # 0x100010b
        Key_Suspend              : Qt.Key = ... # 0x100010c
        Key_ContrastAdjust       : Qt.Key = ... # 0x100010d
        Key_LaunchG              : Qt.Key = ... # 0x100010e
        Key_LaunchH              : Qt.Key = ... # 0x100010f
        Key_TouchpadToggle       : Qt.Key = ... # 0x1000110
        Key_TouchpadOn           : Qt.Key = ... # 0x1000111
        Key_TouchpadOff          : Qt.Key = ... # 0x1000112
        Key_MicMute              : Qt.Key = ... # 0x1000113
        Key_Red                  : Qt.Key = ... # 0x1000114
        Key_Green                : Qt.Key = ... # 0x1000115
        Key_Yellow               : Qt.Key = ... # 0x1000116
        Key_Blue                 : Qt.Key = ... # 0x1000117
        Key_ChannelUp            : Qt.Key = ... # 0x1000118
        Key_ChannelDown          : Qt.Key = ... # 0x1000119
        Key_Guide                : Qt.Key = ... # 0x100011a
        Key_Info                 : Qt.Key = ... # 0x100011b
        Key_Settings             : Qt.Key = ... # 0x100011c
        Key_MicVolumeUp          : Qt.Key = ... # 0x100011d
        Key_MicVolumeDown        : Qt.Key = ... # 0x100011e
        Key_New                  : Qt.Key = ... # 0x1000120
        Key_Open                 : Qt.Key = ... # 0x1000121
        Key_Find                 : Qt.Key = ... # 0x1000122
        Key_Undo                 : Qt.Key = ... # 0x1000123
        Key_Redo                 : Qt.Key = ... # 0x1000124
        Key_AltGr                : Qt.Key = ... # 0x1001103
        Key_Multi_key            : Qt.Key = ... # 0x1001120
        Key_Kanji                : Qt.Key = ... # 0x1001121
        Key_Muhenkan             : Qt.Key = ... # 0x1001122
        Key_Henkan               : Qt.Key = ... # 0x1001123
        Key_Romaji               : Qt.Key = ... # 0x1001124
        Key_Hiragana             : Qt.Key = ... # 0x1001125
        Key_Katakana             : Qt.Key = ... # 0x1001126
        Key_Hiragana_Katakana    : Qt.Key = ... # 0x1001127
        Key_Zenkaku              : Qt.Key = ... # 0x1001128
        Key_Hankaku              : Qt.Key = ... # 0x1001129
        Key_Zenkaku_Hankaku      : Qt.Key = ... # 0x100112a
        Key_Touroku              : Qt.Key = ... # 0x100112b
        Key_Massyo               : Qt.Key = ... # 0x100112c
        Key_Kana_Lock            : Qt.Key = ... # 0x100112d
        Key_Kana_Shift           : Qt.Key = ... # 0x100112e
        Key_Eisu_Shift           : Qt.Key = ... # 0x100112f
        Key_Eisu_toggle          : Qt.Key = ... # 0x1001130
        Key_Hangul               : Qt.Key = ... # 0x1001131
        Key_Hangul_Start         : Qt.Key = ... # 0x1001132
        Key_Hangul_End           : Qt.Key = ... # 0x1001133
        Key_Hangul_Hanja         : Qt.Key = ... # 0x1001134
        Key_Hangul_Jamo          : Qt.Key = ... # 0x1001135
        Key_Hangul_Romaja        : Qt.Key = ... # 0x1001136
        Key_Codeinput            : Qt.Key = ... # 0x1001137
        Key_Hangul_Jeonja        : Qt.Key = ... # 0x1001138
        Key_Hangul_Banja         : Qt.Key = ... # 0x1001139
        Key_Hangul_PreHanja      : Qt.Key = ... # 0x100113a
        Key_Hangul_PostHanja     : Qt.Key = ... # 0x100113b
        Key_SingleCandidate      : Qt.Key = ... # 0x100113c
        Key_MultipleCandidate    : Qt.Key = ... # 0x100113d
        Key_PreviousCandidate    : Qt.Key = ... # 0x100113e
        Key_Hangul_Special       : Qt.Key = ... # 0x100113f
        Key_Mode_switch          : Qt.Key = ... # 0x100117e
        Key_Dead_Grave           : Qt.Key = ... # 0x1001250
        Key_Dead_Acute           : Qt.Key = ... # 0x1001251
        Key_Dead_Circumflex      : Qt.Key = ... # 0x1001252
        Key_Dead_Tilde           : Qt.Key = ... # 0x1001253
        Key_Dead_Macron          : Qt.Key = ... # 0x1001254
        Key_Dead_Breve           : Qt.Key = ... # 0x1001255
        Key_Dead_Abovedot        : Qt.Key = ... # 0x1001256
        Key_Dead_Diaeresis       : Qt.Key = ... # 0x1001257
        Key_Dead_Abovering       : Qt.Key = ... # 0x1001258
        Key_Dead_Doubleacute     : Qt.Key = ... # 0x1001259
        Key_Dead_Caron           : Qt.Key = ... # 0x100125a
        Key_Dead_Cedilla         : Qt.Key = ... # 0x100125b
        Key_Dead_Ogonek          : Qt.Key = ... # 0x100125c
        Key_Dead_Iota            : Qt.Key = ... # 0x100125d
        Key_Dead_Voiced_Sound    : Qt.Key = ... # 0x100125e
        Key_Dead_Semivoiced_Sound: Qt.Key = ... # 0x100125f
        Key_Dead_Belowdot        : Qt.Key = ... # 0x1001260
        Key_Dead_Hook            : Qt.Key = ... # 0x1001261
        Key_Dead_Horn            : Qt.Key = ... # 0x1001262
        Key_Dead_Stroke          : Qt.Key = ... # 0x1001263
        Key_Dead_Abovecomma      : Qt.Key = ... # 0x1001264
        Key_Dead_Abovereversedcomma: Qt.Key = ... # 0x1001265
        Key_Dead_Doublegrave     : Qt.Key = ... # 0x1001266
        Key_Dead_Belowring       : Qt.Key = ... # 0x1001267
        Key_Dead_Belowmacron     : Qt.Key = ... # 0x1001268
        Key_Dead_Belowcircumflex : Qt.Key = ... # 0x1001269
        Key_Dead_Belowtilde      : Qt.Key = ... # 0x100126a
        Key_Dead_Belowbreve      : Qt.Key = ... # 0x100126b
        Key_Dead_Belowdiaeresis  : Qt.Key = ... # 0x100126c
        Key_Dead_Invertedbreve   : Qt.Key = ... # 0x100126d
        Key_Dead_Belowcomma      : Qt.Key = ... # 0x100126e
        Key_Dead_Currency        : Qt.Key = ... # 0x100126f
        Key_Dead_a               : Qt.Key = ... # 0x1001280
        Key_Dead_A               : Qt.Key = ... # 0x1001281
        Key_Dead_e               : Qt.Key = ... # 0x1001282
        Key_Dead_E               : Qt.Key = ... # 0x1001283
        Key_Dead_i               : Qt.Key = ... # 0x1001284
        Key_Dead_I               : Qt.Key = ... # 0x1001285
        Key_Dead_o               : Qt.Key = ... # 0x1001286
        Key_Dead_O               : Qt.Key = ... # 0x1001287
        Key_Dead_u               : Qt.Key = ... # 0x1001288
        Key_Dead_U               : Qt.Key = ... # 0x1001289
        Key_Dead_Small_Schwa     : Qt.Key = ... # 0x100128a
        Key_Dead_Capital_Schwa   : Qt.Key = ... # 0x100128b
        Key_Dead_Greek           : Qt.Key = ... # 0x100128c
        Key_Dead_Lowline         : Qt.Key = ... # 0x1001290
        Key_Dead_Aboveverticalline: Qt.Key = ... # 0x1001291
        Key_Dead_Belowverticalline: Qt.Key = ... # 0x1001292
        Key_Dead_Longsolidusoverlay: Qt.Key = ... # 0x1001293
        Key_MediaLast            : Qt.Key = ... # 0x100ffff
        Key_Select               : Qt.Key = ... # 0x1010000
        Key_Yes                  : Qt.Key = ... # 0x1010001
        Key_No                   : Qt.Key = ... # 0x1010002
        Key_Cancel               : Qt.Key = ... # 0x1020001
        Key_Printer              : Qt.Key = ... # 0x1020002
        Key_Execute              : Qt.Key = ... # 0x1020003
        Key_Sleep                : Qt.Key = ... # 0x1020004
        Key_Play                 : Qt.Key = ... # 0x1020005
        Key_Zoom                 : Qt.Key = ... # 0x1020006
        Key_Exit                 : Qt.Key = ... # 0x102000a
        Key_Context1             : Qt.Key = ... # 0x1100000
        Key_Context2             : Qt.Key = ... # 0x1100001
        Key_Context3             : Qt.Key = ... # 0x1100002
        Key_Context4             : Qt.Key = ... # 0x1100003
        Key_Call                 : Qt.Key = ... # 0x1100004
        Key_Hangup               : Qt.Key = ... # 0x1100005
        Key_Flip                 : Qt.Key = ... # 0x1100006
        Key_ToggleCallHangup     : Qt.Key = ... # 0x1100007
        Key_VoiceDial            : Qt.Key = ... # 0x1100008
        Key_LastNumberRedial     : Qt.Key = ... # 0x1100009
        Key_Camera               : Qt.Key = ... # 0x1100020
        Key_CameraFocus          : Qt.Key = ... # 0x1100021
        Key_unknown              : Qt.Key = ... # 0x1ffffff

    class KeyboardModifier(Shiboken.Enum):
        NoModifier               : Qt.KeyboardModifier = ... # 0x0
        ShiftModifier            : Qt.KeyboardModifier = ... # 0x2000000
        ControlModifier          : Qt.KeyboardModifier = ... # 0x4000000
        AltModifier              : Qt.KeyboardModifier = ... # 0x8000000
        MetaModifier             : Qt.KeyboardModifier = ... # 0x10000000
        KeypadModifier           : Qt.KeyboardModifier = ... # 0x20000000
        GroupSwitchModifier      : Qt.KeyboardModifier = ... # 0x40000000
        KeyboardModifierMask     : Qt.KeyboardModifier = ... # -0x2000000

    class KeyboardModifiers(object): ...

    class LayoutDirection(Shiboken.Enum):
        LeftToRight              : Qt.LayoutDirection = ... # 0x0
        RightToLeft              : Qt.LayoutDirection = ... # 0x1
        LayoutDirectionAuto      : Qt.LayoutDirection = ... # 0x2

    class MaskMode(Shiboken.Enum):
        MaskInColor              : Qt.MaskMode = ... # 0x0
        MaskOutColor             : Qt.MaskMode = ... # 0x1

    class MatchFlag(Shiboken.Enum):
        MatchExactly             : Qt.MatchFlag = ... # 0x0
        MatchContains            : Qt.MatchFlag = ... # 0x1
        MatchStartsWith          : Qt.MatchFlag = ... # 0x2
        MatchEndsWith            : Qt.MatchFlag = ... # 0x3
        MatchRegExp              : Qt.MatchFlag = ... # 0x4
        MatchWildcard            : Qt.MatchFlag = ... # 0x5
        MatchFixedString         : Qt.MatchFlag = ... # 0x8
        MatchRegularExpression   : Qt.MatchFlag = ... # 0x9
        MatchCaseSensitive       : Qt.MatchFlag = ... # 0x10
        MatchWrap                : Qt.MatchFlag = ... # 0x20
        MatchRecursive           : Qt.MatchFlag = ... # 0x40

    class MatchFlags(object): ...

    class Modifier(Shiboken.Enum):
        UNICODE_ACCEL            : Qt.Modifier = ... # 0x0
        SHIFT                    : Qt.Modifier = ... # 0x2000000
        CTRL                     : Qt.Modifier = ... # 0x4000000
        ALT                      : Qt.Modifier = ... # 0x8000000
        META                     : Qt.Modifier = ... # 0x10000000
        MODIFIER_MASK            : Qt.Modifier = ... # 0xfe000000

    class MouseButton(Shiboken.Enum):
        NoButton                 : Qt.MouseButton = ... # 0x0
        LeftButton               : Qt.MouseButton = ... # 0x1
        RightButton              : Qt.MouseButton = ... # 0x2
        MidButton                : Qt.MouseButton = ... # 0x4
        MiddleButton             : Qt.MouseButton = ... # 0x4
        BackButton               : Qt.MouseButton = ... # 0x8
        ExtraButton1             : Qt.MouseButton = ... # 0x8
        XButton1                 : Qt.MouseButton = ... # 0x8
        ExtraButton2             : Qt.MouseButton = ... # 0x10
        ForwardButton            : Qt.MouseButton = ... # 0x10
        XButton2                 : Qt.MouseButton = ... # 0x10
        ExtraButton3             : Qt.MouseButton = ... # 0x20
        TaskButton               : Qt.MouseButton = ... # 0x20
        ExtraButton4             : Qt.MouseButton = ... # 0x40
        ExtraButton5             : Qt.MouseButton = ... # 0x80
        ExtraButton6             : Qt.MouseButton = ... # 0x100
        ExtraButton7             : Qt.MouseButton = ... # 0x200
        ExtraButton8             : Qt.MouseButton = ... # 0x400
        ExtraButton9             : Qt.MouseButton = ... # 0x800
        ExtraButton10            : Qt.MouseButton = ... # 0x1000
        ExtraButton11            : Qt.MouseButton = ... # 0x2000
        ExtraButton12            : Qt.MouseButton = ... # 0x4000
        ExtraButton13            : Qt.MouseButton = ... # 0x8000
        ExtraButton14            : Qt.MouseButton = ... # 0x10000
        ExtraButton15            : Qt.MouseButton = ... # 0x20000
        ExtraButton16            : Qt.MouseButton = ... # 0x40000
        ExtraButton17            : Qt.MouseButton = ... # 0x80000
        ExtraButton18            : Qt.MouseButton = ... # 0x100000
        ExtraButton19            : Qt.MouseButton = ... # 0x200000
        ExtraButton20            : Qt.MouseButton = ... # 0x400000
        ExtraButton21            : Qt.MouseButton = ... # 0x800000
        ExtraButton22            : Qt.MouseButton = ... # 0x1000000
        ExtraButton23            : Qt.MouseButton = ... # 0x2000000
        ExtraButton24            : Qt.MouseButton = ... # 0x4000000
        MaxMouseButton           : Qt.MouseButton = ... # 0x4000000
        AllButtons               : Qt.MouseButton = ... # 0x7ffffff
        MouseButtonMask          : Qt.MouseButton = ... # -0x1

    class MouseButtons(object): ...

    class MouseEventFlag(Shiboken.Enum):
        MouseEventCreatedDoubleClick: Qt.MouseEventFlag = ... # 0x1
        MouseEventFlagMask       : Qt.MouseEventFlag = ... # 0xff

    class MouseEventFlags(object): ...

    class MouseEventSource(Shiboken.Enum):
        MouseEventNotSynthesized : Qt.MouseEventSource = ... # 0x0
        MouseEventSynthesizedBySystem: Qt.MouseEventSource = ... # 0x1
        MouseEventSynthesizedByQt: Qt.MouseEventSource = ... # 0x2
        MouseEventSynthesizedByApplication: Qt.MouseEventSource = ... # 0x3

    class NativeGestureType(Shiboken.Enum):
        BeginNativeGesture       : Qt.NativeGestureType = ... # 0x0
        EndNativeGesture         : Qt.NativeGestureType = ... # 0x1
        PanNativeGesture         : Qt.NativeGestureType = ... # 0x2
        ZoomNativeGesture        : Qt.NativeGestureType = ... # 0x3
        SmartZoomNativeGesture   : Qt.NativeGestureType = ... # 0x4
        RotateNativeGesture      : Qt.NativeGestureType = ... # 0x5
        SwipeNativeGesture       : Qt.NativeGestureType = ... # 0x6

    class NavigationMode(Shiboken.Enum):
        NavigationModeNone       : Qt.NavigationMode = ... # 0x0
        NavigationModeKeypadTabOrder: Qt.NavigationMode = ... # 0x1
        NavigationModeKeypadDirectional: Qt.NavigationMode = ... # 0x2
        NavigationModeCursorAuto : Qt.NavigationMode = ... # 0x3
        NavigationModeCursorForceVisible: Qt.NavigationMode = ... # 0x4

    class Orientation(Shiboken.Enum):
        Horizontal               : Qt.Orientation = ... # 0x1
        Vertical                 : Qt.Orientation = ... # 0x2

    class Orientations(object): ...

    class PenCapStyle(Shiboken.Enum):
        FlatCap                  : Qt.PenCapStyle = ... # 0x0
        SquareCap                : Qt.PenCapStyle = ... # 0x10
        RoundCap                 : Qt.PenCapStyle = ... # 0x20
        MPenCapStyle             : Qt.PenCapStyle = ... # 0x30

    class PenJoinStyle(Shiboken.Enum):
        MiterJoin                : Qt.PenJoinStyle = ... # 0x0
        BevelJoin                : Qt.PenJoinStyle = ... # 0x40
        RoundJoin                : Qt.PenJoinStyle = ... # 0x80
        SvgMiterJoin             : Qt.PenJoinStyle = ... # 0x100
        MPenJoinStyle            : Qt.PenJoinStyle = ... # 0x1c0

    class PenStyle(Shiboken.Enum):
        NoPen                    : Qt.PenStyle = ... # 0x0
        SolidLine                : Qt.PenStyle = ... # 0x1
        DashLine                 : Qt.PenStyle = ... # 0x2
        DotLine                  : Qt.PenStyle = ... # 0x3
        DashDotLine              : Qt.PenStyle = ... # 0x4
        DashDotDotLine           : Qt.PenStyle = ... # 0x5
        CustomDashLine           : Qt.PenStyle = ... # 0x6
        MPenStyle                : Qt.PenStyle = ... # 0xf

    class ScreenOrientation(Shiboken.Enum):
        PrimaryOrientation       : Qt.ScreenOrientation = ... # 0x0
        PortraitOrientation      : Qt.ScreenOrientation = ... # 0x1
        LandscapeOrientation     : Qt.ScreenOrientation = ... # 0x2
        InvertedPortraitOrientation: Qt.ScreenOrientation = ... # 0x4
        InvertedLandscapeOrientation: Qt.ScreenOrientation = ... # 0x8

    class ScreenOrientations(object): ...

    class ScrollBarPolicy(Shiboken.Enum):
        ScrollBarAsNeeded        : Qt.ScrollBarPolicy = ... # 0x0
        ScrollBarAlwaysOff       : Qt.ScrollBarPolicy = ... # 0x1
        ScrollBarAlwaysOn        : Qt.ScrollBarPolicy = ... # 0x2

    class ScrollPhase(Shiboken.Enum):
        NoScrollPhase            : Qt.ScrollPhase = ... # 0x0
        ScrollBegin              : Qt.ScrollPhase = ... # 0x1
        ScrollUpdate             : Qt.ScrollPhase = ... # 0x2
        ScrollEnd                : Qt.ScrollPhase = ... # 0x3
        ScrollMomentum           : Qt.ScrollPhase = ... # 0x4

    class ShortcutContext(Shiboken.Enum):
        WidgetShortcut           : Qt.ShortcutContext = ... # 0x0
        WindowShortcut           : Qt.ShortcutContext = ... # 0x1
        ApplicationShortcut      : Qt.ShortcutContext = ... # 0x2
        WidgetWithChildrenShortcut: Qt.ShortcutContext = ... # 0x3

    class SizeHint(Shiboken.Enum):
        MinimumSize              : Qt.SizeHint = ... # 0x0
        PreferredSize            : Qt.SizeHint = ... # 0x1
        MaximumSize              : Qt.SizeHint = ... # 0x2
        MinimumDescent           : Qt.SizeHint = ... # 0x3
        NSizeHints               : Qt.SizeHint = ... # 0x4

    class SizeMode(Shiboken.Enum):
        AbsoluteSize             : Qt.SizeMode = ... # 0x0
        RelativeSize             : Qt.SizeMode = ... # 0x1

    class SortOrder(Shiboken.Enum):
        AscendingOrder           : Qt.SortOrder = ... # 0x0
        DescendingOrder          : Qt.SortOrder = ... # 0x1

    class SplitBehavior(object): ...

    class SplitBehaviorFlags(Shiboken.Enum):
        KeepEmptyParts           : Qt.SplitBehaviorFlags = ... # 0x0
        SkipEmptyParts           : Qt.SplitBehaviorFlags = ... # 0x1

    class TabFocusBehavior(Shiboken.Enum):
        NoTabFocus               : Qt.TabFocusBehavior = ... # 0x0
        TabFocusTextControls     : Qt.TabFocusBehavior = ... # 0x1
        TabFocusListControls     : Qt.TabFocusBehavior = ... # 0x2
        TabFocusAllControls      : Qt.TabFocusBehavior = ... # 0xff

    class TextElideMode(Shiboken.Enum):
        ElideLeft                : Qt.TextElideMode = ... # 0x0
        ElideRight               : Qt.TextElideMode = ... # 0x1
        ElideMiddle              : Qt.TextElideMode = ... # 0x2
        ElideNone                : Qt.TextElideMode = ... # 0x3

    class TextFlag(Shiboken.Enum):
        TextSingleLine           : Qt.TextFlag = ... # 0x100
        TextDontClip             : Qt.TextFlag = ... # 0x200
        TextExpandTabs           : Qt.TextFlag = ... # 0x400
        TextShowMnemonic         : Qt.TextFlag = ... # 0x800
        TextWordWrap             : Qt.TextFlag = ... # 0x1000
        TextWrapAnywhere         : Qt.TextFlag = ... # 0x2000
        TextDontPrint            : Qt.TextFlag = ... # 0x4000
        TextHideMnemonic         : Qt.TextFlag = ... # 0x8000
        TextJustificationForced  : Qt.TextFlag = ... # 0x10000
        TextForceLeftToRight     : Qt.TextFlag = ... # 0x20000
        TextForceRightToLeft     : Qt.TextFlag = ... # 0x40000
        TextLongestVariant       : Qt.TextFlag = ... # 0x80000
        TextBypassShaping        : Qt.TextFlag = ... # 0x100000
        TextIncludeTrailingSpaces: Qt.TextFlag = ... # 0x8000000

    class TextFormat(Shiboken.Enum):
        PlainText                : Qt.TextFormat = ... # 0x0
        RichText                 : Qt.TextFormat = ... # 0x1
        AutoText                 : Qt.TextFormat = ... # 0x2
        MarkdownText             : Qt.TextFormat = ... # 0x3

    class TextInteractionFlag(Shiboken.Enum):
        NoTextInteraction        : Qt.TextInteractionFlag = ... # 0x0
        TextSelectableByMouse    : Qt.TextInteractionFlag = ... # 0x1
        TextSelectableByKeyboard : Qt.TextInteractionFlag = ... # 0x2
        LinksAccessibleByMouse   : Qt.TextInteractionFlag = ... # 0x4
        LinksAccessibleByKeyboard: Qt.TextInteractionFlag = ... # 0x8
        TextBrowserInteraction   : Qt.TextInteractionFlag = ... # 0xd
        TextEditable             : Qt.TextInteractionFlag = ... # 0x10
        TextEditorInteraction    : Qt.TextInteractionFlag = ... # 0x13

    class TextInteractionFlags(object): ...

    class TileRule(Shiboken.Enum):
        StretchTile              : Qt.TileRule = ... # 0x0
        RepeatTile               : Qt.TileRule = ... # 0x1
        RoundTile                : Qt.TileRule = ... # 0x2

    class TimeSpec(Shiboken.Enum):
        LocalTime                : Qt.TimeSpec = ... # 0x0
        UTC                      : Qt.TimeSpec = ... # 0x1
        OffsetFromUTC            : Qt.TimeSpec = ... # 0x2
        TimeZone                 : Qt.TimeSpec = ... # 0x3

    class TimerType(Shiboken.Enum):
        PreciseTimer             : Qt.TimerType = ... # 0x0
        CoarseTimer              : Qt.TimerType = ... # 0x1
        VeryCoarseTimer          : Qt.TimerType = ... # 0x2

    class ToolBarArea(Shiboken.Enum):
        NoToolBarArea            : Qt.ToolBarArea = ... # 0x0
        LeftToolBarArea          : Qt.ToolBarArea = ... # 0x1
        RightToolBarArea         : Qt.ToolBarArea = ... # 0x2
        TopToolBarArea           : Qt.ToolBarArea = ... # 0x4
        BottomToolBarArea        : Qt.ToolBarArea = ... # 0x8
        AllToolBarAreas          : Qt.ToolBarArea = ... # 0xf
        ToolBarArea_Mask         : Qt.ToolBarArea = ... # 0xf

    class ToolBarAreaSizes(Shiboken.Enum):
        NToolBarAreas            : Qt.ToolBarAreaSizes = ... # 0x4

    class ToolBarAreas(object): ...

    class ToolButtonStyle(Shiboken.Enum):
        ToolButtonIconOnly       : Qt.ToolButtonStyle = ... # 0x0
        ToolButtonTextOnly       : Qt.ToolButtonStyle = ... # 0x1
        ToolButtonTextBesideIcon : Qt.ToolButtonStyle = ... # 0x2
        ToolButtonTextUnderIcon  : Qt.ToolButtonStyle = ... # 0x3
        ToolButtonFollowStyle    : Qt.ToolButtonStyle = ... # 0x4

    class TouchPointState(Shiboken.Enum):
        TouchPointPressed        : Qt.TouchPointState = ... # 0x1
        TouchPointMoved          : Qt.TouchPointState = ... # 0x2
        TouchPointStationary     : Qt.TouchPointState = ... # 0x4
        TouchPointReleased       : Qt.TouchPointState = ... # 0x8

    class TouchPointStates(object): ...

    class TransformationMode(Shiboken.Enum):
        FastTransformation       : Qt.TransformationMode = ... # 0x0
        SmoothTransformation     : Qt.TransformationMode = ... # 0x1

    class UIEffect(Shiboken.Enum):
        UI_General               : Qt.UIEffect = ... # 0x0
        UI_AnimateMenu           : Qt.UIEffect = ... # 0x1
        UI_FadeMenu              : Qt.UIEffect = ... # 0x2
        UI_AnimateCombo          : Qt.UIEffect = ... # 0x3
        UI_AnimateTooltip        : Qt.UIEffect = ... # 0x4
        UI_FadeTooltip           : Qt.UIEffect = ... # 0x5
        UI_AnimateToolBox        : Qt.UIEffect = ... # 0x6

    class WhiteSpaceMode(Shiboken.Enum):
        WhiteSpaceModeUndefined  : Qt.WhiteSpaceMode = ... # -0x1
        WhiteSpaceNormal         : Qt.WhiteSpaceMode = ... # 0x0
        WhiteSpacePre            : Qt.WhiteSpaceMode = ... # 0x1
        WhiteSpaceNoWrap         : Qt.WhiteSpaceMode = ... # 0x2

    class WidgetAttribute(Shiboken.Enum):
        WA_Disabled              : Qt.WidgetAttribute = ... # 0x0
        WA_UnderMouse            : Qt.WidgetAttribute = ... # 0x1
        WA_MouseTracking         : Qt.WidgetAttribute = ... # 0x2
        WA_ContentsPropagated    : Qt.WidgetAttribute = ... # 0x3
        WA_NoBackground          : Qt.WidgetAttribute = ... # 0x4
        WA_OpaquePaintEvent      : Qt.WidgetAttribute = ... # 0x4
        WA_StaticContents        : Qt.WidgetAttribute = ... # 0x5
        WA_LaidOut               : Qt.WidgetAttribute = ... # 0x7
        WA_PaintOnScreen         : Qt.WidgetAttribute = ... # 0x8
        WA_NoSystemBackground    : Qt.WidgetAttribute = ... # 0x9
        WA_UpdatesDisabled       : Qt.WidgetAttribute = ... # 0xa
        WA_Mapped                : Qt.WidgetAttribute = ... # 0xb
        WA_MacNoClickThrough     : Qt.WidgetAttribute = ... # 0xc
        WA_InputMethodEnabled    : Qt.WidgetAttribute = ... # 0xe
        WA_WState_Visible        : Qt.WidgetAttribute = ... # 0xf
        WA_WState_Hidden         : Qt.WidgetAttribute = ... # 0x10
        WA_ForceDisabled         : Qt.WidgetAttribute = ... # 0x20
        WA_KeyCompression        : Qt.WidgetAttribute = ... # 0x21
        WA_PendingMoveEvent      : Qt.WidgetAttribute = ... # 0x22
        WA_PendingResizeEvent    : Qt.WidgetAttribute = ... # 0x23
        WA_SetPalette            : Qt.WidgetAttribute = ... # 0x24
        WA_SetFont               : Qt.WidgetAttribute = ... # 0x25
        WA_SetCursor             : Qt.WidgetAttribute = ... # 0x26
        WA_NoChildEventsFromChildren: Qt.WidgetAttribute = ... # 0x27
        WA_WindowModified        : Qt.WidgetAttribute = ... # 0x29
        WA_Resized               : Qt.WidgetAttribute = ... # 0x2a
        WA_Moved                 : Qt.WidgetAttribute = ... # 0x2b
        WA_PendingUpdate         : Qt.WidgetAttribute = ... # 0x2c
        WA_InvalidSize           : Qt.WidgetAttribute = ... # 0x2d
        WA_MacBrushedMetal       : Qt.WidgetAttribute = ... # 0x2e
        WA_MacMetalStyle         : Qt.WidgetAttribute = ... # 0x2e
        WA_CustomWhatsThis       : Qt.WidgetAttribute = ... # 0x2f
        WA_LayoutOnEntireRect    : Qt.WidgetAttribute = ... # 0x30
        WA_OutsideWSRange        : Qt.WidgetAttribute = ... # 0x31
        WA_GrabbedShortcut       : Qt.WidgetAttribute = ... # 0x32
        WA_TransparentForMouseEvents: Qt.WidgetAttribute = ... # 0x33
        WA_PaintUnclipped        : Qt.WidgetAttribute = ... # 0x34
        WA_SetWindowIcon         : Qt.WidgetAttribute = ... # 0x35
        WA_NoMouseReplay         : Qt.WidgetAttribute = ... # 0x36
        WA_DeleteOnClose         : Qt.WidgetAttribute = ... # 0x37
        WA_RightToLeft           : Qt.WidgetAttribute = ... # 0x38
        WA_SetLayoutDirection    : Qt.WidgetAttribute = ... # 0x39
        WA_NoChildEventsForParent: Qt.WidgetAttribute = ... # 0x3a
        WA_ForceUpdatesDisabled  : Qt.WidgetAttribute = ... # 0x3b
        WA_WState_Created        : Qt.WidgetAttribute = ... # 0x3c
        WA_WState_CompressKeys   : Qt.WidgetAttribute = ... # 0x3d
        WA_WState_InPaintEvent   : Qt.WidgetAttribute = ... # 0x3e
        WA_WState_Reparented     : Qt.WidgetAttribute = ... # 0x3f
        WA_WState_ConfigPending  : Qt.WidgetAttribute = ... # 0x40
        WA_WState_Polished       : Qt.WidgetAttribute = ... # 0x42
        WA_WState_DND            : Qt.WidgetAttribute = ... # 0x43
        WA_WState_OwnSizePolicy  : Qt.WidgetAttribute = ... # 0x44
        WA_WState_ExplicitShowHide: Qt.WidgetAttribute = ... # 0x45
        WA_ShowModal             : Qt.WidgetAttribute = ... # 0x46
        WA_MouseNoMask           : Qt.WidgetAttribute = ... # 0x47
        WA_GroupLeader           : Qt.WidgetAttribute = ... # 0x48
        WA_NoMousePropagation    : Qt.WidgetAttribute = ... # 0x49
        WA_Hover                 : Qt.WidgetAttribute = ... # 0x4a
        WA_InputMethodTransparent: Qt.WidgetAttribute = ... # 0x4b
        WA_QuitOnClose           : Qt.WidgetAttribute = ... # 0x4c
        WA_KeyboardFocusChange   : Qt.WidgetAttribute = ... # 0x4d
        WA_AcceptDrops           : Qt.WidgetAttribute = ... # 0x4e
        WA_DropSiteRegistered    : Qt.WidgetAttribute = ... # 0x4f
        WA_ForceAcceptDrops      : Qt.WidgetAttribute = ... # 0x4f
        WA_WindowPropagation     : Qt.WidgetAttribute = ... # 0x50
        WA_NoX11EventCompression : Qt.WidgetAttribute = ... # 0x51
        WA_TintedBackground      : Qt.WidgetAttribute = ... # 0x52
        WA_X11OpenGLOverlay      : Qt.WidgetAttribute = ... # 0x53
        WA_AlwaysShowToolTips    : Qt.WidgetAttribute = ... # 0x54
        WA_MacOpaqueSizeGrip     : Qt.WidgetAttribute = ... # 0x55
        WA_SetStyle              : Qt.WidgetAttribute = ... # 0x56
        WA_SetLocale             : Qt.WidgetAttribute = ... # 0x57
        WA_MacShowFocusRect      : Qt.WidgetAttribute = ... # 0x58
        WA_MacNormalSize         : Qt.WidgetAttribute = ... # 0x59
        WA_MacSmallSize          : Qt.WidgetAttribute = ... # 0x5a
        WA_MacMiniSize           : Qt.WidgetAttribute = ... # 0x5b
        WA_LayoutUsesWidgetRect  : Qt.WidgetAttribute = ... # 0x5c
        WA_StyledBackground      : Qt.WidgetAttribute = ... # 0x5d
        WA_MSWindowsUseDirect3D  : Qt.WidgetAttribute = ... # 0x5e
        WA_CanHostQMdiSubWindowTitleBar: Qt.WidgetAttribute = ... # 0x5f
        WA_MacAlwaysShowToolWindow: Qt.WidgetAttribute = ... # 0x60
        WA_StyleSheet            : Qt.WidgetAttribute = ... # 0x61
        WA_ShowWithoutActivating : Qt.WidgetAttribute = ... # 0x62
        WA_X11BypassTransientForHint: Qt.WidgetAttribute = ... # 0x63
        WA_NativeWindow          : Qt.WidgetAttribute = ... # 0x64
        WA_DontCreateNativeAncestors: Qt.WidgetAttribute = ... # 0x65
        WA_MacVariableSize       : Qt.WidgetAttribute = ... # 0x66
        WA_DontShowOnScreen      : Qt.WidgetAttribute = ... # 0x67
        WA_X11NetWmWindowTypeDesktop: Qt.WidgetAttribute = ... # 0x68
        WA_X11NetWmWindowTypeDock: Qt.WidgetAttribute = ... # 0x69
        WA_X11NetWmWindowTypeToolBar: Qt.WidgetAttribute = ... # 0x6a
        WA_X11NetWmWindowTypeMenu: Qt.WidgetAttribute = ... # 0x6b
        WA_X11NetWmWindowTypeUtility: Qt.WidgetAttribute = ... # 0x6c
        WA_X11NetWmWindowTypeSplash: Qt.WidgetAttribute = ... # 0x6d
        WA_X11NetWmWindowTypeDialog: Qt.WidgetAttribute = ... # 0x6e
        WA_X11NetWmWindowTypeDropDownMenu: Qt.WidgetAttribute = ... # 0x6f
        WA_X11NetWmWindowTypePopupMenu: Qt.WidgetAttribute = ... # 0x70
        WA_X11NetWmWindowTypeToolTip: Qt.WidgetAttribute = ... # 0x71
        WA_X11NetWmWindowTypeNotification: Qt.WidgetAttribute = ... # 0x72
        WA_X11NetWmWindowTypeCombo: Qt.WidgetAttribute = ... # 0x73
        WA_X11NetWmWindowTypeDND : Qt.WidgetAttribute = ... # 0x74
        WA_MacFrameworkScaled    : Qt.WidgetAttribute = ... # 0x75
        WA_SetWindowModality     : Qt.WidgetAttribute = ... # 0x76
        WA_WState_WindowOpacitySet: Qt.WidgetAttribute = ... # 0x77
        WA_TranslucentBackground : Qt.WidgetAttribute = ... # 0x78
        WA_AcceptTouchEvents     : Qt.WidgetAttribute = ... # 0x79
        WA_WState_AcceptedTouchBeginEvent: Qt.WidgetAttribute = ... # 0x7a
        WA_TouchPadAcceptSingleTouchEvents: Qt.WidgetAttribute = ... # 0x7b
        WA_X11DoNotAcceptFocus   : Qt.WidgetAttribute = ... # 0x7e
        WA_MacNoShadow           : Qt.WidgetAttribute = ... # 0x7f
        WA_AlwaysStackOnTop      : Qt.WidgetAttribute = ... # 0x80
        WA_TabletTracking        : Qt.WidgetAttribute = ... # 0x81
        WA_ContentsMarginsRespectsSafeArea: Qt.WidgetAttribute = ... # 0x82
        WA_StyleSheetTarget      : Qt.WidgetAttribute = ... # 0x83
        WA_AttributeCount        : Qt.WidgetAttribute = ... # 0x84

    class WindowFlags(object): ...

    class WindowFrameSection(Shiboken.Enum):
        NoSection                : Qt.WindowFrameSection = ... # 0x0
        LeftSection              : Qt.WindowFrameSection = ... # 0x1
        TopLeftSection           : Qt.WindowFrameSection = ... # 0x2
        TopSection               : Qt.WindowFrameSection = ... # 0x3
        TopRightSection          : Qt.WindowFrameSection = ... # 0x4
        RightSection             : Qt.WindowFrameSection = ... # 0x5
        BottomRightSection       : Qt.WindowFrameSection = ... # 0x6
        BottomSection            : Qt.WindowFrameSection = ... # 0x7
        BottomLeftSection        : Qt.WindowFrameSection = ... # 0x8
        TitleBarArea             : Qt.WindowFrameSection = ... # 0x9

    class WindowModality(Shiboken.Enum):
        NonModal                 : Qt.WindowModality = ... # 0x0
        WindowModal              : Qt.WindowModality = ... # 0x1
        ApplicationModal         : Qt.WindowModality = ... # 0x2

    class WindowState(Shiboken.Enum):
        WindowNoState            : Qt.WindowState = ... # 0x0
        WindowMinimized          : Qt.WindowState = ... # 0x1
        WindowMaximized          : Qt.WindowState = ... # 0x2
        WindowFullScreen         : Qt.WindowState = ... # 0x4
        WindowActive             : Qt.WindowState = ... # 0x8

    class WindowStates(object): ...

    class WindowType(Shiboken.Enum):
        Widget                   : Qt.WindowType = ... # 0x0
        Window                   : Qt.WindowType = ... # 0x1
        Dialog                   : Qt.WindowType = ... # 0x3
        Sheet                    : Qt.WindowType = ... # 0x5
        Drawer                   : Qt.WindowType = ... # 0x7
        Popup                    : Qt.WindowType = ... # 0x9
        Tool                     : Qt.WindowType = ... # 0xb
        ToolTip                  : Qt.WindowType = ... # 0xd
        SplashScreen             : Qt.WindowType = ... # 0xf
        Desktop                  : Qt.WindowType = ... # 0x11
        SubWindow                : Qt.WindowType = ... # 0x12
        ForeignWindow            : Qt.WindowType = ... # 0x21
        CoverWindow              : Qt.WindowType = ... # 0x41
        WindowType_Mask          : Qt.WindowType = ... # 0xff
        MSWindowsFixedSizeDialogHint: Qt.WindowType = ... # 0x100
        MSWindowsOwnDC           : Qt.WindowType = ... # 0x200
        BypassWindowManagerHint  : Qt.WindowType = ... # 0x400
        X11BypassWindowManagerHint: Qt.WindowType = ... # 0x400
        FramelessWindowHint      : Qt.WindowType = ... # 0x800
        WindowTitleHint          : Qt.WindowType = ... # 0x1000
        WindowSystemMenuHint     : Qt.WindowType = ... # 0x2000
        WindowMinimizeButtonHint : Qt.WindowType = ... # 0x4000
        WindowMaximizeButtonHint : Qt.WindowType = ... # 0x8000
        WindowMinMaxButtonsHint  : Qt.WindowType = ... # 0xc000
        WindowContextHelpButtonHint: Qt.WindowType = ... # 0x10000
        WindowShadeButtonHint    : Qt.WindowType = ... # 0x20000
        WindowStaysOnTopHint     : Qt.WindowType = ... # 0x40000
        WindowTransparentForInput: Qt.WindowType = ... # 0x80000
        WindowOverridesSystemGestures: Qt.WindowType = ... # 0x100000
        WindowDoesNotAcceptFocus : Qt.WindowType = ... # 0x200000
        MaximizeUsingFullscreenGeometryHint: Qt.WindowType = ... # 0x400000
        CustomizeWindowHint      : Qt.WindowType = ... # 0x2000000
        WindowStaysOnBottomHint  : Qt.WindowType = ... # 0x4000000
        WindowCloseButtonHint    : Qt.WindowType = ... # 0x8000000
        MacWindowToolBarButtonHint: Qt.WindowType = ... # 0x10000000
        BypassGraphicsProxyWidget: Qt.WindowType = ... # 0x20000000
        NoDropShadowWindowHint   : Qt.WindowType = ... # 0x40000000
        WindowFullscreenButtonHint: Qt.WindowType = ... # -0x80000000


class QtMsgType(Shiboken.Enum):
    QtDebugMsg               : QtMsgType = ... # 0x0
    QtWarningMsg             : QtMsgType = ... # 0x1
    QtCriticalMsg            : QtMsgType = ... # 0x2
    QtSystemMsg              : QtMsgType = ... # 0x2
    QtFatalMsg               : QtMsgType = ... # 0x3
    QtInfoMsg                : QtMsgType = ... # 0x4


class Signal(object): ...

    def __init__(self, *types: type, name: typing.Optional[str] = ..., arguments: typing.Optional[str] = ...) -> None: ...


class SignalInstance(object): ...


class Slot(object): ...

    def __init__(self, *types: type, name: typing.Optional[str] = ..., result: typing.Optional[str] = ...) -> typing.Callable[..., typing.Optional[str]]: ...

def QEnum(arg__1: object) -> object: ...
def QFlag(arg__1: object) -> object: ...
def QT_TRANSLATE_NOOP(arg__1: object, arg__2: object) -> object: ...
def QT_TRANSLATE_NOOP3(arg__1: object, arg__2: object, arg__3: object) -> object: ...
def QT_TRANSLATE_NOOP_UTF8(arg__1: object) -> object: ...
def QT_TR_NOOP(arg__1: object) -> object: ...
def QT_TR_NOOP_UTF8(arg__1: object) -> object: ...
def SIGNAL(arg__1: bytes) -> str: ...
def SLOT(arg__1: bytes) -> str: ...
def __init_feature__() -> None: ...
def __moduleShutdown() -> None: ...
def qAbs(arg__1: float) -> float: ...
def qAcos(v: float) -> float: ...
def qAddPostRoutine(arg__1: object) -> None: ...
def qAsin(v: float) -> float: ...
def qAtan(v: float) -> float: ...
def qAtan2(y: float, x: float) -> float: ...
def qChecksum(s: bytes, len: int) -> int: ...
@typing.overload
def qCompress(data: PySide2.QtCore.QByteArray, compressionLevel: int = ...) -> PySide2.QtCore.QByteArray: ...
@typing.overload
def qCompress(data: bytes, nbytes: int, compressionLevel: int = ...) -> PySide2.QtCore.QByteArray: ...
def qCritical(arg__1: bytes) -> None: ...
def qDebug(arg__1: bytes) -> None: ...
def qExp(v: float) -> float: ...
def qFabs(v: float) -> float: ...
def qFastCos(x: float) -> float: ...
def qFastSin(x: float) -> float: ...
def qFatal(arg__1: bytes) -> None: ...
def qFuzzyCompare(p1: float, p2: float) -> bool: ...
def qFuzzyIsNull(d: float) -> bool: ...
def qInstallMessageHandler(arg__1: object) -> object: ...
def qIsFinite(d: float) -> bool: ...
def qIsInf(d: float) -> bool: ...
def qIsNaN(d: float) -> bool: ...
def qIsNull(d: float) -> bool: ...
def qRegisterResourceData(arg__1: int, arg__2: bytes, arg__3: bytes, arg__4: bytes) -> bool: ...
def qTan(v: float) -> float: ...
@typing.overload
def qUncompress(data: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...
@typing.overload
def qUncompress(data: bytes, nbytes: int) -> PySide2.QtCore.QByteArray: ...
def qUnregisterResourceData(arg__1: int, arg__2: bytes, arg__3: bytes, arg__4: bytes) -> bool: ...
def qVersion() -> bytes: ...
def qWarning(arg__1: bytes) -> None: ...
def qrand() -> int: ...
def qsrand(seed: int) -> None: ...
def qtTrId(id: bytes, n: int = ...) -> str: ...

# eof
