#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtGui, except for defaults which are replaced by "...".
"""

# Module PySide2.QtGui
import PySide2
try:
    import typing
except ImportError:
    from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

from shiboken2 import Shiboken

import PySide2.QtCore
import PySide2.QtGui


class QAbstractOpenGLFunctions(Shiboken.Object):

    def __init__(self) -> None: ...


class QAbstractTextDocumentLayout(PySide2.QtCore.QObject):

    class PaintContext(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, PaintContext: PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext) -> None: ...


    class Selection(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, Selection: PySide2.QtGui.QAbstractTextDocumentLayout.Selection) -> None: ...


    def __init__(self, doc: PySide2.QtGui.QTextDocument) -> None: ...


class QAccessible(Shiboken.Object):
    SoundPlayed              : QAccessible.Event = ... # 0x1
    Alert                    : QAccessible.Event = ... # 0x2
    ForegroundChanged        : QAccessible.Event = ... # 0x3
    MenuStart                : QAccessible.Event = ... # 0x4
    MenuEnd                  : QAccessible.Event = ... # 0x5
    PopupMenuStart           : QAccessible.Event = ... # 0x6
    PopupMenuEnd             : QAccessible.Event = ... # 0x7
    ContextHelpStart         : QAccessible.Event = ... # 0xc
    ContextHelpEnd           : QAccessible.Event = ... # 0xd
    DragDropStart            : QAccessible.Event = ... # 0xe
    DragDropEnd              : QAccessible.Event = ... # 0xf
    DialogStart              : QAccessible.Event = ... # 0x10
    DialogEnd                : QAccessible.Event = ... # 0x11
    ScrollingStart           : QAccessible.Event = ... # 0x12
    ScrollingEnd             : QAccessible.Event = ... # 0x13
    MenuCommand              : QAccessible.Event = ... # 0x18
    ActionChanged            : QAccessible.Event = ... # 0x101
    ActiveDescendantChanged  : QAccessible.Event = ... # 0x102
    AttributeChanged         : QAccessible.Event = ... # 0x103
    DocumentContentChanged   : QAccessible.Event = ... # 0x104
    DocumentLoadComplete     : QAccessible.Event = ... # 0x105
    DocumentLoadStopped      : QAccessible.Event = ... # 0x106
    DocumentReload           : QAccessible.Event = ... # 0x107
    HyperlinkEndIndexChanged : QAccessible.Event = ... # 0x108
    HyperlinkNumberOfAnchorsChanged: QAccessible.Event = ... # 0x109
    HyperlinkSelectedLinkChanged: QAccessible.Event = ... # 0x10a
    HypertextLinkActivated   : QAccessible.Event = ... # 0x10b
    HypertextLinkSelected    : QAccessible.Event = ... # 0x10c
    HyperlinkStartIndexChanged: QAccessible.Event = ... # 0x10d
    HypertextChanged         : QAccessible.Event = ... # 0x10e
    HypertextNLinksChanged   : QAccessible.Event = ... # 0x10f
    ObjectAttributeChanged   : QAccessible.Event = ... # 0x110
    PageChanged              : QAccessible.Event = ... # 0x111
    SectionChanged           : QAccessible.Event = ... # 0x112
    TableCaptionChanged      : QAccessible.Event = ... # 0x113
    TableColumnDescriptionChanged: QAccessible.Event = ... # 0x114
    TableColumnHeaderChanged : QAccessible.Event = ... # 0x115
    TableModelChanged        : QAccessible.Event = ... # 0x116
    TableRowDescriptionChanged: QAccessible.Event = ... # 0x117
    TableRowHeaderChanged    : QAccessible.Event = ... # 0x118
    TableSummaryChanged      : QAccessible.Event = ... # 0x119
    TextAttributeChanged     : QAccessible.Event = ... # 0x11a
    TextCaretMoved           : QAccessible.Event = ... # 0x11b
    TextColumnChanged        : QAccessible.Event = ... # 0x11d
    TextInserted             : QAccessible.Event = ... # 0x11e
    TextRemoved              : QAccessible.Event = ... # 0x11f
    TextUpdated              : QAccessible.Event = ... # 0x120
    TextSelectionChanged     : QAccessible.Event = ... # 0x121
    VisibleDataChanged       : QAccessible.Event = ... # 0x122
    ObjectCreated            : QAccessible.Event = ... # 0x8000
    ObjectDestroyed          : QAccessible.Event = ... # 0x8001
    ObjectShow               : QAccessible.Event = ... # 0x8002
    ObjectHide               : QAccessible.Event = ... # 0x8003
    ObjectReorder            : QAccessible.Event = ... # 0x8004
    Focus                    : QAccessible.Event = ... # 0x8005
    Selection                : QAccessible.Event = ... # 0x8006
    SelectionAdd             : QAccessible.Event = ... # 0x8007
    SelectionRemove          : QAccessible.Event = ... # 0x8008
    SelectionWithin          : QAccessible.Event = ... # 0x8009
    StateChanged             : QAccessible.Event = ... # 0x800a
    LocationChanged          : QAccessible.Event = ... # 0x800b
    NameChanged              : QAccessible.Event = ... # 0x800c
    DescriptionChanged       : QAccessible.Event = ... # 0x800d
    ValueChanged             : QAccessible.Event = ... # 0x800e
    ParentChanged            : QAccessible.Event = ... # 0x800f
    HelpChanged              : QAccessible.Event = ... # 0x80a0
    DefaultActionChanged     : QAccessible.Event = ... # 0x80b0
    AcceleratorChanged       : QAccessible.Event = ... # 0x80c0
    InvalidEvent             : QAccessible.Event = ... # 0x80c1
    TextInterface            : QAccessible.InterfaceType = ... # 0x0
    EditableTextInterface    : QAccessible.InterfaceType = ... # 0x1
    ValueInterface           : QAccessible.InterfaceType = ... # 0x2
    ActionInterface          : QAccessible.InterfaceType = ... # 0x3
    ImageInterface           : QAccessible.InterfaceType = ... # 0x4
    TableInterface           : QAccessible.InterfaceType = ... # 0x5
    TableCellInterface       : QAccessible.InterfaceType = ... # 0x6
    Label                    : QAccessible.RelationFlag = ... # 0x1
    Labelled                 : QAccessible.RelationFlag = ... # 0x2
    Controller               : QAccessible.RelationFlag = ... # 0x4
    Controlled               : QAccessible.RelationFlag = ... # 0x8
    AllRelations             : QAccessible.RelationFlag = ... # -0x1
    NoRole                   : QAccessible.Role = ... # 0x0
    TitleBar                 : QAccessible.Role = ... # 0x1
    MenuBar                  : QAccessible.Role = ... # 0x2
    ScrollBar                : QAccessible.Role = ... # 0x3
    Grip                     : QAccessible.Role = ... # 0x4
    Sound                    : QAccessible.Role = ... # 0x5
    Cursor                   : QAccessible.Role = ... # 0x6
    Caret                    : QAccessible.Role = ... # 0x7
    AlertMessage             : QAccessible.Role = ... # 0x8
    Window                   : QAccessible.Role = ... # 0x9
    Client                   : QAccessible.Role = ... # 0xa
    PopupMenu                : QAccessible.Role = ... # 0xb
    MenuItem                 : QAccessible.Role = ... # 0xc
    ToolTip                  : QAccessible.Role = ... # 0xd
    Application              : QAccessible.Role = ... # 0xe
    Document                 : QAccessible.Role = ... # 0xf
    Pane                     : QAccessible.Role = ... # 0x10
    Chart                    : QAccessible.Role = ... # 0x11
    Dialog                   : QAccessible.Role = ... # 0x12
    Border                   : QAccessible.Role = ... # 0x13
    Grouping                 : QAccessible.Role = ... # 0x14
    Separator                : QAccessible.Role = ... # 0x15
    ToolBar                  : QAccessible.Role = ... # 0x16
    StatusBar                : QAccessible.Role = ... # 0x17
    Table                    : QAccessible.Role = ... # 0x18
    ColumnHeader             : QAccessible.Role = ... # 0x19
    RowHeader                : QAccessible.Role = ... # 0x1a
    Column                   : QAccessible.Role = ... # 0x1b
    Row                      : QAccessible.Role = ... # 0x1c
    Cell                     : QAccessible.Role = ... # 0x1d
    Link                     : QAccessible.Role = ... # 0x1e
    HelpBalloon              : QAccessible.Role = ... # 0x1f
    Assistant                : QAccessible.Role = ... # 0x20
    List                     : QAccessible.Role = ... # 0x21
    ListItem                 : QAccessible.Role = ... # 0x22
    Tree                     : QAccessible.Role = ... # 0x23
    TreeItem                 : QAccessible.Role = ... # 0x24
    PageTab                  : QAccessible.Role = ... # 0x25
    PropertyPage             : QAccessible.Role = ... # 0x26
    Indicator                : QAccessible.Role = ... # 0x27
    Graphic                  : QAccessible.Role = ... # 0x28
    StaticText               : QAccessible.Role = ... # 0x29
    EditableText             : QAccessible.Role = ... # 0x2a
    Button                   : QAccessible.Role = ... # 0x2b
    PushButton               : QAccessible.Role = ... # 0x2b
    CheckBox                 : QAccessible.Role = ... # 0x2c
    RadioButton              : QAccessible.Role = ... # 0x2d
    ComboBox                 : QAccessible.Role = ... # 0x2e
    ProgressBar              : QAccessible.Role = ... # 0x30
    Dial                     : QAccessible.Role = ... # 0x31
    HotkeyField              : QAccessible.Role = ... # 0x32
    Slider                   : QAccessible.Role = ... # 0x33
    SpinBox                  : QAccessible.Role = ... # 0x34
    Canvas                   : QAccessible.Role = ... # 0x35
    Animation                : QAccessible.Role = ... # 0x36
    Equation                 : QAccessible.Role = ... # 0x37
    ButtonDropDown           : QAccessible.Role = ... # 0x38
    ButtonMenu               : QAccessible.Role = ... # 0x39
    ButtonDropGrid           : QAccessible.Role = ... # 0x3a
    Whitespace               : QAccessible.Role = ... # 0x3b
    PageTabList              : QAccessible.Role = ... # 0x3c
    Clock                    : QAccessible.Role = ... # 0x3d
    Splitter                 : QAccessible.Role = ... # 0x3e
    LayeredPane              : QAccessible.Role = ... # 0x80
    Terminal                 : QAccessible.Role = ... # 0x81
    Desktop                  : QAccessible.Role = ... # 0x82
    Paragraph                : QAccessible.Role = ... # 0x83
    WebDocument              : QAccessible.Role = ... # 0x84
    Section                  : QAccessible.Role = ... # 0x85
    Notification             : QAccessible.Role = ... # 0x86
    ColorChooser             : QAccessible.Role = ... # 0x404
    Footer                   : QAccessible.Role = ... # 0x40e
    Form                     : QAccessible.Role = ... # 0x410
    Heading                  : QAccessible.Role = ... # 0x414
    Note                     : QAccessible.Role = ... # 0x41b
    ComplementaryContent     : QAccessible.Role = ... # 0x42c
    UserRole                 : QAccessible.Role = ... # 0xffff
    Name                     : QAccessible.Text = ... # 0x0
    Description              : QAccessible.Text = ... # 0x1
    Value                    : QAccessible.Text = ... # 0x2
    Help                     : QAccessible.Text = ... # 0x3
    Accelerator              : QAccessible.Text = ... # 0x4
    DebugDescription         : QAccessible.Text = ... # 0x5
    UserText                 : QAccessible.Text = ... # 0xffff
    CharBoundary             : QAccessible.TextBoundaryType = ... # 0x0
    WordBoundary             : QAccessible.TextBoundaryType = ... # 0x1
    SentenceBoundary         : QAccessible.TextBoundaryType = ... # 0x2
    ParagraphBoundary        : QAccessible.TextBoundaryType = ... # 0x3
    LineBoundary             : QAccessible.TextBoundaryType = ... # 0x4
    NoBoundary               : QAccessible.TextBoundaryType = ... # 0x5

    class Event(Shiboken.Enum):
        SoundPlayed              : QAccessible.Event = ... # 0x1
        Alert                    : QAccessible.Event = ... # 0x2
        ForegroundChanged        : QAccessible.Event = ... # 0x3
        MenuStart                : QAccessible.Event = ... # 0x4
        MenuEnd                  : QAccessible.Event = ... # 0x5
        PopupMenuStart           : QAccessible.Event = ... # 0x6
        PopupMenuEnd             : QAccessible.Event = ... # 0x7
        ContextHelpStart         : QAccessible.Event = ... # 0xc
        ContextHelpEnd           : QAccessible.Event = ... # 0xd
        DragDropStart            : QAccessible.Event = ... # 0xe
        DragDropEnd              : QAccessible.Event = ... # 0xf
        DialogStart              : QAccessible.Event = ... # 0x10
        DialogEnd                : QAccessible.Event = ... # 0x11
        ScrollingStart           : QAccessible.Event = ... # 0x12
        ScrollingEnd             : QAccessible.Event = ... # 0x13
        MenuCommand              : QAccessible.Event = ... # 0x18
        ActionChanged            : QAccessible.Event = ... # 0x101
        ActiveDescendantChanged  : QAccessible.Event = ... # 0x102
        AttributeChanged         : QAccessible.Event = ... # 0x103
        DocumentContentChanged   : QAccessible.Event = ... # 0x104
        DocumentLoadComplete     : QAccessible.Event = ... # 0x105
        DocumentLoadStopped      : QAccessible.Event = ... # 0x106
        DocumentReload           : QAccessible.Event = ... # 0x107
        HyperlinkEndIndexChanged : QAccessible.Event = ... # 0x108
        HyperlinkNumberOfAnchorsChanged: QAccessible.Event = ... # 0x109
        HyperlinkSelectedLinkChanged: QAccessible.Event = ... # 0x10a
        HypertextLinkActivated   : QAccessible.Event = ... # 0x10b
        HypertextLinkSelected    : QAccessible.Event = ... # 0x10c
        HyperlinkStartIndexChanged: QAccessible.Event = ... # 0x10d
        HypertextChanged         : QAccessible.Event = ... # 0x10e
        HypertextNLinksChanged   : QAccessible.Event = ... # 0x10f
        ObjectAttributeChanged   : QAccessible.Event = ... # 0x110
        PageChanged              : QAccessible.Event = ... # 0x111
        SectionChanged           : QAccessible.Event = ... # 0x112
        TableCaptionChanged      : QAccessible.Event = ... # 0x113
        TableColumnDescriptionChanged: QAccessible.Event = ... # 0x114
        TableColumnHeaderChanged : QAccessible.Event = ... # 0x115
        TableModelChanged        : QAccessible.Event = ... # 0x116
        TableRowDescriptionChanged: QAccessible.Event = ... # 0x117
        TableRowHeaderChanged    : QAccessible.Event = ... # 0x118
        TableSummaryChanged      : QAccessible.Event = ... # 0x119
        TextAttributeChanged     : QAccessible.Event = ... # 0x11a
        TextCaretMoved           : QAccessible.Event = ... # 0x11b
        TextColumnChanged        : QAccessible.Event = ... # 0x11d
        TextInserted             : QAccessible.Event = ... # 0x11e
        TextRemoved              : QAccessible.Event = ... # 0x11f
        TextUpdated              : QAccessible.Event = ... # 0x120
        TextSelectionChanged     : QAccessible.Event = ... # 0x121
        VisibleDataChanged       : QAccessible.Event = ... # 0x122
        ObjectCreated            : QAccessible.Event = ... # 0x8000
        ObjectDestroyed          : QAccessible.Event = ... # 0x8001
        ObjectShow               : QAccessible.Event = ... # 0x8002
        ObjectHide               : QAccessible.Event = ... # 0x8003
        ObjectReorder            : QAccessible.Event = ... # 0x8004
        Focus                    : QAccessible.Event = ... # 0x8005
        Selection                : QAccessible.Event = ... # 0x8006
        SelectionAdd             : QAccessible.Event = ... # 0x8007
        SelectionRemove          : QAccessible.Event = ... # 0x8008
        SelectionWithin          : QAccessible.Event = ... # 0x8009
        StateChanged             : QAccessible.Event = ... # 0x800a
        LocationChanged          : QAccessible.Event = ... # 0x800b
        NameChanged              : QAccessible.Event = ... # 0x800c
        DescriptionChanged       : QAccessible.Event = ... # 0x800d
        ValueChanged             : QAccessible.Event = ... # 0x800e
        ParentChanged            : QAccessible.Event = ... # 0x800f
        HelpChanged              : QAccessible.Event = ... # 0x80a0
        DefaultActionChanged     : QAccessible.Event = ... # 0x80b0
        AcceleratorChanged       : QAccessible.Event = ... # 0x80c0
        InvalidEvent             : QAccessible.Event = ... # 0x80c1

    class InterfaceType(Shiboken.Enum):
        TextInterface            : QAccessible.InterfaceType = ... # 0x0
        EditableTextInterface    : QAccessible.InterfaceType = ... # 0x1
        ValueInterface           : QAccessible.InterfaceType = ... # 0x2
        ActionInterface          : QAccessible.InterfaceType = ... # 0x3
        ImageInterface           : QAccessible.InterfaceType = ... # 0x4
        TableInterface           : QAccessible.InterfaceType = ... # 0x5
        TableCellInterface       : QAccessible.InterfaceType = ... # 0x6

    class Relation(object): ...

    class RelationFlag(Shiboken.Enum):
        Label                    : QAccessible.RelationFlag = ... # 0x1
        Labelled                 : QAccessible.RelationFlag = ... # 0x2
        Controller               : QAccessible.RelationFlag = ... # 0x4
        Controlled               : QAccessible.RelationFlag = ... # 0x8
        AllRelations             : QAccessible.RelationFlag = ... # -0x1

    class Role(Shiboken.Enum):
        NoRole                   : QAccessible.Role = ... # 0x0
        TitleBar                 : QAccessible.Role = ... # 0x1
        MenuBar                  : QAccessible.Role = ... # 0x2
        ScrollBar                : QAccessible.Role = ... # 0x3
        Grip                     : QAccessible.Role = ... # 0x4
        Sound                    : QAccessible.Role = ... # 0x5
        Cursor                   : QAccessible.Role = ... # 0x6
        Caret                    : QAccessible.Role = ... # 0x7
        AlertMessage             : QAccessible.Role = ... # 0x8
        Window                   : QAccessible.Role = ... # 0x9
        Client                   : QAccessible.Role = ... # 0xa
        PopupMenu                : QAccessible.Role = ... # 0xb
        MenuItem                 : QAccessible.Role = ... # 0xc
        ToolTip                  : QAccessible.Role = ... # 0xd
        Application              : QAccessible.Role = ... # 0xe
        Document                 : QAccessible.Role = ... # 0xf
        Pane                     : QAccessible.Role = ... # 0x10
        Chart                    : QAccessible.Role = ... # 0x11
        Dialog                   : QAccessible.Role = ... # 0x12
        Border                   : QAccessible.Role = ... # 0x13
        Grouping                 : QAccessible.Role = ... # 0x14
        Separator                : QAccessible.Role = ... # 0x15
        ToolBar                  : QAccessible.Role = ... # 0x16
        StatusBar                : QAccessible.Role = ... # 0x17
        Table                    : QAccessible.Role = ... # 0x18
        ColumnHeader             : QAccessible.Role = ... # 0x19
        RowHeader                : QAccessible.Role = ... # 0x1a
        Column                   : QAccessible.Role = ... # 0x1b
        Row                      : QAccessible.Role = ... # 0x1c
        Cell                     : QAccessible.Role = ... # 0x1d
        Link                     : QAccessible.Role = ... # 0x1e
        HelpBalloon              : QAccessible.Role = ... # 0x1f
        Assistant                : QAccessible.Role = ... # 0x20
        List                     : QAccessible.Role = ... # 0x21
        ListItem                 : QAccessible.Role = ... # 0x22
        Tree                     : QAccessible.Role = ... # 0x23
        TreeItem                 : QAccessible.Role = ... # 0x24
        PageTab                  : QAccessible.Role = ... # 0x25
        PropertyPage             : QAccessible.Role = ... # 0x26
        Indicator                : QAccessible.Role = ... # 0x27
        Graphic                  : QAccessible.Role = ... # 0x28
        StaticText               : QAccessible.Role = ... # 0x29
        EditableText             : QAccessible.Role = ... # 0x2a
        Button                   : QAccessible.Role = ... # 0x2b
        PushButton               : QAccessible.Role = ... # 0x2b
        CheckBox                 : QAccessible.Role = ... # 0x2c
        RadioButton              : QAccessible.Role = ... # 0x2d
        ComboBox                 : QAccessible.Role = ... # 0x2e
        ProgressBar              : QAccessible.Role = ... # 0x30
        Dial                     : QAccessible.Role = ... # 0x31
        HotkeyField              : QAccessible.Role = ... # 0x32
        Slider                   : QAccessible.Role = ... # 0x33
        SpinBox                  : QAccessible.Role = ... # 0x34
        Canvas                   : QAccessible.Role = ... # 0x35
        Animation                : QAccessible.Role = ... # 0x36
        Equation                 : QAccessible.Role = ... # 0x37
        ButtonDropDown           : QAccessible.Role = ... # 0x38
        ButtonMenu               : QAccessible.Role = ... # 0x39
        ButtonDropGrid           : QAccessible.Role = ... # 0x3a
        Whitespace               : QAccessible.Role = ... # 0x3b
        PageTabList              : QAccessible.Role = ... # 0x3c
        Clock                    : QAccessible.Role = ... # 0x3d
        Splitter                 : QAccessible.Role = ... # 0x3e
        LayeredPane              : QAccessible.Role = ... # 0x80
        Terminal                 : QAccessible.Role = ... # 0x81
        Desktop                  : QAccessible.Role = ... # 0x82
        Paragraph                : QAccessible.Role = ... # 0x83
        WebDocument              : QAccessible.Role = ... # 0x84
        Section                  : QAccessible.Role = ... # 0x85
        Notification             : QAccessible.Role = ... # 0x86
        ColorChooser             : QAccessible.Role = ... # 0x404
        Footer                   : QAccessible.Role = ... # 0x40e
        Form                     : QAccessible.Role = ... # 0x410
        Heading                  : QAccessible.Role = ... # 0x414
        Note                     : QAccessible.Role = ... # 0x41b
        ComplementaryContent     : QAccessible.Role = ... # 0x42c
        UserRole                 : QAccessible.Role = ... # 0xffff

    class State(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, State: PySide2.QtGui.QAccessible.State) -> None: ...


    class Text(Shiboken.Enum):
        Name                     : QAccessible.Text = ... # 0x0
        Description              : QAccessible.Text = ... # 0x1
        Value                    : QAccessible.Text = ... # 0x2
        Help                     : QAccessible.Text = ... # 0x3
        Accelerator              : QAccessible.Text = ... # 0x4
        DebugDescription         : QAccessible.Text = ... # 0x5
        UserText                 : QAccessible.Text = ... # 0xffff

    class TextBoundaryType(Shiboken.Enum):
        CharBoundary             : QAccessible.TextBoundaryType = ... # 0x0
        WordBoundary             : QAccessible.TextBoundaryType = ... # 0x1
        SentenceBoundary         : QAccessible.TextBoundaryType = ... # 0x2
        ParagraphBoundary        : QAccessible.TextBoundaryType = ... # 0x3
        LineBoundary             : QAccessible.TextBoundaryType = ... # 0x4
        NoBoundary               : QAccessible.TextBoundaryType = ... # 0x5


class QAccessibleEditableTextInterface(Shiboken.Object):

    def __init__(self) -> None: ...


class QAccessibleEvent(Shiboken.Object):

    @typing.overload
    def __init__(self, iface: PySide2.QtGui.QAccessibleInterface, typ: PySide2.QtGui.QAccessible.Event) -> None: ...
    @typing.overload
    def __init__(self, obj: PySide2.QtCore.QObject, typ: PySide2.QtGui.QAccessible.Event) -> None: ...


class QAccessibleInterface(Shiboken.Object):

    def __init__(self) -> None: ...


class QAccessibleObject(PySide2.QtGui.QAccessibleInterface):

    def __init__(self, object: PySide2.QtCore.QObject) -> None: ...


class QAccessibleStateChangeEvent(PySide2.QtGui.QAccessibleEvent):

    @typing.overload
    def __init__(self, iface: PySide2.QtGui.QAccessibleInterface, state: PySide2.QtGui.QAccessible.State) -> None: ...
    @typing.overload
    def __init__(self, obj: PySide2.QtCore.QObject, state: PySide2.QtGui.QAccessible.State) -> None: ...


class QAccessibleTableCellInterface(Shiboken.Object):

    def __init__(self) -> None: ...


class QAccessibleTableModelChangeEvent(PySide2.QtGui.QAccessibleEvent):
    ModelReset               : QAccessibleTableModelChangeEvent.ModelChangeType = ... # 0x0
    DataChanged              : QAccessibleTableModelChangeEvent.ModelChangeType = ... # 0x1
    RowsInserted             : QAccessibleTableModelChangeEvent.ModelChangeType = ... # 0x2
    ColumnsInserted          : QAccessibleTableModelChangeEvent.ModelChangeType = ... # 0x3
    RowsRemoved              : QAccessibleTableModelChangeEvent.ModelChangeType = ... # 0x4
    ColumnsRemoved           : QAccessibleTableModelChangeEvent.ModelChangeType = ... # 0x5

    class ModelChangeType(Shiboken.Enum):
        ModelReset               : QAccessibleTableModelChangeEvent.ModelChangeType = ... # 0x0
        DataChanged              : QAccessibleTableModelChangeEvent.ModelChangeType = ... # 0x1
        RowsInserted             : QAccessibleTableModelChangeEvent.ModelChangeType = ... # 0x2
        ColumnsInserted          : QAccessibleTableModelChangeEvent.ModelChangeType = ... # 0x3
        RowsRemoved              : QAccessibleTableModelChangeEvent.ModelChangeType = ... # 0x4
        ColumnsRemoved           : QAccessibleTableModelChangeEvent.ModelChangeType = ... # 0x5

    @typing.overload
    def __init__(self, iface: PySide2.QtGui.QAccessibleInterface, changeType: PySide2.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType) -> None: ...
    @typing.overload
    def __init__(self, obj: PySide2.QtCore.QObject, changeType: PySide2.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType) -> None: ...


class QAccessibleTextCursorEvent(PySide2.QtGui.QAccessibleEvent):

    @typing.overload
    def __init__(self, iface: PySide2.QtGui.QAccessibleInterface, cursorPos: int) -> None: ...
    @typing.overload
    def __init__(self, obj: PySide2.QtCore.QObject, cursorPos: int) -> None: ...


class QAccessibleTextInsertEvent(PySide2.QtGui.QAccessibleTextCursorEvent):

    @typing.overload
    def __init__(self, iface: PySide2.QtGui.QAccessibleInterface, position: int, text: str) -> None: ...
    @typing.overload
    def __init__(self, obj: PySide2.QtCore.QObject, position: int, text: str) -> None: ...


class QAccessibleTextInterface(Shiboken.Object):

    def __init__(self) -> None: ...


class QAccessibleTextRemoveEvent(PySide2.QtGui.QAccessibleTextCursorEvent):

    @typing.overload
    def __init__(self, iface: PySide2.QtGui.QAccessibleInterface, position: int, text: str) -> None: ...
    @typing.overload
    def __init__(self, obj: PySide2.QtCore.QObject, position: int, text: str) -> None: ...


class QAccessibleTextSelectionEvent(PySide2.QtGui.QAccessibleTextCursorEvent):

    @typing.overload
    def __init__(self, iface: PySide2.QtGui.QAccessibleInterface, start: int, end: int) -> None: ...
    @typing.overload
    def __init__(self, obj: PySide2.QtCore.QObject, start: int, end: int) -> None: ...


class QAccessibleTextUpdateEvent(PySide2.QtGui.QAccessibleTextCursorEvent):

    @typing.overload
    def __init__(self, iface: PySide2.QtGui.QAccessibleInterface, position: int, oldText: str, text: str) -> None: ...
    @typing.overload
    def __init__(self, obj: PySide2.QtCore.QObject, position: int, oldText: str, text: str) -> None: ...


class QAccessibleValueChangeEvent(PySide2.QtGui.QAccessibleEvent):

    @typing.overload
    def __init__(self, iface: PySide2.QtGui.QAccessibleInterface, val: typing.Any) -> None: ...
    @typing.overload
    def __init__(self, obj: PySide2.QtCore.QObject, val: typing.Any) -> None: ...


class QAccessibleValueInterface(Shiboken.Object):

    def __init__(self) -> None: ...


class QActionEvent(PySide2.QtCore.QEvent): ...


class QBackingStore(Shiboken.Object):

    def __init__(self, window: PySide2.QtGui.QWindow) -> None: ...


class QBitmap(PySide2.QtGui.QPixmap):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QPixmap) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, format: typing.Optional[bytes] = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QBitmap) -> None: ...
    @typing.overload
    def __init__(self, w: int, h: int) -> None: ...


class QBrush(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, brush: PySide2.QtGui.QBrush) -> None: ...
    @typing.overload
    def __init__(self, bs: PySide2.QtCore.Qt.BrushStyle) -> None: ...
    @typing.overload
    def __init__(self, color: PySide2.QtCore.Qt.GlobalColor, bs: PySide2.QtCore.Qt.BrushStyle = ...) -> None: ...
    @typing.overload
    def __init__(self, color: PySide2.QtCore.Qt.GlobalColor, pixmap: PySide2.QtGui.QPixmap) -> None: ...
    @typing.overload
    def __init__(self, color: PySide2.QtGui.QColor, bs: PySide2.QtCore.Qt.BrushStyle = ...) -> None: ...
    @typing.overload
    def __init__(self, color: PySide2.QtGui.QColor, pixmap: PySide2.QtGui.QPixmap) -> None: ...
    @typing.overload
    def __init__(self, gradient: PySide2.QtGui.QGradient) -> None: ...
    @typing.overload
    def __init__(self, image: PySide2.QtGui.QImage) -> None: ...
    @typing.overload
    def __init__(self, pixmap: PySide2.QtGui.QPixmap) -> None: ...


class QClipboard(PySide2.QtCore.QObject):
    Clipboard                : QClipboard.Mode = ... # 0x0
    Selection                : QClipboard.Mode = ... # 0x1
    FindBuffer               : QClipboard.Mode = ... # 0x2
    LastMode                 : QClipboard.Mode = ... # 0x2

    class Mode(Shiboken.Enum):
        Clipboard                : QClipboard.Mode = ... # 0x0
        Selection                : QClipboard.Mode = ... # 0x1
        FindBuffer               : QClipboard.Mode = ... # 0x2
        LastMode                 : QClipboard.Mode = ... # 0x2


class QCloseEvent(PySide2.QtCore.QEvent):

    def __init__(self) -> None: ...


class QColor(Shiboken.Object):
    HexRgb                   : QColor.NameFormat = ... # 0x0
    HexArgb                  : QColor.NameFormat = ... # 0x1
    Invalid                  : QColor.Spec = ... # 0x0
    Rgb                      : QColor.Spec = ... # 0x1
    Hsv                      : QColor.Spec = ... # 0x2
    Cmyk                     : QColor.Spec = ... # 0x3
    Hsl                      : QColor.Spec = ... # 0x4
    ExtendedRgb              : QColor.Spec = ... # 0x5

    class NameFormat(Shiboken.Enum):
        HexRgb                   : QColor.NameFormat = ... # 0x0
        HexArgb                  : QColor.NameFormat = ... # 0x1

    class Spec(Shiboken.Enum):
        Invalid                  : QColor.Spec = ... # 0x0
        Rgb                      : QColor.Spec = ... # 0x1
        Hsv                      : QColor.Spec = ... # 0x2
        Cmyk                     : QColor.Spec = ... # 0x3
        Hsl                      : QColor.Spec = ... # 0x4
        ExtendedRgb              : QColor.Spec = ... # 0x5

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: typing.Any) -> None: ...
    @typing.overload
    def __init__(self, color: PySide2.QtCore.Qt.GlobalColor) -> None: ...
    @typing.overload
    def __init__(self, color: PySide2.QtGui.QColor) -> None: ...
    @typing.overload
    def __init__(self, name: str) -> None: ...
    @typing.overload
    def __init__(self, r: int, g: int, b: int, a: int = ...) -> None: ...
    @typing.overload
    def __init__(self, rgb: int) -> None: ...
    @typing.overload
    def __init__(self, spec: PySide2.QtGui.QColor.Spec, a1: int, a2: int, a3: int, a4: int, a5: int = ...) -> None: ...


class QColorConstants(Shiboken.Object):

    class Svg(Shiboken.Object): ...


class QColorSpace(Shiboken.Object):
    SRgb                     : QColorSpace.NamedColorSpace = ... # 0x1
    SRgbLinear               : QColorSpace.NamedColorSpace = ... # 0x2
    AdobeRgb                 : QColorSpace.NamedColorSpace = ... # 0x3
    DisplayP3                : QColorSpace.NamedColorSpace = ... # 0x4
    ProPhotoRgb              : QColorSpace.NamedColorSpace = ... # 0x5

    class NamedColorSpace(Shiboken.Enum):
        SRgb                     : QColorSpace.NamedColorSpace = ... # 0x1
        SRgbLinear               : QColorSpace.NamedColorSpace = ... # 0x2
        AdobeRgb                 : QColorSpace.NamedColorSpace = ... # 0x3
        DisplayP3                : QColorSpace.NamedColorSpace = ... # 0x4
        ProPhotoRgb              : QColorSpace.NamedColorSpace = ... # 0x5

    class Primaries(Shiboken.Enum):
        Custom                   : QColorSpace.Primaries = ... # 0x0
        SRgb                     : QColorSpace.Primaries = ... # 0x1
        AdobeRgb                 : QColorSpace.Primaries = ... # 0x2
        DciP3D65                 : QColorSpace.Primaries = ... # 0x3
        ProPhotoRgb              : QColorSpace.Primaries = ... # 0x4

    class TransferFunction(Shiboken.Enum):
        Custom                   : QColorSpace.TransferFunction = ... # 0x0
        Linear                   : QColorSpace.TransferFunction = ... # 0x1
        Gamma                    : QColorSpace.TransferFunction = ... # 0x2
        SRgb                     : QColorSpace.TransferFunction = ... # 0x3
        ProPhotoRgb              : QColorSpace.TransferFunction = ... # 0x4

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, colorSpace: PySide2.QtGui.QColorSpace) -> None: ...
    @typing.overload
    def __init__(self, namedColorSpace: PySide2.QtGui.QColorSpace.NamedColorSpace) -> None: ...
    @typing.overload
    def __init__(self, primaries: PySide2.QtGui.QColorSpace.Primaries, gamma: float) -> None: ...
    @typing.overload
    def __init__(self, primaries: PySide2.QtGui.QColorSpace.Primaries, transferFunction: PySide2.QtGui.QColorSpace.TransferFunction, gamma: float = ...) -> None: ...
    @typing.overload
    def __init__(self, whitePoint: PySide2.QtCore.QPointF, redPoint: PySide2.QtCore.QPointF, greenPoint: PySide2.QtCore.QPointF, bluePoint: PySide2.QtCore.QPointF, transferFunction: PySide2.QtGui.QColorSpace.TransferFunction, gamma: float = ...) -> None: ...


class QConicalGradient(PySide2.QtGui.QGradient):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QConicalGradient: PySide2.QtGui.QConicalGradient) -> None: ...
    @typing.overload
    def __init__(self, center: PySide2.QtCore.QPointF, startAngle: float) -> None: ...
    @typing.overload
    def __init__(self, cx: float, cy: float, startAngle: float) -> None: ...


class QContextMenuEvent(PySide2.QtGui.QInputEvent):
    Mouse                    : QContextMenuEvent.Reason = ... # 0x0
    Keyboard                 : QContextMenuEvent.Reason = ... # 0x1
    Other                    : QContextMenuEvent.Reason = ... # 0x2

    class Reason(Shiboken.Enum):
        Mouse                    : QContextMenuEvent.Reason = ... # 0x0
        Keyboard                 : QContextMenuEvent.Reason = ... # 0x1
        Other                    : QContextMenuEvent.Reason = ... # 0x2

    @typing.overload
    def __init__(self, reason: PySide2.QtGui.QContextMenuEvent.Reason, pos: PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, reason: PySide2.QtGui.QContextMenuEvent.Reason, pos: PySide2.QtCore.QPoint, globalPos: PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, reason: PySide2.QtGui.QContextMenuEvent.Reason, pos: PySide2.QtCore.QPoint, globalPos: PySide2.QtCore.QPoint, modifiers: PySide2.QtCore.Qt.KeyboardModifiers) -> None: ...


class QCursor(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, bitmap: PySide2.QtGui.QBitmap, mask: PySide2.QtGui.QBitmap, hotX: int = ..., hotY: int = ...) -> None: ...
    @typing.overload
    def __init__(self, cursor: PySide2.QtGui.QCursor) -> None: ...
    @typing.overload
    def __init__(self, pixmap: PySide2.QtGui.QPixmap, hotX: int = ..., hotY: int = ...) -> None: ...
    @typing.overload
    def __init__(self, shape: PySide2.QtCore.Qt.CursorShape) -> None: ...


class QDesktopServices(Shiboken.Object):

    def __init__(self) -> None: ...


class QDoubleValidator(PySide2.QtGui.QValidator):
    StandardNotation         : QDoubleValidator.Notation = ... # 0x0
    ScientificNotation       : QDoubleValidator.Notation = ... # 0x1

    class Notation(Shiboken.Enum):
        StandardNotation         : QDoubleValidator.Notation = ... # 0x0
        ScientificNotation       : QDoubleValidator.Notation = ... # 0x1

    @typing.overload
    def __init__(self, bottom: float, top: float, decimals: int, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QDrag(PySide2.QtCore.QObject):

    def __init__(self, dragSource: PySide2.QtCore.QObject) -> None: ...


class QDragEnterEvent(PySide2.QtGui.QDragMoveEvent):

    def __init__(self, pos: PySide2.QtCore.QPoint, actions: PySide2.QtCore.Qt.DropActions, data: PySide2.QtCore.QMimeData, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers) -> None: ...


class QDragLeaveEvent(PySide2.QtCore.QEvent):

    def __init__(self) -> None: ...


class QDragMoveEvent(PySide2.QtGui.QDropEvent):

    def __init__(self, pos: PySide2.QtCore.QPoint, actions: PySide2.QtCore.Qt.DropActions, data: PySide2.QtCore.QMimeData, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers, type: PySide2.QtCore.QEvent.Type = ...) -> None: ...


class QDropEvent(PySide2.QtCore.QEvent):

    def __init__(self, pos: PySide2.QtCore.QPointF, actions: PySide2.QtCore.Qt.DropActions, data: PySide2.QtCore.QMimeData, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers, type: PySide2.QtCore.QEvent.Type = ...) -> None: ...


class QEnterEvent(PySide2.QtCore.QEvent):

    def __init__(self, localPos: PySide2.QtCore.QPointF, windowPos: PySide2.QtCore.QPointF, screenPos: PySide2.QtCore.QPointF) -> None: ...


class QExposeEvent(PySide2.QtCore.QEvent):

    def __init__(self, rgn: PySide2.QtGui.QRegion) -> None: ...


class QFileOpenEvent(PySide2.QtCore.QEvent):

    @typing.overload
    def __init__(self, file: str) -> None: ...
    @typing.overload
    def __init__(self, url: PySide2.QtCore.QUrl) -> None: ...


class QFocusEvent(PySide2.QtCore.QEvent):

    def __init__(self, type: PySide2.QtCore.QEvent.Type, reason: PySide2.QtCore.Qt.FocusReason = ...) -> None: ...


class QFont(Shiboken.Object):
    MixedCase                : QFont.Capitalization = ... # 0x0
    AllUppercase             : QFont.Capitalization = ... # 0x1
    AllLowercase             : QFont.Capitalization = ... # 0x2
    SmallCaps                : QFont.Capitalization = ... # 0x3
    Capitalize               : QFont.Capitalization = ... # 0x4
    PreferDefaultHinting     : QFont.HintingPreference = ... # 0x0
    PreferNoHinting          : QFont.HintingPreference = ... # 0x1
    PreferVerticalHinting    : QFont.HintingPreference = ... # 0x2
    PreferFullHinting        : QFont.HintingPreference = ... # 0x3
    PercentageSpacing        : QFont.SpacingType = ... # 0x0
    AbsoluteSpacing          : QFont.SpacingType = ... # 0x1
    AnyStretch               : QFont.Stretch = ... # 0x0
    UltraCondensed           : QFont.Stretch = ... # 0x32
    ExtraCondensed           : QFont.Stretch = ... # 0x3e
    Condensed                : QFont.Stretch = ... # 0x4b
    SemiCondensed            : QFont.Stretch = ... # 0x57
    Unstretched              : QFont.Stretch = ... # 0x64
    SemiExpanded             : QFont.Stretch = ... # 0x70
    Expanded                 : QFont.Stretch = ... # 0x7d
    ExtraExpanded            : QFont.Stretch = ... # 0x96
    UltraExpanded            : QFont.Stretch = ... # 0xc8
    StyleNormal              : QFont.Style = ... # 0x0
    StyleItalic              : QFont.Style = ... # 0x1
    StyleOblique             : QFont.Style = ... # 0x2
    Helvetica                : QFont.StyleHint = ... # 0x0
    SansSerif                : QFont.StyleHint = ... # 0x0
    Serif                    : QFont.StyleHint = ... # 0x1
    Times                    : QFont.StyleHint = ... # 0x1
    Courier                  : QFont.StyleHint = ... # 0x2
    TypeWriter               : QFont.StyleHint = ... # 0x2
    Decorative               : QFont.StyleHint = ... # 0x3
    OldEnglish               : QFont.StyleHint = ... # 0x3
    System                   : QFont.StyleHint = ... # 0x4
    AnyStyle                 : QFont.StyleHint = ... # 0x5
    Cursive                  : QFont.StyleHint = ... # 0x6
    Monospace                : QFont.StyleHint = ... # 0x7
    Fantasy                  : QFont.StyleHint = ... # 0x8
    PreferDefault            : QFont.StyleStrategy = ... # 0x1
    PreferBitmap             : QFont.StyleStrategy = ... # 0x2
    PreferDevice             : QFont.StyleStrategy = ... # 0x4
    PreferOutline            : QFont.StyleStrategy = ... # 0x8
    ForceOutline             : QFont.StyleStrategy = ... # 0x10
    PreferMatch              : QFont.StyleStrategy = ... # 0x20
    PreferQuality            : QFont.StyleStrategy = ... # 0x40
    PreferAntialias          : QFont.StyleStrategy = ... # 0x80
    NoAntialias              : QFont.StyleStrategy = ... # 0x100
    OpenGLCompatible         : QFont.StyleStrategy = ... # 0x200
    ForceIntegerMetrics      : QFont.StyleStrategy = ... # 0x400
    NoSubpixelAntialias      : QFont.StyleStrategy = ... # 0x800
    PreferNoShaping          : QFont.StyleStrategy = ... # 0x1000
    NoFontMerging            : QFont.StyleStrategy = ... # 0x8000
    Thin                     : QFont.Weight = ... # 0x0
    ExtraLight               : QFont.Weight = ... # 0xc
    Light                    : QFont.Weight = ... # 0x19
    Normal                   : QFont.Weight = ... # 0x32
    Medium                   : QFont.Weight = ... # 0x39
    DemiBold                 : QFont.Weight = ... # 0x3f
    Bold                     : QFont.Weight = ... # 0x4b
    ExtraBold                : QFont.Weight = ... # 0x51
    Black                    : QFont.Weight = ... # 0x57

    class Capitalization(Shiboken.Enum):
        MixedCase                : QFont.Capitalization = ... # 0x0
        AllUppercase             : QFont.Capitalization = ... # 0x1
        AllLowercase             : QFont.Capitalization = ... # 0x2
        SmallCaps                : QFont.Capitalization = ... # 0x3
        Capitalize               : QFont.Capitalization = ... # 0x4

    class HintingPreference(Shiboken.Enum):
        PreferDefaultHinting     : QFont.HintingPreference = ... # 0x0
        PreferNoHinting          : QFont.HintingPreference = ... # 0x1
        PreferVerticalHinting    : QFont.HintingPreference = ... # 0x2
        PreferFullHinting        : QFont.HintingPreference = ... # 0x3

    class SpacingType(Shiboken.Enum):
        PercentageSpacing        : QFont.SpacingType = ... # 0x0
        AbsoluteSpacing          : QFont.SpacingType = ... # 0x1

    class Stretch(Shiboken.Enum):
        AnyStretch               : QFont.Stretch = ... # 0x0
        UltraCondensed           : QFont.Stretch = ... # 0x32
        ExtraCondensed           : QFont.Stretch = ... # 0x3e
        Condensed                : QFont.Stretch = ... # 0x4b
        SemiCondensed            : QFont.Stretch = ... # 0x57
        Unstretched              : QFont.Stretch = ... # 0x64
        SemiExpanded             : QFont.Stretch = ... # 0x70
        Expanded                 : QFont.Stretch = ... # 0x7d
        ExtraExpanded            : QFont.Stretch = ... # 0x96
        UltraExpanded            : QFont.Stretch = ... # 0xc8

    class Style(Shiboken.Enum):
        StyleNormal              : QFont.Style = ... # 0x0
        StyleItalic              : QFont.Style = ... # 0x1
        StyleOblique             : QFont.Style = ... # 0x2

    class StyleHint(Shiboken.Enum):
        Helvetica                : QFont.StyleHint = ... # 0x0
        SansSerif                : QFont.StyleHint = ... # 0x0
        Serif                    : QFont.StyleHint = ... # 0x1
        Times                    : QFont.StyleHint = ... # 0x1
        Courier                  : QFont.StyleHint = ... # 0x2
        TypeWriter               : QFont.StyleHint = ... # 0x2
        Decorative               : QFont.StyleHint = ... # 0x3
        OldEnglish               : QFont.StyleHint = ... # 0x3
        System                   : QFont.StyleHint = ... # 0x4
        AnyStyle                 : QFont.StyleHint = ... # 0x5
        Cursive                  : QFont.StyleHint = ... # 0x6
        Monospace                : QFont.StyleHint = ... # 0x7
        Fantasy                  : QFont.StyleHint = ... # 0x8

    class StyleStrategy(Shiboken.Enum):
        PreferDefault            : QFont.StyleStrategy = ... # 0x1
        PreferBitmap             : QFont.StyleStrategy = ... # 0x2
        PreferDevice             : QFont.StyleStrategy = ... # 0x4
        PreferOutline            : QFont.StyleStrategy = ... # 0x8
        ForceOutline             : QFont.StyleStrategy = ... # 0x10
        PreferMatch              : QFont.StyleStrategy = ... # 0x20
        PreferQuality            : QFont.StyleStrategy = ... # 0x40
        PreferAntialias          : QFont.StyleStrategy = ... # 0x80
        NoAntialias              : QFont.StyleStrategy = ... # 0x100
        OpenGLCompatible         : QFont.StyleStrategy = ... # 0x200
        ForceIntegerMetrics      : QFont.StyleStrategy = ... # 0x400
        NoSubpixelAntialias      : QFont.StyleStrategy = ... # 0x800
        PreferNoShaping          : QFont.StyleStrategy = ... # 0x1000
        NoFontMerging            : QFont.StyleStrategy = ... # 0x8000

    class Weight(Shiboken.Enum):
        Thin                     : QFont.Weight = ... # 0x0
        ExtraLight               : QFont.Weight = ... # 0xc
        Light                    : QFont.Weight = ... # 0x19
        Normal                   : QFont.Weight = ... # 0x32
        Medium                   : QFont.Weight = ... # 0x39
        DemiBold                 : QFont.Weight = ... # 0x3f
        Bold                     : QFont.Weight = ... # 0x4b
        ExtraBold                : QFont.Weight = ... # 0x51
        Black                    : QFont.Weight = ... # 0x57

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, family: str, pointSize: int = ..., weight: int = ..., italic: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, font: PySide2.QtGui.QFont) -> None: ...
    @typing.overload
    def __init__(self, font: PySide2.QtGui.QFont, pd: PySide2.QtGui.QPaintDevice) -> None: ...


class QFontDatabase(Shiboken.Object):
    GeneralFont              : QFontDatabase.SystemFont = ... # 0x0
    FixedFont                : QFontDatabase.SystemFont = ... # 0x1
    TitleFont                : QFontDatabase.SystemFont = ... # 0x2
    SmallestReadableFont     : QFontDatabase.SystemFont = ... # 0x3
    Any                      : QFontDatabase.WritingSystem = ... # 0x0
    Latin                    : QFontDatabase.WritingSystem = ... # 0x1
    Greek                    : QFontDatabase.WritingSystem = ... # 0x2
    Cyrillic                 : QFontDatabase.WritingSystem = ... # 0x3
    Armenian                 : QFontDatabase.WritingSystem = ... # 0x4
    Hebrew                   : QFontDatabase.WritingSystem = ... # 0x5
    Arabic                   : QFontDatabase.WritingSystem = ... # 0x6
    Syriac                   : QFontDatabase.WritingSystem = ... # 0x7
    Thaana                   : QFontDatabase.WritingSystem = ... # 0x8
    Devanagari               : QFontDatabase.WritingSystem = ... # 0x9
    Bengali                  : QFontDatabase.WritingSystem = ... # 0xa
    Gurmukhi                 : QFontDatabase.WritingSystem = ... # 0xb
    Gujarati                 : QFontDatabase.WritingSystem = ... # 0xc
    Oriya                    : QFontDatabase.WritingSystem = ... # 0xd
    Tamil                    : QFontDatabase.WritingSystem = ... # 0xe
    Telugu                   : QFontDatabase.WritingSystem = ... # 0xf
    Kannada                  : QFontDatabase.WritingSystem = ... # 0x10
    Malayalam                : QFontDatabase.WritingSystem = ... # 0x11
    Sinhala                  : QFontDatabase.WritingSystem = ... # 0x12
    Thai                     : QFontDatabase.WritingSystem = ... # 0x13
    Lao                      : QFontDatabase.WritingSystem = ... # 0x14
    Tibetan                  : QFontDatabase.WritingSystem = ... # 0x15
    Myanmar                  : QFontDatabase.WritingSystem = ... # 0x16
    Georgian                 : QFontDatabase.WritingSystem = ... # 0x17
    Khmer                    : QFontDatabase.WritingSystem = ... # 0x18
    SimplifiedChinese        : QFontDatabase.WritingSystem = ... # 0x19
    TraditionalChinese       : QFontDatabase.WritingSystem = ... # 0x1a
    Japanese                 : QFontDatabase.WritingSystem = ... # 0x1b
    Korean                   : QFontDatabase.WritingSystem = ... # 0x1c
    Vietnamese               : QFontDatabase.WritingSystem = ... # 0x1d
    Other                    : QFontDatabase.WritingSystem = ... # 0x1e
    Symbol                   : QFontDatabase.WritingSystem = ... # 0x1e
    Ogham                    : QFontDatabase.WritingSystem = ... # 0x1f
    Runic                    : QFontDatabase.WritingSystem = ... # 0x20
    Nko                      : QFontDatabase.WritingSystem = ... # 0x21
    WritingSystemsCount      : QFontDatabase.WritingSystem = ... # 0x22

    class SystemFont(Shiboken.Enum):
        GeneralFont              : QFontDatabase.SystemFont = ... # 0x0
        FixedFont                : QFontDatabase.SystemFont = ... # 0x1
        TitleFont                : QFontDatabase.SystemFont = ... # 0x2
        SmallestReadableFont     : QFontDatabase.SystemFont = ... # 0x3

    class WritingSystem(Shiboken.Enum):
        Any                      : QFontDatabase.WritingSystem = ... # 0x0
        Latin                    : QFontDatabase.WritingSystem = ... # 0x1
        Greek                    : QFontDatabase.WritingSystem = ... # 0x2
        Cyrillic                 : QFontDatabase.WritingSystem = ... # 0x3
        Armenian                 : QFontDatabase.WritingSystem = ... # 0x4
        Hebrew                   : QFontDatabase.WritingSystem = ... # 0x5
        Arabic                   : QFontDatabase.WritingSystem = ... # 0x6
        Syriac                   : QFontDatabase.WritingSystem = ... # 0x7
        Thaana                   : QFontDatabase.WritingSystem = ... # 0x8
        Devanagari               : QFontDatabase.WritingSystem = ... # 0x9
        Bengali                  : QFontDatabase.WritingSystem = ... # 0xa
        Gurmukhi                 : QFontDatabase.WritingSystem = ... # 0xb
        Gujarati                 : QFontDatabase.WritingSystem = ... # 0xc
        Oriya                    : QFontDatabase.WritingSystem = ... # 0xd
        Tamil                    : QFontDatabase.WritingSystem = ... # 0xe
        Telugu                   : QFontDatabase.WritingSystem = ... # 0xf
        Kannada                  : QFontDatabase.WritingSystem = ... # 0x10
        Malayalam                : QFontDatabase.WritingSystem = ... # 0x11
        Sinhala                  : QFontDatabase.WritingSystem = ... # 0x12
        Thai                     : QFontDatabase.WritingSystem = ... # 0x13
        Lao                      : QFontDatabase.WritingSystem = ... # 0x14
        Tibetan                  : QFontDatabase.WritingSystem = ... # 0x15
        Myanmar                  : QFontDatabase.WritingSystem = ... # 0x16
        Georgian                 : QFontDatabase.WritingSystem = ... # 0x17
        Khmer                    : QFontDatabase.WritingSystem = ... # 0x18
        SimplifiedChinese        : QFontDatabase.WritingSystem = ... # 0x19
        TraditionalChinese       : QFontDatabase.WritingSystem = ... # 0x1a
        Japanese                 : QFontDatabase.WritingSystem = ... # 0x1b
        Korean                   : QFontDatabase.WritingSystem = ... # 0x1c
        Vietnamese               : QFontDatabase.WritingSystem = ... # 0x1d
        Other                    : QFontDatabase.WritingSystem = ... # 0x1e
        Symbol                   : QFontDatabase.WritingSystem = ... # 0x1e
        Ogham                    : QFontDatabase.WritingSystem = ... # 0x1f
        Runic                    : QFontDatabase.WritingSystem = ... # 0x20
        Nko                      : QFontDatabase.WritingSystem = ... # 0x21
        WritingSystemsCount      : QFontDatabase.WritingSystem = ... # 0x22

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QFontDatabase: PySide2.QtGui.QFontDatabase) -> None: ...


class QFontInfo(Shiboken.Object):

    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QFont) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QFontInfo) -> None: ...


class QFontMetrics(Shiboken.Object):

    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QFont) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QFontMetrics) -> None: ...
    @typing.overload
    def __init__(self, font: PySide2.QtGui.QFont, pd: PySide2.QtGui.QPaintDevice) -> None: ...


class QFontMetricsF(Shiboken.Object):

    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QFontMetrics) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QFontMetricsF) -> None: ...
    @typing.overload
    def __init__(self, font: PySide2.QtGui.QFont) -> None: ...
    @typing.overload
    def __init__(self, font: PySide2.QtGui.QFont, pd: PySide2.QtGui.QPaintDevice) -> None: ...


class QGradient(Shiboken.Object):
    LogicalMode              : QGradient.CoordinateMode = ... # 0x0
    StretchToDeviceMode      : QGradient.CoordinateMode = ... # 0x1
    ObjectBoundingMode       : QGradient.CoordinateMode = ... # 0x2
    ObjectMode               : QGradient.CoordinateMode = ... # 0x3
    ColorInterpolation       : QGradient.InterpolationMode = ... # 0x0
    ComponentInterpolation   : QGradient.InterpolationMode = ... # 0x1
    WarmFlame                : QGradient.Preset = ... # 0x1
    NightFade                : QGradient.Preset = ... # 0x2
    SpringWarmth             : QGradient.Preset = ... # 0x3
    JuicyPeach               : QGradient.Preset = ... # 0x4
    YoungPassion             : QGradient.Preset = ... # 0x5
    LadyLips                 : QGradient.Preset = ... # 0x6
    SunnyMorning             : QGradient.Preset = ... # 0x7
    RainyAshville            : QGradient.Preset = ... # 0x8
    FrozenDreams             : QGradient.Preset = ... # 0x9
    WinterNeva               : QGradient.Preset = ... # 0xa
    DustyGrass               : QGradient.Preset = ... # 0xb
    TemptingAzure            : QGradient.Preset = ... # 0xc
    HeavyRain                : QGradient.Preset = ... # 0xd
    AmyCrisp                 : QGradient.Preset = ... # 0xe
    MeanFruit                : QGradient.Preset = ... # 0xf
    DeepBlue                 : QGradient.Preset = ... # 0x10
    RipeMalinka              : QGradient.Preset = ... # 0x11
    CloudyKnoxville          : QGradient.Preset = ... # 0x12
    MalibuBeach              : QGradient.Preset = ... # 0x13
    NewLife                  : QGradient.Preset = ... # 0x14
    TrueSunset               : QGradient.Preset = ... # 0x15
    MorpheusDen              : QGradient.Preset = ... # 0x16
    RareWind                 : QGradient.Preset = ... # 0x17
    NearMoon                 : QGradient.Preset = ... # 0x18
    WildApple                : QGradient.Preset = ... # 0x19
    SaintPetersburg          : QGradient.Preset = ... # 0x1a
    PlumPlate                : QGradient.Preset = ... # 0x1c
    EverlastingSky           : QGradient.Preset = ... # 0x1d
    HappyFisher              : QGradient.Preset = ... # 0x1e
    Blessing                 : QGradient.Preset = ... # 0x1f
    SharpeyeEagle            : QGradient.Preset = ... # 0x20
    LadogaBottom             : QGradient.Preset = ... # 0x21
    LemonGate                : QGradient.Preset = ... # 0x22
    ItmeoBranding            : QGradient.Preset = ... # 0x23
    ZeusMiracle              : QGradient.Preset = ... # 0x24
    OldHat                   : QGradient.Preset = ... # 0x25
    StarWine                 : QGradient.Preset = ... # 0x26
    HappyAcid                : QGradient.Preset = ... # 0x29
    AwesomePine              : QGradient.Preset = ... # 0x2a
    NewYork                  : QGradient.Preset = ... # 0x2b
    ShyRainbow               : QGradient.Preset = ... # 0x2c
    MixedHopes               : QGradient.Preset = ... # 0x2e
    FlyHigh                  : QGradient.Preset = ... # 0x2f
    StrongBliss              : QGradient.Preset = ... # 0x30
    FreshMilk                : QGradient.Preset = ... # 0x31
    SnowAgain                : QGradient.Preset = ... # 0x32
    FebruaryInk              : QGradient.Preset = ... # 0x33
    KindSteel                : QGradient.Preset = ... # 0x34
    SoftGrass                : QGradient.Preset = ... # 0x35
    GrownEarly               : QGradient.Preset = ... # 0x36
    SharpBlues               : QGradient.Preset = ... # 0x37
    ShadyWater               : QGradient.Preset = ... # 0x38
    DirtyBeauty              : QGradient.Preset = ... # 0x39
    GreatWhale               : QGradient.Preset = ... # 0x3a
    TeenNotebook             : QGradient.Preset = ... # 0x3b
    PoliteRumors             : QGradient.Preset = ... # 0x3c
    SweetPeriod              : QGradient.Preset = ... # 0x3d
    WideMatrix               : QGradient.Preset = ... # 0x3e
    SoftCherish              : QGradient.Preset = ... # 0x3f
    RedSalvation             : QGradient.Preset = ... # 0x40
    BurningSpring            : QGradient.Preset = ... # 0x41
    NightParty               : QGradient.Preset = ... # 0x42
    SkyGlider                : QGradient.Preset = ... # 0x43
    HeavenPeach              : QGradient.Preset = ... # 0x44
    PurpleDivision           : QGradient.Preset = ... # 0x45
    AquaSplash               : QGradient.Preset = ... # 0x46
    SpikyNaga                : QGradient.Preset = ... # 0x48
    LoveKiss                 : QGradient.Preset = ... # 0x49
    CleanMirror              : QGradient.Preset = ... # 0x4b
    PremiumDark              : QGradient.Preset = ... # 0x4c
    ColdEvening              : QGradient.Preset = ... # 0x4d
    CochitiLake              : QGradient.Preset = ... # 0x4e
    SummerGames              : QGradient.Preset = ... # 0x4f
    PassionateBed            : QGradient.Preset = ... # 0x50
    MountainRock             : QGradient.Preset = ... # 0x51
    DesertHump               : QGradient.Preset = ... # 0x52
    JungleDay                : QGradient.Preset = ... # 0x53
    PhoenixStart             : QGradient.Preset = ... # 0x54
    OctoberSilence           : QGradient.Preset = ... # 0x55
    FarawayRiver             : QGradient.Preset = ... # 0x56
    AlchemistLab             : QGradient.Preset = ... # 0x57
    OverSun                  : QGradient.Preset = ... # 0x58
    PremiumWhite             : QGradient.Preset = ... # 0x59
    MarsParty                : QGradient.Preset = ... # 0x5a
    EternalConstance         : QGradient.Preset = ... # 0x5b
    JapanBlush               : QGradient.Preset = ... # 0x5c
    SmilingRain              : QGradient.Preset = ... # 0x5d
    CloudyApple              : QGradient.Preset = ... # 0x5e
    BigMango                 : QGradient.Preset = ... # 0x5f
    HealthyWater             : QGradient.Preset = ... # 0x60
    AmourAmour               : QGradient.Preset = ... # 0x61
    RiskyConcrete            : QGradient.Preset = ... # 0x62
    StrongStick              : QGradient.Preset = ... # 0x63
    ViciousStance            : QGradient.Preset = ... # 0x64
    PaloAlto                 : QGradient.Preset = ... # 0x65
    HappyMemories            : QGradient.Preset = ... # 0x66
    MidnightBloom            : QGradient.Preset = ... # 0x67
    Crystalline              : QGradient.Preset = ... # 0x68
    PartyBliss               : QGradient.Preset = ... # 0x6a
    ConfidentCloud           : QGradient.Preset = ... # 0x6b
    LeCocktail               : QGradient.Preset = ... # 0x6c
    RiverCity                : QGradient.Preset = ... # 0x6d
    FrozenBerry              : QGradient.Preset = ... # 0x6e
    ChildCare                : QGradient.Preset = ... # 0x70
    FlyingLemon              : QGradient.Preset = ... # 0x71
    NewRetrowave             : QGradient.Preset = ... # 0x72
    HiddenJaguar             : QGradient.Preset = ... # 0x73
    AboveTheSky              : QGradient.Preset = ... # 0x74
    Nega                     : QGradient.Preset = ... # 0x75
    DenseWater               : QGradient.Preset = ... # 0x76
    Seashore                 : QGradient.Preset = ... # 0x78
    MarbleWall               : QGradient.Preset = ... # 0x79
    CheerfulCaramel          : QGradient.Preset = ... # 0x7a
    NightSky                 : QGradient.Preset = ... # 0x7b
    MagicLake                : QGradient.Preset = ... # 0x7c
    YoungGrass               : QGradient.Preset = ... # 0x7d
    ColorfulPeach            : QGradient.Preset = ... # 0x7e
    GentleCare               : QGradient.Preset = ... # 0x7f
    PlumBath                 : QGradient.Preset = ... # 0x80
    HappyUnicorn             : QGradient.Preset = ... # 0x81
    AfricanField             : QGradient.Preset = ... # 0x83
    SolidStone               : QGradient.Preset = ... # 0x84
    OrangeJuice              : QGradient.Preset = ... # 0x85
    GlassWater               : QGradient.Preset = ... # 0x86
    NorthMiracle             : QGradient.Preset = ... # 0x88
    FruitBlend               : QGradient.Preset = ... # 0x89
    MillenniumPine           : QGradient.Preset = ... # 0x8a
    HighFlight               : QGradient.Preset = ... # 0x8b
    MoleHall                 : QGradient.Preset = ... # 0x8c
    SpaceShift               : QGradient.Preset = ... # 0x8e
    ForestInei               : QGradient.Preset = ... # 0x8f
    RoyalGarden              : QGradient.Preset = ... # 0x90
    RichMetal                : QGradient.Preset = ... # 0x91
    JuicyCake                : QGradient.Preset = ... # 0x92
    SmartIndigo              : QGradient.Preset = ... # 0x93
    SandStrike               : QGradient.Preset = ... # 0x94
    NorseBeauty              : QGradient.Preset = ... # 0x95
    AquaGuidance             : QGradient.Preset = ... # 0x96
    SunVeggie                : QGradient.Preset = ... # 0x97
    SeaLord                  : QGradient.Preset = ... # 0x98
    BlackSea                 : QGradient.Preset = ... # 0x99
    GrassShampoo             : QGradient.Preset = ... # 0x9a
    LandingAircraft          : QGradient.Preset = ... # 0x9b
    WitchDance               : QGradient.Preset = ... # 0x9c
    SleeplessNight           : QGradient.Preset = ... # 0x9d
    AngelCare                : QGradient.Preset = ... # 0x9e
    CrystalRiver             : QGradient.Preset = ... # 0x9f
    SoftLipstick             : QGradient.Preset = ... # 0xa0
    SaltMountain             : QGradient.Preset = ... # 0xa1
    PerfectWhite             : QGradient.Preset = ... # 0xa2
    FreshOasis               : QGradient.Preset = ... # 0xa3
    StrictNovember           : QGradient.Preset = ... # 0xa4
    MorningSalad             : QGradient.Preset = ... # 0xa5
    DeepRelief               : QGradient.Preset = ... # 0xa6
    SeaStrike                : QGradient.Preset = ... # 0xa7
    NightCall                : QGradient.Preset = ... # 0xa8
    SupremeSky               : QGradient.Preset = ... # 0xa9
    LightBlue                : QGradient.Preset = ... # 0xaa
    MindCrawl                : QGradient.Preset = ... # 0xab
    LilyMeadow               : QGradient.Preset = ... # 0xac
    SugarLollipop            : QGradient.Preset = ... # 0xad
    SweetDessert             : QGradient.Preset = ... # 0xae
    MagicRay                 : QGradient.Preset = ... # 0xaf
    TeenParty                : QGradient.Preset = ... # 0xb0
    FrozenHeat               : QGradient.Preset = ... # 0xb1
    GagarinView              : QGradient.Preset = ... # 0xb2
    FabledSunset             : QGradient.Preset = ... # 0xb3
    PerfectBlue              : QGradient.Preset = ... # 0xb4
    NumPresets               : QGradient.Preset = ... # 0xb5
    PadSpread                : QGradient.Spread = ... # 0x0
    ReflectSpread            : QGradient.Spread = ... # 0x1
    RepeatSpread             : QGradient.Spread = ... # 0x2
    LinearGradient           : QGradient.Type = ... # 0x0
    RadialGradient           : QGradient.Type = ... # 0x1
    ConicalGradient          : QGradient.Type = ... # 0x2
    NoGradient               : QGradient.Type = ... # 0x3

    class CoordinateMode(Shiboken.Enum):
        LogicalMode              : QGradient.CoordinateMode = ... # 0x0
        StretchToDeviceMode      : QGradient.CoordinateMode = ... # 0x1
        ObjectBoundingMode       : QGradient.CoordinateMode = ... # 0x2
        ObjectMode               : QGradient.CoordinateMode = ... # 0x3

    class InterpolationMode(Shiboken.Enum):
        ColorInterpolation       : QGradient.InterpolationMode = ... # 0x0
        ComponentInterpolation   : QGradient.InterpolationMode = ... # 0x1

    class Preset(Shiboken.Enum):
        WarmFlame                : QGradient.Preset = ... # 0x1
        NightFade                : QGradient.Preset = ... # 0x2
        SpringWarmth             : QGradient.Preset = ... # 0x3
        JuicyPeach               : QGradient.Preset = ... # 0x4
        YoungPassion             : QGradient.Preset = ... # 0x5
        LadyLips                 : QGradient.Preset = ... # 0x6
        SunnyMorning             : QGradient.Preset = ... # 0x7
        RainyAshville            : QGradient.Preset = ... # 0x8
        FrozenDreams             : QGradient.Preset = ... # 0x9
        WinterNeva               : QGradient.Preset = ... # 0xa
        DustyGrass               : QGradient.Preset = ... # 0xb
        TemptingAzure            : QGradient.Preset = ... # 0xc
        HeavyRain                : QGradient.Preset = ... # 0xd
        AmyCrisp                 : QGradient.Preset = ... # 0xe
        MeanFruit                : QGradient.Preset = ... # 0xf
        DeepBlue                 : QGradient.Preset = ... # 0x10
        RipeMalinka              : QGradient.Preset = ... # 0x11
        CloudyKnoxville          : QGradient.Preset = ... # 0x12
        MalibuBeach              : QGradient.Preset = ... # 0x13
        NewLife                  : QGradient.Preset = ... # 0x14
        TrueSunset               : QGradient.Preset = ... # 0x15
        MorpheusDen              : QGradient.Preset = ... # 0x16
        RareWind                 : QGradient.Preset = ... # 0x17
        NearMoon                 : QGradient.Preset = ... # 0x18
        WildApple                : QGradient.Preset = ... # 0x19
        SaintPetersburg          : QGradient.Preset = ... # 0x1a
        PlumPlate                : QGradient.Preset = ... # 0x1c
        EverlastingSky           : QGradient.Preset = ... # 0x1d
        HappyFisher              : QGradient.Preset = ... # 0x1e
        Blessing                 : QGradient.Preset = ... # 0x1f
        SharpeyeEagle            : QGradient.Preset = ... # 0x20
        LadogaBottom             : QGradient.Preset = ... # 0x21
        LemonGate                : QGradient.Preset = ... # 0x22
        ItmeoBranding            : QGradient.Preset = ... # 0x23
        ZeusMiracle              : QGradient.Preset = ... # 0x24
        OldHat                   : QGradient.Preset = ... # 0x25
        StarWine                 : QGradient.Preset = ... # 0x26
        HappyAcid                : QGradient.Preset = ... # 0x29
        AwesomePine              : QGradient.Preset = ... # 0x2a
        NewYork                  : QGradient.Preset = ... # 0x2b
        ShyRainbow               : QGradient.Preset = ... # 0x2c
        MixedHopes               : QGradient.Preset = ... # 0x2e
        FlyHigh                  : QGradient.Preset = ... # 0x2f
        StrongBliss              : QGradient.Preset = ... # 0x30
        FreshMilk                : QGradient.Preset = ... # 0x31
        SnowAgain                : QGradient.Preset = ... # 0x32
        FebruaryInk              : QGradient.Preset = ... # 0x33
        KindSteel                : QGradient.Preset = ... # 0x34
        SoftGrass                : QGradient.Preset = ... # 0x35
        GrownEarly               : QGradient.Preset = ... # 0x36
        SharpBlues               : QGradient.Preset = ... # 0x37
        ShadyWater               : QGradient.Preset = ... # 0x38
        DirtyBeauty              : QGradient.Preset = ... # 0x39
        GreatWhale               : QGradient.Preset = ... # 0x3a
        TeenNotebook             : QGradient.Preset = ... # 0x3b
        PoliteRumors             : QGradient.Preset = ... # 0x3c
        SweetPeriod              : QGradient.Preset = ... # 0x3d
        WideMatrix               : QGradient.Preset = ... # 0x3e
        SoftCherish              : QGradient.Preset = ... # 0x3f
        RedSalvation             : QGradient.Preset = ... # 0x40
        BurningSpring            : QGradient.Preset = ... # 0x41
        NightParty               : QGradient.Preset = ... # 0x42
        SkyGlider                : QGradient.Preset = ... # 0x43
        HeavenPeach              : QGradient.Preset = ... # 0x44
        PurpleDivision           : QGradient.Preset = ... # 0x45
        AquaSplash               : QGradient.Preset = ... # 0x46
        SpikyNaga                : QGradient.Preset = ... # 0x48
        LoveKiss                 : QGradient.Preset = ... # 0x49
        CleanMirror              : QGradient.Preset = ... # 0x4b
        PremiumDark              : QGradient.Preset = ... # 0x4c
        ColdEvening              : QGradient.Preset = ... # 0x4d
        CochitiLake              : QGradient.Preset = ... # 0x4e
        SummerGames              : QGradient.Preset = ... # 0x4f
        PassionateBed            : QGradient.Preset = ... # 0x50
        MountainRock             : QGradient.Preset = ... # 0x51
        DesertHump               : QGradient.Preset = ... # 0x52
        JungleDay                : QGradient.Preset = ... # 0x53
        PhoenixStart             : QGradient.Preset = ... # 0x54
        OctoberSilence           : QGradient.Preset = ... # 0x55
        FarawayRiver             : QGradient.Preset = ... # 0x56
        AlchemistLab             : QGradient.Preset = ... # 0x57
        OverSun                  : QGradient.Preset = ... # 0x58
        PremiumWhite             : QGradient.Preset = ... # 0x59
        MarsParty                : QGradient.Preset = ... # 0x5a
        EternalConstance         : QGradient.Preset = ... # 0x5b
        JapanBlush               : QGradient.Preset = ... # 0x5c
        SmilingRain              : QGradient.Preset = ... # 0x5d
        CloudyApple              : QGradient.Preset = ... # 0x5e
        BigMango                 : QGradient.Preset = ... # 0x5f
        HealthyWater             : QGradient.Preset = ... # 0x60
        AmourAmour               : QGradient.Preset = ... # 0x61
        RiskyConcrete            : QGradient.Preset = ... # 0x62
        StrongStick              : QGradient.Preset = ... # 0x63
        ViciousStance            : QGradient.Preset = ... # 0x64
        PaloAlto                 : QGradient.Preset = ... # 0x65
        HappyMemories            : QGradient.Preset = ... # 0x66
        MidnightBloom            : QGradient.Preset = ... # 0x67
        Crystalline              : QGradient.Preset = ... # 0x68
        PartyBliss               : QGradient.Preset = ... # 0x6a
        ConfidentCloud           : QGradient.Preset = ... # 0x6b
        LeCocktail               : QGradient.Preset = ... # 0x6c
        RiverCity                : QGradient.Preset = ... # 0x6d
        FrozenBerry              : QGradient.Preset = ... # 0x6e
        ChildCare                : QGradient.Preset = ... # 0x70
        FlyingLemon              : QGradient.Preset = ... # 0x71
        NewRetrowave             : QGradient.Preset = ... # 0x72
        HiddenJaguar             : QGradient.Preset = ... # 0x73
        AboveTheSky              : QGradient.Preset = ... # 0x74
        Nega                     : QGradient.Preset = ... # 0x75
        DenseWater               : QGradient.Preset = ... # 0x76
        Seashore                 : QGradient.Preset = ... # 0x78
        MarbleWall               : QGradient.Preset = ... # 0x79
        CheerfulCaramel          : QGradient.Preset = ... # 0x7a
        NightSky                 : QGradient.Preset = ... # 0x7b
        MagicLake                : QGradient.Preset = ... # 0x7c
        YoungGrass               : QGradient.Preset = ... # 0x7d
        ColorfulPeach            : QGradient.Preset = ... # 0x7e
        GentleCare               : QGradient.Preset = ... # 0x7f
        PlumBath                 : QGradient.Preset = ... # 0x80
        HappyUnicorn             : QGradient.Preset = ... # 0x81
        AfricanField             : QGradient.Preset = ... # 0x83
        SolidStone               : QGradient.Preset = ... # 0x84
        OrangeJuice              : QGradient.Preset = ... # 0x85
        GlassWater               : QGradient.Preset = ... # 0x86
        NorthMiracle             : QGradient.Preset = ... # 0x88
        FruitBlend               : QGradient.Preset = ... # 0x89
        MillenniumPine           : QGradient.Preset = ... # 0x8a
        HighFlight               : QGradient.Preset = ... # 0x8b
        MoleHall                 : QGradient.Preset = ... # 0x8c
        SpaceShift               : QGradient.Preset = ... # 0x8e
        ForestInei               : QGradient.Preset = ... # 0x8f
        RoyalGarden              : QGradient.Preset = ... # 0x90
        RichMetal                : QGradient.Preset = ... # 0x91
        JuicyCake                : QGradient.Preset = ... # 0x92
        SmartIndigo              : QGradient.Preset = ... # 0x93
        SandStrike               : QGradient.Preset = ... # 0x94
        NorseBeauty              : QGradient.Preset = ... # 0x95
        AquaGuidance             : QGradient.Preset = ... # 0x96
        SunVeggie                : QGradient.Preset = ... # 0x97
        SeaLord                  : QGradient.Preset = ... # 0x98
        BlackSea                 : QGradient.Preset = ... # 0x99
        GrassShampoo             : QGradient.Preset = ... # 0x9a
        LandingAircraft          : QGradient.Preset = ... # 0x9b
        WitchDance               : QGradient.Preset = ... # 0x9c
        SleeplessNight           : QGradient.Preset = ... # 0x9d
        AngelCare                : QGradient.Preset = ... # 0x9e
        CrystalRiver             : QGradient.Preset = ... # 0x9f
        SoftLipstick             : QGradient.Preset = ... # 0xa0
        SaltMountain             : QGradient.Preset = ... # 0xa1
        PerfectWhite             : QGradient.Preset = ... # 0xa2
        FreshOasis               : QGradient.Preset = ... # 0xa3
        StrictNovember           : QGradient.Preset = ... # 0xa4
        MorningSalad             : QGradient.Preset = ... # 0xa5
        DeepRelief               : QGradient.Preset = ... # 0xa6
        SeaStrike                : QGradient.Preset = ... # 0xa7
        NightCall                : QGradient.Preset = ... # 0xa8
        SupremeSky               : QGradient.Preset = ... # 0xa9
        LightBlue                : QGradient.Preset = ... # 0xaa
        MindCrawl                : QGradient.Preset = ... # 0xab
        LilyMeadow               : QGradient.Preset = ... # 0xac
        SugarLollipop            : QGradient.Preset = ... # 0xad
        SweetDessert             : QGradient.Preset = ... # 0xae
        MagicRay                 : QGradient.Preset = ... # 0xaf
        TeenParty                : QGradient.Preset = ... # 0xb0
        FrozenHeat               : QGradient.Preset = ... # 0xb1
        GagarinView              : QGradient.Preset = ... # 0xb2
        FabledSunset             : QGradient.Preset = ... # 0xb3
        PerfectBlue              : QGradient.Preset = ... # 0xb4
        NumPresets               : QGradient.Preset = ... # 0xb5

    class Spread(Shiboken.Enum):
        PadSpread                : QGradient.Spread = ... # 0x0
        ReflectSpread            : QGradient.Spread = ... # 0x1
        RepeatSpread             : QGradient.Spread = ... # 0x2

    class Type(Shiboken.Enum):
        LinearGradient           : QGradient.Type = ... # 0x0
        RadialGradient           : QGradient.Type = ... # 0x1
        ConicalGradient          : QGradient.Type = ... # 0x2
        NoGradient               : QGradient.Type = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QGradient: PySide2.QtGui.QGradient) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QGradient.Preset) -> None: ...


class QGuiApplication(PySide2.QtCore.QCoreApplication):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: typing.Sequence[str]) -> None: ...


class QHelpEvent(PySide2.QtCore.QEvent):

    def __init__(self, type: PySide2.QtCore.QEvent.Type, pos: PySide2.QtCore.QPoint, globalPos: PySide2.QtCore.QPoint) -> None: ...


class QHideEvent(PySide2.QtCore.QEvent):

    def __init__(self) -> None: ...


class QHoverEvent(PySide2.QtGui.QInputEvent):

    def __init__(self, type: PySide2.QtCore.QEvent.Type, pos: PySide2.QtCore.QPointF, oldPos: PySide2.QtCore.QPointF, modifiers: PySide2.QtCore.Qt.KeyboardModifiers = ...) -> None: ...


class QIcon(Shiboken.Object):
    Normal                   : QIcon.Mode = ... # 0x0
    Disabled                 : QIcon.Mode = ... # 0x1
    Active                   : QIcon.Mode = ... # 0x2
    Selected                 : QIcon.Mode = ... # 0x3
    On                       : QIcon.State = ... # 0x0
    Off                      : QIcon.State = ... # 0x1

    class Mode(Shiboken.Enum):
        Normal                   : QIcon.Mode = ... # 0x0
        Disabled                 : QIcon.Mode = ... # 0x1
        Active                   : QIcon.Mode = ... # 0x2
        Selected                 : QIcon.Mode = ... # 0x3

    class State(Shiboken.Enum):
        On                       : QIcon.State = ... # 0x0
        Off                      : QIcon.State = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, engine: PySide2.QtGui.QIconEngine) -> None: ...
    @typing.overload
    def __init__(self, fileName: str) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QIcon) -> None: ...
    @typing.overload
    def __init__(self, pixmap: PySide2.QtGui.QPixmap) -> None: ...


class QIconDragEvent(PySide2.QtCore.QEvent):

    def __init__(self) -> None: ...


class QIconEngine(Shiboken.Object):
    AvailableSizesHook       : QIconEngine.IconEngineHook = ... # 0x1
    IconNameHook             : QIconEngine.IconEngineHook = ... # 0x2
    IsNullHook               : QIconEngine.IconEngineHook = ... # 0x3
    ScaledPixmapHook         : QIconEngine.IconEngineHook = ... # 0x4

    class AvailableSizesArgument(Shiboken.Object):

        def __init__(self) -> None: ...


    class IconEngineHook(Shiboken.Enum):
        AvailableSizesHook       : QIconEngine.IconEngineHook = ... # 0x1
        IconNameHook             : QIconEngine.IconEngineHook = ... # 0x2
        IsNullHook               : QIconEngine.IconEngineHook = ... # 0x3
        ScaledPixmapHook         : QIconEngine.IconEngineHook = ... # 0x4

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QIconEngine) -> None: ...


class QImage(PySide2.QtGui.QPaintDevice):
    Format_Invalid           : QImage.Format = ... # 0x0
    Format_Mono              : QImage.Format = ... # 0x1
    Format_MonoLSB           : QImage.Format = ... # 0x2
    Format_Indexed8          : QImage.Format = ... # 0x3
    Format_RGB32             : QImage.Format = ... # 0x4
    Format_ARGB32            : QImage.Format = ... # 0x5
    Format_ARGB32_Premultiplied: QImage.Format = ... # 0x6
    Format_RGB16             : QImage.Format = ... # 0x7
    Format_ARGB8565_Premultiplied: QImage.Format = ... # 0x8
    Format_RGB666            : QImage.Format = ... # 0x9
    Format_ARGB6666_Premultiplied: QImage.Format = ... # 0xa
    Format_RGB555            : QImage.Format = ... # 0xb
    Format_ARGB8555_Premultiplied: QImage.Format = ... # 0xc
    Format_RGB888            : QImage.Format = ... # 0xd
    Format_RGB444            : QImage.Format = ... # 0xe
    Format_ARGB4444_Premultiplied: QImage.Format = ... # 0xf
    Format_RGBX8888          : QImage.Format = ... # 0x10
    Format_RGBA8888          : QImage.Format = ... # 0x11
    Format_RGBA8888_Premultiplied: QImage.Format = ... # 0x12
    Format_BGR30             : QImage.Format = ... # 0x13
    Format_A2BGR30_Premultiplied: QImage.Format = ... # 0x14
    Format_RGB30             : QImage.Format = ... # 0x15
    Format_A2RGB30_Premultiplied: QImage.Format = ... # 0x16
    Format_Alpha8            : QImage.Format = ... # 0x17
    Format_Grayscale8        : QImage.Format = ... # 0x18
    Format_RGBX64            : QImage.Format = ... # 0x19
    Format_RGBA64            : QImage.Format = ... # 0x1a
    Format_RGBA64_Premultiplied: QImage.Format = ... # 0x1b
    Format_Grayscale16       : QImage.Format = ... # 0x1c
    Format_BGR888            : QImage.Format = ... # 0x1d
    NImageFormats            : QImage.Format = ... # 0x1e
    InvertRgb                : QImage.InvertMode = ... # 0x0
    InvertRgba               : QImage.InvertMode = ... # 0x1

    class Format(Shiboken.Enum):
        Format_Invalid           : QImage.Format = ... # 0x0
        Format_Mono              : QImage.Format = ... # 0x1
        Format_MonoLSB           : QImage.Format = ... # 0x2
        Format_Indexed8          : QImage.Format = ... # 0x3
        Format_RGB32             : QImage.Format = ... # 0x4
        Format_ARGB32            : QImage.Format = ... # 0x5
        Format_ARGB32_Premultiplied: QImage.Format = ... # 0x6
        Format_RGB16             : QImage.Format = ... # 0x7
        Format_ARGB8565_Premultiplied: QImage.Format = ... # 0x8
        Format_RGB666            : QImage.Format = ... # 0x9
        Format_ARGB6666_Premultiplied: QImage.Format = ... # 0xa
        Format_RGB555            : QImage.Format = ... # 0xb
        Format_ARGB8555_Premultiplied: QImage.Format = ... # 0xc
        Format_RGB888            : QImage.Format = ... # 0xd
        Format_RGB444            : QImage.Format = ... # 0xe
        Format_ARGB4444_Premultiplied: QImage.Format = ... # 0xf
        Format_RGBX8888          : QImage.Format = ... # 0x10
        Format_RGBA8888          : QImage.Format = ... # 0x11
        Format_RGBA8888_Premultiplied: QImage.Format = ... # 0x12
        Format_BGR30             : QImage.Format = ... # 0x13
        Format_A2BGR30_Premultiplied: QImage.Format = ... # 0x14
        Format_RGB30             : QImage.Format = ... # 0x15
        Format_A2RGB30_Premultiplied: QImage.Format = ... # 0x16
        Format_Alpha8            : QImage.Format = ... # 0x17
        Format_Grayscale8        : QImage.Format = ... # 0x18
        Format_RGBX64            : QImage.Format = ... # 0x19
        Format_RGBA64            : QImage.Format = ... # 0x1a
        Format_RGBA64_Premultiplied: QImage.Format = ... # 0x1b
        Format_Grayscale16       : QImage.Format = ... # 0x1c
        Format_BGR888            : QImage.Format = ... # 0x1d
        NImageFormats            : QImage.Format = ... # 0x1e

    class InvertMode(Shiboken.Enum):
        InvertRgb                : QImage.InvertMode = ... # 0x0
        InvertRgba               : QImage.InvertMode = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QImage) -> None: ...
    @typing.overload
    def __init__(self, arg__1: str, arg__2: int, arg__3: int, arg__4: PySide2.QtGui.QImage.Format) -> None: ...
    @typing.overload
    def __init__(self, arg__1: str, arg__2: int, arg__3: int, arg__4: int, arg__5: PySide2.QtGui.QImage.Format) -> None: ...
    @typing.overload
    def __init__(self, data: bytes, width: int, height: int, bytesPerLine: int, format: PySide2.QtGui.QImage.Format, cleanupFunction: typing.Optional[typing.Callable] = ..., cleanupInfo: typing.Optional[int] = ...) -> None: ...
    @typing.overload
    def __init__(self, data: bytes, width: int, height: int, format: PySide2.QtGui.QImage.Format, cleanupFunction: typing.Optional[typing.Callable] = ..., cleanupInfo: typing.Optional[int] = ...) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, format: typing.Optional[bytes] = ...) -> None: ...
    @typing.overload
    def __init__(self, size: PySide2.QtCore.QSize, format: PySide2.QtGui.QImage.Format) -> None: ...
    @typing.overload
    def __init__(self, width: int, height: int, format: PySide2.QtGui.QImage.Format) -> None: ...
    @typing.overload
    def __init__(self, xpm: typing.Sequence[str]) -> None: ...


class QImageIOHandler(Shiboken.Object):
    Size                     : QImageIOHandler.ImageOption = ... # 0x0
    ClipRect                 : QImageIOHandler.ImageOption = ... # 0x1
    Description              : QImageIOHandler.ImageOption = ... # 0x2
    ScaledClipRect           : QImageIOHandler.ImageOption = ... # 0x3
    ScaledSize               : QImageIOHandler.ImageOption = ... # 0x4
    CompressionRatio         : QImageIOHandler.ImageOption = ... # 0x5
    Gamma                    : QImageIOHandler.ImageOption = ... # 0x6
    Quality                  : QImageIOHandler.ImageOption = ... # 0x7
    Name                     : QImageIOHandler.ImageOption = ... # 0x8
    SubType                  : QImageIOHandler.ImageOption = ... # 0x9
    IncrementalReading       : QImageIOHandler.ImageOption = ... # 0xa
    Endianness               : QImageIOHandler.ImageOption = ... # 0xb
    Animation                : QImageIOHandler.ImageOption = ... # 0xc
    BackgroundColor          : QImageIOHandler.ImageOption = ... # 0xd
    ImageFormat              : QImageIOHandler.ImageOption = ... # 0xe
    SupportedSubTypes        : QImageIOHandler.ImageOption = ... # 0xf
    OptimizedWrite           : QImageIOHandler.ImageOption = ... # 0x10
    ProgressiveScanWrite     : QImageIOHandler.ImageOption = ... # 0x11
    ImageTransformation      : QImageIOHandler.ImageOption = ... # 0x12
    TransformedByDefault     : QImageIOHandler.ImageOption = ... # 0x13
    TransformationNone       : QImageIOHandler.Transformation = ... # 0x0
    TransformationMirror     : QImageIOHandler.Transformation = ... # 0x1
    TransformationFlip       : QImageIOHandler.Transformation = ... # 0x2
    TransformationRotate180  : QImageIOHandler.Transformation = ... # 0x3
    TransformationRotate90   : QImageIOHandler.Transformation = ... # 0x4
    TransformationMirrorAndRotate90: QImageIOHandler.Transformation = ... # 0x5
    TransformationFlipAndRotate90: QImageIOHandler.Transformation = ... # 0x6
    TransformationRotate270  : QImageIOHandler.Transformation = ... # 0x7

    class ImageOption(Shiboken.Enum):
        Size                     : QImageIOHandler.ImageOption = ... # 0x0
        ClipRect                 : QImageIOHandler.ImageOption = ... # 0x1
        Description              : QImageIOHandler.ImageOption = ... # 0x2
        ScaledClipRect           : QImageIOHandler.ImageOption = ... # 0x3
        ScaledSize               : QImageIOHandler.ImageOption = ... # 0x4
        CompressionRatio         : QImageIOHandler.ImageOption = ... # 0x5
        Gamma                    : QImageIOHandler.ImageOption = ... # 0x6
        Quality                  : QImageIOHandler.ImageOption = ... # 0x7
        Name                     : QImageIOHandler.ImageOption = ... # 0x8
        SubType                  : QImageIOHandler.ImageOption = ... # 0x9
        IncrementalReading       : QImageIOHandler.ImageOption = ... # 0xa
        Endianness               : QImageIOHandler.ImageOption = ... # 0xb
        Animation                : QImageIOHandler.ImageOption = ... # 0xc
        BackgroundColor          : QImageIOHandler.ImageOption = ... # 0xd
        ImageFormat              : QImageIOHandler.ImageOption = ... # 0xe
        SupportedSubTypes        : QImageIOHandler.ImageOption = ... # 0xf
        OptimizedWrite           : QImageIOHandler.ImageOption = ... # 0x10
        ProgressiveScanWrite     : QImageIOHandler.ImageOption = ... # 0x11
        ImageTransformation      : QImageIOHandler.ImageOption = ... # 0x12
        TransformedByDefault     : QImageIOHandler.ImageOption = ... # 0x13

    class Transformation(Shiboken.Enum):
        TransformationNone       : QImageIOHandler.Transformation = ... # 0x0
        TransformationMirror     : QImageIOHandler.Transformation = ... # 0x1
        TransformationFlip       : QImageIOHandler.Transformation = ... # 0x2
        TransformationRotate180  : QImageIOHandler.Transformation = ... # 0x3
        TransformationRotate90   : QImageIOHandler.Transformation = ... # 0x4
        TransformationMirrorAndRotate90: QImageIOHandler.Transformation = ... # 0x5
        TransformationFlipAndRotate90: QImageIOHandler.Transformation = ... # 0x6
        TransformationRotate270  : QImageIOHandler.Transformation = ... # 0x7

    class Transformations(object): ...

    def __init__(self) -> None: ...


class QImageReader(Shiboken.Object):
    UnknownError             : QImageReader.ImageReaderError = ... # 0x0
    FileNotFoundError        : QImageReader.ImageReaderError = ... # 0x1
    DeviceError              : QImageReader.ImageReaderError = ... # 0x2
    UnsupportedFormatError   : QImageReader.ImageReaderError = ... # 0x3
    InvalidDataError         : QImageReader.ImageReaderError = ... # 0x4

    class ImageReaderError(Shiboken.Enum):
        UnknownError             : QImageReader.ImageReaderError = ... # 0x0
        FileNotFoundError        : QImageReader.ImageReaderError = ... # 0x1
        DeviceError              : QImageReader.ImageReaderError = ... # 0x2
        UnsupportedFormatError   : QImageReader.ImageReaderError = ... # 0x3
        InvalidDataError         : QImageReader.ImageReaderError = ... # 0x4

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, device: PySide2.QtCore.QIODevice, format: PySide2.QtCore.QByteArray = ...) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, format: PySide2.QtCore.QByteArray = ...) -> None: ...


class QImageWriter(Shiboken.Object):
    UnknownError             : QImageWriter.ImageWriterError = ... # 0x0
    DeviceError              : QImageWriter.ImageWriterError = ... # 0x1
    UnsupportedFormatError   : QImageWriter.ImageWriterError = ... # 0x2
    InvalidImageError        : QImageWriter.ImageWriterError = ... # 0x3

    class ImageWriterError(Shiboken.Enum):
        UnknownError             : QImageWriter.ImageWriterError = ... # 0x0
        DeviceError              : QImageWriter.ImageWriterError = ... # 0x1
        UnsupportedFormatError   : QImageWriter.ImageWriterError = ... # 0x2
        InvalidImageError        : QImageWriter.ImageWriterError = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, device: PySide2.QtCore.QIODevice, format: PySide2.QtCore.QByteArray) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, format: PySide2.QtCore.QByteArray = ...) -> None: ...


class QInputEvent(PySide2.QtCore.QEvent):

    def __init__(self, type: PySide2.QtCore.QEvent.Type, modifiers: PySide2.QtCore.Qt.KeyboardModifiers = ...) -> None: ...


class QInputMethod(PySide2.QtCore.QObject):
    Click                    : QInputMethod.Action = ... # 0x0
    ContextMenu              : QInputMethod.Action = ... # 0x1

    class Action(Shiboken.Enum):
        Click                    : QInputMethod.Action = ... # 0x0
        ContextMenu              : QInputMethod.Action = ... # 0x1


class QInputMethodEvent(PySide2.QtCore.QEvent):
    TextFormat               : QInputMethodEvent.AttributeType = ... # 0x0
    Cursor                   : QInputMethodEvent.AttributeType = ... # 0x1
    Language                 : QInputMethodEvent.AttributeType = ... # 0x2
    Ruby                     : QInputMethodEvent.AttributeType = ... # 0x3
    Selection                : QInputMethodEvent.AttributeType = ... # 0x4

    class Attribute(Shiboken.Object):

        @typing.overload
        def __init__(self, Attribute: PySide2.QtGui.QInputMethodEvent.Attribute) -> None: ...
        @typing.overload
        def __init__(self, typ: PySide2.QtGui.QInputMethodEvent.AttributeType, s: int, l: int) -> None: ...
        @typing.overload
        def __init__(self, typ: PySide2.QtGui.QInputMethodEvent.AttributeType, s: int, l: int, val: typing.Any) -> None: ...


    class AttributeType(Shiboken.Enum):
        TextFormat               : QInputMethodEvent.AttributeType = ... # 0x0
        Cursor                   : QInputMethodEvent.AttributeType = ... # 0x1
        Language                 : QInputMethodEvent.AttributeType = ... # 0x2
        Ruby                     : QInputMethodEvent.AttributeType = ... # 0x3
        Selection                : QInputMethodEvent.AttributeType = ... # 0x4

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QInputMethodEvent) -> None: ...
    @typing.overload
    def __init__(self, preeditText: str, attributes: typing.Sequence[PySide2.QtGui.QInputMethodEvent.Attribute]) -> None: ...


class QInputMethodQueryEvent(PySide2.QtCore.QEvent):

    def __init__(self, queries: PySide2.QtCore.Qt.InputMethodQueries) -> None: ...


class QIntValidator(PySide2.QtGui.QValidator):

    @typing.overload
    def __init__(self, bottom: int, top: int, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QKeyEvent(PySide2.QtGui.QInputEvent):

    @typing.overload
    def __init__(self, type: PySide2.QtCore.QEvent.Type, key: int, modifiers: PySide2.QtCore.Qt.KeyboardModifiers, nativeScanCode: int, nativeVirtualKey: int, nativeModifiers: int, text: str = ..., autorep: bool = ..., count: int = ...) -> None: ...
    @typing.overload
    def __init__(self, type: PySide2.QtCore.QEvent.Type, key: int, modifiers: PySide2.QtCore.Qt.KeyboardModifiers, text: str = ..., autorep: bool = ..., count: int = ...) -> None: ...


class QKeySequence(Shiboken.Object):
    NativeText               : QKeySequence.SequenceFormat = ... # 0x0
    PortableText             : QKeySequence.SequenceFormat = ... # 0x1
    NoMatch                  : QKeySequence.SequenceMatch = ... # 0x0
    PartialMatch             : QKeySequence.SequenceMatch = ... # 0x1
    ExactMatch               : QKeySequence.SequenceMatch = ... # 0x2
    UnknownKey               : QKeySequence.StandardKey = ... # 0x0
    HelpContents             : QKeySequence.StandardKey = ... # 0x1
    WhatsThis                : QKeySequence.StandardKey = ... # 0x2
    Open                     : QKeySequence.StandardKey = ... # 0x3
    Close                    : QKeySequence.StandardKey = ... # 0x4
    Save                     : QKeySequence.StandardKey = ... # 0x5
    New                      : QKeySequence.StandardKey = ... # 0x6
    Delete                   : QKeySequence.StandardKey = ... # 0x7
    Cut                      : QKeySequence.StandardKey = ... # 0x8
    Copy                     : QKeySequence.StandardKey = ... # 0x9
    Paste                    : QKeySequence.StandardKey = ... # 0xa
    Undo                     : QKeySequence.StandardKey = ... # 0xb
    Redo                     : QKeySequence.StandardKey = ... # 0xc
    Back                     : QKeySequence.StandardKey = ... # 0xd
    Forward                  : QKeySequence.StandardKey = ... # 0xe
    Refresh                  : QKeySequence.StandardKey = ... # 0xf
    ZoomIn                   : QKeySequence.StandardKey = ... # 0x10
    ZoomOut                  : QKeySequence.StandardKey = ... # 0x11
    Print                    : QKeySequence.StandardKey = ... # 0x12
    AddTab                   : QKeySequence.StandardKey = ... # 0x13
    NextChild                : QKeySequence.StandardKey = ... # 0x14
    PreviousChild            : QKeySequence.StandardKey = ... # 0x15
    Find                     : QKeySequence.StandardKey = ... # 0x16
    FindNext                 : QKeySequence.StandardKey = ... # 0x17
    FindPrevious             : QKeySequence.StandardKey = ... # 0x18
    Replace                  : QKeySequence.StandardKey = ... # 0x19
    SelectAll                : QKeySequence.StandardKey = ... # 0x1a
    Bold                     : QKeySequence.StandardKey = ... # 0x1b
    Italic                   : QKeySequence.StandardKey = ... # 0x1c
    Underline                : QKeySequence.StandardKey = ... # 0x1d
    MoveToNextChar           : QKeySequence.StandardKey = ... # 0x1e
    MoveToPreviousChar       : QKeySequence.StandardKey = ... # 0x1f
    MoveToNextWord           : QKeySequence.StandardKey = ... # 0x20
    MoveToPreviousWord       : QKeySequence.StandardKey = ... # 0x21
    MoveToNextLine           : QKeySequence.StandardKey = ... # 0x22
    MoveToPreviousLine       : QKeySequence.StandardKey = ... # 0x23
    MoveToNextPage           : QKeySequence.StandardKey = ... # 0x24
    MoveToPreviousPage       : QKeySequence.StandardKey = ... # 0x25
    MoveToStartOfLine        : QKeySequence.StandardKey = ... # 0x26
    MoveToEndOfLine          : QKeySequence.StandardKey = ... # 0x27
    MoveToStartOfBlock       : QKeySequence.StandardKey = ... # 0x28
    MoveToEndOfBlock         : QKeySequence.StandardKey = ... # 0x29
    MoveToStartOfDocument    : QKeySequence.StandardKey = ... # 0x2a
    MoveToEndOfDocument      : QKeySequence.StandardKey = ... # 0x2b
    SelectNextChar           : QKeySequence.StandardKey = ... # 0x2c
    SelectPreviousChar       : QKeySequence.StandardKey = ... # 0x2d
    SelectNextWord           : QKeySequence.StandardKey = ... # 0x2e
    SelectPreviousWord       : QKeySequence.StandardKey = ... # 0x2f
    SelectNextLine           : QKeySequence.StandardKey = ... # 0x30
    SelectPreviousLine       : QKeySequence.StandardKey = ... # 0x31
    SelectNextPage           : QKeySequence.StandardKey = ... # 0x32
    SelectPreviousPage       : QKeySequence.StandardKey = ... # 0x33
    SelectStartOfLine        : QKeySequence.StandardKey = ... # 0x34
    SelectEndOfLine          : QKeySequence.StandardKey = ... # 0x35
    SelectStartOfBlock       : QKeySequence.StandardKey = ... # 0x36
    SelectEndOfBlock         : QKeySequence.StandardKey = ... # 0x37
    SelectStartOfDocument    : QKeySequence.StandardKey = ... # 0x38
    SelectEndOfDocument      : QKeySequence.StandardKey = ... # 0x39
    DeleteStartOfWord        : QKeySequence.StandardKey = ... # 0x3a
    DeleteEndOfWord          : QKeySequence.StandardKey = ... # 0x3b
    DeleteEndOfLine          : QKeySequence.StandardKey = ... # 0x3c
    InsertParagraphSeparator : QKeySequence.StandardKey = ... # 0x3d
    InsertLineSeparator      : QKeySequence.StandardKey = ... # 0x3e
    SaveAs                   : QKeySequence.StandardKey = ... # 0x3f
    Preferences              : QKeySequence.StandardKey = ... # 0x40
    Quit                     : QKeySequence.StandardKey = ... # 0x41
    FullScreen               : QKeySequence.StandardKey = ... # 0x42
    Deselect                 : QKeySequence.StandardKey = ... # 0x43
    DeleteCompleteLine       : QKeySequence.StandardKey = ... # 0x44
    Backspace                : QKeySequence.StandardKey = ... # 0x45
    Cancel                   : QKeySequence.StandardKey = ... # 0x46

    class SequenceFormat(Shiboken.Enum):
        NativeText               : QKeySequence.SequenceFormat = ... # 0x0
        PortableText             : QKeySequence.SequenceFormat = ... # 0x1

    class SequenceMatch(Shiboken.Enum):
        NoMatch                  : QKeySequence.SequenceMatch = ... # 0x0
        PartialMatch             : QKeySequence.SequenceMatch = ... # 0x1
        ExactMatch               : QKeySequence.SequenceMatch = ... # 0x2

    class StandardKey(Shiboken.Enum):
        UnknownKey               : QKeySequence.StandardKey = ... # 0x0
        HelpContents             : QKeySequence.StandardKey = ... # 0x1
        WhatsThis                : QKeySequence.StandardKey = ... # 0x2
        Open                     : QKeySequence.StandardKey = ... # 0x3
        Close                    : QKeySequence.StandardKey = ... # 0x4
        Save                     : QKeySequence.StandardKey = ... # 0x5
        New                      : QKeySequence.StandardKey = ... # 0x6
        Delete                   : QKeySequence.StandardKey = ... # 0x7
        Cut                      : QKeySequence.StandardKey = ... # 0x8
        Copy                     : QKeySequence.StandardKey = ... # 0x9
        Paste                    : QKeySequence.StandardKey = ... # 0xa
        Undo                     : QKeySequence.StandardKey = ... # 0xb
        Redo                     : QKeySequence.StandardKey = ... # 0xc
        Back                     : QKeySequence.StandardKey = ... # 0xd
        Forward                  : QKeySequence.StandardKey = ... # 0xe
        Refresh                  : QKeySequence.StandardKey = ... # 0xf
        ZoomIn                   : QKeySequence.StandardKey = ... # 0x10
        ZoomOut                  : QKeySequence.StandardKey = ... # 0x11
        Print                    : QKeySequence.StandardKey = ... # 0x12
        AddTab                   : QKeySequence.StandardKey = ... # 0x13
        NextChild                : QKeySequence.StandardKey = ... # 0x14
        PreviousChild            : QKeySequence.StandardKey = ... # 0x15
        Find                     : QKeySequence.StandardKey = ... # 0x16
        FindNext                 : QKeySequence.StandardKey = ... # 0x17
        FindPrevious             : QKeySequence.StandardKey = ... # 0x18
        Replace                  : QKeySequence.StandardKey = ... # 0x19
        SelectAll                : QKeySequence.StandardKey = ... # 0x1a
        Bold                     : QKeySequence.StandardKey = ... # 0x1b
        Italic                   : QKeySequence.StandardKey = ... # 0x1c
        Underline                : QKeySequence.StandardKey = ... # 0x1d
        MoveToNextChar           : QKeySequence.StandardKey = ... # 0x1e
        MoveToPreviousChar       : QKeySequence.StandardKey = ... # 0x1f
        MoveToNextWord           : QKeySequence.StandardKey = ... # 0x20
        MoveToPreviousWord       : QKeySequence.StandardKey = ... # 0x21
        MoveToNextLine           : QKeySequence.StandardKey = ... # 0x22
        MoveToPreviousLine       : QKeySequence.StandardKey = ... # 0x23
        MoveToNextPage           : QKeySequence.StandardKey = ... # 0x24
        MoveToPreviousPage       : QKeySequence.StandardKey = ... # 0x25
        MoveToStartOfLine        : QKeySequence.StandardKey = ... # 0x26
        MoveToEndOfLine          : QKeySequence.StandardKey = ... # 0x27
        MoveToStartOfBlock       : QKeySequence.StandardKey = ... # 0x28
        MoveToEndOfBlock         : QKeySequence.StandardKey = ... # 0x29
        MoveToStartOfDocument    : QKeySequence.StandardKey = ... # 0x2a
        MoveToEndOfDocument      : QKeySequence.StandardKey = ... # 0x2b
        SelectNextChar           : QKeySequence.StandardKey = ... # 0x2c
        SelectPreviousChar       : QKeySequence.StandardKey = ... # 0x2d
        SelectNextWord           : QKeySequence.StandardKey = ... # 0x2e
        SelectPreviousWord       : QKeySequence.StandardKey = ... # 0x2f
        SelectNextLine           : QKeySequence.StandardKey = ... # 0x30
        SelectPreviousLine       : QKeySequence.StandardKey = ... # 0x31
        SelectNextPage           : QKeySequence.StandardKey = ... # 0x32
        SelectPreviousPage       : QKeySequence.StandardKey = ... # 0x33
        SelectStartOfLine        : QKeySequence.StandardKey = ... # 0x34
        SelectEndOfLine          : QKeySequence.StandardKey = ... # 0x35
        SelectStartOfBlock       : QKeySequence.StandardKey = ... # 0x36
        SelectEndOfBlock         : QKeySequence.StandardKey = ... # 0x37
        SelectStartOfDocument    : QKeySequence.StandardKey = ... # 0x38
        SelectEndOfDocument      : QKeySequence.StandardKey = ... # 0x39
        DeleteStartOfWord        : QKeySequence.StandardKey = ... # 0x3a
        DeleteEndOfWord          : QKeySequence.StandardKey = ... # 0x3b
        DeleteEndOfLine          : QKeySequence.StandardKey = ... # 0x3c
        InsertParagraphSeparator : QKeySequence.StandardKey = ... # 0x3d
        InsertLineSeparator      : QKeySequence.StandardKey = ... # 0x3e
        SaveAs                   : QKeySequence.StandardKey = ... # 0x3f
        Preferences              : QKeySequence.StandardKey = ... # 0x40
        Quit                     : QKeySequence.StandardKey = ... # 0x41
        FullScreen               : QKeySequence.StandardKey = ... # 0x42
        Deselect                 : QKeySequence.StandardKey = ... # 0x43
        DeleteCompleteLine       : QKeySequence.StandardKey = ... # 0x44
        Backspace                : QKeySequence.StandardKey = ... # 0x45
        Cancel                   : QKeySequence.StandardKey = ... # 0x46

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, k1: int, k2: int = ..., k3: int = ..., k4: int = ...) -> None: ...
    @typing.overload
    def __init__(self, key: PySide2.QtGui.QKeySequence.StandardKey) -> None: ...
    @typing.overload
    def __init__(self, key: str, format: PySide2.QtGui.QKeySequence.SequenceFormat = ...) -> None: ...
    @typing.overload
    def __init__(self, ks: PySide2.QtGui.QKeySequence) -> None: ...


class QLinearGradient(PySide2.QtGui.QGradient):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QLinearGradient: PySide2.QtGui.QLinearGradient) -> None: ...
    @typing.overload
    def __init__(self, start: PySide2.QtCore.QPointF, finalStop: PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def __init__(self, xStart: float, yStart: float, xFinalStop: float, yFinalStop: float) -> None: ...


class QMatrix(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, m11: float, m12: float, m21: float, m22: float, dx: float, dy: float) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QMatrix) -> None: ...


class QMatrix2x2(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMatrix2x2: PySide2.QtGui.QMatrix2x2) -> None: ...
    @typing.overload
    def __init__(self, arg__1: typing.Iterable) -> None: ...


class QMatrix2x3(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMatrix2x3: PySide2.QtGui.QMatrix2x3) -> None: ...
    @typing.overload
    def __init__(self, arg__1: typing.Iterable) -> None: ...


class QMatrix2x4(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMatrix2x4: PySide2.QtGui.QMatrix2x4) -> None: ...
    @typing.overload
    def __init__(self, arg__1: typing.Iterable) -> None: ...


class QMatrix3x2(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMatrix3x2: PySide2.QtGui.QMatrix3x2) -> None: ...
    @typing.overload
    def __init__(self, arg__1: typing.Iterable) -> None: ...


class QMatrix3x3(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMatrix3x3: PySide2.QtGui.QMatrix3x3) -> None: ...
    @typing.overload
    def __init__(self, arg__1: typing.Iterable) -> None: ...


class QMatrix3x4(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMatrix3x4: PySide2.QtGui.QMatrix3x4) -> None: ...
    @typing.overload
    def __init__(self, arg__1: typing.Iterable) -> None: ...


class QMatrix4x2(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMatrix4x2: PySide2.QtGui.QMatrix4x2) -> None: ...
    @typing.overload
    def __init__(self, arg__1: typing.Iterable) -> None: ...


class QMatrix4x3(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMatrix4x3: PySide2.QtGui.QMatrix4x3) -> None: ...
    @typing.overload
    def __init__(self, arg__1: typing.Iterable) -> None: ...


class QMatrix4x4(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, m11: float, m12: float, m13: float, m14: float, m21: float, m22: float, m23: float, m24: float, m31: float, m32: float, m33: float, m34: float, m41: float, m42: float, m43: float, m44: float) -> None: ...
    @typing.overload
    def __init__(self, matrix: PySide2.QtGui.QMatrix) -> None: ...
    @typing.overload
    def __init__(self, transform: PySide2.QtGui.QTransform) -> None: ...
    @typing.overload
    def __init__(self, values: typing.Sequence[float]) -> None: ...


class QMouseEvent(PySide2.QtGui.QInputEvent):

    @typing.overload
    def __init__(self, type: PySide2.QtCore.QEvent.Type, localPos: PySide2.QtCore.QPointF, button: PySide2.QtCore.Qt.MouseButton, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers) -> None: ...
    @typing.overload
    def __init__(self, type: PySide2.QtCore.QEvent.Type, localPos: PySide2.QtCore.QPointF, screenPos: PySide2.QtCore.QPointF, button: PySide2.QtCore.Qt.MouseButton, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers) -> None: ...
    @typing.overload
    def __init__(self, type: PySide2.QtCore.QEvent.Type, localPos: PySide2.QtCore.QPointF, windowPos: PySide2.QtCore.QPointF, screenPos: PySide2.QtCore.QPointF, button: PySide2.QtCore.Qt.MouseButton, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers) -> None: ...
    @typing.overload
    def __init__(self, type: PySide2.QtCore.QEvent.Type, localPos: PySide2.QtCore.QPointF, windowPos: PySide2.QtCore.QPointF, screenPos: PySide2.QtCore.QPointF, button: PySide2.QtCore.Qt.MouseButton, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers, source: PySide2.QtCore.Qt.MouseEventSource) -> None: ...


class QMoveEvent(PySide2.QtCore.QEvent):

    def __init__(self, pos: PySide2.QtCore.QPoint, oldPos: PySide2.QtCore.QPoint) -> None: ...


class QMovie(PySide2.QtCore.QObject):
    CacheNone                : QMovie.CacheMode = ... # 0x0
    CacheAll                 : QMovie.CacheMode = ... # 0x1
    NotRunning               : QMovie.MovieState = ... # 0x0
    Paused                   : QMovie.MovieState = ... # 0x1
    Running                  : QMovie.MovieState = ... # 0x2

    class CacheMode(Shiboken.Enum):
        CacheNone                : QMovie.CacheMode = ... # 0x0
        CacheAll                 : QMovie.CacheMode = ... # 0x1

    class MovieState(Shiboken.Enum):
        NotRunning               : QMovie.MovieState = ... # 0x0
        Paused                   : QMovie.MovieState = ... # 0x1
        Running                  : QMovie.MovieState = ... # 0x2

    @typing.overload
    def __init__(self, device: PySide2.QtCore.QIODevice, format: PySide2.QtCore.QByteArray = ..., parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, format: PySide2.QtCore.QByteArray = ..., parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QNativeGestureEvent(PySide2.QtGui.QInputEvent):

    @typing.overload
    def __init__(self, type: PySide2.QtCore.Qt.NativeGestureType, dev: PySide2.QtGui.QTouchDevice, localPos: PySide2.QtCore.QPointF, windowPos: PySide2.QtCore.QPointF, screenPos: PySide2.QtCore.QPointF, value: float, sequenceId: int, intArgument: int) -> None: ...
    @typing.overload
    def __init__(self, type: PySide2.QtCore.Qt.NativeGestureType, localPos: PySide2.QtCore.QPointF, windowPos: PySide2.QtCore.QPointF, screenPos: PySide2.QtCore.QPointF, value: float, sequenceId: int, intArgument: int) -> None: ...


class QOffscreenSurface(PySide2.QtCore.QObject, PySide2.QtGui.QSurface):

    @typing.overload
    def __init__(self, screen: PySide2.QtGui.QScreen, parent: PySide2.QtCore.QObject) -> None: ...
    @typing.overload
    def __init__(self, screen: typing.Optional[PySide2.QtGui.QScreen] = ...) -> None: ...


class QOpenGLBuffer(Shiboken.Object):
    ReadOnly                 : QOpenGLBuffer.Access = ... # 0x88b8
    WriteOnly                : QOpenGLBuffer.Access = ... # 0x88b9
    ReadWrite                : QOpenGLBuffer.Access = ... # 0x88ba
    RangeRead                : QOpenGLBuffer.RangeAccessFlag = ... # 0x1
    RangeWrite               : QOpenGLBuffer.RangeAccessFlag = ... # 0x2
    RangeInvalidate          : QOpenGLBuffer.RangeAccessFlag = ... # 0x4
    RangeInvalidateBuffer    : QOpenGLBuffer.RangeAccessFlag = ... # 0x8
    RangeFlushExplicit       : QOpenGLBuffer.RangeAccessFlag = ... # 0x10
    RangeUnsynchronized      : QOpenGLBuffer.RangeAccessFlag = ... # 0x20
    VertexBuffer             : QOpenGLBuffer.Type = ... # 0x8892
    IndexBuffer              : QOpenGLBuffer.Type = ... # 0x8893
    PixelPackBuffer          : QOpenGLBuffer.Type = ... # 0x88eb
    PixelUnpackBuffer        : QOpenGLBuffer.Type = ... # 0x88ec
    StreamDraw               : QOpenGLBuffer.UsagePattern = ... # 0x88e0
    StreamRead               : QOpenGLBuffer.UsagePattern = ... # 0x88e1
    StreamCopy               : QOpenGLBuffer.UsagePattern = ... # 0x88e2
    StaticDraw               : QOpenGLBuffer.UsagePattern = ... # 0x88e4
    StaticRead               : QOpenGLBuffer.UsagePattern = ... # 0x88e5
    StaticCopy               : QOpenGLBuffer.UsagePattern = ... # 0x88e6
    DynamicDraw              : QOpenGLBuffer.UsagePattern = ... # 0x88e8
    DynamicRead              : QOpenGLBuffer.UsagePattern = ... # 0x88e9
    DynamicCopy              : QOpenGLBuffer.UsagePattern = ... # 0x88ea

    class Access(Shiboken.Enum):
        ReadOnly                 : QOpenGLBuffer.Access = ... # 0x88b8
        WriteOnly                : QOpenGLBuffer.Access = ... # 0x88b9
        ReadWrite                : QOpenGLBuffer.Access = ... # 0x88ba

    class RangeAccessFlag(Shiboken.Enum):
        RangeRead                : QOpenGLBuffer.RangeAccessFlag = ... # 0x1
        RangeWrite               : QOpenGLBuffer.RangeAccessFlag = ... # 0x2
        RangeInvalidate          : QOpenGLBuffer.RangeAccessFlag = ... # 0x4
        RangeInvalidateBuffer    : QOpenGLBuffer.RangeAccessFlag = ... # 0x8
        RangeFlushExplicit       : QOpenGLBuffer.RangeAccessFlag = ... # 0x10
        RangeUnsynchronized      : QOpenGLBuffer.RangeAccessFlag = ... # 0x20

    class RangeAccessFlags(object): ...

    class Type(Shiboken.Enum):
        VertexBuffer             : QOpenGLBuffer.Type = ... # 0x8892
        IndexBuffer              : QOpenGLBuffer.Type = ... # 0x8893
        PixelPackBuffer          : QOpenGLBuffer.Type = ... # 0x88eb
        PixelUnpackBuffer        : QOpenGLBuffer.Type = ... # 0x88ec

    class UsagePattern(Shiboken.Enum):
        StreamDraw               : QOpenGLBuffer.UsagePattern = ... # 0x88e0
        StreamRead               : QOpenGLBuffer.UsagePattern = ... # 0x88e1
        StreamCopy               : QOpenGLBuffer.UsagePattern = ... # 0x88e2
        StaticDraw               : QOpenGLBuffer.UsagePattern = ... # 0x88e4
        StaticRead               : QOpenGLBuffer.UsagePattern = ... # 0x88e5
        StaticCopy               : QOpenGLBuffer.UsagePattern = ... # 0x88e6
        DynamicDraw              : QOpenGLBuffer.UsagePattern = ... # 0x88e8
        DynamicRead              : QOpenGLBuffer.UsagePattern = ... # 0x88e9
        DynamicCopy              : QOpenGLBuffer.UsagePattern = ... # 0x88ea

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QOpenGLBuffer) -> None: ...
    @typing.overload
    def __init__(self, type: PySide2.QtGui.QOpenGLBuffer.Type) -> None: ...


class QOpenGLContext(PySide2.QtCore.QObject):
    LibGL                    : QOpenGLContext.OpenGLModuleType = ... # 0x0
    LibGLES                  : QOpenGLContext.OpenGLModuleType = ... # 0x1

    class OpenGLModuleType(Shiboken.Enum):
        LibGL                    : QOpenGLContext.OpenGLModuleType = ... # 0x0
        LibGLES                  : QOpenGLContext.OpenGLModuleType = ... # 0x1

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QOpenGLContextGroup(PySide2.QtCore.QObject): ...


class QOpenGLDebugLogger(PySide2.QtCore.QObject):
    AsynchronousLogging      : QOpenGLDebugLogger.LoggingMode = ... # 0x0
    SynchronousLogging       : QOpenGLDebugLogger.LoggingMode = ... # 0x1

    class LoggingMode(Shiboken.Enum):
        AsynchronousLogging      : QOpenGLDebugLogger.LoggingMode = ... # 0x0
        SynchronousLogging       : QOpenGLDebugLogger.LoggingMode = ... # 0x1

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QOpenGLDebugMessage(Shiboken.Object):
    InvalidSeverity          : QOpenGLDebugMessage.Severity = ... # 0x0
    HighSeverity             : QOpenGLDebugMessage.Severity = ... # 0x1
    MediumSeverity           : QOpenGLDebugMessage.Severity = ... # 0x2
    LowSeverity              : QOpenGLDebugMessage.Severity = ... # 0x4
    LastSeverity             : QOpenGLDebugMessage.Severity = ... # 0x8
    NotificationSeverity     : QOpenGLDebugMessage.Severity = ... # 0x8
    AnySeverity              : QOpenGLDebugMessage.Severity = ... # -0x1
    InvalidSource            : QOpenGLDebugMessage.Source = ... # 0x0
    APISource                : QOpenGLDebugMessage.Source = ... # 0x1
    WindowSystemSource       : QOpenGLDebugMessage.Source = ... # 0x2
    ShaderCompilerSource     : QOpenGLDebugMessage.Source = ... # 0x4
    ThirdPartySource         : QOpenGLDebugMessage.Source = ... # 0x8
    ApplicationSource        : QOpenGLDebugMessage.Source = ... # 0x10
    LastSource               : QOpenGLDebugMessage.Source = ... # 0x20
    OtherSource              : QOpenGLDebugMessage.Source = ... # 0x20
    AnySource                : QOpenGLDebugMessage.Source = ... # -0x1
    InvalidType              : QOpenGLDebugMessage.Type = ... # 0x0
    ErrorType                : QOpenGLDebugMessage.Type = ... # 0x1
    DeprecatedBehaviorType   : QOpenGLDebugMessage.Type = ... # 0x2
    UndefinedBehaviorType    : QOpenGLDebugMessage.Type = ... # 0x4
    PortabilityType          : QOpenGLDebugMessage.Type = ... # 0x8
    PerformanceType          : QOpenGLDebugMessage.Type = ... # 0x10
    OtherType                : QOpenGLDebugMessage.Type = ... # 0x20
    MarkerType               : QOpenGLDebugMessage.Type = ... # 0x40
    GroupPushType            : QOpenGLDebugMessage.Type = ... # 0x80
    GroupPopType             : QOpenGLDebugMessage.Type = ... # 0x100
    LastType                 : QOpenGLDebugMessage.Type = ... # 0x100
    AnyType                  : QOpenGLDebugMessage.Type = ... # -0x1

    class Severities(object): ...

    class Severity(Shiboken.Enum):
        InvalidSeverity          : QOpenGLDebugMessage.Severity = ... # 0x0
        HighSeverity             : QOpenGLDebugMessage.Severity = ... # 0x1
        MediumSeverity           : QOpenGLDebugMessage.Severity = ... # 0x2
        LowSeverity              : QOpenGLDebugMessage.Severity = ... # 0x4
        LastSeverity             : QOpenGLDebugMessage.Severity = ... # 0x8
        NotificationSeverity     : QOpenGLDebugMessage.Severity = ... # 0x8
        AnySeverity              : QOpenGLDebugMessage.Severity = ... # -0x1

    class Source(Shiboken.Enum):
        InvalidSource            : QOpenGLDebugMessage.Source = ... # 0x0
        APISource                : QOpenGLDebugMessage.Source = ... # 0x1
        WindowSystemSource       : QOpenGLDebugMessage.Source = ... # 0x2
        ShaderCompilerSource     : QOpenGLDebugMessage.Source = ... # 0x4
        ThirdPartySource         : QOpenGLDebugMessage.Source = ... # 0x8
        ApplicationSource        : QOpenGLDebugMessage.Source = ... # 0x10
        LastSource               : QOpenGLDebugMessage.Source = ... # 0x20
        OtherSource              : QOpenGLDebugMessage.Source = ... # 0x20
        AnySource                : QOpenGLDebugMessage.Source = ... # -0x1

    class Sources(object): ...

    class Type(Shiboken.Enum):
        InvalidType              : QOpenGLDebugMessage.Type = ... # 0x0
        ErrorType                : QOpenGLDebugMessage.Type = ... # 0x1
        DeprecatedBehaviorType   : QOpenGLDebugMessage.Type = ... # 0x2
        UndefinedBehaviorType    : QOpenGLDebugMessage.Type = ... # 0x4
        PortabilityType          : QOpenGLDebugMessage.Type = ... # 0x8
        PerformanceType          : QOpenGLDebugMessage.Type = ... # 0x10
        OtherType                : QOpenGLDebugMessage.Type = ... # 0x20
        MarkerType               : QOpenGLDebugMessage.Type = ... # 0x40
        GroupPushType            : QOpenGLDebugMessage.Type = ... # 0x80
        GroupPopType             : QOpenGLDebugMessage.Type = ... # 0x100
        LastType                 : QOpenGLDebugMessage.Type = ... # 0x100
        AnyType                  : QOpenGLDebugMessage.Type = ... # -0x1

    class Types(object): ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, debugMessage: PySide2.QtGui.QOpenGLDebugMessage) -> None: ...


class QOpenGLExtraFunctions(PySide2.QtGui.QOpenGLFunctions):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, context: PySide2.QtGui.QOpenGLContext) -> None: ...


class QOpenGLFramebufferObject(Shiboken.Object):
    NoAttachment             : QOpenGLFramebufferObject.Attachment = ... # 0x0
    CombinedDepthStencil     : QOpenGLFramebufferObject.Attachment = ... # 0x1
    Depth                    : QOpenGLFramebufferObject.Attachment = ... # 0x2
    DontRestoreFramebufferBinding: QOpenGLFramebufferObject.FramebufferRestorePolicy = ... # 0x0
    RestoreFramebufferBindingToDefault: QOpenGLFramebufferObject.FramebufferRestorePolicy = ... # 0x1
    RestoreFrameBufferBinding: QOpenGLFramebufferObject.FramebufferRestorePolicy = ... # 0x2

    class Attachment(Shiboken.Enum):
        NoAttachment             : QOpenGLFramebufferObject.Attachment = ... # 0x0
        CombinedDepthStencil     : QOpenGLFramebufferObject.Attachment = ... # 0x1
        Depth                    : QOpenGLFramebufferObject.Attachment = ... # 0x2

    class FramebufferRestorePolicy(Shiboken.Enum):
        DontRestoreFramebufferBinding: QOpenGLFramebufferObject.FramebufferRestorePolicy = ... # 0x0
        RestoreFramebufferBindingToDefault: QOpenGLFramebufferObject.FramebufferRestorePolicy = ... # 0x1
        RestoreFrameBufferBinding: QOpenGLFramebufferObject.FramebufferRestorePolicy = ... # 0x2

    @typing.overload
    def __init__(self, size: PySide2.QtCore.QSize, attachment: PySide2.QtGui.QOpenGLFramebufferObject.Attachment, target: int = ..., internalFormat: int = ...) -> None: ...
    @typing.overload
    def __init__(self, size: PySide2.QtCore.QSize, format: PySide2.QtGui.QOpenGLFramebufferObjectFormat) -> None: ...
    @typing.overload
    def __init__(self, size: PySide2.QtCore.QSize, target: int = ...) -> None: ...
    @typing.overload
    def __init__(self, width: int, height: int, attachment: PySide2.QtGui.QOpenGLFramebufferObject.Attachment, target: int = ..., internalFormat: int = ...) -> None: ...
    @typing.overload
    def __init__(self, width: int, height: int, format: PySide2.QtGui.QOpenGLFramebufferObjectFormat) -> None: ...
    @typing.overload
    def __init__(self, width: int, height: int, target: int = ...) -> None: ...


class QOpenGLFramebufferObjectFormat(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QOpenGLFramebufferObjectFormat) -> None: ...


class QOpenGLFunctions(Shiboken.Object):
    Multitexture             : QOpenGLFunctions.OpenGLFeature = ... # 0x1
    Shaders                  : QOpenGLFunctions.OpenGLFeature = ... # 0x2
    Buffers                  : QOpenGLFunctions.OpenGLFeature = ... # 0x4
    Framebuffers             : QOpenGLFunctions.OpenGLFeature = ... # 0x8
    BlendColor               : QOpenGLFunctions.OpenGLFeature = ... # 0x10
    BlendEquation            : QOpenGLFunctions.OpenGLFeature = ... # 0x20
    BlendEquationSeparate    : QOpenGLFunctions.OpenGLFeature = ... # 0x40
    BlendFuncSeparate        : QOpenGLFunctions.OpenGLFeature = ... # 0x80
    BlendSubtract            : QOpenGLFunctions.OpenGLFeature = ... # 0x100
    CompressedTextures       : QOpenGLFunctions.OpenGLFeature = ... # 0x200
    Multisample              : QOpenGLFunctions.OpenGLFeature = ... # 0x400
    StencilSeparate          : QOpenGLFunctions.OpenGLFeature = ... # 0x800
    NPOTTextures             : QOpenGLFunctions.OpenGLFeature = ... # 0x1000
    NPOTTextureRepeat        : QOpenGLFunctions.OpenGLFeature = ... # 0x2000
    FixedFunctionPipeline    : QOpenGLFunctions.OpenGLFeature = ... # 0x4000
    TextureRGFormats         : QOpenGLFunctions.OpenGLFeature = ... # 0x8000
    MultipleRenderTargets    : QOpenGLFunctions.OpenGLFeature = ... # 0x10000
    BlendEquationAdvanced    : QOpenGLFunctions.OpenGLFeature = ... # 0x20000

    class OpenGLFeature(Shiboken.Enum):
        Multitexture             : QOpenGLFunctions.OpenGLFeature = ... # 0x1
        Shaders                  : QOpenGLFunctions.OpenGLFeature = ... # 0x2
        Buffers                  : QOpenGLFunctions.OpenGLFeature = ... # 0x4
        Framebuffers             : QOpenGLFunctions.OpenGLFeature = ... # 0x8
        BlendColor               : QOpenGLFunctions.OpenGLFeature = ... # 0x10
        BlendEquation            : QOpenGLFunctions.OpenGLFeature = ... # 0x20
        BlendEquationSeparate    : QOpenGLFunctions.OpenGLFeature = ... # 0x40
        BlendFuncSeparate        : QOpenGLFunctions.OpenGLFeature = ... # 0x80
        BlendSubtract            : QOpenGLFunctions.OpenGLFeature = ... # 0x100
        CompressedTextures       : QOpenGLFunctions.OpenGLFeature = ... # 0x200
        Multisample              : QOpenGLFunctions.OpenGLFeature = ... # 0x400
        StencilSeparate          : QOpenGLFunctions.OpenGLFeature = ... # 0x800
        NPOTTextures             : QOpenGLFunctions.OpenGLFeature = ... # 0x1000
        NPOTTextureRepeat        : QOpenGLFunctions.OpenGLFeature = ... # 0x2000
        FixedFunctionPipeline    : QOpenGLFunctions.OpenGLFeature = ... # 0x4000
        TextureRGFormats         : QOpenGLFunctions.OpenGLFeature = ... # 0x8000
        MultipleRenderTargets    : QOpenGLFunctions.OpenGLFeature = ... # 0x10000
        BlendEquationAdvanced    : QOpenGLFunctions.OpenGLFeature = ... # 0x20000

    class OpenGLFeatures(object): ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, context: PySide2.QtGui.QOpenGLContext) -> None: ...


class QOpenGLPaintDevice(PySide2.QtGui.QPaintDevice):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, size: PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def __init__(self, width: int, height: int) -> None: ...


class QOpenGLPixelTransferOptions(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QOpenGLPixelTransferOptions) -> None: ...


class QOpenGLShader(PySide2.QtCore.QObject):
    Vertex                   : QOpenGLShader.ShaderTypeBit = ... # 0x1
    Fragment                 : QOpenGLShader.ShaderTypeBit = ... # 0x2
    Geometry                 : QOpenGLShader.ShaderTypeBit = ... # 0x4
    TessellationControl      : QOpenGLShader.ShaderTypeBit = ... # 0x8
    TessellationEvaluation   : QOpenGLShader.ShaderTypeBit = ... # 0x10
    Compute                  : QOpenGLShader.ShaderTypeBit = ... # 0x20

    class ShaderType(object): ...

    class ShaderTypeBit(Shiboken.Enum):
        Vertex                   : QOpenGLShader.ShaderTypeBit = ... # 0x1
        Fragment                 : QOpenGLShader.ShaderTypeBit = ... # 0x2
        Geometry                 : QOpenGLShader.ShaderTypeBit = ... # 0x4
        TessellationControl      : QOpenGLShader.ShaderTypeBit = ... # 0x8
        TessellationEvaluation   : QOpenGLShader.ShaderTypeBit = ... # 0x10
        Compute                  : QOpenGLShader.ShaderTypeBit = ... # 0x20

    def __init__(self, type: PySide2.QtGui.QOpenGLShader.ShaderType, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QOpenGLShaderProgram(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QOpenGLTexture(Shiboken.Object):
    BindingTarget1D          : QOpenGLTexture.BindingTarget = ... # 0x8068
    BindingTarget2D          : QOpenGLTexture.BindingTarget = ... # 0x8069
    BindingTarget3D          : QOpenGLTexture.BindingTarget = ... # 0x806a
    BindingTargetRectangle   : QOpenGLTexture.BindingTarget = ... # 0x84f6
    BindingTargetCubeMap     : QOpenGLTexture.BindingTarget = ... # 0x8514
    BindingTarget1DArray     : QOpenGLTexture.BindingTarget = ... # 0x8c1c
    BindingTarget2DArray     : QOpenGLTexture.BindingTarget = ... # 0x8c1d
    BindingTargetBuffer      : QOpenGLTexture.BindingTarget = ... # 0x8c2c
    BindingTargetCubeMapArray: QOpenGLTexture.BindingTarget = ... # 0x900a
    BindingTarget2DMultisample: QOpenGLTexture.BindingTarget = ... # 0x9104
    BindingTarget2DMultisampleArray: QOpenGLTexture.BindingTarget = ... # 0x9105
    CompareNever             : QOpenGLTexture.ComparisonFunction = ... # 0x200
    CompareLess              : QOpenGLTexture.ComparisonFunction = ... # 0x201
    CompareEqual             : QOpenGLTexture.ComparisonFunction = ... # 0x202
    CompareLessEqual         : QOpenGLTexture.ComparisonFunction = ... # 0x203
    CompareGreater           : QOpenGLTexture.ComparisonFunction = ... # 0x204
    CommpareNotEqual         : QOpenGLTexture.ComparisonFunction = ... # 0x205
    CompareGreaterEqual      : QOpenGLTexture.ComparisonFunction = ... # 0x206
    CompareAlways            : QOpenGLTexture.ComparisonFunction = ... # 0x207
    CompareNone              : QOpenGLTexture.ComparisonMode = ... # 0x0
    CompareRefToTexture      : QOpenGLTexture.ComparisonMode = ... # 0x884e
    DirectionS               : QOpenGLTexture.CoordinateDirection = ... # 0x2802
    DirectionT               : QOpenGLTexture.CoordinateDirection = ... # 0x2803
    DirectionR               : QOpenGLTexture.CoordinateDirection = ... # 0x8072
    CubeMapPositiveX         : QOpenGLTexture.CubeMapFace = ... # 0x8515
    CubeMapNegativeX         : QOpenGLTexture.CubeMapFace = ... # 0x8516
    CubeMapPositiveY         : QOpenGLTexture.CubeMapFace = ... # 0x8517
    CubeMapNegativeY         : QOpenGLTexture.CubeMapFace = ... # 0x8518
    CubeMapPositiveZ         : QOpenGLTexture.CubeMapFace = ... # 0x8519
    CubeMapNegativeZ         : QOpenGLTexture.CubeMapFace = ... # 0x851a
    StencilMode              : QOpenGLTexture.DepthStencilMode = ... # 0x1901
    DepthMode                : QOpenGLTexture.DepthStencilMode = ... # 0x1902
    ImmutableStorage         : QOpenGLTexture.Feature = ... # 0x1
    ImmutableMultisampleStorage: QOpenGLTexture.Feature = ... # 0x2
    TextureRectangle         : QOpenGLTexture.Feature = ... # 0x4
    TextureArrays            : QOpenGLTexture.Feature = ... # 0x8
    Texture3D                : QOpenGLTexture.Feature = ... # 0x10
    TextureMultisample       : QOpenGLTexture.Feature = ... # 0x20
    TextureBuffer            : QOpenGLTexture.Feature = ... # 0x40
    TextureCubeMapArrays     : QOpenGLTexture.Feature = ... # 0x80
    Swizzle                  : QOpenGLTexture.Feature = ... # 0x100
    StencilTexturing         : QOpenGLTexture.Feature = ... # 0x200
    AnisotropicFiltering     : QOpenGLTexture.Feature = ... # 0x400
    NPOTTextures             : QOpenGLTexture.Feature = ... # 0x800
    NPOTTextureRepeat        : QOpenGLTexture.Feature = ... # 0x1000
    Texture1D                : QOpenGLTexture.Feature = ... # 0x2000
    TextureComparisonOperators: QOpenGLTexture.Feature = ... # 0x4000
    TextureMipMapLevel       : QOpenGLTexture.Feature = ... # 0x8000
    MaxFeatureFlag           : QOpenGLTexture.Feature = ... # 0x10000
    Nearest                  : QOpenGLTexture.Filter = ... # 0x2600
    Linear                   : QOpenGLTexture.Filter = ... # 0x2601
    NearestMipMapNearest     : QOpenGLTexture.Filter = ... # 0x2700
    LinearMipMapNearest      : QOpenGLTexture.Filter = ... # 0x2701
    NearestMipMapLinear      : QOpenGLTexture.Filter = ... # 0x2702
    LinearMipMapLinear       : QOpenGLTexture.Filter = ... # 0x2703
    GenerateMipMaps          : QOpenGLTexture.MipMapGeneration = ... # 0x0
    DontGenerateMipMaps      : QOpenGLTexture.MipMapGeneration = ... # 0x1
    NoSourceFormat           : QOpenGLTexture.PixelFormat = ... # 0x0
    Stencil                  : QOpenGLTexture.PixelFormat = ... # 0x1901
    Depth                    : QOpenGLTexture.PixelFormat = ... # 0x1902
    Red                      : QOpenGLTexture.PixelFormat = ... # 0x1903
    Alpha                    : QOpenGLTexture.PixelFormat = ... # 0x1906
    RGB                      : QOpenGLTexture.PixelFormat = ... # 0x1907
    RGBA                     : QOpenGLTexture.PixelFormat = ... # 0x1908
    Luminance                : QOpenGLTexture.PixelFormat = ... # 0x1909
    LuminanceAlpha           : QOpenGLTexture.PixelFormat = ... # 0x190a
    BGR                      : QOpenGLTexture.PixelFormat = ... # 0x80e0
    BGRA                     : QOpenGLTexture.PixelFormat = ... # 0x80e1
    RG                       : QOpenGLTexture.PixelFormat = ... # 0x8227
    RG_Integer               : QOpenGLTexture.PixelFormat = ... # 0x8228
    DepthStencil             : QOpenGLTexture.PixelFormat = ... # 0x84f9
    Red_Integer              : QOpenGLTexture.PixelFormat = ... # 0x8d94
    RGB_Integer              : QOpenGLTexture.PixelFormat = ... # 0x8d98
    RGBA_Integer             : QOpenGLTexture.PixelFormat = ... # 0x8d99
    BGR_Integer              : QOpenGLTexture.PixelFormat = ... # 0x8d9a
    BGRA_Integer             : QOpenGLTexture.PixelFormat = ... # 0x8d9b
    NoPixelType              : QOpenGLTexture.PixelType = ... # 0x0
    Int8                     : QOpenGLTexture.PixelType = ... # 0x1400
    UInt8                    : QOpenGLTexture.PixelType = ... # 0x1401
    Int16                    : QOpenGLTexture.PixelType = ... # 0x1402
    UInt16                   : QOpenGLTexture.PixelType = ... # 0x1403
    Int32                    : QOpenGLTexture.PixelType = ... # 0x1404
    UInt32                   : QOpenGLTexture.PixelType = ... # 0x1405
    Float32                  : QOpenGLTexture.PixelType = ... # 0x1406
    Float16                  : QOpenGLTexture.PixelType = ... # 0x140b
    UInt8_RG3B2              : QOpenGLTexture.PixelType = ... # 0x8032
    UInt16_RGBA4             : QOpenGLTexture.PixelType = ... # 0x8033
    UInt16_RGB5A1            : QOpenGLTexture.PixelType = ... # 0x8034
    UInt32_RGBA8             : QOpenGLTexture.PixelType = ... # 0x8035
    UInt32_RGB10A2           : QOpenGLTexture.PixelType = ... # 0x8036
    UInt8_RG3B2_Rev          : QOpenGLTexture.PixelType = ... # 0x8362
    UInt16_R5G6B5            : QOpenGLTexture.PixelType = ... # 0x8363
    UInt16_R5G6B5_Rev        : QOpenGLTexture.PixelType = ... # 0x8364
    UInt16_RGBA4_Rev         : QOpenGLTexture.PixelType = ... # 0x8365
    UInt16_RGB5A1_Rev        : QOpenGLTexture.PixelType = ... # 0x8366
    UInt32_RGBA8_Rev         : QOpenGLTexture.PixelType = ... # 0x8367
    UInt32_RGB10A2_Rev       : QOpenGLTexture.PixelType = ... # 0x8368
    UInt32_D24S8             : QOpenGLTexture.PixelType = ... # 0x84fa
    UInt32_RG11B10F          : QOpenGLTexture.PixelType = ... # 0x8c3b
    UInt32_RGB9_E5           : QOpenGLTexture.PixelType = ... # 0x8c3e
    Float16OES               : QOpenGLTexture.PixelType = ... # 0x8d61
    Float32_D32_UInt32_S8_X24: QOpenGLTexture.PixelType = ... # 0x8dad
    SwizzleRed               : QOpenGLTexture.SwizzleComponent = ... # 0x8e42
    SwizzleGreen             : QOpenGLTexture.SwizzleComponent = ... # 0x8e43
    SwizzleBlue              : QOpenGLTexture.SwizzleComponent = ... # 0x8e44
    SwizzleAlpha             : QOpenGLTexture.SwizzleComponent = ... # 0x8e45
    ZeroValue                : QOpenGLTexture.SwizzleValue = ... # 0x0
    OneValue                 : QOpenGLTexture.SwizzleValue = ... # 0x1
    RedValue                 : QOpenGLTexture.SwizzleValue = ... # 0x1903
    GreenValue               : QOpenGLTexture.SwizzleValue = ... # 0x1904
    BlueValue                : QOpenGLTexture.SwizzleValue = ... # 0x1905
    AlphaValue               : QOpenGLTexture.SwizzleValue = ... # 0x1906
    Target1D                 : QOpenGLTexture.Target = ... # 0xde0
    Target2D                 : QOpenGLTexture.Target = ... # 0xde1
    Target3D                 : QOpenGLTexture.Target = ... # 0x806f
    TargetRectangle          : QOpenGLTexture.Target = ... # 0x84f5
    TargetCubeMap            : QOpenGLTexture.Target = ... # 0x8513
    Target1DArray            : QOpenGLTexture.Target = ... # 0x8c18
    Target2DArray            : QOpenGLTexture.Target = ... # 0x8c1a
    TargetBuffer             : QOpenGLTexture.Target = ... # 0x8c2a
    TargetCubeMapArray       : QOpenGLTexture.Target = ... # 0x9009
    Target2DMultisample      : QOpenGLTexture.Target = ... # 0x9100
    Target2DMultisampleArray : QOpenGLTexture.Target = ... # 0x9102
    NoFormat                 : QOpenGLTexture.TextureFormat = ... # 0x0
    DepthFormat              : QOpenGLTexture.TextureFormat = ... # 0x1902
    AlphaFormat              : QOpenGLTexture.TextureFormat = ... # 0x1906
    RGBFormat                : QOpenGLTexture.TextureFormat = ... # 0x1907
    RGBAFormat               : QOpenGLTexture.TextureFormat = ... # 0x1908
    LuminanceFormat          : QOpenGLTexture.TextureFormat = ... # 0x1909
    LuminanceAlphaFormat     : QOpenGLTexture.TextureFormat = ... # 0x190a
    RG3B2                    : QOpenGLTexture.TextureFormat = ... # 0x2a10
    RGB8_UNorm               : QOpenGLTexture.TextureFormat = ... # 0x8051
    RGB16_UNorm              : QOpenGLTexture.TextureFormat = ... # 0x8054
    RGBA4                    : QOpenGLTexture.TextureFormat = ... # 0x8056
    RGB5A1                   : QOpenGLTexture.TextureFormat = ... # 0x8057
    RGBA8_UNorm              : QOpenGLTexture.TextureFormat = ... # 0x8058
    RGBA16_UNorm             : QOpenGLTexture.TextureFormat = ... # 0x805b
    D16                      : QOpenGLTexture.TextureFormat = ... # 0x81a5
    D24                      : QOpenGLTexture.TextureFormat = ... # 0x81a6
    D32                      : QOpenGLTexture.TextureFormat = ... # 0x81a7
    R8_UNorm                 : QOpenGLTexture.TextureFormat = ... # 0x8229
    R16_UNorm                : QOpenGLTexture.TextureFormat = ... # 0x822a
    RG8_UNorm                : QOpenGLTexture.TextureFormat = ... # 0x822b
    RG16_UNorm               : QOpenGLTexture.TextureFormat = ... # 0x822c
    R16F                     : QOpenGLTexture.TextureFormat = ... # 0x822d
    R32F                     : QOpenGLTexture.TextureFormat = ... # 0x822e
    RG16F                    : QOpenGLTexture.TextureFormat = ... # 0x822f
    RG32F                    : QOpenGLTexture.TextureFormat = ... # 0x8230
    R8I                      : QOpenGLTexture.TextureFormat = ... # 0x8231
    R8U                      : QOpenGLTexture.TextureFormat = ... # 0x8232
    R16I                     : QOpenGLTexture.TextureFormat = ... # 0x8233
    R16U                     : QOpenGLTexture.TextureFormat = ... # 0x8234
    R32I                     : QOpenGLTexture.TextureFormat = ... # 0x8235
    R32U                     : QOpenGLTexture.TextureFormat = ... # 0x8236
    RG8I                     : QOpenGLTexture.TextureFormat = ... # 0x8237
    RG8U                     : QOpenGLTexture.TextureFormat = ... # 0x8238
    RG16I                    : QOpenGLTexture.TextureFormat = ... # 0x8239
    RG16U                    : QOpenGLTexture.TextureFormat = ... # 0x823a
    RG32I                    : QOpenGLTexture.TextureFormat = ... # 0x823b
    RG32U                    : QOpenGLTexture.TextureFormat = ... # 0x823c
    RGB_DXT1                 : QOpenGLTexture.TextureFormat = ... # 0x83f0
    RGBA_DXT1                : QOpenGLTexture.TextureFormat = ... # 0x83f1
    RGBA_DXT3                : QOpenGLTexture.TextureFormat = ... # 0x83f2
    RGBA_DXT5                : QOpenGLTexture.TextureFormat = ... # 0x83f3
    RGBA32F                  : QOpenGLTexture.TextureFormat = ... # 0x8814
    RGB32F                   : QOpenGLTexture.TextureFormat = ... # 0x8815
    RGBA16F                  : QOpenGLTexture.TextureFormat = ... # 0x881a
    RGB16F                   : QOpenGLTexture.TextureFormat = ... # 0x881b
    D24S8                    : QOpenGLTexture.TextureFormat = ... # 0x88f0
    RG11B10F                 : QOpenGLTexture.TextureFormat = ... # 0x8c3a
    RGB9E5                   : QOpenGLTexture.TextureFormat = ... # 0x8c3d
    SRGB8                    : QOpenGLTexture.TextureFormat = ... # 0x8c41
    SRGB8_Alpha8             : QOpenGLTexture.TextureFormat = ... # 0x8c43
    SRGB_DXT1                : QOpenGLTexture.TextureFormat = ... # 0x8c4c
    SRGB_Alpha_DXT1          : QOpenGLTexture.TextureFormat = ... # 0x8c4d
    SRGB_Alpha_DXT3          : QOpenGLTexture.TextureFormat = ... # 0x8c4e
    SRGB_Alpha_DXT5          : QOpenGLTexture.TextureFormat = ... # 0x8c4f
    D32F                     : QOpenGLTexture.TextureFormat = ... # 0x8cac
    D32FS8X24                : QOpenGLTexture.TextureFormat = ... # 0x8cad
    S8                       : QOpenGLTexture.TextureFormat = ... # 0x8d48
    R5G6B5                   : QOpenGLTexture.TextureFormat = ... # 0x8d62
    RGB8_ETC1                : QOpenGLTexture.TextureFormat = ... # 0x8d64
    RGBA32U                  : QOpenGLTexture.TextureFormat = ... # 0x8d70
    RGB32U                   : QOpenGLTexture.TextureFormat = ... # 0x8d71
    RGBA16U                  : QOpenGLTexture.TextureFormat = ... # 0x8d76
    RGB16U                   : QOpenGLTexture.TextureFormat = ... # 0x8d77
    RGBA8U                   : QOpenGLTexture.TextureFormat = ... # 0x8d7c
    RGB8U                    : QOpenGLTexture.TextureFormat = ... # 0x8d7d
    RGBA32I                  : QOpenGLTexture.TextureFormat = ... # 0x8d82
    RGB32I                   : QOpenGLTexture.TextureFormat = ... # 0x8d83
    RGBA16I                  : QOpenGLTexture.TextureFormat = ... # 0x8d88
    RGB16I                   : QOpenGLTexture.TextureFormat = ... # 0x8d89
    RGBA8I                   : QOpenGLTexture.TextureFormat = ... # 0x8d8e
    RGB8I                    : QOpenGLTexture.TextureFormat = ... # 0x8d8f
    R_ATI1N_UNorm            : QOpenGLTexture.TextureFormat = ... # 0x8dbb
    R_ATI1N_SNorm            : QOpenGLTexture.TextureFormat = ... # 0x8dbc
    RG_ATI2N_UNorm           : QOpenGLTexture.TextureFormat = ... # 0x8dbd
    RG_ATI2N_SNorm           : QOpenGLTexture.TextureFormat = ... # 0x8dbe
    RGB_BP_UNorm             : QOpenGLTexture.TextureFormat = ... # 0x8e8c
    SRGB_BP_UNorm            : QOpenGLTexture.TextureFormat = ... # 0x8e8d
    RGB_BP_SIGNED_FLOAT      : QOpenGLTexture.TextureFormat = ... # 0x8e8e
    RGB_BP_UNSIGNED_FLOAT    : QOpenGLTexture.TextureFormat = ... # 0x8e8f
    R8_SNorm                 : QOpenGLTexture.TextureFormat = ... # 0x8f94
    RG8_SNorm                : QOpenGLTexture.TextureFormat = ... # 0x8f95
    RGB8_SNorm               : QOpenGLTexture.TextureFormat = ... # 0x8f96
    RGBA8_SNorm              : QOpenGLTexture.TextureFormat = ... # 0x8f97
    R16_SNorm                : QOpenGLTexture.TextureFormat = ... # 0x8f98
    RG16_SNorm               : QOpenGLTexture.TextureFormat = ... # 0x8f99
    RGB16_SNorm              : QOpenGLTexture.TextureFormat = ... # 0x8f9a
    RGBA16_SNorm             : QOpenGLTexture.TextureFormat = ... # 0x8f9b
    RGB10A2                  : QOpenGLTexture.TextureFormat = ... # 0x906f
    R11_EAC_UNorm            : QOpenGLTexture.TextureFormat = ... # 0x9270
    R11_EAC_SNorm            : QOpenGLTexture.TextureFormat = ... # 0x9271
    RG11_EAC_UNorm           : QOpenGLTexture.TextureFormat = ... # 0x9272
    RG11_EAC_SNorm           : QOpenGLTexture.TextureFormat = ... # 0x9273
    RGB8_ETC2                : QOpenGLTexture.TextureFormat = ... # 0x9274
    SRGB8_ETC2               : QOpenGLTexture.TextureFormat = ... # 0x9275
    RGB8_PunchThrough_Alpha1_ETC2: QOpenGLTexture.TextureFormat = ... # 0x9276
    SRGB8_PunchThrough_Alpha1_ETC2: QOpenGLTexture.TextureFormat = ... # 0x9277
    RGBA8_ETC2_EAC           : QOpenGLTexture.TextureFormat = ... # 0x9278
    SRGB8_Alpha8_ETC2_EAC    : QOpenGLTexture.TextureFormat = ... # 0x9279
    RGBA_ASTC_4x4            : QOpenGLTexture.TextureFormat = ... # 0x93b0
    RGBA_ASTC_5x4            : QOpenGLTexture.TextureFormat = ... # 0x93b1
    RGBA_ASTC_5x5            : QOpenGLTexture.TextureFormat = ... # 0x93b2
    RGBA_ASTC_6x5            : QOpenGLTexture.TextureFormat = ... # 0x93b3
    RGBA_ASTC_6x6            : QOpenGLTexture.TextureFormat = ... # 0x93b4
    RGBA_ASTC_8x5            : QOpenGLTexture.TextureFormat = ... # 0x93b5
    RGBA_ASTC_8x6            : QOpenGLTexture.TextureFormat = ... # 0x93b6
    RGBA_ASTC_8x8            : QOpenGLTexture.TextureFormat = ... # 0x93b7
    RGBA_ASTC_10x5           : QOpenGLTexture.TextureFormat = ... # 0x93b8
    RGBA_ASTC_10x6           : QOpenGLTexture.TextureFormat = ... # 0x93b9
    RGBA_ASTC_10x8           : QOpenGLTexture.TextureFormat = ... # 0x93ba
    RGBA_ASTC_10x10          : QOpenGLTexture.TextureFormat = ... # 0x93bb
    RGBA_ASTC_12x10          : QOpenGLTexture.TextureFormat = ... # 0x93bc
    RGBA_ASTC_12x12          : QOpenGLTexture.TextureFormat = ... # 0x93bd
    SRGB8_Alpha8_ASTC_4x4    : QOpenGLTexture.TextureFormat = ... # 0x93d0
    SRGB8_Alpha8_ASTC_5x4    : QOpenGLTexture.TextureFormat = ... # 0x93d1
    SRGB8_Alpha8_ASTC_5x5    : QOpenGLTexture.TextureFormat = ... # 0x93d2
    SRGB8_Alpha8_ASTC_6x5    : QOpenGLTexture.TextureFormat = ... # 0x93d3
    SRGB8_Alpha8_ASTC_6x6    : QOpenGLTexture.TextureFormat = ... # 0x93d4
    SRGB8_Alpha8_ASTC_8x5    : QOpenGLTexture.TextureFormat = ... # 0x93d5
    SRGB8_Alpha8_ASTC_8x6    : QOpenGLTexture.TextureFormat = ... # 0x93d6
    SRGB8_Alpha8_ASTC_8x8    : QOpenGLTexture.TextureFormat = ... # 0x93d7
    SRGB8_Alpha8_ASTC_10x5   : QOpenGLTexture.TextureFormat = ... # 0x93d8
    SRGB8_Alpha8_ASTC_10x6   : QOpenGLTexture.TextureFormat = ... # 0x93d9
    SRGB8_Alpha8_ASTC_10x8   : QOpenGLTexture.TextureFormat = ... # 0x93da
    SRGB8_Alpha8_ASTC_10x10  : QOpenGLTexture.TextureFormat = ... # 0x93db
    SRGB8_Alpha8_ASTC_12x10  : QOpenGLTexture.TextureFormat = ... # 0x93dc
    SRGB8_Alpha8_ASTC_12x12  : QOpenGLTexture.TextureFormat = ... # 0x93dd
    NoFormatClass            : QOpenGLTexture.TextureFormatClass = ... # 0x0
    FormatClass_128Bit       : QOpenGLTexture.TextureFormatClass = ... # 0x1
    FormatClass_96Bit        : QOpenGLTexture.TextureFormatClass = ... # 0x2
    FormatClass_64Bit        : QOpenGLTexture.TextureFormatClass = ... # 0x3
    FormatClass_48Bit        : QOpenGLTexture.TextureFormatClass = ... # 0x4
    FormatClass_32Bit        : QOpenGLTexture.TextureFormatClass = ... # 0x5
    FormatClass_24Bit        : QOpenGLTexture.TextureFormatClass = ... # 0x6
    FormatClass_16Bit        : QOpenGLTexture.TextureFormatClass = ... # 0x7
    FormatClass_8Bit         : QOpenGLTexture.TextureFormatClass = ... # 0x8
    FormatClass_RGTC1_R      : QOpenGLTexture.TextureFormatClass = ... # 0x9
    FormatClass_RGTC2_RG     : QOpenGLTexture.TextureFormatClass = ... # 0xa
    FormatClass_BPTC_Unorm   : QOpenGLTexture.TextureFormatClass = ... # 0xb
    FormatClass_BPTC_Float   : QOpenGLTexture.TextureFormatClass = ... # 0xc
    FormatClass_S3TC_DXT1_RGB: QOpenGLTexture.TextureFormatClass = ... # 0xd
    FormatClass_S3TC_DXT1_RGBA: QOpenGLTexture.TextureFormatClass = ... # 0xe
    FormatClass_S3TC_DXT3_RGBA: QOpenGLTexture.TextureFormatClass = ... # 0xf
    FormatClass_S3TC_DXT5_RGBA: QOpenGLTexture.TextureFormatClass = ... # 0x10
    FormatClass_Unique       : QOpenGLTexture.TextureFormatClass = ... # 0x11
    ResetTextureUnit         : QOpenGLTexture.TextureUnitReset = ... # 0x0
    DontResetTextureUnit     : QOpenGLTexture.TextureUnitReset = ... # 0x1
    Repeat                   : QOpenGLTexture.WrapMode = ... # 0x2901
    ClampToBorder            : QOpenGLTexture.WrapMode = ... # 0x812d
    ClampToEdge              : QOpenGLTexture.WrapMode = ... # 0x812f
    MirroredRepeat           : QOpenGLTexture.WrapMode = ... # 0x8370

    class BindingTarget(Shiboken.Enum):
        BindingTarget1D          : QOpenGLTexture.BindingTarget = ... # 0x8068
        BindingTarget2D          : QOpenGLTexture.BindingTarget = ... # 0x8069
        BindingTarget3D          : QOpenGLTexture.BindingTarget = ... # 0x806a
        BindingTargetRectangle   : QOpenGLTexture.BindingTarget = ... # 0x84f6
        BindingTargetCubeMap     : QOpenGLTexture.BindingTarget = ... # 0x8514
        BindingTarget1DArray     : QOpenGLTexture.BindingTarget = ... # 0x8c1c
        BindingTarget2DArray     : QOpenGLTexture.BindingTarget = ... # 0x8c1d
        BindingTargetBuffer      : QOpenGLTexture.BindingTarget = ... # 0x8c2c
        BindingTargetCubeMapArray: QOpenGLTexture.BindingTarget = ... # 0x900a
        BindingTarget2DMultisample: QOpenGLTexture.BindingTarget = ... # 0x9104
        BindingTarget2DMultisampleArray: QOpenGLTexture.BindingTarget = ... # 0x9105

    class ComparisonFunction(Shiboken.Enum):
        CompareNever             : QOpenGLTexture.ComparisonFunction = ... # 0x200
        CompareLess              : QOpenGLTexture.ComparisonFunction = ... # 0x201
        CompareEqual             : QOpenGLTexture.ComparisonFunction = ... # 0x202
        CompareLessEqual         : QOpenGLTexture.ComparisonFunction = ... # 0x203
        CompareGreater           : QOpenGLTexture.ComparisonFunction = ... # 0x204
        CommpareNotEqual         : QOpenGLTexture.ComparisonFunction = ... # 0x205
        CompareGreaterEqual      : QOpenGLTexture.ComparisonFunction = ... # 0x206
        CompareAlways            : QOpenGLTexture.ComparisonFunction = ... # 0x207

    class ComparisonMode(Shiboken.Enum):
        CompareNone              : QOpenGLTexture.ComparisonMode = ... # 0x0
        CompareRefToTexture      : QOpenGLTexture.ComparisonMode = ... # 0x884e

    class CoordinateDirection(Shiboken.Enum):
        DirectionS               : QOpenGLTexture.CoordinateDirection = ... # 0x2802
        DirectionT               : QOpenGLTexture.CoordinateDirection = ... # 0x2803
        DirectionR               : QOpenGLTexture.CoordinateDirection = ... # 0x8072

    class CubeMapFace(Shiboken.Enum):
        CubeMapPositiveX         : QOpenGLTexture.CubeMapFace = ... # 0x8515
        CubeMapNegativeX         : QOpenGLTexture.CubeMapFace = ... # 0x8516
        CubeMapPositiveY         : QOpenGLTexture.CubeMapFace = ... # 0x8517
        CubeMapNegativeY         : QOpenGLTexture.CubeMapFace = ... # 0x8518
        CubeMapPositiveZ         : QOpenGLTexture.CubeMapFace = ... # 0x8519
        CubeMapNegativeZ         : QOpenGLTexture.CubeMapFace = ... # 0x851a

    class DepthStencilMode(Shiboken.Enum):
        StencilMode              : QOpenGLTexture.DepthStencilMode = ... # 0x1901
        DepthMode                : QOpenGLTexture.DepthStencilMode = ... # 0x1902

    class Feature(Shiboken.Enum):
        ImmutableStorage         : QOpenGLTexture.Feature = ... # 0x1
        ImmutableMultisampleStorage: QOpenGLTexture.Feature = ... # 0x2
        TextureRectangle         : QOpenGLTexture.Feature = ... # 0x4
        TextureArrays            : QOpenGLTexture.Feature = ... # 0x8
        Texture3D                : QOpenGLTexture.Feature = ... # 0x10
        TextureMultisample       : QOpenGLTexture.Feature = ... # 0x20
        TextureBuffer            : QOpenGLTexture.Feature = ... # 0x40
        TextureCubeMapArrays     : QOpenGLTexture.Feature = ... # 0x80
        Swizzle                  : QOpenGLTexture.Feature = ... # 0x100
        StencilTexturing         : QOpenGLTexture.Feature = ... # 0x200
        AnisotropicFiltering     : QOpenGLTexture.Feature = ... # 0x400
        NPOTTextures             : QOpenGLTexture.Feature = ... # 0x800
        NPOTTextureRepeat        : QOpenGLTexture.Feature = ... # 0x1000
        Texture1D                : QOpenGLTexture.Feature = ... # 0x2000
        TextureComparisonOperators: QOpenGLTexture.Feature = ... # 0x4000
        TextureMipMapLevel       : QOpenGLTexture.Feature = ... # 0x8000
        MaxFeatureFlag           : QOpenGLTexture.Feature = ... # 0x10000

    class Features(object): ...

    class Filter(Shiboken.Enum):
        Nearest                  : QOpenGLTexture.Filter = ... # 0x2600
        Linear                   : QOpenGLTexture.Filter = ... # 0x2601
        NearestMipMapNearest     : QOpenGLTexture.Filter = ... # 0x2700
        LinearMipMapNearest      : QOpenGLTexture.Filter = ... # 0x2701
        NearestMipMapLinear      : QOpenGLTexture.Filter = ... # 0x2702
        LinearMipMapLinear       : QOpenGLTexture.Filter = ... # 0x2703

    class MipMapGeneration(Shiboken.Enum):
        GenerateMipMaps          : QOpenGLTexture.MipMapGeneration = ... # 0x0
        DontGenerateMipMaps      : QOpenGLTexture.MipMapGeneration = ... # 0x1

    class PixelFormat(Shiboken.Enum):
        NoSourceFormat           : QOpenGLTexture.PixelFormat = ... # 0x0
        Stencil                  : QOpenGLTexture.PixelFormat = ... # 0x1901
        Depth                    : QOpenGLTexture.PixelFormat = ... # 0x1902
        Red                      : QOpenGLTexture.PixelFormat = ... # 0x1903
        Alpha                    : QOpenGLTexture.PixelFormat = ... # 0x1906
        RGB                      : QOpenGLTexture.PixelFormat = ... # 0x1907
        RGBA                     : QOpenGLTexture.PixelFormat = ... # 0x1908
        Luminance                : QOpenGLTexture.PixelFormat = ... # 0x1909
        LuminanceAlpha           : QOpenGLTexture.PixelFormat = ... # 0x190a
        BGR                      : QOpenGLTexture.PixelFormat = ... # 0x80e0
        BGRA                     : QOpenGLTexture.PixelFormat = ... # 0x80e1
        RG                       : QOpenGLTexture.PixelFormat = ... # 0x8227
        RG_Integer               : QOpenGLTexture.PixelFormat = ... # 0x8228
        DepthStencil             : QOpenGLTexture.PixelFormat = ... # 0x84f9
        Red_Integer              : QOpenGLTexture.PixelFormat = ... # 0x8d94
        RGB_Integer              : QOpenGLTexture.PixelFormat = ... # 0x8d98
        RGBA_Integer             : QOpenGLTexture.PixelFormat = ... # 0x8d99
        BGR_Integer              : QOpenGLTexture.PixelFormat = ... # 0x8d9a
        BGRA_Integer             : QOpenGLTexture.PixelFormat = ... # 0x8d9b

    class PixelType(Shiboken.Enum):
        NoPixelType              : QOpenGLTexture.PixelType = ... # 0x0
        Int8                     : QOpenGLTexture.PixelType = ... # 0x1400
        UInt8                    : QOpenGLTexture.PixelType = ... # 0x1401
        Int16                    : QOpenGLTexture.PixelType = ... # 0x1402
        UInt16                   : QOpenGLTexture.PixelType = ... # 0x1403
        Int32                    : QOpenGLTexture.PixelType = ... # 0x1404
        UInt32                   : QOpenGLTexture.PixelType = ... # 0x1405
        Float32                  : QOpenGLTexture.PixelType = ... # 0x1406
        Float16                  : QOpenGLTexture.PixelType = ... # 0x140b
        UInt8_RG3B2              : QOpenGLTexture.PixelType = ... # 0x8032
        UInt16_RGBA4             : QOpenGLTexture.PixelType = ... # 0x8033
        UInt16_RGB5A1            : QOpenGLTexture.PixelType = ... # 0x8034
        UInt32_RGBA8             : QOpenGLTexture.PixelType = ... # 0x8035
        UInt32_RGB10A2           : QOpenGLTexture.PixelType = ... # 0x8036
        UInt8_RG3B2_Rev          : QOpenGLTexture.PixelType = ... # 0x8362
        UInt16_R5G6B5            : QOpenGLTexture.PixelType = ... # 0x8363
        UInt16_R5G6B5_Rev        : QOpenGLTexture.PixelType = ... # 0x8364
        UInt16_RGBA4_Rev         : QOpenGLTexture.PixelType = ... # 0x8365
        UInt16_RGB5A1_Rev        : QOpenGLTexture.PixelType = ... # 0x8366
        UInt32_RGBA8_Rev         : QOpenGLTexture.PixelType = ... # 0x8367
        UInt32_RGB10A2_Rev       : QOpenGLTexture.PixelType = ... # 0x8368
        UInt32_D24S8             : QOpenGLTexture.PixelType = ... # 0x84fa
        UInt32_RG11B10F          : QOpenGLTexture.PixelType = ... # 0x8c3b
        UInt32_RGB9_E5           : QOpenGLTexture.PixelType = ... # 0x8c3e
        Float16OES               : QOpenGLTexture.PixelType = ... # 0x8d61
        Float32_D32_UInt32_S8_X24: QOpenGLTexture.PixelType = ... # 0x8dad

    class SwizzleComponent(Shiboken.Enum):
        SwizzleRed               : QOpenGLTexture.SwizzleComponent = ... # 0x8e42
        SwizzleGreen             : QOpenGLTexture.SwizzleComponent = ... # 0x8e43
        SwizzleBlue              : QOpenGLTexture.SwizzleComponent = ... # 0x8e44
        SwizzleAlpha             : QOpenGLTexture.SwizzleComponent = ... # 0x8e45

    class SwizzleValue(Shiboken.Enum):
        ZeroValue                : QOpenGLTexture.SwizzleValue = ... # 0x0
        OneValue                 : QOpenGLTexture.SwizzleValue = ... # 0x1
        RedValue                 : QOpenGLTexture.SwizzleValue = ... # 0x1903
        GreenValue               : QOpenGLTexture.SwizzleValue = ... # 0x1904
        BlueValue                : QOpenGLTexture.SwizzleValue = ... # 0x1905
        AlphaValue               : QOpenGLTexture.SwizzleValue = ... # 0x1906

    class Target(Shiboken.Enum):
        Target1D                 : QOpenGLTexture.Target = ... # 0xde0
        Target2D                 : QOpenGLTexture.Target = ... # 0xde1
        Target3D                 : QOpenGLTexture.Target = ... # 0x806f
        TargetRectangle          : QOpenGLTexture.Target = ... # 0x84f5
        TargetCubeMap            : QOpenGLTexture.Target = ... # 0x8513
        Target1DArray            : QOpenGLTexture.Target = ... # 0x8c18
        Target2DArray            : QOpenGLTexture.Target = ... # 0x8c1a
        TargetBuffer             : QOpenGLTexture.Target = ... # 0x8c2a
        TargetCubeMapArray       : QOpenGLTexture.Target = ... # 0x9009
        Target2DMultisample      : QOpenGLTexture.Target = ... # 0x9100
        Target2DMultisampleArray : QOpenGLTexture.Target = ... # 0x9102

    class TextureFormat(Shiboken.Enum):
        NoFormat                 : QOpenGLTexture.TextureFormat = ... # 0x0
        DepthFormat              : QOpenGLTexture.TextureFormat = ... # 0x1902
        AlphaFormat              : QOpenGLTexture.TextureFormat = ... # 0x1906
        RGBFormat                : QOpenGLTexture.TextureFormat = ... # 0x1907
        RGBAFormat               : QOpenGLTexture.TextureFormat = ... # 0x1908
        LuminanceFormat          : QOpenGLTexture.TextureFormat = ... # 0x1909
        LuminanceAlphaFormat     : QOpenGLTexture.TextureFormat = ... # 0x190a
        RG3B2                    : QOpenGLTexture.TextureFormat = ... # 0x2a10
        RGB8_UNorm               : QOpenGLTexture.TextureFormat = ... # 0x8051
        RGB16_UNorm              : QOpenGLTexture.TextureFormat = ... # 0x8054
        RGBA4                    : QOpenGLTexture.TextureFormat = ... # 0x8056
        RGB5A1                   : QOpenGLTexture.TextureFormat = ... # 0x8057
        RGBA8_UNorm              : QOpenGLTexture.TextureFormat = ... # 0x8058
        RGBA16_UNorm             : QOpenGLTexture.TextureFormat = ... # 0x805b
        D16                      : QOpenGLTexture.TextureFormat = ... # 0x81a5
        D24                      : QOpenGLTexture.TextureFormat = ... # 0x81a6
        D32                      : QOpenGLTexture.TextureFormat = ... # 0x81a7
        R8_UNorm                 : QOpenGLTexture.TextureFormat = ... # 0x8229
        R16_UNorm                : QOpenGLTexture.TextureFormat = ... # 0x822a
        RG8_UNorm                : QOpenGLTexture.TextureFormat = ... # 0x822b
        RG16_UNorm               : QOpenGLTexture.TextureFormat = ... # 0x822c
        R16F                     : QOpenGLTexture.TextureFormat = ... # 0x822d
        R32F                     : QOpenGLTexture.TextureFormat = ... # 0x822e
        RG16F                    : QOpenGLTexture.TextureFormat = ... # 0x822f
        RG32F                    : QOpenGLTexture.TextureFormat = ... # 0x8230
        R8I                      : QOpenGLTexture.TextureFormat = ... # 0x8231
        R8U                      : QOpenGLTexture.TextureFormat = ... # 0x8232
        R16I                     : QOpenGLTexture.TextureFormat = ... # 0x8233
        R16U                     : QOpenGLTexture.TextureFormat = ... # 0x8234
        R32I                     : QOpenGLTexture.TextureFormat = ... # 0x8235
        R32U                     : QOpenGLTexture.TextureFormat = ... # 0x8236
        RG8I                     : QOpenGLTexture.TextureFormat = ... # 0x8237
        RG8U                     : QOpenGLTexture.TextureFormat = ... # 0x8238
        RG16I                    : QOpenGLTexture.TextureFormat = ... # 0x8239
        RG16U                    : QOpenGLTexture.TextureFormat = ... # 0x823a
        RG32I                    : QOpenGLTexture.TextureFormat = ... # 0x823b
        RG32U                    : QOpenGLTexture.TextureFormat = ... # 0x823c
        RGB_DXT1                 : QOpenGLTexture.TextureFormat = ... # 0x83f0
        RGBA_DXT1                : QOpenGLTexture.TextureFormat = ... # 0x83f1
        RGBA_DXT3                : QOpenGLTexture.TextureFormat = ... # 0x83f2
        RGBA_DXT5                : QOpenGLTexture.TextureFormat = ... # 0x83f3
        RGBA32F                  : QOpenGLTexture.TextureFormat = ... # 0x8814
        RGB32F                   : QOpenGLTexture.TextureFormat = ... # 0x8815
        RGBA16F                  : QOpenGLTexture.TextureFormat = ... # 0x881a
        RGB16F                   : QOpenGLTexture.TextureFormat = ... # 0x881b
        D24S8                    : QOpenGLTexture.TextureFormat = ... # 0x88f0
        RG11B10F                 : QOpenGLTexture.TextureFormat = ... # 0x8c3a
        RGB9E5                   : QOpenGLTexture.TextureFormat = ... # 0x8c3d
        SRGB8                    : QOpenGLTexture.TextureFormat = ... # 0x8c41
        SRGB8_Alpha8             : QOpenGLTexture.TextureFormat = ... # 0x8c43
        SRGB_DXT1                : QOpenGLTexture.TextureFormat = ... # 0x8c4c
        SRGB_Alpha_DXT1          : QOpenGLTexture.TextureFormat = ... # 0x8c4d
        SRGB_Alpha_DXT3          : QOpenGLTexture.TextureFormat = ... # 0x8c4e
        SRGB_Alpha_DXT5          : QOpenGLTexture.TextureFormat = ... # 0x8c4f
        D32F                     : QOpenGLTexture.TextureFormat = ... # 0x8cac
        D32FS8X24                : QOpenGLTexture.TextureFormat = ... # 0x8cad
        S8                       : QOpenGLTexture.TextureFormat = ... # 0x8d48
        R5G6B5                   : QOpenGLTexture.TextureFormat = ... # 0x8d62
        RGB8_ETC1                : QOpenGLTexture.TextureFormat = ... # 0x8d64
        RGBA32U                  : QOpenGLTexture.TextureFormat = ... # 0x8d70
        RGB32U                   : QOpenGLTexture.TextureFormat = ... # 0x8d71
        RGBA16U                  : QOpenGLTexture.TextureFormat = ... # 0x8d76
        RGB16U                   : QOpenGLTexture.TextureFormat = ... # 0x8d77
        RGBA8U                   : QOpenGLTexture.TextureFormat = ... # 0x8d7c
        RGB8U                    : QOpenGLTexture.TextureFormat = ... # 0x8d7d
        RGBA32I                  : QOpenGLTexture.TextureFormat = ... # 0x8d82
        RGB32I                   : QOpenGLTexture.TextureFormat = ... # 0x8d83
        RGBA16I                  : QOpenGLTexture.TextureFormat = ... # 0x8d88
        RGB16I                   : QOpenGLTexture.TextureFormat = ... # 0x8d89
        RGBA8I                   : QOpenGLTexture.TextureFormat = ... # 0x8d8e
        RGB8I                    : QOpenGLTexture.TextureFormat = ... # 0x8d8f
        R_ATI1N_UNorm            : QOpenGLTexture.TextureFormat = ... # 0x8dbb
        R_ATI1N_SNorm            : QOpenGLTexture.TextureFormat = ... # 0x8dbc
        RG_ATI2N_UNorm           : QOpenGLTexture.TextureFormat = ... # 0x8dbd
        RG_ATI2N_SNorm           : QOpenGLTexture.TextureFormat = ... # 0x8dbe
        RGB_BP_UNorm             : QOpenGLTexture.TextureFormat = ... # 0x8e8c
        SRGB_BP_UNorm            : QOpenGLTexture.TextureFormat = ... # 0x8e8d
        RGB_BP_SIGNED_FLOAT      : QOpenGLTexture.TextureFormat = ... # 0x8e8e
        RGB_BP_UNSIGNED_FLOAT    : QOpenGLTexture.TextureFormat = ... # 0x8e8f
        R8_SNorm                 : QOpenGLTexture.TextureFormat = ... # 0x8f94
        RG8_SNorm                : QOpenGLTexture.TextureFormat = ... # 0x8f95
        RGB8_SNorm               : QOpenGLTexture.TextureFormat = ... # 0x8f96
        RGBA8_SNorm              : QOpenGLTexture.TextureFormat = ... # 0x8f97
        R16_SNorm                : QOpenGLTexture.TextureFormat = ... # 0x8f98
        RG16_SNorm               : QOpenGLTexture.TextureFormat = ... # 0x8f99
        RGB16_SNorm              : QOpenGLTexture.TextureFormat = ... # 0x8f9a
        RGBA16_SNorm             : QOpenGLTexture.TextureFormat = ... # 0x8f9b
        RGB10A2                  : QOpenGLTexture.TextureFormat = ... # 0x906f
        R11_EAC_UNorm            : QOpenGLTexture.TextureFormat = ... # 0x9270
        R11_EAC_SNorm            : QOpenGLTexture.TextureFormat = ... # 0x9271
        RG11_EAC_UNorm           : QOpenGLTexture.TextureFormat = ... # 0x9272
        RG11_EAC_SNorm           : QOpenGLTexture.TextureFormat = ... # 0x9273
        RGB8_ETC2                : QOpenGLTexture.TextureFormat = ... # 0x9274
        SRGB8_ETC2               : QOpenGLTexture.TextureFormat = ... # 0x9275
        RGB8_PunchThrough_Alpha1_ETC2: QOpenGLTexture.TextureFormat = ... # 0x9276
        SRGB8_PunchThrough_Alpha1_ETC2: QOpenGLTexture.TextureFormat = ... # 0x9277
        RGBA8_ETC2_EAC           : QOpenGLTexture.TextureFormat = ... # 0x9278
        SRGB8_Alpha8_ETC2_EAC    : QOpenGLTexture.TextureFormat = ... # 0x9279
        RGBA_ASTC_4x4            : QOpenGLTexture.TextureFormat = ... # 0x93b0
        RGBA_ASTC_5x4            : QOpenGLTexture.TextureFormat = ... # 0x93b1
        RGBA_ASTC_5x5            : QOpenGLTexture.TextureFormat = ... # 0x93b2
        RGBA_ASTC_6x5            : QOpenGLTexture.TextureFormat = ... # 0x93b3
        RGBA_ASTC_6x6            : QOpenGLTexture.TextureFormat = ... # 0x93b4
        RGBA_ASTC_8x5            : QOpenGLTexture.TextureFormat = ... # 0x93b5
        RGBA_ASTC_8x6            : QOpenGLTexture.TextureFormat = ... # 0x93b6
        RGBA_ASTC_8x8            : QOpenGLTexture.TextureFormat = ... # 0x93b7
        RGBA_ASTC_10x5           : QOpenGLTexture.TextureFormat = ... # 0x93b8
        RGBA_ASTC_10x6           : QOpenGLTexture.TextureFormat = ... # 0x93b9
        RGBA_ASTC_10x8           : QOpenGLTexture.TextureFormat = ... # 0x93ba
        RGBA_ASTC_10x10          : QOpenGLTexture.TextureFormat = ... # 0x93bb
        RGBA_ASTC_12x10          : QOpenGLTexture.TextureFormat = ... # 0x93bc
        RGBA_ASTC_12x12          : QOpenGLTexture.TextureFormat = ... # 0x93bd
        SRGB8_Alpha8_ASTC_4x4    : QOpenGLTexture.TextureFormat = ... # 0x93d0
        SRGB8_Alpha8_ASTC_5x4    : QOpenGLTexture.TextureFormat = ... # 0x93d1
        SRGB8_Alpha8_ASTC_5x5    : QOpenGLTexture.TextureFormat = ... # 0x93d2
        SRGB8_Alpha8_ASTC_6x5    : QOpenGLTexture.TextureFormat = ... # 0x93d3
        SRGB8_Alpha8_ASTC_6x6    : QOpenGLTexture.TextureFormat = ... # 0x93d4
        SRGB8_Alpha8_ASTC_8x5    : QOpenGLTexture.TextureFormat = ... # 0x93d5
        SRGB8_Alpha8_ASTC_8x6    : QOpenGLTexture.TextureFormat = ... # 0x93d6
        SRGB8_Alpha8_ASTC_8x8    : QOpenGLTexture.TextureFormat = ... # 0x93d7
        SRGB8_Alpha8_ASTC_10x5   : QOpenGLTexture.TextureFormat = ... # 0x93d8
        SRGB8_Alpha8_ASTC_10x6   : QOpenGLTexture.TextureFormat = ... # 0x93d9
        SRGB8_Alpha8_ASTC_10x8   : QOpenGLTexture.TextureFormat = ... # 0x93da
        SRGB8_Alpha8_ASTC_10x10  : QOpenGLTexture.TextureFormat = ... # 0x93db
        SRGB8_Alpha8_ASTC_12x10  : QOpenGLTexture.TextureFormat = ... # 0x93dc
        SRGB8_Alpha8_ASTC_12x12  : QOpenGLTexture.TextureFormat = ... # 0x93dd

    class TextureFormatClass(Shiboken.Enum):
        NoFormatClass            : QOpenGLTexture.TextureFormatClass = ... # 0x0
        FormatClass_128Bit       : QOpenGLTexture.TextureFormatClass = ... # 0x1
        FormatClass_96Bit        : QOpenGLTexture.TextureFormatClass = ... # 0x2
        FormatClass_64Bit        : QOpenGLTexture.TextureFormatClass = ... # 0x3
        FormatClass_48Bit        : QOpenGLTexture.TextureFormatClass = ... # 0x4
        FormatClass_32Bit        : QOpenGLTexture.TextureFormatClass = ... # 0x5
        FormatClass_24Bit        : QOpenGLTexture.TextureFormatClass = ... # 0x6
        FormatClass_16Bit        : QOpenGLTexture.TextureFormatClass = ... # 0x7
        FormatClass_8Bit         : QOpenGLTexture.TextureFormatClass = ... # 0x8
        FormatClass_RGTC1_R      : QOpenGLTexture.TextureFormatClass = ... # 0x9
        FormatClass_RGTC2_RG     : QOpenGLTexture.TextureFormatClass = ... # 0xa
        FormatClass_BPTC_Unorm   : QOpenGLTexture.TextureFormatClass = ... # 0xb
        FormatClass_BPTC_Float   : QOpenGLTexture.TextureFormatClass = ... # 0xc
        FormatClass_S3TC_DXT1_RGB: QOpenGLTexture.TextureFormatClass = ... # 0xd
        FormatClass_S3TC_DXT1_RGBA: QOpenGLTexture.TextureFormatClass = ... # 0xe
        FormatClass_S3TC_DXT3_RGBA: QOpenGLTexture.TextureFormatClass = ... # 0xf
        FormatClass_S3TC_DXT5_RGBA: QOpenGLTexture.TextureFormatClass = ... # 0x10
        FormatClass_Unique       : QOpenGLTexture.TextureFormatClass = ... # 0x11

    class TextureUnitReset(Shiboken.Enum):
        ResetTextureUnit         : QOpenGLTexture.TextureUnitReset = ... # 0x0
        DontResetTextureUnit     : QOpenGLTexture.TextureUnitReset = ... # 0x1

    class WrapMode(Shiboken.Enum):
        Repeat                   : QOpenGLTexture.WrapMode = ... # 0x2901
        ClampToBorder            : QOpenGLTexture.WrapMode = ... # 0x812d
        ClampToEdge              : QOpenGLTexture.WrapMode = ... # 0x812f
        MirroredRepeat           : QOpenGLTexture.WrapMode = ... # 0x8370

    @typing.overload
    def __init__(self, image: PySide2.QtGui.QImage, genMipMaps: PySide2.QtGui.QOpenGLTexture.MipMapGeneration = ...) -> None: ...
    @typing.overload
    def __init__(self, target: PySide2.QtGui.QOpenGLTexture.Target) -> None: ...


class QOpenGLTextureBlitter(Shiboken.Object):
    OriginBottomLeft         : QOpenGLTextureBlitter.Origin = ... # 0x0
    OriginTopLeft            : QOpenGLTextureBlitter.Origin = ... # 0x1

    class Origin(Shiboken.Enum):
        OriginBottomLeft         : QOpenGLTextureBlitter.Origin = ... # 0x0
        OriginTopLeft            : QOpenGLTextureBlitter.Origin = ... # 0x1

    def __init__(self) -> None: ...


class QOpenGLTimeMonitor(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QOpenGLTimerQuery(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QOpenGLVersionProfile(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, format: PySide2.QtGui.QSurfaceFormat) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QOpenGLVersionProfile) -> None: ...


class QOpenGLVertexArrayObject(PySide2.QtCore.QObject):

    class Binder(Shiboken.Object):

        def __init__(self, v: PySide2.QtGui.QOpenGLVertexArrayObject) -> None: ...


    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QOpenGLWindow(PySide2.QtGui.QPaintDeviceWindow):
    NoPartialUpdate          : QOpenGLWindow.UpdateBehavior = ... # 0x0
    PartialUpdateBlit        : QOpenGLWindow.UpdateBehavior = ... # 0x1
    PartialUpdateBlend       : QOpenGLWindow.UpdateBehavior = ... # 0x2

    class UpdateBehavior(Shiboken.Enum):
        NoPartialUpdate          : QOpenGLWindow.UpdateBehavior = ... # 0x0
        PartialUpdateBlit        : QOpenGLWindow.UpdateBehavior = ... # 0x1
        PartialUpdateBlend       : QOpenGLWindow.UpdateBehavior = ... # 0x2

    @typing.overload
    def __init__(self, shareContext: PySide2.QtGui.QOpenGLContext, updateBehavior: PySide2.QtGui.QOpenGLWindow.UpdateBehavior = ..., parent: typing.Optional[PySide2.QtGui.QWindow] = ...) -> None: ...
    @typing.overload
    def __init__(self, updateBehavior: PySide2.QtGui.QOpenGLWindow.UpdateBehavior = ..., parent: typing.Optional[PySide2.QtGui.QWindow] = ...) -> None: ...


class QPageLayout(Shiboken.Object):
    StandardMode             : QPageLayout.Mode = ... # 0x0
    FullPageMode             : QPageLayout.Mode = ... # 0x1
    Portrait                 : QPageLayout.Orientation = ... # 0x0
    Landscape                : QPageLayout.Orientation = ... # 0x1
    Millimeter               : QPageLayout.Unit = ... # 0x0
    Point                    : QPageLayout.Unit = ... # 0x1
    Inch                     : QPageLayout.Unit = ... # 0x2
    Pica                     : QPageLayout.Unit = ... # 0x3
    Didot                    : QPageLayout.Unit = ... # 0x4
    Cicero                   : QPageLayout.Unit = ... # 0x5

    class Mode(Shiboken.Enum):
        StandardMode             : QPageLayout.Mode = ... # 0x0
        FullPageMode             : QPageLayout.Mode = ... # 0x1

    class Orientation(Shiboken.Enum):
        Portrait                 : QPageLayout.Orientation = ... # 0x0
        Landscape                : QPageLayout.Orientation = ... # 0x1

    class Unit(Shiboken.Enum):
        Millimeter               : QPageLayout.Unit = ... # 0x0
        Point                    : QPageLayout.Unit = ... # 0x1
        Inch                     : QPageLayout.Unit = ... # 0x2
        Pica                     : QPageLayout.Unit = ... # 0x3
        Didot                    : QPageLayout.Unit = ... # 0x4
        Cicero                   : QPageLayout.Unit = ... # 0x5

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QPageLayout) -> None: ...
    @typing.overload
    def __init__(self, pageSize: PySide2.QtGui.QPageSize, orientation: PySide2.QtGui.QPageLayout.Orientation, margins: PySide2.QtCore.QMarginsF, units: PySide2.QtGui.QPageLayout.Unit = ..., minMargins: PySide2.QtCore.QMarginsF = ...) -> None: ...


class QPageSize(Shiboken.Object):
    A4                       : QPageSize.PageSizeId = ... # 0x0
    B5                       : QPageSize.PageSizeId = ... # 0x1
    AnsiA                    : QPageSize.PageSizeId = ... # 0x2
    Letter                   : QPageSize.PageSizeId = ... # 0x2
    Legal                    : QPageSize.PageSizeId = ... # 0x3
    Executive                : QPageSize.PageSizeId = ... # 0x4
    A0                       : QPageSize.PageSizeId = ... # 0x5
    A1                       : QPageSize.PageSizeId = ... # 0x6
    A2                       : QPageSize.PageSizeId = ... # 0x7
    A3                       : QPageSize.PageSizeId = ... # 0x8
    A5                       : QPageSize.PageSizeId = ... # 0x9
    A6                       : QPageSize.PageSizeId = ... # 0xa
    A7                       : QPageSize.PageSizeId = ... # 0xb
    A8                       : QPageSize.PageSizeId = ... # 0xc
    A9                       : QPageSize.PageSizeId = ... # 0xd
    B0                       : QPageSize.PageSizeId = ... # 0xe
    B1                       : QPageSize.PageSizeId = ... # 0xf
    B10                      : QPageSize.PageSizeId = ... # 0x10
    B2                       : QPageSize.PageSizeId = ... # 0x11
    B3                       : QPageSize.PageSizeId = ... # 0x12
    B4                       : QPageSize.PageSizeId = ... # 0x13
    B6                       : QPageSize.PageSizeId = ... # 0x14
    B7                       : QPageSize.PageSizeId = ... # 0x15
    B8                       : QPageSize.PageSizeId = ... # 0x16
    B9                       : QPageSize.PageSizeId = ... # 0x17
    C5E                      : QPageSize.PageSizeId = ... # 0x18
    EnvelopeC5               : QPageSize.PageSizeId = ... # 0x18
    Comm10E                  : QPageSize.PageSizeId = ... # 0x19
    Envelope10               : QPageSize.PageSizeId = ... # 0x19
    DLE                      : QPageSize.PageSizeId = ... # 0x1a
    EnvelopeDL               : QPageSize.PageSizeId = ... # 0x1a
    Folio                    : QPageSize.PageSizeId = ... # 0x1b
    AnsiB                    : QPageSize.PageSizeId = ... # 0x1c
    Ledger                   : QPageSize.PageSizeId = ... # 0x1c
    Tabloid                  : QPageSize.PageSizeId = ... # 0x1d
    Custom                   : QPageSize.PageSizeId = ... # 0x1e
    A10                      : QPageSize.PageSizeId = ... # 0x1f
    A3Extra                  : QPageSize.PageSizeId = ... # 0x20
    A4Extra                  : QPageSize.PageSizeId = ... # 0x21
    A4Plus                   : QPageSize.PageSizeId = ... # 0x22
    A4Small                  : QPageSize.PageSizeId = ... # 0x23
    A5Extra                  : QPageSize.PageSizeId = ... # 0x24
    B5Extra                  : QPageSize.PageSizeId = ... # 0x25
    JisB0                    : QPageSize.PageSizeId = ... # 0x26
    JisB1                    : QPageSize.PageSizeId = ... # 0x27
    JisB2                    : QPageSize.PageSizeId = ... # 0x28
    JisB3                    : QPageSize.PageSizeId = ... # 0x29
    JisB4                    : QPageSize.PageSizeId = ... # 0x2a
    JisB5                    : QPageSize.PageSizeId = ... # 0x2b
    JisB6                    : QPageSize.PageSizeId = ... # 0x2c
    JisB7                    : QPageSize.PageSizeId = ... # 0x2d
    JisB8                    : QPageSize.PageSizeId = ... # 0x2e
    JisB9                    : QPageSize.PageSizeId = ... # 0x2f
    JisB10                   : QPageSize.PageSizeId = ... # 0x30
    AnsiC                    : QPageSize.PageSizeId = ... # 0x31
    AnsiD                    : QPageSize.PageSizeId = ... # 0x32
    AnsiE                    : QPageSize.PageSizeId = ... # 0x33
    LegalExtra               : QPageSize.PageSizeId = ... # 0x34
    LetterExtra              : QPageSize.PageSizeId = ... # 0x35
    LetterPlus               : QPageSize.PageSizeId = ... # 0x36
    LetterSmall              : QPageSize.PageSizeId = ... # 0x37
    TabloidExtra             : QPageSize.PageSizeId = ... # 0x38
    ArchA                    : QPageSize.PageSizeId = ... # 0x39
    ArchB                    : QPageSize.PageSizeId = ... # 0x3a
    ArchC                    : QPageSize.PageSizeId = ... # 0x3b
    ArchD                    : QPageSize.PageSizeId = ... # 0x3c
    ArchE                    : QPageSize.PageSizeId = ... # 0x3d
    Imperial7x9              : QPageSize.PageSizeId = ... # 0x3e
    Imperial8x10             : QPageSize.PageSizeId = ... # 0x3f
    Imperial9x11             : QPageSize.PageSizeId = ... # 0x40
    Imperial9x12             : QPageSize.PageSizeId = ... # 0x41
    Imperial10x11            : QPageSize.PageSizeId = ... # 0x42
    Imperial10x13            : QPageSize.PageSizeId = ... # 0x43
    Imperial10x14            : QPageSize.PageSizeId = ... # 0x44
    Imperial12x11            : QPageSize.PageSizeId = ... # 0x45
    Imperial15x11            : QPageSize.PageSizeId = ... # 0x46
    ExecutiveStandard        : QPageSize.PageSizeId = ... # 0x47
    Note                     : QPageSize.PageSizeId = ... # 0x48
    Quarto                   : QPageSize.PageSizeId = ... # 0x49
    Statement                : QPageSize.PageSizeId = ... # 0x4a
    SuperA                   : QPageSize.PageSizeId = ... # 0x4b
    SuperB                   : QPageSize.PageSizeId = ... # 0x4c
    Postcard                 : QPageSize.PageSizeId = ... # 0x4d
    DoublePostcard           : QPageSize.PageSizeId = ... # 0x4e
    Prc16K                   : QPageSize.PageSizeId = ... # 0x4f
    Prc32K                   : QPageSize.PageSizeId = ... # 0x50
    Prc32KBig                : QPageSize.PageSizeId = ... # 0x51
    FanFoldUS                : QPageSize.PageSizeId = ... # 0x52
    FanFoldGerman            : QPageSize.PageSizeId = ... # 0x53
    FanFoldGermanLegal       : QPageSize.PageSizeId = ... # 0x54
    EnvelopeB4               : QPageSize.PageSizeId = ... # 0x55
    EnvelopeB5               : QPageSize.PageSizeId = ... # 0x56
    EnvelopeB6               : QPageSize.PageSizeId = ... # 0x57
    EnvelopeC0               : QPageSize.PageSizeId = ... # 0x58
    EnvelopeC1               : QPageSize.PageSizeId = ... # 0x59
    EnvelopeC2               : QPageSize.PageSizeId = ... # 0x5a
    EnvelopeC3               : QPageSize.PageSizeId = ... # 0x5b
    EnvelopeC4               : QPageSize.PageSizeId = ... # 0x5c
    EnvelopeC6               : QPageSize.PageSizeId = ... # 0x5d
    EnvelopeC65              : QPageSize.PageSizeId = ... # 0x5e
    EnvelopeC7               : QPageSize.PageSizeId = ... # 0x5f
    Envelope9                : QPageSize.PageSizeId = ... # 0x60
    Envelope11               : QPageSize.PageSizeId = ... # 0x61
    Envelope12               : QPageSize.PageSizeId = ... # 0x62
    Envelope14               : QPageSize.PageSizeId = ... # 0x63
    EnvelopeMonarch          : QPageSize.PageSizeId = ... # 0x64
    EnvelopePersonal         : QPageSize.PageSizeId = ... # 0x65
    EnvelopeChou3            : QPageSize.PageSizeId = ... # 0x66
    EnvelopeChou4            : QPageSize.PageSizeId = ... # 0x67
    EnvelopeInvite           : QPageSize.PageSizeId = ... # 0x68
    EnvelopeItalian          : QPageSize.PageSizeId = ... # 0x69
    EnvelopeKaku2            : QPageSize.PageSizeId = ... # 0x6a
    EnvelopeKaku3            : QPageSize.PageSizeId = ... # 0x6b
    EnvelopePrc1             : QPageSize.PageSizeId = ... # 0x6c
    EnvelopePrc2             : QPageSize.PageSizeId = ... # 0x6d
    EnvelopePrc3             : QPageSize.PageSizeId = ... # 0x6e
    EnvelopePrc4             : QPageSize.PageSizeId = ... # 0x6f
    EnvelopePrc5             : QPageSize.PageSizeId = ... # 0x70
    EnvelopePrc6             : QPageSize.PageSizeId = ... # 0x71
    EnvelopePrc7             : QPageSize.PageSizeId = ... # 0x72
    EnvelopePrc8             : QPageSize.PageSizeId = ... # 0x73
    EnvelopePrc9             : QPageSize.PageSizeId = ... # 0x74
    EnvelopePrc10            : QPageSize.PageSizeId = ... # 0x75
    EnvelopeYou4             : QPageSize.PageSizeId = ... # 0x76
    LastPageSize             : QPageSize.PageSizeId = ... # 0x76
    NPageSize                : QPageSize.PageSizeId = ... # 0x76
    NPaperSize               : QPageSize.PageSizeId = ... # 0x76
    FuzzyMatch               : QPageSize.SizeMatchPolicy = ... # 0x0
    FuzzyOrientationMatch    : QPageSize.SizeMatchPolicy = ... # 0x1
    ExactMatch               : QPageSize.SizeMatchPolicy = ... # 0x2
    Millimeter               : QPageSize.Unit = ... # 0x0
    Point                    : QPageSize.Unit = ... # 0x1
    Inch                     : QPageSize.Unit = ... # 0x2
    Pica                     : QPageSize.Unit = ... # 0x3
    Didot                    : QPageSize.Unit = ... # 0x4
    Cicero                   : QPageSize.Unit = ... # 0x5

    class PageSizeId(Shiboken.Enum):
        A4                       : QPageSize.PageSizeId = ... # 0x0
        B5                       : QPageSize.PageSizeId = ... # 0x1
        AnsiA                    : QPageSize.PageSizeId = ... # 0x2
        Letter                   : QPageSize.PageSizeId = ... # 0x2
        Legal                    : QPageSize.PageSizeId = ... # 0x3
        Executive                : QPageSize.PageSizeId = ... # 0x4
        A0                       : QPageSize.PageSizeId = ... # 0x5
        A1                       : QPageSize.PageSizeId = ... # 0x6
        A2                       : QPageSize.PageSizeId = ... # 0x7
        A3                       : QPageSize.PageSizeId = ... # 0x8
        A5                       : QPageSize.PageSizeId = ... # 0x9
        A6                       : QPageSize.PageSizeId = ... # 0xa
        A7                       : QPageSize.PageSizeId = ... # 0xb
        A8                       : QPageSize.PageSizeId = ... # 0xc
        A9                       : QPageSize.PageSizeId = ... # 0xd
        B0                       : QPageSize.PageSizeId = ... # 0xe
        B1                       : QPageSize.PageSizeId = ... # 0xf
        B10                      : QPageSize.PageSizeId = ... # 0x10
        B2                       : QPageSize.PageSizeId = ... # 0x11
        B3                       : QPageSize.PageSizeId = ... # 0x12
        B4                       : QPageSize.PageSizeId = ... # 0x13
        B6                       : QPageSize.PageSizeId = ... # 0x14
        B7                       : QPageSize.PageSizeId = ... # 0x15
        B8                       : QPageSize.PageSizeId = ... # 0x16
        B9                       : QPageSize.PageSizeId = ... # 0x17
        C5E                      : QPageSize.PageSizeId = ... # 0x18
        EnvelopeC5               : QPageSize.PageSizeId = ... # 0x18
        Comm10E                  : QPageSize.PageSizeId = ... # 0x19
        Envelope10               : QPageSize.PageSizeId = ... # 0x19
        DLE                      : QPageSize.PageSizeId = ... # 0x1a
        EnvelopeDL               : QPageSize.PageSizeId = ... # 0x1a
        Folio                    : QPageSize.PageSizeId = ... # 0x1b
        AnsiB                    : QPageSize.PageSizeId = ... # 0x1c
        Ledger                   : QPageSize.PageSizeId = ... # 0x1c
        Tabloid                  : QPageSize.PageSizeId = ... # 0x1d
        Custom                   : QPageSize.PageSizeId = ... # 0x1e
        A10                      : QPageSize.PageSizeId = ... # 0x1f
        A3Extra                  : QPageSize.PageSizeId = ... # 0x20
        A4Extra                  : QPageSize.PageSizeId = ... # 0x21
        A4Plus                   : QPageSize.PageSizeId = ... # 0x22
        A4Small                  : QPageSize.PageSizeId = ... # 0x23
        A5Extra                  : QPageSize.PageSizeId = ... # 0x24
        B5Extra                  : QPageSize.PageSizeId = ... # 0x25
        JisB0                    : QPageSize.PageSizeId = ... # 0x26
        JisB1                    : QPageSize.PageSizeId = ... # 0x27
        JisB2                    : QPageSize.PageSizeId = ... # 0x28
        JisB3                    : QPageSize.PageSizeId = ... # 0x29
        JisB4                    : QPageSize.PageSizeId = ... # 0x2a
        JisB5                    : QPageSize.PageSizeId = ... # 0x2b
        JisB6                    : QPageSize.PageSizeId = ... # 0x2c
        JisB7                    : QPageSize.PageSizeId = ... # 0x2d
        JisB8                    : QPageSize.PageSizeId = ... # 0x2e
        JisB9                    : QPageSize.PageSizeId = ... # 0x2f
        JisB10                   : QPageSize.PageSizeId = ... # 0x30
        AnsiC                    : QPageSize.PageSizeId = ... # 0x31
        AnsiD                    : QPageSize.PageSizeId = ... # 0x32
        AnsiE                    : QPageSize.PageSizeId = ... # 0x33
        LegalExtra               : QPageSize.PageSizeId = ... # 0x34
        LetterExtra              : QPageSize.PageSizeId = ... # 0x35
        LetterPlus               : QPageSize.PageSizeId = ... # 0x36
        LetterSmall              : QPageSize.PageSizeId = ... # 0x37
        TabloidExtra             : QPageSize.PageSizeId = ... # 0x38
        ArchA                    : QPageSize.PageSizeId = ... # 0x39
        ArchB                    : QPageSize.PageSizeId = ... # 0x3a
        ArchC                    : QPageSize.PageSizeId = ... # 0x3b
        ArchD                    : QPageSize.PageSizeId = ... # 0x3c
        ArchE                    : QPageSize.PageSizeId = ... # 0x3d
        Imperial7x9              : QPageSize.PageSizeId = ... # 0x3e
        Imperial8x10             : QPageSize.PageSizeId = ... # 0x3f
        Imperial9x11             : QPageSize.PageSizeId = ... # 0x40
        Imperial9x12             : QPageSize.PageSizeId = ... # 0x41
        Imperial10x11            : QPageSize.PageSizeId = ... # 0x42
        Imperial10x13            : QPageSize.PageSizeId = ... # 0x43
        Imperial10x14            : QPageSize.PageSizeId = ... # 0x44
        Imperial12x11            : QPageSize.PageSizeId = ... # 0x45
        Imperial15x11            : QPageSize.PageSizeId = ... # 0x46
        ExecutiveStandard        : QPageSize.PageSizeId = ... # 0x47
        Note                     : QPageSize.PageSizeId = ... # 0x48
        Quarto                   : QPageSize.PageSizeId = ... # 0x49
        Statement                : QPageSize.PageSizeId = ... # 0x4a
        SuperA                   : QPageSize.PageSizeId = ... # 0x4b
        SuperB                   : QPageSize.PageSizeId = ... # 0x4c
        Postcard                 : QPageSize.PageSizeId = ... # 0x4d
        DoublePostcard           : QPageSize.PageSizeId = ... # 0x4e
        Prc16K                   : QPageSize.PageSizeId = ... # 0x4f
        Prc32K                   : QPageSize.PageSizeId = ... # 0x50
        Prc32KBig                : QPageSize.PageSizeId = ... # 0x51
        FanFoldUS                : QPageSize.PageSizeId = ... # 0x52
        FanFoldGerman            : QPageSize.PageSizeId = ... # 0x53
        FanFoldGermanLegal       : QPageSize.PageSizeId = ... # 0x54
        EnvelopeB4               : QPageSize.PageSizeId = ... # 0x55
        EnvelopeB5               : QPageSize.PageSizeId = ... # 0x56
        EnvelopeB6               : QPageSize.PageSizeId = ... # 0x57
        EnvelopeC0               : QPageSize.PageSizeId = ... # 0x58
        EnvelopeC1               : QPageSize.PageSizeId = ... # 0x59
        EnvelopeC2               : QPageSize.PageSizeId = ... # 0x5a
        EnvelopeC3               : QPageSize.PageSizeId = ... # 0x5b
        EnvelopeC4               : QPageSize.PageSizeId = ... # 0x5c
        EnvelopeC6               : QPageSize.PageSizeId = ... # 0x5d
        EnvelopeC65              : QPageSize.PageSizeId = ... # 0x5e
        EnvelopeC7               : QPageSize.PageSizeId = ... # 0x5f
        Envelope9                : QPageSize.PageSizeId = ... # 0x60
        Envelope11               : QPageSize.PageSizeId = ... # 0x61
        Envelope12               : QPageSize.PageSizeId = ... # 0x62
        Envelope14               : QPageSize.PageSizeId = ... # 0x63
        EnvelopeMonarch          : QPageSize.PageSizeId = ... # 0x64
        EnvelopePersonal         : QPageSize.PageSizeId = ... # 0x65
        EnvelopeChou3            : QPageSize.PageSizeId = ... # 0x66
        EnvelopeChou4            : QPageSize.PageSizeId = ... # 0x67
        EnvelopeInvite           : QPageSize.PageSizeId = ... # 0x68
        EnvelopeItalian          : QPageSize.PageSizeId = ... # 0x69
        EnvelopeKaku2            : QPageSize.PageSizeId = ... # 0x6a
        EnvelopeKaku3            : QPageSize.PageSizeId = ... # 0x6b
        EnvelopePrc1             : QPageSize.PageSizeId = ... # 0x6c
        EnvelopePrc2             : QPageSize.PageSizeId = ... # 0x6d
        EnvelopePrc3             : QPageSize.PageSizeId = ... # 0x6e
        EnvelopePrc4             : QPageSize.PageSizeId = ... # 0x6f
        EnvelopePrc5             : QPageSize.PageSizeId = ... # 0x70
        EnvelopePrc6             : QPageSize.PageSizeId = ... # 0x71
        EnvelopePrc7             : QPageSize.PageSizeId = ... # 0x72
        EnvelopePrc8             : QPageSize.PageSizeId = ... # 0x73
        EnvelopePrc9             : QPageSize.PageSizeId = ... # 0x74
        EnvelopePrc10            : QPageSize.PageSizeId = ... # 0x75
        EnvelopeYou4             : QPageSize.PageSizeId = ... # 0x76
        LastPageSize             : QPageSize.PageSizeId = ... # 0x76
        NPageSize                : QPageSize.PageSizeId = ... # 0x76
        NPaperSize               : QPageSize.PageSizeId = ... # 0x76

    class SizeMatchPolicy(Shiboken.Enum):
        FuzzyMatch               : QPageSize.SizeMatchPolicy = ... # 0x0
        FuzzyOrientationMatch    : QPageSize.SizeMatchPolicy = ... # 0x1
        ExactMatch               : QPageSize.SizeMatchPolicy = ... # 0x2

    class Unit(Shiboken.Enum):
        Millimeter               : QPageSize.Unit = ... # 0x0
        Point                    : QPageSize.Unit = ... # 0x1
        Inch                     : QPageSize.Unit = ... # 0x2
        Pica                     : QPageSize.Unit = ... # 0x3
        Didot                    : QPageSize.Unit = ... # 0x4
        Cicero                   : QPageSize.Unit = ... # 0x5

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QPageSize) -> None: ...
    @typing.overload
    def __init__(self, pageSizeId: PySide2.QtGui.QPageSize.PageSizeId) -> None: ...
    @typing.overload
    def __init__(self, pointSize: PySide2.QtCore.QSize, name: str = ..., matchPolicy: PySide2.QtGui.QPageSize.SizeMatchPolicy = ...) -> None: ...
    @typing.overload
    def __init__(self, size: PySide2.QtCore.QSizeF, units: PySide2.QtGui.QPageSize.Unit, name: str = ..., matchPolicy: PySide2.QtGui.QPageSize.SizeMatchPolicy = ...) -> None: ...


class QPagedPaintDevice(PySide2.QtGui.QPaintDevice):
    A4                       : QPagedPaintDevice.PageSize = ... # 0x0
    B5                       : QPagedPaintDevice.PageSize = ... # 0x1
    AnsiA                    : QPagedPaintDevice.PageSize = ... # 0x2
    Letter                   : QPagedPaintDevice.PageSize = ... # 0x2
    Legal                    : QPagedPaintDevice.PageSize = ... # 0x3
    Executive                : QPagedPaintDevice.PageSize = ... # 0x4
    A0                       : QPagedPaintDevice.PageSize = ... # 0x5
    A1                       : QPagedPaintDevice.PageSize = ... # 0x6
    A2                       : QPagedPaintDevice.PageSize = ... # 0x7
    A3                       : QPagedPaintDevice.PageSize = ... # 0x8
    A5                       : QPagedPaintDevice.PageSize = ... # 0x9
    A6                       : QPagedPaintDevice.PageSize = ... # 0xa
    A7                       : QPagedPaintDevice.PageSize = ... # 0xb
    A8                       : QPagedPaintDevice.PageSize = ... # 0xc
    A9                       : QPagedPaintDevice.PageSize = ... # 0xd
    B0                       : QPagedPaintDevice.PageSize = ... # 0xe
    B1                       : QPagedPaintDevice.PageSize = ... # 0xf
    B10                      : QPagedPaintDevice.PageSize = ... # 0x10
    B2                       : QPagedPaintDevice.PageSize = ... # 0x11
    B3                       : QPagedPaintDevice.PageSize = ... # 0x12
    B4                       : QPagedPaintDevice.PageSize = ... # 0x13
    B6                       : QPagedPaintDevice.PageSize = ... # 0x14
    B7                       : QPagedPaintDevice.PageSize = ... # 0x15
    B8                       : QPagedPaintDevice.PageSize = ... # 0x16
    B9                       : QPagedPaintDevice.PageSize = ... # 0x17
    C5E                      : QPagedPaintDevice.PageSize = ... # 0x18
    EnvelopeC5               : QPagedPaintDevice.PageSize = ... # 0x18
    Comm10E                  : QPagedPaintDevice.PageSize = ... # 0x19
    Envelope10               : QPagedPaintDevice.PageSize = ... # 0x19
    DLE                      : QPagedPaintDevice.PageSize = ... # 0x1a
    EnvelopeDL               : QPagedPaintDevice.PageSize = ... # 0x1a
    Folio                    : QPagedPaintDevice.PageSize = ... # 0x1b
    AnsiB                    : QPagedPaintDevice.PageSize = ... # 0x1c
    Ledger                   : QPagedPaintDevice.PageSize = ... # 0x1c
    Tabloid                  : QPagedPaintDevice.PageSize = ... # 0x1d
    Custom                   : QPagedPaintDevice.PageSize = ... # 0x1e
    A10                      : QPagedPaintDevice.PageSize = ... # 0x1f
    A3Extra                  : QPagedPaintDevice.PageSize = ... # 0x20
    A4Extra                  : QPagedPaintDevice.PageSize = ... # 0x21
    A4Plus                   : QPagedPaintDevice.PageSize = ... # 0x22
    A4Small                  : QPagedPaintDevice.PageSize = ... # 0x23
    A5Extra                  : QPagedPaintDevice.PageSize = ... # 0x24
    B5Extra                  : QPagedPaintDevice.PageSize = ... # 0x25
    JisB0                    : QPagedPaintDevice.PageSize = ... # 0x26
    JisB1                    : QPagedPaintDevice.PageSize = ... # 0x27
    JisB2                    : QPagedPaintDevice.PageSize = ... # 0x28
    JisB3                    : QPagedPaintDevice.PageSize = ... # 0x29
    JisB4                    : QPagedPaintDevice.PageSize = ... # 0x2a
    JisB5                    : QPagedPaintDevice.PageSize = ... # 0x2b
    JisB6                    : QPagedPaintDevice.PageSize = ... # 0x2c
    JisB7                    : QPagedPaintDevice.PageSize = ... # 0x2d
    JisB8                    : QPagedPaintDevice.PageSize = ... # 0x2e
    JisB9                    : QPagedPaintDevice.PageSize = ... # 0x2f
    JisB10                   : QPagedPaintDevice.PageSize = ... # 0x30
    AnsiC                    : QPagedPaintDevice.PageSize = ... # 0x31
    AnsiD                    : QPagedPaintDevice.PageSize = ... # 0x32
    AnsiE                    : QPagedPaintDevice.PageSize = ... # 0x33
    LegalExtra               : QPagedPaintDevice.PageSize = ... # 0x34
    LetterExtra              : QPagedPaintDevice.PageSize = ... # 0x35
    LetterPlus               : QPagedPaintDevice.PageSize = ... # 0x36
    LetterSmall              : QPagedPaintDevice.PageSize = ... # 0x37
    TabloidExtra             : QPagedPaintDevice.PageSize = ... # 0x38
    ArchA                    : QPagedPaintDevice.PageSize = ... # 0x39
    ArchB                    : QPagedPaintDevice.PageSize = ... # 0x3a
    ArchC                    : QPagedPaintDevice.PageSize = ... # 0x3b
    ArchD                    : QPagedPaintDevice.PageSize = ... # 0x3c
    ArchE                    : QPagedPaintDevice.PageSize = ... # 0x3d
    Imperial7x9              : QPagedPaintDevice.PageSize = ... # 0x3e
    Imperial8x10             : QPagedPaintDevice.PageSize = ... # 0x3f
    Imperial9x11             : QPagedPaintDevice.PageSize = ... # 0x40
    Imperial9x12             : QPagedPaintDevice.PageSize = ... # 0x41
    Imperial10x11            : QPagedPaintDevice.PageSize = ... # 0x42
    Imperial10x13            : QPagedPaintDevice.PageSize = ... # 0x43
    Imperial10x14            : QPagedPaintDevice.PageSize = ... # 0x44
    Imperial12x11            : QPagedPaintDevice.PageSize = ... # 0x45
    Imperial15x11            : QPagedPaintDevice.PageSize = ... # 0x46
    ExecutiveStandard        : QPagedPaintDevice.PageSize = ... # 0x47
    Note                     : QPagedPaintDevice.PageSize = ... # 0x48
    Quarto                   : QPagedPaintDevice.PageSize = ... # 0x49
    Statement                : QPagedPaintDevice.PageSize = ... # 0x4a
    SuperA                   : QPagedPaintDevice.PageSize = ... # 0x4b
    SuperB                   : QPagedPaintDevice.PageSize = ... # 0x4c
    Postcard                 : QPagedPaintDevice.PageSize = ... # 0x4d
    DoublePostcard           : QPagedPaintDevice.PageSize = ... # 0x4e
    Prc16K                   : QPagedPaintDevice.PageSize = ... # 0x4f
    Prc32K                   : QPagedPaintDevice.PageSize = ... # 0x50
    Prc32KBig                : QPagedPaintDevice.PageSize = ... # 0x51
    FanFoldUS                : QPagedPaintDevice.PageSize = ... # 0x52
    FanFoldGerman            : QPagedPaintDevice.PageSize = ... # 0x53
    FanFoldGermanLegal       : QPagedPaintDevice.PageSize = ... # 0x54
    EnvelopeB4               : QPagedPaintDevice.PageSize = ... # 0x55
    EnvelopeB5               : QPagedPaintDevice.PageSize = ... # 0x56
    EnvelopeB6               : QPagedPaintDevice.PageSize = ... # 0x57
    EnvelopeC0               : QPagedPaintDevice.PageSize = ... # 0x58
    EnvelopeC1               : QPagedPaintDevice.PageSize = ... # 0x59
    EnvelopeC2               : QPagedPaintDevice.PageSize = ... # 0x5a
    EnvelopeC3               : QPagedPaintDevice.PageSize = ... # 0x5b
    EnvelopeC4               : QPagedPaintDevice.PageSize = ... # 0x5c
    EnvelopeC6               : QPagedPaintDevice.PageSize = ... # 0x5d
    EnvelopeC65              : QPagedPaintDevice.PageSize = ... # 0x5e
    EnvelopeC7               : QPagedPaintDevice.PageSize = ... # 0x5f
    Envelope9                : QPagedPaintDevice.PageSize = ... # 0x60
    Envelope11               : QPagedPaintDevice.PageSize = ... # 0x61
    Envelope12               : QPagedPaintDevice.PageSize = ... # 0x62
    Envelope14               : QPagedPaintDevice.PageSize = ... # 0x63
    EnvelopeMonarch          : QPagedPaintDevice.PageSize = ... # 0x64
    EnvelopePersonal         : QPagedPaintDevice.PageSize = ... # 0x65
    EnvelopeChou3            : QPagedPaintDevice.PageSize = ... # 0x66
    EnvelopeChou4            : QPagedPaintDevice.PageSize = ... # 0x67
    EnvelopeInvite           : QPagedPaintDevice.PageSize = ... # 0x68
    EnvelopeItalian          : QPagedPaintDevice.PageSize = ... # 0x69
    EnvelopeKaku2            : QPagedPaintDevice.PageSize = ... # 0x6a
    EnvelopeKaku3            : QPagedPaintDevice.PageSize = ... # 0x6b
    EnvelopePrc1             : QPagedPaintDevice.PageSize = ... # 0x6c
    EnvelopePrc2             : QPagedPaintDevice.PageSize = ... # 0x6d
    EnvelopePrc3             : QPagedPaintDevice.PageSize = ... # 0x6e
    EnvelopePrc4             : QPagedPaintDevice.PageSize = ... # 0x6f
    EnvelopePrc5             : QPagedPaintDevice.PageSize = ... # 0x70
    EnvelopePrc6             : QPagedPaintDevice.PageSize = ... # 0x71
    EnvelopePrc7             : QPagedPaintDevice.PageSize = ... # 0x72
    EnvelopePrc8             : QPagedPaintDevice.PageSize = ... # 0x73
    EnvelopePrc9             : QPagedPaintDevice.PageSize = ... # 0x74
    EnvelopePrc10            : QPagedPaintDevice.PageSize = ... # 0x75
    EnvelopeYou4             : QPagedPaintDevice.PageSize = ... # 0x76
    LastPageSize             : QPagedPaintDevice.PageSize = ... # 0x76
    NPageSize                : QPagedPaintDevice.PageSize = ... # 0x76
    NPaperSize               : QPagedPaintDevice.PageSize = ... # 0x76
    PdfVersion_1_4           : QPagedPaintDevice.PdfVersion = ... # 0x0
    PdfVersion_A1b           : QPagedPaintDevice.PdfVersion = ... # 0x1
    PdfVersion_1_6           : QPagedPaintDevice.PdfVersion = ... # 0x2

    class Margins(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, Margins: PySide2.QtGui.QPagedPaintDevice.Margins) -> None: ...


    class PageSize(Shiboken.Enum):
        A4                       : QPagedPaintDevice.PageSize = ... # 0x0
        B5                       : QPagedPaintDevice.PageSize = ... # 0x1
        AnsiA                    : QPagedPaintDevice.PageSize = ... # 0x2
        Letter                   : QPagedPaintDevice.PageSize = ... # 0x2
        Legal                    : QPagedPaintDevice.PageSize = ... # 0x3
        Executive                : QPagedPaintDevice.PageSize = ... # 0x4
        A0                       : QPagedPaintDevice.PageSize = ... # 0x5
        A1                       : QPagedPaintDevice.PageSize = ... # 0x6
        A2                       : QPagedPaintDevice.PageSize = ... # 0x7
        A3                       : QPagedPaintDevice.PageSize = ... # 0x8
        A5                       : QPagedPaintDevice.PageSize = ... # 0x9
        A6                       : QPagedPaintDevice.PageSize = ... # 0xa
        A7                       : QPagedPaintDevice.PageSize = ... # 0xb
        A8                       : QPagedPaintDevice.PageSize = ... # 0xc
        A9                       : QPagedPaintDevice.PageSize = ... # 0xd
        B0                       : QPagedPaintDevice.PageSize = ... # 0xe
        B1                       : QPagedPaintDevice.PageSize = ... # 0xf
        B10                      : QPagedPaintDevice.PageSize = ... # 0x10
        B2                       : QPagedPaintDevice.PageSize = ... # 0x11
        B3                       : QPagedPaintDevice.PageSize = ... # 0x12
        B4                       : QPagedPaintDevice.PageSize = ... # 0x13
        B6                       : QPagedPaintDevice.PageSize = ... # 0x14
        B7                       : QPagedPaintDevice.PageSize = ... # 0x15
        B8                       : QPagedPaintDevice.PageSize = ... # 0x16
        B9                       : QPagedPaintDevice.PageSize = ... # 0x17
        C5E                      : QPagedPaintDevice.PageSize = ... # 0x18
        EnvelopeC5               : QPagedPaintDevice.PageSize = ... # 0x18
        Comm10E                  : QPagedPaintDevice.PageSize = ... # 0x19
        Envelope10               : QPagedPaintDevice.PageSize = ... # 0x19
        DLE                      : QPagedPaintDevice.PageSize = ... # 0x1a
        EnvelopeDL               : QPagedPaintDevice.PageSize = ... # 0x1a
        Folio                    : QPagedPaintDevice.PageSize = ... # 0x1b
        AnsiB                    : QPagedPaintDevice.PageSize = ... # 0x1c
        Ledger                   : QPagedPaintDevice.PageSize = ... # 0x1c
        Tabloid                  : QPagedPaintDevice.PageSize = ... # 0x1d
        Custom                   : QPagedPaintDevice.PageSize = ... # 0x1e
        A10                      : QPagedPaintDevice.PageSize = ... # 0x1f
        A3Extra                  : QPagedPaintDevice.PageSize = ... # 0x20
        A4Extra                  : QPagedPaintDevice.PageSize = ... # 0x21
        A4Plus                   : QPagedPaintDevice.PageSize = ... # 0x22
        A4Small                  : QPagedPaintDevice.PageSize = ... # 0x23
        A5Extra                  : QPagedPaintDevice.PageSize = ... # 0x24
        B5Extra                  : QPagedPaintDevice.PageSize = ... # 0x25
        JisB0                    : QPagedPaintDevice.PageSize = ... # 0x26
        JisB1                    : QPagedPaintDevice.PageSize = ... # 0x27
        JisB2                    : QPagedPaintDevice.PageSize = ... # 0x28
        JisB3                    : QPagedPaintDevice.PageSize = ... # 0x29
        JisB4                    : QPagedPaintDevice.PageSize = ... # 0x2a
        JisB5                    : QPagedPaintDevice.PageSize = ... # 0x2b
        JisB6                    : QPagedPaintDevice.PageSize = ... # 0x2c
        JisB7                    : QPagedPaintDevice.PageSize = ... # 0x2d
        JisB8                    : QPagedPaintDevice.PageSize = ... # 0x2e
        JisB9                    : QPagedPaintDevice.PageSize = ... # 0x2f
        JisB10                   : QPagedPaintDevice.PageSize = ... # 0x30
        AnsiC                    : QPagedPaintDevice.PageSize = ... # 0x31
        AnsiD                    : QPagedPaintDevice.PageSize = ... # 0x32
        AnsiE                    : QPagedPaintDevice.PageSize = ... # 0x33
        LegalExtra               : QPagedPaintDevice.PageSize = ... # 0x34
        LetterExtra              : QPagedPaintDevice.PageSize = ... # 0x35
        LetterPlus               : QPagedPaintDevice.PageSize = ... # 0x36
        LetterSmall              : QPagedPaintDevice.PageSize = ... # 0x37
        TabloidExtra             : QPagedPaintDevice.PageSize = ... # 0x38
        ArchA                    : QPagedPaintDevice.PageSize = ... # 0x39
        ArchB                    : QPagedPaintDevice.PageSize = ... # 0x3a
        ArchC                    : QPagedPaintDevice.PageSize = ... # 0x3b
        ArchD                    : QPagedPaintDevice.PageSize = ... # 0x3c
        ArchE                    : QPagedPaintDevice.PageSize = ... # 0x3d
        Imperial7x9              : QPagedPaintDevice.PageSize = ... # 0x3e
        Imperial8x10             : QPagedPaintDevice.PageSize = ... # 0x3f
        Imperial9x11             : QPagedPaintDevice.PageSize = ... # 0x40
        Imperial9x12             : QPagedPaintDevice.PageSize = ... # 0x41
        Imperial10x11            : QPagedPaintDevice.PageSize = ... # 0x42
        Imperial10x13            : QPagedPaintDevice.PageSize = ... # 0x43
        Imperial10x14            : QPagedPaintDevice.PageSize = ... # 0x44
        Imperial12x11            : QPagedPaintDevice.PageSize = ... # 0x45
        Imperial15x11            : QPagedPaintDevice.PageSize = ... # 0x46
        ExecutiveStandard        : QPagedPaintDevice.PageSize = ... # 0x47
        Note                     : QPagedPaintDevice.PageSize = ... # 0x48
        Quarto                   : QPagedPaintDevice.PageSize = ... # 0x49
        Statement                : QPagedPaintDevice.PageSize = ... # 0x4a
        SuperA                   : QPagedPaintDevice.PageSize = ... # 0x4b
        SuperB                   : QPagedPaintDevice.PageSize = ... # 0x4c
        Postcard                 : QPagedPaintDevice.PageSize = ... # 0x4d
        DoublePostcard           : QPagedPaintDevice.PageSize = ... # 0x4e
        Prc16K                   : QPagedPaintDevice.PageSize = ... # 0x4f
        Prc32K                   : QPagedPaintDevice.PageSize = ... # 0x50
        Prc32KBig                : QPagedPaintDevice.PageSize = ... # 0x51
        FanFoldUS                : QPagedPaintDevice.PageSize = ... # 0x52
        FanFoldGerman            : QPagedPaintDevice.PageSize = ... # 0x53
        FanFoldGermanLegal       : QPagedPaintDevice.PageSize = ... # 0x54
        EnvelopeB4               : QPagedPaintDevice.PageSize = ... # 0x55
        EnvelopeB5               : QPagedPaintDevice.PageSize = ... # 0x56
        EnvelopeB6               : QPagedPaintDevice.PageSize = ... # 0x57
        EnvelopeC0               : QPagedPaintDevice.PageSize = ... # 0x58
        EnvelopeC1               : QPagedPaintDevice.PageSize = ... # 0x59
        EnvelopeC2               : QPagedPaintDevice.PageSize = ... # 0x5a
        EnvelopeC3               : QPagedPaintDevice.PageSize = ... # 0x5b
        EnvelopeC4               : QPagedPaintDevice.PageSize = ... # 0x5c
        EnvelopeC6               : QPagedPaintDevice.PageSize = ... # 0x5d
        EnvelopeC65              : QPagedPaintDevice.PageSize = ... # 0x5e
        EnvelopeC7               : QPagedPaintDevice.PageSize = ... # 0x5f
        Envelope9                : QPagedPaintDevice.PageSize = ... # 0x60
        Envelope11               : QPagedPaintDevice.PageSize = ... # 0x61
        Envelope12               : QPagedPaintDevice.PageSize = ... # 0x62
        Envelope14               : QPagedPaintDevice.PageSize = ... # 0x63
        EnvelopeMonarch          : QPagedPaintDevice.PageSize = ... # 0x64
        EnvelopePersonal         : QPagedPaintDevice.PageSize = ... # 0x65
        EnvelopeChou3            : QPagedPaintDevice.PageSize = ... # 0x66
        EnvelopeChou4            : QPagedPaintDevice.PageSize = ... # 0x67
        EnvelopeInvite           : QPagedPaintDevice.PageSize = ... # 0x68
        EnvelopeItalian          : QPagedPaintDevice.PageSize = ... # 0x69
        EnvelopeKaku2            : QPagedPaintDevice.PageSize = ... # 0x6a
        EnvelopeKaku3            : QPagedPaintDevice.PageSize = ... # 0x6b
        EnvelopePrc1             : QPagedPaintDevice.PageSize = ... # 0x6c
        EnvelopePrc2             : QPagedPaintDevice.PageSize = ... # 0x6d
        EnvelopePrc3             : QPagedPaintDevice.PageSize = ... # 0x6e
        EnvelopePrc4             : QPagedPaintDevice.PageSize = ... # 0x6f
        EnvelopePrc5             : QPagedPaintDevice.PageSize = ... # 0x70
        EnvelopePrc6             : QPagedPaintDevice.PageSize = ... # 0x71
        EnvelopePrc7             : QPagedPaintDevice.PageSize = ... # 0x72
        EnvelopePrc8             : QPagedPaintDevice.PageSize = ... # 0x73
        EnvelopePrc9             : QPagedPaintDevice.PageSize = ... # 0x74
        EnvelopePrc10            : QPagedPaintDevice.PageSize = ... # 0x75
        EnvelopeYou4             : QPagedPaintDevice.PageSize = ... # 0x76
        LastPageSize             : QPagedPaintDevice.PageSize = ... # 0x76
        NPageSize                : QPagedPaintDevice.PageSize = ... # 0x76
        NPaperSize               : QPagedPaintDevice.PageSize = ... # 0x76

    class PdfVersion(Shiboken.Enum):
        PdfVersion_1_4           : QPagedPaintDevice.PdfVersion = ... # 0x0
        PdfVersion_A1b           : QPagedPaintDevice.PdfVersion = ... # 0x1
        PdfVersion_1_6           : QPagedPaintDevice.PdfVersion = ... # 0x2

    def __init__(self) -> None: ...


class QPaintDevice(Shiboken.Object):
    PdmWidth                 : QPaintDevice.PaintDeviceMetric = ... # 0x1
    PdmHeight                : QPaintDevice.PaintDeviceMetric = ... # 0x2
    PdmWidthMM               : QPaintDevice.PaintDeviceMetric = ... # 0x3
    PdmHeightMM              : QPaintDevice.PaintDeviceMetric = ... # 0x4
    PdmNumColors             : QPaintDevice.PaintDeviceMetric = ... # 0x5
    PdmDepth                 : QPaintDevice.PaintDeviceMetric = ... # 0x6
    PdmDpiX                  : QPaintDevice.PaintDeviceMetric = ... # 0x7
    PdmDpiY                  : QPaintDevice.PaintDeviceMetric = ... # 0x8
    PdmPhysicalDpiX          : QPaintDevice.PaintDeviceMetric = ... # 0x9
    PdmPhysicalDpiY          : QPaintDevice.PaintDeviceMetric = ... # 0xa
    PdmDevicePixelRatio      : QPaintDevice.PaintDeviceMetric = ... # 0xb
    PdmDevicePixelRatioScaled: QPaintDevice.PaintDeviceMetric = ... # 0xc

    class PaintDeviceMetric(Shiboken.Enum):
        PdmWidth                 : QPaintDevice.PaintDeviceMetric = ... # 0x1
        PdmHeight                : QPaintDevice.PaintDeviceMetric = ... # 0x2
        PdmWidthMM               : QPaintDevice.PaintDeviceMetric = ... # 0x3
        PdmHeightMM              : QPaintDevice.PaintDeviceMetric = ... # 0x4
        PdmNumColors             : QPaintDevice.PaintDeviceMetric = ... # 0x5
        PdmDepth                 : QPaintDevice.PaintDeviceMetric = ... # 0x6
        PdmDpiX                  : QPaintDevice.PaintDeviceMetric = ... # 0x7
        PdmDpiY                  : QPaintDevice.PaintDeviceMetric = ... # 0x8
        PdmPhysicalDpiX          : QPaintDevice.PaintDeviceMetric = ... # 0x9
        PdmPhysicalDpiY          : QPaintDevice.PaintDeviceMetric = ... # 0xa
        PdmDevicePixelRatio      : QPaintDevice.PaintDeviceMetric = ... # 0xb
        PdmDevicePixelRatioScaled: QPaintDevice.PaintDeviceMetric = ... # 0xc

    def __init__(self) -> None: ...


class QPaintDeviceWindow(PySide2.QtGui.QWindow, PySide2.QtGui.QPaintDevice): ...


class QPaintEngine(Shiboken.Object):
    DirtyPen                 : QPaintEngine.DirtyFlag = ... # 0x1
    DirtyBrush               : QPaintEngine.DirtyFlag = ... # 0x2
    DirtyBrushOrigin         : QPaintEngine.DirtyFlag = ... # 0x4
    DirtyFont                : QPaintEngine.DirtyFlag = ... # 0x8
    DirtyBackground          : QPaintEngine.DirtyFlag = ... # 0x10
    DirtyBackgroundMode      : QPaintEngine.DirtyFlag = ... # 0x20
    DirtyTransform           : QPaintEngine.DirtyFlag = ... # 0x40
    DirtyClipRegion          : QPaintEngine.DirtyFlag = ... # 0x80
    DirtyClipPath            : QPaintEngine.DirtyFlag = ... # 0x100
    DirtyHints               : QPaintEngine.DirtyFlag = ... # 0x200
    DirtyCompositionMode     : QPaintEngine.DirtyFlag = ... # 0x400
    DirtyClipEnabled         : QPaintEngine.DirtyFlag = ... # 0x800
    DirtyOpacity             : QPaintEngine.DirtyFlag = ... # 0x1000
    AllDirty                 : QPaintEngine.DirtyFlag = ... # 0xffff
    PrimitiveTransform       : QPaintEngine.PaintEngineFeature = ... # 0x1
    PatternTransform         : QPaintEngine.PaintEngineFeature = ... # 0x2
    PixmapTransform          : QPaintEngine.PaintEngineFeature = ... # 0x4
    PatternBrush             : QPaintEngine.PaintEngineFeature = ... # 0x8
    LinearGradientFill       : QPaintEngine.PaintEngineFeature = ... # 0x10
    RadialGradientFill       : QPaintEngine.PaintEngineFeature = ... # 0x20
    ConicalGradientFill      : QPaintEngine.PaintEngineFeature = ... # 0x40
    AlphaBlend               : QPaintEngine.PaintEngineFeature = ... # 0x80
    PorterDuff               : QPaintEngine.PaintEngineFeature = ... # 0x100
    PainterPaths             : QPaintEngine.PaintEngineFeature = ... # 0x200
    Antialiasing             : QPaintEngine.PaintEngineFeature = ... # 0x400
    BrushStroke              : QPaintEngine.PaintEngineFeature = ... # 0x800
    ConstantOpacity          : QPaintEngine.PaintEngineFeature = ... # 0x1000
    MaskedBrush              : QPaintEngine.PaintEngineFeature = ... # 0x2000
    PerspectiveTransform     : QPaintEngine.PaintEngineFeature = ... # 0x4000
    BlendModes               : QPaintEngine.PaintEngineFeature = ... # 0x8000
    ObjectBoundingModeGradients: QPaintEngine.PaintEngineFeature = ... # 0x10000
    RasterOpModes            : QPaintEngine.PaintEngineFeature = ... # 0x20000
    PaintOutsidePaintEvent   : QPaintEngine.PaintEngineFeature = ... # 0x20000000
    AllFeatures              : QPaintEngine.PaintEngineFeature = ... # -0x1
    OddEvenMode              : QPaintEngine.PolygonDrawMode = ... # 0x0
    WindingMode              : QPaintEngine.PolygonDrawMode = ... # 0x1
    ConvexMode               : QPaintEngine.PolygonDrawMode = ... # 0x2
    PolylineMode             : QPaintEngine.PolygonDrawMode = ... # 0x3
    X11                      : QPaintEngine.Type = ... # 0x0
    Windows                  : QPaintEngine.Type = ... # 0x1
    QuickDraw                : QPaintEngine.Type = ... # 0x2
    CoreGraphics             : QPaintEngine.Type = ... # 0x3
    MacPrinter               : QPaintEngine.Type = ... # 0x4
    QWindowSystem            : QPaintEngine.Type = ... # 0x5
    PostScript               : QPaintEngine.Type = ... # 0x6
    OpenGL                   : QPaintEngine.Type = ... # 0x7
    Picture                  : QPaintEngine.Type = ... # 0x8
    SVG                      : QPaintEngine.Type = ... # 0x9
    Raster                   : QPaintEngine.Type = ... # 0xa
    Direct3D                 : QPaintEngine.Type = ... # 0xb
    Pdf                      : QPaintEngine.Type = ... # 0xc
    OpenVG                   : QPaintEngine.Type = ... # 0xd
    OpenGL2                  : QPaintEngine.Type = ... # 0xe
    PaintBuffer              : QPaintEngine.Type = ... # 0xf
    Blitter                  : QPaintEngine.Type = ... # 0x10
    Direct2D                 : QPaintEngine.Type = ... # 0x11
    User                     : QPaintEngine.Type = ... # 0x32
    MaxUser                  : QPaintEngine.Type = ... # 0x64

    class DirtyFlag(Shiboken.Enum):
        DirtyPen                 : QPaintEngine.DirtyFlag = ... # 0x1
        DirtyBrush               : QPaintEngine.DirtyFlag = ... # 0x2
        DirtyBrushOrigin         : QPaintEngine.DirtyFlag = ... # 0x4
        DirtyFont                : QPaintEngine.DirtyFlag = ... # 0x8
        DirtyBackground          : QPaintEngine.DirtyFlag = ... # 0x10
        DirtyBackgroundMode      : QPaintEngine.DirtyFlag = ... # 0x20
        DirtyTransform           : QPaintEngine.DirtyFlag = ... # 0x40
        DirtyClipRegion          : QPaintEngine.DirtyFlag = ... # 0x80
        DirtyClipPath            : QPaintEngine.DirtyFlag = ... # 0x100
        DirtyHints               : QPaintEngine.DirtyFlag = ... # 0x200
        DirtyCompositionMode     : QPaintEngine.DirtyFlag = ... # 0x400
        DirtyClipEnabled         : QPaintEngine.DirtyFlag = ... # 0x800
        DirtyOpacity             : QPaintEngine.DirtyFlag = ... # 0x1000
        AllDirty                 : QPaintEngine.DirtyFlag = ... # 0xffff

    class DirtyFlags(object): ...

    class PaintEngineFeature(Shiboken.Enum):
        PrimitiveTransform       : QPaintEngine.PaintEngineFeature = ... # 0x1
        PatternTransform         : QPaintEngine.PaintEngineFeature = ... # 0x2
        PixmapTransform          : QPaintEngine.PaintEngineFeature = ... # 0x4
        PatternBrush             : QPaintEngine.PaintEngineFeature = ... # 0x8
        LinearGradientFill       : QPaintEngine.PaintEngineFeature = ... # 0x10
        RadialGradientFill       : QPaintEngine.PaintEngineFeature = ... # 0x20
        ConicalGradientFill      : QPaintEngine.PaintEngineFeature = ... # 0x40
        AlphaBlend               : QPaintEngine.PaintEngineFeature = ... # 0x80
        PorterDuff               : QPaintEngine.PaintEngineFeature = ... # 0x100
        PainterPaths             : QPaintEngine.PaintEngineFeature = ... # 0x200
        Antialiasing             : QPaintEngine.PaintEngineFeature = ... # 0x400
        BrushStroke              : QPaintEngine.PaintEngineFeature = ... # 0x800
        ConstantOpacity          : QPaintEngine.PaintEngineFeature = ... # 0x1000
        MaskedBrush              : QPaintEngine.PaintEngineFeature = ... # 0x2000
        PerspectiveTransform     : QPaintEngine.PaintEngineFeature = ... # 0x4000
        BlendModes               : QPaintEngine.PaintEngineFeature = ... # 0x8000
        ObjectBoundingModeGradients: QPaintEngine.PaintEngineFeature = ... # 0x10000
        RasterOpModes            : QPaintEngine.PaintEngineFeature = ... # 0x20000
        PaintOutsidePaintEvent   : QPaintEngine.PaintEngineFeature = ... # 0x20000000
        AllFeatures              : QPaintEngine.PaintEngineFeature = ... # -0x1

    class PaintEngineFeatures(object): ...

    class PolygonDrawMode(Shiboken.Enum):
        OddEvenMode              : QPaintEngine.PolygonDrawMode = ... # 0x0
        WindingMode              : QPaintEngine.PolygonDrawMode = ... # 0x1
        ConvexMode               : QPaintEngine.PolygonDrawMode = ... # 0x2
        PolylineMode             : QPaintEngine.PolygonDrawMode = ... # 0x3

    class Type(Shiboken.Enum):
        X11                      : QPaintEngine.Type = ... # 0x0
        Windows                  : QPaintEngine.Type = ... # 0x1
        QuickDraw                : QPaintEngine.Type = ... # 0x2
        CoreGraphics             : QPaintEngine.Type = ... # 0x3
        MacPrinter               : QPaintEngine.Type = ... # 0x4
        QWindowSystem            : QPaintEngine.Type = ... # 0x5
        PostScript               : QPaintEngine.Type = ... # 0x6
        OpenGL                   : QPaintEngine.Type = ... # 0x7
        Picture                  : QPaintEngine.Type = ... # 0x8
        SVG                      : QPaintEngine.Type = ... # 0x9
        Raster                   : QPaintEngine.Type = ... # 0xa
        Direct3D                 : QPaintEngine.Type = ... # 0xb
        Pdf                      : QPaintEngine.Type = ... # 0xc
        OpenVG                   : QPaintEngine.Type = ... # 0xd
        OpenGL2                  : QPaintEngine.Type = ... # 0xe
        PaintBuffer              : QPaintEngine.Type = ... # 0xf
        Blitter                  : QPaintEngine.Type = ... # 0x10
        Direct2D                 : QPaintEngine.Type = ... # 0x11
        User                     : QPaintEngine.Type = ... # 0x32
        MaxUser                  : QPaintEngine.Type = ... # 0x64

    def __init__(self, features: PySide2.QtGui.QPaintEngine.PaintEngineFeatures = ...) -> None: ...


class QPaintEngineState(Shiboken.Object):

    def __init__(self) -> None: ...


class QPaintEvent(PySide2.QtCore.QEvent):

    @typing.overload
    def __init__(self, paintRect: PySide2.QtCore.QRect) -> None: ...
    @typing.overload
    def __init__(self, paintRegion: PySide2.QtGui.QRegion) -> None: ...


class QPainter(Shiboken.Object):
    CompositionMode_SourceOver: QPainter.CompositionMode = ... # 0x0
    CompositionMode_DestinationOver: QPainter.CompositionMode = ... # 0x1
    CompositionMode_Clear    : QPainter.CompositionMode = ... # 0x2
    CompositionMode_Source   : QPainter.CompositionMode = ... # 0x3
    CompositionMode_Destination: QPainter.CompositionMode = ... # 0x4
    CompositionMode_SourceIn : QPainter.CompositionMode = ... # 0x5
    CompositionMode_DestinationIn: QPainter.CompositionMode = ... # 0x6
    CompositionMode_SourceOut: QPainter.CompositionMode = ... # 0x7
    CompositionMode_DestinationOut: QPainter.CompositionMode = ... # 0x8
    CompositionMode_SourceAtop: QPainter.CompositionMode = ... # 0x9
    CompositionMode_DestinationAtop: QPainter.CompositionMode = ... # 0xa
    CompositionMode_Xor      : QPainter.CompositionMode = ... # 0xb
    CompositionMode_Plus     : QPainter.CompositionMode = ... # 0xc
    CompositionMode_Multiply : QPainter.CompositionMode = ... # 0xd
    CompositionMode_Screen   : QPainter.CompositionMode = ... # 0xe
    CompositionMode_Overlay  : QPainter.CompositionMode = ... # 0xf
    CompositionMode_Darken   : QPainter.CompositionMode = ... # 0x10
    CompositionMode_Lighten  : QPainter.CompositionMode = ... # 0x11
    CompositionMode_ColorDodge: QPainter.CompositionMode = ... # 0x12
    CompositionMode_ColorBurn: QPainter.CompositionMode = ... # 0x13
    CompositionMode_HardLight: QPainter.CompositionMode = ... # 0x14
    CompositionMode_SoftLight: QPainter.CompositionMode = ... # 0x15
    CompositionMode_Difference: QPainter.CompositionMode = ... # 0x16
    CompositionMode_Exclusion: QPainter.CompositionMode = ... # 0x17
    RasterOp_SourceOrDestination: QPainter.CompositionMode = ... # 0x18
    RasterOp_SourceAndDestination: QPainter.CompositionMode = ... # 0x19
    RasterOp_SourceXorDestination: QPainter.CompositionMode = ... # 0x1a
    RasterOp_NotSourceAndNotDestination: QPainter.CompositionMode = ... # 0x1b
    RasterOp_NotSourceOrNotDestination: QPainter.CompositionMode = ... # 0x1c
    RasterOp_NotSourceXorDestination: QPainter.CompositionMode = ... # 0x1d
    RasterOp_NotSource       : QPainter.CompositionMode = ... # 0x1e
    RasterOp_NotSourceAndDestination: QPainter.CompositionMode = ... # 0x1f
    RasterOp_SourceAndNotDestination: QPainter.CompositionMode = ... # 0x20
    RasterOp_NotSourceOrDestination: QPainter.CompositionMode = ... # 0x21
    RasterOp_SourceOrNotDestination: QPainter.CompositionMode = ... # 0x22
    RasterOp_ClearDestination: QPainter.CompositionMode = ... # 0x23
    RasterOp_SetDestination  : QPainter.CompositionMode = ... # 0x24
    RasterOp_NotDestination  : QPainter.CompositionMode = ... # 0x25
    OpaqueHint               : QPainter.PixmapFragmentHint = ... # 0x1
    Antialiasing             : QPainter.RenderHint = ... # 0x1
    TextAntialiasing         : QPainter.RenderHint = ... # 0x2
    SmoothPixmapTransform    : QPainter.RenderHint = ... # 0x4
    HighQualityAntialiasing  : QPainter.RenderHint = ... # 0x8
    NonCosmeticDefaultPen    : QPainter.RenderHint = ... # 0x10
    Qt4CompatiblePainting    : QPainter.RenderHint = ... # 0x20
    LosslessImageRendering   : QPainter.RenderHint = ... # 0x40

    class CompositionMode(Shiboken.Enum):
        CompositionMode_SourceOver: QPainter.CompositionMode = ... # 0x0
        CompositionMode_DestinationOver: QPainter.CompositionMode = ... # 0x1
        CompositionMode_Clear    : QPainter.CompositionMode = ... # 0x2
        CompositionMode_Source   : QPainter.CompositionMode = ... # 0x3
        CompositionMode_Destination: QPainter.CompositionMode = ... # 0x4
        CompositionMode_SourceIn : QPainter.CompositionMode = ... # 0x5
        CompositionMode_DestinationIn: QPainter.CompositionMode = ... # 0x6
        CompositionMode_SourceOut: QPainter.CompositionMode = ... # 0x7
        CompositionMode_DestinationOut: QPainter.CompositionMode = ... # 0x8
        CompositionMode_SourceAtop: QPainter.CompositionMode = ... # 0x9
        CompositionMode_DestinationAtop: QPainter.CompositionMode = ... # 0xa
        CompositionMode_Xor      : QPainter.CompositionMode = ... # 0xb
        CompositionMode_Plus     : QPainter.CompositionMode = ... # 0xc
        CompositionMode_Multiply : QPainter.CompositionMode = ... # 0xd
        CompositionMode_Screen   : QPainter.CompositionMode = ... # 0xe
        CompositionMode_Overlay  : QPainter.CompositionMode = ... # 0xf
        CompositionMode_Darken   : QPainter.CompositionMode = ... # 0x10
        CompositionMode_Lighten  : QPainter.CompositionMode = ... # 0x11
        CompositionMode_ColorDodge: QPainter.CompositionMode = ... # 0x12
        CompositionMode_ColorBurn: QPainter.CompositionMode = ... # 0x13
        CompositionMode_HardLight: QPainter.CompositionMode = ... # 0x14
        CompositionMode_SoftLight: QPainter.CompositionMode = ... # 0x15
        CompositionMode_Difference: QPainter.CompositionMode = ... # 0x16
        CompositionMode_Exclusion: QPainter.CompositionMode = ... # 0x17
        RasterOp_SourceOrDestination: QPainter.CompositionMode = ... # 0x18
        RasterOp_SourceAndDestination: QPainter.CompositionMode = ... # 0x19
        RasterOp_SourceXorDestination: QPainter.CompositionMode = ... # 0x1a
        RasterOp_NotSourceAndNotDestination: QPainter.CompositionMode = ... # 0x1b
        RasterOp_NotSourceOrNotDestination: QPainter.CompositionMode = ... # 0x1c
        RasterOp_NotSourceXorDestination: QPainter.CompositionMode = ... # 0x1d
        RasterOp_NotSource       : QPainter.CompositionMode = ... # 0x1e
        RasterOp_NotSourceAndDestination: QPainter.CompositionMode = ... # 0x1f
        RasterOp_SourceAndNotDestination: QPainter.CompositionMode = ... # 0x20
        RasterOp_NotSourceOrDestination: QPainter.CompositionMode = ... # 0x21
        RasterOp_SourceOrNotDestination: QPainter.CompositionMode = ... # 0x22
        RasterOp_ClearDestination: QPainter.CompositionMode = ... # 0x23
        RasterOp_SetDestination  : QPainter.CompositionMode = ... # 0x24
        RasterOp_NotDestination  : QPainter.CompositionMode = ... # 0x25

    class PixmapFragment(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, PixmapFragment: PySide2.QtGui.QPainter.PixmapFragment) -> None: ...


    class PixmapFragmentHint(Shiboken.Enum):
        OpaqueHint               : QPainter.PixmapFragmentHint = ... # 0x1

    class PixmapFragmentHints(object): ...

    class RenderHint(Shiboken.Enum):
        Antialiasing             : QPainter.RenderHint = ... # 0x1
        TextAntialiasing         : QPainter.RenderHint = ... # 0x2
        SmoothPixmapTransform    : QPainter.RenderHint = ... # 0x4
        HighQualityAntialiasing  : QPainter.RenderHint = ... # 0x8
        NonCosmeticDefaultPen    : QPainter.RenderHint = ... # 0x10
        Qt4CompatiblePainting    : QPainter.RenderHint = ... # 0x20
        LosslessImageRendering   : QPainter.RenderHint = ... # 0x40

    class RenderHints(object): ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QPaintDevice) -> None: ...


class QPainterPath(Shiboken.Object):
    MoveToElement            : QPainterPath.ElementType = ... # 0x0
    LineToElement            : QPainterPath.ElementType = ... # 0x1
    CurveToElement           : QPainterPath.ElementType = ... # 0x2
    CurveToDataElement       : QPainterPath.ElementType = ... # 0x3

    class Element(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, Element: PySide2.QtGui.QPainterPath.Element) -> None: ...


    class ElementType(Shiboken.Enum):
        MoveToElement            : QPainterPath.ElementType = ... # 0x0
        LineToElement            : QPainterPath.ElementType = ... # 0x1
        CurveToElement           : QPainterPath.ElementType = ... # 0x2
        CurveToDataElement       : QPainterPath.ElementType = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QPainterPath) -> None: ...
    @typing.overload
    def __init__(self, startPoint: PySide2.QtCore.QPointF) -> None: ...


class QPainterPathStroker(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, pen: PySide2.QtGui.QPen) -> None: ...


class QPalette(Shiboken.Object):
    Active                   : QPalette.ColorGroup = ... # 0x0
    Normal                   : QPalette.ColorGroup = ... # 0x0
    Disabled                 : QPalette.ColorGroup = ... # 0x1
    Inactive                 : QPalette.ColorGroup = ... # 0x2
    NColorGroups             : QPalette.ColorGroup = ... # 0x3
    Current                  : QPalette.ColorGroup = ... # 0x4
    All                      : QPalette.ColorGroup = ... # 0x5
    Foreground               : QPalette.ColorRole = ... # 0x0
    WindowText               : QPalette.ColorRole = ... # 0x0
    Button                   : QPalette.ColorRole = ... # 0x1
    Light                    : QPalette.ColorRole = ... # 0x2
    Midlight                 : QPalette.ColorRole = ... # 0x3
    Dark                     : QPalette.ColorRole = ... # 0x4
    Mid                      : QPalette.ColorRole = ... # 0x5
    Text                     : QPalette.ColorRole = ... # 0x6
    BrightText               : QPalette.ColorRole = ... # 0x7
    ButtonText               : QPalette.ColorRole = ... # 0x8
    Base                     : QPalette.ColorRole = ... # 0x9
    Background               : QPalette.ColorRole = ... # 0xa
    Window                   : QPalette.ColorRole = ... # 0xa
    Shadow                   : QPalette.ColorRole = ... # 0xb
    Highlight                : QPalette.ColorRole = ... # 0xc
    HighlightedText          : QPalette.ColorRole = ... # 0xd
    Link                     : QPalette.ColorRole = ... # 0xe
    LinkVisited              : QPalette.ColorRole = ... # 0xf
    AlternateBase            : QPalette.ColorRole = ... # 0x10
    NoRole                   : QPalette.ColorRole = ... # 0x11
    ToolTipBase              : QPalette.ColorRole = ... # 0x12
    ToolTipText              : QPalette.ColorRole = ... # 0x13
    PlaceholderText          : QPalette.ColorRole = ... # 0x14
    NColorRoles              : QPalette.ColorRole = ... # 0x15

    class ColorGroup(Shiboken.Enum):
        Active                   : QPalette.ColorGroup = ... # 0x0
        Normal                   : QPalette.ColorGroup = ... # 0x0
        Disabled                 : QPalette.ColorGroup = ... # 0x1
        Inactive                 : QPalette.ColorGroup = ... # 0x2
        NColorGroups             : QPalette.ColorGroup = ... # 0x3
        Current                  : QPalette.ColorGroup = ... # 0x4
        All                      : QPalette.ColorGroup = ... # 0x5

    class ColorRole(Shiboken.Enum):
        Foreground               : QPalette.ColorRole = ... # 0x0
        WindowText               : QPalette.ColorRole = ... # 0x0
        Button                   : QPalette.ColorRole = ... # 0x1
        Light                    : QPalette.ColorRole = ... # 0x2
        Midlight                 : QPalette.ColorRole = ... # 0x3
        Dark                     : QPalette.ColorRole = ... # 0x4
        Mid                      : QPalette.ColorRole = ... # 0x5
        Text                     : QPalette.ColorRole = ... # 0x6
        BrightText               : QPalette.ColorRole = ... # 0x7
        ButtonText               : QPalette.ColorRole = ... # 0x8
        Base                     : QPalette.ColorRole = ... # 0x9
        Background               : QPalette.ColorRole = ... # 0xa
        Window                   : QPalette.ColorRole = ... # 0xa
        Shadow                   : QPalette.ColorRole = ... # 0xb
        Highlight                : QPalette.ColorRole = ... # 0xc
        HighlightedText          : QPalette.ColorRole = ... # 0xd
        Link                     : QPalette.ColorRole = ... # 0xe
        LinkVisited              : QPalette.ColorRole = ... # 0xf
        AlternateBase            : QPalette.ColorRole = ... # 0x10
        NoRole                   : QPalette.ColorRole = ... # 0x11
        ToolTipBase              : QPalette.ColorRole = ... # 0x12
        ToolTipText              : QPalette.ColorRole = ... # 0x13
        PlaceholderText          : QPalette.ColorRole = ... # 0x14
        NColorRoles              : QPalette.ColorRole = ... # 0x15

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, button: PySide2.QtCore.Qt.GlobalColor) -> None: ...
    @typing.overload
    def __init__(self, button: PySide2.QtGui.QColor) -> None: ...
    @typing.overload
    def __init__(self, button: PySide2.QtGui.QColor, window: PySide2.QtGui.QColor) -> None: ...
    @typing.overload
    def __init__(self, palette: PySide2.QtGui.QPalette) -> None: ...
    @typing.overload
    def __init__(self, windowText: PySide2.QtGui.QBrush, button: PySide2.QtGui.QBrush, light: PySide2.QtGui.QBrush, dark: PySide2.QtGui.QBrush, mid: PySide2.QtGui.QBrush, text: PySide2.QtGui.QBrush, bright_text: PySide2.QtGui.QBrush, base: PySide2.QtGui.QBrush, window: PySide2.QtGui.QBrush) -> None: ...
    @typing.overload
    def __init__(self, windowText: PySide2.QtGui.QColor, window: PySide2.QtGui.QColor, light: PySide2.QtGui.QColor, dark: PySide2.QtGui.QColor, mid: PySide2.QtGui.QColor, text: PySide2.QtGui.QColor, base: PySide2.QtGui.QColor) -> None: ...


class QPdfWriter(PySide2.QtCore.QObject, PySide2.QtGui.QPagedPaintDevice):

    @typing.overload
    def __init__(self, device: PySide2.QtCore.QIODevice) -> None: ...
    @typing.overload
    def __init__(self, filename: str) -> None: ...


class QPen(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.Qt.PenStyle) -> None: ...
    @typing.overload
    def __init__(self, brush: PySide2.QtGui.QBrush, width: float, s: PySide2.QtCore.Qt.PenStyle = ..., c: PySide2.QtCore.Qt.PenCapStyle = ..., j: PySide2.QtCore.Qt.PenJoinStyle = ...) -> None: ...
    @typing.overload
    def __init__(self, color: PySide2.QtGui.QColor) -> None: ...
    @typing.overload
    def __init__(self, pen: PySide2.QtGui.QPen) -> None: ...


class QPicture(PySide2.QtGui.QPaintDevice):

    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QPicture) -> None: ...
    @typing.overload
    def __init__(self, formatVersion: int = ...) -> None: ...


class QPictureIO(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, format: bytes) -> None: ...
    @typing.overload
    def __init__(self, ioDevice: PySide2.QtCore.QIODevice, format: bytes) -> None: ...


class QPixelFormat(Shiboken.Object):
    AtBeginning              : QPixelFormat.AlphaPosition = ... # 0x0
    AtEnd                    : QPixelFormat.AlphaPosition = ... # 0x1
    NotPremultiplied         : QPixelFormat.AlphaPremultiplied = ... # 0x0
    Premultiplied            : QPixelFormat.AlphaPremultiplied = ... # 0x1
    UsesAlpha                : QPixelFormat.AlphaUsage = ... # 0x0
    IgnoresAlpha             : QPixelFormat.AlphaUsage = ... # 0x1
    LittleEndian             : QPixelFormat.ByteOrder = ... # 0x0
    BigEndian                : QPixelFormat.ByteOrder = ... # 0x1
    CurrentSystemEndian      : QPixelFormat.ByteOrder = ... # 0x2
    RGB                      : QPixelFormat.ColorModel = ... # 0x0
    BGR                      : QPixelFormat.ColorModel = ... # 0x1
    Indexed                  : QPixelFormat.ColorModel = ... # 0x2
    Grayscale                : QPixelFormat.ColorModel = ... # 0x3
    CMYK                     : QPixelFormat.ColorModel = ... # 0x4
    HSL                      : QPixelFormat.ColorModel = ... # 0x5
    HSV                      : QPixelFormat.ColorModel = ... # 0x6
    YUV                      : QPixelFormat.ColorModel = ... # 0x7
    Alpha                    : QPixelFormat.ColorModel = ... # 0x8
    UnsignedInteger          : QPixelFormat.TypeInterpretation = ... # 0x0
    UnsignedShort            : QPixelFormat.TypeInterpretation = ... # 0x1
    UnsignedByte             : QPixelFormat.TypeInterpretation = ... # 0x2
    FloatingPoint            : QPixelFormat.TypeInterpretation = ... # 0x3
    YUV444                   : QPixelFormat.YUVLayout = ... # 0x0
    YUV422                   : QPixelFormat.YUVLayout = ... # 0x1
    YUV411                   : QPixelFormat.YUVLayout = ... # 0x2
    YUV420P                  : QPixelFormat.YUVLayout = ... # 0x3
    YUV420SP                 : QPixelFormat.YUVLayout = ... # 0x4
    YV12                     : QPixelFormat.YUVLayout = ... # 0x5
    UYVY                     : QPixelFormat.YUVLayout = ... # 0x6
    YUYV                     : QPixelFormat.YUVLayout = ... # 0x7
    NV12                     : QPixelFormat.YUVLayout = ... # 0x8
    NV21                     : QPixelFormat.YUVLayout = ... # 0x9
    IMC1                     : QPixelFormat.YUVLayout = ... # 0xa
    IMC2                     : QPixelFormat.YUVLayout = ... # 0xb
    IMC3                     : QPixelFormat.YUVLayout = ... # 0xc
    IMC4                     : QPixelFormat.YUVLayout = ... # 0xd
    Y8                       : QPixelFormat.YUVLayout = ... # 0xe
    Y16                      : QPixelFormat.YUVLayout = ... # 0xf

    class AlphaPosition(Shiboken.Enum):
        AtBeginning              : QPixelFormat.AlphaPosition = ... # 0x0
        AtEnd                    : QPixelFormat.AlphaPosition = ... # 0x1

    class AlphaPremultiplied(Shiboken.Enum):
        NotPremultiplied         : QPixelFormat.AlphaPremultiplied = ... # 0x0
        Premultiplied            : QPixelFormat.AlphaPremultiplied = ... # 0x1

    class AlphaUsage(Shiboken.Enum):
        UsesAlpha                : QPixelFormat.AlphaUsage = ... # 0x0
        IgnoresAlpha             : QPixelFormat.AlphaUsage = ... # 0x1

    class ByteOrder(Shiboken.Enum):
        LittleEndian             : QPixelFormat.ByteOrder = ... # 0x0
        BigEndian                : QPixelFormat.ByteOrder = ... # 0x1
        CurrentSystemEndian      : QPixelFormat.ByteOrder = ... # 0x2

    class ColorModel(Shiboken.Enum):
        RGB                      : QPixelFormat.ColorModel = ... # 0x0
        BGR                      : QPixelFormat.ColorModel = ... # 0x1
        Indexed                  : QPixelFormat.ColorModel = ... # 0x2
        Grayscale                : QPixelFormat.ColorModel = ... # 0x3
        CMYK                     : QPixelFormat.ColorModel = ... # 0x4
        HSL                      : QPixelFormat.ColorModel = ... # 0x5
        HSV                      : QPixelFormat.ColorModel = ... # 0x6
        YUV                      : QPixelFormat.ColorModel = ... # 0x7
        Alpha                    : QPixelFormat.ColorModel = ... # 0x8

    class TypeInterpretation(Shiboken.Enum):
        UnsignedInteger          : QPixelFormat.TypeInterpretation = ... # 0x0
        UnsignedShort            : QPixelFormat.TypeInterpretation = ... # 0x1
        UnsignedByte             : QPixelFormat.TypeInterpretation = ... # 0x2
        FloatingPoint            : QPixelFormat.TypeInterpretation = ... # 0x3

    class YUVLayout(Shiboken.Enum):
        YUV444                   : QPixelFormat.YUVLayout = ... # 0x0
        YUV422                   : QPixelFormat.YUVLayout = ... # 0x1
        YUV411                   : QPixelFormat.YUVLayout = ... # 0x2
        YUV420P                  : QPixelFormat.YUVLayout = ... # 0x3
        YUV420SP                 : QPixelFormat.YUVLayout = ... # 0x4
        YV12                     : QPixelFormat.YUVLayout = ... # 0x5
        UYVY                     : QPixelFormat.YUVLayout = ... # 0x6
        YUYV                     : QPixelFormat.YUVLayout = ... # 0x7
        NV12                     : QPixelFormat.YUVLayout = ... # 0x8
        NV21                     : QPixelFormat.YUVLayout = ... # 0x9
        IMC1                     : QPixelFormat.YUVLayout = ... # 0xa
        IMC2                     : QPixelFormat.YUVLayout = ... # 0xb
        IMC3                     : QPixelFormat.YUVLayout = ... # 0xc
        IMC4                     : QPixelFormat.YUVLayout = ... # 0xd
        Y8                       : QPixelFormat.YUVLayout = ... # 0xe
        Y16                      : QPixelFormat.YUVLayout = ... # 0xf

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QPixelFormat: PySide2.QtGui.QPixelFormat) -> None: ...
    @typing.overload
    def __init__(self, colorModel: PySide2.QtGui.QPixelFormat.ColorModel, firstSize: int, secondSize: int, thirdSize: int, fourthSize: int, fifthSize: int, alphaSize: int, alphaUsage: PySide2.QtGui.QPixelFormat.AlphaUsage, alphaPosition: PySide2.QtGui.QPixelFormat.AlphaPosition, premultiplied: PySide2.QtGui.QPixelFormat.AlphaPremultiplied, typeInterpretation: PySide2.QtGui.QPixelFormat.TypeInterpretation, byteOrder: PySide2.QtGui.QPixelFormat.ByteOrder = ..., subEnum: int = ...) -> None: ...


class QPixmap(PySide2.QtGui.QPaintDevice):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QPixmap) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, format: typing.Optional[bytes] = ..., flags: PySide2.QtCore.Qt.ImageConversionFlags = ...) -> None: ...
    @typing.overload
    def __init__(self, image: PySide2.QtGui.QImage) -> None: ...
    @typing.overload
    def __init__(self, w: int, h: int) -> None: ...
    @typing.overload
    def __init__(self, xpm: typing.Sequence[str]) -> None: ...


class QPixmapCache(Shiboken.Object):

    class Key(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, other: PySide2.QtGui.QPixmapCache.Key) -> None: ...


    def __init__(self) -> None: ...


class QPointingDeviceUniqueId(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QPointingDeviceUniqueId: PySide2.QtGui.QPointingDeviceUniqueId) -> None: ...


class QPolygon(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QPolygon) -> None: ...
    @typing.overload
    def __init__(self, r: PySide2.QtCore.QRect, closed: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, size: int) -> None: ...
    @typing.overload
    def __init__(self, v: typing.List[PySide2.QtCore.QPoint]) -> None: ...


class QPolygonF(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a: PySide2.QtGui.QPolygon) -> None: ...
    @typing.overload
    def __init__(self, a: PySide2.QtGui.QPolygonF) -> None: ...
    @typing.overload
    def __init__(self, r: PySide2.QtCore.QRectF) -> None: ...
    @typing.overload
    def __init__(self, size: int) -> None: ...
    @typing.overload
    def __init__(self, v: typing.List[PySide2.QtCore.QPointF]) -> None: ...


class QPyTextObject(PySide2.QtCore.QObject, PySide2.QtGui.QTextObjectInterface):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QQuaternion(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, scalar: float, vector: PySide2.QtGui.QVector3D) -> None: ...
    @typing.overload
    def __init__(self, scalar: float, xpos: float, ypos: float, zpos: float) -> None: ...
    @typing.overload
    def __init__(self, vector: PySide2.QtGui.QVector4D) -> None: ...


class QRadialGradient(PySide2.QtGui.QGradient):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QRadialGradient: PySide2.QtGui.QRadialGradient) -> None: ...
    @typing.overload
    def __init__(self, center: PySide2.QtCore.QPointF, centerRadius: float, focalPoint: PySide2.QtCore.QPointF, focalRadius: float) -> None: ...
    @typing.overload
    def __init__(self, center: PySide2.QtCore.QPointF, radius: float) -> None: ...
    @typing.overload
    def __init__(self, center: PySide2.QtCore.QPointF, radius: float, focalPoint: PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def __init__(self, cx: float, cy: float, centerRadius: float, fx: float, fy: float, focalRadius: float) -> None: ...
    @typing.overload
    def __init__(self, cx: float, cy: float, radius: float) -> None: ...
    @typing.overload
    def __init__(self, cx: float, cy: float, radius: float, fx: float, fy: float) -> None: ...


class QRasterWindow(PySide2.QtGui.QPaintDeviceWindow):

    def __init__(self, parent: typing.Optional[PySide2.QtGui.QWindow] = ...) -> None: ...


class QRawFont(Shiboken.Object):
    PixelAntialiasing        : QRawFont.AntialiasingType = ... # 0x0
    SubPixelAntialiasing     : QRawFont.AntialiasingType = ... # 0x1
    SeparateAdvances         : QRawFont.LayoutFlag = ... # 0x0
    KernedAdvances           : QRawFont.LayoutFlag = ... # 0x1
    UseDesignMetrics         : QRawFont.LayoutFlag = ... # 0x2

    class AntialiasingType(Shiboken.Enum):
        PixelAntialiasing        : QRawFont.AntialiasingType = ... # 0x0
        SubPixelAntialiasing     : QRawFont.AntialiasingType = ... # 0x1

    class LayoutFlag(Shiboken.Enum):
        SeparateAdvances         : QRawFont.LayoutFlag = ... # 0x0
        KernedAdvances           : QRawFont.LayoutFlag = ... # 0x1
        UseDesignMetrics         : QRawFont.LayoutFlag = ... # 0x2

    class LayoutFlags(object): ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, pixelSize: float, hintingPreference: PySide2.QtGui.QFont.HintingPreference = ...) -> None: ...
    @typing.overload
    def __init__(self, fontData: PySide2.QtCore.QByteArray, pixelSize: float, hintingPreference: PySide2.QtGui.QFont.HintingPreference = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QRawFont) -> None: ...


class QRegExpValidator(PySide2.QtGui.QValidator):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, rx: PySide2.QtCore.QRegExp, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QRegion(Shiboken.Object):
    Rectangle                : QRegion.RegionType = ... # 0x0
    Ellipse                  : QRegion.RegionType = ... # 0x1

    class RegionType(Shiboken.Enum):
        Rectangle                : QRegion.RegionType = ... # 0x0
        Ellipse                  : QRegion.RegionType = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, bitmap: PySide2.QtGui.QBitmap) -> None: ...
    @typing.overload
    def __init__(self, pa: PySide2.QtGui.QPolygon, fillRule: PySide2.QtCore.Qt.FillRule = ...) -> None: ...
    @typing.overload
    def __init__(self, r: PySide2.QtCore.QRect, t: PySide2.QtGui.QRegion.RegionType = ...) -> None: ...
    @typing.overload
    def __init__(self, region: PySide2.QtGui.QRegion) -> None: ...
    @typing.overload
    def __init__(self, x: int, y: int, w: int, h: int, t: PySide2.QtGui.QRegion.RegionType = ...) -> None: ...


class QRegularExpressionValidator(PySide2.QtGui.QValidator):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, re: PySide2.QtCore.QRegularExpression, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QResizeEvent(PySide2.QtCore.QEvent):

    def __init__(self, size: PySide2.QtCore.QSize, oldSize: PySide2.QtCore.QSize) -> None: ...


class QScreen(PySide2.QtCore.QObject): ...


class QScrollEvent(PySide2.QtCore.QEvent):
    ScrollStarted            : QScrollEvent.ScrollState = ... # 0x0
    ScrollUpdated            : QScrollEvent.ScrollState = ... # 0x1
    ScrollFinished           : QScrollEvent.ScrollState = ... # 0x2

    class ScrollState(Shiboken.Enum):
        ScrollStarted            : QScrollEvent.ScrollState = ... # 0x0
        ScrollUpdated            : QScrollEvent.ScrollState = ... # 0x1
        ScrollFinished           : QScrollEvent.ScrollState = ... # 0x2

    def __init__(self, contentPos: PySide2.QtCore.QPointF, overshoot: PySide2.QtCore.QPointF, scrollState: PySide2.QtGui.QScrollEvent.ScrollState) -> None: ...


class QScrollPrepareEvent(PySide2.QtCore.QEvent):

    def __init__(self, startPos: PySide2.QtCore.QPointF) -> None: ...


class QSessionManager(PySide2.QtCore.QObject):
    RestartIfRunning         : QSessionManager.RestartHint = ... # 0x0
    RestartAnyway            : QSessionManager.RestartHint = ... # 0x1
    RestartImmediately       : QSessionManager.RestartHint = ... # 0x2
    RestartNever             : QSessionManager.RestartHint = ... # 0x3

    class RestartHint(Shiboken.Enum):
        RestartIfRunning         : QSessionManager.RestartHint = ... # 0x0
        RestartAnyway            : QSessionManager.RestartHint = ... # 0x1
        RestartImmediately       : QSessionManager.RestartHint = ... # 0x2
        RestartNever             : QSessionManager.RestartHint = ... # 0x3


class QShortcutEvent(PySide2.QtCore.QEvent):

    def __init__(self, key: PySide2.QtGui.QKeySequence, id: int, ambiguous: bool = ...) -> None: ...


class QShowEvent(PySide2.QtCore.QEvent):

    def __init__(self) -> None: ...


class QStandardItem(Shiboken.Object):
    Type                     : QStandardItem.ItemType = ... # 0x0
    UserType                 : QStandardItem.ItemType = ... # 0x3e8

    class ItemType(Shiboken.Enum):
        Type                     : QStandardItem.ItemType = ... # 0x0
        UserType                 : QStandardItem.ItemType = ... # 0x3e8

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, icon: PySide2.QtGui.QIcon, text: str) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QStandardItem) -> None: ...
    @typing.overload
    def __init__(self, rows: int, columns: int = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str) -> None: ...


class QStandardItemModel(PySide2.QtCore.QAbstractItemModel):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, rows: int, columns: int, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QStaticText(Shiboken.Object):
    ModerateCaching          : QStaticText.PerformanceHint = ... # 0x0
    AggressiveCaching        : QStaticText.PerformanceHint = ... # 0x1

    class PerformanceHint(Shiboken.Enum):
        ModerateCaching          : QStaticText.PerformanceHint = ... # 0x0
        AggressiveCaching        : QStaticText.PerformanceHint = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QStaticText) -> None: ...
    @typing.overload
    def __init__(self, text: str) -> None: ...


class QStatusTipEvent(PySide2.QtCore.QEvent):

    def __init__(self, tip: str) -> None: ...


class QStyleHints(PySide2.QtCore.QObject): ...


class QSurface(Shiboken.Object):
    Window                   : QSurface.SurfaceClass = ... # 0x0
    Offscreen                : QSurface.SurfaceClass = ... # 0x1
    RasterSurface            : QSurface.SurfaceType = ... # 0x0
    OpenGLSurface            : QSurface.SurfaceType = ... # 0x1
    RasterGLSurface          : QSurface.SurfaceType = ... # 0x2
    OpenVGSurface            : QSurface.SurfaceType = ... # 0x3
    VulkanSurface            : QSurface.SurfaceType = ... # 0x4
    MetalSurface             : QSurface.SurfaceType = ... # 0x5

    class SurfaceClass(Shiboken.Enum):
        Window                   : QSurface.SurfaceClass = ... # 0x0
        Offscreen                : QSurface.SurfaceClass = ... # 0x1

    class SurfaceType(Shiboken.Enum):
        RasterSurface            : QSurface.SurfaceType = ... # 0x0
        OpenGLSurface            : QSurface.SurfaceType = ... # 0x1
        RasterGLSurface          : QSurface.SurfaceType = ... # 0x2
        OpenVGSurface            : QSurface.SurfaceType = ... # 0x3
        VulkanSurface            : QSurface.SurfaceType = ... # 0x4
        MetalSurface             : QSurface.SurfaceType = ... # 0x5

    def __init__(self, type: PySide2.QtGui.QSurface.SurfaceClass) -> None: ...


class QSurfaceFormat(Shiboken.Object):
    DefaultColorSpace        : QSurfaceFormat.ColorSpace = ... # 0x0
    sRGBColorSpace           : QSurfaceFormat.ColorSpace = ... # 0x1
    StereoBuffers            : QSurfaceFormat.FormatOption = ... # 0x1
    DebugContext             : QSurfaceFormat.FormatOption = ... # 0x2
    DeprecatedFunctions      : QSurfaceFormat.FormatOption = ... # 0x4
    ResetNotification        : QSurfaceFormat.FormatOption = ... # 0x8
    NoProfile                : QSurfaceFormat.OpenGLContextProfile = ... # 0x0
    CoreProfile              : QSurfaceFormat.OpenGLContextProfile = ... # 0x1
    CompatibilityProfile     : QSurfaceFormat.OpenGLContextProfile = ... # 0x2
    DefaultRenderableType    : QSurfaceFormat.RenderableType = ... # 0x0
    OpenGL                   : QSurfaceFormat.RenderableType = ... # 0x1
    OpenGLES                 : QSurfaceFormat.RenderableType = ... # 0x2
    OpenVG                   : QSurfaceFormat.RenderableType = ... # 0x4
    DefaultSwapBehavior      : QSurfaceFormat.SwapBehavior = ... # 0x0
    SingleBuffer             : QSurfaceFormat.SwapBehavior = ... # 0x1
    DoubleBuffer             : QSurfaceFormat.SwapBehavior = ... # 0x2
    TripleBuffer             : QSurfaceFormat.SwapBehavior = ... # 0x3

    class ColorSpace(Shiboken.Enum):
        DefaultColorSpace        : QSurfaceFormat.ColorSpace = ... # 0x0
        sRGBColorSpace           : QSurfaceFormat.ColorSpace = ... # 0x1

    class FormatOption(Shiboken.Enum):
        StereoBuffers            : QSurfaceFormat.FormatOption = ... # 0x1
        DebugContext             : QSurfaceFormat.FormatOption = ... # 0x2
        DeprecatedFunctions      : QSurfaceFormat.FormatOption = ... # 0x4
        ResetNotification        : QSurfaceFormat.FormatOption = ... # 0x8

    class FormatOptions(object): ...

    class OpenGLContextProfile(Shiboken.Enum):
        NoProfile                : QSurfaceFormat.OpenGLContextProfile = ... # 0x0
        CoreProfile              : QSurfaceFormat.OpenGLContextProfile = ... # 0x1
        CompatibilityProfile     : QSurfaceFormat.OpenGLContextProfile = ... # 0x2

    class RenderableType(Shiboken.Enum):
        DefaultRenderableType    : QSurfaceFormat.RenderableType = ... # 0x0
        OpenGL                   : QSurfaceFormat.RenderableType = ... # 0x1
        OpenGLES                 : QSurfaceFormat.RenderableType = ... # 0x2
        OpenVG                   : QSurfaceFormat.RenderableType = ... # 0x4

    class SwapBehavior(Shiboken.Enum):
        DefaultSwapBehavior      : QSurfaceFormat.SwapBehavior = ... # 0x0
        SingleBuffer             : QSurfaceFormat.SwapBehavior = ... # 0x1
        DoubleBuffer             : QSurfaceFormat.SwapBehavior = ... # 0x2
        TripleBuffer             : QSurfaceFormat.SwapBehavior = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, options: PySide2.QtGui.QSurfaceFormat.FormatOptions) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QSurfaceFormat) -> None: ...


class QSyntaxHighlighter(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtGui.QTextDocument) -> None: ...


class QTabletEvent(PySide2.QtGui.QInputEvent):
    UnknownPointer           : QTabletEvent.PointerType = ... # 0x0
    Pen                      : QTabletEvent.PointerType = ... # 0x1
    Cursor                   : QTabletEvent.PointerType = ... # 0x2
    Eraser                   : QTabletEvent.PointerType = ... # 0x3
    NoDevice                 : QTabletEvent.TabletDevice = ... # 0x0
    Puck                     : QTabletEvent.TabletDevice = ... # 0x1
    Stylus                   : QTabletEvent.TabletDevice = ... # 0x2
    Airbrush                 : QTabletEvent.TabletDevice = ... # 0x3
    FourDMouse               : QTabletEvent.TabletDevice = ... # 0x4
    XFreeEraser              : QTabletEvent.TabletDevice = ... # 0x5
    RotationStylus           : QTabletEvent.TabletDevice = ... # 0x6

    class PointerType(Shiboken.Enum):
        UnknownPointer           : QTabletEvent.PointerType = ... # 0x0
        Pen                      : QTabletEvent.PointerType = ... # 0x1
        Cursor                   : QTabletEvent.PointerType = ... # 0x2
        Eraser                   : QTabletEvent.PointerType = ... # 0x3

    class TabletDevice(Shiboken.Enum):
        NoDevice                 : QTabletEvent.TabletDevice = ... # 0x0
        Puck                     : QTabletEvent.TabletDevice = ... # 0x1
        Stylus                   : QTabletEvent.TabletDevice = ... # 0x2
        Airbrush                 : QTabletEvent.TabletDevice = ... # 0x3
        FourDMouse               : QTabletEvent.TabletDevice = ... # 0x4
        XFreeEraser              : QTabletEvent.TabletDevice = ... # 0x5
        RotationStylus           : QTabletEvent.TabletDevice = ... # 0x6

    @typing.overload
    def __init__(self, t: PySide2.QtCore.QEvent.Type, pos: PySide2.QtCore.QPointF, globalPos: PySide2.QtCore.QPointF, device: int, pointerType: int, pressure: float, xTilt: int, yTilt: int, tangentialPressure: float, rotation: float, z: int, keyState: PySide2.QtCore.Qt.KeyboardModifiers, uniqueID: int) -> None: ...
    @typing.overload
    def __init__(self, t: PySide2.QtCore.QEvent.Type, pos: PySide2.QtCore.QPointF, globalPos: PySide2.QtCore.QPointF, device: int, pointerType: int, pressure: float, xTilt: int, yTilt: int, tangentialPressure: float, rotation: float, z: int, keyState: PySide2.QtCore.Qt.KeyboardModifiers, uniqueID: int, button: PySide2.QtCore.Qt.MouseButton, buttons: PySide2.QtCore.Qt.MouseButtons) -> None: ...


class QTextBlock(Shiboken.Object):

    class iterator(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, o: PySide2.QtGui.QTextBlock.iterator) -> None: ...


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, o: PySide2.QtGui.QTextBlock) -> None: ...


class QTextBlockFormat(PySide2.QtGui.QTextFormat):
    SingleHeight             : QTextBlockFormat.LineHeightTypes = ... # 0x0
    ProportionalHeight       : QTextBlockFormat.LineHeightTypes = ... # 0x1
    FixedHeight              : QTextBlockFormat.LineHeightTypes = ... # 0x2
    MinimumHeight            : QTextBlockFormat.LineHeightTypes = ... # 0x3
    LineDistanceHeight       : QTextBlockFormat.LineHeightTypes = ... # 0x4

    class LineHeightTypes(Shiboken.Enum):
        SingleHeight             : QTextBlockFormat.LineHeightTypes = ... # 0x0
        ProportionalHeight       : QTextBlockFormat.LineHeightTypes = ... # 0x1
        FixedHeight              : QTextBlockFormat.LineHeightTypes = ... # 0x2
        MinimumHeight            : QTextBlockFormat.LineHeightTypes = ... # 0x3
        LineDistanceHeight       : QTextBlockFormat.LineHeightTypes = ... # 0x4

    class MarkerType(Shiboken.Enum):
        NoMarker                 : QTextBlockFormat.MarkerType = ... # 0x0
        Unchecked                : QTextBlockFormat.MarkerType = ... # 0x1
        Checked                  : QTextBlockFormat.MarkerType = ... # 0x2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QTextBlockFormat: PySide2.QtGui.QTextBlockFormat) -> None: ...
    @typing.overload
    def __init__(self, fmt: PySide2.QtGui.QTextFormat) -> None: ...


class QTextBlockGroup(PySide2.QtGui.QTextObject):

    def __init__(self, doc: PySide2.QtGui.QTextDocument) -> None: ...


class QTextBlockUserData(Shiboken.Object):

    def __init__(self) -> None: ...


class QTextCharFormat(PySide2.QtGui.QTextFormat):
    FontPropertiesSpecifiedOnly: QTextCharFormat.FontPropertiesInheritanceBehavior = ... # 0x0
    FontPropertiesAll        : QTextCharFormat.FontPropertiesInheritanceBehavior = ... # 0x1
    NoUnderline              : QTextCharFormat.UnderlineStyle = ... # 0x0
    SingleUnderline          : QTextCharFormat.UnderlineStyle = ... # 0x1
    DashUnderline            : QTextCharFormat.UnderlineStyle = ... # 0x2
    DotLine                  : QTextCharFormat.UnderlineStyle = ... # 0x3
    DashDotLine              : QTextCharFormat.UnderlineStyle = ... # 0x4
    DashDotDotLine           : QTextCharFormat.UnderlineStyle = ... # 0x5
    WaveUnderline            : QTextCharFormat.UnderlineStyle = ... # 0x6
    SpellCheckUnderline      : QTextCharFormat.UnderlineStyle = ... # 0x7
    AlignNormal              : QTextCharFormat.VerticalAlignment = ... # 0x0
    AlignSuperScript         : QTextCharFormat.VerticalAlignment = ... # 0x1
    AlignSubScript           : QTextCharFormat.VerticalAlignment = ... # 0x2
    AlignMiddle              : QTextCharFormat.VerticalAlignment = ... # 0x3
    AlignTop                 : QTextCharFormat.VerticalAlignment = ... # 0x4
    AlignBottom              : QTextCharFormat.VerticalAlignment = ... # 0x5
    AlignBaseline            : QTextCharFormat.VerticalAlignment = ... # 0x6

    class FontPropertiesInheritanceBehavior(Shiboken.Enum):
        FontPropertiesSpecifiedOnly: QTextCharFormat.FontPropertiesInheritanceBehavior = ... # 0x0
        FontPropertiesAll        : QTextCharFormat.FontPropertiesInheritanceBehavior = ... # 0x1

    class UnderlineStyle(Shiboken.Enum):
        NoUnderline              : QTextCharFormat.UnderlineStyle = ... # 0x0
        SingleUnderline          : QTextCharFormat.UnderlineStyle = ... # 0x1
        DashUnderline            : QTextCharFormat.UnderlineStyle = ... # 0x2
        DotLine                  : QTextCharFormat.UnderlineStyle = ... # 0x3
        DashDotLine              : QTextCharFormat.UnderlineStyle = ... # 0x4
        DashDotDotLine           : QTextCharFormat.UnderlineStyle = ... # 0x5
        WaveUnderline            : QTextCharFormat.UnderlineStyle = ... # 0x6
        SpellCheckUnderline      : QTextCharFormat.UnderlineStyle = ... # 0x7

    class VerticalAlignment(Shiboken.Enum):
        AlignNormal              : QTextCharFormat.VerticalAlignment = ... # 0x0
        AlignSuperScript         : QTextCharFormat.VerticalAlignment = ... # 0x1
        AlignSubScript           : QTextCharFormat.VerticalAlignment = ... # 0x2
        AlignMiddle              : QTextCharFormat.VerticalAlignment = ... # 0x3
        AlignTop                 : QTextCharFormat.VerticalAlignment = ... # 0x4
        AlignBottom              : QTextCharFormat.VerticalAlignment = ... # 0x5
        AlignBaseline            : QTextCharFormat.VerticalAlignment = ... # 0x6

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QTextCharFormat: PySide2.QtGui.QTextCharFormat) -> None: ...
    @typing.overload
    def __init__(self, fmt: PySide2.QtGui.QTextFormat) -> None: ...


class QTextCursor(Shiboken.Object):
    MoveAnchor               : QTextCursor.MoveMode = ... # 0x0
    KeepAnchor               : QTextCursor.MoveMode = ... # 0x1
    NoMove                   : QTextCursor.MoveOperation = ... # 0x0
    Start                    : QTextCursor.MoveOperation = ... # 0x1
    Up                       : QTextCursor.MoveOperation = ... # 0x2
    StartOfLine              : QTextCursor.MoveOperation = ... # 0x3
    StartOfBlock             : QTextCursor.MoveOperation = ... # 0x4
    StartOfWord              : QTextCursor.MoveOperation = ... # 0x5
    PreviousBlock            : QTextCursor.MoveOperation = ... # 0x6
    PreviousCharacter        : QTextCursor.MoveOperation = ... # 0x7
    PreviousWord             : QTextCursor.MoveOperation = ... # 0x8
    Left                     : QTextCursor.MoveOperation = ... # 0x9
    WordLeft                 : QTextCursor.MoveOperation = ... # 0xa
    End                      : QTextCursor.MoveOperation = ... # 0xb
    Down                     : QTextCursor.MoveOperation = ... # 0xc
    EndOfLine                : QTextCursor.MoveOperation = ... # 0xd
    EndOfWord                : QTextCursor.MoveOperation = ... # 0xe
    EndOfBlock               : QTextCursor.MoveOperation = ... # 0xf
    NextBlock                : QTextCursor.MoveOperation = ... # 0x10
    NextCharacter            : QTextCursor.MoveOperation = ... # 0x11
    NextWord                 : QTextCursor.MoveOperation = ... # 0x12
    Right                    : QTextCursor.MoveOperation = ... # 0x13
    WordRight                : QTextCursor.MoveOperation = ... # 0x14
    NextCell                 : QTextCursor.MoveOperation = ... # 0x15
    PreviousCell             : QTextCursor.MoveOperation = ... # 0x16
    NextRow                  : QTextCursor.MoveOperation = ... # 0x17
    PreviousRow              : QTextCursor.MoveOperation = ... # 0x18
    WordUnderCursor          : QTextCursor.SelectionType = ... # 0x0
    LineUnderCursor          : QTextCursor.SelectionType = ... # 0x1
    BlockUnderCursor         : QTextCursor.SelectionType = ... # 0x2
    Document                 : QTextCursor.SelectionType = ... # 0x3

    class MoveMode(Shiboken.Enum):
        MoveAnchor               : QTextCursor.MoveMode = ... # 0x0
        KeepAnchor               : QTextCursor.MoveMode = ... # 0x1

    class MoveOperation(Shiboken.Enum):
        NoMove                   : QTextCursor.MoveOperation = ... # 0x0
        Start                    : QTextCursor.MoveOperation = ... # 0x1
        Up                       : QTextCursor.MoveOperation = ... # 0x2
        StartOfLine              : QTextCursor.MoveOperation = ... # 0x3
        StartOfBlock             : QTextCursor.MoveOperation = ... # 0x4
        StartOfWord              : QTextCursor.MoveOperation = ... # 0x5
        PreviousBlock            : QTextCursor.MoveOperation = ... # 0x6
        PreviousCharacter        : QTextCursor.MoveOperation = ... # 0x7
        PreviousWord             : QTextCursor.MoveOperation = ... # 0x8
        Left                     : QTextCursor.MoveOperation = ... # 0x9
        WordLeft                 : QTextCursor.MoveOperation = ... # 0xa
        End                      : QTextCursor.MoveOperation = ... # 0xb
        Down                     : QTextCursor.MoveOperation = ... # 0xc
        EndOfLine                : QTextCursor.MoveOperation = ... # 0xd
        EndOfWord                : QTextCursor.MoveOperation = ... # 0xe
        EndOfBlock               : QTextCursor.MoveOperation = ... # 0xf
        NextBlock                : QTextCursor.MoveOperation = ... # 0x10
        NextCharacter            : QTextCursor.MoveOperation = ... # 0x11
        NextWord                 : QTextCursor.MoveOperation = ... # 0x12
        Right                    : QTextCursor.MoveOperation = ... # 0x13
        WordRight                : QTextCursor.MoveOperation = ... # 0x14
        NextCell                 : QTextCursor.MoveOperation = ... # 0x15
        PreviousCell             : QTextCursor.MoveOperation = ... # 0x16
        NextRow                  : QTextCursor.MoveOperation = ... # 0x17
        PreviousRow              : QTextCursor.MoveOperation = ... # 0x18

    class SelectionType(Shiboken.Enum):
        WordUnderCursor          : QTextCursor.SelectionType = ... # 0x0
        LineUnderCursor          : QTextCursor.SelectionType = ... # 0x1
        BlockUnderCursor         : QTextCursor.SelectionType = ... # 0x2
        Document                 : QTextCursor.SelectionType = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, block: PySide2.QtGui.QTextBlock) -> None: ...
    @typing.overload
    def __init__(self, cursor: PySide2.QtGui.QTextCursor) -> None: ...
    @typing.overload
    def __init__(self, document: PySide2.QtGui.QTextDocument) -> None: ...
    @typing.overload
    def __init__(self, frame: PySide2.QtGui.QTextFrame) -> None: ...


class QTextDocument(PySide2.QtCore.QObject):
    FindBackward             : QTextDocument.FindFlag = ... # 0x1
    FindCaseSensitively      : QTextDocument.FindFlag = ... # 0x2
    FindWholeWords           : QTextDocument.FindFlag = ... # 0x4
    MarkdownDialectCommonMark: QTextDocument.MarkdownFeature = ... # 0x0
    MarkdownNoHTML           : QTextDocument.MarkdownFeature = ... # 0x60
    MarkdownDialectGitHub    : QTextDocument.MarkdownFeature = ... # 0xf0c
    DocumentTitle            : QTextDocument.MetaInformation = ... # 0x0
    DocumentUrl              : QTextDocument.MetaInformation = ... # 0x1
    UnknownResource          : QTextDocument.ResourceType = ... # 0x0
    HtmlResource             : QTextDocument.ResourceType = ... # 0x1
    ImageResource            : QTextDocument.ResourceType = ... # 0x2
    StyleSheetResource       : QTextDocument.ResourceType = ... # 0x3
    MarkdownResource         : QTextDocument.ResourceType = ... # 0x4
    UserResource             : QTextDocument.ResourceType = ... # 0x64
    UndoStack                : QTextDocument.Stacks = ... # 0x1
    RedoStack                : QTextDocument.Stacks = ... # 0x2
    UndoAndRedoStacks        : QTextDocument.Stacks = ... # 0x3

    class FindFlag(Shiboken.Enum):
        FindBackward             : QTextDocument.FindFlag = ... # 0x1
        FindCaseSensitively      : QTextDocument.FindFlag = ... # 0x2
        FindWholeWords           : QTextDocument.FindFlag = ... # 0x4

    class FindFlags(object): ...

    class MarkdownFeature(Shiboken.Enum):
        MarkdownDialectCommonMark: QTextDocument.MarkdownFeature = ... # 0x0
        MarkdownNoHTML           : QTextDocument.MarkdownFeature = ... # 0x60
        MarkdownDialectGitHub    : QTextDocument.MarkdownFeature = ... # 0xf0c

    class MarkdownFeatures(object): ...

    class MetaInformation(Shiboken.Enum):
        DocumentTitle            : QTextDocument.MetaInformation = ... # 0x0
        DocumentUrl              : QTextDocument.MetaInformation = ... # 0x1

    class ResourceType(Shiboken.Enum):
        UnknownResource          : QTextDocument.ResourceType = ... # 0x0
        HtmlResource             : QTextDocument.ResourceType = ... # 0x1
        ImageResource            : QTextDocument.ResourceType = ... # 0x2
        StyleSheetResource       : QTextDocument.ResourceType = ... # 0x3
        MarkdownResource         : QTextDocument.ResourceType = ... # 0x4
        UserResource             : QTextDocument.ResourceType = ... # 0x64

    class Stacks(Shiboken.Enum):
        UndoStack                : QTextDocument.Stacks = ... # 0x1
        RedoStack                : QTextDocument.Stacks = ... # 0x2
        UndoAndRedoStacks        : QTextDocument.Stacks = ... # 0x3

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QTextDocumentFragment(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, document: PySide2.QtGui.QTextDocument) -> None: ...
    @typing.overload
    def __init__(self, range: PySide2.QtGui.QTextCursor) -> None: ...
    @typing.overload
    def __init__(self, rhs: PySide2.QtGui.QTextDocumentFragment) -> None: ...


class QTextDocumentWriter(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, device: PySide2.QtCore.QIODevice, format: PySide2.QtCore.QByteArray) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, format: PySide2.QtCore.QByteArray = ...) -> None: ...


class QTextFormat(Shiboken.Object):
    InvalidFormat            : QTextFormat.FormatType = ... # -0x1
    BlockFormat              : QTextFormat.FormatType = ... # 0x1
    CharFormat               : QTextFormat.FormatType = ... # 0x2
    ListFormat               : QTextFormat.FormatType = ... # 0x3
    TableFormat              : QTextFormat.FormatType = ... # 0x4
    FrameFormat              : QTextFormat.FormatType = ... # 0x5
    UserFormat               : QTextFormat.FormatType = ... # 0x64
    NoObject                 : QTextFormat.ObjectTypes = ... # 0x0
    ImageObject              : QTextFormat.ObjectTypes = ... # 0x1
    TableObject              : QTextFormat.ObjectTypes = ... # 0x2
    TableCellObject          : QTextFormat.ObjectTypes = ... # 0x3
    UserObject               : QTextFormat.ObjectTypes = ... # 0x1000
    PageBreak_Auto           : QTextFormat.PageBreakFlag = ... # 0x0
    PageBreak_AlwaysBefore   : QTextFormat.PageBreakFlag = ... # 0x1
    PageBreak_AlwaysAfter    : QTextFormat.PageBreakFlag = ... # 0x10
    ObjectIndex              : QTextFormat.Property = ... # 0x0
    CssFloat                 : QTextFormat.Property = ... # 0x800
    LayoutDirection          : QTextFormat.Property = ... # 0x801
    OutlinePen               : QTextFormat.Property = ... # 0x810
    BackgroundBrush          : QTextFormat.Property = ... # 0x820
    ForegroundBrush          : QTextFormat.Property = ... # 0x821
    BackgroundImageUrl       : QTextFormat.Property = ... # 0x823
    BlockAlignment           : QTextFormat.Property = ... # 0x1010
    BlockTopMargin           : QTextFormat.Property = ... # 0x1030
    BlockBottomMargin        : QTextFormat.Property = ... # 0x1031
    BlockLeftMargin          : QTextFormat.Property = ... # 0x1032
    BlockRightMargin         : QTextFormat.Property = ... # 0x1033
    TextIndent               : QTextFormat.Property = ... # 0x1034
    TabPositions             : QTextFormat.Property = ... # 0x1035
    BlockIndent              : QTextFormat.Property = ... # 0x1040
    LineHeight               : QTextFormat.Property = ... # 0x1048
    LineHeightType           : QTextFormat.Property = ... # 0x1049
    BlockNonBreakableLines   : QTextFormat.Property = ... # 0x1050
    BlockTrailingHorizontalRulerWidth: QTextFormat.Property = ... # 0x1060
    HeadingLevel             : QTextFormat.Property = ... # 0x1070
    BlockQuoteLevel          : QTextFormat.Property = ... # 0x1080
    BlockCodeLanguage        : QTextFormat.Property = ... # 0x1090
    BlockCodeFence           : QTextFormat.Property = ... # 0x1091
    BlockMarker              : QTextFormat.Property = ... # 0x10a0
    FirstFontProperty        : QTextFormat.Property = ... # 0x1fe0
    FontCapitalization       : QTextFormat.Property = ... # 0x1fe0
    FontLetterSpacing        : QTextFormat.Property = ... # 0x1fe1
    FontWordSpacing          : QTextFormat.Property = ... # 0x1fe2
    FontStyleHint            : QTextFormat.Property = ... # 0x1fe3
    FontStyleStrategy        : QTextFormat.Property = ... # 0x1fe4
    FontKerning              : QTextFormat.Property = ... # 0x1fe5
    FontHintingPreference    : QTextFormat.Property = ... # 0x1fe6
    FontFamilies             : QTextFormat.Property = ... # 0x1fe7
    FontStyleName            : QTextFormat.Property = ... # 0x1fe8
    FontFamily               : QTextFormat.Property = ... # 0x2000
    FontPointSize            : QTextFormat.Property = ... # 0x2001
    FontSizeAdjustment       : QTextFormat.Property = ... # 0x2002
    FontSizeIncrement        : QTextFormat.Property = ... # 0x2002
    FontWeight               : QTextFormat.Property = ... # 0x2003
    FontItalic               : QTextFormat.Property = ... # 0x2004
    FontUnderline            : QTextFormat.Property = ... # 0x2005
    FontOverline             : QTextFormat.Property = ... # 0x2006
    FontStrikeOut            : QTextFormat.Property = ... # 0x2007
    FontFixedPitch           : QTextFormat.Property = ... # 0x2008
    FontPixelSize            : QTextFormat.Property = ... # 0x2009
    LastFontProperty         : QTextFormat.Property = ... # 0x2009
    TextUnderlineColor       : QTextFormat.Property = ... # 0x2010
    TextVerticalAlignment    : QTextFormat.Property = ... # 0x2021
    TextOutline              : QTextFormat.Property = ... # 0x2022
    TextUnderlineStyle       : QTextFormat.Property = ... # 0x2023
    TextToolTip              : QTextFormat.Property = ... # 0x2024
    IsAnchor                 : QTextFormat.Property = ... # 0x2030
    AnchorHref               : QTextFormat.Property = ... # 0x2031
    AnchorName               : QTextFormat.Property = ... # 0x2032
    FontLetterSpacingType    : QTextFormat.Property = ... # 0x2033
    FontStretch              : QTextFormat.Property = ... # 0x2034
    ObjectType               : QTextFormat.Property = ... # 0x2f00
    ListStyle                : QTextFormat.Property = ... # 0x3000
    ListIndent               : QTextFormat.Property = ... # 0x3001
    ListNumberPrefix         : QTextFormat.Property = ... # 0x3002
    ListNumberSuffix         : QTextFormat.Property = ... # 0x3003
    FrameBorder              : QTextFormat.Property = ... # 0x4000
    FrameMargin              : QTextFormat.Property = ... # 0x4001
    FramePadding             : QTextFormat.Property = ... # 0x4002
    FrameWidth               : QTextFormat.Property = ... # 0x4003
    FrameHeight              : QTextFormat.Property = ... # 0x4004
    FrameTopMargin           : QTextFormat.Property = ... # 0x4005
    FrameBottomMargin        : QTextFormat.Property = ... # 0x4006
    FrameLeftMargin          : QTextFormat.Property = ... # 0x4007
    FrameRightMargin         : QTextFormat.Property = ... # 0x4008
    FrameBorderBrush         : QTextFormat.Property = ... # 0x4009
    FrameBorderStyle         : QTextFormat.Property = ... # 0x4010
    TableColumns             : QTextFormat.Property = ... # 0x4100
    TableColumnWidthConstraints: QTextFormat.Property = ... # 0x4101
    TableCellSpacing         : QTextFormat.Property = ... # 0x4102
    TableCellPadding         : QTextFormat.Property = ... # 0x4103
    TableHeaderRowCount      : QTextFormat.Property = ... # 0x4104
    TableBorderCollapse      : QTextFormat.Property = ... # 0x4105
    TableCellRowSpan         : QTextFormat.Property = ... # 0x4810
    TableCellColumnSpan      : QTextFormat.Property = ... # 0x4811
    TableCellTopPadding      : QTextFormat.Property = ... # 0x4812
    TableCellBottomPadding   : QTextFormat.Property = ... # 0x4813
    TableCellLeftPadding     : QTextFormat.Property = ... # 0x4814
    TableCellRightPadding    : QTextFormat.Property = ... # 0x4815
    TableCellTopBorder       : QTextFormat.Property = ... # 0x4816
    TableCellBottomBorder    : QTextFormat.Property = ... # 0x4817
    TableCellLeftBorder      : QTextFormat.Property = ... # 0x4818
    TableCellRightBorder     : QTextFormat.Property = ... # 0x4819
    TableCellTopBorderStyle  : QTextFormat.Property = ... # 0x481a
    TableCellBottomBorderStyle: QTextFormat.Property = ... # 0x481b
    TableCellLeftBorderStyle : QTextFormat.Property = ... # 0x481c
    TableCellRightBorderStyle: QTextFormat.Property = ... # 0x481d
    TableCellTopBorderBrush  : QTextFormat.Property = ... # 0x481e
    TableCellBottomBorderBrush: QTextFormat.Property = ... # 0x481f
    TableCellLeftBorderBrush : QTextFormat.Property = ... # 0x4820
    TableCellRightBorderBrush: QTextFormat.Property = ... # 0x4821
    ImageName                : QTextFormat.Property = ... # 0x5000
    ImageTitle               : QTextFormat.Property = ... # 0x5001
    ImageAltText             : QTextFormat.Property = ... # 0x5002
    ImageWidth               : QTextFormat.Property = ... # 0x5010
    ImageHeight              : QTextFormat.Property = ... # 0x5011
    ImageQuality             : QTextFormat.Property = ... # 0x5014
    FullWidthSelection       : QTextFormat.Property = ... # 0x6000
    PageBreakPolicy          : QTextFormat.Property = ... # 0x7000
    UserProperty             : QTextFormat.Property = ... # 0x100000

    class FormatType(Shiboken.Enum):
        InvalidFormat            : QTextFormat.FormatType = ... # -0x1
        BlockFormat              : QTextFormat.FormatType = ... # 0x1
        CharFormat               : QTextFormat.FormatType = ... # 0x2
        ListFormat               : QTextFormat.FormatType = ... # 0x3
        TableFormat              : QTextFormat.FormatType = ... # 0x4
        FrameFormat              : QTextFormat.FormatType = ... # 0x5
        UserFormat               : QTextFormat.FormatType = ... # 0x64

    class ObjectTypes(Shiboken.Enum):
        NoObject                 : QTextFormat.ObjectTypes = ... # 0x0
        ImageObject              : QTextFormat.ObjectTypes = ... # 0x1
        TableObject              : QTextFormat.ObjectTypes = ... # 0x2
        TableCellObject          : QTextFormat.ObjectTypes = ... # 0x3
        UserObject               : QTextFormat.ObjectTypes = ... # 0x1000

    class PageBreakFlag(Shiboken.Enum):
        PageBreak_Auto           : QTextFormat.PageBreakFlag = ... # 0x0
        PageBreak_AlwaysBefore   : QTextFormat.PageBreakFlag = ... # 0x1
        PageBreak_AlwaysAfter    : QTextFormat.PageBreakFlag = ... # 0x10

    class PageBreakFlags(object): ...

    class Property(Shiboken.Enum):
        ObjectIndex              : QTextFormat.Property = ... # 0x0
        CssFloat                 : QTextFormat.Property = ... # 0x800
        LayoutDirection          : QTextFormat.Property = ... # 0x801
        OutlinePen               : QTextFormat.Property = ... # 0x810
        BackgroundBrush          : QTextFormat.Property = ... # 0x820
        ForegroundBrush          : QTextFormat.Property = ... # 0x821
        BackgroundImageUrl       : QTextFormat.Property = ... # 0x823
        BlockAlignment           : QTextFormat.Property = ... # 0x1010
        BlockTopMargin           : QTextFormat.Property = ... # 0x1030
        BlockBottomMargin        : QTextFormat.Property = ... # 0x1031
        BlockLeftMargin          : QTextFormat.Property = ... # 0x1032
        BlockRightMargin         : QTextFormat.Property = ... # 0x1033
        TextIndent               : QTextFormat.Property = ... # 0x1034
        TabPositions             : QTextFormat.Property = ... # 0x1035
        BlockIndent              : QTextFormat.Property = ... # 0x1040
        LineHeight               : QTextFormat.Property = ... # 0x1048
        LineHeightType           : QTextFormat.Property = ... # 0x1049
        BlockNonBreakableLines   : QTextFormat.Property = ... # 0x1050
        BlockTrailingHorizontalRulerWidth: QTextFormat.Property = ... # 0x1060
        HeadingLevel             : QTextFormat.Property = ... # 0x1070
        BlockQuoteLevel          : QTextFormat.Property = ... # 0x1080
        BlockCodeLanguage        : QTextFormat.Property = ... # 0x1090
        BlockCodeFence           : QTextFormat.Property = ... # 0x1091
        BlockMarker              : QTextFormat.Property = ... # 0x10a0
        FirstFontProperty        : QTextFormat.Property = ... # 0x1fe0
        FontCapitalization       : QTextFormat.Property = ... # 0x1fe0
        FontLetterSpacing        : QTextFormat.Property = ... # 0x1fe1
        FontWordSpacing          : QTextFormat.Property = ... # 0x1fe2
        FontStyleHint            : QTextFormat.Property = ... # 0x1fe3
        FontStyleStrategy        : QTextFormat.Property = ... # 0x1fe4
        FontKerning              : QTextFormat.Property = ... # 0x1fe5
        FontHintingPreference    : QTextFormat.Property = ... # 0x1fe6
        FontFamilies             : QTextFormat.Property = ... # 0x1fe7
        FontStyleName            : QTextFormat.Property = ... # 0x1fe8
        FontFamily               : QTextFormat.Property = ... # 0x2000
        FontPointSize            : QTextFormat.Property = ... # 0x2001
        FontSizeAdjustment       : QTextFormat.Property = ... # 0x2002
        FontSizeIncrement        : QTextFormat.Property = ... # 0x2002
        FontWeight               : QTextFormat.Property = ... # 0x2003
        FontItalic               : QTextFormat.Property = ... # 0x2004
        FontUnderline            : QTextFormat.Property = ... # 0x2005
        FontOverline             : QTextFormat.Property = ... # 0x2006
        FontStrikeOut            : QTextFormat.Property = ... # 0x2007
        FontFixedPitch           : QTextFormat.Property = ... # 0x2008
        FontPixelSize            : QTextFormat.Property = ... # 0x2009
        LastFontProperty         : QTextFormat.Property = ... # 0x2009
        TextUnderlineColor       : QTextFormat.Property = ... # 0x2010
        TextVerticalAlignment    : QTextFormat.Property = ... # 0x2021
        TextOutline              : QTextFormat.Property = ... # 0x2022
        TextUnderlineStyle       : QTextFormat.Property = ... # 0x2023
        TextToolTip              : QTextFormat.Property = ... # 0x2024
        IsAnchor                 : QTextFormat.Property = ... # 0x2030
        AnchorHref               : QTextFormat.Property = ... # 0x2031
        AnchorName               : QTextFormat.Property = ... # 0x2032
        FontLetterSpacingType    : QTextFormat.Property = ... # 0x2033
        FontStretch              : QTextFormat.Property = ... # 0x2034
        ObjectType               : QTextFormat.Property = ... # 0x2f00
        ListStyle                : QTextFormat.Property = ... # 0x3000
        ListIndent               : QTextFormat.Property = ... # 0x3001
        ListNumberPrefix         : QTextFormat.Property = ... # 0x3002
        ListNumberSuffix         : QTextFormat.Property = ... # 0x3003
        FrameBorder              : QTextFormat.Property = ... # 0x4000
        FrameMargin              : QTextFormat.Property = ... # 0x4001
        FramePadding             : QTextFormat.Property = ... # 0x4002
        FrameWidth               : QTextFormat.Property = ... # 0x4003
        FrameHeight              : QTextFormat.Property = ... # 0x4004
        FrameTopMargin           : QTextFormat.Property = ... # 0x4005
        FrameBottomMargin        : QTextFormat.Property = ... # 0x4006
        FrameLeftMargin          : QTextFormat.Property = ... # 0x4007
        FrameRightMargin         : QTextFormat.Property = ... # 0x4008
        FrameBorderBrush         : QTextFormat.Property = ... # 0x4009
        FrameBorderStyle         : QTextFormat.Property = ... # 0x4010
        TableColumns             : QTextFormat.Property = ... # 0x4100
        TableColumnWidthConstraints: QTextFormat.Property = ... # 0x4101
        TableCellSpacing         : QTextFormat.Property = ... # 0x4102
        TableCellPadding         : QTextFormat.Property = ... # 0x4103
        TableHeaderRowCount      : QTextFormat.Property = ... # 0x4104
        TableBorderCollapse      : QTextFormat.Property = ... # 0x4105
        TableCellRowSpan         : QTextFormat.Property = ... # 0x4810
        TableCellColumnSpan      : QTextFormat.Property = ... # 0x4811
        TableCellTopPadding      : QTextFormat.Property = ... # 0x4812
        TableCellBottomPadding   : QTextFormat.Property = ... # 0x4813
        TableCellLeftPadding     : QTextFormat.Property = ... # 0x4814
        TableCellRightPadding    : QTextFormat.Property = ... # 0x4815
        TableCellTopBorder       : QTextFormat.Property = ... # 0x4816
        TableCellBottomBorder    : QTextFormat.Property = ... # 0x4817
        TableCellLeftBorder      : QTextFormat.Property = ... # 0x4818
        TableCellRightBorder     : QTextFormat.Property = ... # 0x4819
        TableCellTopBorderStyle  : QTextFormat.Property = ... # 0x481a
        TableCellBottomBorderStyle: QTextFormat.Property = ... # 0x481b
        TableCellLeftBorderStyle : QTextFormat.Property = ... # 0x481c
        TableCellRightBorderStyle: QTextFormat.Property = ... # 0x481d
        TableCellTopBorderBrush  : QTextFormat.Property = ... # 0x481e
        TableCellBottomBorderBrush: QTextFormat.Property = ... # 0x481f
        TableCellLeftBorderBrush : QTextFormat.Property = ... # 0x4820
        TableCellRightBorderBrush: QTextFormat.Property = ... # 0x4821
        ImageName                : QTextFormat.Property = ... # 0x5000
        ImageTitle               : QTextFormat.Property = ... # 0x5001
        ImageAltText             : QTextFormat.Property = ... # 0x5002
        ImageWidth               : QTextFormat.Property = ... # 0x5010
        ImageHeight              : QTextFormat.Property = ... # 0x5011
        ImageQuality             : QTextFormat.Property = ... # 0x5014
        FullWidthSelection       : QTextFormat.Property = ... # 0x6000
        PageBreakPolicy          : QTextFormat.Property = ... # 0x7000
        UserProperty             : QTextFormat.Property = ... # 0x100000

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, rhs: PySide2.QtGui.QTextFormat) -> None: ...
    @typing.overload
    def __init__(self, type: int) -> None: ...


class QTextFragment(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, o: PySide2.QtGui.QTextFragment) -> None: ...


class QTextFrame(PySide2.QtGui.QTextObject):

    class iterator(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, o: PySide2.QtGui.QTextFrame.iterator) -> None: ...


    def __init__(self, doc: PySide2.QtGui.QTextDocument) -> None: ...


class QTextFrameFormat(PySide2.QtGui.QTextFormat):
    BorderStyle_None         : QTextFrameFormat.BorderStyle = ... # 0x0
    BorderStyle_Dotted       : QTextFrameFormat.BorderStyle = ... # 0x1
    BorderStyle_Dashed       : QTextFrameFormat.BorderStyle = ... # 0x2
    BorderStyle_Solid        : QTextFrameFormat.BorderStyle = ... # 0x3
    BorderStyle_Double       : QTextFrameFormat.BorderStyle = ... # 0x4
    BorderStyle_DotDash      : QTextFrameFormat.BorderStyle = ... # 0x5
    BorderStyle_DotDotDash   : QTextFrameFormat.BorderStyle = ... # 0x6
    BorderStyle_Groove       : QTextFrameFormat.BorderStyle = ... # 0x7
    BorderStyle_Ridge        : QTextFrameFormat.BorderStyle = ... # 0x8
    BorderStyle_Inset        : QTextFrameFormat.BorderStyle = ... # 0x9
    BorderStyle_Outset       : QTextFrameFormat.BorderStyle = ... # 0xa
    InFlow                   : QTextFrameFormat.Position = ... # 0x0
    FloatLeft                : QTextFrameFormat.Position = ... # 0x1
    FloatRight               : QTextFrameFormat.Position = ... # 0x2

    class BorderStyle(Shiboken.Enum):
        BorderStyle_None         : QTextFrameFormat.BorderStyle = ... # 0x0
        BorderStyle_Dotted       : QTextFrameFormat.BorderStyle = ... # 0x1
        BorderStyle_Dashed       : QTextFrameFormat.BorderStyle = ... # 0x2
        BorderStyle_Solid        : QTextFrameFormat.BorderStyle = ... # 0x3
        BorderStyle_Double       : QTextFrameFormat.BorderStyle = ... # 0x4
        BorderStyle_DotDash      : QTextFrameFormat.BorderStyle = ... # 0x5
        BorderStyle_DotDotDash   : QTextFrameFormat.BorderStyle = ... # 0x6
        BorderStyle_Groove       : QTextFrameFormat.BorderStyle = ... # 0x7
        BorderStyle_Ridge        : QTextFrameFormat.BorderStyle = ... # 0x8
        BorderStyle_Inset        : QTextFrameFormat.BorderStyle = ... # 0x9
        BorderStyle_Outset       : QTextFrameFormat.BorderStyle = ... # 0xa

    class Position(Shiboken.Enum):
        InFlow                   : QTextFrameFormat.Position = ... # 0x0
        FloatLeft                : QTextFrameFormat.Position = ... # 0x1
        FloatRight               : QTextFrameFormat.Position = ... # 0x2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QTextFrameFormat: PySide2.QtGui.QTextFrameFormat) -> None: ...
    @typing.overload
    def __init__(self, fmt: PySide2.QtGui.QTextFormat) -> None: ...


class QTextImageFormat(PySide2.QtGui.QTextCharFormat):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QTextImageFormat: PySide2.QtGui.QTextImageFormat) -> None: ...
    @typing.overload
    def __init__(self, format: PySide2.QtGui.QTextFormat) -> None: ...


class QTextInlineObject(Shiboken.Object):

    def __init__(self) -> None: ...


class QTextItem(Shiboken.Object):
    RightToLeft              : QTextItem.RenderFlag = ... # 0x1
    Overline                 : QTextItem.RenderFlag = ... # 0x10
    Underline                : QTextItem.RenderFlag = ... # 0x20
    StrikeOut                : QTextItem.RenderFlag = ... # 0x40
    Dummy                    : QTextItem.RenderFlag = ... # -0x1

    class RenderFlag(Shiboken.Enum):
        RightToLeft              : QTextItem.RenderFlag = ... # 0x1
        Overline                 : QTextItem.RenderFlag = ... # 0x10
        Underline                : QTextItem.RenderFlag = ... # 0x20
        StrikeOut                : QTextItem.RenderFlag = ... # 0x40
        Dummy                    : QTextItem.RenderFlag = ... # -0x1

    class RenderFlags(object): ...

    def __init__(self) -> None: ...


class QTextLayout(Shiboken.Object):
    SkipCharacters           : QTextLayout.CursorMode = ... # 0x0
    SkipWords                : QTextLayout.CursorMode = ... # 0x1

    class CursorMode(Shiboken.Enum):
        SkipCharacters           : QTextLayout.CursorMode = ... # 0x0
        SkipWords                : QTextLayout.CursorMode = ... # 0x1

    class FormatRange(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, FormatRange: PySide2.QtGui.QTextLayout.FormatRange) -> None: ...


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, b: PySide2.QtGui.QTextBlock) -> None: ...
    @typing.overload
    def __init__(self, text: str) -> None: ...
    @typing.overload
    def __init__(self, text: str, font: PySide2.QtGui.QFont, paintdevice: typing.Optional[PySide2.QtGui.QPaintDevice] = ...) -> None: ...


class QTextLength(Shiboken.Object):
    VariableLength           : QTextLength.Type = ... # 0x0
    FixedLength              : QTextLength.Type = ... # 0x1
    PercentageLength         : QTextLength.Type = ... # 0x2

    class Type(Shiboken.Enum):
        VariableLength           : QTextLength.Type = ... # 0x0
        FixedLength              : QTextLength.Type = ... # 0x1
        PercentageLength         : QTextLength.Type = ... # 0x2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QTextLength: PySide2.QtGui.QTextLength) -> None: ...
    @typing.overload
    def __init__(self, type: PySide2.QtGui.QTextLength.Type, value: float) -> None: ...


class QTextLine(Shiboken.Object):
    CursorBetweenCharacters  : QTextLine.CursorPosition = ... # 0x0
    CursorOnCharacter        : QTextLine.CursorPosition = ... # 0x1
    Leading                  : QTextLine.Edge = ... # 0x0
    Trailing                 : QTextLine.Edge = ... # 0x1

    class CursorPosition(Shiboken.Enum):
        CursorBetweenCharacters  : QTextLine.CursorPosition = ... # 0x0
        CursorOnCharacter        : QTextLine.CursorPosition = ... # 0x1

    class Edge(Shiboken.Enum):
        Leading                  : QTextLine.Edge = ... # 0x0
        Trailing                 : QTextLine.Edge = ... # 0x1

    def __init__(self) -> None: ...


class QTextList(PySide2.QtGui.QTextBlockGroup):

    def __init__(self, doc: PySide2.QtGui.QTextDocument) -> None: ...


class QTextListFormat(PySide2.QtGui.QTextFormat):
    ListUpperRoman           : QTextListFormat.Style = ... # -0x8
    ListLowerRoman           : QTextListFormat.Style = ... # -0x7
    ListUpperAlpha           : QTextListFormat.Style = ... # -0x6
    ListLowerAlpha           : QTextListFormat.Style = ... # -0x5
    ListDecimal              : QTextListFormat.Style = ... # -0x4
    ListSquare               : QTextListFormat.Style = ... # -0x3
    ListCircle               : QTextListFormat.Style = ... # -0x2
    ListDisc                 : QTextListFormat.Style = ... # -0x1
    ListStyleUndefined       : QTextListFormat.Style = ... # 0x0

    class Style(Shiboken.Enum):
        ListUpperRoman           : QTextListFormat.Style = ... # -0x8
        ListLowerRoman           : QTextListFormat.Style = ... # -0x7
        ListUpperAlpha           : QTextListFormat.Style = ... # -0x6
        ListLowerAlpha           : QTextListFormat.Style = ... # -0x5
        ListDecimal              : QTextListFormat.Style = ... # -0x4
        ListSquare               : QTextListFormat.Style = ... # -0x3
        ListCircle               : QTextListFormat.Style = ... # -0x2
        ListDisc                 : QTextListFormat.Style = ... # -0x1
        ListStyleUndefined       : QTextListFormat.Style = ... # 0x0

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QTextListFormat: PySide2.QtGui.QTextListFormat) -> None: ...
    @typing.overload
    def __init__(self, fmt: PySide2.QtGui.QTextFormat) -> None: ...


class QTextObject(PySide2.QtCore.QObject):

    def __init__(self, doc: PySide2.QtGui.QTextDocument) -> None: ...


class QTextObjectInterface(Shiboken.Object):

    def __init__(self) -> None: ...


class QTextOption(Shiboken.Object):
    ShowTabsAndSpaces        : QTextOption.Flag = ... # 0x1
    ShowLineAndParagraphSeparators: QTextOption.Flag = ... # 0x2
    AddSpaceForLineAndParagraphSeparators: QTextOption.Flag = ... # 0x4
    SuppressColors           : QTextOption.Flag = ... # 0x8
    ShowDocumentTerminator   : QTextOption.Flag = ... # 0x10
    IncludeTrailingSpaces    : QTextOption.Flag = ... # -0x80000000
    LeftTab                  : QTextOption.TabType = ... # 0x0
    RightTab                 : QTextOption.TabType = ... # 0x1
    CenterTab                : QTextOption.TabType = ... # 0x2
    DelimiterTab             : QTextOption.TabType = ... # 0x3
    NoWrap                   : QTextOption.WrapMode = ... # 0x0
    WordWrap                 : QTextOption.WrapMode = ... # 0x1
    ManualWrap               : QTextOption.WrapMode = ... # 0x2
    WrapAnywhere             : QTextOption.WrapMode = ... # 0x3
    WrapAtWordBoundaryOrAnywhere: QTextOption.WrapMode = ... # 0x4

    class Flag(Shiboken.Enum):
        ShowTabsAndSpaces        : QTextOption.Flag = ... # 0x1
        ShowLineAndParagraphSeparators: QTextOption.Flag = ... # 0x2
        AddSpaceForLineAndParagraphSeparators: QTextOption.Flag = ... # 0x4
        SuppressColors           : QTextOption.Flag = ... # 0x8
        ShowDocumentTerminator   : QTextOption.Flag = ... # 0x10
        IncludeTrailingSpaces    : QTextOption.Flag = ... # -0x80000000

    class Flags(object): ...

    class Tab(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, Tab: PySide2.QtGui.QTextOption.Tab) -> None: ...
        @typing.overload
        def __init__(self, pos: float, tabType: PySide2.QtGui.QTextOption.TabType, delim: str = ...) -> None: ...


    class TabType(Shiboken.Enum):
        LeftTab                  : QTextOption.TabType = ... # 0x0
        RightTab                 : QTextOption.TabType = ... # 0x1
        CenterTab                : QTextOption.TabType = ... # 0x2
        DelimiterTab             : QTextOption.TabType = ... # 0x3

    class WrapMode(Shiboken.Enum):
        NoWrap                   : QTextOption.WrapMode = ... # 0x0
        WordWrap                 : QTextOption.WrapMode = ... # 0x1
        ManualWrap               : QTextOption.WrapMode = ... # 0x2
        WrapAnywhere             : QTextOption.WrapMode = ... # 0x3
        WrapAtWordBoundaryOrAnywhere: QTextOption.WrapMode = ... # 0x4

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, alignment: PySide2.QtCore.Qt.Alignment) -> None: ...
    @typing.overload
    def __init__(self, o: PySide2.QtGui.QTextOption) -> None: ...


class QTextTable(PySide2.QtGui.QTextFrame):

    def __init__(self, doc: PySide2.QtGui.QTextDocument) -> None: ...


class QTextTableCell(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, o: PySide2.QtGui.QTextTableCell) -> None: ...


class QTextTableCellFormat(PySide2.QtGui.QTextCharFormat):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QTextTableCellFormat: PySide2.QtGui.QTextTableCellFormat) -> None: ...
    @typing.overload
    def __init__(self, fmt: PySide2.QtGui.QTextFormat) -> None: ...


class QTextTableFormat(PySide2.QtGui.QTextFrameFormat):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QTextTableFormat: PySide2.QtGui.QTextTableFormat) -> None: ...
    @typing.overload
    def __init__(self, fmt: PySide2.QtGui.QTextFormat) -> None: ...


class QToolBarChangeEvent(PySide2.QtCore.QEvent):

    def __init__(self, t: bool) -> None: ...


class QTouchDevice(Shiboken.Object):
    Position                 : QTouchDevice.CapabilityFlag = ... # 0x1
    Area                     : QTouchDevice.CapabilityFlag = ... # 0x2
    Pressure                 : QTouchDevice.CapabilityFlag = ... # 0x4
    Velocity                 : QTouchDevice.CapabilityFlag = ... # 0x8
    RawPositions             : QTouchDevice.CapabilityFlag = ... # 0x10
    NormalizedPosition       : QTouchDevice.CapabilityFlag = ... # 0x20
    MouseEmulation           : QTouchDevice.CapabilityFlag = ... # 0x40
    TouchScreen              : QTouchDevice.DeviceType = ... # 0x0
    TouchPad                 : QTouchDevice.DeviceType = ... # 0x1

    class Capabilities(object): ...

    class CapabilityFlag(Shiboken.Enum):
        Position                 : QTouchDevice.CapabilityFlag = ... # 0x1
        Area                     : QTouchDevice.CapabilityFlag = ... # 0x2
        Pressure                 : QTouchDevice.CapabilityFlag = ... # 0x4
        Velocity                 : QTouchDevice.CapabilityFlag = ... # 0x8
        RawPositions             : QTouchDevice.CapabilityFlag = ... # 0x10
        NormalizedPosition       : QTouchDevice.CapabilityFlag = ... # 0x20
        MouseEmulation           : QTouchDevice.CapabilityFlag = ... # 0x40

    class DeviceType(Shiboken.Enum):
        TouchScreen              : QTouchDevice.DeviceType = ... # 0x0
        TouchPad                 : QTouchDevice.DeviceType = ... # 0x1

    def __init__(self) -> None: ...


class QTouchEvent(PySide2.QtGui.QInputEvent):

    class TouchPoint(Shiboken.Object):
        Pen                      : QTouchEvent.TouchPoint.InfoFlag = ... # 0x1
        Token                    : QTouchEvent.TouchPoint.InfoFlag = ... # 0x2

        class InfoFlag(Shiboken.Enum):
            Pen                      : QTouchEvent.TouchPoint.InfoFlag = ... # 0x1
            Token                    : QTouchEvent.TouchPoint.InfoFlag = ... # 0x2

        class InfoFlags(object): ...

        @typing.overload
        def __init__(self, id: int = ...) -> None: ...
        @typing.overload
        def __init__(self, other: PySide2.QtGui.QTouchEvent.TouchPoint) -> None: ...


    def __init__(self, eventType: PySide2.QtCore.QEvent.Type, device: typing.Optional[PySide2.QtGui.QTouchDevice] = ..., modifiers: PySide2.QtCore.Qt.KeyboardModifiers = ..., touchPointStates: PySide2.QtCore.Qt.TouchPointStates = ..., touchPoints: typing.Sequence[PySide2.QtGui.QTouchEvent.TouchPoint] = ...) -> None: ...


class QTransform(Shiboken.Object):
    TxNone                   : QTransform.TransformationType = ... # 0x0
    TxTranslate              : QTransform.TransformationType = ... # 0x1
    TxScale                  : QTransform.TransformationType = ... # 0x2
    TxRotate                 : QTransform.TransformationType = ... # 0x4
    TxShear                  : QTransform.TransformationType = ... # 0x8
    TxProject                : QTransform.TransformationType = ... # 0x10

    class TransformationType(Shiboken.Enum):
        TxNone                   : QTransform.TransformationType = ... # 0x0
        TxTranslate              : QTransform.TransformationType = ... # 0x1
        TxScale                  : QTransform.TransformationType = ... # 0x2
        TxRotate                 : QTransform.TransformationType = ... # 0x4
        TxShear                  : QTransform.TransformationType = ... # 0x8
        TxProject                : QTransform.TransformationType = ... # 0x10

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, h11: float, h12: float, h13: float, h21: float, h22: float, h23: float, h31: float, h32: float, h33: float = ...) -> None: ...
    @typing.overload
    def __init__(self, h11: float, h12: float, h21: float, h22: float, dx: float, dy: float) -> None: ...
    @typing.overload
    def __init__(self, mtx: PySide2.QtGui.QMatrix) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtGui.QTransform) -> None: ...


class QValidator(PySide2.QtCore.QObject):
    Invalid                  : QValidator.State = ... # 0x0
    Intermediate             : QValidator.State = ... # 0x1
    Acceptable               : QValidator.State = ... # 0x2

    class State(Shiboken.Enum):
        Invalid                  : QValidator.State = ... # 0x0
        Intermediate             : QValidator.State = ... # 0x1
        Acceptable               : QValidator.State = ... # 0x2

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QVector2D(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, point: PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, point: PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def __init__(self, vector: PySide2.QtGui.QVector3D) -> None: ...
    @typing.overload
    def __init__(self, vector: PySide2.QtGui.QVector4D) -> None: ...
    @typing.overload
    def __init__(self, xpos: float, ypos: float) -> None: ...


class QVector3D(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, point: PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, point: PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def __init__(self, vector: PySide2.QtGui.QVector2D) -> None: ...
    @typing.overload
    def __init__(self, vector: PySide2.QtGui.QVector2D, zpos: float) -> None: ...
    @typing.overload
    def __init__(self, vector: PySide2.QtGui.QVector4D) -> None: ...
    @typing.overload
    def __init__(self, xpos: float, ypos: float, zpos: float) -> None: ...


class QVector4D(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, point: PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, point: PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def __init__(self, vector: PySide2.QtGui.QVector2D) -> None: ...
    @typing.overload
    def __init__(self, vector: PySide2.QtGui.QVector2D, zpos: float, wpos: float) -> None: ...
    @typing.overload
    def __init__(self, vector: PySide2.QtGui.QVector3D) -> None: ...
    @typing.overload
    def __init__(self, vector: PySide2.QtGui.QVector3D, wpos: float) -> None: ...
    @typing.overload
    def __init__(self, xpos: float, ypos: float, zpos: float, wpos: float) -> None: ...


class QWhatsThisClickedEvent(PySide2.QtCore.QEvent):

    def __init__(self, href: str) -> None: ...


class QWheelEvent(PySide2.QtGui.QInputEvent):

    @typing.overload
    def __init__(self, pos: PySide2.QtCore.QPointF, delta: int, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers, orient: PySide2.QtCore.Qt.Orientation = ...) -> None: ...
    @typing.overload
    def __init__(self, pos: PySide2.QtCore.QPointF, globalPos: PySide2.QtCore.QPointF, delta: int, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers, orient: PySide2.QtCore.Qt.Orientation = ...) -> None: ...
    @typing.overload
    def __init__(self, pos: PySide2.QtCore.QPointF, globalPos: PySide2.QtCore.QPointF, pixelDelta: PySide2.QtCore.QPoint, angleDelta: PySide2.QtCore.QPoint, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers, phase: PySide2.QtCore.Qt.ScrollPhase, inverted: bool, source: PySide2.QtCore.Qt.MouseEventSource = ...) -> None: ...
    @typing.overload
    def __init__(self, pos: PySide2.QtCore.QPointF, globalPos: PySide2.QtCore.QPointF, pixelDelta: PySide2.QtCore.QPoint, angleDelta: PySide2.QtCore.QPoint, qt4Delta: int, qt4Orientation: PySide2.QtCore.Qt.Orientation, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers) -> None: ...
    @typing.overload
    def __init__(self, pos: PySide2.QtCore.QPointF, globalPos: PySide2.QtCore.QPointF, pixelDelta: PySide2.QtCore.QPoint, angleDelta: PySide2.QtCore.QPoint, qt4Delta: int, qt4Orientation: PySide2.QtCore.Qt.Orientation, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers, phase: PySide2.QtCore.Qt.ScrollPhase) -> None: ...
    @typing.overload
    def __init__(self, pos: PySide2.QtCore.QPointF, globalPos: PySide2.QtCore.QPointF, pixelDelta: PySide2.QtCore.QPoint, angleDelta: PySide2.QtCore.QPoint, qt4Delta: int, qt4Orientation: PySide2.QtCore.Qt.Orientation, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers, phase: PySide2.QtCore.Qt.ScrollPhase, source: PySide2.QtCore.Qt.MouseEventSource) -> None: ...
    @typing.overload
    def __init__(self, pos: PySide2.QtCore.QPointF, globalPos: PySide2.QtCore.QPointF, pixelDelta: PySide2.QtCore.QPoint, angleDelta: PySide2.QtCore.QPoint, qt4Delta: int, qt4Orientation: PySide2.QtCore.Qt.Orientation, buttons: PySide2.QtCore.Qt.MouseButtons, modifiers: PySide2.QtCore.Qt.KeyboardModifiers, phase: PySide2.QtCore.Qt.ScrollPhase, source: PySide2.QtCore.Qt.MouseEventSource, inverted: bool) -> None: ...


class QWindow(PySide2.QtCore.QObject, PySide2.QtGui.QSurface):
    ExcludeTransients        : QWindow.AncestorMode = ... # 0x0
    IncludeTransients        : QWindow.AncestorMode = ... # 0x1
    Hidden                   : QWindow.Visibility = ... # 0x0
    AutomaticVisibility      : QWindow.Visibility = ... # 0x1
    Windowed                 : QWindow.Visibility = ... # 0x2
    Minimized                : QWindow.Visibility = ... # 0x3
    Maximized                : QWindow.Visibility = ... # 0x4
    FullScreen               : QWindow.Visibility = ... # 0x5

    class AncestorMode(Shiboken.Enum):
        ExcludeTransients        : QWindow.AncestorMode = ... # 0x0
        IncludeTransients        : QWindow.AncestorMode = ... # 0x1

    class Visibility(Shiboken.Enum):
        Hidden                   : QWindow.Visibility = ... # 0x0
        AutomaticVisibility      : QWindow.Visibility = ... # 0x1
        Windowed                 : QWindow.Visibility = ... # 0x2
        Minimized                : QWindow.Visibility = ... # 0x3
        Maximized                : QWindow.Visibility = ... # 0x4
        FullScreen               : QWindow.Visibility = ... # 0x5

    @typing.overload
    def __init__(self, parent: PySide2.QtGui.QWindow) -> None: ...
    @typing.overload
    def __init__(self, screen: typing.Optional[PySide2.QtGui.QScreen] = ...) -> None: ...


class QWindowStateChangeEvent(PySide2.QtCore.QEvent):

    def __init__(self, aOldState: PySide2.QtCore.Qt.WindowStates, isOverride: bool = ...) -> None: ...


class Qt(PySide2.QtCore.Qt): ...
def qAlpha(rgb: int) -> int: ...
def qBlue(rgb: int) -> int: ...
@typing.overload
def qGray(r: int, g: int, b: int) -> int: ...
@typing.overload
def qGray(rgb: int) -> int: ...
def qGreen(rgb: int) -> int: ...
def qIsGray(rgb: int) -> bool: ...
def qRed(rgb: int) -> int: ...
def qRgb(r: int, g: int, b: int) -> int: ...
def qRgba(r: int, g: int, b: int, a: int) -> int: ...

# eof
