#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtHelp, except for defaults which are replaced by "...".
"""

# Module PySide2.QtHelp
import PySide2
try:
    import typing
except ImportError:
    from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

from shiboken2 import Shiboken

import PySide2.QtCore
import PySide2.QtWidgets
import PySide2.QtHelp


class QCompressedHelpInfo(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtHelp.QCompressedHelpInfo) -> None: ...


class QHelpContentItem(Shiboken.Object): ...


class QHelpContentModel(PySide2.QtCore.QAbstractItemModel): ...


class QHelpContentWidget(PySide2.QtWidgets.QTreeView): ...


class QHelpEngine(PySide2.QtHelp.QHelpEngineCore):

    def __init__(self, collectionFile: str, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QHelpEngineCore(PySide2.QtCore.QObject):

    def __init__(self, collectionFile: str, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QHelpFilterData(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtHelp.QHelpFilterData) -> None: ...


class QHelpFilterEngine(PySide2.QtCore.QObject):

    def __init__(self, helpEngine: PySide2.QtHelp.QHelpEngineCore) -> None: ...


class QHelpFilterSettingsWidget(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QHelpIndexModel(PySide2.QtCore.QStringListModel): ...


class QHelpIndexWidget(PySide2.QtWidgets.QListView): ...


class QHelpLink(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QHelpLink: PySide2.QtHelp.QHelpLink) -> None: ...


class QHelpSearchEngine(PySide2.QtCore.QObject):

    def __init__(self, helpEngine: PySide2.QtHelp.QHelpEngineCore, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QHelpSearchQuery(Shiboken.Object):
    DEFAULT                  : QHelpSearchQuery.FieldName = ... # 0x0
    FUZZY                    : QHelpSearchQuery.FieldName = ... # 0x1
    WITHOUT                  : QHelpSearchQuery.FieldName = ... # 0x2
    PHRASE                   : QHelpSearchQuery.FieldName = ... # 0x3
    ALL                      : QHelpSearchQuery.FieldName = ... # 0x4
    ATLEAST                  : QHelpSearchQuery.FieldName = ... # 0x5

    class FieldName(Shiboken.Enum):
        DEFAULT                  : QHelpSearchQuery.FieldName = ... # 0x0
        FUZZY                    : QHelpSearchQuery.FieldName = ... # 0x1
        WITHOUT                  : QHelpSearchQuery.FieldName = ... # 0x2
        PHRASE                   : QHelpSearchQuery.FieldName = ... # 0x3
        ALL                      : QHelpSearchQuery.FieldName = ... # 0x4
        ATLEAST                  : QHelpSearchQuery.FieldName = ... # 0x5

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QHelpSearchQuery: PySide2.QtHelp.QHelpSearchQuery) -> None: ...
    @typing.overload
    def __init__(self, field: PySide2.QtHelp.QHelpSearchQuery.FieldName, wordList_: typing.Sequence[str]) -> None: ...


class QHelpSearchQueryWidget(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QHelpSearchResult(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtHelp.QHelpSearchResult) -> None: ...
    @typing.overload
    def __init__(self, url: PySide2.QtCore.QUrl, title: str, snippet: str) -> None: ...


class QHelpSearchResultWidget(PySide2.QtWidgets.QWidget): ...

# eof
