#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtMultimedia, except for defaults which are replaced by "...".
"""

# Module PySide2.QtMultimedia
import PySide2
try:
    import typing
except ImportError:
    from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

from shiboken2 import Shiboken

import PySide2.QtCore
import PySide2.QtGui
import PySide2.QtNetwork
import PySide2.QtMultimedia


class QAbstractAudioDeviceInfo(PySide2.QtCore.QObject):

    def __init__(self) -> None: ...


class QAbstractAudioInput(PySide2.QtCore.QObject):

    def __init__(self) -> None: ...


class QAbstractAudioOutput(PySide2.QtCore.QObject):

    def __init__(self) -> None: ...


class QAbstractVideoBuffer(Shiboken.Object):
    NoHandle                 : QAbstractVideoBuffer.HandleType = ... # 0x0
    GLTextureHandle          : QAbstractVideoBuffer.HandleType = ... # 0x1
    XvShmImageHandle         : QAbstractVideoBuffer.HandleType = ... # 0x2
    CoreImageHandle          : QAbstractVideoBuffer.HandleType = ... # 0x3
    QPixmapHandle            : QAbstractVideoBuffer.HandleType = ... # 0x4
    EGLImageHandle           : QAbstractVideoBuffer.HandleType = ... # 0x5
    GLTextureRectangleHandle : QAbstractVideoBuffer.HandleType = ... # 0x6
    UserHandle               : QAbstractVideoBuffer.HandleType = ... # 0x3e8
    NotMapped                : QAbstractVideoBuffer.MapMode = ... # 0x0
    ReadOnly                 : QAbstractVideoBuffer.MapMode = ... # 0x1
    WriteOnly                : QAbstractVideoBuffer.MapMode = ... # 0x2
    ReadWrite                : QAbstractVideoBuffer.MapMode = ... # 0x3

    class HandleType(Shiboken.Enum):
        NoHandle                 : QAbstractVideoBuffer.HandleType = ... # 0x0
        GLTextureHandle          : QAbstractVideoBuffer.HandleType = ... # 0x1
        XvShmImageHandle         : QAbstractVideoBuffer.HandleType = ... # 0x2
        CoreImageHandle          : QAbstractVideoBuffer.HandleType = ... # 0x3
        QPixmapHandle            : QAbstractVideoBuffer.HandleType = ... # 0x4
        EGLImageHandle           : QAbstractVideoBuffer.HandleType = ... # 0x5
        GLTextureRectangleHandle : QAbstractVideoBuffer.HandleType = ... # 0x6
        UserHandle               : QAbstractVideoBuffer.HandleType = ... # 0x3e8

    class MapMode(Shiboken.Enum):
        NotMapped                : QAbstractVideoBuffer.MapMode = ... # 0x0
        ReadOnly                 : QAbstractVideoBuffer.MapMode = ... # 0x1
        WriteOnly                : QAbstractVideoBuffer.MapMode = ... # 0x2
        ReadWrite                : QAbstractVideoBuffer.MapMode = ... # 0x3

    def __init__(self, type: PySide2.QtMultimedia.QAbstractVideoBuffer.HandleType) -> None: ...


class QAbstractVideoFilter(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QAbstractVideoSurface(PySide2.QtCore.QObject):
    NoError                  : QAbstractVideoSurface.Error = ... # 0x0
    UnsupportedFormatError   : QAbstractVideoSurface.Error = ... # 0x1
    IncorrectFormatError     : QAbstractVideoSurface.Error = ... # 0x2
    StoppedError             : QAbstractVideoSurface.Error = ... # 0x3
    ResourceError            : QAbstractVideoSurface.Error = ... # 0x4

    class Error(Shiboken.Enum):
        NoError                  : QAbstractVideoSurface.Error = ... # 0x0
        UnsupportedFormatError   : QAbstractVideoSurface.Error = ... # 0x1
        IncorrectFormatError     : QAbstractVideoSurface.Error = ... # 0x2
        StoppedError             : QAbstractVideoSurface.Error = ... # 0x3
        ResourceError            : QAbstractVideoSurface.Error = ... # 0x4

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QAudio(Shiboken.Object):
    NoError                  : QAudio.Error = ... # 0x0
    OpenError                : QAudio.Error = ... # 0x1
    IOError                  : QAudio.Error = ... # 0x2
    UnderrunError            : QAudio.Error = ... # 0x3
    FatalError               : QAudio.Error = ... # 0x4
    AudioInput               : QAudio.Mode = ... # 0x0
    AudioOutput              : QAudio.Mode = ... # 0x1
    UnknownRole              : QAudio.Role = ... # 0x0
    MusicRole                : QAudio.Role = ... # 0x1
    VideoRole                : QAudio.Role = ... # 0x2
    VoiceCommunicationRole   : QAudio.Role = ... # 0x3
    AlarmRole                : QAudio.Role = ... # 0x4
    NotificationRole         : QAudio.Role = ... # 0x5
    RingtoneRole             : QAudio.Role = ... # 0x6
    AccessibilityRole        : QAudio.Role = ... # 0x7
    SonificationRole         : QAudio.Role = ... # 0x8
    GameRole                 : QAudio.Role = ... # 0x9
    CustomRole               : QAudio.Role = ... # 0xa
    ActiveState              : QAudio.State = ... # 0x0
    SuspendedState           : QAudio.State = ... # 0x1
    StoppedState             : QAudio.State = ... # 0x2
    IdleState                : QAudio.State = ... # 0x3
    InterruptedState         : QAudio.State = ... # 0x4
    LinearVolumeScale        : QAudio.VolumeScale = ... # 0x0
    CubicVolumeScale         : QAudio.VolumeScale = ... # 0x1
    LogarithmicVolumeScale   : QAudio.VolumeScale = ... # 0x2
    DecibelVolumeScale       : QAudio.VolumeScale = ... # 0x3

    class Error(Shiboken.Enum):
        NoError                  : QAudio.Error = ... # 0x0
        OpenError                : QAudio.Error = ... # 0x1
        IOError                  : QAudio.Error = ... # 0x2
        UnderrunError            : QAudio.Error = ... # 0x3
        FatalError               : QAudio.Error = ... # 0x4

    class Mode(Shiboken.Enum):
        AudioInput               : QAudio.Mode = ... # 0x0
        AudioOutput              : QAudio.Mode = ... # 0x1

    class Role(Shiboken.Enum):
        UnknownRole              : QAudio.Role = ... # 0x0
        MusicRole                : QAudio.Role = ... # 0x1
        VideoRole                : QAudio.Role = ... # 0x2
        VoiceCommunicationRole   : QAudio.Role = ... # 0x3
        AlarmRole                : QAudio.Role = ... # 0x4
        NotificationRole         : QAudio.Role = ... # 0x5
        RingtoneRole             : QAudio.Role = ... # 0x6
        AccessibilityRole        : QAudio.Role = ... # 0x7
        SonificationRole         : QAudio.Role = ... # 0x8
        GameRole                 : QAudio.Role = ... # 0x9
        CustomRole               : QAudio.Role = ... # 0xa

    class State(Shiboken.Enum):
        ActiveState              : QAudio.State = ... # 0x0
        SuspendedState           : QAudio.State = ... # 0x1
        StoppedState             : QAudio.State = ... # 0x2
        IdleState                : QAudio.State = ... # 0x3
        InterruptedState         : QAudio.State = ... # 0x4

    class VolumeScale(Shiboken.Enum):
        LinearVolumeScale        : QAudio.VolumeScale = ... # 0x0
        CubicVolumeScale         : QAudio.VolumeScale = ... # 0x1
        LogarithmicVolumeScale   : QAudio.VolumeScale = ... # 0x2
        DecibelVolumeScale       : QAudio.VolumeScale = ... # 0x3


class QAudioBuffer(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, data: PySide2.QtCore.QByteArray, format: PySide2.QtMultimedia.QAudioFormat, startTime: int = ...) -> None: ...
    @typing.overload
    def __init__(self, numFrames: int, format: PySide2.QtMultimedia.QAudioFormat, startTime: int = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QAudioBuffer) -> None: ...


class QAudioDecoder(PySide2.QtMultimedia.QMediaObject):
    NoError                  : QAudioDecoder.Error = ... # 0x0
    ResourceError            : QAudioDecoder.Error = ... # 0x1
    FormatError              : QAudioDecoder.Error = ... # 0x2
    AccessDeniedError        : QAudioDecoder.Error = ... # 0x3
    ServiceMissingError      : QAudioDecoder.Error = ... # 0x4
    StoppedState             : QAudioDecoder.State = ... # 0x0
    DecodingState            : QAudioDecoder.State = ... # 0x1

    class Error(Shiboken.Enum):
        NoError                  : QAudioDecoder.Error = ... # 0x0
        ResourceError            : QAudioDecoder.Error = ... # 0x1
        FormatError              : QAudioDecoder.Error = ... # 0x2
        AccessDeniedError        : QAudioDecoder.Error = ... # 0x3
        ServiceMissingError      : QAudioDecoder.Error = ... # 0x4

    class State(Shiboken.Enum):
        StoppedState             : QAudioDecoder.State = ... # 0x0
        DecodingState            : QAudioDecoder.State = ... # 0x1

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QAudioDecoderControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QAudioDeviceInfo(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QAudioDeviceInfo) -> None: ...


class QAudioEncoderSettings(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QAudioEncoderSettings) -> None: ...


class QAudioEncoderSettingsControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QAudioFormat(Shiboken.Object):
    BigEndian                : QAudioFormat.Endian = ... # 0x0
    LittleEndian             : QAudioFormat.Endian = ... # 0x1
    Unknown                  : QAudioFormat.SampleType = ... # 0x0
    SignedInt                : QAudioFormat.SampleType = ... # 0x1
    UnSignedInt              : QAudioFormat.SampleType = ... # 0x2
    Float                    : QAudioFormat.SampleType = ... # 0x3

    class Endian(Shiboken.Enum):
        BigEndian                : QAudioFormat.Endian = ... # 0x0
        LittleEndian             : QAudioFormat.Endian = ... # 0x1

    class SampleType(Shiboken.Enum):
        Unknown                  : QAudioFormat.SampleType = ... # 0x0
        SignedInt                : QAudioFormat.SampleType = ... # 0x1
        UnSignedInt              : QAudioFormat.SampleType = ... # 0x2
        Float                    : QAudioFormat.SampleType = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QAudioFormat) -> None: ...


class QAudioInput(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, audioDeviceInfo: PySide2.QtMultimedia.QAudioDeviceInfo, format: PySide2.QtMultimedia.QAudioFormat = ..., parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, format: PySide2.QtMultimedia.QAudioFormat = ..., parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QAudioInputSelectorControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QAudioOutput(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, audioDeviceInfo: PySide2.QtMultimedia.QAudioDeviceInfo, format: PySide2.QtMultimedia.QAudioFormat = ..., parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, format: PySide2.QtMultimedia.QAudioFormat = ..., parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QAudioOutputSelectorControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QAudioProbe(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QAudioRecorder(PySide2.QtMultimedia.QMediaRecorder):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QAudioRoleControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QCamera(PySide2.QtMultimedia.QMediaObject):
    CaptureViewfinder        : QCamera.CaptureMode = ... # 0x0
    CaptureStillImage        : QCamera.CaptureMode = ... # 0x1
    CaptureVideo             : QCamera.CaptureMode = ... # 0x2
    NoError                  : QCamera.Error = ... # 0x0
    CameraError              : QCamera.Error = ... # 0x1
    InvalidRequestError      : QCamera.Error = ... # 0x2
    ServiceMissingError      : QCamera.Error = ... # 0x3
    NotSupportedFeatureError : QCamera.Error = ... # 0x4
    UserRequest              : QCamera.LockChangeReason = ... # 0x0
    LockAcquired             : QCamera.LockChangeReason = ... # 0x1
    LockFailed               : QCamera.LockChangeReason = ... # 0x2
    LockLost                 : QCamera.LockChangeReason = ... # 0x3
    LockTemporaryLost        : QCamera.LockChangeReason = ... # 0x4
    Unlocked                 : QCamera.LockStatus = ... # 0x0
    Searching                : QCamera.LockStatus = ... # 0x1
    Locked                   : QCamera.LockStatus = ... # 0x2
    NoLock                   : QCamera.LockType = ... # 0x0
    LockExposure             : QCamera.LockType = ... # 0x1
    LockWhiteBalance         : QCamera.LockType = ... # 0x2
    LockFocus                : QCamera.LockType = ... # 0x4
    UnspecifiedPosition      : QCamera.Position = ... # 0x0
    BackFace                 : QCamera.Position = ... # 0x1
    FrontFace                : QCamera.Position = ... # 0x2
    UnloadedState            : QCamera.State = ... # 0x0
    LoadedState              : QCamera.State = ... # 0x1
    ActiveState              : QCamera.State = ... # 0x2
    UnavailableStatus        : QCamera.Status = ... # 0x0
    UnloadedStatus           : QCamera.Status = ... # 0x1
    LoadingStatus            : QCamera.Status = ... # 0x2
    UnloadingStatus          : QCamera.Status = ... # 0x3
    LoadedStatus             : QCamera.Status = ... # 0x4
    StandbyStatus            : QCamera.Status = ... # 0x5
    StartingStatus           : QCamera.Status = ... # 0x6
    StoppingStatus           : QCamera.Status = ... # 0x7
    ActiveStatus             : QCamera.Status = ... # 0x8

    class CaptureMode(Shiboken.Enum):
        CaptureViewfinder        : QCamera.CaptureMode = ... # 0x0
        CaptureStillImage        : QCamera.CaptureMode = ... # 0x1
        CaptureVideo             : QCamera.CaptureMode = ... # 0x2

    class CaptureModes(object): ...

    class Error(Shiboken.Enum):
        NoError                  : QCamera.Error = ... # 0x0
        CameraError              : QCamera.Error = ... # 0x1
        InvalidRequestError      : QCamera.Error = ... # 0x2
        ServiceMissingError      : QCamera.Error = ... # 0x3
        NotSupportedFeatureError : QCamera.Error = ... # 0x4

    class FrameRateRange(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, FrameRateRange: PySide2.QtMultimedia.QCamera.FrameRateRange) -> None: ...
        @typing.overload
        def __init__(self, minimum: float, maximum: float) -> None: ...


    class LockChangeReason(Shiboken.Enum):
        UserRequest              : QCamera.LockChangeReason = ... # 0x0
        LockAcquired             : QCamera.LockChangeReason = ... # 0x1
        LockFailed               : QCamera.LockChangeReason = ... # 0x2
        LockLost                 : QCamera.LockChangeReason = ... # 0x3
        LockTemporaryLost        : QCamera.LockChangeReason = ... # 0x4

    class LockStatus(Shiboken.Enum):
        Unlocked                 : QCamera.LockStatus = ... # 0x0
        Searching                : QCamera.LockStatus = ... # 0x1
        Locked                   : QCamera.LockStatus = ... # 0x2

    class LockType(Shiboken.Enum):
        NoLock                   : QCamera.LockType = ... # 0x0
        LockExposure             : QCamera.LockType = ... # 0x1
        LockWhiteBalance         : QCamera.LockType = ... # 0x2
        LockFocus                : QCamera.LockType = ... # 0x4

    class LockTypes(object): ...

    class Position(Shiboken.Enum):
        UnspecifiedPosition      : QCamera.Position = ... # 0x0
        BackFace                 : QCamera.Position = ... # 0x1
        FrontFace                : QCamera.Position = ... # 0x2

    class State(Shiboken.Enum):
        UnloadedState            : QCamera.State = ... # 0x0
        LoadedState              : QCamera.State = ... # 0x1
        ActiveState              : QCamera.State = ... # 0x2

    class Status(Shiboken.Enum):
        UnavailableStatus        : QCamera.Status = ... # 0x0
        UnloadedStatus           : QCamera.Status = ... # 0x1
        LoadingStatus            : QCamera.Status = ... # 0x2
        UnloadingStatus          : QCamera.Status = ... # 0x3
        LoadedStatus             : QCamera.Status = ... # 0x4
        StandbyStatus            : QCamera.Status = ... # 0x5
        StartingStatus           : QCamera.Status = ... # 0x6
        StoppingStatus           : QCamera.Status = ... # 0x7
        ActiveStatus             : QCamera.Status = ... # 0x8

    @typing.overload
    def __init__(self, cameraInfo: PySide2.QtMultimedia.QCameraInfo, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, deviceName: PySide2.QtCore.QByteArray, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, position: PySide2.QtMultimedia.QCamera.Position, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QCameraCaptureBufferFormatControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QCameraCaptureDestinationControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QCameraControl(PySide2.QtMultimedia.QMediaControl):
    CaptureMode              : QCameraControl.PropertyChangeType = ... # 0x1
    ImageEncodingSettings    : QCameraControl.PropertyChangeType = ... # 0x2
    VideoEncodingSettings    : QCameraControl.PropertyChangeType = ... # 0x3
    Viewfinder               : QCameraControl.PropertyChangeType = ... # 0x4
    ViewfinderSettings       : QCameraControl.PropertyChangeType = ... # 0x5

    class PropertyChangeType(Shiboken.Enum):
        CaptureMode              : QCameraControl.PropertyChangeType = ... # 0x1
        ImageEncodingSettings    : QCameraControl.PropertyChangeType = ... # 0x2
        VideoEncodingSettings    : QCameraControl.PropertyChangeType = ... # 0x3
        Viewfinder               : QCameraControl.PropertyChangeType = ... # 0x4
        ViewfinderSettings       : QCameraControl.PropertyChangeType = ... # 0x5

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QCameraExposure(PySide2.QtCore.QObject):
    ExposureAuto             : QCameraExposure.ExposureMode = ... # 0x0
    ExposureManual           : QCameraExposure.ExposureMode = ... # 0x1
    ExposurePortrait         : QCameraExposure.ExposureMode = ... # 0x2
    ExposureNight            : QCameraExposure.ExposureMode = ... # 0x3
    ExposureBacklight        : QCameraExposure.ExposureMode = ... # 0x4
    ExposureSpotlight        : QCameraExposure.ExposureMode = ... # 0x5
    ExposureSports           : QCameraExposure.ExposureMode = ... # 0x6
    ExposureSnow             : QCameraExposure.ExposureMode = ... # 0x7
    ExposureBeach            : QCameraExposure.ExposureMode = ... # 0x8
    ExposureLargeAperture    : QCameraExposure.ExposureMode = ... # 0x9
    ExposureSmallAperture    : QCameraExposure.ExposureMode = ... # 0xa
    ExposureAction           : QCameraExposure.ExposureMode = ... # 0xb
    ExposureLandscape        : QCameraExposure.ExposureMode = ... # 0xc
    ExposureNightPortrait    : QCameraExposure.ExposureMode = ... # 0xd
    ExposureTheatre          : QCameraExposure.ExposureMode = ... # 0xe
    ExposureSunset           : QCameraExposure.ExposureMode = ... # 0xf
    ExposureSteadyPhoto      : QCameraExposure.ExposureMode = ... # 0x10
    ExposureFireworks        : QCameraExposure.ExposureMode = ... # 0x11
    ExposureParty            : QCameraExposure.ExposureMode = ... # 0x12
    ExposureCandlelight      : QCameraExposure.ExposureMode = ... # 0x13
    ExposureBarcode          : QCameraExposure.ExposureMode = ... # 0x14
    ExposureModeVendor       : QCameraExposure.ExposureMode = ... # 0x3e8
    FlashAuto                : QCameraExposure.FlashMode = ... # 0x1
    FlashOff                 : QCameraExposure.FlashMode = ... # 0x2
    FlashOn                  : QCameraExposure.FlashMode = ... # 0x4
    FlashRedEyeReduction     : QCameraExposure.FlashMode = ... # 0x8
    FlashFill                : QCameraExposure.FlashMode = ... # 0x10
    FlashTorch               : QCameraExposure.FlashMode = ... # 0x20
    FlashVideoLight          : QCameraExposure.FlashMode = ... # 0x40
    FlashSlowSyncFrontCurtain: QCameraExposure.FlashMode = ... # 0x80
    FlashSlowSyncRearCurtain : QCameraExposure.FlashMode = ... # 0x100
    FlashManual              : QCameraExposure.FlashMode = ... # 0x200
    MeteringMatrix           : QCameraExposure.MeteringMode = ... # 0x1
    MeteringAverage          : QCameraExposure.MeteringMode = ... # 0x2
    MeteringSpot             : QCameraExposure.MeteringMode = ... # 0x3

    class ExposureMode(Shiboken.Enum):
        ExposureAuto             : QCameraExposure.ExposureMode = ... # 0x0
        ExposureManual           : QCameraExposure.ExposureMode = ... # 0x1
        ExposurePortrait         : QCameraExposure.ExposureMode = ... # 0x2
        ExposureNight            : QCameraExposure.ExposureMode = ... # 0x3
        ExposureBacklight        : QCameraExposure.ExposureMode = ... # 0x4
        ExposureSpotlight        : QCameraExposure.ExposureMode = ... # 0x5
        ExposureSports           : QCameraExposure.ExposureMode = ... # 0x6
        ExposureSnow             : QCameraExposure.ExposureMode = ... # 0x7
        ExposureBeach            : QCameraExposure.ExposureMode = ... # 0x8
        ExposureLargeAperture    : QCameraExposure.ExposureMode = ... # 0x9
        ExposureSmallAperture    : QCameraExposure.ExposureMode = ... # 0xa
        ExposureAction           : QCameraExposure.ExposureMode = ... # 0xb
        ExposureLandscape        : QCameraExposure.ExposureMode = ... # 0xc
        ExposureNightPortrait    : QCameraExposure.ExposureMode = ... # 0xd
        ExposureTheatre          : QCameraExposure.ExposureMode = ... # 0xe
        ExposureSunset           : QCameraExposure.ExposureMode = ... # 0xf
        ExposureSteadyPhoto      : QCameraExposure.ExposureMode = ... # 0x10
        ExposureFireworks        : QCameraExposure.ExposureMode = ... # 0x11
        ExposureParty            : QCameraExposure.ExposureMode = ... # 0x12
        ExposureCandlelight      : QCameraExposure.ExposureMode = ... # 0x13
        ExposureBarcode          : QCameraExposure.ExposureMode = ... # 0x14
        ExposureModeVendor       : QCameraExposure.ExposureMode = ... # 0x3e8

    class FlashMode(Shiboken.Enum):
        FlashAuto                : QCameraExposure.FlashMode = ... # 0x1
        FlashOff                 : QCameraExposure.FlashMode = ... # 0x2
        FlashOn                  : QCameraExposure.FlashMode = ... # 0x4
        FlashRedEyeReduction     : QCameraExposure.FlashMode = ... # 0x8
        FlashFill                : QCameraExposure.FlashMode = ... # 0x10
        FlashTorch               : QCameraExposure.FlashMode = ... # 0x20
        FlashVideoLight          : QCameraExposure.FlashMode = ... # 0x40
        FlashSlowSyncFrontCurtain: QCameraExposure.FlashMode = ... # 0x80
        FlashSlowSyncRearCurtain : QCameraExposure.FlashMode = ... # 0x100
        FlashManual              : QCameraExposure.FlashMode = ... # 0x200

    class FlashModes(object): ...

    class MeteringMode(Shiboken.Enum):
        MeteringMatrix           : QCameraExposure.MeteringMode = ... # 0x1
        MeteringAverage          : QCameraExposure.MeteringMode = ... # 0x2
        MeteringSpot             : QCameraExposure.MeteringMode = ... # 0x3


class QCameraExposureControl(PySide2.QtMultimedia.QMediaControl):
    ISO                      : QCameraExposureControl.ExposureParameter = ... # 0x0
    Aperture                 : QCameraExposureControl.ExposureParameter = ... # 0x1
    ShutterSpeed             : QCameraExposureControl.ExposureParameter = ... # 0x2
    ExposureCompensation     : QCameraExposureControl.ExposureParameter = ... # 0x3
    FlashPower               : QCameraExposureControl.ExposureParameter = ... # 0x4
    FlashCompensation        : QCameraExposureControl.ExposureParameter = ... # 0x5
    TorchPower               : QCameraExposureControl.ExposureParameter = ... # 0x6
    SpotMeteringPoint        : QCameraExposureControl.ExposureParameter = ... # 0x7
    ExposureMode             : QCameraExposureControl.ExposureParameter = ... # 0x8
    MeteringMode             : QCameraExposureControl.ExposureParameter = ... # 0x9
    ExtendedExposureParameter: QCameraExposureControl.ExposureParameter = ... # 0x3e8

    class ExposureParameter(Shiboken.Enum):
        ISO                      : QCameraExposureControl.ExposureParameter = ... # 0x0
        Aperture                 : QCameraExposureControl.ExposureParameter = ... # 0x1
        ShutterSpeed             : QCameraExposureControl.ExposureParameter = ... # 0x2
        ExposureCompensation     : QCameraExposureControl.ExposureParameter = ... # 0x3
        FlashPower               : QCameraExposureControl.ExposureParameter = ... # 0x4
        FlashCompensation        : QCameraExposureControl.ExposureParameter = ... # 0x5
        TorchPower               : QCameraExposureControl.ExposureParameter = ... # 0x6
        SpotMeteringPoint        : QCameraExposureControl.ExposureParameter = ... # 0x7
        ExposureMode             : QCameraExposureControl.ExposureParameter = ... # 0x8
        MeteringMode             : QCameraExposureControl.ExposureParameter = ... # 0x9
        ExtendedExposureParameter: QCameraExposureControl.ExposureParameter = ... # 0x3e8

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QCameraFeedbackControl(PySide2.QtMultimedia.QMediaControl):
    ViewfinderStarted        : QCameraFeedbackControl.EventType = ... # 0x1
    ViewfinderStopped        : QCameraFeedbackControl.EventType = ... # 0x2
    ImageCaptured            : QCameraFeedbackControl.EventType = ... # 0x3
    ImageSaved               : QCameraFeedbackControl.EventType = ... # 0x4
    ImageError               : QCameraFeedbackControl.EventType = ... # 0x5
    RecordingStarted         : QCameraFeedbackControl.EventType = ... # 0x6
    RecordingInProgress      : QCameraFeedbackControl.EventType = ... # 0x7
    RecordingStopped         : QCameraFeedbackControl.EventType = ... # 0x8
    AutoFocusInProgress      : QCameraFeedbackControl.EventType = ... # 0x9
    AutoFocusLocked          : QCameraFeedbackControl.EventType = ... # 0xa
    AutoFocusFailed          : QCameraFeedbackControl.EventType = ... # 0xb

    class EventType(Shiboken.Enum):
        ViewfinderStarted        : QCameraFeedbackControl.EventType = ... # 0x1
        ViewfinderStopped        : QCameraFeedbackControl.EventType = ... # 0x2
        ImageCaptured            : QCameraFeedbackControl.EventType = ... # 0x3
        ImageSaved               : QCameraFeedbackControl.EventType = ... # 0x4
        ImageError               : QCameraFeedbackControl.EventType = ... # 0x5
        RecordingStarted         : QCameraFeedbackControl.EventType = ... # 0x6
        RecordingInProgress      : QCameraFeedbackControl.EventType = ... # 0x7
        RecordingStopped         : QCameraFeedbackControl.EventType = ... # 0x8
        AutoFocusInProgress      : QCameraFeedbackControl.EventType = ... # 0x9
        AutoFocusLocked          : QCameraFeedbackControl.EventType = ... # 0xa
        AutoFocusFailed          : QCameraFeedbackControl.EventType = ... # 0xb

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QCameraFlashControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QCameraFocus(PySide2.QtCore.QObject):
    ManualFocus              : QCameraFocus.FocusMode = ... # 0x1
    HyperfocalFocus          : QCameraFocus.FocusMode = ... # 0x2
    InfinityFocus            : QCameraFocus.FocusMode = ... # 0x4
    AutoFocus                : QCameraFocus.FocusMode = ... # 0x8
    ContinuousFocus          : QCameraFocus.FocusMode = ... # 0x10
    MacroFocus               : QCameraFocus.FocusMode = ... # 0x20
    FocusPointAuto           : QCameraFocus.FocusPointMode = ... # 0x0
    FocusPointCenter         : QCameraFocus.FocusPointMode = ... # 0x1
    FocusPointFaceDetection  : QCameraFocus.FocusPointMode = ... # 0x2
    FocusPointCustom         : QCameraFocus.FocusPointMode = ... # 0x3

    class FocusMode(Shiboken.Enum):
        ManualFocus              : QCameraFocus.FocusMode = ... # 0x1
        HyperfocalFocus          : QCameraFocus.FocusMode = ... # 0x2
        InfinityFocus            : QCameraFocus.FocusMode = ... # 0x4
        AutoFocus                : QCameraFocus.FocusMode = ... # 0x8
        ContinuousFocus          : QCameraFocus.FocusMode = ... # 0x10
        MacroFocus               : QCameraFocus.FocusMode = ... # 0x20

    class FocusModes(object): ...

    class FocusPointMode(Shiboken.Enum):
        FocusPointAuto           : QCameraFocus.FocusPointMode = ... # 0x0
        FocusPointCenter         : QCameraFocus.FocusPointMode = ... # 0x1
        FocusPointFaceDetection  : QCameraFocus.FocusPointMode = ... # 0x2
        FocusPointCustom         : QCameraFocus.FocusPointMode = ... # 0x3


class QCameraFocusControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QCameraFocusZone(Shiboken.Object):
    Invalid                  : QCameraFocusZone.FocusZoneStatus = ... # 0x0
    Unused                   : QCameraFocusZone.FocusZoneStatus = ... # 0x1
    Selected                 : QCameraFocusZone.FocusZoneStatus = ... # 0x2
    Focused                  : QCameraFocusZone.FocusZoneStatus = ... # 0x3

    class FocusZoneStatus(Shiboken.Enum):
        Invalid                  : QCameraFocusZone.FocusZoneStatus = ... # 0x0
        Unused                   : QCameraFocusZone.FocusZoneStatus = ... # 0x1
        Selected                 : QCameraFocusZone.FocusZoneStatus = ... # 0x2
        Focused                  : QCameraFocusZone.FocusZoneStatus = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, area: PySide2.QtCore.QRectF, status: PySide2.QtMultimedia.QCameraFocusZone.FocusZoneStatus = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QCameraFocusZone) -> None: ...


class QCameraImageCapture(PySide2.QtCore.QObject, PySide2.QtMultimedia.QMediaBindableInterface):
    CaptureToFile            : QCameraImageCapture.CaptureDestination = ... # 0x1
    CaptureToBuffer          : QCameraImageCapture.CaptureDestination = ... # 0x2
    SingleImageCapture       : QCameraImageCapture.DriveMode = ... # 0x0
    NoError                  : QCameraImageCapture.Error = ... # 0x0
    NotReadyError            : QCameraImageCapture.Error = ... # 0x1
    ResourceError            : QCameraImageCapture.Error = ... # 0x2
    OutOfSpaceError          : QCameraImageCapture.Error = ... # 0x3
    NotSupportedFeatureError : QCameraImageCapture.Error = ... # 0x4
    FormatError              : QCameraImageCapture.Error = ... # 0x5

    class CaptureDestination(Shiboken.Enum):
        CaptureToFile            : QCameraImageCapture.CaptureDestination = ... # 0x1
        CaptureToBuffer          : QCameraImageCapture.CaptureDestination = ... # 0x2

    class CaptureDestinations(object): ...

    class DriveMode(Shiboken.Enum):
        SingleImageCapture       : QCameraImageCapture.DriveMode = ... # 0x0

    class Error(Shiboken.Enum):
        NoError                  : QCameraImageCapture.Error = ... # 0x0
        NotReadyError            : QCameraImageCapture.Error = ... # 0x1
        ResourceError            : QCameraImageCapture.Error = ... # 0x2
        OutOfSpaceError          : QCameraImageCapture.Error = ... # 0x3
        NotSupportedFeatureError : QCameraImageCapture.Error = ... # 0x4
        FormatError              : QCameraImageCapture.Error = ... # 0x5

    def __init__(self, mediaObject: PySide2.QtMultimedia.QMediaObject, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QCameraImageCaptureControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QCameraImageProcessing(PySide2.QtCore.QObject):
    ColorFilterNone          : QCameraImageProcessing.ColorFilter = ... # 0x0
    ColorFilterGrayscale     : QCameraImageProcessing.ColorFilter = ... # 0x1
    ColorFilterNegative      : QCameraImageProcessing.ColorFilter = ... # 0x2
    ColorFilterSolarize      : QCameraImageProcessing.ColorFilter = ... # 0x3
    ColorFilterSepia         : QCameraImageProcessing.ColorFilter = ... # 0x4
    ColorFilterPosterize     : QCameraImageProcessing.ColorFilter = ... # 0x5
    ColorFilterWhiteboard    : QCameraImageProcessing.ColorFilter = ... # 0x6
    ColorFilterBlackboard    : QCameraImageProcessing.ColorFilter = ... # 0x7
    ColorFilterAqua          : QCameraImageProcessing.ColorFilter = ... # 0x8
    ColorFilterVendor        : QCameraImageProcessing.ColorFilter = ... # 0x3e8
    WhiteBalanceAuto         : QCameraImageProcessing.WhiteBalanceMode = ... # 0x0
    WhiteBalanceManual       : QCameraImageProcessing.WhiteBalanceMode = ... # 0x1
    WhiteBalanceSunlight     : QCameraImageProcessing.WhiteBalanceMode = ... # 0x2
    WhiteBalanceCloudy       : QCameraImageProcessing.WhiteBalanceMode = ... # 0x3
    WhiteBalanceShade        : QCameraImageProcessing.WhiteBalanceMode = ... # 0x4
    WhiteBalanceTungsten     : QCameraImageProcessing.WhiteBalanceMode = ... # 0x5
    WhiteBalanceFluorescent  : QCameraImageProcessing.WhiteBalanceMode = ... # 0x6
    WhiteBalanceFlash        : QCameraImageProcessing.WhiteBalanceMode = ... # 0x7
    WhiteBalanceSunset       : QCameraImageProcessing.WhiteBalanceMode = ... # 0x8
    WhiteBalanceVendor       : QCameraImageProcessing.WhiteBalanceMode = ... # 0x3e8

    class ColorFilter(Shiboken.Enum):
        ColorFilterNone          : QCameraImageProcessing.ColorFilter = ... # 0x0
        ColorFilterGrayscale     : QCameraImageProcessing.ColorFilter = ... # 0x1
        ColorFilterNegative      : QCameraImageProcessing.ColorFilter = ... # 0x2
        ColorFilterSolarize      : QCameraImageProcessing.ColorFilter = ... # 0x3
        ColorFilterSepia         : QCameraImageProcessing.ColorFilter = ... # 0x4
        ColorFilterPosterize     : QCameraImageProcessing.ColorFilter = ... # 0x5
        ColorFilterWhiteboard    : QCameraImageProcessing.ColorFilter = ... # 0x6
        ColorFilterBlackboard    : QCameraImageProcessing.ColorFilter = ... # 0x7
        ColorFilterAqua          : QCameraImageProcessing.ColorFilter = ... # 0x8
        ColorFilterVendor        : QCameraImageProcessing.ColorFilter = ... # 0x3e8

    class WhiteBalanceMode(Shiboken.Enum):
        WhiteBalanceAuto         : QCameraImageProcessing.WhiteBalanceMode = ... # 0x0
        WhiteBalanceManual       : QCameraImageProcessing.WhiteBalanceMode = ... # 0x1
        WhiteBalanceSunlight     : QCameraImageProcessing.WhiteBalanceMode = ... # 0x2
        WhiteBalanceCloudy       : QCameraImageProcessing.WhiteBalanceMode = ... # 0x3
        WhiteBalanceShade        : QCameraImageProcessing.WhiteBalanceMode = ... # 0x4
        WhiteBalanceTungsten     : QCameraImageProcessing.WhiteBalanceMode = ... # 0x5
        WhiteBalanceFluorescent  : QCameraImageProcessing.WhiteBalanceMode = ... # 0x6
        WhiteBalanceFlash        : QCameraImageProcessing.WhiteBalanceMode = ... # 0x7
        WhiteBalanceSunset       : QCameraImageProcessing.WhiteBalanceMode = ... # 0x8
        WhiteBalanceVendor       : QCameraImageProcessing.WhiteBalanceMode = ... # 0x3e8


class QCameraImageProcessingControl(PySide2.QtMultimedia.QMediaControl):
    WhiteBalancePreset       : QCameraImageProcessingControl.ProcessingParameter = ... # 0x0
    ColorTemperature         : QCameraImageProcessingControl.ProcessingParameter = ... # 0x1
    Contrast                 : QCameraImageProcessingControl.ProcessingParameter = ... # 0x2
    Saturation               : QCameraImageProcessingControl.ProcessingParameter = ... # 0x3
    Brightness               : QCameraImageProcessingControl.ProcessingParameter = ... # 0x4
    Sharpening               : QCameraImageProcessingControl.ProcessingParameter = ... # 0x5
    Denoising                : QCameraImageProcessingControl.ProcessingParameter = ... # 0x6
    ContrastAdjustment       : QCameraImageProcessingControl.ProcessingParameter = ... # 0x7
    SaturationAdjustment     : QCameraImageProcessingControl.ProcessingParameter = ... # 0x8
    BrightnessAdjustment     : QCameraImageProcessingControl.ProcessingParameter = ... # 0x9
    SharpeningAdjustment     : QCameraImageProcessingControl.ProcessingParameter = ... # 0xa
    DenoisingAdjustment      : QCameraImageProcessingControl.ProcessingParameter = ... # 0xb
    ColorFilter              : QCameraImageProcessingControl.ProcessingParameter = ... # 0xc
    ExtendedParameter        : QCameraImageProcessingControl.ProcessingParameter = ... # 0x3e8

    class ProcessingParameter(Shiboken.Enum):
        WhiteBalancePreset       : QCameraImageProcessingControl.ProcessingParameter = ... # 0x0
        ColorTemperature         : QCameraImageProcessingControl.ProcessingParameter = ... # 0x1
        Contrast                 : QCameraImageProcessingControl.ProcessingParameter = ... # 0x2
        Saturation               : QCameraImageProcessingControl.ProcessingParameter = ... # 0x3
        Brightness               : QCameraImageProcessingControl.ProcessingParameter = ... # 0x4
        Sharpening               : QCameraImageProcessingControl.ProcessingParameter = ... # 0x5
        Denoising                : QCameraImageProcessingControl.ProcessingParameter = ... # 0x6
        ContrastAdjustment       : QCameraImageProcessingControl.ProcessingParameter = ... # 0x7
        SaturationAdjustment     : QCameraImageProcessingControl.ProcessingParameter = ... # 0x8
        BrightnessAdjustment     : QCameraImageProcessingControl.ProcessingParameter = ... # 0x9
        SharpeningAdjustment     : QCameraImageProcessingControl.ProcessingParameter = ... # 0xa
        DenoisingAdjustment      : QCameraImageProcessingControl.ProcessingParameter = ... # 0xb
        ColorFilter              : QCameraImageProcessingControl.ProcessingParameter = ... # 0xc
        ExtendedParameter        : QCameraImageProcessingControl.ProcessingParameter = ... # 0x3e8

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QCameraInfo(Shiboken.Object):

    @typing.overload
    def __init__(self, camera: PySide2.QtMultimedia.QCamera) -> None: ...
    @typing.overload
    def __init__(self, name: PySide2.QtCore.QByteArray = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QCameraInfo) -> None: ...


class QCameraInfoControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QCameraLocksControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QCameraViewfinderSettings(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QCameraViewfinderSettings) -> None: ...


class QCameraViewfinderSettingsControl(PySide2.QtMultimedia.QMediaControl):
    Resolution               : QCameraViewfinderSettingsControl.ViewfinderParameter = ... # 0x0
    PixelAspectRatio         : QCameraViewfinderSettingsControl.ViewfinderParameter = ... # 0x1
    MinimumFrameRate         : QCameraViewfinderSettingsControl.ViewfinderParameter = ... # 0x2
    MaximumFrameRate         : QCameraViewfinderSettingsControl.ViewfinderParameter = ... # 0x3
    PixelFormat              : QCameraViewfinderSettingsControl.ViewfinderParameter = ... # 0x4
    UserParameter            : QCameraViewfinderSettingsControl.ViewfinderParameter = ... # 0x3e8

    class ViewfinderParameter(Shiboken.Enum):
        Resolution               : QCameraViewfinderSettingsControl.ViewfinderParameter = ... # 0x0
        PixelAspectRatio         : QCameraViewfinderSettingsControl.ViewfinderParameter = ... # 0x1
        MinimumFrameRate         : QCameraViewfinderSettingsControl.ViewfinderParameter = ... # 0x2
        MaximumFrameRate         : QCameraViewfinderSettingsControl.ViewfinderParameter = ... # 0x3
        PixelFormat              : QCameraViewfinderSettingsControl.ViewfinderParameter = ... # 0x4
        UserParameter            : QCameraViewfinderSettingsControl.ViewfinderParameter = ... # 0x3e8

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QCameraViewfinderSettingsControl2(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QCameraZoomControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QCustomAudioRoleControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QImageEncoderControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QImageEncoderSettings(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QImageEncoderSettings) -> None: ...


class QMediaAudioProbeControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QMediaAvailabilityControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QMediaBindableInterface(Shiboken.Object):

    def __init__(self) -> None: ...


class QMediaContainerControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QMediaContent(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, contentRequest: PySide2.QtNetwork.QNetworkRequest) -> None: ...
    @typing.overload
    def __init__(self, contentResource: PySide2.QtMultimedia.QMediaResource) -> None: ...
    @typing.overload
    def __init__(self, contentUrl: PySide2.QtCore.QUrl) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QMediaContent) -> None: ...
    @typing.overload
    def __init__(self, playlist: PySide2.QtMultimedia.QMediaPlaylist, contentUrl: PySide2.QtCore.QUrl = ..., takeOwnership: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, resources: typing.Sequence[PySide2.QtMultimedia.QMediaResource]) -> None: ...


class QMediaControl(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QMediaGaplessPlaybackControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QMediaNetworkAccessControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QMediaObject(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject, service: PySide2.QtMultimedia.QMediaService) -> None: ...


class QMediaPlayer(PySide2.QtMultimedia.QMediaObject):
    NoError                  : QMediaPlayer.Error = ... # 0x0
    ResourceError            : QMediaPlayer.Error = ... # 0x1
    FormatError              : QMediaPlayer.Error = ... # 0x2
    NetworkError             : QMediaPlayer.Error = ... # 0x3
    AccessDeniedError        : QMediaPlayer.Error = ... # 0x4
    ServiceMissingError      : QMediaPlayer.Error = ... # 0x5
    MediaIsPlaylist          : QMediaPlayer.Error = ... # 0x6
    LowLatency               : QMediaPlayer.Flag = ... # 0x1
    StreamPlayback           : QMediaPlayer.Flag = ... # 0x2
    VideoSurface             : QMediaPlayer.Flag = ... # 0x4
    UnknownMediaStatus       : QMediaPlayer.MediaStatus = ... # 0x0
    NoMedia                  : QMediaPlayer.MediaStatus = ... # 0x1
    LoadingMedia             : QMediaPlayer.MediaStatus = ... # 0x2
    LoadedMedia              : QMediaPlayer.MediaStatus = ... # 0x3
    StalledMedia             : QMediaPlayer.MediaStatus = ... # 0x4
    BufferingMedia           : QMediaPlayer.MediaStatus = ... # 0x5
    BufferedMedia            : QMediaPlayer.MediaStatus = ... # 0x6
    EndOfMedia               : QMediaPlayer.MediaStatus = ... # 0x7
    InvalidMedia             : QMediaPlayer.MediaStatus = ... # 0x8
    StoppedState             : QMediaPlayer.State = ... # 0x0
    PlayingState             : QMediaPlayer.State = ... # 0x1
    PausedState              : QMediaPlayer.State = ... # 0x2

    class Error(Shiboken.Enum):
        NoError                  : QMediaPlayer.Error = ... # 0x0
        ResourceError            : QMediaPlayer.Error = ... # 0x1
        FormatError              : QMediaPlayer.Error = ... # 0x2
        NetworkError             : QMediaPlayer.Error = ... # 0x3
        AccessDeniedError        : QMediaPlayer.Error = ... # 0x4
        ServiceMissingError      : QMediaPlayer.Error = ... # 0x5
        MediaIsPlaylist          : QMediaPlayer.Error = ... # 0x6

    class Flag(Shiboken.Enum):
        LowLatency               : QMediaPlayer.Flag = ... # 0x1
        StreamPlayback           : QMediaPlayer.Flag = ... # 0x2
        VideoSurface             : QMediaPlayer.Flag = ... # 0x4

    class Flags(object): ...

    class MediaStatus(Shiboken.Enum):
        UnknownMediaStatus       : QMediaPlayer.MediaStatus = ... # 0x0
        NoMedia                  : QMediaPlayer.MediaStatus = ... # 0x1
        LoadingMedia             : QMediaPlayer.MediaStatus = ... # 0x2
        LoadedMedia              : QMediaPlayer.MediaStatus = ... # 0x3
        StalledMedia             : QMediaPlayer.MediaStatus = ... # 0x4
        BufferingMedia           : QMediaPlayer.MediaStatus = ... # 0x5
        BufferedMedia            : QMediaPlayer.MediaStatus = ... # 0x6
        EndOfMedia               : QMediaPlayer.MediaStatus = ... # 0x7
        InvalidMedia             : QMediaPlayer.MediaStatus = ... # 0x8

    class State(Shiboken.Enum):
        StoppedState             : QMediaPlayer.State = ... # 0x0
        PlayingState             : QMediaPlayer.State = ... # 0x1
        PausedState              : QMediaPlayer.State = ... # 0x2

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ..., flags: PySide2.QtMultimedia.QMediaPlayer.Flags = ...) -> None: ...


class QMediaPlayerControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QMediaPlaylist(PySide2.QtCore.QObject, PySide2.QtMultimedia.QMediaBindableInterface):
    NoError                  : QMediaPlaylist.Error = ... # 0x0
    FormatError              : QMediaPlaylist.Error = ... # 0x1
    FormatNotSupportedError  : QMediaPlaylist.Error = ... # 0x2
    NetworkError             : QMediaPlaylist.Error = ... # 0x3
    AccessDeniedError        : QMediaPlaylist.Error = ... # 0x4
    CurrentItemOnce          : QMediaPlaylist.PlaybackMode = ... # 0x0
    CurrentItemInLoop        : QMediaPlaylist.PlaybackMode = ... # 0x1
    Sequential               : QMediaPlaylist.PlaybackMode = ... # 0x2
    Loop                     : QMediaPlaylist.PlaybackMode = ... # 0x3
    Random                   : QMediaPlaylist.PlaybackMode = ... # 0x4

    class Error(Shiboken.Enum):
        NoError                  : QMediaPlaylist.Error = ... # 0x0
        FormatError              : QMediaPlaylist.Error = ... # 0x1
        FormatNotSupportedError  : QMediaPlaylist.Error = ... # 0x2
        NetworkError             : QMediaPlaylist.Error = ... # 0x3
        AccessDeniedError        : QMediaPlaylist.Error = ... # 0x4

    class PlaybackMode(Shiboken.Enum):
        CurrentItemOnce          : QMediaPlaylist.PlaybackMode = ... # 0x0
        CurrentItemInLoop        : QMediaPlaylist.PlaybackMode = ... # 0x1
        Sequential               : QMediaPlaylist.PlaybackMode = ... # 0x2
        Loop                     : QMediaPlaylist.PlaybackMode = ... # 0x3
        Random                   : QMediaPlaylist.PlaybackMode = ... # 0x4

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QMediaRecorder(PySide2.QtCore.QObject, PySide2.QtMultimedia.QMediaBindableInterface):
    NoError                  : QMediaRecorder.Error = ... # 0x0
    ResourceError            : QMediaRecorder.Error = ... # 0x1
    FormatError              : QMediaRecorder.Error = ... # 0x2
    OutOfSpaceError          : QMediaRecorder.Error = ... # 0x3
    StoppedState             : QMediaRecorder.State = ... # 0x0
    RecordingState           : QMediaRecorder.State = ... # 0x1
    PausedState              : QMediaRecorder.State = ... # 0x2
    UnavailableStatus        : QMediaRecorder.Status = ... # 0x0
    UnloadedStatus           : QMediaRecorder.Status = ... # 0x1
    LoadingStatus            : QMediaRecorder.Status = ... # 0x2
    LoadedStatus             : QMediaRecorder.Status = ... # 0x3
    StartingStatus           : QMediaRecorder.Status = ... # 0x4
    RecordingStatus          : QMediaRecorder.Status = ... # 0x5
    PausedStatus             : QMediaRecorder.Status = ... # 0x6
    FinalizingStatus         : QMediaRecorder.Status = ... # 0x7

    class Error(Shiboken.Enum):
        NoError                  : QMediaRecorder.Error = ... # 0x0
        ResourceError            : QMediaRecorder.Error = ... # 0x1
        FormatError              : QMediaRecorder.Error = ... # 0x2
        OutOfSpaceError          : QMediaRecorder.Error = ... # 0x3

    class State(Shiboken.Enum):
        StoppedState             : QMediaRecorder.State = ... # 0x0
        RecordingState           : QMediaRecorder.State = ... # 0x1
        PausedState              : QMediaRecorder.State = ... # 0x2

    class Status(Shiboken.Enum):
        UnavailableStatus        : QMediaRecorder.Status = ... # 0x0
        UnloadedStatus           : QMediaRecorder.Status = ... # 0x1
        LoadingStatus            : QMediaRecorder.Status = ... # 0x2
        LoadedStatus             : QMediaRecorder.Status = ... # 0x3
        StartingStatus           : QMediaRecorder.Status = ... # 0x4
        RecordingStatus          : QMediaRecorder.Status = ... # 0x5
        PausedStatus             : QMediaRecorder.Status = ... # 0x6
        FinalizingStatus         : QMediaRecorder.Status = ... # 0x7

    def __init__(self, mediaObject: PySide2.QtMultimedia.QMediaObject, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QMediaRecorderControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QMediaResource(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QMediaResource) -> None: ...
    @typing.overload
    def __init__(self, request: PySide2.QtNetwork.QNetworkRequest, mimeType: str = ...) -> None: ...
    @typing.overload
    def __init__(self, url: PySide2.QtCore.QUrl, mimeType: str = ...) -> None: ...


class QMediaService(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject) -> None: ...


class QMediaServiceCameraInfoInterface(Shiboken.Object):

    def __init__(self) -> None: ...


class QMediaServiceDefaultDeviceInterface(Shiboken.Object):

    def __init__(self) -> None: ...


class QMediaServiceFeaturesInterface(Shiboken.Object):

    def __init__(self) -> None: ...


class QMediaServiceProviderHint(Shiboken.Object):
    LowLatencyPlayback       : QMediaServiceProviderHint.Feature = ... # 0x1
    RecordingSupport         : QMediaServiceProviderHint.Feature = ... # 0x2
    StreamPlayback           : QMediaServiceProviderHint.Feature = ... # 0x4
    VideoSurface             : QMediaServiceProviderHint.Feature = ... # 0x8
    Null                     : QMediaServiceProviderHint.Type = ... # 0x0
    ContentType              : QMediaServiceProviderHint.Type = ... # 0x1
    Device                   : QMediaServiceProviderHint.Type = ... # 0x2
    SupportedFeatures        : QMediaServiceProviderHint.Type = ... # 0x3
    CameraPosition           : QMediaServiceProviderHint.Type = ... # 0x4

    class Feature(Shiboken.Enum):
        LowLatencyPlayback       : QMediaServiceProviderHint.Feature = ... # 0x1
        RecordingSupport         : QMediaServiceProviderHint.Feature = ... # 0x2
        StreamPlayback           : QMediaServiceProviderHint.Feature = ... # 0x4
        VideoSurface             : QMediaServiceProviderHint.Feature = ... # 0x8

    class Features(object): ...

    class Type(Shiboken.Enum):
        Null                     : QMediaServiceProviderHint.Type = ... # 0x0
        ContentType              : QMediaServiceProviderHint.Type = ... # 0x1
        Device                   : QMediaServiceProviderHint.Type = ... # 0x2
        SupportedFeatures        : QMediaServiceProviderHint.Type = ... # 0x3
        CameraPosition           : QMediaServiceProviderHint.Type = ... # 0x4

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, device: PySide2.QtCore.QByteArray) -> None: ...
    @typing.overload
    def __init__(self, features: PySide2.QtMultimedia.QMediaServiceProviderHint.Features) -> None: ...
    @typing.overload
    def __init__(self, mimeType: str, codecs: typing.Sequence[str]) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QMediaServiceProviderHint) -> None: ...
    @typing.overload
    def __init__(self, position: PySide2.QtMultimedia.QCamera.Position) -> None: ...


class QMediaServiceSupportedDevicesInterface(Shiboken.Object):

    def __init__(self) -> None: ...


class QMediaServiceSupportedFormatsInterface(Shiboken.Object):

    def __init__(self) -> None: ...


class QMediaStreamsControl(PySide2.QtMultimedia.QMediaControl):
    UnknownStream            : QMediaStreamsControl.StreamType = ... # 0x0
    VideoStream              : QMediaStreamsControl.StreamType = ... # 0x1
    AudioStream              : QMediaStreamsControl.StreamType = ... # 0x2
    SubPictureStream         : QMediaStreamsControl.StreamType = ... # 0x3
    DataStream               : QMediaStreamsControl.StreamType = ... # 0x4

    class StreamType(Shiboken.Enum):
        UnknownStream            : QMediaStreamsControl.StreamType = ... # 0x0
        VideoStream              : QMediaStreamsControl.StreamType = ... # 0x1
        AudioStream              : QMediaStreamsControl.StreamType = ... # 0x2
        SubPictureStream         : QMediaStreamsControl.StreamType = ... # 0x3
        DataStream               : QMediaStreamsControl.StreamType = ... # 0x4

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QMediaTimeInterval(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtMultimedia.QMediaTimeInterval) -> None: ...
    @typing.overload
    def __init__(self, start: int, end: int) -> None: ...


class QMediaTimeRange(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtMultimedia.QMediaTimeInterval) -> None: ...
    @typing.overload
    def __init__(self, range: PySide2.QtMultimedia.QMediaTimeRange) -> None: ...
    @typing.overload
    def __init__(self, start: int, end: int) -> None: ...


class QMediaVideoProbeControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QMetaDataReaderControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QMetaDataWriterControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QMultimedia(Shiboken.Object):
    Available                : QMultimedia.AvailabilityStatus = ... # 0x0
    ServiceMissing           : QMultimedia.AvailabilityStatus = ... # 0x1
    Busy                     : QMultimedia.AvailabilityStatus = ... # 0x2
    ResourceError            : QMultimedia.AvailabilityStatus = ... # 0x3
    ConstantQualityEncoding  : QMultimedia.EncodingMode = ... # 0x0
    ConstantBitRateEncoding  : QMultimedia.EncodingMode = ... # 0x1
    AverageBitRateEncoding   : QMultimedia.EncodingMode = ... # 0x2
    TwoPassEncoding          : QMultimedia.EncodingMode = ... # 0x3
    VeryLowQuality           : QMultimedia.EncodingQuality = ... # 0x0
    LowQuality               : QMultimedia.EncodingQuality = ... # 0x1
    NormalQuality            : QMultimedia.EncodingQuality = ... # 0x2
    HighQuality              : QMultimedia.EncodingQuality = ... # 0x3
    VeryHighQuality          : QMultimedia.EncodingQuality = ... # 0x4
    NotSupported             : QMultimedia.SupportEstimate = ... # 0x0
    MaybeSupported           : QMultimedia.SupportEstimate = ... # 0x1
    ProbablySupported        : QMultimedia.SupportEstimate = ... # 0x2
    PreferredService         : QMultimedia.SupportEstimate = ... # 0x3

    class AvailabilityStatus(Shiboken.Enum):
        Available                : QMultimedia.AvailabilityStatus = ... # 0x0
        ServiceMissing           : QMultimedia.AvailabilityStatus = ... # 0x1
        Busy                     : QMultimedia.AvailabilityStatus = ... # 0x2
        ResourceError            : QMultimedia.AvailabilityStatus = ... # 0x3

    class EncodingMode(Shiboken.Enum):
        ConstantQualityEncoding  : QMultimedia.EncodingMode = ... # 0x0
        ConstantBitRateEncoding  : QMultimedia.EncodingMode = ... # 0x1
        AverageBitRateEncoding   : QMultimedia.EncodingMode = ... # 0x2
        TwoPassEncoding          : QMultimedia.EncodingMode = ... # 0x3

    class EncodingQuality(Shiboken.Enum):
        VeryLowQuality           : QMultimedia.EncodingQuality = ... # 0x0
        LowQuality               : QMultimedia.EncodingQuality = ... # 0x1
        NormalQuality            : QMultimedia.EncodingQuality = ... # 0x2
        HighQuality              : QMultimedia.EncodingQuality = ... # 0x3
        VeryHighQuality          : QMultimedia.EncodingQuality = ... # 0x4

    class SupportEstimate(Shiboken.Enum):
        NotSupported             : QMultimedia.SupportEstimate = ... # 0x0
        MaybeSupported           : QMultimedia.SupportEstimate = ... # 0x1
        ProbablySupported        : QMultimedia.SupportEstimate = ... # 0x2
        PreferredService         : QMultimedia.SupportEstimate = ... # 0x3


class QRadioData(PySide2.QtCore.QObject, PySide2.QtMultimedia.QMediaBindableInterface):
    NoError                  : QRadioData.Error = ... # 0x0
    ResourceError            : QRadioData.Error = ... # 0x1
    OpenError                : QRadioData.Error = ... # 0x2
    OutOfRangeError          : QRadioData.Error = ... # 0x3
    Undefined                : QRadioData.ProgramType = ... # 0x0
    News                     : QRadioData.ProgramType = ... # 0x1
    CurrentAffairs           : QRadioData.ProgramType = ... # 0x2
    Information              : QRadioData.ProgramType = ... # 0x3
    Sport                    : QRadioData.ProgramType = ... # 0x4
    Education                : QRadioData.ProgramType = ... # 0x5
    Drama                    : QRadioData.ProgramType = ... # 0x6
    Culture                  : QRadioData.ProgramType = ... # 0x7
    Science                  : QRadioData.ProgramType = ... # 0x8
    Varied                   : QRadioData.ProgramType = ... # 0x9
    PopMusic                 : QRadioData.ProgramType = ... # 0xa
    RockMusic                : QRadioData.ProgramType = ... # 0xb
    EasyListening            : QRadioData.ProgramType = ... # 0xc
    LightClassical           : QRadioData.ProgramType = ... # 0xd
    SeriousClassical         : QRadioData.ProgramType = ... # 0xe
    OtherMusic               : QRadioData.ProgramType = ... # 0xf
    Weather                  : QRadioData.ProgramType = ... # 0x10
    Finance                  : QRadioData.ProgramType = ... # 0x11
    ChildrensProgrammes      : QRadioData.ProgramType = ... # 0x12
    SocialAffairs            : QRadioData.ProgramType = ... # 0x13
    Religion                 : QRadioData.ProgramType = ... # 0x14
    PhoneIn                  : QRadioData.ProgramType = ... # 0x15
    Travel                   : QRadioData.ProgramType = ... # 0x16
    Leisure                  : QRadioData.ProgramType = ... # 0x17
    JazzMusic                : QRadioData.ProgramType = ... # 0x18
    CountryMusic             : QRadioData.ProgramType = ... # 0x19
    NationalMusic            : QRadioData.ProgramType = ... # 0x1a
    OldiesMusic              : QRadioData.ProgramType = ... # 0x1b
    FolkMusic                : QRadioData.ProgramType = ... # 0x1c
    Documentary              : QRadioData.ProgramType = ... # 0x1d
    AlarmTest                : QRadioData.ProgramType = ... # 0x1e
    Alarm                    : QRadioData.ProgramType = ... # 0x1f
    Talk                     : QRadioData.ProgramType = ... # 0x20
    ClassicRock              : QRadioData.ProgramType = ... # 0x21
    AdultHits                : QRadioData.ProgramType = ... # 0x22
    SoftRock                 : QRadioData.ProgramType = ... # 0x23
    Top40                    : QRadioData.ProgramType = ... # 0x24
    Soft                     : QRadioData.ProgramType = ... # 0x25
    Nostalgia                : QRadioData.ProgramType = ... # 0x26
    Classical                : QRadioData.ProgramType = ... # 0x27
    RhythmAndBlues           : QRadioData.ProgramType = ... # 0x28
    SoftRhythmAndBlues       : QRadioData.ProgramType = ... # 0x29
    Language                 : QRadioData.ProgramType = ... # 0x2a
    ReligiousMusic           : QRadioData.ProgramType = ... # 0x2b
    ReligiousTalk            : QRadioData.ProgramType = ... # 0x2c
    Personality              : QRadioData.ProgramType = ... # 0x2d
    Public                   : QRadioData.ProgramType = ... # 0x2e
    College                  : QRadioData.ProgramType = ... # 0x2f

    class Error(Shiboken.Enum):
        NoError                  : QRadioData.Error = ... # 0x0
        ResourceError            : QRadioData.Error = ... # 0x1
        OpenError                : QRadioData.Error = ... # 0x2
        OutOfRangeError          : QRadioData.Error = ... # 0x3

    class ProgramType(Shiboken.Enum):
        Undefined                : QRadioData.ProgramType = ... # 0x0
        News                     : QRadioData.ProgramType = ... # 0x1
        CurrentAffairs           : QRadioData.ProgramType = ... # 0x2
        Information              : QRadioData.ProgramType = ... # 0x3
        Sport                    : QRadioData.ProgramType = ... # 0x4
        Education                : QRadioData.ProgramType = ... # 0x5
        Drama                    : QRadioData.ProgramType = ... # 0x6
        Culture                  : QRadioData.ProgramType = ... # 0x7
        Science                  : QRadioData.ProgramType = ... # 0x8
        Varied                   : QRadioData.ProgramType = ... # 0x9
        PopMusic                 : QRadioData.ProgramType = ... # 0xa
        RockMusic                : QRadioData.ProgramType = ... # 0xb
        EasyListening            : QRadioData.ProgramType = ... # 0xc
        LightClassical           : QRadioData.ProgramType = ... # 0xd
        SeriousClassical         : QRadioData.ProgramType = ... # 0xe
        OtherMusic               : QRadioData.ProgramType = ... # 0xf
        Weather                  : QRadioData.ProgramType = ... # 0x10
        Finance                  : QRadioData.ProgramType = ... # 0x11
        ChildrensProgrammes      : QRadioData.ProgramType = ... # 0x12
        SocialAffairs            : QRadioData.ProgramType = ... # 0x13
        Religion                 : QRadioData.ProgramType = ... # 0x14
        PhoneIn                  : QRadioData.ProgramType = ... # 0x15
        Travel                   : QRadioData.ProgramType = ... # 0x16
        Leisure                  : QRadioData.ProgramType = ... # 0x17
        JazzMusic                : QRadioData.ProgramType = ... # 0x18
        CountryMusic             : QRadioData.ProgramType = ... # 0x19
        NationalMusic            : QRadioData.ProgramType = ... # 0x1a
        OldiesMusic              : QRadioData.ProgramType = ... # 0x1b
        FolkMusic                : QRadioData.ProgramType = ... # 0x1c
        Documentary              : QRadioData.ProgramType = ... # 0x1d
        AlarmTest                : QRadioData.ProgramType = ... # 0x1e
        Alarm                    : QRadioData.ProgramType = ... # 0x1f
        Talk                     : QRadioData.ProgramType = ... # 0x20
        ClassicRock              : QRadioData.ProgramType = ... # 0x21
        AdultHits                : QRadioData.ProgramType = ... # 0x22
        SoftRock                 : QRadioData.ProgramType = ... # 0x23
        Top40                    : QRadioData.ProgramType = ... # 0x24
        Soft                     : QRadioData.ProgramType = ... # 0x25
        Nostalgia                : QRadioData.ProgramType = ... # 0x26
        Classical                : QRadioData.ProgramType = ... # 0x27
        RhythmAndBlues           : QRadioData.ProgramType = ... # 0x28
        SoftRhythmAndBlues       : QRadioData.ProgramType = ... # 0x29
        Language                 : QRadioData.ProgramType = ... # 0x2a
        ReligiousMusic           : QRadioData.ProgramType = ... # 0x2b
        ReligiousTalk            : QRadioData.ProgramType = ... # 0x2c
        Personality              : QRadioData.ProgramType = ... # 0x2d
        Public                   : QRadioData.ProgramType = ... # 0x2e
        College                  : QRadioData.ProgramType = ... # 0x2f

    def __init__(self, mediaObject: PySide2.QtMultimedia.QMediaObject, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QRadioDataControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QRadioTuner(PySide2.QtMultimedia.QMediaObject):
    AM                       : QRadioTuner.Band = ... # 0x0
    FM                       : QRadioTuner.Band = ... # 0x1
    SW                       : QRadioTuner.Band = ... # 0x2
    LW                       : QRadioTuner.Band = ... # 0x3
    FM2                      : QRadioTuner.Band = ... # 0x4
    NoError                  : QRadioTuner.Error = ... # 0x0
    ResourceError            : QRadioTuner.Error = ... # 0x1
    OpenError                : QRadioTuner.Error = ... # 0x2
    OutOfRangeError          : QRadioTuner.Error = ... # 0x3
    SearchFast               : QRadioTuner.SearchMode = ... # 0x0
    SearchGetStationId       : QRadioTuner.SearchMode = ... # 0x1
    ActiveState              : QRadioTuner.State = ... # 0x0
    StoppedState             : QRadioTuner.State = ... # 0x1
    ForceStereo              : QRadioTuner.StereoMode = ... # 0x0
    ForceMono                : QRadioTuner.StereoMode = ... # 0x1
    Auto                     : QRadioTuner.StereoMode = ... # 0x2

    class Band(Shiboken.Enum):
        AM                       : QRadioTuner.Band = ... # 0x0
        FM                       : QRadioTuner.Band = ... # 0x1
        SW                       : QRadioTuner.Band = ... # 0x2
        LW                       : QRadioTuner.Band = ... # 0x3
        FM2                      : QRadioTuner.Band = ... # 0x4

    class Error(Shiboken.Enum):
        NoError                  : QRadioTuner.Error = ... # 0x0
        ResourceError            : QRadioTuner.Error = ... # 0x1
        OpenError                : QRadioTuner.Error = ... # 0x2
        OutOfRangeError          : QRadioTuner.Error = ... # 0x3

    class SearchMode(Shiboken.Enum):
        SearchFast               : QRadioTuner.SearchMode = ... # 0x0
        SearchGetStationId       : QRadioTuner.SearchMode = ... # 0x1

    class State(Shiboken.Enum):
        ActiveState              : QRadioTuner.State = ... # 0x0
        StoppedState             : QRadioTuner.State = ... # 0x1

    class StereoMode(Shiboken.Enum):
        ForceStereo              : QRadioTuner.StereoMode = ... # 0x0
        ForceMono                : QRadioTuner.StereoMode = ... # 0x1
        Auto                     : QRadioTuner.StereoMode = ... # 0x2

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QRadioTunerControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QSound(PySide2.QtCore.QObject):
    Infinite                 : QSound.Loop = ... # -0x1

    class Loop(Shiboken.Enum):
        Infinite                 : QSound.Loop = ... # -0x1

    def __init__(self, filename: str, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QSoundEffect(PySide2.QtCore.QObject):
    Infinite                 : QSoundEffect.Loop = ... # -0x2
    Null                     : QSoundEffect.Status = ... # 0x0
    Loading                  : QSoundEffect.Status = ... # 0x1
    Ready                    : QSoundEffect.Status = ... # 0x2
    Error                    : QSoundEffect.Status = ... # 0x3

    class Loop(Shiboken.Enum):
        Infinite                 : QSoundEffect.Loop = ... # -0x2

    class Status(Shiboken.Enum):
        Null                     : QSoundEffect.Status = ... # 0x0
        Loading                  : QSoundEffect.Status = ... # 0x1
        Ready                    : QSoundEffect.Status = ... # 0x2
        Error                    : QSoundEffect.Status = ... # 0x3

    @typing.overload
    def __init__(self, audioDevice: PySide2.QtMultimedia.QAudioDeviceInfo, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QVideoDeviceSelectorControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QVideoEncoderSettings(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QVideoEncoderSettings) -> None: ...


class QVideoEncoderSettingsControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QVideoFilterRunnable(Shiboken.Object):
    LastInChain              : QVideoFilterRunnable.RunFlag = ... # 0x1

    class RunFlag(Shiboken.Enum):
        LastInChain              : QVideoFilterRunnable.RunFlag = ... # 0x1

    class RunFlags(object): ...

    def __init__(self) -> None: ...


class QVideoFrame(Shiboken.Object):
    ProgressiveFrame         : QVideoFrame.FieldType = ... # 0x0
    TopField                 : QVideoFrame.FieldType = ... # 0x1
    BottomField              : QVideoFrame.FieldType = ... # 0x2
    InterlacedFrame          : QVideoFrame.FieldType = ... # 0x3
    Format_Invalid           : QVideoFrame.PixelFormat = ... # 0x0
    Format_ARGB32            : QVideoFrame.PixelFormat = ... # 0x1
    Format_ARGB32_Premultiplied: QVideoFrame.PixelFormat = ... # 0x2
    Format_RGB32             : QVideoFrame.PixelFormat = ... # 0x3
    Format_RGB24             : QVideoFrame.PixelFormat = ... # 0x4
    Format_RGB565            : QVideoFrame.PixelFormat = ... # 0x5
    Format_RGB555            : QVideoFrame.PixelFormat = ... # 0x6
    Format_ARGB8565_Premultiplied: QVideoFrame.PixelFormat = ... # 0x7
    Format_BGRA32            : QVideoFrame.PixelFormat = ... # 0x8
    Format_BGRA32_Premultiplied: QVideoFrame.PixelFormat = ... # 0x9
    Format_BGR32             : QVideoFrame.PixelFormat = ... # 0xa
    Format_BGR24             : QVideoFrame.PixelFormat = ... # 0xb
    Format_BGR565            : QVideoFrame.PixelFormat = ... # 0xc
    Format_BGR555            : QVideoFrame.PixelFormat = ... # 0xd
    Format_BGRA5658_Premultiplied: QVideoFrame.PixelFormat = ... # 0xe
    Format_AYUV444           : QVideoFrame.PixelFormat = ... # 0xf
    Format_AYUV444_Premultiplied: QVideoFrame.PixelFormat = ... # 0x10
    Format_YUV444            : QVideoFrame.PixelFormat = ... # 0x11
    Format_YUV420P           : QVideoFrame.PixelFormat = ... # 0x12
    Format_YV12              : QVideoFrame.PixelFormat = ... # 0x13
    Format_UYVY              : QVideoFrame.PixelFormat = ... # 0x14
    Format_YUYV              : QVideoFrame.PixelFormat = ... # 0x15
    Format_NV12              : QVideoFrame.PixelFormat = ... # 0x16
    Format_NV21              : QVideoFrame.PixelFormat = ... # 0x17
    Format_IMC1              : QVideoFrame.PixelFormat = ... # 0x18
    Format_IMC2              : QVideoFrame.PixelFormat = ... # 0x19
    Format_IMC3              : QVideoFrame.PixelFormat = ... # 0x1a
    Format_IMC4              : QVideoFrame.PixelFormat = ... # 0x1b
    Format_Y8                : QVideoFrame.PixelFormat = ... # 0x1c
    Format_Y16               : QVideoFrame.PixelFormat = ... # 0x1d
    Format_Jpeg              : QVideoFrame.PixelFormat = ... # 0x1e
    Format_CameraRaw         : QVideoFrame.PixelFormat = ... # 0x1f
    Format_AdobeDng          : QVideoFrame.PixelFormat = ... # 0x20
    Format_ABGR32            : QVideoFrame.PixelFormat = ... # 0x21
    Format_YUV422P           : QVideoFrame.PixelFormat = ... # 0x22
    NPixelFormats            : QVideoFrame.PixelFormat = ... # 0x23
    Format_User              : QVideoFrame.PixelFormat = ... # 0x3e8

    class FieldType(Shiboken.Enum):
        ProgressiveFrame         : QVideoFrame.FieldType = ... # 0x0
        TopField                 : QVideoFrame.FieldType = ... # 0x1
        BottomField              : QVideoFrame.FieldType = ... # 0x2
        InterlacedFrame          : QVideoFrame.FieldType = ... # 0x3

    class PixelFormat(Shiboken.Enum):
        Format_Invalid           : QVideoFrame.PixelFormat = ... # 0x0
        Format_ARGB32            : QVideoFrame.PixelFormat = ... # 0x1
        Format_ARGB32_Premultiplied: QVideoFrame.PixelFormat = ... # 0x2
        Format_RGB32             : QVideoFrame.PixelFormat = ... # 0x3
        Format_RGB24             : QVideoFrame.PixelFormat = ... # 0x4
        Format_RGB565            : QVideoFrame.PixelFormat = ... # 0x5
        Format_RGB555            : QVideoFrame.PixelFormat = ... # 0x6
        Format_ARGB8565_Premultiplied: QVideoFrame.PixelFormat = ... # 0x7
        Format_BGRA32            : QVideoFrame.PixelFormat = ... # 0x8
        Format_BGRA32_Premultiplied: QVideoFrame.PixelFormat = ... # 0x9
        Format_BGR32             : QVideoFrame.PixelFormat = ... # 0xa
        Format_BGR24             : QVideoFrame.PixelFormat = ... # 0xb
        Format_BGR565            : QVideoFrame.PixelFormat = ... # 0xc
        Format_BGR555            : QVideoFrame.PixelFormat = ... # 0xd
        Format_BGRA5658_Premultiplied: QVideoFrame.PixelFormat = ... # 0xe
        Format_AYUV444           : QVideoFrame.PixelFormat = ... # 0xf
        Format_AYUV444_Premultiplied: QVideoFrame.PixelFormat = ... # 0x10
        Format_YUV444            : QVideoFrame.PixelFormat = ... # 0x11
        Format_YUV420P           : QVideoFrame.PixelFormat = ... # 0x12
        Format_YV12              : QVideoFrame.PixelFormat = ... # 0x13
        Format_UYVY              : QVideoFrame.PixelFormat = ... # 0x14
        Format_YUYV              : QVideoFrame.PixelFormat = ... # 0x15
        Format_NV12              : QVideoFrame.PixelFormat = ... # 0x16
        Format_NV21              : QVideoFrame.PixelFormat = ... # 0x17
        Format_IMC1              : QVideoFrame.PixelFormat = ... # 0x18
        Format_IMC2              : QVideoFrame.PixelFormat = ... # 0x19
        Format_IMC3              : QVideoFrame.PixelFormat = ... # 0x1a
        Format_IMC4              : QVideoFrame.PixelFormat = ... # 0x1b
        Format_Y8                : QVideoFrame.PixelFormat = ... # 0x1c
        Format_Y16               : QVideoFrame.PixelFormat = ... # 0x1d
        Format_Jpeg              : QVideoFrame.PixelFormat = ... # 0x1e
        Format_CameraRaw         : QVideoFrame.PixelFormat = ... # 0x1f
        Format_AdobeDng          : QVideoFrame.PixelFormat = ... # 0x20
        Format_ABGR32            : QVideoFrame.PixelFormat = ... # 0x21
        Format_YUV422P           : QVideoFrame.PixelFormat = ... # 0x22
        NPixelFormats            : QVideoFrame.PixelFormat = ... # 0x23
        Format_User              : QVideoFrame.PixelFormat = ... # 0x3e8

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, buffer: PySide2.QtMultimedia.QAbstractVideoBuffer, size: PySide2.QtCore.QSize, format: PySide2.QtMultimedia.QVideoFrame.PixelFormat) -> None: ...
    @typing.overload
    def __init__(self, bytes: int, size: PySide2.QtCore.QSize, bytesPerLine: int, format: PySide2.QtMultimedia.QVideoFrame.PixelFormat) -> None: ...
    @typing.overload
    def __init__(self, image: PySide2.QtGui.QImage) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QVideoFrame) -> None: ...


class QVideoProbe(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QVideoRendererControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QVideoSurfaceFormat(Shiboken.Object):
    TopToBottom              : QVideoSurfaceFormat.Direction = ... # 0x0
    BottomToTop              : QVideoSurfaceFormat.Direction = ... # 0x1
    YCbCr_Undefined          : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x0
    YCbCr_BT601              : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x1
    YCbCr_BT709              : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x2
    YCbCr_xvYCC601           : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x3
    YCbCr_xvYCC709           : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x4
    YCbCr_JPEG               : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x5
    YCbCr_CustomMatrix       : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x6

    class Direction(Shiboken.Enum):
        TopToBottom              : QVideoSurfaceFormat.Direction = ... # 0x0
        BottomToTop              : QVideoSurfaceFormat.Direction = ... # 0x1

    class YCbCrColorSpace(Shiboken.Enum):
        YCbCr_Undefined          : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x0
        YCbCr_BT601              : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x1
        YCbCr_BT709              : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x2
        YCbCr_xvYCC601           : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x3
        YCbCr_xvYCC709           : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x4
        YCbCr_JPEG               : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x5
        YCbCr_CustomMatrix       : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x6

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, format: PySide2.QtMultimedia.QVideoSurfaceFormat) -> None: ...
    @typing.overload
    def __init__(self, size: PySide2.QtCore.QSize, pixelFormat: PySide2.QtMultimedia.QVideoFrame.PixelFormat, handleType: PySide2.QtMultimedia.QAbstractVideoBuffer.HandleType = ...) -> None: ...


class QVideoWindowControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


# eof
