#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtNetwork, except for defaults which are replaced by "...".
"""

# Module PySide2.QtNetwork
import PySide2
try:
    import typing
except ImportError:
    from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

from shiboken2 import Shiboken

import PySide2.QtCore
import PySide2.QtNetwork


class QAbstractNetworkCache(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QAbstractSocket(PySide2.QtCore.QIODevice):
    DefaultForPlatform       : QAbstractSocket.BindFlag = ... # 0x0
    ShareAddress             : QAbstractSocket.BindFlag = ... # 0x1
    DontShareAddress         : QAbstractSocket.BindFlag = ... # 0x2
    ReuseAddressHint         : QAbstractSocket.BindFlag = ... # 0x4
    UnknownNetworkLayerProtocol: QAbstractSocket.NetworkLayerProtocol = ... # -0x1
    IPv4Protocol             : QAbstractSocket.NetworkLayerProtocol = ... # 0x0
    IPv6Protocol             : QAbstractSocket.NetworkLayerProtocol = ... # 0x1
    AnyIPProtocol            : QAbstractSocket.NetworkLayerProtocol = ... # 0x2
    PauseNever               : QAbstractSocket.PauseMode = ... # 0x0
    PauseOnSslErrors         : QAbstractSocket.PauseMode = ... # 0x1
    UnknownSocketError       : QAbstractSocket.SocketError = ... # -0x1
    ConnectionRefusedError   : QAbstractSocket.SocketError = ... # 0x0
    RemoteHostClosedError    : QAbstractSocket.SocketError = ... # 0x1
    HostNotFoundError        : QAbstractSocket.SocketError = ... # 0x2
    SocketAccessError        : QAbstractSocket.SocketError = ... # 0x3
    SocketResourceError      : QAbstractSocket.SocketError = ... # 0x4
    SocketTimeoutError       : QAbstractSocket.SocketError = ... # 0x5
    DatagramTooLargeError    : QAbstractSocket.SocketError = ... # 0x6
    NetworkError             : QAbstractSocket.SocketError = ... # 0x7
    AddressInUseError        : QAbstractSocket.SocketError = ... # 0x8
    SocketAddressNotAvailableError: QAbstractSocket.SocketError = ... # 0x9
    UnsupportedSocketOperationError: QAbstractSocket.SocketError = ... # 0xa
    UnfinishedSocketOperationError: QAbstractSocket.SocketError = ... # 0xb
    ProxyAuthenticationRequiredError: QAbstractSocket.SocketError = ... # 0xc
    SslHandshakeFailedError  : QAbstractSocket.SocketError = ... # 0xd
    ProxyConnectionRefusedError: QAbstractSocket.SocketError = ... # 0xe
    ProxyConnectionClosedError: QAbstractSocket.SocketError = ... # 0xf
    ProxyConnectionTimeoutError: QAbstractSocket.SocketError = ... # 0x10
    ProxyNotFoundError       : QAbstractSocket.SocketError = ... # 0x11
    ProxyProtocolError       : QAbstractSocket.SocketError = ... # 0x12
    OperationError           : QAbstractSocket.SocketError = ... # 0x13
    SslInternalError         : QAbstractSocket.SocketError = ... # 0x14
    SslInvalidUserDataError  : QAbstractSocket.SocketError = ... # 0x15
    TemporaryError           : QAbstractSocket.SocketError = ... # 0x16
    LowDelayOption           : QAbstractSocket.SocketOption = ... # 0x0
    KeepAliveOption          : QAbstractSocket.SocketOption = ... # 0x1
    MulticastTtlOption       : QAbstractSocket.SocketOption = ... # 0x2
    MulticastLoopbackOption  : QAbstractSocket.SocketOption = ... # 0x3
    TypeOfServiceOption      : QAbstractSocket.SocketOption = ... # 0x4
    SendBufferSizeSocketOption: QAbstractSocket.SocketOption = ... # 0x5
    ReceiveBufferSizeSocketOption: QAbstractSocket.SocketOption = ... # 0x6
    PathMtuSocketOption      : QAbstractSocket.SocketOption = ... # 0x7
    UnconnectedState         : QAbstractSocket.SocketState = ... # 0x0
    HostLookupState          : QAbstractSocket.SocketState = ... # 0x1
    ConnectingState          : QAbstractSocket.SocketState = ... # 0x2
    ConnectedState           : QAbstractSocket.SocketState = ... # 0x3
    BoundState               : QAbstractSocket.SocketState = ... # 0x4
    ListeningState           : QAbstractSocket.SocketState = ... # 0x5
    ClosingState             : QAbstractSocket.SocketState = ... # 0x6
    UnknownSocketType        : QAbstractSocket.SocketType = ... # -0x1
    TcpSocket                : QAbstractSocket.SocketType = ... # 0x0
    UdpSocket                : QAbstractSocket.SocketType = ... # 0x1
    SctpSocket               : QAbstractSocket.SocketType = ... # 0x2

    class BindFlag(Shiboken.Enum):
        DefaultForPlatform       : QAbstractSocket.BindFlag = ... # 0x0
        ShareAddress             : QAbstractSocket.BindFlag = ... # 0x1
        DontShareAddress         : QAbstractSocket.BindFlag = ... # 0x2
        ReuseAddressHint         : QAbstractSocket.BindFlag = ... # 0x4

    class BindMode(object): ...

    class NetworkLayerProtocol(Shiboken.Enum):
        UnknownNetworkLayerProtocol: QAbstractSocket.NetworkLayerProtocol = ... # -0x1
        IPv4Protocol             : QAbstractSocket.NetworkLayerProtocol = ... # 0x0
        IPv6Protocol             : QAbstractSocket.NetworkLayerProtocol = ... # 0x1
        AnyIPProtocol            : QAbstractSocket.NetworkLayerProtocol = ... # 0x2

    class PauseMode(Shiboken.Enum):
        PauseNever               : QAbstractSocket.PauseMode = ... # 0x0
        PauseOnSslErrors         : QAbstractSocket.PauseMode = ... # 0x1

    class PauseModes(object): ...

    class SocketError(Shiboken.Enum):
        UnknownSocketError       : QAbstractSocket.SocketError = ... # -0x1
        ConnectionRefusedError   : QAbstractSocket.SocketError = ... # 0x0
        RemoteHostClosedError    : QAbstractSocket.SocketError = ... # 0x1
        HostNotFoundError        : QAbstractSocket.SocketError = ... # 0x2
        SocketAccessError        : QAbstractSocket.SocketError = ... # 0x3
        SocketResourceError      : QAbstractSocket.SocketError = ... # 0x4
        SocketTimeoutError       : QAbstractSocket.SocketError = ... # 0x5
        DatagramTooLargeError    : QAbstractSocket.SocketError = ... # 0x6
        NetworkError             : QAbstractSocket.SocketError = ... # 0x7
        AddressInUseError        : QAbstractSocket.SocketError = ... # 0x8
        SocketAddressNotAvailableError: QAbstractSocket.SocketError = ... # 0x9
        UnsupportedSocketOperationError: QAbstractSocket.SocketError = ... # 0xa
        UnfinishedSocketOperationError: QAbstractSocket.SocketError = ... # 0xb
        ProxyAuthenticationRequiredError: QAbstractSocket.SocketError = ... # 0xc
        SslHandshakeFailedError  : QAbstractSocket.SocketError = ... # 0xd
        ProxyConnectionRefusedError: QAbstractSocket.SocketError = ... # 0xe
        ProxyConnectionClosedError: QAbstractSocket.SocketError = ... # 0xf
        ProxyConnectionTimeoutError: QAbstractSocket.SocketError = ... # 0x10
        ProxyNotFoundError       : QAbstractSocket.SocketError = ... # 0x11
        ProxyProtocolError       : QAbstractSocket.SocketError = ... # 0x12
        OperationError           : QAbstractSocket.SocketError = ... # 0x13
        SslInternalError         : QAbstractSocket.SocketError = ... # 0x14
        SslInvalidUserDataError  : QAbstractSocket.SocketError = ... # 0x15
        TemporaryError           : QAbstractSocket.SocketError = ... # 0x16

    class SocketOption(Shiboken.Enum):
        LowDelayOption           : QAbstractSocket.SocketOption = ... # 0x0
        KeepAliveOption          : QAbstractSocket.SocketOption = ... # 0x1
        MulticastTtlOption       : QAbstractSocket.SocketOption = ... # 0x2
        MulticastLoopbackOption  : QAbstractSocket.SocketOption = ... # 0x3
        TypeOfServiceOption      : QAbstractSocket.SocketOption = ... # 0x4
        SendBufferSizeSocketOption: QAbstractSocket.SocketOption = ... # 0x5
        ReceiveBufferSizeSocketOption: QAbstractSocket.SocketOption = ... # 0x6
        PathMtuSocketOption      : QAbstractSocket.SocketOption = ... # 0x7

    class SocketState(Shiboken.Enum):
        UnconnectedState         : QAbstractSocket.SocketState = ... # 0x0
        HostLookupState          : QAbstractSocket.SocketState = ... # 0x1
        ConnectingState          : QAbstractSocket.SocketState = ... # 0x2
        ConnectedState           : QAbstractSocket.SocketState = ... # 0x3
        BoundState               : QAbstractSocket.SocketState = ... # 0x4
        ListeningState           : QAbstractSocket.SocketState = ... # 0x5
        ClosingState             : QAbstractSocket.SocketState = ... # 0x6

    class SocketType(Shiboken.Enum):
        UnknownSocketType        : QAbstractSocket.SocketType = ... # -0x1
        TcpSocket                : QAbstractSocket.SocketType = ... # 0x0
        UdpSocket                : QAbstractSocket.SocketType = ... # 0x1
        SctpSocket               : QAbstractSocket.SocketType = ... # 0x2

    def __init__(self, socketType: PySide2.QtNetwork.QAbstractSocket.SocketType, parent: PySide2.QtCore.QObject) -> None: ...


class QAuthenticator(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QAuthenticator) -> None: ...


class QDnsDomainNameRecord(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QDnsDomainNameRecord) -> None: ...


class QDnsHostAddressRecord(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QDnsHostAddressRecord) -> None: ...


class QDnsLookup(PySide2.QtCore.QObject):
    NoError                  : QDnsLookup.Error = ... # 0x0
    ResolverError            : QDnsLookup.Error = ... # 0x1
    OperationCancelledError  : QDnsLookup.Error = ... # 0x2
    InvalidRequestError      : QDnsLookup.Error = ... # 0x3
    InvalidReplyError        : QDnsLookup.Error = ... # 0x4
    ServerFailureError       : QDnsLookup.Error = ... # 0x5
    ServerRefusedError       : QDnsLookup.Error = ... # 0x6
    NotFoundError            : QDnsLookup.Error = ... # 0x7
    A                        : QDnsLookup.Type = ... # 0x1
    NS                       : QDnsLookup.Type = ... # 0x2
    CNAME                    : QDnsLookup.Type = ... # 0x5
    PTR                      : QDnsLookup.Type = ... # 0xc
    MX                       : QDnsLookup.Type = ... # 0xf
    TXT                      : QDnsLookup.Type = ... # 0x10
    AAAA                     : QDnsLookup.Type = ... # 0x1c
    SRV                      : QDnsLookup.Type = ... # 0x21
    ANY                      : QDnsLookup.Type = ... # 0xff

    class Error(Shiboken.Enum):
        NoError                  : QDnsLookup.Error = ... # 0x0
        ResolverError            : QDnsLookup.Error = ... # 0x1
        OperationCancelledError  : QDnsLookup.Error = ... # 0x2
        InvalidRequestError      : QDnsLookup.Error = ... # 0x3
        InvalidReplyError        : QDnsLookup.Error = ... # 0x4
        ServerFailureError       : QDnsLookup.Error = ... # 0x5
        ServerRefusedError       : QDnsLookup.Error = ... # 0x6
        NotFoundError            : QDnsLookup.Error = ... # 0x7

    class Type(Shiboken.Enum):
        A                        : QDnsLookup.Type = ... # 0x1
        NS                       : QDnsLookup.Type = ... # 0x2
        CNAME                    : QDnsLookup.Type = ... # 0x5
        PTR                      : QDnsLookup.Type = ... # 0xc
        MX                       : QDnsLookup.Type = ... # 0xf
        TXT                      : QDnsLookup.Type = ... # 0x10
        AAAA                     : QDnsLookup.Type = ... # 0x1c
        SRV                      : QDnsLookup.Type = ... # 0x21
        ANY                      : QDnsLookup.Type = ... # 0xff

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, type: PySide2.QtNetwork.QDnsLookup.Type, name: str, nameserver: PySide2.QtNetwork.QHostAddress, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, type: PySide2.QtNetwork.QDnsLookup.Type, name: str, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QDnsMailExchangeRecord(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QDnsMailExchangeRecord) -> None: ...


class QDnsServiceRecord(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QDnsServiceRecord) -> None: ...


class QDnsTextRecord(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QDnsTextRecord) -> None: ...


class QDtls(PySide2.QtCore.QObject):
    HandshakeNotStarted      : QDtls.HandshakeState = ... # 0x0
    HandshakeInProgress      : QDtls.HandshakeState = ... # 0x1
    PeerVerificationFailed   : QDtls.HandshakeState = ... # 0x2
    HandshakeComplete        : QDtls.HandshakeState = ... # 0x3

    class HandshakeState(Shiboken.Enum):
        HandshakeNotStarted      : QDtls.HandshakeState = ... # 0x0
        HandshakeInProgress      : QDtls.HandshakeState = ... # 0x1
        PeerVerificationFailed   : QDtls.HandshakeState = ... # 0x2
        HandshakeComplete        : QDtls.HandshakeState = ... # 0x3

    def __init__(self, mode: PySide2.QtNetwork.QSslSocket.SslMode, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QDtlsError(Shiboken.Enum):
    NoError                  : QDtlsError = ... # 0x0
    InvalidInputParameters   : QDtlsError = ... # 0x1
    InvalidOperation         : QDtlsError = ... # 0x2
    UnderlyingSocketError    : QDtlsError = ... # 0x3
    RemoteClosedConnectionError: QDtlsError = ... # 0x4
    PeerVerificationError    : QDtlsError = ... # 0x5
    TlsInitializationError   : QDtlsError = ... # 0x6
    TlsFatalError            : QDtlsError = ... # 0x7
    TlsNonFatalError         : QDtlsError = ... # 0x8


class QHostAddress(Shiboken.Object):
    StrictConversion         : QHostAddress.ConversionModeFlag = ... # 0x0
    ConvertV4MappedToIPv4    : QHostAddress.ConversionModeFlag = ... # 0x1
    ConvertV4CompatToIPv4    : QHostAddress.ConversionModeFlag = ... # 0x2
    ConvertUnspecifiedAddress: QHostAddress.ConversionModeFlag = ... # 0x4
    ConvertLocalHost         : QHostAddress.ConversionModeFlag = ... # 0x8
    TolerantConversion       : QHostAddress.ConversionModeFlag = ... # 0xff
    Null                     : QHostAddress.SpecialAddress = ... # 0x0
    Broadcast                : QHostAddress.SpecialAddress = ... # 0x1
    LocalHost                : QHostAddress.SpecialAddress = ... # 0x2
    LocalHostIPv6            : QHostAddress.SpecialAddress = ... # 0x3
    Any                      : QHostAddress.SpecialAddress = ... # 0x4
    AnyIPv6                  : QHostAddress.SpecialAddress = ... # 0x5
    AnyIPv4                  : QHostAddress.SpecialAddress = ... # 0x6

    class ConversionMode(object): ...

    class ConversionModeFlag(Shiboken.Enum):
        StrictConversion         : QHostAddress.ConversionModeFlag = ... # 0x0
        ConvertV4MappedToIPv4    : QHostAddress.ConversionModeFlag = ... # 0x1
        ConvertV4CompatToIPv4    : QHostAddress.ConversionModeFlag = ... # 0x2
        ConvertUnspecifiedAddress: QHostAddress.ConversionModeFlag = ... # 0x4
        ConvertLocalHost         : QHostAddress.ConversionModeFlag = ... # 0x8
        TolerantConversion       : QHostAddress.ConversionModeFlag = ... # 0xff

    class SpecialAddress(Shiboken.Enum):
        Null                     : QHostAddress.SpecialAddress = ... # 0x0
        Broadcast                : QHostAddress.SpecialAddress = ... # 0x1
        LocalHost                : QHostAddress.SpecialAddress = ... # 0x2
        LocalHostIPv6            : QHostAddress.SpecialAddress = ... # 0x3
        Any                      : QHostAddress.SpecialAddress = ... # 0x4
        AnyIPv6                  : QHostAddress.SpecialAddress = ... # 0x5
        AnyIPv4                  : QHostAddress.SpecialAddress = ... # 0x6

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, address: PySide2.QtNetwork.QHostAddress.SpecialAddress) -> None: ...
    @typing.overload
    def __init__(self, address: str) -> None: ...
    @typing.overload
    def __init__(self, copy: PySide2.QtNetwork.QHostAddress) -> None: ...
    @typing.overload
    def __init__(self, ip4Addr: int) -> None: ...
    @typing.overload
    def __init__(self, ip6Addr: PySide2.QtNetwork.QIPv6Address) -> None: ...


class QHostInfo(Shiboken.Object):
    NoError                  : QHostInfo.HostInfoError = ... # 0x0
    HostNotFound             : QHostInfo.HostInfoError = ... # 0x1
    UnknownError             : QHostInfo.HostInfoError = ... # 0x2

    class HostInfoError(Shiboken.Enum):
        NoError                  : QHostInfo.HostInfoError = ... # 0x0
        HostNotFound             : QHostInfo.HostInfoError = ... # 0x1
        UnknownError             : QHostInfo.HostInfoError = ... # 0x2

    @typing.overload
    def __init__(self, d: PySide2.QtNetwork.QHostInfo) -> None: ...
    @typing.overload
    def __init__(self, lookupId: int = ...) -> None: ...


class QHstsPolicy(Shiboken.Object):
    IncludeSubDomains        : QHstsPolicy.PolicyFlag = ... # 0x1

    class PolicyFlag(Shiboken.Enum):
        IncludeSubDomains        : QHstsPolicy.PolicyFlag = ... # 0x1

    class PolicyFlags(object): ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, expiry: PySide2.QtCore.QDateTime, flags: PySide2.QtNetwork.QHstsPolicy.PolicyFlags, host: str, mode: PySide2.QtCore.QUrl.ParsingMode = ...) -> None: ...
    @typing.overload
    def __init__(self, rhs: PySide2.QtNetwork.QHstsPolicy) -> None: ...


class QHttpMultiPart(PySide2.QtCore.QObject):
    MixedType                : QHttpMultiPart.ContentType = ... # 0x0
    RelatedType              : QHttpMultiPart.ContentType = ... # 0x1
    FormDataType             : QHttpMultiPart.ContentType = ... # 0x2
    AlternativeType          : QHttpMultiPart.ContentType = ... # 0x3

    class ContentType(Shiboken.Enum):
        MixedType                : QHttpMultiPart.ContentType = ... # 0x0
        RelatedType              : QHttpMultiPart.ContentType = ... # 0x1
        FormDataType             : QHttpMultiPart.ContentType = ... # 0x2
        AlternativeType          : QHttpMultiPart.ContentType = ... # 0x3

    @typing.overload
    def __init__(self, contentType: PySide2.QtNetwork.QHttpMultiPart.ContentType, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QHttpPart(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QHttpPart) -> None: ...


class QIPv6Address(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QIPv6Address: PySide2.QtNetwork.QIPv6Address) -> None: ...


class QLocalServer(PySide2.QtCore.QObject):
    NoOptions                : QLocalServer.SocketOption = ... # 0x0
    UserAccessOption         : QLocalServer.SocketOption = ... # 0x1
    GroupAccessOption        : QLocalServer.SocketOption = ... # 0x2
    OtherAccessOption        : QLocalServer.SocketOption = ... # 0x4
    WorldAccessOption        : QLocalServer.SocketOption = ... # 0x7

    class SocketOption(Shiboken.Enum):
        NoOptions                : QLocalServer.SocketOption = ... # 0x0
        UserAccessOption         : QLocalServer.SocketOption = ... # 0x1
        GroupAccessOption        : QLocalServer.SocketOption = ... # 0x2
        OtherAccessOption        : QLocalServer.SocketOption = ... # 0x4
        WorldAccessOption        : QLocalServer.SocketOption = ... # 0x7

    class SocketOptions(object): ...

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QLocalSocket(PySide2.QtCore.QIODevice):
    UnknownSocketError       : QLocalSocket.LocalSocketError = ... # -0x1
    ConnectionRefusedError   : QLocalSocket.LocalSocketError = ... # 0x0
    PeerClosedError          : QLocalSocket.LocalSocketError = ... # 0x1
    ServerNotFoundError      : QLocalSocket.LocalSocketError = ... # 0x2
    SocketAccessError        : QLocalSocket.LocalSocketError = ... # 0x3
    SocketResourceError      : QLocalSocket.LocalSocketError = ... # 0x4
    SocketTimeoutError       : QLocalSocket.LocalSocketError = ... # 0x5
    DatagramTooLargeError    : QLocalSocket.LocalSocketError = ... # 0x6
    ConnectionError          : QLocalSocket.LocalSocketError = ... # 0x7
    UnsupportedSocketOperationError: QLocalSocket.LocalSocketError = ... # 0xa
    OperationError           : QLocalSocket.LocalSocketError = ... # 0x13
    UnconnectedState         : QLocalSocket.LocalSocketState = ... # 0x0
    ConnectingState          : QLocalSocket.LocalSocketState = ... # 0x2
    ConnectedState           : QLocalSocket.LocalSocketState = ... # 0x3
    ClosingState             : QLocalSocket.LocalSocketState = ... # 0x6

    class LocalSocketError(Shiboken.Enum):
        UnknownSocketError       : QLocalSocket.LocalSocketError = ... # -0x1
        ConnectionRefusedError   : QLocalSocket.LocalSocketError = ... # 0x0
        PeerClosedError          : QLocalSocket.LocalSocketError = ... # 0x1
        ServerNotFoundError      : QLocalSocket.LocalSocketError = ... # 0x2
        SocketAccessError        : QLocalSocket.LocalSocketError = ... # 0x3
        SocketResourceError      : QLocalSocket.LocalSocketError = ... # 0x4
        SocketTimeoutError       : QLocalSocket.LocalSocketError = ... # 0x5
        DatagramTooLargeError    : QLocalSocket.LocalSocketError = ... # 0x6
        ConnectionError          : QLocalSocket.LocalSocketError = ... # 0x7
        UnsupportedSocketOperationError: QLocalSocket.LocalSocketError = ... # 0xa
        OperationError           : QLocalSocket.LocalSocketError = ... # 0x13

    class LocalSocketState(Shiboken.Enum):
        UnconnectedState         : QLocalSocket.LocalSocketState = ... # 0x0
        ConnectingState          : QLocalSocket.LocalSocketState = ... # 0x2
        ConnectedState           : QLocalSocket.LocalSocketState = ... # 0x3
        ClosingState             : QLocalSocket.LocalSocketState = ... # 0x6

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QNetworkAccessManager(PySide2.QtCore.QObject):
    UnknownAccessibility     : QNetworkAccessManager.NetworkAccessibility = ... # -0x1
    NotAccessible            : QNetworkAccessManager.NetworkAccessibility = ... # 0x0
    Accessible               : QNetworkAccessManager.NetworkAccessibility = ... # 0x1
    UnknownOperation         : QNetworkAccessManager.Operation = ... # 0x0
    HeadOperation            : QNetworkAccessManager.Operation = ... # 0x1
    GetOperation             : QNetworkAccessManager.Operation = ... # 0x2
    PutOperation             : QNetworkAccessManager.Operation = ... # 0x3
    PostOperation            : QNetworkAccessManager.Operation = ... # 0x4
    DeleteOperation          : QNetworkAccessManager.Operation = ... # 0x5
    CustomOperation          : QNetworkAccessManager.Operation = ... # 0x6

    class NetworkAccessibility(Shiboken.Enum):
        UnknownAccessibility     : QNetworkAccessManager.NetworkAccessibility = ... # -0x1
        NotAccessible            : QNetworkAccessManager.NetworkAccessibility = ... # 0x0
        Accessible               : QNetworkAccessManager.NetworkAccessibility = ... # 0x1

    class Operation(Shiboken.Enum):
        UnknownOperation         : QNetworkAccessManager.Operation = ... # 0x0
        HeadOperation            : QNetworkAccessManager.Operation = ... # 0x1
        GetOperation             : QNetworkAccessManager.Operation = ... # 0x2
        PutOperation             : QNetworkAccessManager.Operation = ... # 0x3
        PostOperation            : QNetworkAccessManager.Operation = ... # 0x4
        DeleteOperation          : QNetworkAccessManager.Operation = ... # 0x5
        CustomOperation          : QNetworkAccessManager.Operation = ... # 0x6

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QNetworkAddressEntry(Shiboken.Object):
    DnsEligibilityUnknown    : QNetworkAddressEntry.DnsEligibilityStatus = ... # -0x1
    DnsIneligible            : QNetworkAddressEntry.DnsEligibilityStatus = ... # 0x0
    DnsEligible              : QNetworkAddressEntry.DnsEligibilityStatus = ... # 0x1

    class DnsEligibilityStatus(Shiboken.Enum):
        DnsEligibilityUnknown    : QNetworkAddressEntry.DnsEligibilityStatus = ... # -0x1
        DnsIneligible            : QNetworkAddressEntry.DnsEligibilityStatus = ... # 0x0
        DnsEligible              : QNetworkAddressEntry.DnsEligibilityStatus = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QNetworkAddressEntry) -> None: ...


class QNetworkCacheMetaData(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QNetworkCacheMetaData) -> None: ...


class QNetworkConfiguration(Shiboken.Object):
    BearerUnknown            : QNetworkConfiguration.BearerType = ... # 0x0
    BearerEthernet           : QNetworkConfiguration.BearerType = ... # 0x1
    BearerWLAN               : QNetworkConfiguration.BearerType = ... # 0x2
    Bearer2G                 : QNetworkConfiguration.BearerType = ... # 0x3
    BearerCDMA2000           : QNetworkConfiguration.BearerType = ... # 0x4
    BearerWCDMA              : QNetworkConfiguration.BearerType = ... # 0x5
    BearerHSPA               : QNetworkConfiguration.BearerType = ... # 0x6
    BearerBluetooth          : QNetworkConfiguration.BearerType = ... # 0x7
    BearerWiMAX              : QNetworkConfiguration.BearerType = ... # 0x8
    BearerEVDO               : QNetworkConfiguration.BearerType = ... # 0x9
    BearerLTE                : QNetworkConfiguration.BearerType = ... # 0xa
    Bearer3G                 : QNetworkConfiguration.BearerType = ... # 0xb
    Bearer4G                 : QNetworkConfiguration.BearerType = ... # 0xc
    UnknownPurpose           : QNetworkConfiguration.Purpose = ... # 0x0
    PublicPurpose            : QNetworkConfiguration.Purpose = ... # 0x1
    PrivatePurpose           : QNetworkConfiguration.Purpose = ... # 0x2
    ServiceSpecificPurpose   : QNetworkConfiguration.Purpose = ... # 0x3
    Undefined                : QNetworkConfiguration.StateFlag = ... # 0x1
    Defined                  : QNetworkConfiguration.StateFlag = ... # 0x2
    Discovered               : QNetworkConfiguration.StateFlag = ... # 0x6
    Active                   : QNetworkConfiguration.StateFlag = ... # 0xe
    InternetAccessPoint      : QNetworkConfiguration.Type = ... # 0x0
    ServiceNetwork           : QNetworkConfiguration.Type = ... # 0x1
    UserChoice               : QNetworkConfiguration.Type = ... # 0x2
    Invalid                  : QNetworkConfiguration.Type = ... # 0x3

    class BearerType(Shiboken.Enum):
        BearerUnknown            : QNetworkConfiguration.BearerType = ... # 0x0
        BearerEthernet           : QNetworkConfiguration.BearerType = ... # 0x1
        BearerWLAN               : QNetworkConfiguration.BearerType = ... # 0x2
        Bearer2G                 : QNetworkConfiguration.BearerType = ... # 0x3
        BearerCDMA2000           : QNetworkConfiguration.BearerType = ... # 0x4
        BearerWCDMA              : QNetworkConfiguration.BearerType = ... # 0x5
        BearerHSPA               : QNetworkConfiguration.BearerType = ... # 0x6
        BearerBluetooth          : QNetworkConfiguration.BearerType = ... # 0x7
        BearerWiMAX              : QNetworkConfiguration.BearerType = ... # 0x8
        BearerEVDO               : QNetworkConfiguration.BearerType = ... # 0x9
        BearerLTE                : QNetworkConfiguration.BearerType = ... # 0xa
        Bearer3G                 : QNetworkConfiguration.BearerType = ... # 0xb
        Bearer4G                 : QNetworkConfiguration.BearerType = ... # 0xc

    class Purpose(Shiboken.Enum):
        UnknownPurpose           : QNetworkConfiguration.Purpose = ... # 0x0
        PublicPurpose            : QNetworkConfiguration.Purpose = ... # 0x1
        PrivatePurpose           : QNetworkConfiguration.Purpose = ... # 0x2
        ServiceSpecificPurpose   : QNetworkConfiguration.Purpose = ... # 0x3

    class StateFlag(Shiboken.Enum):
        Undefined                : QNetworkConfiguration.StateFlag = ... # 0x1
        Defined                  : QNetworkConfiguration.StateFlag = ... # 0x2
        Discovered               : QNetworkConfiguration.StateFlag = ... # 0x6
        Active                   : QNetworkConfiguration.StateFlag = ... # 0xe

    class StateFlags(object): ...

    class Type(Shiboken.Enum):
        InternetAccessPoint      : QNetworkConfiguration.Type = ... # 0x0
        ServiceNetwork           : QNetworkConfiguration.Type = ... # 0x1
        UserChoice               : QNetworkConfiguration.Type = ... # 0x2
        Invalid                  : QNetworkConfiguration.Type = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QNetworkConfiguration) -> None: ...


class QNetworkConfigurationManager(PySide2.QtCore.QObject):
    CanStartAndStopInterfaces: QNetworkConfigurationManager.Capability = ... # 0x1
    DirectConnectionRouting  : QNetworkConfigurationManager.Capability = ... # 0x2
    SystemSessionSupport     : QNetworkConfigurationManager.Capability = ... # 0x4
    ApplicationLevelRoaming  : QNetworkConfigurationManager.Capability = ... # 0x8
    ForcedRoaming            : QNetworkConfigurationManager.Capability = ... # 0x10
    DataStatistics           : QNetworkConfigurationManager.Capability = ... # 0x20
    NetworkSessionRequired   : QNetworkConfigurationManager.Capability = ... # 0x40

    class Capabilities(object): ...

    class Capability(Shiboken.Enum):
        CanStartAndStopInterfaces: QNetworkConfigurationManager.Capability = ... # 0x1
        DirectConnectionRouting  : QNetworkConfigurationManager.Capability = ... # 0x2
        SystemSessionSupport     : QNetworkConfigurationManager.Capability = ... # 0x4
        ApplicationLevelRoaming  : QNetworkConfigurationManager.Capability = ... # 0x8
        ForcedRoaming            : QNetworkConfigurationManager.Capability = ... # 0x10
        DataStatistics           : QNetworkConfigurationManager.Capability = ... # 0x20
        NetworkSessionRequired   : QNetworkConfigurationManager.Capability = ... # 0x40

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QNetworkCookie(Shiboken.Object):
    NameAndValueOnly         : QNetworkCookie.RawForm = ... # 0x0
    Full                     : QNetworkCookie.RawForm = ... # 0x1

    class RawForm(Shiboken.Enum):
        NameAndValueOnly         : QNetworkCookie.RawForm = ... # 0x0
        Full                     : QNetworkCookie.RawForm = ... # 0x1

    @typing.overload
    def __init__(self, name: PySide2.QtCore.QByteArray = ..., value: PySide2.QtCore.QByteArray = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QNetworkCookie) -> None: ...


class QNetworkCookieJar(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QNetworkDatagram(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, data: PySide2.QtCore.QByteArray, destinationAddress: PySide2.QtNetwork.QHostAddress = ..., port: int = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QNetworkDatagram) -> None: ...


class QNetworkDiskCache(PySide2.QtNetwork.QAbstractNetworkCache):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QNetworkInterface(Shiboken.Object):
    IsUp                     : QNetworkInterface.InterfaceFlag = ... # 0x1
    IsRunning                : QNetworkInterface.InterfaceFlag = ... # 0x2
    CanBroadcast             : QNetworkInterface.InterfaceFlag = ... # 0x4
    IsLoopBack               : QNetworkInterface.InterfaceFlag = ... # 0x8
    IsPointToPoint           : QNetworkInterface.InterfaceFlag = ... # 0x10
    CanMulticast             : QNetworkInterface.InterfaceFlag = ... # 0x20
    Unknown                  : QNetworkInterface.InterfaceType = ... # 0x0
    Loopback                 : QNetworkInterface.InterfaceType = ... # 0x1
    Virtual                  : QNetworkInterface.InterfaceType = ... # 0x2
    Ethernet                 : QNetworkInterface.InterfaceType = ... # 0x3
    Slip                     : QNetworkInterface.InterfaceType = ... # 0x4
    CanBus                   : QNetworkInterface.InterfaceType = ... # 0x5
    Ppp                      : QNetworkInterface.InterfaceType = ... # 0x6
    Fddi                     : QNetworkInterface.InterfaceType = ... # 0x7
    Ieee80211                : QNetworkInterface.InterfaceType = ... # 0x8
    Wifi                     : QNetworkInterface.InterfaceType = ... # 0x8
    Phonet                   : QNetworkInterface.InterfaceType = ... # 0x9
    Ieee802154               : QNetworkInterface.InterfaceType = ... # 0xa
    SixLoWPAN                : QNetworkInterface.InterfaceType = ... # 0xb
    Ieee80216                : QNetworkInterface.InterfaceType = ... # 0xc
    Ieee1394                 : QNetworkInterface.InterfaceType = ... # 0xd

    class InterfaceFlag(Shiboken.Enum):
        IsUp                     : QNetworkInterface.InterfaceFlag = ... # 0x1
        IsRunning                : QNetworkInterface.InterfaceFlag = ... # 0x2
        CanBroadcast             : QNetworkInterface.InterfaceFlag = ... # 0x4
        IsLoopBack               : QNetworkInterface.InterfaceFlag = ... # 0x8
        IsPointToPoint           : QNetworkInterface.InterfaceFlag = ... # 0x10
        CanMulticast             : QNetworkInterface.InterfaceFlag = ... # 0x20

    class InterfaceFlags(object): ...

    class InterfaceType(Shiboken.Enum):
        Unknown                  : QNetworkInterface.InterfaceType = ... # 0x0
        Loopback                 : QNetworkInterface.InterfaceType = ... # 0x1
        Virtual                  : QNetworkInterface.InterfaceType = ... # 0x2
        Ethernet                 : QNetworkInterface.InterfaceType = ... # 0x3
        Slip                     : QNetworkInterface.InterfaceType = ... # 0x4
        CanBus                   : QNetworkInterface.InterfaceType = ... # 0x5
        Ppp                      : QNetworkInterface.InterfaceType = ... # 0x6
        Fddi                     : QNetworkInterface.InterfaceType = ... # 0x7
        Ieee80211                : QNetworkInterface.InterfaceType = ... # 0x8
        Wifi                     : QNetworkInterface.InterfaceType = ... # 0x8
        Phonet                   : QNetworkInterface.InterfaceType = ... # 0x9
        Ieee802154               : QNetworkInterface.InterfaceType = ... # 0xa
        SixLoWPAN                : QNetworkInterface.InterfaceType = ... # 0xb
        Ieee80216                : QNetworkInterface.InterfaceType = ... # 0xc
        Ieee1394                 : QNetworkInterface.InterfaceType = ... # 0xd

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QNetworkInterface) -> None: ...


class QNetworkProxy(Shiboken.Object):
    TunnelingCapability      : QNetworkProxy.Capability = ... # 0x1
    ListeningCapability      : QNetworkProxy.Capability = ... # 0x2
    UdpTunnelingCapability   : QNetworkProxy.Capability = ... # 0x4
    CachingCapability        : QNetworkProxy.Capability = ... # 0x8
    HostNameLookupCapability : QNetworkProxy.Capability = ... # 0x10
    SctpTunnelingCapability  : QNetworkProxy.Capability = ... # 0x20
    SctpListeningCapability  : QNetworkProxy.Capability = ... # 0x40
    DefaultProxy             : QNetworkProxy.ProxyType = ... # 0x0
    Socks5Proxy              : QNetworkProxy.ProxyType = ... # 0x1
    NoProxy                  : QNetworkProxy.ProxyType = ... # 0x2
    HttpProxy                : QNetworkProxy.ProxyType = ... # 0x3
    HttpCachingProxy         : QNetworkProxy.ProxyType = ... # 0x4
    FtpCachingProxy          : QNetworkProxy.ProxyType = ... # 0x5

    class Capabilities(object): ...

    class Capability(Shiboken.Enum):
        TunnelingCapability      : QNetworkProxy.Capability = ... # 0x1
        ListeningCapability      : QNetworkProxy.Capability = ... # 0x2
        UdpTunnelingCapability   : QNetworkProxy.Capability = ... # 0x4
        CachingCapability        : QNetworkProxy.Capability = ... # 0x8
        HostNameLookupCapability : QNetworkProxy.Capability = ... # 0x10
        SctpTunnelingCapability  : QNetworkProxy.Capability = ... # 0x20
        SctpListeningCapability  : QNetworkProxy.Capability = ... # 0x40

    class ProxyType(Shiboken.Enum):
        DefaultProxy             : QNetworkProxy.ProxyType = ... # 0x0
        Socks5Proxy              : QNetworkProxy.ProxyType = ... # 0x1
        NoProxy                  : QNetworkProxy.ProxyType = ... # 0x2
        HttpProxy                : QNetworkProxy.ProxyType = ... # 0x3
        HttpCachingProxy         : QNetworkProxy.ProxyType = ... # 0x4
        FtpCachingProxy          : QNetworkProxy.ProxyType = ... # 0x5

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QNetworkProxy) -> None: ...
    @typing.overload
    def __init__(self, type: PySide2.QtNetwork.QNetworkProxy.ProxyType, hostName: str = ..., port: int = ..., user: str = ..., password: str = ...) -> None: ...


class QNetworkProxyFactory(Shiboken.Object):

    def __init__(self) -> None: ...


class QNetworkProxyQuery(Shiboken.Object):
    TcpSocket                : QNetworkProxyQuery.QueryType = ... # 0x0
    UdpSocket                : QNetworkProxyQuery.QueryType = ... # 0x1
    SctpSocket               : QNetworkProxyQuery.QueryType = ... # 0x2
    TcpServer                : QNetworkProxyQuery.QueryType = ... # 0x64
    UrlRequest               : QNetworkProxyQuery.QueryType = ... # 0x65
    SctpServer               : QNetworkProxyQuery.QueryType = ... # 0x66

    class QueryType(Shiboken.Enum):
        TcpSocket                : QNetworkProxyQuery.QueryType = ... # 0x0
        UdpSocket                : QNetworkProxyQuery.QueryType = ... # 0x1
        SctpSocket               : QNetworkProxyQuery.QueryType = ... # 0x2
        TcpServer                : QNetworkProxyQuery.QueryType = ... # 0x64
        UrlRequest               : QNetworkProxyQuery.QueryType = ... # 0x65
        SctpServer               : QNetworkProxyQuery.QueryType = ... # 0x66

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, bindPort: int, protocolTag: str = ..., queryType: PySide2.QtNetwork.QNetworkProxyQuery.QueryType = ...) -> None: ...
    @typing.overload
    def __init__(self, hostname: str, port: int, protocolTag: str = ..., queryType: PySide2.QtNetwork.QNetworkProxyQuery.QueryType = ...) -> None: ...
    @typing.overload
    def __init__(self, networkConfiguration: PySide2.QtNetwork.QNetworkConfiguration, bindPort: int, protocolTag: str = ..., queryType: PySide2.QtNetwork.QNetworkProxyQuery.QueryType = ...) -> None: ...
    @typing.overload
    def __init__(self, networkConfiguration: PySide2.QtNetwork.QNetworkConfiguration, hostname: str, port: int, protocolTag: str = ..., queryType: PySide2.QtNetwork.QNetworkProxyQuery.QueryType = ...) -> None: ...
    @typing.overload
    def __init__(self, networkConfiguration: PySide2.QtNetwork.QNetworkConfiguration, requestUrl: PySide2.QtCore.QUrl, queryType: PySide2.QtNetwork.QNetworkProxyQuery.QueryType = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QNetworkProxyQuery) -> None: ...
    @typing.overload
    def __init__(self, requestUrl: PySide2.QtCore.QUrl, queryType: PySide2.QtNetwork.QNetworkProxyQuery.QueryType = ...) -> None: ...


class QNetworkReply(PySide2.QtCore.QIODevice):
    NoError                  : QNetworkReply.NetworkError = ... # 0x0
    ConnectionRefusedError   : QNetworkReply.NetworkError = ... # 0x1
    RemoteHostClosedError    : QNetworkReply.NetworkError = ... # 0x2
    HostNotFoundError        : QNetworkReply.NetworkError = ... # 0x3
    TimeoutError             : QNetworkReply.NetworkError = ... # 0x4
    OperationCanceledError   : QNetworkReply.NetworkError = ... # 0x5
    SslHandshakeFailedError  : QNetworkReply.NetworkError = ... # 0x6
    TemporaryNetworkFailureError: QNetworkReply.NetworkError = ... # 0x7
    NetworkSessionFailedError: QNetworkReply.NetworkError = ... # 0x8
    BackgroundRequestNotAllowedError: QNetworkReply.NetworkError = ... # 0x9
    TooManyRedirectsError    : QNetworkReply.NetworkError = ... # 0xa
    InsecureRedirectError    : QNetworkReply.NetworkError = ... # 0xb
    UnknownNetworkError      : QNetworkReply.NetworkError = ... # 0x63
    ProxyConnectionRefusedError: QNetworkReply.NetworkError = ... # 0x65
    ProxyConnectionClosedError: QNetworkReply.NetworkError = ... # 0x66
    ProxyNotFoundError       : QNetworkReply.NetworkError = ... # 0x67
    ProxyTimeoutError        : QNetworkReply.NetworkError = ... # 0x68
    ProxyAuthenticationRequiredError: QNetworkReply.NetworkError = ... # 0x69
    UnknownProxyError        : QNetworkReply.NetworkError = ... # 0xc7
    ContentAccessDenied      : QNetworkReply.NetworkError = ... # 0xc9
    ContentOperationNotPermittedError: QNetworkReply.NetworkError = ... # 0xca
    ContentNotFoundError     : QNetworkReply.NetworkError = ... # 0xcb
    AuthenticationRequiredError: QNetworkReply.NetworkError = ... # 0xcc
    ContentReSendError       : QNetworkReply.NetworkError = ... # 0xcd
    ContentConflictError     : QNetworkReply.NetworkError = ... # 0xce
    ContentGoneError         : QNetworkReply.NetworkError = ... # 0xcf
    UnknownContentError      : QNetworkReply.NetworkError = ... # 0x12b
    ProtocolUnknownError     : QNetworkReply.NetworkError = ... # 0x12d
    ProtocolInvalidOperationError: QNetworkReply.NetworkError = ... # 0x12e
    ProtocolFailure          : QNetworkReply.NetworkError = ... # 0x18f
    InternalServerError      : QNetworkReply.NetworkError = ... # 0x191
    OperationNotImplementedError: QNetworkReply.NetworkError = ... # 0x192
    ServiceUnavailableError  : QNetworkReply.NetworkError = ... # 0x193
    UnknownServerError       : QNetworkReply.NetworkError = ... # 0x1f3

    class NetworkError(Shiboken.Enum):
        NoError                  : QNetworkReply.NetworkError = ... # 0x0
        ConnectionRefusedError   : QNetworkReply.NetworkError = ... # 0x1
        RemoteHostClosedError    : QNetworkReply.NetworkError = ... # 0x2
        HostNotFoundError        : QNetworkReply.NetworkError = ... # 0x3
        TimeoutError             : QNetworkReply.NetworkError = ... # 0x4
        OperationCanceledError   : QNetworkReply.NetworkError = ... # 0x5
        SslHandshakeFailedError  : QNetworkReply.NetworkError = ... # 0x6
        TemporaryNetworkFailureError: QNetworkReply.NetworkError = ... # 0x7
        NetworkSessionFailedError: QNetworkReply.NetworkError = ... # 0x8
        BackgroundRequestNotAllowedError: QNetworkReply.NetworkError = ... # 0x9
        TooManyRedirectsError    : QNetworkReply.NetworkError = ... # 0xa
        InsecureRedirectError    : QNetworkReply.NetworkError = ... # 0xb
        UnknownNetworkError      : QNetworkReply.NetworkError = ... # 0x63
        ProxyConnectionRefusedError: QNetworkReply.NetworkError = ... # 0x65
        ProxyConnectionClosedError: QNetworkReply.NetworkError = ... # 0x66
        ProxyNotFoundError       : QNetworkReply.NetworkError = ... # 0x67
        ProxyTimeoutError        : QNetworkReply.NetworkError = ... # 0x68
        ProxyAuthenticationRequiredError: QNetworkReply.NetworkError = ... # 0x69
        UnknownProxyError        : QNetworkReply.NetworkError = ... # 0xc7
        ContentAccessDenied      : QNetworkReply.NetworkError = ... # 0xc9
        ContentOperationNotPermittedError: QNetworkReply.NetworkError = ... # 0xca
        ContentNotFoundError     : QNetworkReply.NetworkError = ... # 0xcb
        AuthenticationRequiredError: QNetworkReply.NetworkError = ... # 0xcc
        ContentReSendError       : QNetworkReply.NetworkError = ... # 0xcd
        ContentConflictError     : QNetworkReply.NetworkError = ... # 0xce
        ContentGoneError         : QNetworkReply.NetworkError = ... # 0xcf
        UnknownContentError      : QNetworkReply.NetworkError = ... # 0x12b
        ProtocolUnknownError     : QNetworkReply.NetworkError = ... # 0x12d
        ProtocolInvalidOperationError: QNetworkReply.NetworkError = ... # 0x12e
        ProtocolFailure          : QNetworkReply.NetworkError = ... # 0x18f
        InternalServerError      : QNetworkReply.NetworkError = ... # 0x191
        OperationNotImplementedError: QNetworkReply.NetworkError = ... # 0x192
        ServiceUnavailableError  : QNetworkReply.NetworkError = ... # 0x193
        UnknownServerError       : QNetworkReply.NetworkError = ... # 0x1f3

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QNetworkRequest(Shiboken.Object):
    HttpStatusCodeAttribute  : QNetworkRequest.Attribute = ... # 0x0
    HttpReasonPhraseAttribute: QNetworkRequest.Attribute = ... # 0x1
    RedirectionTargetAttribute: QNetworkRequest.Attribute = ... # 0x2
    ConnectionEncryptedAttribute: QNetworkRequest.Attribute = ... # 0x3
    CacheLoadControlAttribute: QNetworkRequest.Attribute = ... # 0x4
    CacheSaveControlAttribute: QNetworkRequest.Attribute = ... # 0x5
    SourceIsFromCacheAttribute: QNetworkRequest.Attribute = ... # 0x6
    DoNotBufferUploadDataAttribute: QNetworkRequest.Attribute = ... # 0x7
    HttpPipeliningAllowedAttribute: QNetworkRequest.Attribute = ... # 0x8
    HttpPipeliningWasUsedAttribute: QNetworkRequest.Attribute = ... # 0x9
    CustomVerbAttribute      : QNetworkRequest.Attribute = ... # 0xa
    CookieLoadControlAttribute: QNetworkRequest.Attribute = ... # 0xb
    AuthenticationReuseAttribute: QNetworkRequest.Attribute = ... # 0xc
    CookieSaveControlAttribute: QNetworkRequest.Attribute = ... # 0xd
    MaximumDownloadBufferSizeAttribute: QNetworkRequest.Attribute = ... # 0xe
    DownloadBufferAttribute  : QNetworkRequest.Attribute = ... # 0xf
    SynchronousRequestAttribute: QNetworkRequest.Attribute = ... # 0x10
    BackgroundRequestAttribute: QNetworkRequest.Attribute = ... # 0x11
    SpdyAllowedAttribute     : QNetworkRequest.Attribute = ... # 0x12
    SpdyWasUsedAttribute     : QNetworkRequest.Attribute = ... # 0x13
    EmitAllUploadProgressSignalsAttribute: QNetworkRequest.Attribute = ... # 0x14
    FollowRedirectsAttribute : QNetworkRequest.Attribute = ... # 0x15
    HTTP2AllowedAttribute    : QNetworkRequest.Attribute = ... # 0x16
    Http2AllowedAttribute    : QNetworkRequest.Attribute = ... # 0x16
    HTTP2WasUsedAttribute    : QNetworkRequest.Attribute = ... # 0x17
    Http2WasUsedAttribute    : QNetworkRequest.Attribute = ... # 0x17
    OriginalContentLengthAttribute: QNetworkRequest.Attribute = ... # 0x18
    RedirectPolicyAttribute  : QNetworkRequest.Attribute = ... # 0x19
    Http2DirectAttribute     : QNetworkRequest.Attribute = ... # 0x1a
    ResourceTypeAttribute    : QNetworkRequest.Attribute = ... # 0x1b
    AutoDeleteReplyOnFinishAttribute: QNetworkRequest.Attribute = ... # 0x1c
    User                     : QNetworkRequest.Attribute = ... # 0x3e8
    UserMax                  : QNetworkRequest.Attribute = ... # 0x7fff
    AlwaysNetwork            : QNetworkRequest.CacheLoadControl = ... # 0x0
    PreferNetwork            : QNetworkRequest.CacheLoadControl = ... # 0x1
    PreferCache              : QNetworkRequest.CacheLoadControl = ... # 0x2
    AlwaysCache              : QNetworkRequest.CacheLoadControl = ... # 0x3
    ContentTypeHeader        : QNetworkRequest.KnownHeaders = ... # 0x0
    ContentLengthHeader      : QNetworkRequest.KnownHeaders = ... # 0x1
    LocationHeader           : QNetworkRequest.KnownHeaders = ... # 0x2
    LastModifiedHeader       : QNetworkRequest.KnownHeaders = ... # 0x3
    CookieHeader             : QNetworkRequest.KnownHeaders = ... # 0x4
    SetCookieHeader          : QNetworkRequest.KnownHeaders = ... # 0x5
    ContentDispositionHeader : QNetworkRequest.KnownHeaders = ... # 0x6
    UserAgentHeader          : QNetworkRequest.KnownHeaders = ... # 0x7
    ServerHeader             : QNetworkRequest.KnownHeaders = ... # 0x8
    IfModifiedSinceHeader    : QNetworkRequest.KnownHeaders = ... # 0x9
    ETagHeader               : QNetworkRequest.KnownHeaders = ... # 0xa
    IfMatchHeader            : QNetworkRequest.KnownHeaders = ... # 0xb
    IfNoneMatchHeader        : QNetworkRequest.KnownHeaders = ... # 0xc
    Automatic                : QNetworkRequest.LoadControl = ... # 0x0
    Manual                   : QNetworkRequest.LoadControl = ... # 0x1
    HighPriority             : QNetworkRequest.Priority = ... # 0x1
    NormalPriority           : QNetworkRequest.Priority = ... # 0x3
    LowPriority              : QNetworkRequest.Priority = ... # 0x5
    ManualRedirectPolicy     : QNetworkRequest.RedirectPolicy = ... # 0x0
    NoLessSafeRedirectPolicy : QNetworkRequest.RedirectPolicy = ... # 0x1
    SameOriginRedirectPolicy : QNetworkRequest.RedirectPolicy = ... # 0x2
    UserVerifiedRedirectPolicy: QNetworkRequest.RedirectPolicy = ... # 0x3
    DefaultTransferTimeoutConstant: QNetworkRequest.TransferTimeoutConstant = ... # 0x7530

    class Attribute(Shiboken.Enum):
        HttpStatusCodeAttribute  : QNetworkRequest.Attribute = ... # 0x0
        HttpReasonPhraseAttribute: QNetworkRequest.Attribute = ... # 0x1
        RedirectionTargetAttribute: QNetworkRequest.Attribute = ... # 0x2
        ConnectionEncryptedAttribute: QNetworkRequest.Attribute = ... # 0x3
        CacheLoadControlAttribute: QNetworkRequest.Attribute = ... # 0x4
        CacheSaveControlAttribute: QNetworkRequest.Attribute = ... # 0x5
        SourceIsFromCacheAttribute: QNetworkRequest.Attribute = ... # 0x6
        DoNotBufferUploadDataAttribute: QNetworkRequest.Attribute = ... # 0x7
        HttpPipeliningAllowedAttribute: QNetworkRequest.Attribute = ... # 0x8
        HttpPipeliningWasUsedAttribute: QNetworkRequest.Attribute = ... # 0x9
        CustomVerbAttribute      : QNetworkRequest.Attribute = ... # 0xa
        CookieLoadControlAttribute: QNetworkRequest.Attribute = ... # 0xb
        AuthenticationReuseAttribute: QNetworkRequest.Attribute = ... # 0xc
        CookieSaveControlAttribute: QNetworkRequest.Attribute = ... # 0xd
        MaximumDownloadBufferSizeAttribute: QNetworkRequest.Attribute = ... # 0xe
        DownloadBufferAttribute  : QNetworkRequest.Attribute = ... # 0xf
        SynchronousRequestAttribute: QNetworkRequest.Attribute = ... # 0x10
        BackgroundRequestAttribute: QNetworkRequest.Attribute = ... # 0x11
        SpdyAllowedAttribute     : QNetworkRequest.Attribute = ... # 0x12
        SpdyWasUsedAttribute     : QNetworkRequest.Attribute = ... # 0x13
        EmitAllUploadProgressSignalsAttribute: QNetworkRequest.Attribute = ... # 0x14
        FollowRedirectsAttribute : QNetworkRequest.Attribute = ... # 0x15
        HTTP2AllowedAttribute    : QNetworkRequest.Attribute = ... # 0x16
        Http2AllowedAttribute    : QNetworkRequest.Attribute = ... # 0x16
        HTTP2WasUsedAttribute    : QNetworkRequest.Attribute = ... # 0x17
        Http2WasUsedAttribute    : QNetworkRequest.Attribute = ... # 0x17
        OriginalContentLengthAttribute: QNetworkRequest.Attribute = ... # 0x18
        RedirectPolicyAttribute  : QNetworkRequest.Attribute = ... # 0x19
        Http2DirectAttribute     : QNetworkRequest.Attribute = ... # 0x1a
        ResourceTypeAttribute    : QNetworkRequest.Attribute = ... # 0x1b
        AutoDeleteReplyOnFinishAttribute: QNetworkRequest.Attribute = ... # 0x1c
        User                     : QNetworkRequest.Attribute = ... # 0x3e8
        UserMax                  : QNetworkRequest.Attribute = ... # 0x7fff

    class CacheLoadControl(Shiboken.Enum):
        AlwaysNetwork            : QNetworkRequest.CacheLoadControl = ... # 0x0
        PreferNetwork            : QNetworkRequest.CacheLoadControl = ... # 0x1
        PreferCache              : QNetworkRequest.CacheLoadControl = ... # 0x2
        AlwaysCache              : QNetworkRequest.CacheLoadControl = ... # 0x3

    class KnownHeaders(Shiboken.Enum):
        ContentTypeHeader        : QNetworkRequest.KnownHeaders = ... # 0x0
        ContentLengthHeader      : QNetworkRequest.KnownHeaders = ... # 0x1
        LocationHeader           : QNetworkRequest.KnownHeaders = ... # 0x2
        LastModifiedHeader       : QNetworkRequest.KnownHeaders = ... # 0x3
        CookieHeader             : QNetworkRequest.KnownHeaders = ... # 0x4
        SetCookieHeader          : QNetworkRequest.KnownHeaders = ... # 0x5
        ContentDispositionHeader : QNetworkRequest.KnownHeaders = ... # 0x6
        UserAgentHeader          : QNetworkRequest.KnownHeaders = ... # 0x7
        ServerHeader             : QNetworkRequest.KnownHeaders = ... # 0x8
        IfModifiedSinceHeader    : QNetworkRequest.KnownHeaders = ... # 0x9
        ETagHeader               : QNetworkRequest.KnownHeaders = ... # 0xa
        IfMatchHeader            : QNetworkRequest.KnownHeaders = ... # 0xb
        IfNoneMatchHeader        : QNetworkRequest.KnownHeaders = ... # 0xc

    class LoadControl(Shiboken.Enum):
        Automatic                : QNetworkRequest.LoadControl = ... # 0x0
        Manual                   : QNetworkRequest.LoadControl = ... # 0x1

    class Priority(Shiboken.Enum):
        HighPriority             : QNetworkRequest.Priority = ... # 0x1
        NormalPriority           : QNetworkRequest.Priority = ... # 0x3
        LowPriority              : QNetworkRequest.Priority = ... # 0x5

    class RedirectPolicy(Shiboken.Enum):
        ManualRedirectPolicy     : QNetworkRequest.RedirectPolicy = ... # 0x0
        NoLessSafeRedirectPolicy : QNetworkRequest.RedirectPolicy = ... # 0x1
        SameOriginRedirectPolicy : QNetworkRequest.RedirectPolicy = ... # 0x2
        UserVerifiedRedirectPolicy: QNetworkRequest.RedirectPolicy = ... # 0x3

    class TransferTimeoutConstant(Shiboken.Enum):
        DefaultTransferTimeoutConstant: QNetworkRequest.TransferTimeoutConstant = ... # 0x7530

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QNetworkRequest) -> None: ...
    @typing.overload
    def __init__(self, url: PySide2.QtCore.QUrl) -> None: ...


class QNetworkSession(PySide2.QtCore.QObject):
    UnknownSessionError      : QNetworkSession.SessionError = ... # 0x0
    SessionAbortedError      : QNetworkSession.SessionError = ... # 0x1
    RoamingError             : QNetworkSession.SessionError = ... # 0x2
    OperationNotSupportedError: QNetworkSession.SessionError = ... # 0x3
    InvalidConfigurationError: QNetworkSession.SessionError = ... # 0x4
    Invalid                  : QNetworkSession.State = ... # 0x0
    NotAvailable             : QNetworkSession.State = ... # 0x1
    Connecting               : QNetworkSession.State = ... # 0x2
    Connected                : QNetworkSession.State = ... # 0x3
    Closing                  : QNetworkSession.State = ... # 0x4
    Disconnected             : QNetworkSession.State = ... # 0x5
    Roaming                  : QNetworkSession.State = ... # 0x6
    NoPolicy                 : QNetworkSession.UsagePolicy = ... # 0x0
    NoBackgroundTrafficPolicy: QNetworkSession.UsagePolicy = ... # 0x1

    class SessionError(Shiboken.Enum):
        UnknownSessionError      : QNetworkSession.SessionError = ... # 0x0
        SessionAbortedError      : QNetworkSession.SessionError = ... # 0x1
        RoamingError             : QNetworkSession.SessionError = ... # 0x2
        OperationNotSupportedError: QNetworkSession.SessionError = ... # 0x3
        InvalidConfigurationError: QNetworkSession.SessionError = ... # 0x4

    class State(Shiboken.Enum):
        Invalid                  : QNetworkSession.State = ... # 0x0
        NotAvailable             : QNetworkSession.State = ... # 0x1
        Connecting               : QNetworkSession.State = ... # 0x2
        Connected                : QNetworkSession.State = ... # 0x3
        Closing                  : QNetworkSession.State = ... # 0x4
        Disconnected             : QNetworkSession.State = ... # 0x5
        Roaming                  : QNetworkSession.State = ... # 0x6

    class UsagePolicies(object): ...

    class UsagePolicy(Shiboken.Enum):
        NoPolicy                 : QNetworkSession.UsagePolicy = ... # 0x0
        NoBackgroundTrafficPolicy: QNetworkSession.UsagePolicy = ... # 0x1

    def __init__(self, connConfig: PySide2.QtNetwork.QNetworkConfiguration, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QOcspCertificateStatus(Shiboken.Enum):
    Good                     : QOcspCertificateStatus = ... # 0x0
    Revoked                  : QOcspCertificateStatus = ... # 0x1
    Unknown                  : QOcspCertificateStatus = ... # 0x2


class QOcspResponse(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QOcspResponse) -> None: ...


class QOcspRevocationReason(Shiboken.Enum):
    None_                    : QOcspRevocationReason = ... # -0x1
    Unspecified              : QOcspRevocationReason = ... # 0x0
    KeyCompromise            : QOcspRevocationReason = ... # 0x1
    CACompromise             : QOcspRevocationReason = ... # 0x2
    AffiliationChanged       : QOcspRevocationReason = ... # 0x3
    Superseded               : QOcspRevocationReason = ... # 0x4
    CessationOfOperation     : QOcspRevocationReason = ... # 0x5
    CertificateHold          : QOcspRevocationReason = ... # 0x6
    RemoveFromCRL            : QOcspRevocationReason = ... # 0x7


class QPasswordDigestor(Shiboken.Object): ...


class QSsl(Shiboken.Object):
    EmailEntry               : QSsl.AlternativeNameEntryType = ... # 0x0
    DnsEntry                 : QSsl.AlternativeNameEntryType = ... # 0x1
    IpAddressEntry           : QSsl.AlternativeNameEntryType = ... # 0x2
    Pem                      : QSsl.EncodingFormat = ... # 0x0
    Der                      : QSsl.EncodingFormat = ... # 0x1
    Opaque                   : QSsl.KeyAlgorithm = ... # 0x0
    Rsa                      : QSsl.KeyAlgorithm = ... # 0x1
    Dsa                      : QSsl.KeyAlgorithm = ... # 0x2
    Ec                       : QSsl.KeyAlgorithm = ... # 0x3
    Dh                       : QSsl.KeyAlgorithm = ... # 0x4
    PrivateKey               : QSsl.KeyType = ... # 0x0
    PublicKey                : QSsl.KeyType = ... # 0x1
    SslOptionDisableEmptyFragments: QSsl.SslOption = ... # 0x1
    SslOptionDisableSessionTickets: QSsl.SslOption = ... # 0x2
    SslOptionDisableCompression: QSsl.SslOption = ... # 0x4
    SslOptionDisableServerNameIndication: QSsl.SslOption = ... # 0x8
    SslOptionDisableLegacyRenegotiation: QSsl.SslOption = ... # 0x10
    SslOptionDisableSessionSharing: QSsl.SslOption = ... # 0x20
    SslOptionDisableSessionPersistence: QSsl.SslOption = ... # 0x40
    SslOptionDisableServerCipherPreference: QSsl.SslOption = ... # 0x80
    UnknownProtocol          : QSsl.SslProtocol = ... # -0x1
    SslV3                    : QSsl.SslProtocol = ... # 0x0
    SslV2                    : QSsl.SslProtocol = ... # 0x1
    TlsV1_0                  : QSsl.SslProtocol = ... # 0x2
    TlsV1_1                  : QSsl.SslProtocol = ... # 0x3
    TlsV1_2                  : QSsl.SslProtocol = ... # 0x4
    AnyProtocol              : QSsl.SslProtocol = ... # 0x5
    TlsV1SslV3               : QSsl.SslProtocol = ... # 0x6
    SecureProtocols          : QSsl.SslProtocol = ... # 0x7
    TlsV1_0OrLater           : QSsl.SslProtocol = ... # 0x8
    TlsV1_1OrLater           : QSsl.SslProtocol = ... # 0x9
    TlsV1_2OrLater           : QSsl.SslProtocol = ... # 0xa
    DtlsV1_0                 : QSsl.SslProtocol = ... # 0xb
    DtlsV1_0OrLater          : QSsl.SslProtocol = ... # 0xc
    DtlsV1_2                 : QSsl.SslProtocol = ... # 0xd
    DtlsV1_2OrLater          : QSsl.SslProtocol = ... # 0xe
    TlsV1_3                  : QSsl.SslProtocol = ... # 0xf
    TlsV1_3OrLater           : QSsl.SslProtocol = ... # 0x10

    class AlternativeNameEntryType(Shiboken.Enum):
        EmailEntry               : QSsl.AlternativeNameEntryType = ... # 0x0
        DnsEntry                 : QSsl.AlternativeNameEntryType = ... # 0x1
        IpAddressEntry           : QSsl.AlternativeNameEntryType = ... # 0x2

    class EncodingFormat(Shiboken.Enum):
        Pem                      : QSsl.EncodingFormat = ... # 0x0
        Der                      : QSsl.EncodingFormat = ... # 0x1

    class KeyAlgorithm(Shiboken.Enum):
        Opaque                   : QSsl.KeyAlgorithm = ... # 0x0
        Rsa                      : QSsl.KeyAlgorithm = ... # 0x1
        Dsa                      : QSsl.KeyAlgorithm = ... # 0x2
        Ec                       : QSsl.KeyAlgorithm = ... # 0x3
        Dh                       : QSsl.KeyAlgorithm = ... # 0x4

    class KeyType(Shiboken.Enum):
        PrivateKey               : QSsl.KeyType = ... # 0x0
        PublicKey                : QSsl.KeyType = ... # 0x1

    class SslOption(Shiboken.Enum):
        SslOptionDisableEmptyFragments: QSsl.SslOption = ... # 0x1
        SslOptionDisableSessionTickets: QSsl.SslOption = ... # 0x2
        SslOptionDisableCompression: QSsl.SslOption = ... # 0x4
        SslOptionDisableServerNameIndication: QSsl.SslOption = ... # 0x8
        SslOptionDisableLegacyRenegotiation: QSsl.SslOption = ... # 0x10
        SslOptionDisableSessionSharing: QSsl.SslOption = ... # 0x20
        SslOptionDisableSessionPersistence: QSsl.SslOption = ... # 0x40
        SslOptionDisableServerCipherPreference: QSsl.SslOption = ... # 0x80

    class SslOptions(object): ...

    class SslProtocol(Shiboken.Enum):
        UnknownProtocol          : QSsl.SslProtocol = ... # -0x1
        SslV3                    : QSsl.SslProtocol = ... # 0x0
        SslV2                    : QSsl.SslProtocol = ... # 0x1
        TlsV1_0                  : QSsl.SslProtocol = ... # 0x2
        TlsV1_1                  : QSsl.SslProtocol = ... # 0x3
        TlsV1_2                  : QSsl.SslProtocol = ... # 0x4
        AnyProtocol              : QSsl.SslProtocol = ... # 0x5
        TlsV1SslV3               : QSsl.SslProtocol = ... # 0x6
        SecureProtocols          : QSsl.SslProtocol = ... # 0x7
        TlsV1_0OrLater           : QSsl.SslProtocol = ... # 0x8
        TlsV1_1OrLater           : QSsl.SslProtocol = ... # 0x9
        TlsV1_2OrLater           : QSsl.SslProtocol = ... # 0xa
        DtlsV1_0                 : QSsl.SslProtocol = ... # 0xb
        DtlsV1_0OrLater          : QSsl.SslProtocol = ... # 0xc
        DtlsV1_2                 : QSsl.SslProtocol = ... # 0xd
        DtlsV1_2OrLater          : QSsl.SslProtocol = ... # 0xe
        TlsV1_3                  : QSsl.SslProtocol = ... # 0xf
        TlsV1_3OrLater           : QSsl.SslProtocol = ... # 0x10


class QSslCertificate(Shiboken.Object):
    Organization             : QSslCertificate.SubjectInfo = ... # 0x0
    CommonName               : QSslCertificate.SubjectInfo = ... # 0x1
    LocalityName             : QSslCertificate.SubjectInfo = ... # 0x2
    OrganizationalUnitName   : QSslCertificate.SubjectInfo = ... # 0x3
    CountryName              : QSslCertificate.SubjectInfo = ... # 0x4
    StateOrProvinceName      : QSslCertificate.SubjectInfo = ... # 0x5
    DistinguishedNameQualifier: QSslCertificate.SubjectInfo = ... # 0x6
    SerialNumber             : QSslCertificate.SubjectInfo = ... # 0x7
    EmailAddress             : QSslCertificate.SubjectInfo = ... # 0x8

    class PatternSyntax(Shiboken.Enum):
        RegularExpression        : QSslCertificate.PatternSyntax = ... # 0x0
        Wildcard                 : QSslCertificate.PatternSyntax = ... # 0x1
        FixedString              : QSslCertificate.PatternSyntax = ... # 0x2

    class SubjectInfo(Shiboken.Enum):
        Organization             : QSslCertificate.SubjectInfo = ... # 0x0
        CommonName               : QSslCertificate.SubjectInfo = ... # 0x1
        LocalityName             : QSslCertificate.SubjectInfo = ... # 0x2
        OrganizationalUnitName   : QSslCertificate.SubjectInfo = ... # 0x3
        CountryName              : QSslCertificate.SubjectInfo = ... # 0x4
        StateOrProvinceName      : QSslCertificate.SubjectInfo = ... # 0x5
        DistinguishedNameQualifier: QSslCertificate.SubjectInfo = ... # 0x6
        SerialNumber             : QSslCertificate.SubjectInfo = ... # 0x7
        EmailAddress             : QSslCertificate.SubjectInfo = ... # 0x8

    @typing.overload
    def __init__(self, data: PySide2.QtCore.QByteArray = ..., format: PySide2.QtNetwork.QSsl.EncodingFormat = ...) -> None: ...
    @typing.overload
    def __init__(self, device: PySide2.QtCore.QIODevice, format: PySide2.QtNetwork.QSsl.EncodingFormat = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QSslCertificate) -> None: ...


class QSslCertificateExtension(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QSslCertificateExtension) -> None: ...


class QSslCipher(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, name: str) -> None: ...
    @typing.overload
    def __init__(self, name: str, protocol: PySide2.QtNetwork.QSsl.SslProtocol) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QSslCipher) -> None: ...


class QSslConfiguration(Shiboken.Object):
    NextProtocolNegotiationNone: QSslConfiguration.NextProtocolNegotiationStatus = ... # 0x0
    NextProtocolNegotiationNegotiated: QSslConfiguration.NextProtocolNegotiationStatus = ... # 0x1
    NextProtocolNegotiationUnsupported: QSslConfiguration.NextProtocolNegotiationStatus = ... # 0x2

    class NextProtocolNegotiationStatus(Shiboken.Enum):
        NextProtocolNegotiationNone: QSslConfiguration.NextProtocolNegotiationStatus = ... # 0x0
        NextProtocolNegotiationNegotiated: QSslConfiguration.NextProtocolNegotiationStatus = ... # 0x1
        NextProtocolNegotiationUnsupported: QSslConfiguration.NextProtocolNegotiationStatus = ... # 0x2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QSslConfiguration) -> None: ...


class QSslDiffieHellmanParameters(Shiboken.Object):
    NoError                  : QSslDiffieHellmanParameters.Error = ... # 0x0
    InvalidInputDataError    : QSslDiffieHellmanParameters.Error = ... # 0x1
    UnsafeParametersError    : QSslDiffieHellmanParameters.Error = ... # 0x2

    class Error(Shiboken.Enum):
        NoError                  : QSslDiffieHellmanParameters.Error = ... # 0x0
        InvalidInputDataError    : QSslDiffieHellmanParameters.Error = ... # 0x1
        UnsafeParametersError    : QSslDiffieHellmanParameters.Error = ... # 0x2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QSslDiffieHellmanParameters) -> None: ...


class QSslError(Shiboken.Object):
    UnspecifiedError         : QSslError.SslError = ... # -0x1
    NoError                  : QSslError.SslError = ... # 0x0
    UnableToGetIssuerCertificate: QSslError.SslError = ... # 0x1
    UnableToDecryptCertificateSignature: QSslError.SslError = ... # 0x2
    UnableToDecodeIssuerPublicKey: QSslError.SslError = ... # 0x3
    CertificateSignatureFailed: QSslError.SslError = ... # 0x4
    CertificateNotYetValid   : QSslError.SslError = ... # 0x5
    CertificateExpired       : QSslError.SslError = ... # 0x6
    InvalidNotBeforeField    : QSslError.SslError = ... # 0x7
    InvalidNotAfterField     : QSslError.SslError = ... # 0x8
    SelfSignedCertificate    : QSslError.SslError = ... # 0x9
    SelfSignedCertificateInChain: QSslError.SslError = ... # 0xa
    UnableToGetLocalIssuerCertificate: QSslError.SslError = ... # 0xb
    UnableToVerifyFirstCertificate: QSslError.SslError = ... # 0xc
    CertificateRevoked       : QSslError.SslError = ... # 0xd
    InvalidCaCertificate     : QSslError.SslError = ... # 0xe
    PathLengthExceeded       : QSslError.SslError = ... # 0xf
    InvalidPurpose           : QSslError.SslError = ... # 0x10
    CertificateUntrusted     : QSslError.SslError = ... # 0x11
    CertificateRejected      : QSslError.SslError = ... # 0x12
    SubjectIssuerMismatch    : QSslError.SslError = ... # 0x13
    AuthorityIssuerSerialNumberMismatch: QSslError.SslError = ... # 0x14
    NoPeerCertificate        : QSslError.SslError = ... # 0x15
    HostNameMismatch         : QSslError.SslError = ... # 0x16
    NoSslSupport             : QSslError.SslError = ... # 0x17
    CertificateBlacklisted   : QSslError.SslError = ... # 0x18
    CertificateStatusUnknown : QSslError.SslError = ... # 0x19
    OcspNoResponseFound      : QSslError.SslError = ... # 0x1a
    OcspMalformedRequest     : QSslError.SslError = ... # 0x1b
    OcspMalformedResponse    : QSslError.SslError = ... # 0x1c
    OcspInternalError        : QSslError.SslError = ... # 0x1d
    OcspTryLater             : QSslError.SslError = ... # 0x1e
    OcspSigRequred           : QSslError.SslError = ... # 0x1f
    OcspUnauthorized         : QSslError.SslError = ... # 0x20
    OcspResponseCannotBeTrusted: QSslError.SslError = ... # 0x21
    OcspResponseCertIdUnknown: QSslError.SslError = ... # 0x22
    OcspResponseExpired      : QSslError.SslError = ... # 0x23
    OcspStatusUnknown        : QSslError.SslError = ... # 0x24

    class SslError(Shiboken.Enum):
        UnspecifiedError         : QSslError.SslError = ... # -0x1
        NoError                  : QSslError.SslError = ... # 0x0
        UnableToGetIssuerCertificate: QSslError.SslError = ... # 0x1
        UnableToDecryptCertificateSignature: QSslError.SslError = ... # 0x2
        UnableToDecodeIssuerPublicKey: QSslError.SslError = ... # 0x3
        CertificateSignatureFailed: QSslError.SslError = ... # 0x4
        CertificateNotYetValid   : QSslError.SslError = ... # 0x5
        CertificateExpired       : QSslError.SslError = ... # 0x6
        InvalidNotBeforeField    : QSslError.SslError = ... # 0x7
        InvalidNotAfterField     : QSslError.SslError = ... # 0x8
        SelfSignedCertificate    : QSslError.SslError = ... # 0x9
        SelfSignedCertificateInChain: QSslError.SslError = ... # 0xa
        UnableToGetLocalIssuerCertificate: QSslError.SslError = ... # 0xb
        UnableToVerifyFirstCertificate: QSslError.SslError = ... # 0xc
        CertificateRevoked       : QSslError.SslError = ... # 0xd
        InvalidCaCertificate     : QSslError.SslError = ... # 0xe
        PathLengthExceeded       : QSslError.SslError = ... # 0xf
        InvalidPurpose           : QSslError.SslError = ... # 0x10
        CertificateUntrusted     : QSslError.SslError = ... # 0x11
        CertificateRejected      : QSslError.SslError = ... # 0x12
        SubjectIssuerMismatch    : QSslError.SslError = ... # 0x13
        AuthorityIssuerSerialNumberMismatch: QSslError.SslError = ... # 0x14
        NoPeerCertificate        : QSslError.SslError = ... # 0x15
        HostNameMismatch         : QSslError.SslError = ... # 0x16
        NoSslSupport             : QSslError.SslError = ... # 0x17
        CertificateBlacklisted   : QSslError.SslError = ... # 0x18
        CertificateStatusUnknown : QSslError.SslError = ... # 0x19
        OcspNoResponseFound      : QSslError.SslError = ... # 0x1a
        OcspMalformedRequest     : QSslError.SslError = ... # 0x1b
        OcspMalformedResponse    : QSslError.SslError = ... # 0x1c
        OcspInternalError        : QSslError.SslError = ... # 0x1d
        OcspTryLater             : QSslError.SslError = ... # 0x1e
        OcspSigRequred           : QSslError.SslError = ... # 0x1f
        OcspUnauthorized         : QSslError.SslError = ... # 0x20
        OcspResponseCannotBeTrusted: QSslError.SslError = ... # 0x21
        OcspResponseCertIdUnknown: QSslError.SslError = ... # 0x22
        OcspResponseExpired      : QSslError.SslError = ... # 0x23
        OcspStatusUnknown        : QSslError.SslError = ... # 0x24

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, error: PySide2.QtNetwork.QSslError.SslError) -> None: ...
    @typing.overload
    def __init__(self, error: PySide2.QtNetwork.QSslError.SslError, certificate: PySide2.QtNetwork.QSslCertificate) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QSslError) -> None: ...


class QSslKey(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, device: PySide2.QtCore.QIODevice, algorithm: PySide2.QtNetwork.QSsl.KeyAlgorithm, format: PySide2.QtNetwork.QSsl.EncodingFormat = ..., type: PySide2.QtNetwork.QSsl.KeyType = ..., passPhrase: PySide2.QtCore.QByteArray = ...) -> None: ...
    @typing.overload
    def __init__(self, encoded: PySide2.QtCore.QByteArray, algorithm: PySide2.QtNetwork.QSsl.KeyAlgorithm, format: PySide2.QtNetwork.QSsl.EncodingFormat = ..., type: PySide2.QtNetwork.QSsl.KeyType = ..., passPhrase: PySide2.QtCore.QByteArray = ...) -> None: ...
    @typing.overload
    def __init__(self, handle: int, type: PySide2.QtNetwork.QSsl.KeyType = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtNetwork.QSslKey) -> None: ...


class QSslPreSharedKeyAuthenticator(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, authenticator: PySide2.QtNetwork.QSslPreSharedKeyAuthenticator) -> None: ...


class QSslSocket(PySide2.QtNetwork.QTcpSocket):
    VerifyNone               : QSslSocket.PeerVerifyMode = ... # 0x0
    QueryPeer                : QSslSocket.PeerVerifyMode = ... # 0x1
    VerifyPeer               : QSslSocket.PeerVerifyMode = ... # 0x2
    AutoVerifyPeer           : QSslSocket.PeerVerifyMode = ... # 0x3
    UnencryptedMode          : QSslSocket.SslMode = ... # 0x0
    SslClientMode            : QSslSocket.SslMode = ... # 0x1
    SslServerMode            : QSslSocket.SslMode = ... # 0x2

    class PeerVerifyMode(Shiboken.Enum):
        VerifyNone               : QSslSocket.PeerVerifyMode = ... # 0x0
        QueryPeer                : QSslSocket.PeerVerifyMode = ... # 0x1
        VerifyPeer               : QSslSocket.PeerVerifyMode = ... # 0x2
        AutoVerifyPeer           : QSslSocket.PeerVerifyMode = ... # 0x3

    class SslMode(Shiboken.Enum):
        UnencryptedMode          : QSslSocket.SslMode = ... # 0x0
        SslClientMode            : QSslSocket.SslMode = ... # 0x1
        SslServerMode            : QSslSocket.SslMode = ... # 0x2

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QTcpServer(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QTcpSocket(PySide2.QtNetwork.QAbstractSocket):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QUdpSocket(PySide2.QtNetwork.QAbstractSocket):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


# eof
