#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtOpenGL, except for defaults which are replaced by "...".
"""

# Module PySide2.QtOpenGL
import PySide2
try:
    import typing
except ImportError:
    from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

from shiboken2 import Shiboken

import PySide2.QtCore
import PySide2.QtGui
import PySide2.QtWidgets
import PySide2.QtOpenGL


class QGL(Shiboken.Object):
    DoubleBuffer             : QGL.FormatOption = ... # 0x1
    DepthBuffer              : QGL.FormatOption = ... # 0x2
    Rgba                     : QGL.FormatOption = ... # 0x4
    AlphaChannel             : QGL.FormatOption = ... # 0x8
    AccumBuffer              : QGL.FormatOption = ... # 0x10
    StencilBuffer            : QGL.FormatOption = ... # 0x20
    StereoBuffers            : QGL.FormatOption = ... # 0x40
    DirectRendering          : QGL.FormatOption = ... # 0x80
    HasOverlay               : QGL.FormatOption = ... # 0x100
    SampleBuffers            : QGL.FormatOption = ... # 0x200
    DeprecatedFunctions      : QGL.FormatOption = ... # 0x400
    SingleBuffer             : QGL.FormatOption = ... # 0x10000
    NoDepthBuffer            : QGL.FormatOption = ... # 0x20000
    ColorIndex               : QGL.FormatOption = ... # 0x40000
    NoAlphaChannel           : QGL.FormatOption = ... # 0x80000
    NoAccumBuffer            : QGL.FormatOption = ... # 0x100000
    NoStencilBuffer          : QGL.FormatOption = ... # 0x200000
    NoStereoBuffers          : QGL.FormatOption = ... # 0x400000
    IndirectRendering        : QGL.FormatOption = ... # 0x800000
    NoOverlay                : QGL.FormatOption = ... # 0x1000000
    NoSampleBuffers          : QGL.FormatOption = ... # 0x2000000
    NoDeprecatedFunctions    : QGL.FormatOption = ... # 0x4000000

    class FormatOption(Shiboken.Enum):
        DoubleBuffer             : QGL.FormatOption = ... # 0x1
        DepthBuffer              : QGL.FormatOption = ... # 0x2
        Rgba                     : QGL.FormatOption = ... # 0x4
        AlphaChannel             : QGL.FormatOption = ... # 0x8
        AccumBuffer              : QGL.FormatOption = ... # 0x10
        StencilBuffer            : QGL.FormatOption = ... # 0x20
        StereoBuffers            : QGL.FormatOption = ... # 0x40
        DirectRendering          : QGL.FormatOption = ... # 0x80
        HasOverlay               : QGL.FormatOption = ... # 0x100
        SampleBuffers            : QGL.FormatOption = ... # 0x200
        DeprecatedFunctions      : QGL.FormatOption = ... # 0x400
        SingleBuffer             : QGL.FormatOption = ... # 0x10000
        NoDepthBuffer            : QGL.FormatOption = ... # 0x20000
        ColorIndex               : QGL.FormatOption = ... # 0x40000
        NoAlphaChannel           : QGL.FormatOption = ... # 0x80000
        NoAccumBuffer            : QGL.FormatOption = ... # 0x100000
        NoStencilBuffer          : QGL.FormatOption = ... # 0x200000
        NoStereoBuffers          : QGL.FormatOption = ... # 0x400000
        IndirectRendering        : QGL.FormatOption = ... # 0x800000
        NoOverlay                : QGL.FormatOption = ... # 0x1000000
        NoSampleBuffers          : QGL.FormatOption = ... # 0x2000000
        NoDeprecatedFunctions    : QGL.FormatOption = ... # 0x4000000

    class FormatOptions(object): ...


class QGLBuffer(Shiboken.Object):
    ReadOnly                 : QGLBuffer.Access = ... # 0x88b8
    WriteOnly                : QGLBuffer.Access = ... # 0x88b9
    ReadWrite                : QGLBuffer.Access = ... # 0x88ba
    VertexBuffer             : QGLBuffer.Type = ... # 0x8892
    IndexBuffer              : QGLBuffer.Type = ... # 0x8893
    PixelPackBuffer          : QGLBuffer.Type = ... # 0x88eb
    PixelUnpackBuffer        : QGLBuffer.Type = ... # 0x88ec
    StreamDraw               : QGLBuffer.UsagePattern = ... # 0x88e0
    StreamRead               : QGLBuffer.UsagePattern = ... # 0x88e1
    StreamCopy               : QGLBuffer.UsagePattern = ... # 0x88e2
    StaticDraw               : QGLBuffer.UsagePattern = ... # 0x88e4
    StaticRead               : QGLBuffer.UsagePattern = ... # 0x88e5
    StaticCopy               : QGLBuffer.UsagePattern = ... # 0x88e6
    DynamicDraw              : QGLBuffer.UsagePattern = ... # 0x88e8
    DynamicRead              : QGLBuffer.UsagePattern = ... # 0x88e9
    DynamicCopy              : QGLBuffer.UsagePattern = ... # 0x88ea

    class Access(Shiboken.Enum):
        ReadOnly                 : QGLBuffer.Access = ... # 0x88b8
        WriteOnly                : QGLBuffer.Access = ... # 0x88b9
        ReadWrite                : QGLBuffer.Access = ... # 0x88ba

    class Type(Shiboken.Enum):
        VertexBuffer             : QGLBuffer.Type = ... # 0x8892
        IndexBuffer              : QGLBuffer.Type = ... # 0x8893
        PixelPackBuffer          : QGLBuffer.Type = ... # 0x88eb
        PixelUnpackBuffer        : QGLBuffer.Type = ... # 0x88ec

    class UsagePattern(Shiboken.Enum):
        StreamDraw               : QGLBuffer.UsagePattern = ... # 0x88e0
        StreamRead               : QGLBuffer.UsagePattern = ... # 0x88e1
        StreamCopy               : QGLBuffer.UsagePattern = ... # 0x88e2
        StaticDraw               : QGLBuffer.UsagePattern = ... # 0x88e4
        StaticRead               : QGLBuffer.UsagePattern = ... # 0x88e5
        StaticCopy               : QGLBuffer.UsagePattern = ... # 0x88e6
        DynamicDraw              : QGLBuffer.UsagePattern = ... # 0x88e8
        DynamicRead              : QGLBuffer.UsagePattern = ... # 0x88e9
        DynamicCopy              : QGLBuffer.UsagePattern = ... # 0x88ea

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtOpenGL.QGLBuffer) -> None: ...
    @typing.overload
    def __init__(self, type: PySide2.QtOpenGL.QGLBuffer.Type) -> None: ...


class QGLColormap(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtOpenGL.QGLColormap) -> None: ...


class QGLContext(Shiboken.Object):
    NoBindOption             : QGLContext.BindOption = ... # 0x0
    InvertedYBindOption      : QGLContext.BindOption = ... # 0x1
    MipmapBindOption         : QGLContext.BindOption = ... # 0x2
    PremultipliedAlphaBindOption: QGLContext.BindOption = ... # 0x4
    LinearFilteringBindOption: QGLContext.BindOption = ... # 0x8
    DefaultBindOption        : QGLContext.BindOption = ... # 0xb
    MemoryManagedBindOption  : QGLContext.BindOption = ... # 0x10
    InternalBindOption       : QGLContext.BindOption = ... # 0x14
    CanFlipNativePixmapBindOption: QGLContext.BindOption = ... # 0x20
    TemporarilyCachedBindOption: QGLContext.BindOption = ... # 0x40

    class BindOption(Shiboken.Enum):
        NoBindOption             : QGLContext.BindOption = ... # 0x0
        InvertedYBindOption      : QGLContext.BindOption = ... # 0x1
        MipmapBindOption         : QGLContext.BindOption = ... # 0x2
        PremultipliedAlphaBindOption: QGLContext.BindOption = ... # 0x4
        LinearFilteringBindOption: QGLContext.BindOption = ... # 0x8
        DefaultBindOption        : QGLContext.BindOption = ... # 0xb
        MemoryManagedBindOption  : QGLContext.BindOption = ... # 0x10
        InternalBindOption       : QGLContext.BindOption = ... # 0x14
        CanFlipNativePixmapBindOption: QGLContext.BindOption = ... # 0x20
        TemporarilyCachedBindOption: QGLContext.BindOption = ... # 0x40

    class BindOptions(object): ...

    def __init__(self, format: PySide2.QtOpenGL.QGLFormat) -> None: ...


class QGLFormat(Shiboken.Object):
    NoProfile                : QGLFormat.OpenGLContextProfile = ... # 0x0
    CoreProfile              : QGLFormat.OpenGLContextProfile = ... # 0x1
    CompatibilityProfile     : QGLFormat.OpenGLContextProfile = ... # 0x2
    OpenGL_Version_None      : QGLFormat.OpenGLVersionFlag = ... # 0x0
    OpenGL_Version_1_1       : QGLFormat.OpenGLVersionFlag = ... # 0x1
    OpenGL_Version_1_2       : QGLFormat.OpenGLVersionFlag = ... # 0x2
    OpenGL_Version_1_3       : QGLFormat.OpenGLVersionFlag = ... # 0x4
    OpenGL_Version_1_4       : QGLFormat.OpenGLVersionFlag = ... # 0x8
    OpenGL_Version_1_5       : QGLFormat.OpenGLVersionFlag = ... # 0x10
    OpenGL_Version_2_0       : QGLFormat.OpenGLVersionFlag = ... # 0x20
    OpenGL_Version_2_1       : QGLFormat.OpenGLVersionFlag = ... # 0x40
    OpenGL_ES_Common_Version_1_0: QGLFormat.OpenGLVersionFlag = ... # 0x80
    OpenGL_ES_CommonLite_Version_1_0: QGLFormat.OpenGLVersionFlag = ... # 0x100
    OpenGL_ES_Common_Version_1_1: QGLFormat.OpenGLVersionFlag = ... # 0x200
    OpenGL_ES_CommonLite_Version_1_1: QGLFormat.OpenGLVersionFlag = ... # 0x400
    OpenGL_ES_Version_2_0    : QGLFormat.OpenGLVersionFlag = ... # 0x800
    OpenGL_Version_3_0       : QGLFormat.OpenGLVersionFlag = ... # 0x1000
    OpenGL_Version_3_1       : QGLFormat.OpenGLVersionFlag = ... # 0x2000
    OpenGL_Version_3_2       : QGLFormat.OpenGLVersionFlag = ... # 0x4000
    OpenGL_Version_3_3       : QGLFormat.OpenGLVersionFlag = ... # 0x8000
    OpenGL_Version_4_0       : QGLFormat.OpenGLVersionFlag = ... # 0x10000
    OpenGL_Version_4_1       : QGLFormat.OpenGLVersionFlag = ... # 0x20000
    OpenGL_Version_4_2       : QGLFormat.OpenGLVersionFlag = ... # 0x40000
    OpenGL_Version_4_3       : QGLFormat.OpenGLVersionFlag = ... # 0x80000

    class OpenGLContextProfile(Shiboken.Enum):
        NoProfile                : QGLFormat.OpenGLContextProfile = ... # 0x0
        CoreProfile              : QGLFormat.OpenGLContextProfile = ... # 0x1
        CompatibilityProfile     : QGLFormat.OpenGLContextProfile = ... # 0x2

    class OpenGLVersionFlag(Shiboken.Enum):
        OpenGL_Version_None      : QGLFormat.OpenGLVersionFlag = ... # 0x0
        OpenGL_Version_1_1       : QGLFormat.OpenGLVersionFlag = ... # 0x1
        OpenGL_Version_1_2       : QGLFormat.OpenGLVersionFlag = ... # 0x2
        OpenGL_Version_1_3       : QGLFormat.OpenGLVersionFlag = ... # 0x4
        OpenGL_Version_1_4       : QGLFormat.OpenGLVersionFlag = ... # 0x8
        OpenGL_Version_1_5       : QGLFormat.OpenGLVersionFlag = ... # 0x10
        OpenGL_Version_2_0       : QGLFormat.OpenGLVersionFlag = ... # 0x20
        OpenGL_Version_2_1       : QGLFormat.OpenGLVersionFlag = ... # 0x40
        OpenGL_ES_Common_Version_1_0: QGLFormat.OpenGLVersionFlag = ... # 0x80
        OpenGL_ES_CommonLite_Version_1_0: QGLFormat.OpenGLVersionFlag = ... # 0x100
        OpenGL_ES_Common_Version_1_1: QGLFormat.OpenGLVersionFlag = ... # 0x200
        OpenGL_ES_CommonLite_Version_1_1: QGLFormat.OpenGLVersionFlag = ... # 0x400
        OpenGL_ES_Version_2_0    : QGLFormat.OpenGLVersionFlag = ... # 0x800
        OpenGL_Version_3_0       : QGLFormat.OpenGLVersionFlag = ... # 0x1000
        OpenGL_Version_3_1       : QGLFormat.OpenGLVersionFlag = ... # 0x2000
        OpenGL_Version_3_2       : QGLFormat.OpenGLVersionFlag = ... # 0x4000
        OpenGL_Version_3_3       : QGLFormat.OpenGLVersionFlag = ... # 0x8000
        OpenGL_Version_4_0       : QGLFormat.OpenGLVersionFlag = ... # 0x10000
        OpenGL_Version_4_1       : QGLFormat.OpenGLVersionFlag = ... # 0x20000
        OpenGL_Version_4_2       : QGLFormat.OpenGLVersionFlag = ... # 0x40000
        OpenGL_Version_4_3       : QGLFormat.OpenGLVersionFlag = ... # 0x80000

    class OpenGLVersionFlags(object): ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, options: PySide2.QtOpenGL.QGL.FormatOptions, plane: int = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtOpenGL.QGLFormat) -> None: ...


class QGLFramebufferObject(PySide2.QtGui.QPaintDevice):
    NoAttachment             : QGLFramebufferObject.Attachment = ... # 0x0
    CombinedDepthStencil     : QGLFramebufferObject.Attachment = ... # 0x1
    Depth                    : QGLFramebufferObject.Attachment = ... # 0x2

    class Attachment(Shiboken.Enum):
        NoAttachment             : QGLFramebufferObject.Attachment = ... # 0x0
        CombinedDepthStencil     : QGLFramebufferObject.Attachment = ... # 0x1
        Depth                    : QGLFramebufferObject.Attachment = ... # 0x2

    @typing.overload
    def __init__(self, size: PySide2.QtCore.QSize, attachment: PySide2.QtOpenGL.QGLFramebufferObject.Attachment, target: int = ..., internal_format: int = ...) -> None: ...
    @typing.overload
    def __init__(self, size: PySide2.QtCore.QSize, format: PySide2.QtOpenGL.QGLFramebufferObjectFormat) -> None: ...
    @typing.overload
    def __init__(self, size: PySide2.QtCore.QSize, target: int = ...) -> None: ...
    @typing.overload
    def __init__(self, width: int, height: int, attachment: PySide2.QtOpenGL.QGLFramebufferObject.Attachment, target: int = ..., internal_format: int = ...) -> None: ...
    @typing.overload
    def __init__(self, width: int, height: int, format: PySide2.QtOpenGL.QGLFramebufferObjectFormat) -> None: ...
    @typing.overload
    def __init__(self, width: int, height: int, target: int = ...) -> None: ...


class QGLFramebufferObjectFormat(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtOpenGL.QGLFramebufferObjectFormat) -> None: ...


class QGLPixelBuffer(PySide2.QtGui.QPaintDevice):

    @typing.overload
    def __init__(self, size: PySide2.QtCore.QSize, format: PySide2.QtOpenGL.QGLFormat = ..., shareWidget: typing.Optional[PySide2.QtOpenGL.QGLWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, width: int, height: int, format: PySide2.QtOpenGL.QGLFormat = ..., shareWidget: typing.Optional[PySide2.QtOpenGL.QGLWidget] = ...) -> None: ...


class QGLShader(PySide2.QtCore.QObject):
    Vertex                   : QGLShader.ShaderTypeBit = ... # 0x1
    Fragment                 : QGLShader.ShaderTypeBit = ... # 0x2
    Geometry                 : QGLShader.ShaderTypeBit = ... # 0x4

    class ShaderType(object): ...

    class ShaderTypeBit(Shiboken.Enum):
        Vertex                   : QGLShader.ShaderTypeBit = ... # 0x1
        Fragment                 : QGLShader.ShaderTypeBit = ... # 0x2
        Geometry                 : QGLShader.ShaderTypeBit = ... # 0x4

    @typing.overload
    def __init__(self, type: PySide2.QtOpenGL.QGLShader.ShaderType, context: PySide2.QtOpenGL.QGLContext, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, type: PySide2.QtOpenGL.QGLShader.ShaderType, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QGLShaderProgram(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, context: PySide2.QtOpenGL.QGLContext, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QGLWidget(PySide2.QtWidgets.QWidget):

    @typing.overload
    def __init__(self, context: PySide2.QtOpenGL.QGLContext, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., shareWidget: typing.Optional[PySide2.QtOpenGL.QGLWidget] = ..., f: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...
    @typing.overload
    def __init__(self, format: PySide2.QtOpenGL.QGLFormat, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., shareWidget: typing.Optional[PySide2.QtOpenGL.QGLWidget] = ..., f: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., shareWidget: typing.Optional[PySide2.QtOpenGL.QGLWidget] = ..., f: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...


# eof
