#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtPrintSupport, except for defaults which are replaced by "...".
"""

# Module PySide2.QtPrintSupport
import PySide2
try:
    import typing
except ImportError:
    from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

from shiboken2 import Shiboken

import PySide2.QtCore
import PySide2.QtGui
import PySide2.QtWidgets
import PySide2.QtPrintSupport


class QAbstractPrintDialog(PySide2.QtWidgets.QDialog):
    None_                    : QAbstractPrintDialog.PrintDialogOption = ... # 0x0
    PrintToFile              : QAbstractPrintDialog.PrintDialogOption = ... # 0x1
    PrintSelection           : QAbstractPrintDialog.PrintDialogOption = ... # 0x2
    PrintPageRange           : QAbstractPrintDialog.PrintDialogOption = ... # 0x4
    PrintShowPageSize        : QAbstractPrintDialog.PrintDialogOption = ... # 0x8
    PrintCollateCopies       : QAbstractPrintDialog.PrintDialogOption = ... # 0x10
    DontUseSheet             : QAbstractPrintDialog.PrintDialogOption = ... # 0x20
    PrintCurrentPage         : QAbstractPrintDialog.PrintDialogOption = ... # 0x40
    AllPages                 : QAbstractPrintDialog.PrintRange = ... # 0x0
    Selection                : QAbstractPrintDialog.PrintRange = ... # 0x1
    PageRange                : QAbstractPrintDialog.PrintRange = ... # 0x2
    CurrentPage              : QAbstractPrintDialog.PrintRange = ... # 0x3

    class PrintDialogOption(Shiboken.Enum):
        None_                    : QAbstractPrintDialog.PrintDialogOption = ... # 0x0
        PrintToFile              : QAbstractPrintDialog.PrintDialogOption = ... # 0x1
        PrintSelection           : QAbstractPrintDialog.PrintDialogOption = ... # 0x2
        PrintPageRange           : QAbstractPrintDialog.PrintDialogOption = ... # 0x4
        PrintShowPageSize        : QAbstractPrintDialog.PrintDialogOption = ... # 0x8
        PrintCollateCopies       : QAbstractPrintDialog.PrintDialogOption = ... # 0x10
        DontUseSheet             : QAbstractPrintDialog.PrintDialogOption = ... # 0x20
        PrintCurrentPage         : QAbstractPrintDialog.PrintDialogOption = ... # 0x40

    class PrintDialogOptions(object): ...

    class PrintRange(Shiboken.Enum):
        AllPages                 : QAbstractPrintDialog.PrintRange = ... # 0x0
        Selection                : QAbstractPrintDialog.PrintRange = ... # 0x1
        PageRange                : QAbstractPrintDialog.PrintRange = ... # 0x2
        CurrentPage              : QAbstractPrintDialog.PrintRange = ... # 0x3

    def __init__(self, printer: PySide2.QtPrintSupport.QPrinter, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QPageSetupDialog(PySide2.QtWidgets.QDialog):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, printer: PySide2.QtPrintSupport.QPrinter, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QPrintDialog(PySide2.QtPrintSupport.QAbstractPrintDialog):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, printer: PySide2.QtPrintSupport.QPrinter, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QPrintEngine(Shiboken.Object):
    PPK_CollateCopies        : QPrintEngine.PrintEnginePropertyKey = ... # 0x0
    PPK_ColorMode            : QPrintEngine.PrintEnginePropertyKey = ... # 0x1
    PPK_Creator              : QPrintEngine.PrintEnginePropertyKey = ... # 0x2
    PPK_DocumentName         : QPrintEngine.PrintEnginePropertyKey = ... # 0x3
    PPK_FullPage             : QPrintEngine.PrintEnginePropertyKey = ... # 0x4
    PPK_NumberOfCopies       : QPrintEngine.PrintEnginePropertyKey = ... # 0x5
    PPK_Orientation          : QPrintEngine.PrintEnginePropertyKey = ... # 0x6
    PPK_OutputFileName       : QPrintEngine.PrintEnginePropertyKey = ... # 0x7
    PPK_PageOrder            : QPrintEngine.PrintEnginePropertyKey = ... # 0x8
    PPK_PageRect             : QPrintEngine.PrintEnginePropertyKey = ... # 0x9
    PPK_PageSize             : QPrintEngine.PrintEnginePropertyKey = ... # 0xa
    PPK_PaperSize            : QPrintEngine.PrintEnginePropertyKey = ... # 0xa
    PPK_PaperRect            : QPrintEngine.PrintEnginePropertyKey = ... # 0xb
    PPK_PaperSource          : QPrintEngine.PrintEnginePropertyKey = ... # 0xc
    PPK_PrinterName          : QPrintEngine.PrintEnginePropertyKey = ... # 0xd
    PPK_PrinterProgram       : QPrintEngine.PrintEnginePropertyKey = ... # 0xe
    PPK_Resolution           : QPrintEngine.PrintEnginePropertyKey = ... # 0xf
    PPK_SelectionOption      : QPrintEngine.PrintEnginePropertyKey = ... # 0x10
    PPK_SupportedResolutions : QPrintEngine.PrintEnginePropertyKey = ... # 0x11
    PPK_WindowsPageSize      : QPrintEngine.PrintEnginePropertyKey = ... # 0x12
    PPK_FontEmbedding        : QPrintEngine.PrintEnginePropertyKey = ... # 0x13
    PPK_Duplex               : QPrintEngine.PrintEnginePropertyKey = ... # 0x14
    PPK_PaperSources         : QPrintEngine.PrintEnginePropertyKey = ... # 0x15
    PPK_CustomPaperSize      : QPrintEngine.PrintEnginePropertyKey = ... # 0x16
    PPK_PageMargins          : QPrintEngine.PrintEnginePropertyKey = ... # 0x17
    PPK_CopyCount            : QPrintEngine.PrintEnginePropertyKey = ... # 0x18
    PPK_SupportsMultipleCopies: QPrintEngine.PrintEnginePropertyKey = ... # 0x19
    PPK_PaperName            : QPrintEngine.PrintEnginePropertyKey = ... # 0x1a
    PPK_QPageSize            : QPrintEngine.PrintEnginePropertyKey = ... # 0x1b
    PPK_QPageMargins         : QPrintEngine.PrintEnginePropertyKey = ... # 0x1c
    PPK_QPageLayout          : QPrintEngine.PrintEnginePropertyKey = ... # 0x1d
    PPK_CustomBase           : QPrintEngine.PrintEnginePropertyKey = ... # 0xff00

    class PrintEnginePropertyKey(Shiboken.Enum):
        PPK_CollateCopies        : QPrintEngine.PrintEnginePropertyKey = ... # 0x0
        PPK_ColorMode            : QPrintEngine.PrintEnginePropertyKey = ... # 0x1
        PPK_Creator              : QPrintEngine.PrintEnginePropertyKey = ... # 0x2
        PPK_DocumentName         : QPrintEngine.PrintEnginePropertyKey = ... # 0x3
        PPK_FullPage             : QPrintEngine.PrintEnginePropertyKey = ... # 0x4
        PPK_NumberOfCopies       : QPrintEngine.PrintEnginePropertyKey = ... # 0x5
        PPK_Orientation          : QPrintEngine.PrintEnginePropertyKey = ... # 0x6
        PPK_OutputFileName       : QPrintEngine.PrintEnginePropertyKey = ... # 0x7
        PPK_PageOrder            : QPrintEngine.PrintEnginePropertyKey = ... # 0x8
        PPK_PageRect             : QPrintEngine.PrintEnginePropertyKey = ... # 0x9
        PPK_PageSize             : QPrintEngine.PrintEnginePropertyKey = ... # 0xa
        PPK_PaperSize            : QPrintEngine.PrintEnginePropertyKey = ... # 0xa
        PPK_PaperRect            : QPrintEngine.PrintEnginePropertyKey = ... # 0xb
        PPK_PaperSource          : QPrintEngine.PrintEnginePropertyKey = ... # 0xc
        PPK_PrinterName          : QPrintEngine.PrintEnginePropertyKey = ... # 0xd
        PPK_PrinterProgram       : QPrintEngine.PrintEnginePropertyKey = ... # 0xe
        PPK_Resolution           : QPrintEngine.PrintEnginePropertyKey = ... # 0xf
        PPK_SelectionOption      : QPrintEngine.PrintEnginePropertyKey = ... # 0x10
        PPK_SupportedResolutions : QPrintEngine.PrintEnginePropertyKey = ... # 0x11
        PPK_WindowsPageSize      : QPrintEngine.PrintEnginePropertyKey = ... # 0x12
        PPK_FontEmbedding        : QPrintEngine.PrintEnginePropertyKey = ... # 0x13
        PPK_Duplex               : QPrintEngine.PrintEnginePropertyKey = ... # 0x14
        PPK_PaperSources         : QPrintEngine.PrintEnginePropertyKey = ... # 0x15
        PPK_CustomPaperSize      : QPrintEngine.PrintEnginePropertyKey = ... # 0x16
        PPK_PageMargins          : QPrintEngine.PrintEnginePropertyKey = ... # 0x17
        PPK_CopyCount            : QPrintEngine.PrintEnginePropertyKey = ... # 0x18
        PPK_SupportsMultipleCopies: QPrintEngine.PrintEnginePropertyKey = ... # 0x19
        PPK_PaperName            : QPrintEngine.PrintEnginePropertyKey = ... # 0x1a
        PPK_QPageSize            : QPrintEngine.PrintEnginePropertyKey = ... # 0x1b
        PPK_QPageMargins         : QPrintEngine.PrintEnginePropertyKey = ... # 0x1c
        PPK_QPageLayout          : QPrintEngine.PrintEnginePropertyKey = ... # 0x1d
        PPK_CustomBase           : QPrintEngine.PrintEnginePropertyKey = ... # 0xff00

    def __init__(self) -> None: ...


class QPrintPreviewDialog(PySide2.QtWidgets.QDialog):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...
    @typing.overload
    def __init__(self, printer: PySide2.QtPrintSupport.QPrinter, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...


class QPrintPreviewWidget(PySide2.QtWidgets.QWidget):
    SinglePageView           : QPrintPreviewWidget.ViewMode = ... # 0x0
    FacingPagesView          : QPrintPreviewWidget.ViewMode = ... # 0x1
    AllPagesView             : QPrintPreviewWidget.ViewMode = ... # 0x2
    CustomZoom               : QPrintPreviewWidget.ZoomMode = ... # 0x0
    FitToWidth               : QPrintPreviewWidget.ZoomMode = ... # 0x1
    FitInView                : QPrintPreviewWidget.ZoomMode = ... # 0x2

    class ViewMode(Shiboken.Enum):
        SinglePageView           : QPrintPreviewWidget.ViewMode = ... # 0x0
        FacingPagesView          : QPrintPreviewWidget.ViewMode = ... # 0x1
        AllPagesView             : QPrintPreviewWidget.ViewMode = ... # 0x2

    class ZoomMode(Shiboken.Enum):
        CustomZoom               : QPrintPreviewWidget.ZoomMode = ... # 0x0
        FitToWidth               : QPrintPreviewWidget.ZoomMode = ... # 0x1
        FitInView                : QPrintPreviewWidget.ZoomMode = ... # 0x2

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...
    @typing.overload
    def __init__(self, printer: PySide2.QtPrintSupport.QPrinter, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...


class QPrinter(PySide2.QtGui.QPagedPaintDevice):
    GrayScale                : QPrinter.ColorMode = ... # 0x0
    Color                    : QPrinter.ColorMode = ... # 0x1
    DuplexNone               : QPrinter.DuplexMode = ... # 0x0
    DuplexAuto               : QPrinter.DuplexMode = ... # 0x1
    DuplexLongSide           : QPrinter.DuplexMode = ... # 0x2
    DuplexShortSide          : QPrinter.DuplexMode = ... # 0x3
    Portrait                 : QPrinter.Orientation = ... # 0x0
    Landscape                : QPrinter.Orientation = ... # 0x1
    NativeFormat             : QPrinter.OutputFormat = ... # 0x0
    PdfFormat                : QPrinter.OutputFormat = ... # 0x1
    FirstPageFirst           : QPrinter.PageOrder = ... # 0x0
    LastPageFirst            : QPrinter.PageOrder = ... # 0x1
    OnlyOne                  : QPrinter.PaperSource = ... # 0x0
    Upper                    : QPrinter.PaperSource = ... # 0x0
    Lower                    : QPrinter.PaperSource = ... # 0x1
    Middle                   : QPrinter.PaperSource = ... # 0x2
    Manual                   : QPrinter.PaperSource = ... # 0x3
    Envelope                 : QPrinter.PaperSource = ... # 0x4
    EnvelopeManual           : QPrinter.PaperSource = ... # 0x5
    Auto                     : QPrinter.PaperSource = ... # 0x6
    Tractor                  : QPrinter.PaperSource = ... # 0x7
    SmallFormat              : QPrinter.PaperSource = ... # 0x8
    LargeFormat              : QPrinter.PaperSource = ... # 0x9
    LargeCapacity            : QPrinter.PaperSource = ... # 0xa
    Cassette                 : QPrinter.PaperSource = ... # 0xb
    FormSource               : QPrinter.PaperSource = ... # 0xc
    MaxPageSource            : QPrinter.PaperSource = ... # 0xd
    CustomSource             : QPrinter.PaperSource = ... # 0xe
    LastPaperSource          : QPrinter.PaperSource = ... # 0xe
    AllPages                 : QPrinter.PrintRange = ... # 0x0
    Selection                : QPrinter.PrintRange = ... # 0x1
    PageRange                : QPrinter.PrintRange = ... # 0x2
    CurrentPage              : QPrinter.PrintRange = ... # 0x3
    ScreenResolution         : QPrinter.PrinterMode = ... # 0x0
    PrinterResolution        : QPrinter.PrinterMode = ... # 0x1
    HighResolution           : QPrinter.PrinterMode = ... # 0x2
    Idle                     : QPrinter.PrinterState = ... # 0x0
    Active                   : QPrinter.PrinterState = ... # 0x1
    Aborted                  : QPrinter.PrinterState = ... # 0x2
    Error                    : QPrinter.PrinterState = ... # 0x3
    Millimeter               : QPrinter.Unit = ... # 0x0
    Point                    : QPrinter.Unit = ... # 0x1
    Inch                     : QPrinter.Unit = ... # 0x2
    Pica                     : QPrinter.Unit = ... # 0x3
    Didot                    : QPrinter.Unit = ... # 0x4
    Cicero                   : QPrinter.Unit = ... # 0x5
    DevicePixel              : QPrinter.Unit = ... # 0x6

    class ColorMode(Shiboken.Enum):
        GrayScale                : QPrinter.ColorMode = ... # 0x0
        Color                    : QPrinter.ColorMode = ... # 0x1

    class DuplexMode(Shiboken.Enum):
        DuplexNone               : QPrinter.DuplexMode = ... # 0x0
        DuplexAuto               : QPrinter.DuplexMode = ... # 0x1
        DuplexLongSide           : QPrinter.DuplexMode = ... # 0x2
        DuplexShortSide          : QPrinter.DuplexMode = ... # 0x3

    class Orientation(Shiboken.Enum):
        Portrait                 : QPrinter.Orientation = ... # 0x0
        Landscape                : QPrinter.Orientation = ... # 0x1

    class OutputFormat(Shiboken.Enum):
        NativeFormat             : QPrinter.OutputFormat = ... # 0x0
        PdfFormat                : QPrinter.OutputFormat = ... # 0x1

    class PageOrder(Shiboken.Enum):
        FirstPageFirst           : QPrinter.PageOrder = ... # 0x0
        LastPageFirst            : QPrinter.PageOrder = ... # 0x1

    class PaperSource(Shiboken.Enum):
        OnlyOne                  : QPrinter.PaperSource = ... # 0x0
        Upper                    : QPrinter.PaperSource = ... # 0x0
        Lower                    : QPrinter.PaperSource = ... # 0x1
        Middle                   : QPrinter.PaperSource = ... # 0x2
        Manual                   : QPrinter.PaperSource = ... # 0x3
        Envelope                 : QPrinter.PaperSource = ... # 0x4
        EnvelopeManual           : QPrinter.PaperSource = ... # 0x5
        Auto                     : QPrinter.PaperSource = ... # 0x6
        Tractor                  : QPrinter.PaperSource = ... # 0x7
        SmallFormat              : QPrinter.PaperSource = ... # 0x8
        LargeFormat              : QPrinter.PaperSource = ... # 0x9
        LargeCapacity            : QPrinter.PaperSource = ... # 0xa
        Cassette                 : QPrinter.PaperSource = ... # 0xb
        FormSource               : QPrinter.PaperSource = ... # 0xc
        MaxPageSource            : QPrinter.PaperSource = ... # 0xd
        CustomSource             : QPrinter.PaperSource = ... # 0xe
        LastPaperSource          : QPrinter.PaperSource = ... # 0xe

    class PrintRange(Shiboken.Enum):
        AllPages                 : QPrinter.PrintRange = ... # 0x0
        Selection                : QPrinter.PrintRange = ... # 0x1
        PageRange                : QPrinter.PrintRange = ... # 0x2
        CurrentPage              : QPrinter.PrintRange = ... # 0x3

    class PrinterMode(Shiboken.Enum):
        ScreenResolution         : QPrinter.PrinterMode = ... # 0x0
        PrinterResolution        : QPrinter.PrinterMode = ... # 0x1
        HighResolution           : QPrinter.PrinterMode = ... # 0x2

    class PrinterState(Shiboken.Enum):
        Idle                     : QPrinter.PrinterState = ... # 0x0
        Active                   : QPrinter.PrinterState = ... # 0x1
        Aborted                  : QPrinter.PrinterState = ... # 0x2
        Error                    : QPrinter.PrinterState = ... # 0x3

    class Unit(Shiboken.Enum):
        Millimeter               : QPrinter.Unit = ... # 0x0
        Point                    : QPrinter.Unit = ... # 0x1
        Inch                     : QPrinter.Unit = ... # 0x2
        Pica                     : QPrinter.Unit = ... # 0x3
        Didot                    : QPrinter.Unit = ... # 0x4
        Cicero                   : QPrinter.Unit = ... # 0x5
        DevicePixel              : QPrinter.Unit = ... # 0x6

    @typing.overload
    def __init__(self, mode: PySide2.QtPrintSupport.QPrinter.PrinterMode = ...) -> None: ...
    @typing.overload
    def __init__(self, printer: PySide2.QtPrintSupport.QPrinterInfo, mode: PySide2.QtPrintSupport.QPrinter.PrinterMode = ...) -> None: ...


class QPrinterInfo(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtPrintSupport.QPrinterInfo) -> None: ...
    @typing.overload
    def __init__(self, printer: PySide2.QtPrintSupport.QPrinter) -> None: ...


# eof
