#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtRemoteObjects, except for defaults which are replaced by "...".
"""

# Module PySide2.QtRemoteObjects
import PySide2
try:
    import typing
except ImportError:
    from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

from shiboken2 import Shiboken

import PySide2.QtCore
import PySide2.QtRemoteObjects


class QAbstractItemModelReplica(PySide2.QtCore.QAbstractItemModel): ...


class QRemoteObjectAbstractPersistedStore(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QRemoteObjectDynamicReplica(PySide2.QtRemoteObjects.QRemoteObjectReplica): ...


class QRemoteObjectHost(PySide2.QtRemoteObjects.QRemoteObjectHostBase):

    @typing.overload
    def __init__(self, address: PySide2.QtCore.QUrl, parent: PySide2.QtCore.QObject) -> None: ...
    @typing.overload
    def __init__(self, address: PySide2.QtCore.QUrl, registryAddress: PySide2.QtCore.QUrl = ..., allowedSchemas: PySide2.QtRemoteObjects.QRemoteObjectHostBase.AllowedSchemas = ..., parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QRemoteObjectHostBase(PySide2.QtRemoteObjects.QRemoteObjectNode):
    BuiltInSchemasOnly       : QRemoteObjectHostBase.AllowedSchemas = ... # 0x0
    AllowExternalRegistration: QRemoteObjectHostBase.AllowedSchemas = ... # 0x1

    class AllowedSchemas(Shiboken.Enum):
        BuiltInSchemasOnly       : QRemoteObjectHostBase.AllowedSchemas = ... # 0x0
        AllowExternalRegistration: QRemoteObjectHostBase.AllowedSchemas = ... # 0x1


class QRemoteObjectNode(PySide2.QtCore.QObject):
    NoError                  : QRemoteObjectNode.ErrorCode = ... # 0x0
    RegistryNotAcquired      : QRemoteObjectNode.ErrorCode = ... # 0x1
    RegistryAlreadyHosted    : QRemoteObjectNode.ErrorCode = ... # 0x2
    NodeIsNoServer           : QRemoteObjectNode.ErrorCode = ... # 0x3
    ServerAlreadyCreated     : QRemoteObjectNode.ErrorCode = ... # 0x4
    UnintendedRegistryHosting: QRemoteObjectNode.ErrorCode = ... # 0x5
    OperationNotValidOnClientNode: QRemoteObjectNode.ErrorCode = ... # 0x6
    SourceNotRegistered      : QRemoteObjectNode.ErrorCode = ... # 0x7
    MissingObjectName        : QRemoteObjectNode.ErrorCode = ... # 0x8
    HostUrlInvalid           : QRemoteObjectNode.ErrorCode = ... # 0x9
    ProtocolMismatch         : QRemoteObjectNode.ErrorCode = ... # 0xa
    ListenFailed             : QRemoteObjectNode.ErrorCode = ... # 0xb

    class ErrorCode(Shiboken.Enum):
        NoError                  : QRemoteObjectNode.ErrorCode = ... # 0x0
        RegistryNotAcquired      : QRemoteObjectNode.ErrorCode = ... # 0x1
        RegistryAlreadyHosted    : QRemoteObjectNode.ErrorCode = ... # 0x2
        NodeIsNoServer           : QRemoteObjectNode.ErrorCode = ... # 0x3
        ServerAlreadyCreated     : QRemoteObjectNode.ErrorCode = ... # 0x4
        UnintendedRegistryHosting: QRemoteObjectNode.ErrorCode = ... # 0x5
        OperationNotValidOnClientNode: QRemoteObjectNode.ErrorCode = ... # 0x6
        SourceNotRegistered      : QRemoteObjectNode.ErrorCode = ... # 0x7
        MissingObjectName        : QRemoteObjectNode.ErrorCode = ... # 0x8
        HostUrlInvalid           : QRemoteObjectNode.ErrorCode = ... # 0x9
        ProtocolMismatch         : QRemoteObjectNode.ErrorCode = ... # 0xa
        ListenFailed             : QRemoteObjectNode.ErrorCode = ... # 0xb

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, registryAddress: PySide2.QtCore.QUrl, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QRemoteObjectPendingCall(Shiboken.Object):
    NoError                  : QRemoteObjectPendingCall.Error = ... # 0x0
    InvalidMessage           : QRemoteObjectPendingCall.Error = ... # 0x1

    class Error(Shiboken.Enum):
        NoError                  : QRemoteObjectPendingCall.Error = ... # 0x0
        InvalidMessage           : QRemoteObjectPendingCall.Error = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtRemoteObjects.QRemoteObjectPendingCall) -> None: ...


class QRemoteObjectPendingCallWatcher(PySide2.QtCore.QObject, PySide2.QtRemoteObjects.QRemoteObjectPendingCall):

    def __init__(self, call: PySide2.QtRemoteObjects.QRemoteObjectPendingCall, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QRemoteObjectRegistry(PySide2.QtRemoteObjects.QRemoteObjectReplica): ...


class QRemoteObjectRegistryHost(PySide2.QtRemoteObjects.QRemoteObjectHostBase):

    def __init__(self, registryAddress: PySide2.QtCore.QUrl = ..., parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QRemoteObjectReplica(PySide2.QtCore.QObject):
    Uninitialized            : QRemoteObjectReplica.State = ... # 0x0
    Default                  : QRemoteObjectReplica.State = ... # 0x1
    Valid                    : QRemoteObjectReplica.State = ... # 0x2
    Suspect                  : QRemoteObjectReplica.State = ... # 0x3
    SignatureMismatch        : QRemoteObjectReplica.State = ... # 0x4

    class State(Shiboken.Enum):
        Uninitialized            : QRemoteObjectReplica.State = ... # 0x0
        Default                  : QRemoteObjectReplica.State = ... # 0x1
        Valid                    : QRemoteObjectReplica.State = ... # 0x2
        Suspect                  : QRemoteObjectReplica.State = ... # 0x3
        SignatureMismatch        : QRemoteObjectReplica.State = ... # 0x4

    def __init__(self) -> None: ...


class QRemoteObjectSettingsStore(PySide2.QtRemoteObjects.QRemoteObjectAbstractPersistedStore):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QRemoteObjectSourceLocationInfo(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QRemoteObjectSourceLocationInfo: PySide2.QtRemoteObjects.QRemoteObjectSourceLocationInfo) -> None: ...
    @typing.overload
    def __init__(self, typeName_: str, hostUrl_: PySide2.QtCore.QUrl) -> None: ...


# eof
