#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtSql, except for defaults which are replaced by "...".
"""

# Module PySide2.QtSql
import PySide2
try:
    import typing
except ImportError:
    from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

from shiboken2 import Shiboken

import PySide2.QtCore
import PySide2.QtWidgets
import PySide2.QtSql


class QSql(Shiboken.Object):
    AfterLastRow             : QSql.Location = ... # -0x2
    BeforeFirstRow           : QSql.Location = ... # -0x1
    HighPrecision            : QSql.NumericalPrecisionPolicy = ... # 0x0
    LowPrecisionInt32        : QSql.NumericalPrecisionPolicy = ... # 0x1
    LowPrecisionInt64        : QSql.NumericalPrecisionPolicy = ... # 0x2
    LowPrecisionDouble       : QSql.NumericalPrecisionPolicy = ... # 0x4
    In                       : QSql.ParamTypeFlag = ... # 0x1
    Out                      : QSql.ParamTypeFlag = ... # 0x2
    InOut                    : QSql.ParamTypeFlag = ... # 0x3
    Binary                   : QSql.ParamTypeFlag = ... # 0x4
    Tables                   : QSql.TableType = ... # 0x1
    SystemTables             : QSql.TableType = ... # 0x2
    Views                    : QSql.TableType = ... # 0x4
    AllTables                : QSql.TableType = ... # 0xff

    class Location(Shiboken.Enum):
        AfterLastRow             : QSql.Location = ... # -0x2
        BeforeFirstRow           : QSql.Location = ... # -0x1

    class NumericalPrecisionPolicy(Shiboken.Enum):
        HighPrecision            : QSql.NumericalPrecisionPolicy = ... # 0x0
        LowPrecisionInt32        : QSql.NumericalPrecisionPolicy = ... # 0x1
        LowPrecisionInt64        : QSql.NumericalPrecisionPolicy = ... # 0x2
        LowPrecisionDouble       : QSql.NumericalPrecisionPolicy = ... # 0x4

    class ParamType(object): ...

    class ParamTypeFlag(Shiboken.Enum):
        In                       : QSql.ParamTypeFlag = ... # 0x1
        Out                      : QSql.ParamTypeFlag = ... # 0x2
        InOut                    : QSql.ParamTypeFlag = ... # 0x3
        Binary                   : QSql.ParamTypeFlag = ... # 0x4

    class TableType(Shiboken.Enum):
        Tables                   : QSql.TableType = ... # 0x1
        SystemTables             : QSql.TableType = ... # 0x2
        Views                    : QSql.TableType = ... # 0x4
        AllTables                : QSql.TableType = ... # 0xff


class QSqlDatabase(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, driver: PySide2.QtSql.QSqlDriver) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtSql.QSqlDatabase) -> None: ...
    @typing.overload
    def __init__(self, type: str) -> None: ...


class QSqlDriver(PySide2.QtCore.QObject):
    UnknownDbms              : QSqlDriver.DbmsType = ... # 0x0
    MSSqlServer              : QSqlDriver.DbmsType = ... # 0x1
    MySqlServer              : QSqlDriver.DbmsType = ... # 0x2
    PostgreSQL               : QSqlDriver.DbmsType = ... # 0x3
    Oracle                   : QSqlDriver.DbmsType = ... # 0x4
    Sybase                   : QSqlDriver.DbmsType = ... # 0x5
    SQLite                   : QSqlDriver.DbmsType = ... # 0x6
    Interbase                : QSqlDriver.DbmsType = ... # 0x7
    DB2                      : QSqlDriver.DbmsType = ... # 0x8
    Transactions             : QSqlDriver.DriverFeature = ... # 0x0
    QuerySize                : QSqlDriver.DriverFeature = ... # 0x1
    BLOB                     : QSqlDriver.DriverFeature = ... # 0x2
    Unicode                  : QSqlDriver.DriverFeature = ... # 0x3
    PreparedQueries          : QSqlDriver.DriverFeature = ... # 0x4
    NamedPlaceholders        : QSqlDriver.DriverFeature = ... # 0x5
    PositionalPlaceholders   : QSqlDriver.DriverFeature = ... # 0x6
    LastInsertId             : QSqlDriver.DriverFeature = ... # 0x7
    BatchOperations          : QSqlDriver.DriverFeature = ... # 0x8
    SimpleLocking            : QSqlDriver.DriverFeature = ... # 0x9
    LowPrecisionNumbers      : QSqlDriver.DriverFeature = ... # 0xa
    EventNotifications       : QSqlDriver.DriverFeature = ... # 0xb
    FinishQuery              : QSqlDriver.DriverFeature = ... # 0xc
    MultipleResultSets       : QSqlDriver.DriverFeature = ... # 0xd
    CancelQuery              : QSqlDriver.DriverFeature = ... # 0xe
    FieldName                : QSqlDriver.IdentifierType = ... # 0x0
    TableName                : QSqlDriver.IdentifierType = ... # 0x1
    UnknownSource            : QSqlDriver.NotificationSource = ... # 0x0
    SelfSource               : QSqlDriver.NotificationSource = ... # 0x1
    OtherSource              : QSqlDriver.NotificationSource = ... # 0x2
    WhereStatement           : QSqlDriver.StatementType = ... # 0x0
    SelectStatement          : QSqlDriver.StatementType = ... # 0x1
    UpdateStatement          : QSqlDriver.StatementType = ... # 0x2
    InsertStatement          : QSqlDriver.StatementType = ... # 0x3
    DeleteStatement          : QSqlDriver.StatementType = ... # 0x4

    class DbmsType(Shiboken.Enum):
        UnknownDbms              : QSqlDriver.DbmsType = ... # 0x0
        MSSqlServer              : QSqlDriver.DbmsType = ... # 0x1
        MySqlServer              : QSqlDriver.DbmsType = ... # 0x2
        PostgreSQL               : QSqlDriver.DbmsType = ... # 0x3
        Oracle                   : QSqlDriver.DbmsType = ... # 0x4
        Sybase                   : QSqlDriver.DbmsType = ... # 0x5
        SQLite                   : QSqlDriver.DbmsType = ... # 0x6
        Interbase                : QSqlDriver.DbmsType = ... # 0x7
        DB2                      : QSqlDriver.DbmsType = ... # 0x8

    class DriverFeature(Shiboken.Enum):
        Transactions             : QSqlDriver.DriverFeature = ... # 0x0
        QuerySize                : QSqlDriver.DriverFeature = ... # 0x1
        BLOB                     : QSqlDriver.DriverFeature = ... # 0x2
        Unicode                  : QSqlDriver.DriverFeature = ... # 0x3
        PreparedQueries          : QSqlDriver.DriverFeature = ... # 0x4
        NamedPlaceholders        : QSqlDriver.DriverFeature = ... # 0x5
        PositionalPlaceholders   : QSqlDriver.DriverFeature = ... # 0x6
        LastInsertId             : QSqlDriver.DriverFeature = ... # 0x7
        BatchOperations          : QSqlDriver.DriverFeature = ... # 0x8
        SimpleLocking            : QSqlDriver.DriverFeature = ... # 0x9
        LowPrecisionNumbers      : QSqlDriver.DriverFeature = ... # 0xa
        EventNotifications       : QSqlDriver.DriverFeature = ... # 0xb
        FinishQuery              : QSqlDriver.DriverFeature = ... # 0xc
        MultipleResultSets       : QSqlDriver.DriverFeature = ... # 0xd
        CancelQuery              : QSqlDriver.DriverFeature = ... # 0xe

    class IdentifierType(Shiboken.Enum):
        FieldName                : QSqlDriver.IdentifierType = ... # 0x0
        TableName                : QSqlDriver.IdentifierType = ... # 0x1

    class NotificationSource(Shiboken.Enum):
        UnknownSource            : QSqlDriver.NotificationSource = ... # 0x0
        SelfSource               : QSqlDriver.NotificationSource = ... # 0x1
        OtherSource              : QSqlDriver.NotificationSource = ... # 0x2

    class StatementType(Shiboken.Enum):
        WhereStatement           : QSqlDriver.StatementType = ... # 0x0
        SelectStatement          : QSqlDriver.StatementType = ... # 0x1
        UpdateStatement          : QSqlDriver.StatementType = ... # 0x2
        InsertStatement          : QSqlDriver.StatementType = ... # 0x3
        DeleteStatement          : QSqlDriver.StatementType = ... # 0x4

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QSqlDriverCreatorBase(Shiboken.Object):

    def __init__(self) -> None: ...


class QSqlError(Shiboken.Object):
    NoError                  : QSqlError.ErrorType = ... # 0x0
    ConnectionError          : QSqlError.ErrorType = ... # 0x1
    StatementError           : QSqlError.ErrorType = ... # 0x2
    TransactionError         : QSqlError.ErrorType = ... # 0x3
    UnknownError             : QSqlError.ErrorType = ... # 0x4

    class ErrorType(Shiboken.Enum):
        NoError                  : QSqlError.ErrorType = ... # 0x0
        ConnectionError          : QSqlError.ErrorType = ... # 0x1
        StatementError           : QSqlError.ErrorType = ... # 0x2
        TransactionError         : QSqlError.ErrorType = ... # 0x3
        UnknownError             : QSqlError.ErrorType = ... # 0x4

    @typing.overload
    def __init__(self, driverText: str, databaseText: str, type: PySide2.QtSql.QSqlError.ErrorType, number: int) -> None: ...
    @typing.overload
    def __init__(self, driverText: str = ..., databaseText: str = ..., type: PySide2.QtSql.QSqlError.ErrorType = ..., errorCode: str = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtSql.QSqlError) -> None: ...


class QSqlField(Shiboken.Object):
    Unknown                  : QSqlField.RequiredStatus = ... # -0x1
    Optional                 : QSqlField.RequiredStatus = ... # 0x0
    Required                 : QSqlField.RequiredStatus = ... # 0x1

    class RequiredStatus(Shiboken.Enum):
        Unknown                  : QSqlField.RequiredStatus = ... # -0x1
        Optional                 : QSqlField.RequiredStatus = ... # 0x0
        Required                 : QSqlField.RequiredStatus = ... # 0x1

    @typing.overload
    def __init__(self, fieldName: str, type: type, tableName: str) -> None: ...
    @typing.overload
    def __init__(self, fieldName: str = ..., type: type = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtSql.QSqlField) -> None: ...


class QSqlIndex(PySide2.QtSql.QSqlRecord):

    @typing.overload
    def __init__(self, cursorName: str = ..., name: str = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtSql.QSqlIndex) -> None: ...


class QSqlQuery(Shiboken.Object):
    ValuesAsRows             : QSqlQuery.BatchExecutionMode = ... # 0x0
    ValuesAsColumns          : QSqlQuery.BatchExecutionMode = ... # 0x1

    class BatchExecutionMode(Shiboken.Enum):
        ValuesAsRows             : QSqlQuery.BatchExecutionMode = ... # 0x0
        ValuesAsColumns          : QSqlQuery.BatchExecutionMode = ... # 0x1

    @typing.overload
    def __init__(self, db: PySide2.QtSql.QSqlDatabase) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtSql.QSqlQuery) -> None: ...
    @typing.overload
    def __init__(self, query: str = ..., db: PySide2.QtSql.QSqlDatabase = ...) -> None: ...
    @typing.overload
    def __init__(self, r: PySide2.QtSql.QSqlResult) -> None: ...


class QSqlQueryModel(PySide2.QtCore.QAbstractTableModel):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QSqlRecord(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtSql.QSqlRecord) -> None: ...


class QSqlRelation(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QSqlRelation: PySide2.QtSql.QSqlRelation) -> None: ...
    @typing.overload
    def __init__(self, aTableName: str, indexCol: str, displayCol: str) -> None: ...


class QSqlRelationalDelegate(PySide2.QtWidgets.QItemDelegate):

    def __init__(self, aParent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QSqlRelationalTableModel(PySide2.QtSql.QSqlTableModel):
    InnerJoin                : QSqlRelationalTableModel.JoinMode = ... # 0x0
    LeftJoin                 : QSqlRelationalTableModel.JoinMode = ... # 0x1

    class JoinMode(Shiboken.Enum):
        InnerJoin                : QSqlRelationalTableModel.JoinMode = ... # 0x0
        LeftJoin                 : QSqlRelationalTableModel.JoinMode = ... # 0x1

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ..., db: PySide2.QtSql.QSqlDatabase = ...) -> None: ...


class QSqlResult(Shiboken.Object):
    PositionalBinding        : QSqlResult.BindingSyntax = ... # 0x0
    NamedBinding             : QSqlResult.BindingSyntax = ... # 0x1

    class BindingSyntax(Shiboken.Enum):
        PositionalBinding        : QSqlResult.BindingSyntax = ... # 0x0
        NamedBinding             : QSqlResult.BindingSyntax = ... # 0x1

    def __init__(self, db: PySide2.QtSql.QSqlDriver) -> None: ...


class QSqlTableModel(PySide2.QtSql.QSqlQueryModel):
    OnFieldChange            : QSqlTableModel.EditStrategy = ... # 0x0
    OnRowChange              : QSqlTableModel.EditStrategy = ... # 0x1
    OnManualSubmit           : QSqlTableModel.EditStrategy = ... # 0x2

    class EditStrategy(Shiboken.Enum):
        OnFieldChange            : QSqlTableModel.EditStrategy = ... # 0x0
        OnRowChange              : QSqlTableModel.EditStrategy = ... # 0x1
        OnManualSubmit           : QSqlTableModel.EditStrategy = ... # 0x2

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ..., db: PySide2.QtSql.QSqlDatabase = ...) -> None: ...


# eof
