#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtWidgets, except for defaults which are replaced by "...".
"""

# Module PySide2.QtWidgets
import PySide2
try:
    import typing
except ImportError:
    from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

from shiboken2 import Shiboken

import PySide2.QtCore
import PySide2.QtGui
import PySide2.QtWidgets


class QAbstractButton(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QAbstractGraphicsShapeItem(PySide2.QtWidgets.QGraphicsItem):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...


class QAbstractItemDelegate(PySide2.QtCore.QObject):
    NoHint                   : QAbstractItemDelegate.EndEditHint = ... # 0x0
    EditNextItem             : QAbstractItemDelegate.EndEditHint = ... # 0x1
    EditPreviousItem         : QAbstractItemDelegate.EndEditHint = ... # 0x2
    SubmitModelCache         : QAbstractItemDelegate.EndEditHint = ... # 0x3
    RevertModelCache         : QAbstractItemDelegate.EndEditHint = ... # 0x4

    class EndEditHint(Shiboken.Enum):
        NoHint                   : QAbstractItemDelegate.EndEditHint = ... # 0x0
        EditNextItem             : QAbstractItemDelegate.EndEditHint = ... # 0x1
        EditPreviousItem         : QAbstractItemDelegate.EndEditHint = ... # 0x2
        SubmitModelCache         : QAbstractItemDelegate.EndEditHint = ... # 0x3
        RevertModelCache         : QAbstractItemDelegate.EndEditHint = ... # 0x4

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QAbstractItemView(PySide2.QtWidgets.QAbstractScrollArea):
    MoveUp                   : QAbstractItemView.CursorAction = ... # 0x0
    MoveDown                 : QAbstractItemView.CursorAction = ... # 0x1
    MoveLeft                 : QAbstractItemView.CursorAction = ... # 0x2
    MoveRight                : QAbstractItemView.CursorAction = ... # 0x3
    MoveHome                 : QAbstractItemView.CursorAction = ... # 0x4
    MoveEnd                  : QAbstractItemView.CursorAction = ... # 0x5
    MovePageUp               : QAbstractItemView.CursorAction = ... # 0x6
    MovePageDown             : QAbstractItemView.CursorAction = ... # 0x7
    MoveNext                 : QAbstractItemView.CursorAction = ... # 0x8
    MovePrevious             : QAbstractItemView.CursorAction = ... # 0x9
    NoDragDrop               : QAbstractItemView.DragDropMode = ... # 0x0
    DragOnly                 : QAbstractItemView.DragDropMode = ... # 0x1
    DropOnly                 : QAbstractItemView.DragDropMode = ... # 0x2
    DragDrop                 : QAbstractItemView.DragDropMode = ... # 0x3
    InternalMove             : QAbstractItemView.DragDropMode = ... # 0x4
    OnItem                   : QAbstractItemView.DropIndicatorPosition = ... # 0x0
    AboveItem                : QAbstractItemView.DropIndicatorPosition = ... # 0x1
    BelowItem                : QAbstractItemView.DropIndicatorPosition = ... # 0x2
    OnViewport               : QAbstractItemView.DropIndicatorPosition = ... # 0x3
    NoEditTriggers           : QAbstractItemView.EditTrigger = ... # 0x0
    CurrentChanged           : QAbstractItemView.EditTrigger = ... # 0x1
    DoubleClicked            : QAbstractItemView.EditTrigger = ... # 0x2
    SelectedClicked          : QAbstractItemView.EditTrigger = ... # 0x4
    EditKeyPressed           : QAbstractItemView.EditTrigger = ... # 0x8
    AnyKeyPressed            : QAbstractItemView.EditTrigger = ... # 0x10
    AllEditTriggers          : QAbstractItemView.EditTrigger = ... # 0x1f
    EnsureVisible            : QAbstractItemView.ScrollHint = ... # 0x0
    PositionAtTop            : QAbstractItemView.ScrollHint = ... # 0x1
    PositionAtBottom         : QAbstractItemView.ScrollHint = ... # 0x2
    PositionAtCenter         : QAbstractItemView.ScrollHint = ... # 0x3
    ScrollPerItem            : QAbstractItemView.ScrollMode = ... # 0x0
    ScrollPerPixel           : QAbstractItemView.ScrollMode = ... # 0x1
    SelectItems              : QAbstractItemView.SelectionBehavior = ... # 0x0
    SelectRows               : QAbstractItemView.SelectionBehavior = ... # 0x1
    SelectColumns            : QAbstractItemView.SelectionBehavior = ... # 0x2
    NoSelection              : QAbstractItemView.SelectionMode = ... # 0x0
    SingleSelection          : QAbstractItemView.SelectionMode = ... # 0x1
    MultiSelection           : QAbstractItemView.SelectionMode = ... # 0x2
    ExtendedSelection        : QAbstractItemView.SelectionMode = ... # 0x3
    ContiguousSelection      : QAbstractItemView.SelectionMode = ... # 0x4
    NoState                  : QAbstractItemView.State = ... # 0x0
    DraggingState            : QAbstractItemView.State = ... # 0x1
    DragSelectingState       : QAbstractItemView.State = ... # 0x2
    EditingState             : QAbstractItemView.State = ... # 0x3
    ExpandingState           : QAbstractItemView.State = ... # 0x4
    CollapsingState          : QAbstractItemView.State = ... # 0x5
    AnimatingState           : QAbstractItemView.State = ... # 0x6

    class CursorAction(Shiboken.Enum):
        MoveUp                   : QAbstractItemView.CursorAction = ... # 0x0
        MoveDown                 : QAbstractItemView.CursorAction = ... # 0x1
        MoveLeft                 : QAbstractItemView.CursorAction = ... # 0x2
        MoveRight                : QAbstractItemView.CursorAction = ... # 0x3
        MoveHome                 : QAbstractItemView.CursorAction = ... # 0x4
        MoveEnd                  : QAbstractItemView.CursorAction = ... # 0x5
        MovePageUp               : QAbstractItemView.CursorAction = ... # 0x6
        MovePageDown             : QAbstractItemView.CursorAction = ... # 0x7
        MoveNext                 : QAbstractItemView.CursorAction = ... # 0x8
        MovePrevious             : QAbstractItemView.CursorAction = ... # 0x9

    class DragDropMode(Shiboken.Enum):
        NoDragDrop               : QAbstractItemView.DragDropMode = ... # 0x0
        DragOnly                 : QAbstractItemView.DragDropMode = ... # 0x1
        DropOnly                 : QAbstractItemView.DragDropMode = ... # 0x2
        DragDrop                 : QAbstractItemView.DragDropMode = ... # 0x3
        InternalMove             : QAbstractItemView.DragDropMode = ... # 0x4

    class DropIndicatorPosition(Shiboken.Enum):
        OnItem                   : QAbstractItemView.DropIndicatorPosition = ... # 0x0
        AboveItem                : QAbstractItemView.DropIndicatorPosition = ... # 0x1
        BelowItem                : QAbstractItemView.DropIndicatorPosition = ... # 0x2
        OnViewport               : QAbstractItemView.DropIndicatorPosition = ... # 0x3

    class EditTrigger(Shiboken.Enum):
        NoEditTriggers           : QAbstractItemView.EditTrigger = ... # 0x0
        CurrentChanged           : QAbstractItemView.EditTrigger = ... # 0x1
        DoubleClicked            : QAbstractItemView.EditTrigger = ... # 0x2
        SelectedClicked          : QAbstractItemView.EditTrigger = ... # 0x4
        EditKeyPressed           : QAbstractItemView.EditTrigger = ... # 0x8
        AnyKeyPressed            : QAbstractItemView.EditTrigger = ... # 0x10
        AllEditTriggers          : QAbstractItemView.EditTrigger = ... # 0x1f

    class EditTriggers(object): ...

    class ScrollHint(Shiboken.Enum):
        EnsureVisible            : QAbstractItemView.ScrollHint = ... # 0x0
        PositionAtTop            : QAbstractItemView.ScrollHint = ... # 0x1
        PositionAtBottom         : QAbstractItemView.ScrollHint = ... # 0x2
        PositionAtCenter         : QAbstractItemView.ScrollHint = ... # 0x3

    class ScrollMode(Shiboken.Enum):
        ScrollPerItem            : QAbstractItemView.ScrollMode = ... # 0x0
        ScrollPerPixel           : QAbstractItemView.ScrollMode = ... # 0x1

    class SelectionBehavior(Shiboken.Enum):
        SelectItems              : QAbstractItemView.SelectionBehavior = ... # 0x0
        SelectRows               : QAbstractItemView.SelectionBehavior = ... # 0x1
        SelectColumns            : QAbstractItemView.SelectionBehavior = ... # 0x2

    class SelectionMode(Shiboken.Enum):
        NoSelection              : QAbstractItemView.SelectionMode = ... # 0x0
        SingleSelection          : QAbstractItemView.SelectionMode = ... # 0x1
        MultiSelection           : QAbstractItemView.SelectionMode = ... # 0x2
        ExtendedSelection        : QAbstractItemView.SelectionMode = ... # 0x3
        ContiguousSelection      : QAbstractItemView.SelectionMode = ... # 0x4

    class State(Shiboken.Enum):
        NoState                  : QAbstractItemView.State = ... # 0x0
        DraggingState            : QAbstractItemView.State = ... # 0x1
        DragSelectingState       : QAbstractItemView.State = ... # 0x2
        EditingState             : QAbstractItemView.State = ... # 0x3
        ExpandingState           : QAbstractItemView.State = ... # 0x4
        CollapsingState          : QAbstractItemView.State = ... # 0x5
        AnimatingState           : QAbstractItemView.State = ... # 0x6

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QAbstractScrollArea(PySide2.QtWidgets.QFrame):
    AdjustIgnored            : QAbstractScrollArea.SizeAdjustPolicy = ... # 0x0
    AdjustToContentsOnFirstShow: QAbstractScrollArea.SizeAdjustPolicy = ... # 0x1
    AdjustToContents         : QAbstractScrollArea.SizeAdjustPolicy = ... # 0x2

    class SizeAdjustPolicy(Shiboken.Enum):
        AdjustIgnored            : QAbstractScrollArea.SizeAdjustPolicy = ... # 0x0
        AdjustToContentsOnFirstShow: QAbstractScrollArea.SizeAdjustPolicy = ... # 0x1
        AdjustToContents         : QAbstractScrollArea.SizeAdjustPolicy = ... # 0x2

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QAbstractSlider(PySide2.QtWidgets.QWidget):
    SliderNoAction           : QAbstractSlider.SliderAction = ... # 0x0
    SliderSingleStepAdd      : QAbstractSlider.SliderAction = ... # 0x1
    SliderSingleStepSub      : QAbstractSlider.SliderAction = ... # 0x2
    SliderPageStepAdd        : QAbstractSlider.SliderAction = ... # 0x3
    SliderPageStepSub        : QAbstractSlider.SliderAction = ... # 0x4
    SliderToMinimum          : QAbstractSlider.SliderAction = ... # 0x5
    SliderToMaximum          : QAbstractSlider.SliderAction = ... # 0x6
    SliderMove               : QAbstractSlider.SliderAction = ... # 0x7
    SliderRangeChange        : QAbstractSlider.SliderChange = ... # 0x0
    SliderOrientationChange  : QAbstractSlider.SliderChange = ... # 0x1
    SliderStepsChange        : QAbstractSlider.SliderChange = ... # 0x2
    SliderValueChange        : QAbstractSlider.SliderChange = ... # 0x3

    class SliderAction(Shiboken.Enum):
        SliderNoAction           : QAbstractSlider.SliderAction = ... # 0x0
        SliderSingleStepAdd      : QAbstractSlider.SliderAction = ... # 0x1
        SliderSingleStepSub      : QAbstractSlider.SliderAction = ... # 0x2
        SliderPageStepAdd        : QAbstractSlider.SliderAction = ... # 0x3
        SliderPageStepSub        : QAbstractSlider.SliderAction = ... # 0x4
        SliderToMinimum          : QAbstractSlider.SliderAction = ... # 0x5
        SliderToMaximum          : QAbstractSlider.SliderAction = ... # 0x6
        SliderMove               : QAbstractSlider.SliderAction = ... # 0x7

    class SliderChange(Shiboken.Enum):
        SliderRangeChange        : QAbstractSlider.SliderChange = ... # 0x0
        SliderOrientationChange  : QAbstractSlider.SliderChange = ... # 0x1
        SliderStepsChange        : QAbstractSlider.SliderChange = ... # 0x2
        SliderValueChange        : QAbstractSlider.SliderChange = ... # 0x3

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QAbstractSpinBox(PySide2.QtWidgets.QWidget):
    UpDownArrows             : QAbstractSpinBox.ButtonSymbols = ... # 0x0
    PlusMinus                : QAbstractSpinBox.ButtonSymbols = ... # 0x1
    NoButtons                : QAbstractSpinBox.ButtonSymbols = ... # 0x2
    CorrectToPreviousValue   : QAbstractSpinBox.CorrectionMode = ... # 0x0
    CorrectToNearestValue    : QAbstractSpinBox.CorrectionMode = ... # 0x1
    StepNone                 : QAbstractSpinBox.StepEnabledFlag = ... # 0x0
    StepUpEnabled            : QAbstractSpinBox.StepEnabledFlag = ... # 0x1
    StepDownEnabled          : QAbstractSpinBox.StepEnabledFlag = ... # 0x2
    DefaultStepType          : QAbstractSpinBox.StepType = ... # 0x0
    AdaptiveDecimalStepType  : QAbstractSpinBox.StepType = ... # 0x1

    class ButtonSymbols(Shiboken.Enum):
        UpDownArrows             : QAbstractSpinBox.ButtonSymbols = ... # 0x0
        PlusMinus                : QAbstractSpinBox.ButtonSymbols = ... # 0x1
        NoButtons                : QAbstractSpinBox.ButtonSymbols = ... # 0x2

    class CorrectionMode(Shiboken.Enum):
        CorrectToPreviousValue   : QAbstractSpinBox.CorrectionMode = ... # 0x0
        CorrectToNearestValue    : QAbstractSpinBox.CorrectionMode = ... # 0x1

    class StepEnabled(object): ...

    class StepEnabledFlag(Shiboken.Enum):
        StepNone                 : QAbstractSpinBox.StepEnabledFlag = ... # 0x0
        StepUpEnabled            : QAbstractSpinBox.StepEnabledFlag = ... # 0x1
        StepDownEnabled          : QAbstractSpinBox.StepEnabledFlag = ... # 0x2

    class StepType(Shiboken.Enum):
        DefaultStepType          : QAbstractSpinBox.StepType = ... # 0x0
        AdaptiveDecimalStepType  : QAbstractSpinBox.StepType = ... # 0x1

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QAccessibleWidget(PySide2.QtGui.QAccessibleObject):

    def __init__(self, o: PySide2.QtWidgets.QWidget, r: PySide2.QtGui.QAccessible.Role = ..., name: str = ...) -> None: ...


class QAction(PySide2.QtCore.QObject):
    Trigger                  : QAction.ActionEvent = ... # 0x0
    Hover                    : QAction.ActionEvent = ... # 0x1
    NoRole                   : QAction.MenuRole = ... # 0x0
    TextHeuristicRole        : QAction.MenuRole = ... # 0x1
    ApplicationSpecificRole  : QAction.MenuRole = ... # 0x2
    AboutQtRole              : QAction.MenuRole = ... # 0x3
    AboutRole                : QAction.MenuRole = ... # 0x4
    PreferencesRole          : QAction.MenuRole = ... # 0x5
    QuitRole                 : QAction.MenuRole = ... # 0x6
    LowPriority              : QAction.Priority = ... # 0x0
    NormalPriority           : QAction.Priority = ... # 0x80
    HighPriority             : QAction.Priority = ... # 0x100

    class ActionEvent(Shiboken.Enum):
        Trigger                  : QAction.ActionEvent = ... # 0x0
        Hover                    : QAction.ActionEvent = ... # 0x1

    class MenuRole(Shiboken.Enum):
        NoRole                   : QAction.MenuRole = ... # 0x0
        TextHeuristicRole        : QAction.MenuRole = ... # 0x1
        ApplicationSpecificRole  : QAction.MenuRole = ... # 0x2
        AboutQtRole              : QAction.MenuRole = ... # 0x3
        AboutRole                : QAction.MenuRole = ... # 0x4
        PreferencesRole          : QAction.MenuRole = ... # 0x5
        QuitRole                 : QAction.MenuRole = ... # 0x6

    class Priority(Shiboken.Enum):
        LowPriority              : QAction.Priority = ... # 0x0
        NormalPriority           : QAction.Priority = ... # 0x80
        HighPriority             : QAction.Priority = ... # 0x100

    @typing.overload
    def __init__(self, icon: PySide2.QtGui.QIcon, text: str, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QActionGroup(PySide2.QtCore.QObject):

    class ExclusionPolicy(Shiboken.Enum):
        None_                    : QActionGroup.ExclusionPolicy = ... # 0x0
        Exclusive                : QActionGroup.ExclusionPolicy = ... # 0x1
        ExclusiveOptional        : QActionGroup.ExclusionPolicy = ... # 0x2

    def __init__(self, parent: PySide2.QtCore.QObject) -> None: ...


class QApplication(PySide2.QtGui.QGuiApplication):
    NormalColor              : QApplication.ColorSpec = ... # 0x0
    CustomColor              : QApplication.ColorSpec = ... # 0x1
    ManyColor                : QApplication.ColorSpec = ... # 0x2

    class ColorSpec(Shiboken.Enum):
        NormalColor              : QApplication.ColorSpec = ... # 0x0
        CustomColor              : QApplication.ColorSpec = ... # 0x1
        ManyColor                : QApplication.ColorSpec = ... # 0x2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: typing.Sequence[str]) -> None: ...


class QBoxLayout(PySide2.QtWidgets.QLayout):
    LeftToRight              : QBoxLayout.Direction = ... # 0x0
    RightToLeft              : QBoxLayout.Direction = ... # 0x1
    Down                     : QBoxLayout.Direction = ... # 0x2
    TopToBottom              : QBoxLayout.Direction = ... # 0x2
    BottomToTop              : QBoxLayout.Direction = ... # 0x3
    Up                       : QBoxLayout.Direction = ... # 0x3

    class Direction(Shiboken.Enum):
        LeftToRight              : QBoxLayout.Direction = ... # 0x0
        RightToLeft              : QBoxLayout.Direction = ... # 0x1
        Down                     : QBoxLayout.Direction = ... # 0x2
        TopToBottom              : QBoxLayout.Direction = ... # 0x2
        BottomToTop              : QBoxLayout.Direction = ... # 0x3
        Up                       : QBoxLayout.Direction = ... # 0x3

    def __init__(self, arg__1: PySide2.QtWidgets.QBoxLayout.Direction, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QButtonGroup(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QCalendarWidget(PySide2.QtWidgets.QWidget):
    NoHorizontalHeader       : QCalendarWidget.HorizontalHeaderFormat = ... # 0x0
    SingleLetterDayNames     : QCalendarWidget.HorizontalHeaderFormat = ... # 0x1
    ShortDayNames            : QCalendarWidget.HorizontalHeaderFormat = ... # 0x2
    LongDayNames             : QCalendarWidget.HorizontalHeaderFormat = ... # 0x3
    NoSelection              : QCalendarWidget.SelectionMode = ... # 0x0
    SingleSelection          : QCalendarWidget.SelectionMode = ... # 0x1
    NoVerticalHeader         : QCalendarWidget.VerticalHeaderFormat = ... # 0x0
    ISOWeekNumbers           : QCalendarWidget.VerticalHeaderFormat = ... # 0x1

    class HorizontalHeaderFormat(Shiboken.Enum):
        NoHorizontalHeader       : QCalendarWidget.HorizontalHeaderFormat = ... # 0x0
        SingleLetterDayNames     : QCalendarWidget.HorizontalHeaderFormat = ... # 0x1
        ShortDayNames            : QCalendarWidget.HorizontalHeaderFormat = ... # 0x2
        LongDayNames             : QCalendarWidget.HorizontalHeaderFormat = ... # 0x3

    class SelectionMode(Shiboken.Enum):
        NoSelection              : QCalendarWidget.SelectionMode = ... # 0x0
        SingleSelection          : QCalendarWidget.SelectionMode = ... # 0x1

    class VerticalHeaderFormat(Shiboken.Enum):
        NoVerticalHeader         : QCalendarWidget.VerticalHeaderFormat = ... # 0x0
        ISOWeekNumbers           : QCalendarWidget.VerticalHeaderFormat = ... # 0x1

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QCheckBox(PySide2.QtWidgets.QAbstractButton):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QColorDialog(PySide2.QtWidgets.QDialog):
    ShowAlphaChannel         : QColorDialog.ColorDialogOption = ... # 0x1
    NoButtons                : QColorDialog.ColorDialogOption = ... # 0x2
    DontUseNativeDialog      : QColorDialog.ColorDialogOption = ... # 0x4

    class ColorDialogOption(Shiboken.Enum):
        ShowAlphaChannel         : QColorDialog.ColorDialogOption = ... # 0x1
        NoButtons                : QColorDialog.ColorDialogOption = ... # 0x2
        DontUseNativeDialog      : QColorDialog.ColorDialogOption = ... # 0x4

    class ColorDialogOptions(object): ...

    @typing.overload
    def __init__(self, initial: PySide2.QtGui.QColor, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QColormap(Shiboken.Object):
    Direct                   : QColormap.Mode = ... # 0x0
    Indexed                  : QColormap.Mode = ... # 0x1
    Gray                     : QColormap.Mode = ... # 0x2

    class Mode(Shiboken.Enum):
        Direct                   : QColormap.Mode = ... # 0x0
        Indexed                  : QColormap.Mode = ... # 0x1
        Gray                     : QColormap.Mode = ... # 0x2

    def __init__(self, colormap: PySide2.QtWidgets.QColormap) -> None: ...


class QColumnView(PySide2.QtWidgets.QAbstractItemView):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QComboBox(PySide2.QtWidgets.QWidget):
    NoInsert                 : QComboBox.InsertPolicy = ... # 0x0
    InsertAtTop              : QComboBox.InsertPolicy = ... # 0x1
    InsertAtCurrent          : QComboBox.InsertPolicy = ... # 0x2
    InsertAtBottom           : QComboBox.InsertPolicy = ... # 0x3
    InsertAfterCurrent       : QComboBox.InsertPolicy = ... # 0x4
    InsertBeforeCurrent      : QComboBox.InsertPolicy = ... # 0x5
    InsertAlphabetically     : QComboBox.InsertPolicy = ... # 0x6
    AdjustToContents         : QComboBox.SizeAdjustPolicy = ... # 0x0
    AdjustToContentsOnFirstShow: QComboBox.SizeAdjustPolicy = ... # 0x1
    AdjustToMinimumContentsLength: QComboBox.SizeAdjustPolicy = ... # 0x2
    AdjustToMinimumContentsLengthWithIcon: QComboBox.SizeAdjustPolicy = ... # 0x3

    class InsertPolicy(Shiboken.Enum):
        NoInsert                 : QComboBox.InsertPolicy = ... # 0x0
        InsertAtTop              : QComboBox.InsertPolicy = ... # 0x1
        InsertAtCurrent          : QComboBox.InsertPolicy = ... # 0x2
        InsertAtBottom           : QComboBox.InsertPolicy = ... # 0x3
        InsertAfterCurrent       : QComboBox.InsertPolicy = ... # 0x4
        InsertBeforeCurrent      : QComboBox.InsertPolicy = ... # 0x5
        InsertAlphabetically     : QComboBox.InsertPolicy = ... # 0x6

    class SizeAdjustPolicy(Shiboken.Enum):
        AdjustToContents         : QComboBox.SizeAdjustPolicy = ... # 0x0
        AdjustToContentsOnFirstShow: QComboBox.SizeAdjustPolicy = ... # 0x1
        AdjustToMinimumContentsLength: QComboBox.SizeAdjustPolicy = ... # 0x2
        AdjustToMinimumContentsLengthWithIcon: QComboBox.SizeAdjustPolicy = ... # 0x3

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QCommandLinkButton(PySide2.QtWidgets.QPushButton):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, description: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QCommonStyle(PySide2.QtWidgets.QStyle):

    def __init__(self) -> None: ...


class QCompleter(PySide2.QtCore.QObject):
    PopupCompletion          : QCompleter.CompletionMode = ... # 0x0
    UnfilteredPopupCompletion: QCompleter.CompletionMode = ... # 0x1
    InlineCompletion         : QCompleter.CompletionMode = ... # 0x2
    UnsortedModel            : QCompleter.ModelSorting = ... # 0x0
    CaseSensitivelySortedModel: QCompleter.ModelSorting = ... # 0x1
    CaseInsensitivelySortedModel: QCompleter.ModelSorting = ... # 0x2

    class CompletionMode(Shiboken.Enum):
        PopupCompletion          : QCompleter.CompletionMode = ... # 0x0
        UnfilteredPopupCompletion: QCompleter.CompletionMode = ... # 0x1
        InlineCompletion         : QCompleter.CompletionMode = ... # 0x2

    class ModelSorting(Shiboken.Enum):
        UnsortedModel            : QCompleter.ModelSorting = ... # 0x0
        CaseSensitivelySortedModel: QCompleter.ModelSorting = ... # 0x1
        CaseInsensitivelySortedModel: QCompleter.ModelSorting = ... # 0x2

    @typing.overload
    def __init__(self, completions: typing.Sequence[str], parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, model: PySide2.QtCore.QAbstractItemModel, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QDataWidgetMapper(PySide2.QtCore.QObject):
    AutoSubmit               : QDataWidgetMapper.SubmitPolicy = ... # 0x0
    ManualSubmit             : QDataWidgetMapper.SubmitPolicy = ... # 0x1

    class SubmitPolicy(Shiboken.Enum):
        AutoSubmit               : QDataWidgetMapper.SubmitPolicy = ... # 0x0
        ManualSubmit             : QDataWidgetMapper.SubmitPolicy = ... # 0x1

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QDateEdit(PySide2.QtWidgets.QDateTimeEdit):

    @typing.overload
    def __init__(self, date: PySide2.QtCore.QDate, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QDateTimeEdit(PySide2.QtWidgets.QAbstractSpinBox):
    NoSection                : QDateTimeEdit.Section = ... # 0x0
    AmPmSection              : QDateTimeEdit.Section = ... # 0x1
    MSecSection              : QDateTimeEdit.Section = ... # 0x2
    SecondSection            : QDateTimeEdit.Section = ... # 0x4
    MinuteSection            : QDateTimeEdit.Section = ... # 0x8
    HourSection              : QDateTimeEdit.Section = ... # 0x10
    TimeSections_Mask        : QDateTimeEdit.Section = ... # 0x1f
    DaySection               : QDateTimeEdit.Section = ... # 0x100
    MonthSection             : QDateTimeEdit.Section = ... # 0x200
    YearSection              : QDateTimeEdit.Section = ... # 0x400
    DateSections_Mask        : QDateTimeEdit.Section = ... # 0x700

    class Section(Shiboken.Enum):
        NoSection                : QDateTimeEdit.Section = ... # 0x0
        AmPmSection              : QDateTimeEdit.Section = ... # 0x1
        MSecSection              : QDateTimeEdit.Section = ... # 0x2
        SecondSection            : QDateTimeEdit.Section = ... # 0x4
        MinuteSection            : QDateTimeEdit.Section = ... # 0x8
        HourSection              : QDateTimeEdit.Section = ... # 0x10
        TimeSections_Mask        : QDateTimeEdit.Section = ... # 0x1f
        DaySection               : QDateTimeEdit.Section = ... # 0x100
        MonthSection             : QDateTimeEdit.Section = ... # 0x200
        YearSection              : QDateTimeEdit.Section = ... # 0x400
        DateSections_Mask        : QDateTimeEdit.Section = ... # 0x700

    class Sections(object): ...

    @typing.overload
    def __init__(self, d: PySide2.QtCore.QDate, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, dt: PySide2.QtCore.QDateTime, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, t: PySide2.QtCore.QTime, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, val: typing.Any, parserType: type, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QDesktopWidget(PySide2.QtWidgets.QWidget):

    def __init__(self) -> None: ...


class QDial(PySide2.QtWidgets.QAbstractSlider):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QDialog(PySide2.QtWidgets.QWidget):
    Rejected                 : QDialog.DialogCode = ... # 0x0
    Accepted                 : QDialog.DialogCode = ... # 0x1

    class DialogCode(Shiboken.Enum):
        Rejected                 : QDialog.DialogCode = ... # 0x0
        Accepted                 : QDialog.DialogCode = ... # 0x1

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., f: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...


class QDialogButtonBox(PySide2.QtWidgets.QWidget):
    WinLayout                : QDialogButtonBox.ButtonLayout = ... # 0x0
    MacLayout                : QDialogButtonBox.ButtonLayout = ... # 0x1
    KdeLayout                : QDialogButtonBox.ButtonLayout = ... # 0x2
    GnomeLayout              : QDialogButtonBox.ButtonLayout = ... # 0x3
    AndroidLayout            : QDialogButtonBox.ButtonLayout = ... # 0x5
    InvalidRole              : QDialogButtonBox.ButtonRole = ... # -0x1
    AcceptRole               : QDialogButtonBox.ButtonRole = ... # 0x0
    RejectRole               : QDialogButtonBox.ButtonRole = ... # 0x1
    DestructiveRole          : QDialogButtonBox.ButtonRole = ... # 0x2
    ActionRole               : QDialogButtonBox.ButtonRole = ... # 0x3
    HelpRole                 : QDialogButtonBox.ButtonRole = ... # 0x4
    YesRole                  : QDialogButtonBox.ButtonRole = ... # 0x5
    NoRole                   : QDialogButtonBox.ButtonRole = ... # 0x6
    ResetRole                : QDialogButtonBox.ButtonRole = ... # 0x7
    ApplyRole                : QDialogButtonBox.ButtonRole = ... # 0x8
    NRoles                   : QDialogButtonBox.ButtonRole = ... # 0x9
    NoButton                 : QDialogButtonBox.StandardButton = ... # 0x0
    FirstButton              : QDialogButtonBox.StandardButton = ... # 0x400
    Ok                       : QDialogButtonBox.StandardButton = ... # 0x400
    Save                     : QDialogButtonBox.StandardButton = ... # 0x800
    SaveAll                  : QDialogButtonBox.StandardButton = ... # 0x1000
    Open                     : QDialogButtonBox.StandardButton = ... # 0x2000
    Yes                      : QDialogButtonBox.StandardButton = ... # 0x4000
    YesToAll                 : QDialogButtonBox.StandardButton = ... # 0x8000
    No                       : QDialogButtonBox.StandardButton = ... # 0x10000
    NoToAll                  : QDialogButtonBox.StandardButton = ... # 0x20000
    Abort                    : QDialogButtonBox.StandardButton = ... # 0x40000
    Retry                    : QDialogButtonBox.StandardButton = ... # 0x80000
    Ignore                   : QDialogButtonBox.StandardButton = ... # 0x100000
    Close                    : QDialogButtonBox.StandardButton = ... # 0x200000
    Cancel                   : QDialogButtonBox.StandardButton = ... # 0x400000
    Discard                  : QDialogButtonBox.StandardButton = ... # 0x800000
    Help                     : QDialogButtonBox.StandardButton = ... # 0x1000000
    Apply                    : QDialogButtonBox.StandardButton = ... # 0x2000000
    Reset                    : QDialogButtonBox.StandardButton = ... # 0x4000000
    LastButton               : QDialogButtonBox.StandardButton = ... # 0x8000000
    RestoreDefaults          : QDialogButtonBox.StandardButton = ... # 0x8000000

    class ButtonLayout(Shiboken.Enum):
        WinLayout                : QDialogButtonBox.ButtonLayout = ... # 0x0
        MacLayout                : QDialogButtonBox.ButtonLayout = ... # 0x1
        KdeLayout                : QDialogButtonBox.ButtonLayout = ... # 0x2
        GnomeLayout              : QDialogButtonBox.ButtonLayout = ... # 0x3
        AndroidLayout            : QDialogButtonBox.ButtonLayout = ... # 0x5

    class ButtonRole(Shiboken.Enum):
        InvalidRole              : QDialogButtonBox.ButtonRole = ... # -0x1
        AcceptRole               : QDialogButtonBox.ButtonRole = ... # 0x0
        RejectRole               : QDialogButtonBox.ButtonRole = ... # 0x1
        DestructiveRole          : QDialogButtonBox.ButtonRole = ... # 0x2
        ActionRole               : QDialogButtonBox.ButtonRole = ... # 0x3
        HelpRole                 : QDialogButtonBox.ButtonRole = ... # 0x4
        YesRole                  : QDialogButtonBox.ButtonRole = ... # 0x5
        NoRole                   : QDialogButtonBox.ButtonRole = ... # 0x6
        ResetRole                : QDialogButtonBox.ButtonRole = ... # 0x7
        ApplyRole                : QDialogButtonBox.ButtonRole = ... # 0x8
        NRoles                   : QDialogButtonBox.ButtonRole = ... # 0x9

    class StandardButton(Shiboken.Enum):
        NoButton                 : QDialogButtonBox.StandardButton = ... # 0x0
        FirstButton              : QDialogButtonBox.StandardButton = ... # 0x400
        Ok                       : QDialogButtonBox.StandardButton = ... # 0x400
        Save                     : QDialogButtonBox.StandardButton = ... # 0x800
        SaveAll                  : QDialogButtonBox.StandardButton = ... # 0x1000
        Open                     : QDialogButtonBox.StandardButton = ... # 0x2000
        Yes                      : QDialogButtonBox.StandardButton = ... # 0x4000
        YesToAll                 : QDialogButtonBox.StandardButton = ... # 0x8000
        No                       : QDialogButtonBox.StandardButton = ... # 0x10000
        NoToAll                  : QDialogButtonBox.StandardButton = ... # 0x20000
        Abort                    : QDialogButtonBox.StandardButton = ... # 0x40000
        Retry                    : QDialogButtonBox.StandardButton = ... # 0x80000
        Ignore                   : QDialogButtonBox.StandardButton = ... # 0x100000
        Close                    : QDialogButtonBox.StandardButton = ... # 0x200000
        Cancel                   : QDialogButtonBox.StandardButton = ... # 0x400000
        Discard                  : QDialogButtonBox.StandardButton = ... # 0x800000
        Help                     : QDialogButtonBox.StandardButton = ... # 0x1000000
        Apply                    : QDialogButtonBox.StandardButton = ... # 0x2000000
        Reset                    : QDialogButtonBox.StandardButton = ... # 0x4000000
        LastButton               : QDialogButtonBox.StandardButton = ... # 0x8000000
        RestoreDefaults          : QDialogButtonBox.StandardButton = ... # 0x8000000

    class StandardButtons(object): ...

    @typing.overload
    def __init__(self, buttons: PySide2.QtWidgets.QDialogButtonBox.StandardButtons, orientation: PySide2.QtCore.Qt.Orientation, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, buttons: PySide2.QtWidgets.QDialogButtonBox.StandardButtons, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, orientation: PySide2.QtCore.Qt.Orientation, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QDirModel(PySide2.QtCore.QAbstractItemModel):
    FileIconRole             : QDirModel.Roles = ... # 0x1
    FilePathRole             : QDirModel.Roles = ... # 0x101
    FileNameRole             : QDirModel.Roles = ... # 0x102

    class Roles(Shiboken.Enum):
        FileIconRole             : QDirModel.Roles = ... # 0x1
        FilePathRole             : QDirModel.Roles = ... # 0x101
        FileNameRole             : QDirModel.Roles = ... # 0x102

    @typing.overload
    def __init__(self, nameFilters: typing.Sequence[str], filters: PySide2.QtCore.QDir.Filters, sort: PySide2.QtCore.QDir.SortFlags, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QDockWidget(PySide2.QtWidgets.QWidget):
    NoDockWidgetFeatures     : QDockWidget.DockWidgetFeature = ... # 0x0
    DockWidgetClosable       : QDockWidget.DockWidgetFeature = ... # 0x1
    DockWidgetMovable        : QDockWidget.DockWidgetFeature = ... # 0x2
    DockWidgetFloatable      : QDockWidget.DockWidgetFeature = ... # 0x4
    AllDockWidgetFeatures    : QDockWidget.DockWidgetFeature = ... # 0x7
    DockWidgetVerticalTitleBar: QDockWidget.DockWidgetFeature = ... # 0x8
    DockWidgetFeatureMask    : QDockWidget.DockWidgetFeature = ... # 0xf
    Reserved                 : QDockWidget.DockWidgetFeature = ... # 0xff

    class DockWidgetFeature(Shiboken.Enum):
        NoDockWidgetFeatures     : QDockWidget.DockWidgetFeature = ... # 0x0
        DockWidgetClosable       : QDockWidget.DockWidgetFeature = ... # 0x1
        DockWidgetMovable        : QDockWidget.DockWidgetFeature = ... # 0x2
        DockWidgetFloatable      : QDockWidget.DockWidgetFeature = ... # 0x4
        AllDockWidgetFeatures    : QDockWidget.DockWidgetFeature = ... # 0x7
        DockWidgetVerticalTitleBar: QDockWidget.DockWidgetFeature = ... # 0x8
        DockWidgetFeatureMask    : QDockWidget.DockWidgetFeature = ... # 0xf
        Reserved                 : QDockWidget.DockWidgetFeature = ... # 0xff

    class DockWidgetFeatures(object): ...

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...
    @typing.overload
    def __init__(self, title: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...


class QDoubleSpinBox(PySide2.QtWidgets.QAbstractSpinBox):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QErrorMessage(PySide2.QtWidgets.QDialog):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QFileDialog(PySide2.QtWidgets.QDialog):
    AcceptOpen               : QFileDialog.AcceptMode = ... # 0x0
    AcceptSave               : QFileDialog.AcceptMode = ... # 0x1
    LookIn                   : QFileDialog.DialogLabel = ... # 0x0
    FileName                 : QFileDialog.DialogLabel = ... # 0x1
    FileType                 : QFileDialog.DialogLabel = ... # 0x2
    Accept                   : QFileDialog.DialogLabel = ... # 0x3
    Reject                   : QFileDialog.DialogLabel = ... # 0x4
    AnyFile                  : QFileDialog.FileMode = ... # 0x0
    ExistingFile             : QFileDialog.FileMode = ... # 0x1
    Directory                : QFileDialog.FileMode = ... # 0x2
    ExistingFiles            : QFileDialog.FileMode = ... # 0x3
    DirectoryOnly            : QFileDialog.FileMode = ... # 0x4
    ShowDirsOnly             : QFileDialog.Option = ... # 0x1
    DontResolveSymlinks      : QFileDialog.Option = ... # 0x2
    DontConfirmOverwrite     : QFileDialog.Option = ... # 0x4
    DontUseSheet             : QFileDialog.Option = ... # 0x8
    DontUseNativeDialog      : QFileDialog.Option = ... # 0x10
    ReadOnly                 : QFileDialog.Option = ... # 0x20
    HideNameFilterDetails    : QFileDialog.Option = ... # 0x40
    DontUseCustomDirectoryIcons: QFileDialog.Option = ... # 0x80
    Detail                   : QFileDialog.ViewMode = ... # 0x0
    List                     : QFileDialog.ViewMode = ... # 0x1

    class AcceptMode(Shiboken.Enum):
        AcceptOpen               : QFileDialog.AcceptMode = ... # 0x0
        AcceptSave               : QFileDialog.AcceptMode = ... # 0x1

    class DialogLabel(Shiboken.Enum):
        LookIn                   : QFileDialog.DialogLabel = ... # 0x0
        FileName                 : QFileDialog.DialogLabel = ... # 0x1
        FileType                 : QFileDialog.DialogLabel = ... # 0x2
        Accept                   : QFileDialog.DialogLabel = ... # 0x3
        Reject                   : QFileDialog.DialogLabel = ... # 0x4

    class FileMode(Shiboken.Enum):
        AnyFile                  : QFileDialog.FileMode = ... # 0x0
        ExistingFile             : QFileDialog.FileMode = ... # 0x1
        Directory                : QFileDialog.FileMode = ... # 0x2
        ExistingFiles            : QFileDialog.FileMode = ... # 0x3
        DirectoryOnly            : QFileDialog.FileMode = ... # 0x4

    class Option(Shiboken.Enum):
        ShowDirsOnly             : QFileDialog.Option = ... # 0x1
        DontResolveSymlinks      : QFileDialog.Option = ... # 0x2
        DontConfirmOverwrite     : QFileDialog.Option = ... # 0x4
        DontUseSheet             : QFileDialog.Option = ... # 0x8
        DontUseNativeDialog      : QFileDialog.Option = ... # 0x10
        ReadOnly                 : QFileDialog.Option = ... # 0x20
        HideNameFilterDetails    : QFileDialog.Option = ... # 0x40
        DontUseCustomDirectoryIcons: QFileDialog.Option = ... # 0x80

    class Options(object): ...

    class ViewMode(Shiboken.Enum):
        Detail                   : QFileDialog.ViewMode = ... # 0x0
        List                     : QFileDialog.ViewMode = ... # 0x1

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget, f: PySide2.QtCore.Qt.WindowFlags) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., caption: str = ..., directory: str = ..., filter: str = ...) -> None: ...


class QFileIconProvider(Shiboken.Object):
    Computer                 : QFileIconProvider.IconType = ... # 0x0
    Desktop                  : QFileIconProvider.IconType = ... # 0x1
    Trashcan                 : QFileIconProvider.IconType = ... # 0x2
    Network                  : QFileIconProvider.IconType = ... # 0x3
    Drive                    : QFileIconProvider.IconType = ... # 0x4
    Folder                   : QFileIconProvider.IconType = ... # 0x5
    File                     : QFileIconProvider.IconType = ... # 0x6
    DontUseCustomDirectoryIcons: QFileIconProvider.Option = ... # 0x1

    class IconType(Shiboken.Enum):
        Computer                 : QFileIconProvider.IconType = ... # 0x0
        Desktop                  : QFileIconProvider.IconType = ... # 0x1
        Trashcan                 : QFileIconProvider.IconType = ... # 0x2
        Network                  : QFileIconProvider.IconType = ... # 0x3
        Drive                    : QFileIconProvider.IconType = ... # 0x4
        Folder                   : QFileIconProvider.IconType = ... # 0x5
        File                     : QFileIconProvider.IconType = ... # 0x6

    class Option(Shiboken.Enum):
        DontUseCustomDirectoryIcons: QFileIconProvider.Option = ... # 0x1

    class Options(object): ...

    def __init__(self) -> None: ...


class QFileSystemModel(PySide2.QtCore.QAbstractItemModel):
    DontWatchForChanges      : QFileSystemModel.Option = ... # 0x1
    DontResolveSymlinks      : QFileSystemModel.Option = ... # 0x2
    DontUseCustomDirectoryIcons: QFileSystemModel.Option = ... # 0x4
    FileIconRole             : QFileSystemModel.Roles = ... # 0x1
    FilePathRole             : QFileSystemModel.Roles = ... # 0x101
    FileNameRole             : QFileSystemModel.Roles = ... # 0x102
    FilePermissions          : QFileSystemModel.Roles = ... # 0x103

    class Option(Shiboken.Enum):
        DontWatchForChanges      : QFileSystemModel.Option = ... # 0x1
        DontResolveSymlinks      : QFileSystemModel.Option = ... # 0x2
        DontUseCustomDirectoryIcons: QFileSystemModel.Option = ... # 0x4

    class Options(object): ...

    class Roles(Shiboken.Enum):
        FileIconRole             : QFileSystemModel.Roles = ... # 0x1
        FilePathRole             : QFileSystemModel.Roles = ... # 0x101
        FileNameRole             : QFileSystemModel.Roles = ... # 0x102
        FilePermissions          : QFileSystemModel.Roles = ... # 0x103

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QFocusFrame(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QFontComboBox(PySide2.QtWidgets.QComboBox):
    AllFonts                 : QFontComboBox.FontFilter = ... # 0x0
    ScalableFonts            : QFontComboBox.FontFilter = ... # 0x1
    NonScalableFonts         : QFontComboBox.FontFilter = ... # 0x2
    MonospacedFonts          : QFontComboBox.FontFilter = ... # 0x4
    ProportionalFonts        : QFontComboBox.FontFilter = ... # 0x8

    class FontFilter(Shiboken.Enum):
        AllFonts                 : QFontComboBox.FontFilter = ... # 0x0
        ScalableFonts            : QFontComboBox.FontFilter = ... # 0x1
        NonScalableFonts         : QFontComboBox.FontFilter = ... # 0x2
        MonospacedFonts          : QFontComboBox.FontFilter = ... # 0x4
        ProportionalFonts        : QFontComboBox.FontFilter = ... # 0x8

    class FontFilters(object): ...

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QFontDialog(PySide2.QtWidgets.QDialog):
    NoButtons                : QFontDialog.FontDialogOption = ... # 0x1
    DontUseNativeDialog      : QFontDialog.FontDialogOption = ... # 0x2
    ScalableFonts            : QFontDialog.FontDialogOption = ... # 0x4
    NonScalableFonts         : QFontDialog.FontDialogOption = ... # 0x8
    MonospacedFonts          : QFontDialog.FontDialogOption = ... # 0x10
    ProportionalFonts        : QFontDialog.FontDialogOption = ... # 0x20

    class FontDialogOption(Shiboken.Enum):
        NoButtons                : QFontDialog.FontDialogOption = ... # 0x1
        DontUseNativeDialog      : QFontDialog.FontDialogOption = ... # 0x2
        ScalableFonts            : QFontDialog.FontDialogOption = ... # 0x4
        NonScalableFonts         : QFontDialog.FontDialogOption = ... # 0x8
        MonospacedFonts          : QFontDialog.FontDialogOption = ... # 0x10
        ProportionalFonts        : QFontDialog.FontDialogOption = ... # 0x20

    class FontDialogOptions(object): ...

    @typing.overload
    def __init__(self, initial: PySide2.QtGui.QFont, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QFormLayout(PySide2.QtWidgets.QLayout):
    FieldsStayAtSizeHint     : QFormLayout.FieldGrowthPolicy = ... # 0x0
    ExpandingFieldsGrow      : QFormLayout.FieldGrowthPolicy = ... # 0x1
    AllNonFixedFieldsGrow    : QFormLayout.FieldGrowthPolicy = ... # 0x2
    LabelRole                : QFormLayout.ItemRole = ... # 0x0
    FieldRole                : QFormLayout.ItemRole = ... # 0x1
    SpanningRole             : QFormLayout.ItemRole = ... # 0x2
    DontWrapRows             : QFormLayout.RowWrapPolicy = ... # 0x0
    WrapLongRows             : QFormLayout.RowWrapPolicy = ... # 0x1
    WrapAllRows              : QFormLayout.RowWrapPolicy = ... # 0x2

    class FieldGrowthPolicy(Shiboken.Enum):
        FieldsStayAtSizeHint     : QFormLayout.FieldGrowthPolicy = ... # 0x0
        ExpandingFieldsGrow      : QFormLayout.FieldGrowthPolicy = ... # 0x1
        AllNonFixedFieldsGrow    : QFormLayout.FieldGrowthPolicy = ... # 0x2

    class ItemRole(Shiboken.Enum):
        LabelRole                : QFormLayout.ItemRole = ... # 0x0
        FieldRole                : QFormLayout.ItemRole = ... # 0x1
        SpanningRole             : QFormLayout.ItemRole = ... # 0x2

    class RowWrapPolicy(Shiboken.Enum):
        DontWrapRows             : QFormLayout.RowWrapPolicy = ... # 0x0
        WrapLongRows             : QFormLayout.RowWrapPolicy = ... # 0x1
        WrapAllRows              : QFormLayout.RowWrapPolicy = ... # 0x2

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QFrame(PySide2.QtWidgets.QWidget):
    Plain                    : QFrame.Shadow = ... # 0x10
    Raised                   : QFrame.Shadow = ... # 0x20
    Sunken                   : QFrame.Shadow = ... # 0x30
    NoFrame                  : QFrame.Shape = ... # 0x0
    Box                      : QFrame.Shape = ... # 0x1
    Panel                    : QFrame.Shape = ... # 0x2
    WinPanel                 : QFrame.Shape = ... # 0x3
    HLine                    : QFrame.Shape = ... # 0x4
    VLine                    : QFrame.Shape = ... # 0x5
    StyledPanel              : QFrame.Shape = ... # 0x6
    Shape_Mask               : QFrame.StyleMask = ... # 0xf
    Shadow_Mask              : QFrame.StyleMask = ... # 0xf0

    class Shadow(Shiboken.Enum):
        Plain                    : QFrame.Shadow = ... # 0x10
        Raised                   : QFrame.Shadow = ... # 0x20
        Sunken                   : QFrame.Shadow = ... # 0x30

    class Shape(Shiboken.Enum):
        NoFrame                  : QFrame.Shape = ... # 0x0
        Box                      : QFrame.Shape = ... # 0x1
        Panel                    : QFrame.Shape = ... # 0x2
        WinPanel                 : QFrame.Shape = ... # 0x3
        HLine                    : QFrame.Shape = ... # 0x4
        VLine                    : QFrame.Shape = ... # 0x5
        StyledPanel              : QFrame.Shape = ... # 0x6

    class StyleMask(Shiboken.Enum):
        Shape_Mask               : QFrame.StyleMask = ... # 0xf
        Shadow_Mask              : QFrame.StyleMask = ... # 0xf0

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., f: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...


class QGesture(PySide2.QtCore.QObject):
    CancelNone               : QGesture.GestureCancelPolicy = ... # 0x0
    CancelAllInContext       : QGesture.GestureCancelPolicy = ... # 0x1

    class GestureCancelPolicy(Shiboken.Enum):
        CancelNone               : QGesture.GestureCancelPolicy = ... # 0x0
        CancelAllInContext       : QGesture.GestureCancelPolicy = ... # 0x1

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QGestureEvent(PySide2.QtCore.QEvent):

    def __init__(self, gestures: typing.Sequence[PySide2.QtWidgets.QGesture]) -> None: ...


class QGestureRecognizer(Shiboken.Object):
    Ignore                   : QGestureRecognizer.ResultFlag = ... # 0x1
    MayBeGesture             : QGestureRecognizer.ResultFlag = ... # 0x2
    TriggerGesture           : QGestureRecognizer.ResultFlag = ... # 0x4
    FinishGesture            : QGestureRecognizer.ResultFlag = ... # 0x8
    CancelGesture            : QGestureRecognizer.ResultFlag = ... # 0x10
    ResultState_Mask         : QGestureRecognizer.ResultFlag = ... # 0xff
    ConsumeEventHint         : QGestureRecognizer.ResultFlag = ... # 0x100
    ResultHint_Mask          : QGestureRecognizer.ResultFlag = ... # 0xff00

    class Result(object): ...

    class ResultFlag(Shiboken.Enum):
        Ignore                   : QGestureRecognizer.ResultFlag = ... # 0x1
        MayBeGesture             : QGestureRecognizer.ResultFlag = ... # 0x2
        TriggerGesture           : QGestureRecognizer.ResultFlag = ... # 0x4
        FinishGesture            : QGestureRecognizer.ResultFlag = ... # 0x8
        CancelGesture            : QGestureRecognizer.ResultFlag = ... # 0x10
        ResultState_Mask         : QGestureRecognizer.ResultFlag = ... # 0xff
        ConsumeEventHint         : QGestureRecognizer.ResultFlag = ... # 0x100
        ResultHint_Mask          : QGestureRecognizer.ResultFlag = ... # 0xff00

    def __init__(self) -> None: ...


class QGraphicsAnchor(PySide2.QtCore.QObject): ...


class QGraphicsAnchorLayout(PySide2.QtWidgets.QGraphicsLayout):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsLayoutItem] = ...) -> None: ...


class QGraphicsBlurEffect(PySide2.QtWidgets.QGraphicsEffect):
    PerformanceHint          : QGraphicsBlurEffect.BlurHint = ... # 0x0
    QualityHint              : QGraphicsBlurEffect.BlurHint = ... # 0x1
    AnimationHint            : QGraphicsBlurEffect.BlurHint = ... # 0x2

    class BlurHint(Shiboken.Enum):
        PerformanceHint          : QGraphicsBlurEffect.BlurHint = ... # 0x0
        QualityHint              : QGraphicsBlurEffect.BlurHint = ... # 0x1
        AnimationHint            : QGraphicsBlurEffect.BlurHint = ... # 0x2

    class BlurHints(object): ...

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QGraphicsColorizeEffect(PySide2.QtWidgets.QGraphicsEffect):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QGraphicsDropShadowEffect(PySide2.QtWidgets.QGraphicsEffect):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QGraphicsEffect(PySide2.QtCore.QObject):
    SourceAttached           : QGraphicsEffect.ChangeFlag = ... # 0x1
    SourceDetached           : QGraphicsEffect.ChangeFlag = ... # 0x2
    SourceBoundingRectChanged: QGraphicsEffect.ChangeFlag = ... # 0x4
    SourceInvalidated        : QGraphicsEffect.ChangeFlag = ... # 0x8
    NoPad                    : QGraphicsEffect.PixmapPadMode = ... # 0x0
    PadToTransparentBorder   : QGraphicsEffect.PixmapPadMode = ... # 0x1
    PadToEffectiveBoundingRect: QGraphicsEffect.PixmapPadMode = ... # 0x2

    class ChangeFlag(Shiboken.Enum):
        SourceAttached           : QGraphicsEffect.ChangeFlag = ... # 0x1
        SourceDetached           : QGraphicsEffect.ChangeFlag = ... # 0x2
        SourceBoundingRectChanged: QGraphicsEffect.ChangeFlag = ... # 0x4
        SourceInvalidated        : QGraphicsEffect.ChangeFlag = ... # 0x8

    class ChangeFlags(object): ...

    class PixmapPadMode(Shiboken.Enum):
        NoPad                    : QGraphicsEffect.PixmapPadMode = ... # 0x0
        PadToTransparentBorder   : QGraphicsEffect.PixmapPadMode = ... # 0x1
        PadToEffectiveBoundingRect: QGraphicsEffect.PixmapPadMode = ... # 0x2

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QGraphicsEllipseItem(PySide2.QtWidgets.QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @typing.overload
    def __init__(self, rect: PySide2.QtCore.QRectF, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @typing.overload
    def __init__(self, x: float, y: float, w: float, h: float, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...


class QGraphicsGridLayout(PySide2.QtWidgets.QGraphicsLayout):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsLayoutItem] = ...) -> None: ...


class QGraphicsItem(Shiboken.Object):
    NoCache                  : QGraphicsItem.CacheMode = ... # 0x0
    ItemCoordinateCache      : QGraphicsItem.CacheMode = ... # 0x1
    DeviceCoordinateCache    : QGraphicsItem.CacheMode = ... # 0x2
    UserExtension            : QGraphicsItem.Extension = ... # 0x80000000
    ItemPositionChange       : QGraphicsItem.GraphicsItemChange = ... # 0x0
    ItemMatrixChange         : QGraphicsItem.GraphicsItemChange = ... # 0x1
    ItemVisibleChange        : QGraphicsItem.GraphicsItemChange = ... # 0x2
    ItemEnabledChange        : QGraphicsItem.GraphicsItemChange = ... # 0x3
    ItemSelectedChange       : QGraphicsItem.GraphicsItemChange = ... # 0x4
    ItemParentChange         : QGraphicsItem.GraphicsItemChange = ... # 0x5
    ItemChildAddedChange     : QGraphicsItem.GraphicsItemChange = ... # 0x6
    ItemChildRemovedChange   : QGraphicsItem.GraphicsItemChange = ... # 0x7
    ItemTransformChange      : QGraphicsItem.GraphicsItemChange = ... # 0x8
    ItemPositionHasChanged   : QGraphicsItem.GraphicsItemChange = ... # 0x9
    ItemTransformHasChanged  : QGraphicsItem.GraphicsItemChange = ... # 0xa
    ItemSceneChange          : QGraphicsItem.GraphicsItemChange = ... # 0xb
    ItemVisibleHasChanged    : QGraphicsItem.GraphicsItemChange = ... # 0xc
    ItemEnabledHasChanged    : QGraphicsItem.GraphicsItemChange = ... # 0xd
    ItemSelectedHasChanged   : QGraphicsItem.GraphicsItemChange = ... # 0xe
    ItemParentHasChanged     : QGraphicsItem.GraphicsItemChange = ... # 0xf
    ItemSceneHasChanged      : QGraphicsItem.GraphicsItemChange = ... # 0x10
    ItemCursorChange         : QGraphicsItem.GraphicsItemChange = ... # 0x11
    ItemCursorHasChanged     : QGraphicsItem.GraphicsItemChange = ... # 0x12
    ItemToolTipChange        : QGraphicsItem.GraphicsItemChange = ... # 0x13
    ItemToolTipHasChanged    : QGraphicsItem.GraphicsItemChange = ... # 0x14
    ItemFlagsChange          : QGraphicsItem.GraphicsItemChange = ... # 0x15
    ItemFlagsHaveChanged     : QGraphicsItem.GraphicsItemChange = ... # 0x16
    ItemZValueChange         : QGraphicsItem.GraphicsItemChange = ... # 0x17
    ItemZValueHasChanged     : QGraphicsItem.GraphicsItemChange = ... # 0x18
    ItemOpacityChange        : QGraphicsItem.GraphicsItemChange = ... # 0x19
    ItemOpacityHasChanged    : QGraphicsItem.GraphicsItemChange = ... # 0x1a
    ItemScenePositionHasChanged: QGraphicsItem.GraphicsItemChange = ... # 0x1b
    ItemRotationChange       : QGraphicsItem.GraphicsItemChange = ... # 0x1c
    ItemRotationHasChanged   : QGraphicsItem.GraphicsItemChange = ... # 0x1d
    ItemScaleChange          : QGraphicsItem.GraphicsItemChange = ... # 0x1e
    ItemScaleHasChanged      : QGraphicsItem.GraphicsItemChange = ... # 0x1f
    ItemTransformOriginPointChange: QGraphicsItem.GraphicsItemChange = ... # 0x20
    ItemTransformOriginPointHasChanged: QGraphicsItem.GraphicsItemChange = ... # 0x21
    ItemIsMovable            : QGraphicsItem.GraphicsItemFlag = ... # 0x1
    ItemIsSelectable         : QGraphicsItem.GraphicsItemFlag = ... # 0x2
    ItemIsFocusable          : QGraphicsItem.GraphicsItemFlag = ... # 0x4
    ItemClipsToShape         : QGraphicsItem.GraphicsItemFlag = ... # 0x8
    ItemClipsChildrenToShape : QGraphicsItem.GraphicsItemFlag = ... # 0x10
    ItemIgnoresTransformations: QGraphicsItem.GraphicsItemFlag = ... # 0x20
    ItemIgnoresParentOpacity : QGraphicsItem.GraphicsItemFlag = ... # 0x40
    ItemDoesntPropagateOpacityToChildren: QGraphicsItem.GraphicsItemFlag = ... # 0x80
    ItemStacksBehindParent   : QGraphicsItem.GraphicsItemFlag = ... # 0x100
    ItemUsesExtendedStyleOption: QGraphicsItem.GraphicsItemFlag = ... # 0x200
    ItemHasNoContents        : QGraphicsItem.GraphicsItemFlag = ... # 0x400
    ItemSendsGeometryChanges : QGraphicsItem.GraphicsItemFlag = ... # 0x800
    ItemAcceptsInputMethod   : QGraphicsItem.GraphicsItemFlag = ... # 0x1000
    ItemNegativeZStacksBehindParent: QGraphicsItem.GraphicsItemFlag = ... # 0x2000
    ItemIsPanel              : QGraphicsItem.GraphicsItemFlag = ... # 0x4000
    ItemIsFocusScope         : QGraphicsItem.GraphicsItemFlag = ... # 0x8000
    ItemSendsScenePositionChanges: QGraphicsItem.GraphicsItemFlag = ... # 0x10000
    ItemStopsClickFocusPropagation: QGraphicsItem.GraphicsItemFlag = ... # 0x20000
    ItemStopsFocusHandling   : QGraphicsItem.GraphicsItemFlag = ... # 0x40000
    ItemContainsChildrenInShape: QGraphicsItem.GraphicsItemFlag = ... # 0x80000
    NonModal                 : QGraphicsItem.PanelModality = ... # 0x0
    PanelModal               : QGraphicsItem.PanelModality = ... # 0x1
    SceneModal               : QGraphicsItem.PanelModality = ... # 0x2

    class CacheMode(Shiboken.Enum):
        NoCache                  : QGraphicsItem.CacheMode = ... # 0x0
        ItemCoordinateCache      : QGraphicsItem.CacheMode = ... # 0x1
        DeviceCoordinateCache    : QGraphicsItem.CacheMode = ... # 0x2

    class Extension(Shiboken.Enum):
        UserExtension            : QGraphicsItem.Extension = ... # 0x80000000

    class GraphicsItemChange(Shiboken.Enum):
        ItemPositionChange       : QGraphicsItem.GraphicsItemChange = ... # 0x0
        ItemMatrixChange         : QGraphicsItem.GraphicsItemChange = ... # 0x1
        ItemVisibleChange        : QGraphicsItem.GraphicsItemChange = ... # 0x2
        ItemEnabledChange        : QGraphicsItem.GraphicsItemChange = ... # 0x3
        ItemSelectedChange       : QGraphicsItem.GraphicsItemChange = ... # 0x4
        ItemParentChange         : QGraphicsItem.GraphicsItemChange = ... # 0x5
        ItemChildAddedChange     : QGraphicsItem.GraphicsItemChange = ... # 0x6
        ItemChildRemovedChange   : QGraphicsItem.GraphicsItemChange = ... # 0x7
        ItemTransformChange      : QGraphicsItem.GraphicsItemChange = ... # 0x8
        ItemPositionHasChanged   : QGraphicsItem.GraphicsItemChange = ... # 0x9
        ItemTransformHasChanged  : QGraphicsItem.GraphicsItemChange = ... # 0xa
        ItemSceneChange          : QGraphicsItem.GraphicsItemChange = ... # 0xb
        ItemVisibleHasChanged    : QGraphicsItem.GraphicsItemChange = ... # 0xc
        ItemEnabledHasChanged    : QGraphicsItem.GraphicsItemChange = ... # 0xd
        ItemSelectedHasChanged   : QGraphicsItem.GraphicsItemChange = ... # 0xe
        ItemParentHasChanged     : QGraphicsItem.GraphicsItemChange = ... # 0xf
        ItemSceneHasChanged      : QGraphicsItem.GraphicsItemChange = ... # 0x10
        ItemCursorChange         : QGraphicsItem.GraphicsItemChange = ... # 0x11
        ItemCursorHasChanged     : QGraphicsItem.GraphicsItemChange = ... # 0x12
        ItemToolTipChange        : QGraphicsItem.GraphicsItemChange = ... # 0x13
        ItemToolTipHasChanged    : QGraphicsItem.GraphicsItemChange = ... # 0x14
        ItemFlagsChange          : QGraphicsItem.GraphicsItemChange = ... # 0x15
        ItemFlagsHaveChanged     : QGraphicsItem.GraphicsItemChange = ... # 0x16
        ItemZValueChange         : QGraphicsItem.GraphicsItemChange = ... # 0x17
        ItemZValueHasChanged     : QGraphicsItem.GraphicsItemChange = ... # 0x18
        ItemOpacityChange        : QGraphicsItem.GraphicsItemChange = ... # 0x19
        ItemOpacityHasChanged    : QGraphicsItem.GraphicsItemChange = ... # 0x1a
        ItemScenePositionHasChanged: QGraphicsItem.GraphicsItemChange = ... # 0x1b
        ItemRotationChange       : QGraphicsItem.GraphicsItemChange = ... # 0x1c
        ItemRotationHasChanged   : QGraphicsItem.GraphicsItemChange = ... # 0x1d
        ItemScaleChange          : QGraphicsItem.GraphicsItemChange = ... # 0x1e
        ItemScaleHasChanged      : QGraphicsItem.GraphicsItemChange = ... # 0x1f
        ItemTransformOriginPointChange: QGraphicsItem.GraphicsItemChange = ... # 0x20
        ItemTransformOriginPointHasChanged: QGraphicsItem.GraphicsItemChange = ... # 0x21

    class GraphicsItemFlag(Shiboken.Enum):
        ItemIsMovable            : QGraphicsItem.GraphicsItemFlag = ... # 0x1
        ItemIsSelectable         : QGraphicsItem.GraphicsItemFlag = ... # 0x2
        ItemIsFocusable          : QGraphicsItem.GraphicsItemFlag = ... # 0x4
        ItemClipsToShape         : QGraphicsItem.GraphicsItemFlag = ... # 0x8
        ItemClipsChildrenToShape : QGraphicsItem.GraphicsItemFlag = ... # 0x10
        ItemIgnoresTransformations: QGraphicsItem.GraphicsItemFlag = ... # 0x20
        ItemIgnoresParentOpacity : QGraphicsItem.GraphicsItemFlag = ... # 0x40
        ItemDoesntPropagateOpacityToChildren: QGraphicsItem.GraphicsItemFlag = ... # 0x80
        ItemStacksBehindParent   : QGraphicsItem.GraphicsItemFlag = ... # 0x100
        ItemUsesExtendedStyleOption: QGraphicsItem.GraphicsItemFlag = ... # 0x200
        ItemHasNoContents        : QGraphicsItem.GraphicsItemFlag = ... # 0x400
        ItemSendsGeometryChanges : QGraphicsItem.GraphicsItemFlag = ... # 0x800
        ItemAcceptsInputMethod   : QGraphicsItem.GraphicsItemFlag = ... # 0x1000
        ItemNegativeZStacksBehindParent: QGraphicsItem.GraphicsItemFlag = ... # 0x2000
        ItemIsPanel              : QGraphicsItem.GraphicsItemFlag = ... # 0x4000
        ItemIsFocusScope         : QGraphicsItem.GraphicsItemFlag = ... # 0x8000
        ItemSendsScenePositionChanges: QGraphicsItem.GraphicsItemFlag = ... # 0x10000
        ItemStopsClickFocusPropagation: QGraphicsItem.GraphicsItemFlag = ... # 0x20000
        ItemStopsFocusHandling   : QGraphicsItem.GraphicsItemFlag = ... # 0x40000
        ItemContainsChildrenInShape: QGraphicsItem.GraphicsItemFlag = ... # 0x80000

    class GraphicsItemFlags(object): ...

    class PanelModality(Shiboken.Enum):
        NonModal                 : QGraphicsItem.PanelModality = ... # 0x0
        PanelModal               : QGraphicsItem.PanelModality = ... # 0x1
        SceneModal               : QGraphicsItem.PanelModality = ... # 0x2

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...


class QGraphicsItemAnimation(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QGraphicsItemGroup(PySide2.QtWidgets.QGraphicsItem):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...


class QGraphicsLayout(PySide2.QtWidgets.QGraphicsLayoutItem):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsLayoutItem] = ...) -> None: ...


class QGraphicsLayoutItem(Shiboken.Object):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsLayoutItem] = ..., isLayout: bool = ...) -> None: ...


class QGraphicsLineItem(PySide2.QtWidgets.QGraphicsItem):

    @typing.overload
    def __init__(self, line: PySide2.QtCore.QLineF, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @typing.overload
    def __init__(self, x1: float, y1: float, x2: float, y2: float, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...


class QGraphicsLinearLayout(PySide2.QtWidgets.QGraphicsLayout):

    @typing.overload
    def __init__(self, orientation: PySide2.QtCore.Qt.Orientation, parent: typing.Optional[PySide2.QtWidgets.QGraphicsLayoutItem] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsLayoutItem] = ...) -> None: ...


class QGraphicsObject(PySide2.QtWidgets.QGraphicsItem, PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...


class QGraphicsOpacityEffect(PySide2.QtWidgets.QGraphicsEffect):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QGraphicsPathItem(PySide2.QtWidgets.QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @typing.overload
    def __init__(self, path: PySide2.QtGui.QPainterPath, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...


class QGraphicsPixmapItem(PySide2.QtWidgets.QGraphicsItem):
    MaskShape                : QGraphicsPixmapItem.ShapeMode = ... # 0x0
    BoundingRectShape        : QGraphicsPixmapItem.ShapeMode = ... # 0x1
    HeuristicMaskShape       : QGraphicsPixmapItem.ShapeMode = ... # 0x2

    class ShapeMode(Shiboken.Enum):
        MaskShape                : QGraphicsPixmapItem.ShapeMode = ... # 0x0
        BoundingRectShape        : QGraphicsPixmapItem.ShapeMode = ... # 0x1
        HeuristicMaskShape       : QGraphicsPixmapItem.ShapeMode = ... # 0x2

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @typing.overload
    def __init__(self, pixmap: PySide2.QtGui.QPixmap, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...


class QGraphicsPolygonItem(PySide2.QtWidgets.QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @typing.overload
    def __init__(self, polygon: PySide2.QtGui.QPolygonF, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...


class QGraphicsProxyWidget(PySide2.QtWidgets.QGraphicsWidget):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ..., wFlags: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...


class QGraphicsRectItem(PySide2.QtWidgets.QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @typing.overload
    def __init__(self, rect: PySide2.QtCore.QRectF, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @typing.overload
    def __init__(self, x: float, y: float, w: float, h: float, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...


class QGraphicsRotation(PySide2.QtWidgets.QGraphicsTransform):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QGraphicsScale(PySide2.QtWidgets.QGraphicsTransform):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QGraphicsScene(PySide2.QtCore.QObject):
    NoIndex                  : QGraphicsScene.ItemIndexMethod = ... # -0x1
    BspTreeIndex             : QGraphicsScene.ItemIndexMethod = ... # 0x0
    ItemLayer                : QGraphicsScene.SceneLayer = ... # 0x1
    BackgroundLayer          : QGraphicsScene.SceneLayer = ... # 0x2
    ForegroundLayer          : QGraphicsScene.SceneLayer = ... # 0x4
    AllLayers                : QGraphicsScene.SceneLayer = ... # 0xffff

    class ItemIndexMethod(Shiboken.Enum):
        NoIndex                  : QGraphicsScene.ItemIndexMethod = ... # -0x1
        BspTreeIndex             : QGraphicsScene.ItemIndexMethod = ... # 0x0

    class SceneLayer(Shiboken.Enum):
        ItemLayer                : QGraphicsScene.SceneLayer = ... # 0x1
        BackgroundLayer          : QGraphicsScene.SceneLayer = ... # 0x2
        ForegroundLayer          : QGraphicsScene.SceneLayer = ... # 0x4
        AllLayers                : QGraphicsScene.SceneLayer = ... # 0xffff

    class SceneLayers(object): ...

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, sceneRect: PySide2.QtCore.QRectF, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, x: float, y: float, width: float, height: float, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QGraphicsSceneContextMenuEvent(PySide2.QtWidgets.QGraphicsSceneEvent):
    Mouse                    : QGraphicsSceneContextMenuEvent.Reason = ... # 0x0
    Keyboard                 : QGraphicsSceneContextMenuEvent.Reason = ... # 0x1
    Other                    : QGraphicsSceneContextMenuEvent.Reason = ... # 0x2

    class Reason(Shiboken.Enum):
        Mouse                    : QGraphicsSceneContextMenuEvent.Reason = ... # 0x0
        Keyboard                 : QGraphicsSceneContextMenuEvent.Reason = ... # 0x1
        Other                    : QGraphicsSceneContextMenuEvent.Reason = ... # 0x2

    def __init__(self, type: typing.Optional[PySide2.QtCore.QEvent.Type] = ...) -> None: ...


class QGraphicsSceneDragDropEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, type: typing.Optional[PySide2.QtCore.QEvent.Type] = ...) -> None: ...


class QGraphicsSceneEvent(PySide2.QtCore.QEvent):

    def __init__(self, type: PySide2.QtCore.QEvent.Type) -> None: ...


class QGraphicsSceneHelpEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, type: typing.Optional[PySide2.QtCore.QEvent.Type] = ...) -> None: ...


class QGraphicsSceneHoverEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, type: typing.Optional[PySide2.QtCore.QEvent.Type] = ...) -> None: ...


class QGraphicsSceneMouseEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, type: typing.Optional[PySide2.QtCore.QEvent.Type] = ...) -> None: ...


class QGraphicsSceneMoveEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self) -> None: ...


class QGraphicsSceneResizeEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self) -> None: ...


class QGraphicsSceneWheelEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, type: typing.Optional[PySide2.QtCore.QEvent.Type] = ...) -> None: ...


class QGraphicsSimpleTextItem(PySide2.QtWidgets.QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...


class QGraphicsTextItem(PySide2.QtWidgets.QGraphicsObject):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...


class QGraphicsTransform(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QGraphicsView(PySide2.QtWidgets.QAbstractScrollArea):
    CacheNone                : QGraphicsView.CacheModeFlag = ... # 0x0
    CacheBackground          : QGraphicsView.CacheModeFlag = ... # 0x1
    NoDrag                   : QGraphicsView.DragMode = ... # 0x0
    ScrollHandDrag           : QGraphicsView.DragMode = ... # 0x1
    RubberBandDrag           : QGraphicsView.DragMode = ... # 0x2
    DontClipPainter          : QGraphicsView.OptimizationFlag = ... # 0x1
    DontSavePainterState     : QGraphicsView.OptimizationFlag = ... # 0x2
    DontAdjustForAntialiasing: QGraphicsView.OptimizationFlag = ... # 0x4
    IndirectPainting         : QGraphicsView.OptimizationFlag = ... # 0x8
    NoAnchor                 : QGraphicsView.ViewportAnchor = ... # 0x0
    AnchorViewCenter         : QGraphicsView.ViewportAnchor = ... # 0x1
    AnchorUnderMouse         : QGraphicsView.ViewportAnchor = ... # 0x2
    FullViewportUpdate       : QGraphicsView.ViewportUpdateMode = ... # 0x0
    MinimalViewportUpdate    : QGraphicsView.ViewportUpdateMode = ... # 0x1
    SmartViewportUpdate      : QGraphicsView.ViewportUpdateMode = ... # 0x2
    NoViewportUpdate         : QGraphicsView.ViewportUpdateMode = ... # 0x3
    BoundingRectViewportUpdate: QGraphicsView.ViewportUpdateMode = ... # 0x4

    class CacheMode(object): ...

    class CacheModeFlag(Shiboken.Enum):
        CacheNone                : QGraphicsView.CacheModeFlag = ... # 0x0
        CacheBackground          : QGraphicsView.CacheModeFlag = ... # 0x1

    class DragMode(Shiboken.Enum):
        NoDrag                   : QGraphicsView.DragMode = ... # 0x0
        ScrollHandDrag           : QGraphicsView.DragMode = ... # 0x1
        RubberBandDrag           : QGraphicsView.DragMode = ... # 0x2

    class OptimizationFlag(Shiboken.Enum):
        DontClipPainter          : QGraphicsView.OptimizationFlag = ... # 0x1
        DontSavePainterState     : QGraphicsView.OptimizationFlag = ... # 0x2
        DontAdjustForAntialiasing: QGraphicsView.OptimizationFlag = ... # 0x4
        IndirectPainting         : QGraphicsView.OptimizationFlag = ... # 0x8

    class OptimizationFlags(object): ...

    class ViewportAnchor(Shiboken.Enum):
        NoAnchor                 : QGraphicsView.ViewportAnchor = ... # 0x0
        AnchorViewCenter         : QGraphicsView.ViewportAnchor = ... # 0x1
        AnchorUnderMouse         : QGraphicsView.ViewportAnchor = ... # 0x2

    class ViewportUpdateMode(Shiboken.Enum):
        FullViewportUpdate       : QGraphicsView.ViewportUpdateMode = ... # 0x0
        MinimalViewportUpdate    : QGraphicsView.ViewportUpdateMode = ... # 0x1
        SmartViewportUpdate      : QGraphicsView.ViewportUpdateMode = ... # 0x2
        NoViewportUpdate         : QGraphicsView.ViewportUpdateMode = ... # 0x3
        BoundingRectViewportUpdate: QGraphicsView.ViewportUpdateMode = ... # 0x4

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, scene: PySide2.QtWidgets.QGraphicsScene, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QGraphicsWidget(PySide2.QtWidgets.QGraphicsObject, PySide2.QtWidgets.QGraphicsLayoutItem):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ..., wFlags: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...


class QGridLayout(PySide2.QtWidgets.QLayout):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget) -> None: ...


class QGroupBox(PySide2.QtWidgets.QWidget):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, title: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QHBoxLayout(PySide2.QtWidgets.QBoxLayout):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget) -> None: ...


class QHeaderView(PySide2.QtWidgets.QAbstractItemView):
    Interactive              : QHeaderView.ResizeMode = ... # 0x0
    Stretch                  : QHeaderView.ResizeMode = ... # 0x1
    Custom                   : QHeaderView.ResizeMode = ... # 0x2
    Fixed                    : QHeaderView.ResizeMode = ... # 0x2
    ResizeToContents         : QHeaderView.ResizeMode = ... # 0x3

    class ResizeMode(Shiboken.Enum):
        Interactive              : QHeaderView.ResizeMode = ... # 0x0
        Stretch                  : QHeaderView.ResizeMode = ... # 0x1
        Custom                   : QHeaderView.ResizeMode = ... # 0x2
        Fixed                    : QHeaderView.ResizeMode = ... # 0x2
        ResizeToContents         : QHeaderView.ResizeMode = ... # 0x3

    def __init__(self, orientation: PySide2.QtCore.Qt.Orientation, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QInputDialog(PySide2.QtWidgets.QDialog):
    NoButtons                : QInputDialog.InputDialogOption = ... # 0x1
    UseListViewForComboBoxItems: QInputDialog.InputDialogOption = ... # 0x2
    UsePlainTextEditForTextInput: QInputDialog.InputDialogOption = ... # 0x4
    TextInput                : QInputDialog.InputMode = ... # 0x0
    IntInput                 : QInputDialog.InputMode = ... # 0x1
    DoubleInput              : QInputDialog.InputMode = ... # 0x2

    class InputDialogOption(Shiboken.Enum):
        NoButtons                : QInputDialog.InputDialogOption = ... # 0x1
        UseListViewForComboBoxItems: QInputDialog.InputDialogOption = ... # 0x2
        UsePlainTextEditForTextInput: QInputDialog.InputDialogOption = ... # 0x4

    class InputMode(Shiboken.Enum):
        TextInput                : QInputDialog.InputMode = ... # 0x0
        IntInput                 : QInputDialog.InputMode = ... # 0x1
        DoubleInput              : QInputDialog.InputMode = ... # 0x2

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...


class QItemDelegate(PySide2.QtWidgets.QAbstractItemDelegate):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QItemEditorCreatorBase(Shiboken.Object):

    def __init__(self) -> None: ...


class QItemEditorFactory(Shiboken.Object):

    def __init__(self) -> None: ...


class QKeyEventTransition(PySide2.QtCore.QEventTransition):

    @typing.overload
    def __init__(self, object: PySide2.QtCore.QObject, type: PySide2.QtCore.QEvent.Type, key: int, sourceState: typing.Optional[PySide2.QtCore.QState] = ...) -> None: ...
    @typing.overload
    def __init__(self, sourceState: typing.Optional[PySide2.QtCore.QState] = ...) -> None: ...


class QKeySequenceEdit(PySide2.QtWidgets.QWidget):

    @typing.overload
    def __init__(self, keySequence: PySide2.QtGui.QKeySequence, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QLCDNumber(PySide2.QtWidgets.QFrame):
    Hex                      : QLCDNumber.Mode = ... # 0x0
    Dec                      : QLCDNumber.Mode = ... # 0x1
    Oct                      : QLCDNumber.Mode = ... # 0x2
    Bin                      : QLCDNumber.Mode = ... # 0x3
    Outline                  : QLCDNumber.SegmentStyle = ... # 0x0
    Filled                   : QLCDNumber.SegmentStyle = ... # 0x1
    Flat                     : QLCDNumber.SegmentStyle = ... # 0x2

    class Mode(Shiboken.Enum):
        Hex                      : QLCDNumber.Mode = ... # 0x0
        Dec                      : QLCDNumber.Mode = ... # 0x1
        Oct                      : QLCDNumber.Mode = ... # 0x2
        Bin                      : QLCDNumber.Mode = ... # 0x3

    class SegmentStyle(Shiboken.Enum):
        Outline                  : QLCDNumber.SegmentStyle = ... # 0x0
        Filled                   : QLCDNumber.SegmentStyle = ... # 0x1
        Flat                     : QLCDNumber.SegmentStyle = ... # 0x2

    @typing.overload
    def __init__(self, numDigits: int, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QLabel(PySide2.QtWidgets.QFrame):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., f: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., f: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...


class QLayout(PySide2.QtCore.QObject, PySide2.QtWidgets.QLayoutItem):
    SetDefaultConstraint     : QLayout.SizeConstraint = ... # 0x0
    SetNoConstraint          : QLayout.SizeConstraint = ... # 0x1
    SetMinimumSize           : QLayout.SizeConstraint = ... # 0x2
    SetFixedSize             : QLayout.SizeConstraint = ... # 0x3
    SetMaximumSize           : QLayout.SizeConstraint = ... # 0x4
    SetMinAndMaxSize         : QLayout.SizeConstraint = ... # 0x5

    class SizeConstraint(Shiboken.Enum):
        SetDefaultConstraint     : QLayout.SizeConstraint = ... # 0x0
        SetNoConstraint          : QLayout.SizeConstraint = ... # 0x1
        SetMinimumSize           : QLayout.SizeConstraint = ... # 0x2
        SetFixedSize             : QLayout.SizeConstraint = ... # 0x3
        SetMaximumSize           : QLayout.SizeConstraint = ... # 0x4
        SetMinAndMaxSize         : QLayout.SizeConstraint = ... # 0x5

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget) -> None: ...


class QLayoutItem(Shiboken.Object):

    def __init__(self, alignment: PySide2.QtCore.Qt.Alignment = ...) -> None: ...


class QLineEdit(PySide2.QtWidgets.QWidget):
    LeadingPosition          : QLineEdit.ActionPosition = ... # 0x0
    TrailingPosition         : QLineEdit.ActionPosition = ... # 0x1
    Normal                   : QLineEdit.EchoMode = ... # 0x0
    NoEcho                   : QLineEdit.EchoMode = ... # 0x1
    Password                 : QLineEdit.EchoMode = ... # 0x2
    PasswordEchoOnEdit       : QLineEdit.EchoMode = ... # 0x3

    class ActionPosition(Shiboken.Enum):
        LeadingPosition          : QLineEdit.ActionPosition = ... # 0x0
        TrailingPosition         : QLineEdit.ActionPosition = ... # 0x1

    class EchoMode(Shiboken.Enum):
        Normal                   : QLineEdit.EchoMode = ... # 0x0
        NoEcho                   : QLineEdit.EchoMode = ... # 0x1
        Password                 : QLineEdit.EchoMode = ... # 0x2
        PasswordEchoOnEdit       : QLineEdit.EchoMode = ... # 0x3

    @typing.overload
    def __init__(self, arg__1: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QListView(PySide2.QtWidgets.QAbstractItemView):
    LeftToRight              : QListView.Flow = ... # 0x0
    TopToBottom              : QListView.Flow = ... # 0x1
    SinglePass               : QListView.LayoutMode = ... # 0x0
    Batched                  : QListView.LayoutMode = ... # 0x1
    Static                   : QListView.Movement = ... # 0x0
    Free                     : QListView.Movement = ... # 0x1
    Snap                     : QListView.Movement = ... # 0x2
    Fixed                    : QListView.ResizeMode = ... # 0x0
    Adjust                   : QListView.ResizeMode = ... # 0x1
    ListMode                 : QListView.ViewMode = ... # 0x0
    IconMode                 : QListView.ViewMode = ... # 0x1

    class Flow(Shiboken.Enum):
        LeftToRight              : QListView.Flow = ... # 0x0
        TopToBottom              : QListView.Flow = ... # 0x1

    class LayoutMode(Shiboken.Enum):
        SinglePass               : QListView.LayoutMode = ... # 0x0
        Batched                  : QListView.LayoutMode = ... # 0x1

    class Movement(Shiboken.Enum):
        Static                   : QListView.Movement = ... # 0x0
        Free                     : QListView.Movement = ... # 0x1
        Snap                     : QListView.Movement = ... # 0x2

    class ResizeMode(Shiboken.Enum):
        Fixed                    : QListView.ResizeMode = ... # 0x0
        Adjust                   : QListView.ResizeMode = ... # 0x1

    class ViewMode(Shiboken.Enum):
        ListMode                 : QListView.ViewMode = ... # 0x0
        IconMode                 : QListView.ViewMode = ... # 0x1

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QListWidget(PySide2.QtWidgets.QListView):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QListWidgetItem(Shiboken.Object):
    Type                     : QListWidgetItem.ItemType = ... # 0x0
    UserType                 : QListWidgetItem.ItemType = ... # 0x3e8

    class ItemType(Shiboken.Enum):
        Type                     : QListWidgetItem.ItemType = ... # 0x0
        UserType                 : QListWidgetItem.ItemType = ... # 0x3e8

    @typing.overload
    def __init__(self, icon: PySide2.QtGui.QIcon, text: str, listview: typing.Optional[PySide2.QtWidgets.QListWidget] = ..., type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, listview: typing.Optional[PySide2.QtWidgets.QListWidget] = ..., type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QListWidgetItem) -> None: ...
    @typing.overload
    def __init__(self, text: str, listview: typing.Optional[PySide2.QtWidgets.QListWidget] = ..., type: int = ...) -> None: ...


class QMainWindow(PySide2.QtWidgets.QWidget):
    AnimatedDocks            : QMainWindow.DockOption = ... # 0x1
    AllowNestedDocks         : QMainWindow.DockOption = ... # 0x2
    AllowTabbedDocks         : QMainWindow.DockOption = ... # 0x4
    ForceTabbedDocks         : QMainWindow.DockOption = ... # 0x8
    VerticalTabs             : QMainWindow.DockOption = ... # 0x10
    GroupedDragging          : QMainWindow.DockOption = ... # 0x20

    class DockOption(Shiboken.Enum):
        AnimatedDocks            : QMainWindow.DockOption = ... # 0x1
        AllowNestedDocks         : QMainWindow.DockOption = ... # 0x2
        AllowTabbedDocks         : QMainWindow.DockOption = ... # 0x4
        ForceTabbedDocks         : QMainWindow.DockOption = ... # 0x8
        VerticalTabs             : QMainWindow.DockOption = ... # 0x10
        GroupedDragging          : QMainWindow.DockOption = ... # 0x20

    class DockOptions(object): ...

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...


class QMdiArea(PySide2.QtWidgets.QAbstractScrollArea):
    DontMaximizeSubWindowOnActivation: QMdiArea.AreaOption = ... # 0x1
    SubWindowView            : QMdiArea.ViewMode = ... # 0x0
    TabbedView               : QMdiArea.ViewMode = ... # 0x1
    CreationOrder            : QMdiArea.WindowOrder = ... # 0x0
    StackingOrder            : QMdiArea.WindowOrder = ... # 0x1
    ActivationHistoryOrder   : QMdiArea.WindowOrder = ... # 0x2

    class AreaOption(Shiboken.Enum):
        DontMaximizeSubWindowOnActivation: QMdiArea.AreaOption = ... # 0x1

    class AreaOptions(object): ...

    class ViewMode(Shiboken.Enum):
        SubWindowView            : QMdiArea.ViewMode = ... # 0x0
        TabbedView               : QMdiArea.ViewMode = ... # 0x1

    class WindowOrder(Shiboken.Enum):
        CreationOrder            : QMdiArea.WindowOrder = ... # 0x0
        StackingOrder            : QMdiArea.WindowOrder = ... # 0x1
        ActivationHistoryOrder   : QMdiArea.WindowOrder = ... # 0x2

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QMdiSubWindow(PySide2.QtWidgets.QWidget):
    AllowOutsideAreaHorizontally: QMdiSubWindow.SubWindowOption = ... # 0x1
    AllowOutsideAreaVertically: QMdiSubWindow.SubWindowOption = ... # 0x2
    RubberBandResize         : QMdiSubWindow.SubWindowOption = ... # 0x4
    RubberBandMove           : QMdiSubWindow.SubWindowOption = ... # 0x8

    class SubWindowOption(Shiboken.Enum):
        AllowOutsideAreaHorizontally: QMdiSubWindow.SubWindowOption = ... # 0x1
        AllowOutsideAreaVertically: QMdiSubWindow.SubWindowOption = ... # 0x2
        RubberBandResize         : QMdiSubWindow.SubWindowOption = ... # 0x4
        RubberBandMove           : QMdiSubWindow.SubWindowOption = ... # 0x8

    class SubWindowOptions(object): ...

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...


class QMenu(PySide2.QtWidgets.QWidget):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, title: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QMenuBar(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QMessageBox(PySide2.QtWidgets.QDialog):
    InvalidRole              : QMessageBox.ButtonRole = ... # -0x1
    AcceptRole               : QMessageBox.ButtonRole = ... # 0x0
    RejectRole               : QMessageBox.ButtonRole = ... # 0x1
    DestructiveRole          : QMessageBox.ButtonRole = ... # 0x2
    ActionRole               : QMessageBox.ButtonRole = ... # 0x3
    HelpRole                 : QMessageBox.ButtonRole = ... # 0x4
    YesRole                  : QMessageBox.ButtonRole = ... # 0x5
    NoRole                   : QMessageBox.ButtonRole = ... # 0x6
    ResetRole                : QMessageBox.ButtonRole = ... # 0x7
    ApplyRole                : QMessageBox.ButtonRole = ... # 0x8
    NRoles                   : QMessageBox.ButtonRole = ... # 0x9
    NoIcon                   : QMessageBox.Icon = ... # 0x0
    Information              : QMessageBox.Icon = ... # 0x1
    Warning                  : QMessageBox.Icon = ... # 0x2
    Critical                 : QMessageBox.Icon = ... # 0x3
    Question                 : QMessageBox.Icon = ... # 0x4
    ButtonMask               : QMessageBox.StandardButton = ... # -0x301
    NoButton                 : QMessageBox.StandardButton = ... # 0x0
    Default                  : QMessageBox.StandardButton = ... # 0x100
    Escape                   : QMessageBox.StandardButton = ... # 0x200
    FlagMask                 : QMessageBox.StandardButton = ... # 0x300
    FirstButton              : QMessageBox.StandardButton = ... # 0x400
    Ok                       : QMessageBox.StandardButton = ... # 0x400
    Save                     : QMessageBox.StandardButton = ... # 0x800
    SaveAll                  : QMessageBox.StandardButton = ... # 0x1000
    Open                     : QMessageBox.StandardButton = ... # 0x2000
    Yes                      : QMessageBox.StandardButton = ... # 0x4000
    YesAll                   : QMessageBox.StandardButton = ... # 0x8000
    YesToAll                 : QMessageBox.StandardButton = ... # 0x8000
    No                       : QMessageBox.StandardButton = ... # 0x10000
    NoAll                    : QMessageBox.StandardButton = ... # 0x20000
    NoToAll                  : QMessageBox.StandardButton = ... # 0x20000
    Abort                    : QMessageBox.StandardButton = ... # 0x40000
    Retry                    : QMessageBox.StandardButton = ... # 0x80000
    Ignore                   : QMessageBox.StandardButton = ... # 0x100000
    Close                    : QMessageBox.StandardButton = ... # 0x200000
    Cancel                   : QMessageBox.StandardButton = ... # 0x400000
    Discard                  : QMessageBox.StandardButton = ... # 0x800000
    Help                     : QMessageBox.StandardButton = ... # 0x1000000
    Apply                    : QMessageBox.StandardButton = ... # 0x2000000
    Reset                    : QMessageBox.StandardButton = ... # 0x4000000
    LastButton               : QMessageBox.StandardButton = ... # 0x8000000
    RestoreDefaults          : QMessageBox.StandardButton = ... # 0x8000000

    class ButtonRole(Shiboken.Enum):
        InvalidRole              : QMessageBox.ButtonRole = ... # -0x1
        AcceptRole               : QMessageBox.ButtonRole = ... # 0x0
        RejectRole               : QMessageBox.ButtonRole = ... # 0x1
        DestructiveRole          : QMessageBox.ButtonRole = ... # 0x2
        ActionRole               : QMessageBox.ButtonRole = ... # 0x3
        HelpRole                 : QMessageBox.ButtonRole = ... # 0x4
        YesRole                  : QMessageBox.ButtonRole = ... # 0x5
        NoRole                   : QMessageBox.ButtonRole = ... # 0x6
        ResetRole                : QMessageBox.ButtonRole = ... # 0x7
        ApplyRole                : QMessageBox.ButtonRole = ... # 0x8
        NRoles                   : QMessageBox.ButtonRole = ... # 0x9

    class Icon(Shiboken.Enum):
        NoIcon                   : QMessageBox.Icon = ... # 0x0
        Information              : QMessageBox.Icon = ... # 0x1
        Warning                  : QMessageBox.Icon = ... # 0x2
        Critical                 : QMessageBox.Icon = ... # 0x3
        Question                 : QMessageBox.Icon = ... # 0x4

    class StandardButton(Shiboken.Enum):
        ButtonMask               : QMessageBox.StandardButton = ... # -0x301
        NoButton                 : QMessageBox.StandardButton = ... # 0x0
        Default                  : QMessageBox.StandardButton = ... # 0x100
        Escape                   : QMessageBox.StandardButton = ... # 0x200
        FlagMask                 : QMessageBox.StandardButton = ... # 0x300
        FirstButton              : QMessageBox.StandardButton = ... # 0x400
        Ok                       : QMessageBox.StandardButton = ... # 0x400
        Save                     : QMessageBox.StandardButton = ... # 0x800
        SaveAll                  : QMessageBox.StandardButton = ... # 0x1000
        Open                     : QMessageBox.StandardButton = ... # 0x2000
        Yes                      : QMessageBox.StandardButton = ... # 0x4000
        YesAll                   : QMessageBox.StandardButton = ... # 0x8000
        YesToAll                 : QMessageBox.StandardButton = ... # 0x8000
        No                       : QMessageBox.StandardButton = ... # 0x10000
        NoAll                    : QMessageBox.StandardButton = ... # 0x20000
        NoToAll                  : QMessageBox.StandardButton = ... # 0x20000
        Abort                    : QMessageBox.StandardButton = ... # 0x40000
        Retry                    : QMessageBox.StandardButton = ... # 0x80000
        Ignore                   : QMessageBox.StandardButton = ... # 0x100000
        Close                    : QMessageBox.StandardButton = ... # 0x200000
        Cancel                   : QMessageBox.StandardButton = ... # 0x400000
        Discard                  : QMessageBox.StandardButton = ... # 0x800000
        Help                     : QMessageBox.StandardButton = ... # 0x1000000
        Apply                    : QMessageBox.StandardButton = ... # 0x2000000
        Reset                    : QMessageBox.StandardButton = ... # 0x4000000
        LastButton               : QMessageBox.StandardButton = ... # 0x8000000
        RestoreDefaults          : QMessageBox.StandardButton = ... # 0x8000000

    class StandardButtons(object): ...

    @typing.overload
    def __init__(self, icon: PySide2.QtWidgets.QMessageBox.Icon, title: str, text: str, buttons: PySide2.QtWidgets.QMessageBox.StandardButtons = ..., parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QMouseEventTransition(PySide2.QtCore.QEventTransition):

    @typing.overload
    def __init__(self, object: PySide2.QtCore.QObject, type: PySide2.QtCore.QEvent.Type, button: PySide2.QtCore.Qt.MouseButton, sourceState: typing.Optional[PySide2.QtCore.QState] = ...) -> None: ...
    @typing.overload
    def __init__(self, sourceState: typing.Optional[PySide2.QtCore.QState] = ...) -> None: ...


class QOpenGLWidget(PySide2.QtWidgets.QWidget):
    NoPartialUpdate          : QOpenGLWidget.UpdateBehavior = ... # 0x0
    PartialUpdate            : QOpenGLWidget.UpdateBehavior = ... # 0x1

    class UpdateBehavior(Shiboken.Enum):
        NoPartialUpdate          : QOpenGLWidget.UpdateBehavior = ... # 0x0
        PartialUpdate            : QOpenGLWidget.UpdateBehavior = ... # 0x1

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., f: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...


class QPanGesture(PySide2.QtWidgets.QGesture):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QPinchGesture(PySide2.QtWidgets.QGesture):
    ScaleFactorChanged       : QPinchGesture.ChangeFlag = ... # 0x1
    RotationAngleChanged     : QPinchGesture.ChangeFlag = ... # 0x2
    CenterPointChanged       : QPinchGesture.ChangeFlag = ... # 0x4

    class ChangeFlag(Shiboken.Enum):
        ScaleFactorChanged       : QPinchGesture.ChangeFlag = ... # 0x1
        RotationAngleChanged     : QPinchGesture.ChangeFlag = ... # 0x2
        CenterPointChanged       : QPinchGesture.ChangeFlag = ... # 0x4

    class ChangeFlags(object): ...

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QPlainTextDocumentLayout(PySide2.QtGui.QAbstractTextDocumentLayout):

    def __init__(self, document: PySide2.QtGui.QTextDocument) -> None: ...


class QPlainTextEdit(PySide2.QtWidgets.QAbstractScrollArea):
    NoWrap                   : QPlainTextEdit.LineWrapMode = ... # 0x0
    WidgetWidth              : QPlainTextEdit.LineWrapMode = ... # 0x1

    class LineWrapMode(Shiboken.Enum):
        NoWrap                   : QPlainTextEdit.LineWrapMode = ... # 0x0
        WidgetWidth              : QPlainTextEdit.LineWrapMode = ... # 0x1

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QProgressBar(PySide2.QtWidgets.QWidget):
    TopToBottom              : QProgressBar.Direction = ... # 0x0
    BottomToTop              : QProgressBar.Direction = ... # 0x1

    class Direction(Shiboken.Enum):
        TopToBottom              : QProgressBar.Direction = ... # 0x0
        BottomToTop              : QProgressBar.Direction = ... # 0x1

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QProgressDialog(PySide2.QtWidgets.QDialog):

    @typing.overload
    def __init__(self, labelText: str, cancelButtonText: str, minimum: int, maximum: int, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...


class QProxyStyle(PySide2.QtWidgets.QCommonStyle):

    @typing.overload
    def __init__(self, key: str) -> None: ...
    @typing.overload
    def __init__(self, style: typing.Optional[PySide2.QtWidgets.QStyle] = ...) -> None: ...


class QPushButton(PySide2.QtWidgets.QAbstractButton):

    @typing.overload
    def __init__(self, icon: PySide2.QtGui.QIcon, text: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QRadioButton(PySide2.QtWidgets.QAbstractButton):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QRubberBand(PySide2.QtWidgets.QWidget):
    Line                     : QRubberBand.Shape = ... # 0x0
    Rectangle                : QRubberBand.Shape = ... # 0x1

    class Shape(Shiboken.Enum):
        Line                     : QRubberBand.Shape = ... # 0x0
        Rectangle                : QRubberBand.Shape = ... # 0x1

    def __init__(self, arg__1: PySide2.QtWidgets.QRubberBand.Shape, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QScrollArea(PySide2.QtWidgets.QAbstractScrollArea):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QScrollBar(PySide2.QtWidgets.QAbstractSlider):

    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.Qt.Orientation, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QScroller(PySide2.QtCore.QObject):
    InputPress               : QScroller.Input = ... # 0x1
    InputMove                : QScroller.Input = ... # 0x2
    InputRelease             : QScroller.Input = ... # 0x3
    TouchGesture             : QScroller.ScrollerGestureType = ... # 0x0
    LeftMouseButtonGesture   : QScroller.ScrollerGestureType = ... # 0x1
    RightMouseButtonGesture  : QScroller.ScrollerGestureType = ... # 0x2
    MiddleMouseButtonGesture : QScroller.ScrollerGestureType = ... # 0x3
    Inactive                 : QScroller.State = ... # 0x0
    Pressed                  : QScroller.State = ... # 0x1
    Dragging                 : QScroller.State = ... # 0x2
    Scrolling                : QScroller.State = ... # 0x3

    class Input(Shiboken.Enum):
        InputPress               : QScroller.Input = ... # 0x1
        InputMove                : QScroller.Input = ... # 0x2
        InputRelease             : QScroller.Input = ... # 0x3

    class ScrollerGestureType(Shiboken.Enum):
        TouchGesture             : QScroller.ScrollerGestureType = ... # 0x0
        LeftMouseButtonGesture   : QScroller.ScrollerGestureType = ... # 0x1
        RightMouseButtonGesture  : QScroller.ScrollerGestureType = ... # 0x2
        MiddleMouseButtonGesture : QScroller.ScrollerGestureType = ... # 0x3

    class State(Shiboken.Enum):
        Inactive                 : QScroller.State = ... # 0x0
        Pressed                  : QScroller.State = ... # 0x1
        Dragging                 : QScroller.State = ... # 0x2
        Scrolling                : QScroller.State = ... # 0x3


class QScrollerProperties(Shiboken.Object):
    Standard                 : QScrollerProperties.FrameRates = ... # 0x0
    Fps60                    : QScrollerProperties.FrameRates = ... # 0x1
    Fps30                    : QScrollerProperties.FrameRates = ... # 0x2
    Fps20                    : QScrollerProperties.FrameRates = ... # 0x3
    OvershootWhenScrollable  : QScrollerProperties.OvershootPolicy = ... # 0x0
    OvershootAlwaysOff       : QScrollerProperties.OvershootPolicy = ... # 0x1
    OvershootAlwaysOn        : QScrollerProperties.OvershootPolicy = ... # 0x2
    MousePressEventDelay     : QScrollerProperties.ScrollMetric = ... # 0x0
    DragStartDistance        : QScrollerProperties.ScrollMetric = ... # 0x1
    DragVelocitySmoothingFactor: QScrollerProperties.ScrollMetric = ... # 0x2
    AxisLockThreshold        : QScrollerProperties.ScrollMetric = ... # 0x3
    ScrollingCurve           : QScrollerProperties.ScrollMetric = ... # 0x4
    DecelerationFactor       : QScrollerProperties.ScrollMetric = ... # 0x5
    MinimumVelocity          : QScrollerProperties.ScrollMetric = ... # 0x6
    MaximumVelocity          : QScrollerProperties.ScrollMetric = ... # 0x7
    MaximumClickThroughVelocity: QScrollerProperties.ScrollMetric = ... # 0x8
    AcceleratingFlickMaximumTime: QScrollerProperties.ScrollMetric = ... # 0x9
    AcceleratingFlickSpeedupFactor: QScrollerProperties.ScrollMetric = ... # 0xa
    SnapPositionRatio        : QScrollerProperties.ScrollMetric = ... # 0xb
    SnapTime                 : QScrollerProperties.ScrollMetric = ... # 0xc
    OvershootDragResistanceFactor: QScrollerProperties.ScrollMetric = ... # 0xd
    OvershootDragDistanceFactor: QScrollerProperties.ScrollMetric = ... # 0xe
    OvershootScrollDistanceFactor: QScrollerProperties.ScrollMetric = ... # 0xf
    OvershootScrollTime      : QScrollerProperties.ScrollMetric = ... # 0x10
    HorizontalOvershootPolicy: QScrollerProperties.ScrollMetric = ... # 0x11
    VerticalOvershootPolicy  : QScrollerProperties.ScrollMetric = ... # 0x12
    FrameRate                : QScrollerProperties.ScrollMetric = ... # 0x13
    ScrollMetricCount        : QScrollerProperties.ScrollMetric = ... # 0x14

    class FrameRates(Shiboken.Enum):
        Standard                 : QScrollerProperties.FrameRates = ... # 0x0
        Fps60                    : QScrollerProperties.FrameRates = ... # 0x1
        Fps30                    : QScrollerProperties.FrameRates = ... # 0x2
        Fps20                    : QScrollerProperties.FrameRates = ... # 0x3

    class OvershootPolicy(Shiboken.Enum):
        OvershootWhenScrollable  : QScrollerProperties.OvershootPolicy = ... # 0x0
        OvershootAlwaysOff       : QScrollerProperties.OvershootPolicy = ... # 0x1
        OvershootAlwaysOn        : QScrollerProperties.OvershootPolicy = ... # 0x2

    class ScrollMetric(Shiboken.Enum):
        MousePressEventDelay     : QScrollerProperties.ScrollMetric = ... # 0x0
        DragStartDistance        : QScrollerProperties.ScrollMetric = ... # 0x1
        DragVelocitySmoothingFactor: QScrollerProperties.ScrollMetric = ... # 0x2
        AxisLockThreshold        : QScrollerProperties.ScrollMetric = ... # 0x3
        ScrollingCurve           : QScrollerProperties.ScrollMetric = ... # 0x4
        DecelerationFactor       : QScrollerProperties.ScrollMetric = ... # 0x5
        MinimumVelocity          : QScrollerProperties.ScrollMetric = ... # 0x6
        MaximumVelocity          : QScrollerProperties.ScrollMetric = ... # 0x7
        MaximumClickThroughVelocity: QScrollerProperties.ScrollMetric = ... # 0x8
        AcceleratingFlickMaximumTime: QScrollerProperties.ScrollMetric = ... # 0x9
        AcceleratingFlickSpeedupFactor: QScrollerProperties.ScrollMetric = ... # 0xa
        SnapPositionRatio        : QScrollerProperties.ScrollMetric = ... # 0xb
        SnapTime                 : QScrollerProperties.ScrollMetric = ... # 0xc
        OvershootDragResistanceFactor: QScrollerProperties.ScrollMetric = ... # 0xd
        OvershootDragDistanceFactor: QScrollerProperties.ScrollMetric = ... # 0xe
        OvershootScrollDistanceFactor: QScrollerProperties.ScrollMetric = ... # 0xf
        OvershootScrollTime      : QScrollerProperties.ScrollMetric = ... # 0x10
        HorizontalOvershootPolicy: QScrollerProperties.ScrollMetric = ... # 0x11
        VerticalOvershootPolicy  : QScrollerProperties.ScrollMetric = ... # 0x12
        FrameRate                : QScrollerProperties.ScrollMetric = ... # 0x13
        ScrollMetricCount        : QScrollerProperties.ScrollMetric = ... # 0x14

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, sp: PySide2.QtWidgets.QScrollerProperties) -> None: ...


class QShortcut(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QKeySequence, arg__2: PySide2.QtWidgets.QWidget, arg__3: typing.Callable, arg__4: PySide2.QtCore.Qt.ShortcutContext = ...) -> None: ...
    @typing.overload
    def __init__(self, key: PySide2.QtGui.QKeySequence, parent: PySide2.QtWidgets.QWidget, member: typing.Optional[bytes] = ..., ambiguousMember: typing.Optional[bytes] = ..., shortcutContext: PySide2.QtCore.Qt.ShortcutContext = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget) -> None: ...


class QSizeGrip(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: PySide2.QtWidgets.QWidget) -> None: ...


class QSizePolicy(Shiboken.Object):
    DefaultType              : QSizePolicy.ControlType = ... # 0x1
    ButtonBox                : QSizePolicy.ControlType = ... # 0x2
    CheckBox                 : QSizePolicy.ControlType = ... # 0x4
    ComboBox                 : QSizePolicy.ControlType = ... # 0x8
    Frame                    : QSizePolicy.ControlType = ... # 0x10
    GroupBox                 : QSizePolicy.ControlType = ... # 0x20
    Label                    : QSizePolicy.ControlType = ... # 0x40
    Line                     : QSizePolicy.ControlType = ... # 0x80
    LineEdit                 : QSizePolicy.ControlType = ... # 0x100
    PushButton               : QSizePolicy.ControlType = ... # 0x200
    RadioButton              : QSizePolicy.ControlType = ... # 0x400
    Slider                   : QSizePolicy.ControlType = ... # 0x800
    SpinBox                  : QSizePolicy.ControlType = ... # 0x1000
    TabWidget                : QSizePolicy.ControlType = ... # 0x2000
    ToolButton               : QSizePolicy.ControlType = ... # 0x4000
    Fixed                    : QSizePolicy.Policy = ... # 0x0
    Minimum                  : QSizePolicy.Policy = ... # 0x1
    MinimumExpanding         : QSizePolicy.Policy = ... # 0x3
    Maximum                  : QSizePolicy.Policy = ... # 0x4
    Preferred                : QSizePolicy.Policy = ... # 0x5
    Expanding                : QSizePolicy.Policy = ... # 0x7
    Ignored                  : QSizePolicy.Policy = ... # 0xd
    GrowFlag                 : QSizePolicy.PolicyFlag = ... # 0x1
    ExpandFlag               : QSizePolicy.PolicyFlag = ... # 0x2
    ShrinkFlag               : QSizePolicy.PolicyFlag = ... # 0x4
    IgnoreFlag               : QSizePolicy.PolicyFlag = ... # 0x8

    class ControlType(Shiboken.Enum):
        DefaultType              : QSizePolicy.ControlType = ... # 0x1
        ButtonBox                : QSizePolicy.ControlType = ... # 0x2
        CheckBox                 : QSizePolicy.ControlType = ... # 0x4
        ComboBox                 : QSizePolicy.ControlType = ... # 0x8
        Frame                    : QSizePolicy.ControlType = ... # 0x10
        GroupBox                 : QSizePolicy.ControlType = ... # 0x20
        Label                    : QSizePolicy.ControlType = ... # 0x40
        Line                     : QSizePolicy.ControlType = ... # 0x80
        LineEdit                 : QSizePolicy.ControlType = ... # 0x100
        PushButton               : QSizePolicy.ControlType = ... # 0x200
        RadioButton              : QSizePolicy.ControlType = ... # 0x400
        Slider                   : QSizePolicy.ControlType = ... # 0x800
        SpinBox                  : QSizePolicy.ControlType = ... # 0x1000
        TabWidget                : QSizePolicy.ControlType = ... # 0x2000
        ToolButton               : QSizePolicy.ControlType = ... # 0x4000

    class ControlTypes(object): ...

    class Policy(Shiboken.Enum):
        Fixed                    : QSizePolicy.Policy = ... # 0x0
        Minimum                  : QSizePolicy.Policy = ... # 0x1
        MinimumExpanding         : QSizePolicy.Policy = ... # 0x3
        Maximum                  : QSizePolicy.Policy = ... # 0x4
        Preferred                : QSizePolicy.Policy = ... # 0x5
        Expanding                : QSizePolicy.Policy = ... # 0x7
        Ignored                  : QSizePolicy.Policy = ... # 0xd

    class PolicyFlag(Shiboken.Enum):
        GrowFlag                 : QSizePolicy.PolicyFlag = ... # 0x1
        ExpandFlag               : QSizePolicy.PolicyFlag = ... # 0x2
        ShrinkFlag               : QSizePolicy.PolicyFlag = ... # 0x4
        IgnoreFlag               : QSizePolicy.PolicyFlag = ... # 0x8

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, horizontal: PySide2.QtWidgets.QSizePolicy.Policy, vertical: PySide2.QtWidgets.QSizePolicy.Policy, type: PySide2.QtWidgets.QSizePolicy.ControlType = ...) -> None: ...


class QSlider(PySide2.QtWidgets.QAbstractSlider):
    NoTicks                  : QSlider.TickPosition = ... # 0x0
    TicksAbove               : QSlider.TickPosition = ... # 0x1
    TicksLeft                : QSlider.TickPosition = ... # 0x1
    TicksBelow               : QSlider.TickPosition = ... # 0x2
    TicksRight               : QSlider.TickPosition = ... # 0x2
    TicksBothSides           : QSlider.TickPosition = ... # 0x3

    class TickPosition(Shiboken.Enum):
        NoTicks                  : QSlider.TickPosition = ... # 0x0
        TicksAbove               : QSlider.TickPosition = ... # 0x1
        TicksLeft                : QSlider.TickPosition = ... # 0x1
        TicksBelow               : QSlider.TickPosition = ... # 0x2
        TicksRight               : QSlider.TickPosition = ... # 0x2
        TicksBothSides           : QSlider.TickPosition = ... # 0x3

    @typing.overload
    def __init__(self, orientation: PySide2.QtCore.Qt.Orientation, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QSpacerItem(PySide2.QtWidgets.QLayoutItem):

    def __init__(self, w: int, h: int, hData: PySide2.QtWidgets.QSizePolicy.Policy = ..., vData: PySide2.QtWidgets.QSizePolicy.Policy = ...) -> None: ...


class QSpinBox(PySide2.QtWidgets.QAbstractSpinBox):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QSplashScreen(PySide2.QtWidgets.QWidget):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget, pixmap: PySide2.QtGui.QPixmap = ..., f: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...
    @typing.overload
    def __init__(self, pixmap: PySide2.QtGui.QPixmap = ..., f: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...
    @typing.overload
    def __init__(self, screen: PySide2.QtGui.QScreen, pixmap: PySide2.QtGui.QPixmap = ..., f: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...


class QSplitter(PySide2.QtWidgets.QFrame):

    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.Qt.Orientation, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QSplitterHandle(PySide2.QtWidgets.QWidget):

    def __init__(self, o: PySide2.QtCore.Qt.Orientation, parent: PySide2.QtWidgets.QSplitter) -> None: ...


class QStackedLayout(PySide2.QtWidgets.QLayout):
    StackOne                 : QStackedLayout.StackingMode = ... # 0x0
    StackAll                 : QStackedLayout.StackingMode = ... # 0x1

    class StackingMode(Shiboken.Enum):
        StackOne                 : QStackedLayout.StackingMode = ... # 0x0
        StackAll                 : QStackedLayout.StackingMode = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget) -> None: ...
    @typing.overload
    def __init__(self, parentLayout: PySide2.QtWidgets.QLayout) -> None: ...


class QStackedWidget(PySide2.QtWidgets.QFrame):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QStatusBar(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QStyle(PySide2.QtCore.QObject):
    CC_SpinBox               : QStyle.ComplexControl = ... # 0x0
    CC_ComboBox              : QStyle.ComplexControl = ... # 0x1
    CC_ScrollBar             : QStyle.ComplexControl = ... # 0x2
    CC_Slider                : QStyle.ComplexControl = ... # 0x3
    CC_ToolButton            : QStyle.ComplexControl = ... # 0x4
    CC_TitleBar              : QStyle.ComplexControl = ... # 0x5
    CC_Dial                  : QStyle.ComplexControl = ... # 0x6
    CC_GroupBox              : QStyle.ComplexControl = ... # 0x7
    CC_MdiControls           : QStyle.ComplexControl = ... # 0x8
    CC_CustomBase            : QStyle.ComplexControl = ... # 0xf0000000
    CT_PushButton            : QStyle.ContentsType = ... # 0x0
    CT_CheckBox              : QStyle.ContentsType = ... # 0x1
    CT_RadioButton           : QStyle.ContentsType = ... # 0x2
    CT_ToolButton            : QStyle.ContentsType = ... # 0x3
    CT_ComboBox              : QStyle.ContentsType = ... # 0x4
    CT_Splitter              : QStyle.ContentsType = ... # 0x5
    CT_ProgressBar           : QStyle.ContentsType = ... # 0x6
    CT_MenuItem              : QStyle.ContentsType = ... # 0x7
    CT_MenuBarItem           : QStyle.ContentsType = ... # 0x8
    CT_MenuBar               : QStyle.ContentsType = ... # 0x9
    CT_Menu                  : QStyle.ContentsType = ... # 0xa
    CT_TabBarTab             : QStyle.ContentsType = ... # 0xb
    CT_Slider                : QStyle.ContentsType = ... # 0xc
    CT_ScrollBar             : QStyle.ContentsType = ... # 0xd
    CT_LineEdit              : QStyle.ContentsType = ... # 0xe
    CT_SpinBox               : QStyle.ContentsType = ... # 0xf
    CT_SizeGrip              : QStyle.ContentsType = ... # 0x10
    CT_TabWidget             : QStyle.ContentsType = ... # 0x11
    CT_DialogButtons         : QStyle.ContentsType = ... # 0x12
    CT_HeaderSection         : QStyle.ContentsType = ... # 0x13
    CT_GroupBox              : QStyle.ContentsType = ... # 0x14
    CT_MdiControls           : QStyle.ContentsType = ... # 0x15
    CT_ItemViewItem          : QStyle.ContentsType = ... # 0x16
    CT_CustomBase            : QStyle.ContentsType = ... # 0xf0000000
    CE_PushButton            : QStyle.ControlElement = ... # 0x0
    CE_PushButtonBevel       : QStyle.ControlElement = ... # 0x1
    CE_PushButtonLabel       : QStyle.ControlElement = ... # 0x2
    CE_CheckBox              : QStyle.ControlElement = ... # 0x3
    CE_CheckBoxLabel         : QStyle.ControlElement = ... # 0x4
    CE_RadioButton           : QStyle.ControlElement = ... # 0x5
    CE_RadioButtonLabel      : QStyle.ControlElement = ... # 0x6
    CE_TabBarTab             : QStyle.ControlElement = ... # 0x7
    CE_TabBarTabShape        : QStyle.ControlElement = ... # 0x8
    CE_TabBarTabLabel        : QStyle.ControlElement = ... # 0x9
    CE_ProgressBar           : QStyle.ControlElement = ... # 0xa
    CE_ProgressBarGroove     : QStyle.ControlElement = ... # 0xb
    CE_ProgressBarContents   : QStyle.ControlElement = ... # 0xc
    CE_ProgressBarLabel      : QStyle.ControlElement = ... # 0xd
    CE_MenuItem              : QStyle.ControlElement = ... # 0xe
    CE_MenuScroller          : QStyle.ControlElement = ... # 0xf
    CE_MenuVMargin           : QStyle.ControlElement = ... # 0x10
    CE_MenuHMargin           : QStyle.ControlElement = ... # 0x11
    CE_MenuTearoff           : QStyle.ControlElement = ... # 0x12
    CE_MenuEmptyArea         : QStyle.ControlElement = ... # 0x13
    CE_MenuBarItem           : QStyle.ControlElement = ... # 0x14
    CE_MenuBarEmptyArea      : QStyle.ControlElement = ... # 0x15
    CE_ToolButtonLabel       : QStyle.ControlElement = ... # 0x16
    CE_Header                : QStyle.ControlElement = ... # 0x17
    CE_HeaderSection         : QStyle.ControlElement = ... # 0x18
    CE_HeaderLabel           : QStyle.ControlElement = ... # 0x19
    CE_ToolBoxTab            : QStyle.ControlElement = ... # 0x1a
    CE_SizeGrip              : QStyle.ControlElement = ... # 0x1b
    CE_Splitter              : QStyle.ControlElement = ... # 0x1c
    CE_RubberBand            : QStyle.ControlElement = ... # 0x1d
    CE_DockWidgetTitle       : QStyle.ControlElement = ... # 0x1e
    CE_ScrollBarAddLine      : QStyle.ControlElement = ... # 0x1f
    CE_ScrollBarSubLine      : QStyle.ControlElement = ... # 0x20
    CE_ScrollBarAddPage      : QStyle.ControlElement = ... # 0x21
    CE_ScrollBarSubPage      : QStyle.ControlElement = ... # 0x22
    CE_ScrollBarSlider       : QStyle.ControlElement = ... # 0x23
    CE_ScrollBarFirst        : QStyle.ControlElement = ... # 0x24
    CE_ScrollBarLast         : QStyle.ControlElement = ... # 0x25
    CE_FocusFrame            : QStyle.ControlElement = ... # 0x26
    CE_ComboBoxLabel         : QStyle.ControlElement = ... # 0x27
    CE_ToolBar               : QStyle.ControlElement = ... # 0x28
    CE_ToolBoxTabShape       : QStyle.ControlElement = ... # 0x29
    CE_ToolBoxTabLabel       : QStyle.ControlElement = ... # 0x2a
    CE_HeaderEmptyArea       : QStyle.ControlElement = ... # 0x2b
    CE_ColumnViewGrip        : QStyle.ControlElement = ... # 0x2c
    CE_ItemViewItem          : QStyle.ControlElement = ... # 0x2d
    CE_ShapedFrame           : QStyle.ControlElement = ... # 0x2e
    CE_CustomBase            : QStyle.ControlElement = ... # 0xf0000000
    PM_ButtonMargin          : QStyle.PixelMetric = ... # 0x0
    PM_ButtonDefaultIndicator: QStyle.PixelMetric = ... # 0x1
    PM_MenuButtonIndicator   : QStyle.PixelMetric = ... # 0x2
    PM_ButtonShiftHorizontal : QStyle.PixelMetric = ... # 0x3
    PM_ButtonShiftVertical   : QStyle.PixelMetric = ... # 0x4
    PM_DefaultFrameWidth     : QStyle.PixelMetric = ... # 0x5
    PM_SpinBoxFrameWidth     : QStyle.PixelMetric = ... # 0x6
    PM_ComboBoxFrameWidth    : QStyle.PixelMetric = ... # 0x7
    PM_MaximumDragDistance   : QStyle.PixelMetric = ... # 0x8
    PM_ScrollBarExtent       : QStyle.PixelMetric = ... # 0x9
    PM_ScrollBarSliderMin    : QStyle.PixelMetric = ... # 0xa
    PM_SliderThickness       : QStyle.PixelMetric = ... # 0xb
    PM_SliderControlThickness: QStyle.PixelMetric = ... # 0xc
    PM_SliderLength          : QStyle.PixelMetric = ... # 0xd
    PM_SliderTickmarkOffset  : QStyle.PixelMetric = ... # 0xe
    PM_SliderSpaceAvailable  : QStyle.PixelMetric = ... # 0xf
    PM_DockWidgetSeparatorExtent: QStyle.PixelMetric = ... # 0x10
    PM_DockWidgetHandleExtent: QStyle.PixelMetric = ... # 0x11
    PM_DockWidgetFrameWidth  : QStyle.PixelMetric = ... # 0x12
    PM_TabBarTabOverlap      : QStyle.PixelMetric = ... # 0x13
    PM_TabBarTabHSpace       : QStyle.PixelMetric = ... # 0x14
    PM_TabBarTabVSpace       : QStyle.PixelMetric = ... # 0x15
    PM_TabBarBaseHeight      : QStyle.PixelMetric = ... # 0x16
    PM_TabBarBaseOverlap     : QStyle.PixelMetric = ... # 0x17
    PM_ProgressBarChunkWidth : QStyle.PixelMetric = ... # 0x18
    PM_SplitterWidth         : QStyle.PixelMetric = ... # 0x19
    PM_TitleBarHeight        : QStyle.PixelMetric = ... # 0x1a
    PM_MenuScrollerHeight    : QStyle.PixelMetric = ... # 0x1b
    PM_MenuHMargin           : QStyle.PixelMetric = ... # 0x1c
    PM_MenuVMargin           : QStyle.PixelMetric = ... # 0x1d
    PM_MenuPanelWidth        : QStyle.PixelMetric = ... # 0x1e
    PM_MenuTearoffHeight     : QStyle.PixelMetric = ... # 0x1f
    PM_MenuDesktopFrameWidth : QStyle.PixelMetric = ... # 0x20
    PM_MenuBarPanelWidth     : QStyle.PixelMetric = ... # 0x21
    PM_MenuBarItemSpacing    : QStyle.PixelMetric = ... # 0x22
    PM_MenuBarVMargin        : QStyle.PixelMetric = ... # 0x23
    PM_MenuBarHMargin        : QStyle.PixelMetric = ... # 0x24
    PM_IndicatorWidth        : QStyle.PixelMetric = ... # 0x25
    PM_IndicatorHeight       : QStyle.PixelMetric = ... # 0x26
    PM_ExclusiveIndicatorWidth: QStyle.PixelMetric = ... # 0x27
    PM_ExclusiveIndicatorHeight: QStyle.PixelMetric = ... # 0x28
    PM_DialogButtonsSeparator: QStyle.PixelMetric = ... # 0x29
    PM_DialogButtonsButtonWidth: QStyle.PixelMetric = ... # 0x2a
    PM_DialogButtonsButtonHeight: QStyle.PixelMetric = ... # 0x2b
    PM_MDIFrameWidth         : QStyle.PixelMetric = ... # 0x2c
    PM_MdiSubWindowFrameWidth: QStyle.PixelMetric = ... # 0x2c
    PM_MDIMinimizedWidth     : QStyle.PixelMetric = ... # 0x2d
    PM_MdiSubWindowMinimizedWidth: QStyle.PixelMetric = ... # 0x2d
    PM_HeaderMargin          : QStyle.PixelMetric = ... # 0x2e
    PM_HeaderMarkSize        : QStyle.PixelMetric = ... # 0x2f
    PM_HeaderGripMargin      : QStyle.PixelMetric = ... # 0x30
    PM_TabBarTabShiftHorizontal: QStyle.PixelMetric = ... # 0x31
    PM_TabBarTabShiftVertical: QStyle.PixelMetric = ... # 0x32
    PM_TabBarScrollButtonWidth: QStyle.PixelMetric = ... # 0x33
    PM_ToolBarFrameWidth     : QStyle.PixelMetric = ... # 0x34
    PM_ToolBarHandleExtent   : QStyle.PixelMetric = ... # 0x35
    PM_ToolBarItemSpacing    : QStyle.PixelMetric = ... # 0x36
    PM_ToolBarItemMargin     : QStyle.PixelMetric = ... # 0x37
    PM_ToolBarSeparatorExtent: QStyle.PixelMetric = ... # 0x38
    PM_ToolBarExtensionExtent: QStyle.PixelMetric = ... # 0x39
    PM_SpinBoxSliderHeight   : QStyle.PixelMetric = ... # 0x3a
    PM_DefaultTopLevelMargin : QStyle.PixelMetric = ... # 0x3b
    PM_DefaultChildMargin    : QStyle.PixelMetric = ... # 0x3c
    PM_DefaultLayoutSpacing  : QStyle.PixelMetric = ... # 0x3d
    PM_ToolBarIconSize       : QStyle.PixelMetric = ... # 0x3e
    PM_ListViewIconSize      : QStyle.PixelMetric = ... # 0x3f
    PM_IconViewIconSize      : QStyle.PixelMetric = ... # 0x40
    PM_SmallIconSize         : QStyle.PixelMetric = ... # 0x41
    PM_LargeIconSize         : QStyle.PixelMetric = ... # 0x42
    PM_FocusFrameVMargin     : QStyle.PixelMetric = ... # 0x43
    PM_FocusFrameHMargin     : QStyle.PixelMetric = ... # 0x44
    PM_ToolTipLabelFrameWidth: QStyle.PixelMetric = ... # 0x45
    PM_CheckBoxLabelSpacing  : QStyle.PixelMetric = ... # 0x46
    PM_TabBarIconSize        : QStyle.PixelMetric = ... # 0x47
    PM_SizeGripSize          : QStyle.PixelMetric = ... # 0x48
    PM_DockWidgetTitleMargin : QStyle.PixelMetric = ... # 0x49
    PM_MessageBoxIconSize    : QStyle.PixelMetric = ... # 0x4a
    PM_ButtonIconSize        : QStyle.PixelMetric = ... # 0x4b
    PM_DockWidgetTitleBarButtonMargin: QStyle.PixelMetric = ... # 0x4c
    PM_RadioButtonLabelSpacing: QStyle.PixelMetric = ... # 0x4d
    PM_LayoutLeftMargin      : QStyle.PixelMetric = ... # 0x4e
    PM_LayoutTopMargin       : QStyle.PixelMetric = ... # 0x4f
    PM_LayoutRightMargin     : QStyle.PixelMetric = ... # 0x50
    PM_LayoutBottomMargin    : QStyle.PixelMetric = ... # 0x51
    PM_LayoutHorizontalSpacing: QStyle.PixelMetric = ... # 0x52
    PM_LayoutVerticalSpacing : QStyle.PixelMetric = ... # 0x53
    PM_TabBar_ScrollButtonOverlap: QStyle.PixelMetric = ... # 0x54
    PM_TextCursorWidth       : QStyle.PixelMetric = ... # 0x55
    PM_TabCloseIndicatorWidth: QStyle.PixelMetric = ... # 0x56
    PM_TabCloseIndicatorHeight: QStyle.PixelMetric = ... # 0x57
    PM_ScrollView_ScrollBarSpacing: QStyle.PixelMetric = ... # 0x58
    PM_ScrollView_ScrollBarOverlap: QStyle.PixelMetric = ... # 0x59
    PM_SubMenuOverlap        : QStyle.PixelMetric = ... # 0x5a
    PM_TreeViewIndentation   : QStyle.PixelMetric = ... # 0x5b
    PM_HeaderDefaultSectionSizeHorizontal: QStyle.PixelMetric = ... # 0x5c
    PM_HeaderDefaultSectionSizeVertical: QStyle.PixelMetric = ... # 0x5d
    PM_TitleBarButtonIconSize: QStyle.PixelMetric = ... # 0x5e
    PM_TitleBarButtonSize    : QStyle.PixelMetric = ... # 0x5f
    PM_CustomBase            : QStyle.PixelMetric = ... # 0xf0000000
    PE_Frame                 : QStyle.PrimitiveElement = ... # 0x0
    PE_FrameDefaultButton    : QStyle.PrimitiveElement = ... # 0x1
    PE_FrameDockWidget       : QStyle.PrimitiveElement = ... # 0x2
    PE_FrameFocusRect        : QStyle.PrimitiveElement = ... # 0x3
    PE_FrameGroupBox         : QStyle.PrimitiveElement = ... # 0x4
    PE_FrameLineEdit         : QStyle.PrimitiveElement = ... # 0x5
    PE_FrameMenu             : QStyle.PrimitiveElement = ... # 0x6
    PE_FrameStatusBar        : QStyle.PrimitiveElement = ... # 0x7
    PE_FrameStatusBarItem    : QStyle.PrimitiveElement = ... # 0x7
    PE_FrameTabWidget        : QStyle.PrimitiveElement = ... # 0x8
    PE_FrameWindow           : QStyle.PrimitiveElement = ... # 0x9
    PE_FrameButtonBevel      : QStyle.PrimitiveElement = ... # 0xa
    PE_FrameButtonTool       : QStyle.PrimitiveElement = ... # 0xb
    PE_FrameTabBarBase       : QStyle.PrimitiveElement = ... # 0xc
    PE_PanelButtonCommand    : QStyle.PrimitiveElement = ... # 0xd
    PE_PanelButtonBevel      : QStyle.PrimitiveElement = ... # 0xe
    PE_PanelButtonTool       : QStyle.PrimitiveElement = ... # 0xf
    PE_PanelMenuBar          : QStyle.PrimitiveElement = ... # 0x10
    PE_PanelToolBar          : QStyle.PrimitiveElement = ... # 0x11
    PE_PanelLineEdit         : QStyle.PrimitiveElement = ... # 0x12
    PE_IndicatorArrowDown    : QStyle.PrimitiveElement = ... # 0x13
    PE_IndicatorArrowLeft    : QStyle.PrimitiveElement = ... # 0x14
    PE_IndicatorArrowRight   : QStyle.PrimitiveElement = ... # 0x15
    PE_IndicatorArrowUp      : QStyle.PrimitiveElement = ... # 0x16
    PE_IndicatorBranch       : QStyle.PrimitiveElement = ... # 0x17
    PE_IndicatorButtonDropDown: QStyle.PrimitiveElement = ... # 0x18
    PE_IndicatorItemViewItemCheck: QStyle.PrimitiveElement = ... # 0x19
    PE_IndicatorViewItemCheck: QStyle.PrimitiveElement = ... # 0x19
    PE_IndicatorCheckBox     : QStyle.PrimitiveElement = ... # 0x1a
    PE_IndicatorDockWidgetResizeHandle: QStyle.PrimitiveElement = ... # 0x1b
    PE_IndicatorHeaderArrow  : QStyle.PrimitiveElement = ... # 0x1c
    PE_IndicatorMenuCheckMark: QStyle.PrimitiveElement = ... # 0x1d
    PE_IndicatorProgressChunk: QStyle.PrimitiveElement = ... # 0x1e
    PE_IndicatorRadioButton  : QStyle.PrimitiveElement = ... # 0x1f
    PE_IndicatorSpinDown     : QStyle.PrimitiveElement = ... # 0x20
    PE_IndicatorSpinMinus    : QStyle.PrimitiveElement = ... # 0x21
    PE_IndicatorSpinPlus     : QStyle.PrimitiveElement = ... # 0x22
    PE_IndicatorSpinUp       : QStyle.PrimitiveElement = ... # 0x23
    PE_IndicatorToolBarHandle: QStyle.PrimitiveElement = ... # 0x24
    PE_IndicatorToolBarSeparator: QStyle.PrimitiveElement = ... # 0x25
    PE_PanelTipLabel         : QStyle.PrimitiveElement = ... # 0x26
    PE_IndicatorTabTear      : QStyle.PrimitiveElement = ... # 0x27
    PE_IndicatorTabTearLeft  : QStyle.PrimitiveElement = ... # 0x27
    PE_PanelScrollAreaCorner : QStyle.PrimitiveElement = ... # 0x28
    PE_Widget                : QStyle.PrimitiveElement = ... # 0x29
    PE_IndicatorColumnViewArrow: QStyle.PrimitiveElement = ... # 0x2a
    PE_IndicatorItemViewItemDrop: QStyle.PrimitiveElement = ... # 0x2b
    PE_PanelItemViewItem     : QStyle.PrimitiveElement = ... # 0x2c
    PE_PanelItemViewRow      : QStyle.PrimitiveElement = ... # 0x2d
    PE_PanelStatusBar        : QStyle.PrimitiveElement = ... # 0x2e
    PE_IndicatorTabClose     : QStyle.PrimitiveElement = ... # 0x2f
    PE_PanelMenu             : QStyle.PrimitiveElement = ... # 0x30
    PE_IndicatorTabTearRight : QStyle.PrimitiveElement = ... # 0x31
    PE_CustomBase            : QStyle.PrimitiveElement = ... # 0xf000000
    RSIP_OnMouseClickAndAlreadyFocused: QStyle.RequestSoftwareInputPanel = ... # 0x0
    RSIP_OnMouseClick        : QStyle.RequestSoftwareInputPanel = ... # 0x1
    SP_TitleBarMenuButton    : QStyle.StandardPixmap = ... # 0x0
    SP_TitleBarMinButton     : QStyle.StandardPixmap = ... # 0x1
    SP_TitleBarMaxButton     : QStyle.StandardPixmap = ... # 0x2
    SP_TitleBarCloseButton   : QStyle.StandardPixmap = ... # 0x3
    SP_TitleBarNormalButton  : QStyle.StandardPixmap = ... # 0x4
    SP_TitleBarShadeButton   : QStyle.StandardPixmap = ... # 0x5
    SP_TitleBarUnshadeButton : QStyle.StandardPixmap = ... # 0x6
    SP_TitleBarContextHelpButton: QStyle.StandardPixmap = ... # 0x7
    SP_DockWidgetCloseButton : QStyle.StandardPixmap = ... # 0x8
    SP_MessageBoxInformation : QStyle.StandardPixmap = ... # 0x9
    SP_MessageBoxWarning     : QStyle.StandardPixmap = ... # 0xa
    SP_MessageBoxCritical    : QStyle.StandardPixmap = ... # 0xb
    SP_MessageBoxQuestion    : QStyle.StandardPixmap = ... # 0xc
    SP_DesktopIcon           : QStyle.StandardPixmap = ... # 0xd
    SP_TrashIcon             : QStyle.StandardPixmap = ... # 0xe
    SP_ComputerIcon          : QStyle.StandardPixmap = ... # 0xf
    SP_DriveFDIcon           : QStyle.StandardPixmap = ... # 0x10
    SP_DriveHDIcon           : QStyle.StandardPixmap = ... # 0x11
    SP_DriveCDIcon           : QStyle.StandardPixmap = ... # 0x12
    SP_DriveDVDIcon          : QStyle.StandardPixmap = ... # 0x13
    SP_DriveNetIcon          : QStyle.StandardPixmap = ... # 0x14
    SP_DirOpenIcon           : QStyle.StandardPixmap = ... # 0x15
    SP_DirClosedIcon         : QStyle.StandardPixmap = ... # 0x16
    SP_DirLinkIcon           : QStyle.StandardPixmap = ... # 0x17
    SP_DirLinkOpenIcon       : QStyle.StandardPixmap = ... # 0x18
    SP_FileIcon              : QStyle.StandardPixmap = ... # 0x19
    SP_FileLinkIcon          : QStyle.StandardPixmap = ... # 0x1a
    SP_ToolBarHorizontalExtensionButton: QStyle.StandardPixmap = ... # 0x1b
    SP_ToolBarVerticalExtensionButton: QStyle.StandardPixmap = ... # 0x1c
    SP_FileDialogStart       : QStyle.StandardPixmap = ... # 0x1d
    SP_FileDialogEnd         : QStyle.StandardPixmap = ... # 0x1e
    SP_FileDialogToParent    : QStyle.StandardPixmap = ... # 0x1f
    SP_FileDialogNewFolder   : QStyle.StandardPixmap = ... # 0x20
    SP_FileDialogDetailedView: QStyle.StandardPixmap = ... # 0x21
    SP_FileDialogInfoView    : QStyle.StandardPixmap = ... # 0x22
    SP_FileDialogContentsView: QStyle.StandardPixmap = ... # 0x23
    SP_FileDialogListView    : QStyle.StandardPixmap = ... # 0x24
    SP_FileDialogBack        : QStyle.StandardPixmap = ... # 0x25
    SP_DirIcon               : QStyle.StandardPixmap = ... # 0x26
    SP_DialogOkButton        : QStyle.StandardPixmap = ... # 0x27
    SP_DialogCancelButton    : QStyle.StandardPixmap = ... # 0x28
    SP_DialogHelpButton      : QStyle.StandardPixmap = ... # 0x29
    SP_DialogOpenButton      : QStyle.StandardPixmap = ... # 0x2a
    SP_DialogSaveButton      : QStyle.StandardPixmap = ... # 0x2b
    SP_DialogCloseButton     : QStyle.StandardPixmap = ... # 0x2c
    SP_DialogApplyButton     : QStyle.StandardPixmap = ... # 0x2d
    SP_DialogResetButton     : QStyle.StandardPixmap = ... # 0x2e
    SP_DialogDiscardButton   : QStyle.StandardPixmap = ... # 0x2f
    SP_DialogYesButton       : QStyle.StandardPixmap = ... # 0x30
    SP_DialogNoButton        : QStyle.StandardPixmap = ... # 0x31
    SP_ArrowUp               : QStyle.StandardPixmap = ... # 0x32
    SP_ArrowDown             : QStyle.StandardPixmap = ... # 0x33
    SP_ArrowLeft             : QStyle.StandardPixmap = ... # 0x34
    SP_ArrowRight            : QStyle.StandardPixmap = ... # 0x35
    SP_ArrowBack             : QStyle.StandardPixmap = ... # 0x36
    SP_ArrowForward          : QStyle.StandardPixmap = ... # 0x37
    SP_DirHomeIcon           : QStyle.StandardPixmap = ... # 0x38
    SP_CommandLink           : QStyle.StandardPixmap = ... # 0x39
    SP_VistaShield           : QStyle.StandardPixmap = ... # 0x3a
    SP_BrowserReload         : QStyle.StandardPixmap = ... # 0x3b
    SP_BrowserStop           : QStyle.StandardPixmap = ... # 0x3c
    SP_MediaPlay             : QStyle.StandardPixmap = ... # 0x3d
    SP_MediaStop             : QStyle.StandardPixmap = ... # 0x3e
    SP_MediaPause            : QStyle.StandardPixmap = ... # 0x3f
    SP_MediaSkipForward      : QStyle.StandardPixmap = ... # 0x40
    SP_MediaSkipBackward     : QStyle.StandardPixmap = ... # 0x41
    SP_MediaSeekForward      : QStyle.StandardPixmap = ... # 0x42
    SP_MediaSeekBackward     : QStyle.StandardPixmap = ... # 0x43
    SP_MediaVolume           : QStyle.StandardPixmap = ... # 0x44
    SP_MediaVolumeMuted      : QStyle.StandardPixmap = ... # 0x45
    SP_LineEditClearButton   : QStyle.StandardPixmap = ... # 0x46
    SP_DialogYesToAllButton  : QStyle.StandardPixmap = ... # 0x47
    SP_DialogNoToAllButton   : QStyle.StandardPixmap = ... # 0x48
    SP_DialogSaveAllButton   : QStyle.StandardPixmap = ... # 0x49
    SP_DialogAbortButton     : QStyle.StandardPixmap = ... # 0x4a
    SP_DialogRetryButton     : QStyle.StandardPixmap = ... # 0x4b
    SP_DialogIgnoreButton    : QStyle.StandardPixmap = ... # 0x4c
    SP_RestoreDefaultsButton : QStyle.StandardPixmap = ... # 0x4d
    SP_CustomBase            : QStyle.StandardPixmap = ... # 0xf0000000
    State_None               : QStyle.StateFlag = ... # 0x0
    State_Enabled            : QStyle.StateFlag = ... # 0x1
    State_Raised             : QStyle.StateFlag = ... # 0x2
    State_Sunken             : QStyle.StateFlag = ... # 0x4
    State_Off                : QStyle.StateFlag = ... # 0x8
    State_NoChange           : QStyle.StateFlag = ... # 0x10
    State_On                 : QStyle.StateFlag = ... # 0x20
    State_DownArrow          : QStyle.StateFlag = ... # 0x40
    State_Horizontal         : QStyle.StateFlag = ... # 0x80
    State_HasFocus           : QStyle.StateFlag = ... # 0x100
    State_Top                : QStyle.StateFlag = ... # 0x200
    State_Bottom             : QStyle.StateFlag = ... # 0x400
    State_FocusAtBorder      : QStyle.StateFlag = ... # 0x800
    State_AutoRaise          : QStyle.StateFlag = ... # 0x1000
    State_MouseOver          : QStyle.StateFlag = ... # 0x2000
    State_UpArrow            : QStyle.StateFlag = ... # 0x4000
    State_Selected           : QStyle.StateFlag = ... # 0x8000
    State_Active             : QStyle.StateFlag = ... # 0x10000
    State_Window             : QStyle.StateFlag = ... # 0x20000
    State_Open               : QStyle.StateFlag = ... # 0x40000
    State_Children           : QStyle.StateFlag = ... # 0x80000
    State_Item               : QStyle.StateFlag = ... # 0x100000
    State_Sibling            : QStyle.StateFlag = ... # 0x200000
    State_Editing            : QStyle.StateFlag = ... # 0x400000
    State_KeyboardFocusChange: QStyle.StateFlag = ... # 0x800000
    State_ReadOnly           : QStyle.StateFlag = ... # 0x2000000
    State_Small              : QStyle.StateFlag = ... # 0x4000000
    State_Mini               : QStyle.StateFlag = ... # 0x8000000
    SH_EtchDisabledText      : QStyle.StyleHint = ... # 0x0
    SH_DitherDisabledText    : QStyle.StyleHint = ... # 0x1
    SH_ScrollBar_MiddleClickAbsolutePosition: QStyle.StyleHint = ... # 0x2
    SH_ScrollBar_ScrollWhenPointerLeavesControl: QStyle.StyleHint = ... # 0x3
    SH_TabBar_SelectMouseType: QStyle.StyleHint = ... # 0x4
    SH_TabBar_Alignment      : QStyle.StyleHint = ... # 0x5
    SH_Header_ArrowAlignment : QStyle.StyleHint = ... # 0x6
    SH_Slider_SnapToValue    : QStyle.StyleHint = ... # 0x7
    SH_Slider_SloppyKeyEvents: QStyle.StyleHint = ... # 0x8
    SH_ProgressDialog_CenterCancelButton: QStyle.StyleHint = ... # 0x9
    SH_ProgressDialog_TextLabelAlignment: QStyle.StyleHint = ... # 0xa
    SH_PrintDialog_RightAlignButtons: QStyle.StyleHint = ... # 0xb
    SH_MainWindow_SpaceBelowMenuBar: QStyle.StyleHint = ... # 0xc
    SH_FontDialog_SelectAssociatedText: QStyle.StyleHint = ... # 0xd
    SH_Menu_AllowActiveAndDisabled: QStyle.StyleHint = ... # 0xe
    SH_Menu_SpaceActivatesItem: QStyle.StyleHint = ... # 0xf
    SH_Menu_SubMenuPopupDelay: QStyle.StyleHint = ... # 0x10
    SH_ScrollView_FrameOnlyAroundContents: QStyle.StyleHint = ... # 0x11
    SH_MenuBar_AltKeyNavigation: QStyle.StyleHint = ... # 0x12
    SH_ComboBox_ListMouseTracking: QStyle.StyleHint = ... # 0x13
    SH_Menu_MouseTracking    : QStyle.StyleHint = ... # 0x14
    SH_MenuBar_MouseTracking : QStyle.StyleHint = ... # 0x15
    SH_ItemView_ChangeHighlightOnFocus: QStyle.StyleHint = ... # 0x16
    SH_Widget_ShareActivation: QStyle.StyleHint = ... # 0x17
    SH_Workspace_FillSpaceOnMaximize: QStyle.StyleHint = ... # 0x18
    SH_ComboBox_Popup        : QStyle.StyleHint = ... # 0x19
    SH_TitleBar_NoBorder     : QStyle.StyleHint = ... # 0x1a
    SH_ScrollBar_StopMouseOverSlider: QStyle.StyleHint = ... # 0x1b
    SH_Slider_StopMouseOverSlider: QStyle.StyleHint = ... # 0x1b
    SH_BlinkCursorWhenTextSelected: QStyle.StyleHint = ... # 0x1c
    SH_RichText_FullWidthSelection: QStyle.StyleHint = ... # 0x1d
    SH_Menu_Scrollable       : QStyle.StyleHint = ... # 0x1e
    SH_GroupBox_TextLabelVerticalAlignment: QStyle.StyleHint = ... # 0x1f
    SH_GroupBox_TextLabelColor: QStyle.StyleHint = ... # 0x20
    SH_Menu_SloppySubMenus   : QStyle.StyleHint = ... # 0x21
    SH_Table_GridLineColor   : QStyle.StyleHint = ... # 0x22
    SH_LineEdit_PasswordCharacter: QStyle.StyleHint = ... # 0x23
    SH_DialogButtons_DefaultButton: QStyle.StyleHint = ... # 0x24
    SH_ToolBox_SelectedPageTitleBold: QStyle.StyleHint = ... # 0x25
    SH_TabBar_PreferNoArrows : QStyle.StyleHint = ... # 0x26
    SH_ScrollBar_LeftClickAbsolutePosition: QStyle.StyleHint = ... # 0x27
    SH_ListViewExpand_SelectMouseType: QStyle.StyleHint = ... # 0x28
    SH_UnderlineShortcut     : QStyle.StyleHint = ... # 0x29
    SH_SpinBox_AnimateButton : QStyle.StyleHint = ... # 0x2a
    SH_SpinBox_KeyPressAutoRepeatRate: QStyle.StyleHint = ... # 0x2b
    SH_SpinBox_ClickAutoRepeatRate: QStyle.StyleHint = ... # 0x2c
    SH_Menu_FillScreenWithScroll: QStyle.StyleHint = ... # 0x2d
    SH_ToolTipLabel_Opacity  : QStyle.StyleHint = ... # 0x2e
    SH_DrawMenuBarSeparator  : QStyle.StyleHint = ... # 0x2f
    SH_TitleBar_ModifyNotification: QStyle.StyleHint = ... # 0x30
    SH_Button_FocusPolicy    : QStyle.StyleHint = ... # 0x31
    SH_MessageBox_UseBorderForButtonSpacing: QStyle.StyleHint = ... # 0x32
    SH_TitleBar_AutoRaise    : QStyle.StyleHint = ... # 0x33
    SH_ToolButton_PopupDelay : QStyle.StyleHint = ... # 0x34
    SH_FocusFrame_Mask       : QStyle.StyleHint = ... # 0x35
    SH_RubberBand_Mask       : QStyle.StyleHint = ... # 0x36
    SH_WindowFrame_Mask      : QStyle.StyleHint = ... # 0x37
    SH_SpinControls_DisableOnBounds: QStyle.StyleHint = ... # 0x38
    SH_Dial_BackgroundRole   : QStyle.StyleHint = ... # 0x39
    SH_ComboBox_LayoutDirection: QStyle.StyleHint = ... # 0x3a
    SH_ItemView_EllipsisLocation: QStyle.StyleHint = ... # 0x3b
    SH_ItemView_ShowDecorationSelected: QStyle.StyleHint = ... # 0x3c
    SH_ItemView_ActivateItemOnSingleClick: QStyle.StyleHint = ... # 0x3d
    SH_ScrollBar_ContextMenu : QStyle.StyleHint = ... # 0x3e
    SH_ScrollBar_RollBetweenButtons: QStyle.StyleHint = ... # 0x3f
    SH_Slider_AbsoluteSetButtons: QStyle.StyleHint = ... # 0x40
    SH_Slider_PageSetButtons : QStyle.StyleHint = ... # 0x41
    SH_Menu_KeyboardSearch   : QStyle.StyleHint = ... # 0x42
    SH_TabBar_ElideMode      : QStyle.StyleHint = ... # 0x43
    SH_DialogButtonLayout    : QStyle.StyleHint = ... # 0x44
    SH_ComboBox_PopupFrameStyle: QStyle.StyleHint = ... # 0x45
    SH_MessageBox_TextInteractionFlags: QStyle.StyleHint = ... # 0x46
    SH_DialogButtonBox_ButtonsHaveIcons: QStyle.StyleHint = ... # 0x47
    SH_SpellCheckUnderlineStyle: QStyle.StyleHint = ... # 0x48
    SH_MessageBox_CenterButtons: QStyle.StyleHint = ... # 0x49
    SH_Menu_SelectionWrap    : QStyle.StyleHint = ... # 0x4a
    SH_ItemView_MovementWithoutUpdatingSelection: QStyle.StyleHint = ... # 0x4b
    SH_ToolTip_Mask          : QStyle.StyleHint = ... # 0x4c
    SH_FocusFrame_AboveWidget: QStyle.StyleHint = ... # 0x4d
    SH_TextControl_FocusIndicatorTextCharFormat: QStyle.StyleHint = ... # 0x4e
    SH_WizardStyle           : QStyle.StyleHint = ... # 0x4f
    SH_ItemView_ArrowKeysNavigateIntoChildren: QStyle.StyleHint = ... # 0x50
    SH_Menu_Mask             : QStyle.StyleHint = ... # 0x51
    SH_Menu_FlashTriggeredItem: QStyle.StyleHint = ... # 0x52
    SH_Menu_FadeOutOnHide    : QStyle.StyleHint = ... # 0x53
    SH_SpinBox_ClickAutoRepeatThreshold: QStyle.StyleHint = ... # 0x54
    SH_ItemView_PaintAlternatingRowColorsForEmptyArea: QStyle.StyleHint = ... # 0x55
    SH_FormLayoutWrapPolicy  : QStyle.StyleHint = ... # 0x56
    SH_TabWidget_DefaultTabPosition: QStyle.StyleHint = ... # 0x57
    SH_ToolBar_Movable       : QStyle.StyleHint = ... # 0x58
    SH_FormLayoutFieldGrowthPolicy: QStyle.StyleHint = ... # 0x59
    SH_FormLayoutFormAlignment: QStyle.StyleHint = ... # 0x5a
    SH_FormLayoutLabelAlignment: QStyle.StyleHint = ... # 0x5b
    SH_ItemView_DrawDelegateFrame: QStyle.StyleHint = ... # 0x5c
    SH_TabBar_CloseButtonPosition: QStyle.StyleHint = ... # 0x5d
    SH_DockWidget_ButtonsHaveFrame: QStyle.StyleHint = ... # 0x5e
    SH_ToolButtonStyle       : QStyle.StyleHint = ... # 0x5f
    SH_RequestSoftwareInputPanel: QStyle.StyleHint = ... # 0x60
    SH_ScrollBar_Transient   : QStyle.StyleHint = ... # 0x61
    SH_Menu_SupportsSections : QStyle.StyleHint = ... # 0x62
    SH_ToolTip_WakeUpDelay   : QStyle.StyleHint = ... # 0x63
    SH_ToolTip_FallAsleepDelay: QStyle.StyleHint = ... # 0x64
    SH_Widget_Animate        : QStyle.StyleHint = ... # 0x65
    SH_Splitter_OpaqueResize : QStyle.StyleHint = ... # 0x66
    SH_ComboBox_UseNativePopup: QStyle.StyleHint = ... # 0x67
    SH_LineEdit_PasswordMaskDelay: QStyle.StyleHint = ... # 0x68
    SH_TabBar_ChangeCurrentDelay: QStyle.StyleHint = ... # 0x69
    SH_Menu_SubMenuUniDirection: QStyle.StyleHint = ... # 0x6a
    SH_Menu_SubMenuUniDirectionFailCount: QStyle.StyleHint = ... # 0x6b
    SH_Menu_SubMenuSloppySelectOtherActions: QStyle.StyleHint = ... # 0x6c
    SH_Menu_SubMenuSloppyCloseTimeout: QStyle.StyleHint = ... # 0x6d
    SH_Menu_SubMenuResetWhenReenteringParent: QStyle.StyleHint = ... # 0x6e
    SH_Menu_SubMenuDontStartSloppyOnLeave: QStyle.StyleHint = ... # 0x6f
    SH_ItemView_ScrollMode   : QStyle.StyleHint = ... # 0x70
    SH_TitleBar_ShowToolTipsOnButtons: QStyle.StyleHint = ... # 0x71
    SH_Widget_Animation_Duration: QStyle.StyleHint = ... # 0x72
    SH_ComboBox_AllowWheelScrolling: QStyle.StyleHint = ... # 0x73
    SH_SpinBox_ButtonsInsideFrame: QStyle.StyleHint = ... # 0x74
    SH_SpinBox_StepModifier  : QStyle.StyleHint = ... # 0x75
    SH_CustomBase            : QStyle.StyleHint = ... # 0xf0000000
    SC_None                  : QStyle.SubControl = ... # 0x0
    SC_ComboBoxFrame         : QStyle.SubControl = ... # 0x1
    SC_DialGroove            : QStyle.SubControl = ... # 0x1
    SC_GroupBoxCheckBox      : QStyle.SubControl = ... # 0x1
    SC_MdiMinButton          : QStyle.SubControl = ... # 0x1
    SC_ScrollBarAddLine      : QStyle.SubControl = ... # 0x1
    SC_SliderGroove          : QStyle.SubControl = ... # 0x1
    SC_SpinBoxUp             : QStyle.SubControl = ... # 0x1
    SC_TitleBarSysMenu       : QStyle.SubControl = ... # 0x1
    SC_ToolButton            : QStyle.SubControl = ... # 0x1
    SC_ComboBoxEditField     : QStyle.SubControl = ... # 0x2
    SC_DialHandle            : QStyle.SubControl = ... # 0x2
    SC_GroupBoxLabel         : QStyle.SubControl = ... # 0x2
    SC_MdiNormalButton       : QStyle.SubControl = ... # 0x2
    SC_ScrollBarSubLine      : QStyle.SubControl = ... # 0x2
    SC_SliderHandle          : QStyle.SubControl = ... # 0x2
    SC_SpinBoxDown           : QStyle.SubControl = ... # 0x2
    SC_TitleBarMinButton     : QStyle.SubControl = ... # 0x2
    SC_ToolButtonMenu        : QStyle.SubControl = ... # 0x2
    SC_ComboBoxArrow         : QStyle.SubControl = ... # 0x4
    SC_DialTickmarks         : QStyle.SubControl = ... # 0x4
    SC_GroupBoxContents      : QStyle.SubControl = ... # 0x4
    SC_MdiCloseButton        : QStyle.SubControl = ... # 0x4
    SC_ScrollBarAddPage      : QStyle.SubControl = ... # 0x4
    SC_SliderTickmarks       : QStyle.SubControl = ... # 0x4
    SC_SpinBoxFrame          : QStyle.SubControl = ... # 0x4
    SC_TitleBarMaxButton     : QStyle.SubControl = ... # 0x4
    SC_ComboBoxListBoxPopup  : QStyle.SubControl = ... # 0x8
    SC_GroupBoxFrame         : QStyle.SubControl = ... # 0x8
    SC_ScrollBarSubPage      : QStyle.SubControl = ... # 0x8
    SC_SpinBoxEditField      : QStyle.SubControl = ... # 0x8
    SC_TitleBarCloseButton   : QStyle.SubControl = ... # 0x8
    SC_ScrollBarFirst        : QStyle.SubControl = ... # 0x10
    SC_TitleBarNormalButton  : QStyle.SubControl = ... # 0x10
    SC_ScrollBarLast         : QStyle.SubControl = ... # 0x20
    SC_TitleBarShadeButton   : QStyle.SubControl = ... # 0x20
    SC_ScrollBarSlider       : QStyle.SubControl = ... # 0x40
    SC_TitleBarUnshadeButton : QStyle.SubControl = ... # 0x40
    SC_ScrollBarGroove       : QStyle.SubControl = ... # 0x80
    SC_TitleBarContextHelpButton: QStyle.SubControl = ... # 0x80
    SC_TitleBarLabel         : QStyle.SubControl = ... # 0x100
    SC_CustomBase            : QStyle.SubControl = ... # -0x10000000
    SC_All                   : QStyle.SubControl = ... # -0x1
    SE_PushButtonContents    : QStyle.SubElement = ... # 0x0
    SE_PushButtonFocusRect   : QStyle.SubElement = ... # 0x1
    SE_CheckBoxIndicator     : QStyle.SubElement = ... # 0x2
    SE_CheckBoxContents      : QStyle.SubElement = ... # 0x3
    SE_CheckBoxFocusRect     : QStyle.SubElement = ... # 0x4
    SE_CheckBoxClickRect     : QStyle.SubElement = ... # 0x5
    SE_RadioButtonIndicator  : QStyle.SubElement = ... # 0x6
    SE_RadioButtonContents   : QStyle.SubElement = ... # 0x7
    SE_RadioButtonFocusRect  : QStyle.SubElement = ... # 0x8
    SE_RadioButtonClickRect  : QStyle.SubElement = ... # 0x9
    SE_ComboBoxFocusRect     : QStyle.SubElement = ... # 0xa
    SE_SliderFocusRect       : QStyle.SubElement = ... # 0xb
    SE_ProgressBarGroove     : QStyle.SubElement = ... # 0xc
    SE_ProgressBarContents   : QStyle.SubElement = ... # 0xd
    SE_ProgressBarLabel      : QStyle.SubElement = ... # 0xe
    SE_ToolBoxTabContents    : QStyle.SubElement = ... # 0xf
    SE_HeaderLabel           : QStyle.SubElement = ... # 0x10
    SE_HeaderArrow           : QStyle.SubElement = ... # 0x11
    SE_TabWidgetTabBar       : QStyle.SubElement = ... # 0x12
    SE_TabWidgetTabPane      : QStyle.SubElement = ... # 0x13
    SE_TabWidgetTabContents  : QStyle.SubElement = ... # 0x14
    SE_TabWidgetLeftCorner   : QStyle.SubElement = ... # 0x15
    SE_TabWidgetRightCorner  : QStyle.SubElement = ... # 0x16
    SE_ItemViewItemCheckIndicator: QStyle.SubElement = ... # 0x17
    SE_ViewItemCheckIndicator: QStyle.SubElement = ... # 0x17
    SE_TabBarTearIndicator   : QStyle.SubElement = ... # 0x18
    SE_TabBarTearIndicatorLeft: QStyle.SubElement = ... # 0x18
    SE_TreeViewDisclosureItem: QStyle.SubElement = ... # 0x19
    SE_LineEditContents      : QStyle.SubElement = ... # 0x1a
    SE_FrameContents         : QStyle.SubElement = ... # 0x1b
    SE_DockWidgetCloseButton : QStyle.SubElement = ... # 0x1c
    SE_DockWidgetFloatButton : QStyle.SubElement = ... # 0x1d
    SE_DockWidgetTitleBarText: QStyle.SubElement = ... # 0x1e
    SE_DockWidgetIcon        : QStyle.SubElement = ... # 0x1f
    SE_CheckBoxLayoutItem    : QStyle.SubElement = ... # 0x20
    SE_ComboBoxLayoutItem    : QStyle.SubElement = ... # 0x21
    SE_DateTimeEditLayoutItem: QStyle.SubElement = ... # 0x22
    SE_DialogButtonBoxLayoutItem: QStyle.SubElement = ... # 0x23
    SE_LabelLayoutItem       : QStyle.SubElement = ... # 0x24
    SE_ProgressBarLayoutItem : QStyle.SubElement = ... # 0x25
    SE_PushButtonLayoutItem  : QStyle.SubElement = ... # 0x26
    SE_RadioButtonLayoutItem : QStyle.SubElement = ... # 0x27
    SE_SliderLayoutItem      : QStyle.SubElement = ... # 0x28
    SE_SpinBoxLayoutItem     : QStyle.SubElement = ... # 0x29
    SE_ToolButtonLayoutItem  : QStyle.SubElement = ... # 0x2a
    SE_FrameLayoutItem       : QStyle.SubElement = ... # 0x2b
    SE_GroupBoxLayoutItem    : QStyle.SubElement = ... # 0x2c
    SE_TabWidgetLayoutItem   : QStyle.SubElement = ... # 0x2d
    SE_ItemViewItemDecoration: QStyle.SubElement = ... # 0x2e
    SE_ItemViewItemText      : QStyle.SubElement = ... # 0x2f
    SE_ItemViewItemFocusRect : QStyle.SubElement = ... # 0x30
    SE_TabBarTabLeftButton   : QStyle.SubElement = ... # 0x31
    SE_TabBarTabRightButton  : QStyle.SubElement = ... # 0x32
    SE_TabBarTabText         : QStyle.SubElement = ... # 0x33
    SE_ShapedFrameContents   : QStyle.SubElement = ... # 0x34
    SE_ToolBarHandle         : QStyle.SubElement = ... # 0x35
    SE_TabBarScrollLeftButton: QStyle.SubElement = ... # 0x36
    SE_TabBarScrollRightButton: QStyle.SubElement = ... # 0x37
    SE_TabBarTearIndicatorRight: QStyle.SubElement = ... # 0x38
    SE_PushButtonBevel       : QStyle.SubElement = ... # 0x39
    SE_CustomBase            : QStyle.SubElement = ... # 0xf0000000

    class ComplexControl(Shiboken.Enum):
        CC_SpinBox               : QStyle.ComplexControl = ... # 0x0
        CC_ComboBox              : QStyle.ComplexControl = ... # 0x1
        CC_ScrollBar             : QStyle.ComplexControl = ... # 0x2
        CC_Slider                : QStyle.ComplexControl = ... # 0x3
        CC_ToolButton            : QStyle.ComplexControl = ... # 0x4
        CC_TitleBar              : QStyle.ComplexControl = ... # 0x5
        CC_Dial                  : QStyle.ComplexControl = ... # 0x6
        CC_GroupBox              : QStyle.ComplexControl = ... # 0x7
        CC_MdiControls           : QStyle.ComplexControl = ... # 0x8
        CC_CustomBase            : QStyle.ComplexControl = ... # 0xf0000000

    class ContentsType(Shiboken.Enum):
        CT_PushButton            : QStyle.ContentsType = ... # 0x0
        CT_CheckBox              : QStyle.ContentsType = ... # 0x1
        CT_RadioButton           : QStyle.ContentsType = ... # 0x2
        CT_ToolButton            : QStyle.ContentsType = ... # 0x3
        CT_ComboBox              : QStyle.ContentsType = ... # 0x4
        CT_Splitter              : QStyle.ContentsType = ... # 0x5
        CT_ProgressBar           : QStyle.ContentsType = ... # 0x6
        CT_MenuItem              : QStyle.ContentsType = ... # 0x7
        CT_MenuBarItem           : QStyle.ContentsType = ... # 0x8
        CT_MenuBar               : QStyle.ContentsType = ... # 0x9
        CT_Menu                  : QStyle.ContentsType = ... # 0xa
        CT_TabBarTab             : QStyle.ContentsType = ... # 0xb
        CT_Slider                : QStyle.ContentsType = ... # 0xc
        CT_ScrollBar             : QStyle.ContentsType = ... # 0xd
        CT_LineEdit              : QStyle.ContentsType = ... # 0xe
        CT_SpinBox               : QStyle.ContentsType = ... # 0xf
        CT_SizeGrip              : QStyle.ContentsType = ... # 0x10
        CT_TabWidget             : QStyle.ContentsType = ... # 0x11
        CT_DialogButtons         : QStyle.ContentsType = ... # 0x12
        CT_HeaderSection         : QStyle.ContentsType = ... # 0x13
        CT_GroupBox              : QStyle.ContentsType = ... # 0x14
        CT_MdiControls           : QStyle.ContentsType = ... # 0x15
        CT_ItemViewItem          : QStyle.ContentsType = ... # 0x16
        CT_CustomBase            : QStyle.ContentsType = ... # 0xf0000000

    class ControlElement(Shiboken.Enum):
        CE_PushButton            : QStyle.ControlElement = ... # 0x0
        CE_PushButtonBevel       : QStyle.ControlElement = ... # 0x1
        CE_PushButtonLabel       : QStyle.ControlElement = ... # 0x2
        CE_CheckBox              : QStyle.ControlElement = ... # 0x3
        CE_CheckBoxLabel         : QStyle.ControlElement = ... # 0x4
        CE_RadioButton           : QStyle.ControlElement = ... # 0x5
        CE_RadioButtonLabel      : QStyle.ControlElement = ... # 0x6
        CE_TabBarTab             : QStyle.ControlElement = ... # 0x7
        CE_TabBarTabShape        : QStyle.ControlElement = ... # 0x8
        CE_TabBarTabLabel        : QStyle.ControlElement = ... # 0x9
        CE_ProgressBar           : QStyle.ControlElement = ... # 0xa
        CE_ProgressBarGroove     : QStyle.ControlElement = ... # 0xb
        CE_ProgressBarContents   : QStyle.ControlElement = ... # 0xc
        CE_ProgressBarLabel      : QStyle.ControlElement = ... # 0xd
        CE_MenuItem              : QStyle.ControlElement = ... # 0xe
        CE_MenuScroller          : QStyle.ControlElement = ... # 0xf
        CE_MenuVMargin           : QStyle.ControlElement = ... # 0x10
        CE_MenuHMargin           : QStyle.ControlElement = ... # 0x11
        CE_MenuTearoff           : QStyle.ControlElement = ... # 0x12
        CE_MenuEmptyArea         : QStyle.ControlElement = ... # 0x13
        CE_MenuBarItem           : QStyle.ControlElement = ... # 0x14
        CE_MenuBarEmptyArea      : QStyle.ControlElement = ... # 0x15
        CE_ToolButtonLabel       : QStyle.ControlElement = ... # 0x16
        CE_Header                : QStyle.ControlElement = ... # 0x17
        CE_HeaderSection         : QStyle.ControlElement = ... # 0x18
        CE_HeaderLabel           : QStyle.ControlElement = ... # 0x19
        CE_ToolBoxTab            : QStyle.ControlElement = ... # 0x1a
        CE_SizeGrip              : QStyle.ControlElement = ... # 0x1b
        CE_Splitter              : QStyle.ControlElement = ... # 0x1c
        CE_RubberBand            : QStyle.ControlElement = ... # 0x1d
        CE_DockWidgetTitle       : QStyle.ControlElement = ... # 0x1e
        CE_ScrollBarAddLine      : QStyle.ControlElement = ... # 0x1f
        CE_ScrollBarSubLine      : QStyle.ControlElement = ... # 0x20
        CE_ScrollBarAddPage      : QStyle.ControlElement = ... # 0x21
        CE_ScrollBarSubPage      : QStyle.ControlElement = ... # 0x22
        CE_ScrollBarSlider       : QStyle.ControlElement = ... # 0x23
        CE_ScrollBarFirst        : QStyle.ControlElement = ... # 0x24
        CE_ScrollBarLast         : QStyle.ControlElement = ... # 0x25
        CE_FocusFrame            : QStyle.ControlElement = ... # 0x26
        CE_ComboBoxLabel         : QStyle.ControlElement = ... # 0x27
        CE_ToolBar               : QStyle.ControlElement = ... # 0x28
        CE_ToolBoxTabShape       : QStyle.ControlElement = ... # 0x29
        CE_ToolBoxTabLabel       : QStyle.ControlElement = ... # 0x2a
        CE_HeaderEmptyArea       : QStyle.ControlElement = ... # 0x2b
        CE_ColumnViewGrip        : QStyle.ControlElement = ... # 0x2c
        CE_ItemViewItem          : QStyle.ControlElement = ... # 0x2d
        CE_ShapedFrame           : QStyle.ControlElement = ... # 0x2e
        CE_CustomBase            : QStyle.ControlElement = ... # 0xf0000000

    class PixelMetric(Shiboken.Enum):
        PM_ButtonMargin          : QStyle.PixelMetric = ... # 0x0
        PM_ButtonDefaultIndicator: QStyle.PixelMetric = ... # 0x1
        PM_MenuButtonIndicator   : QStyle.PixelMetric = ... # 0x2
        PM_ButtonShiftHorizontal : QStyle.PixelMetric = ... # 0x3
        PM_ButtonShiftVertical   : QStyle.PixelMetric = ... # 0x4
        PM_DefaultFrameWidth     : QStyle.PixelMetric = ... # 0x5
        PM_SpinBoxFrameWidth     : QStyle.PixelMetric = ... # 0x6
        PM_ComboBoxFrameWidth    : QStyle.PixelMetric = ... # 0x7
        PM_MaximumDragDistance   : QStyle.PixelMetric = ... # 0x8
        PM_ScrollBarExtent       : QStyle.PixelMetric = ... # 0x9
        PM_ScrollBarSliderMin    : QStyle.PixelMetric = ... # 0xa
        PM_SliderThickness       : QStyle.PixelMetric = ... # 0xb
        PM_SliderControlThickness: QStyle.PixelMetric = ... # 0xc
        PM_SliderLength          : QStyle.PixelMetric = ... # 0xd
        PM_SliderTickmarkOffset  : QStyle.PixelMetric = ... # 0xe
        PM_SliderSpaceAvailable  : QStyle.PixelMetric = ... # 0xf
        PM_DockWidgetSeparatorExtent: QStyle.PixelMetric = ... # 0x10
        PM_DockWidgetHandleExtent: QStyle.PixelMetric = ... # 0x11
        PM_DockWidgetFrameWidth  : QStyle.PixelMetric = ... # 0x12
        PM_TabBarTabOverlap      : QStyle.PixelMetric = ... # 0x13
        PM_TabBarTabHSpace       : QStyle.PixelMetric = ... # 0x14
        PM_TabBarTabVSpace       : QStyle.PixelMetric = ... # 0x15
        PM_TabBarBaseHeight      : QStyle.PixelMetric = ... # 0x16
        PM_TabBarBaseOverlap     : QStyle.PixelMetric = ... # 0x17
        PM_ProgressBarChunkWidth : QStyle.PixelMetric = ... # 0x18
        PM_SplitterWidth         : QStyle.PixelMetric = ... # 0x19
        PM_TitleBarHeight        : QStyle.PixelMetric = ... # 0x1a
        PM_MenuScrollerHeight    : QStyle.PixelMetric = ... # 0x1b
        PM_MenuHMargin           : QStyle.PixelMetric = ... # 0x1c
        PM_MenuVMargin           : QStyle.PixelMetric = ... # 0x1d
        PM_MenuPanelWidth        : QStyle.PixelMetric = ... # 0x1e
        PM_MenuTearoffHeight     : QStyle.PixelMetric = ... # 0x1f
        PM_MenuDesktopFrameWidth : QStyle.PixelMetric = ... # 0x20
        PM_MenuBarPanelWidth     : QStyle.PixelMetric = ... # 0x21
        PM_MenuBarItemSpacing    : QStyle.PixelMetric = ... # 0x22
        PM_MenuBarVMargin        : QStyle.PixelMetric = ... # 0x23
        PM_MenuBarHMargin        : QStyle.PixelMetric = ... # 0x24
        PM_IndicatorWidth        : QStyle.PixelMetric = ... # 0x25
        PM_IndicatorHeight       : QStyle.PixelMetric = ... # 0x26
        PM_ExclusiveIndicatorWidth: QStyle.PixelMetric = ... # 0x27
        PM_ExclusiveIndicatorHeight: QStyle.PixelMetric = ... # 0x28
        PM_DialogButtonsSeparator: QStyle.PixelMetric = ... # 0x29
        PM_DialogButtonsButtonWidth: QStyle.PixelMetric = ... # 0x2a
        PM_DialogButtonsButtonHeight: QStyle.PixelMetric = ... # 0x2b
        PM_MDIFrameWidth         : QStyle.PixelMetric = ... # 0x2c
        PM_MdiSubWindowFrameWidth: QStyle.PixelMetric = ... # 0x2c
        PM_MDIMinimizedWidth     : QStyle.PixelMetric = ... # 0x2d
        PM_MdiSubWindowMinimizedWidth: QStyle.PixelMetric = ... # 0x2d
        PM_HeaderMargin          : QStyle.PixelMetric = ... # 0x2e
        PM_HeaderMarkSize        : QStyle.PixelMetric = ... # 0x2f
        PM_HeaderGripMargin      : QStyle.PixelMetric = ... # 0x30
        PM_TabBarTabShiftHorizontal: QStyle.PixelMetric = ... # 0x31
        PM_TabBarTabShiftVertical: QStyle.PixelMetric = ... # 0x32
        PM_TabBarScrollButtonWidth: QStyle.PixelMetric = ... # 0x33
        PM_ToolBarFrameWidth     : QStyle.PixelMetric = ... # 0x34
        PM_ToolBarHandleExtent   : QStyle.PixelMetric = ... # 0x35
        PM_ToolBarItemSpacing    : QStyle.PixelMetric = ... # 0x36
        PM_ToolBarItemMargin     : QStyle.PixelMetric = ... # 0x37
        PM_ToolBarSeparatorExtent: QStyle.PixelMetric = ... # 0x38
        PM_ToolBarExtensionExtent: QStyle.PixelMetric = ... # 0x39
        PM_SpinBoxSliderHeight   : QStyle.PixelMetric = ... # 0x3a
        PM_DefaultTopLevelMargin : QStyle.PixelMetric = ... # 0x3b
        PM_DefaultChildMargin    : QStyle.PixelMetric = ... # 0x3c
        PM_DefaultLayoutSpacing  : QStyle.PixelMetric = ... # 0x3d
        PM_ToolBarIconSize       : QStyle.PixelMetric = ... # 0x3e
        PM_ListViewIconSize      : QStyle.PixelMetric = ... # 0x3f
        PM_IconViewIconSize      : QStyle.PixelMetric = ... # 0x40
        PM_SmallIconSize         : QStyle.PixelMetric = ... # 0x41
        PM_LargeIconSize         : QStyle.PixelMetric = ... # 0x42
        PM_FocusFrameVMargin     : QStyle.PixelMetric = ... # 0x43
        PM_FocusFrameHMargin     : QStyle.PixelMetric = ... # 0x44
        PM_ToolTipLabelFrameWidth: QStyle.PixelMetric = ... # 0x45
        PM_CheckBoxLabelSpacing  : QStyle.PixelMetric = ... # 0x46
        PM_TabBarIconSize        : QStyle.PixelMetric = ... # 0x47
        PM_SizeGripSize          : QStyle.PixelMetric = ... # 0x48
        PM_DockWidgetTitleMargin : QStyle.PixelMetric = ... # 0x49
        PM_MessageBoxIconSize    : QStyle.PixelMetric = ... # 0x4a
        PM_ButtonIconSize        : QStyle.PixelMetric = ... # 0x4b
        PM_DockWidgetTitleBarButtonMargin: QStyle.PixelMetric = ... # 0x4c
        PM_RadioButtonLabelSpacing: QStyle.PixelMetric = ... # 0x4d
        PM_LayoutLeftMargin      : QStyle.PixelMetric = ... # 0x4e
        PM_LayoutTopMargin       : QStyle.PixelMetric = ... # 0x4f
        PM_LayoutRightMargin     : QStyle.PixelMetric = ... # 0x50
        PM_LayoutBottomMargin    : QStyle.PixelMetric = ... # 0x51
        PM_LayoutHorizontalSpacing: QStyle.PixelMetric = ... # 0x52
        PM_LayoutVerticalSpacing : QStyle.PixelMetric = ... # 0x53
        PM_TabBar_ScrollButtonOverlap: QStyle.PixelMetric = ... # 0x54
        PM_TextCursorWidth       : QStyle.PixelMetric = ... # 0x55
        PM_TabCloseIndicatorWidth: QStyle.PixelMetric = ... # 0x56
        PM_TabCloseIndicatorHeight: QStyle.PixelMetric = ... # 0x57
        PM_ScrollView_ScrollBarSpacing: QStyle.PixelMetric = ... # 0x58
        PM_ScrollView_ScrollBarOverlap: QStyle.PixelMetric = ... # 0x59
        PM_SubMenuOverlap        : QStyle.PixelMetric = ... # 0x5a
        PM_TreeViewIndentation   : QStyle.PixelMetric = ... # 0x5b
        PM_HeaderDefaultSectionSizeHorizontal: QStyle.PixelMetric = ... # 0x5c
        PM_HeaderDefaultSectionSizeVertical: QStyle.PixelMetric = ... # 0x5d
        PM_TitleBarButtonIconSize: QStyle.PixelMetric = ... # 0x5e
        PM_TitleBarButtonSize    : QStyle.PixelMetric = ... # 0x5f
        PM_CustomBase            : QStyle.PixelMetric = ... # 0xf0000000

    class PrimitiveElement(Shiboken.Enum):
        PE_Frame                 : QStyle.PrimitiveElement = ... # 0x0
        PE_FrameDefaultButton    : QStyle.PrimitiveElement = ... # 0x1
        PE_FrameDockWidget       : QStyle.PrimitiveElement = ... # 0x2
        PE_FrameFocusRect        : QStyle.PrimitiveElement = ... # 0x3
        PE_FrameGroupBox         : QStyle.PrimitiveElement = ... # 0x4
        PE_FrameLineEdit         : QStyle.PrimitiveElement = ... # 0x5
        PE_FrameMenu             : QStyle.PrimitiveElement = ... # 0x6
        PE_FrameStatusBar        : QStyle.PrimitiveElement = ... # 0x7
        PE_FrameStatusBarItem    : QStyle.PrimitiveElement = ... # 0x7
        PE_FrameTabWidget        : QStyle.PrimitiveElement = ... # 0x8
        PE_FrameWindow           : QStyle.PrimitiveElement = ... # 0x9
        PE_FrameButtonBevel      : QStyle.PrimitiveElement = ... # 0xa
        PE_FrameButtonTool       : QStyle.PrimitiveElement = ... # 0xb
        PE_FrameTabBarBase       : QStyle.PrimitiveElement = ... # 0xc
        PE_PanelButtonCommand    : QStyle.PrimitiveElement = ... # 0xd
        PE_PanelButtonBevel      : QStyle.PrimitiveElement = ... # 0xe
        PE_PanelButtonTool       : QStyle.PrimitiveElement = ... # 0xf
        PE_PanelMenuBar          : QStyle.PrimitiveElement = ... # 0x10
        PE_PanelToolBar          : QStyle.PrimitiveElement = ... # 0x11
        PE_PanelLineEdit         : QStyle.PrimitiveElement = ... # 0x12
        PE_IndicatorArrowDown    : QStyle.PrimitiveElement = ... # 0x13
        PE_IndicatorArrowLeft    : QStyle.PrimitiveElement = ... # 0x14
        PE_IndicatorArrowRight   : QStyle.PrimitiveElement = ... # 0x15
        PE_IndicatorArrowUp      : QStyle.PrimitiveElement = ... # 0x16
        PE_IndicatorBranch       : QStyle.PrimitiveElement = ... # 0x17
        PE_IndicatorButtonDropDown: QStyle.PrimitiveElement = ... # 0x18
        PE_IndicatorItemViewItemCheck: QStyle.PrimitiveElement = ... # 0x19
        PE_IndicatorViewItemCheck: QStyle.PrimitiveElement = ... # 0x19
        PE_IndicatorCheckBox     : QStyle.PrimitiveElement = ... # 0x1a
        PE_IndicatorDockWidgetResizeHandle: QStyle.PrimitiveElement = ... # 0x1b
        PE_IndicatorHeaderArrow  : QStyle.PrimitiveElement = ... # 0x1c
        PE_IndicatorMenuCheckMark: QStyle.PrimitiveElement = ... # 0x1d
        PE_IndicatorProgressChunk: QStyle.PrimitiveElement = ... # 0x1e
        PE_IndicatorRadioButton  : QStyle.PrimitiveElement = ... # 0x1f
        PE_IndicatorSpinDown     : QStyle.PrimitiveElement = ... # 0x20
        PE_IndicatorSpinMinus    : QStyle.PrimitiveElement = ... # 0x21
        PE_IndicatorSpinPlus     : QStyle.PrimitiveElement = ... # 0x22
        PE_IndicatorSpinUp       : QStyle.PrimitiveElement = ... # 0x23
        PE_IndicatorToolBarHandle: QStyle.PrimitiveElement = ... # 0x24
        PE_IndicatorToolBarSeparator: QStyle.PrimitiveElement = ... # 0x25
        PE_PanelTipLabel         : QStyle.PrimitiveElement = ... # 0x26
        PE_IndicatorTabTear      : QStyle.PrimitiveElement = ... # 0x27
        PE_IndicatorTabTearLeft  : QStyle.PrimitiveElement = ... # 0x27
        PE_PanelScrollAreaCorner : QStyle.PrimitiveElement = ... # 0x28
        PE_Widget                : QStyle.PrimitiveElement = ... # 0x29
        PE_IndicatorColumnViewArrow: QStyle.PrimitiveElement = ... # 0x2a
        PE_IndicatorItemViewItemDrop: QStyle.PrimitiveElement = ... # 0x2b
        PE_PanelItemViewItem     : QStyle.PrimitiveElement = ... # 0x2c
        PE_PanelItemViewRow      : QStyle.PrimitiveElement = ... # 0x2d
        PE_PanelStatusBar        : QStyle.PrimitiveElement = ... # 0x2e
        PE_IndicatorTabClose     : QStyle.PrimitiveElement = ... # 0x2f
        PE_PanelMenu             : QStyle.PrimitiveElement = ... # 0x30
        PE_IndicatorTabTearRight : QStyle.PrimitiveElement = ... # 0x31
        PE_CustomBase            : QStyle.PrimitiveElement = ... # 0xf000000

    class RequestSoftwareInputPanel(Shiboken.Enum):
        RSIP_OnMouseClickAndAlreadyFocused: QStyle.RequestSoftwareInputPanel = ... # 0x0
        RSIP_OnMouseClick        : QStyle.RequestSoftwareInputPanel = ... # 0x1

    class StandardPixmap(Shiboken.Enum):
        SP_TitleBarMenuButton    : QStyle.StandardPixmap = ... # 0x0
        SP_TitleBarMinButton     : QStyle.StandardPixmap = ... # 0x1
        SP_TitleBarMaxButton     : QStyle.StandardPixmap = ... # 0x2
        SP_TitleBarCloseButton   : QStyle.StandardPixmap = ... # 0x3
        SP_TitleBarNormalButton  : QStyle.StandardPixmap = ... # 0x4
        SP_TitleBarShadeButton   : QStyle.StandardPixmap = ... # 0x5
        SP_TitleBarUnshadeButton : QStyle.StandardPixmap = ... # 0x6
        SP_TitleBarContextHelpButton: QStyle.StandardPixmap = ... # 0x7
        SP_DockWidgetCloseButton : QStyle.StandardPixmap = ... # 0x8
        SP_MessageBoxInformation : QStyle.StandardPixmap = ... # 0x9
        SP_MessageBoxWarning     : QStyle.StandardPixmap = ... # 0xa
        SP_MessageBoxCritical    : QStyle.StandardPixmap = ... # 0xb
        SP_MessageBoxQuestion    : QStyle.StandardPixmap = ... # 0xc
        SP_DesktopIcon           : QStyle.StandardPixmap = ... # 0xd
        SP_TrashIcon             : QStyle.StandardPixmap = ... # 0xe
        SP_ComputerIcon          : QStyle.StandardPixmap = ... # 0xf
        SP_DriveFDIcon           : QStyle.StandardPixmap = ... # 0x10
        SP_DriveHDIcon           : QStyle.StandardPixmap = ... # 0x11
        SP_DriveCDIcon           : QStyle.StandardPixmap = ... # 0x12
        SP_DriveDVDIcon          : QStyle.StandardPixmap = ... # 0x13
        SP_DriveNetIcon          : QStyle.StandardPixmap = ... # 0x14
        SP_DirOpenIcon           : QStyle.StandardPixmap = ... # 0x15
        SP_DirClosedIcon         : QStyle.StandardPixmap = ... # 0x16
        SP_DirLinkIcon           : QStyle.StandardPixmap = ... # 0x17
        SP_DirLinkOpenIcon       : QStyle.StandardPixmap = ... # 0x18
        SP_FileIcon              : QStyle.StandardPixmap = ... # 0x19
        SP_FileLinkIcon          : QStyle.StandardPixmap = ... # 0x1a
        SP_ToolBarHorizontalExtensionButton: QStyle.StandardPixmap = ... # 0x1b
        SP_ToolBarVerticalExtensionButton: QStyle.StandardPixmap = ... # 0x1c
        SP_FileDialogStart       : QStyle.StandardPixmap = ... # 0x1d
        SP_FileDialogEnd         : QStyle.StandardPixmap = ... # 0x1e
        SP_FileDialogToParent    : QStyle.StandardPixmap = ... # 0x1f
        SP_FileDialogNewFolder   : QStyle.StandardPixmap = ... # 0x20
        SP_FileDialogDetailedView: QStyle.StandardPixmap = ... # 0x21
        SP_FileDialogInfoView    : QStyle.StandardPixmap = ... # 0x22
        SP_FileDialogContentsView: QStyle.StandardPixmap = ... # 0x23
        SP_FileDialogListView    : QStyle.StandardPixmap = ... # 0x24
        SP_FileDialogBack        : QStyle.StandardPixmap = ... # 0x25
        SP_DirIcon               : QStyle.StandardPixmap = ... # 0x26
        SP_DialogOkButton        : QStyle.StandardPixmap = ... # 0x27
        SP_DialogCancelButton    : QStyle.StandardPixmap = ... # 0x28
        SP_DialogHelpButton      : QStyle.StandardPixmap = ... # 0x29
        SP_DialogOpenButton      : QStyle.StandardPixmap = ... # 0x2a
        SP_DialogSaveButton      : QStyle.StandardPixmap = ... # 0x2b
        SP_DialogCloseButton     : QStyle.StandardPixmap = ... # 0x2c
        SP_DialogApplyButton     : QStyle.StandardPixmap = ... # 0x2d
        SP_DialogResetButton     : QStyle.StandardPixmap = ... # 0x2e
        SP_DialogDiscardButton   : QStyle.StandardPixmap = ... # 0x2f
        SP_DialogYesButton       : QStyle.StandardPixmap = ... # 0x30
        SP_DialogNoButton        : QStyle.StandardPixmap = ... # 0x31
        SP_ArrowUp               : QStyle.StandardPixmap = ... # 0x32
        SP_ArrowDown             : QStyle.StandardPixmap = ... # 0x33
        SP_ArrowLeft             : QStyle.StandardPixmap = ... # 0x34
        SP_ArrowRight            : QStyle.StandardPixmap = ... # 0x35
        SP_ArrowBack             : QStyle.StandardPixmap = ... # 0x36
        SP_ArrowForward          : QStyle.StandardPixmap = ... # 0x37
        SP_DirHomeIcon           : QStyle.StandardPixmap = ... # 0x38
        SP_CommandLink           : QStyle.StandardPixmap = ... # 0x39
        SP_VistaShield           : QStyle.StandardPixmap = ... # 0x3a
        SP_BrowserReload         : QStyle.StandardPixmap = ... # 0x3b
        SP_BrowserStop           : QStyle.StandardPixmap = ... # 0x3c
        SP_MediaPlay             : QStyle.StandardPixmap = ... # 0x3d
        SP_MediaStop             : QStyle.StandardPixmap = ... # 0x3e
        SP_MediaPause            : QStyle.StandardPixmap = ... # 0x3f
        SP_MediaSkipForward      : QStyle.StandardPixmap = ... # 0x40
        SP_MediaSkipBackward     : QStyle.StandardPixmap = ... # 0x41
        SP_MediaSeekForward      : QStyle.StandardPixmap = ... # 0x42
        SP_MediaSeekBackward     : QStyle.StandardPixmap = ... # 0x43
        SP_MediaVolume           : QStyle.StandardPixmap = ... # 0x44
        SP_MediaVolumeMuted      : QStyle.StandardPixmap = ... # 0x45
        SP_LineEditClearButton   : QStyle.StandardPixmap = ... # 0x46
        SP_DialogYesToAllButton  : QStyle.StandardPixmap = ... # 0x47
        SP_DialogNoToAllButton   : QStyle.StandardPixmap = ... # 0x48
        SP_DialogSaveAllButton   : QStyle.StandardPixmap = ... # 0x49
        SP_DialogAbortButton     : QStyle.StandardPixmap = ... # 0x4a
        SP_DialogRetryButton     : QStyle.StandardPixmap = ... # 0x4b
        SP_DialogIgnoreButton    : QStyle.StandardPixmap = ... # 0x4c
        SP_RestoreDefaultsButton : QStyle.StandardPixmap = ... # 0x4d
        SP_CustomBase            : QStyle.StandardPixmap = ... # 0xf0000000

    class State(object): ...

    class StateFlag(Shiboken.Enum):
        State_None               : QStyle.StateFlag = ... # 0x0
        State_Enabled            : QStyle.StateFlag = ... # 0x1
        State_Raised             : QStyle.StateFlag = ... # 0x2
        State_Sunken             : QStyle.StateFlag = ... # 0x4
        State_Off                : QStyle.StateFlag = ... # 0x8
        State_NoChange           : QStyle.StateFlag = ... # 0x10
        State_On                 : QStyle.StateFlag = ... # 0x20
        State_DownArrow          : QStyle.StateFlag = ... # 0x40
        State_Horizontal         : QStyle.StateFlag = ... # 0x80
        State_HasFocus           : QStyle.StateFlag = ... # 0x100
        State_Top                : QStyle.StateFlag = ... # 0x200
        State_Bottom             : QStyle.StateFlag = ... # 0x400
        State_FocusAtBorder      : QStyle.StateFlag = ... # 0x800
        State_AutoRaise          : QStyle.StateFlag = ... # 0x1000
        State_MouseOver          : QStyle.StateFlag = ... # 0x2000
        State_UpArrow            : QStyle.StateFlag = ... # 0x4000
        State_Selected           : QStyle.StateFlag = ... # 0x8000
        State_Active             : QStyle.StateFlag = ... # 0x10000
        State_Window             : QStyle.StateFlag = ... # 0x20000
        State_Open               : QStyle.StateFlag = ... # 0x40000
        State_Children           : QStyle.StateFlag = ... # 0x80000
        State_Item               : QStyle.StateFlag = ... # 0x100000
        State_Sibling            : QStyle.StateFlag = ... # 0x200000
        State_Editing            : QStyle.StateFlag = ... # 0x400000
        State_KeyboardFocusChange: QStyle.StateFlag = ... # 0x800000
        State_ReadOnly           : QStyle.StateFlag = ... # 0x2000000
        State_Small              : QStyle.StateFlag = ... # 0x4000000
        State_Mini               : QStyle.StateFlag = ... # 0x8000000

    class StyleHint(Shiboken.Enum):
        SH_EtchDisabledText      : QStyle.StyleHint = ... # 0x0
        SH_DitherDisabledText    : QStyle.StyleHint = ... # 0x1
        SH_ScrollBar_MiddleClickAbsolutePosition: QStyle.StyleHint = ... # 0x2
        SH_ScrollBar_ScrollWhenPointerLeavesControl: QStyle.StyleHint = ... # 0x3
        SH_TabBar_SelectMouseType: QStyle.StyleHint = ... # 0x4
        SH_TabBar_Alignment      : QStyle.StyleHint = ... # 0x5
        SH_Header_ArrowAlignment : QStyle.StyleHint = ... # 0x6
        SH_Slider_SnapToValue    : QStyle.StyleHint = ... # 0x7
        SH_Slider_SloppyKeyEvents: QStyle.StyleHint = ... # 0x8
        SH_ProgressDialog_CenterCancelButton: QStyle.StyleHint = ... # 0x9
        SH_ProgressDialog_TextLabelAlignment: QStyle.StyleHint = ... # 0xa
        SH_PrintDialog_RightAlignButtons: QStyle.StyleHint = ... # 0xb
        SH_MainWindow_SpaceBelowMenuBar: QStyle.StyleHint = ... # 0xc
        SH_FontDialog_SelectAssociatedText: QStyle.StyleHint = ... # 0xd
        SH_Menu_AllowActiveAndDisabled: QStyle.StyleHint = ... # 0xe
        SH_Menu_SpaceActivatesItem: QStyle.StyleHint = ... # 0xf
        SH_Menu_SubMenuPopupDelay: QStyle.StyleHint = ... # 0x10
        SH_ScrollView_FrameOnlyAroundContents: QStyle.StyleHint = ... # 0x11
        SH_MenuBar_AltKeyNavigation: QStyle.StyleHint = ... # 0x12
        SH_ComboBox_ListMouseTracking: QStyle.StyleHint = ... # 0x13
        SH_Menu_MouseTracking    : QStyle.StyleHint = ... # 0x14
        SH_MenuBar_MouseTracking : QStyle.StyleHint = ... # 0x15
        SH_ItemView_ChangeHighlightOnFocus: QStyle.StyleHint = ... # 0x16
        SH_Widget_ShareActivation: QStyle.StyleHint = ... # 0x17
        SH_Workspace_FillSpaceOnMaximize: QStyle.StyleHint = ... # 0x18
        SH_ComboBox_Popup        : QStyle.StyleHint = ... # 0x19
        SH_TitleBar_NoBorder     : QStyle.StyleHint = ... # 0x1a
        SH_ScrollBar_StopMouseOverSlider: QStyle.StyleHint = ... # 0x1b
        SH_Slider_StopMouseOverSlider: QStyle.StyleHint = ... # 0x1b
        SH_BlinkCursorWhenTextSelected: QStyle.StyleHint = ... # 0x1c
        SH_RichText_FullWidthSelection: QStyle.StyleHint = ... # 0x1d
        SH_Menu_Scrollable       : QStyle.StyleHint = ... # 0x1e
        SH_GroupBox_TextLabelVerticalAlignment: QStyle.StyleHint = ... # 0x1f
        SH_GroupBox_TextLabelColor: QStyle.StyleHint = ... # 0x20
        SH_Menu_SloppySubMenus   : QStyle.StyleHint = ... # 0x21
        SH_Table_GridLineColor   : QStyle.StyleHint = ... # 0x22
        SH_LineEdit_PasswordCharacter: QStyle.StyleHint = ... # 0x23
        SH_DialogButtons_DefaultButton: QStyle.StyleHint = ... # 0x24
        SH_ToolBox_SelectedPageTitleBold: QStyle.StyleHint = ... # 0x25
        SH_TabBar_PreferNoArrows : QStyle.StyleHint = ... # 0x26
        SH_ScrollBar_LeftClickAbsolutePosition: QStyle.StyleHint = ... # 0x27
        SH_ListViewExpand_SelectMouseType: QStyle.StyleHint = ... # 0x28
        SH_UnderlineShortcut     : QStyle.StyleHint = ... # 0x29
        SH_SpinBox_AnimateButton : QStyle.StyleHint = ... # 0x2a
        SH_SpinBox_KeyPressAutoRepeatRate: QStyle.StyleHint = ... # 0x2b
        SH_SpinBox_ClickAutoRepeatRate: QStyle.StyleHint = ... # 0x2c
        SH_Menu_FillScreenWithScroll: QStyle.StyleHint = ... # 0x2d
        SH_ToolTipLabel_Opacity  : QStyle.StyleHint = ... # 0x2e
        SH_DrawMenuBarSeparator  : QStyle.StyleHint = ... # 0x2f
        SH_TitleBar_ModifyNotification: QStyle.StyleHint = ... # 0x30
        SH_Button_FocusPolicy    : QStyle.StyleHint = ... # 0x31
        SH_MessageBox_UseBorderForButtonSpacing: QStyle.StyleHint = ... # 0x32
        SH_TitleBar_AutoRaise    : QStyle.StyleHint = ... # 0x33
        SH_ToolButton_PopupDelay : QStyle.StyleHint = ... # 0x34
        SH_FocusFrame_Mask       : QStyle.StyleHint = ... # 0x35
        SH_RubberBand_Mask       : QStyle.StyleHint = ... # 0x36
        SH_WindowFrame_Mask      : QStyle.StyleHint = ... # 0x37
        SH_SpinControls_DisableOnBounds: QStyle.StyleHint = ... # 0x38
        SH_Dial_BackgroundRole   : QStyle.StyleHint = ... # 0x39
        SH_ComboBox_LayoutDirection: QStyle.StyleHint = ... # 0x3a
        SH_ItemView_EllipsisLocation: QStyle.StyleHint = ... # 0x3b
        SH_ItemView_ShowDecorationSelected: QStyle.StyleHint = ... # 0x3c
        SH_ItemView_ActivateItemOnSingleClick: QStyle.StyleHint = ... # 0x3d
        SH_ScrollBar_ContextMenu : QStyle.StyleHint = ... # 0x3e
        SH_ScrollBar_RollBetweenButtons: QStyle.StyleHint = ... # 0x3f
        SH_Slider_AbsoluteSetButtons: QStyle.StyleHint = ... # 0x40
        SH_Slider_PageSetButtons : QStyle.StyleHint = ... # 0x41
        SH_Menu_KeyboardSearch   : QStyle.StyleHint = ... # 0x42
        SH_TabBar_ElideMode      : QStyle.StyleHint = ... # 0x43
        SH_DialogButtonLayout    : QStyle.StyleHint = ... # 0x44
        SH_ComboBox_PopupFrameStyle: QStyle.StyleHint = ... # 0x45
        SH_MessageBox_TextInteractionFlags: QStyle.StyleHint = ... # 0x46
        SH_DialogButtonBox_ButtonsHaveIcons: QStyle.StyleHint = ... # 0x47
        SH_SpellCheckUnderlineStyle: QStyle.StyleHint = ... # 0x48
        SH_MessageBox_CenterButtons: QStyle.StyleHint = ... # 0x49
        SH_Menu_SelectionWrap    : QStyle.StyleHint = ... # 0x4a
        SH_ItemView_MovementWithoutUpdatingSelection: QStyle.StyleHint = ... # 0x4b
        SH_ToolTip_Mask          : QStyle.StyleHint = ... # 0x4c
        SH_FocusFrame_AboveWidget: QStyle.StyleHint = ... # 0x4d
        SH_TextControl_FocusIndicatorTextCharFormat: QStyle.StyleHint = ... # 0x4e
        SH_WizardStyle           : QStyle.StyleHint = ... # 0x4f
        SH_ItemView_ArrowKeysNavigateIntoChildren: QStyle.StyleHint = ... # 0x50
        SH_Menu_Mask             : QStyle.StyleHint = ... # 0x51
        SH_Menu_FlashTriggeredItem: QStyle.StyleHint = ... # 0x52
        SH_Menu_FadeOutOnHide    : QStyle.StyleHint = ... # 0x53
        SH_SpinBox_ClickAutoRepeatThreshold: QStyle.StyleHint = ... # 0x54
        SH_ItemView_PaintAlternatingRowColorsForEmptyArea: QStyle.StyleHint = ... # 0x55
        SH_FormLayoutWrapPolicy  : QStyle.StyleHint = ... # 0x56
        SH_TabWidget_DefaultTabPosition: QStyle.StyleHint = ... # 0x57
        SH_ToolBar_Movable       : QStyle.StyleHint = ... # 0x58
        SH_FormLayoutFieldGrowthPolicy: QStyle.StyleHint = ... # 0x59
        SH_FormLayoutFormAlignment: QStyle.StyleHint = ... # 0x5a
        SH_FormLayoutLabelAlignment: QStyle.StyleHint = ... # 0x5b
        SH_ItemView_DrawDelegateFrame: QStyle.StyleHint = ... # 0x5c
        SH_TabBar_CloseButtonPosition: QStyle.StyleHint = ... # 0x5d
        SH_DockWidget_ButtonsHaveFrame: QStyle.StyleHint = ... # 0x5e
        SH_ToolButtonStyle       : QStyle.StyleHint = ... # 0x5f
        SH_RequestSoftwareInputPanel: QStyle.StyleHint = ... # 0x60
        SH_ScrollBar_Transient   : QStyle.StyleHint = ... # 0x61
        SH_Menu_SupportsSections : QStyle.StyleHint = ... # 0x62
        SH_ToolTip_WakeUpDelay   : QStyle.StyleHint = ... # 0x63
        SH_ToolTip_FallAsleepDelay: QStyle.StyleHint = ... # 0x64
        SH_Widget_Animate        : QStyle.StyleHint = ... # 0x65
        SH_Splitter_OpaqueResize : QStyle.StyleHint = ... # 0x66
        SH_ComboBox_UseNativePopup: QStyle.StyleHint = ... # 0x67
        SH_LineEdit_PasswordMaskDelay: QStyle.StyleHint = ... # 0x68
        SH_TabBar_ChangeCurrentDelay: QStyle.StyleHint = ... # 0x69
        SH_Menu_SubMenuUniDirection: QStyle.StyleHint = ... # 0x6a
        SH_Menu_SubMenuUniDirectionFailCount: QStyle.StyleHint = ... # 0x6b
        SH_Menu_SubMenuSloppySelectOtherActions: QStyle.StyleHint = ... # 0x6c
        SH_Menu_SubMenuSloppyCloseTimeout: QStyle.StyleHint = ... # 0x6d
        SH_Menu_SubMenuResetWhenReenteringParent: QStyle.StyleHint = ... # 0x6e
        SH_Menu_SubMenuDontStartSloppyOnLeave: QStyle.StyleHint = ... # 0x6f
        SH_ItemView_ScrollMode   : QStyle.StyleHint = ... # 0x70
        SH_TitleBar_ShowToolTipsOnButtons: QStyle.StyleHint = ... # 0x71
        SH_Widget_Animation_Duration: QStyle.StyleHint = ... # 0x72
        SH_ComboBox_AllowWheelScrolling: QStyle.StyleHint = ... # 0x73
        SH_SpinBox_ButtonsInsideFrame: QStyle.StyleHint = ... # 0x74
        SH_SpinBox_StepModifier  : QStyle.StyleHint = ... # 0x75
        SH_CustomBase            : QStyle.StyleHint = ... # 0xf0000000

    class SubControl(Shiboken.Enum):
        SC_None                  : QStyle.SubControl = ... # 0x0
        SC_ComboBoxFrame         : QStyle.SubControl = ... # 0x1
        SC_DialGroove            : QStyle.SubControl = ... # 0x1
        SC_GroupBoxCheckBox      : QStyle.SubControl = ... # 0x1
        SC_MdiMinButton          : QStyle.SubControl = ... # 0x1
        SC_ScrollBarAddLine      : QStyle.SubControl = ... # 0x1
        SC_SliderGroove          : QStyle.SubControl = ... # 0x1
        SC_SpinBoxUp             : QStyle.SubControl = ... # 0x1
        SC_TitleBarSysMenu       : QStyle.SubControl = ... # 0x1
        SC_ToolButton            : QStyle.SubControl = ... # 0x1
        SC_ComboBoxEditField     : QStyle.SubControl = ... # 0x2
        SC_DialHandle            : QStyle.SubControl = ... # 0x2
        SC_GroupBoxLabel         : QStyle.SubControl = ... # 0x2
        SC_MdiNormalButton       : QStyle.SubControl = ... # 0x2
        SC_ScrollBarSubLine      : QStyle.SubControl = ... # 0x2
        SC_SliderHandle          : QStyle.SubControl = ... # 0x2
        SC_SpinBoxDown           : QStyle.SubControl = ... # 0x2
        SC_TitleBarMinButton     : QStyle.SubControl = ... # 0x2
        SC_ToolButtonMenu        : QStyle.SubControl = ... # 0x2
        SC_ComboBoxArrow         : QStyle.SubControl = ... # 0x4
        SC_DialTickmarks         : QStyle.SubControl = ... # 0x4
        SC_GroupBoxContents      : QStyle.SubControl = ... # 0x4
        SC_MdiCloseButton        : QStyle.SubControl = ... # 0x4
        SC_ScrollBarAddPage      : QStyle.SubControl = ... # 0x4
        SC_SliderTickmarks       : QStyle.SubControl = ... # 0x4
        SC_SpinBoxFrame          : QStyle.SubControl = ... # 0x4
        SC_TitleBarMaxButton     : QStyle.SubControl = ... # 0x4
        SC_ComboBoxListBoxPopup  : QStyle.SubControl = ... # 0x8
        SC_GroupBoxFrame         : QStyle.SubControl = ... # 0x8
        SC_ScrollBarSubPage      : QStyle.SubControl = ... # 0x8
        SC_SpinBoxEditField      : QStyle.SubControl = ... # 0x8
        SC_TitleBarCloseButton   : QStyle.SubControl = ... # 0x8
        SC_ScrollBarFirst        : QStyle.SubControl = ... # 0x10
        SC_TitleBarNormalButton  : QStyle.SubControl = ... # 0x10
        SC_ScrollBarLast         : QStyle.SubControl = ... # 0x20
        SC_TitleBarShadeButton   : QStyle.SubControl = ... # 0x20
        SC_ScrollBarSlider       : QStyle.SubControl = ... # 0x40
        SC_TitleBarUnshadeButton : QStyle.SubControl = ... # 0x40
        SC_ScrollBarGroove       : QStyle.SubControl = ... # 0x80
        SC_TitleBarContextHelpButton: QStyle.SubControl = ... # 0x80
        SC_TitleBarLabel         : QStyle.SubControl = ... # 0x100
        SC_CustomBase            : QStyle.SubControl = ... # -0x10000000
        SC_All                   : QStyle.SubControl = ... # -0x1

    class SubControls(object): ...

    class SubElement(Shiboken.Enum):
        SE_PushButtonContents    : QStyle.SubElement = ... # 0x0
        SE_PushButtonFocusRect   : QStyle.SubElement = ... # 0x1
        SE_CheckBoxIndicator     : QStyle.SubElement = ... # 0x2
        SE_CheckBoxContents      : QStyle.SubElement = ... # 0x3
        SE_CheckBoxFocusRect     : QStyle.SubElement = ... # 0x4
        SE_CheckBoxClickRect     : QStyle.SubElement = ... # 0x5
        SE_RadioButtonIndicator  : QStyle.SubElement = ... # 0x6
        SE_RadioButtonContents   : QStyle.SubElement = ... # 0x7
        SE_RadioButtonFocusRect  : QStyle.SubElement = ... # 0x8
        SE_RadioButtonClickRect  : QStyle.SubElement = ... # 0x9
        SE_ComboBoxFocusRect     : QStyle.SubElement = ... # 0xa
        SE_SliderFocusRect       : QStyle.SubElement = ... # 0xb
        SE_ProgressBarGroove     : QStyle.SubElement = ... # 0xc
        SE_ProgressBarContents   : QStyle.SubElement = ... # 0xd
        SE_ProgressBarLabel      : QStyle.SubElement = ... # 0xe
        SE_ToolBoxTabContents    : QStyle.SubElement = ... # 0xf
        SE_HeaderLabel           : QStyle.SubElement = ... # 0x10
        SE_HeaderArrow           : QStyle.SubElement = ... # 0x11
        SE_TabWidgetTabBar       : QStyle.SubElement = ... # 0x12
        SE_TabWidgetTabPane      : QStyle.SubElement = ... # 0x13
        SE_TabWidgetTabContents  : QStyle.SubElement = ... # 0x14
        SE_TabWidgetLeftCorner   : QStyle.SubElement = ... # 0x15
        SE_TabWidgetRightCorner  : QStyle.SubElement = ... # 0x16
        SE_ItemViewItemCheckIndicator: QStyle.SubElement = ... # 0x17
        SE_ViewItemCheckIndicator: QStyle.SubElement = ... # 0x17
        SE_TabBarTearIndicator   : QStyle.SubElement = ... # 0x18
        SE_TabBarTearIndicatorLeft: QStyle.SubElement = ... # 0x18
        SE_TreeViewDisclosureItem: QStyle.SubElement = ... # 0x19
        SE_LineEditContents      : QStyle.SubElement = ... # 0x1a
        SE_FrameContents         : QStyle.SubElement = ... # 0x1b
        SE_DockWidgetCloseButton : QStyle.SubElement = ... # 0x1c
        SE_DockWidgetFloatButton : QStyle.SubElement = ... # 0x1d
        SE_DockWidgetTitleBarText: QStyle.SubElement = ... # 0x1e
        SE_DockWidgetIcon        : QStyle.SubElement = ... # 0x1f
        SE_CheckBoxLayoutItem    : QStyle.SubElement = ... # 0x20
        SE_ComboBoxLayoutItem    : QStyle.SubElement = ... # 0x21
        SE_DateTimeEditLayoutItem: QStyle.SubElement = ... # 0x22
        SE_DialogButtonBoxLayoutItem: QStyle.SubElement = ... # 0x23
        SE_LabelLayoutItem       : QStyle.SubElement = ... # 0x24
        SE_ProgressBarLayoutItem : QStyle.SubElement = ... # 0x25
        SE_PushButtonLayoutItem  : QStyle.SubElement = ... # 0x26
        SE_RadioButtonLayoutItem : QStyle.SubElement = ... # 0x27
        SE_SliderLayoutItem      : QStyle.SubElement = ... # 0x28
        SE_SpinBoxLayoutItem     : QStyle.SubElement = ... # 0x29
        SE_ToolButtonLayoutItem  : QStyle.SubElement = ... # 0x2a
        SE_FrameLayoutItem       : QStyle.SubElement = ... # 0x2b
        SE_GroupBoxLayoutItem    : QStyle.SubElement = ... # 0x2c
        SE_TabWidgetLayoutItem   : QStyle.SubElement = ... # 0x2d
        SE_ItemViewItemDecoration: QStyle.SubElement = ... # 0x2e
        SE_ItemViewItemText      : QStyle.SubElement = ... # 0x2f
        SE_ItemViewItemFocusRect : QStyle.SubElement = ... # 0x30
        SE_TabBarTabLeftButton   : QStyle.SubElement = ... # 0x31
        SE_TabBarTabRightButton  : QStyle.SubElement = ... # 0x32
        SE_TabBarTabText         : QStyle.SubElement = ... # 0x33
        SE_ShapedFrameContents   : QStyle.SubElement = ... # 0x34
        SE_ToolBarHandle         : QStyle.SubElement = ... # 0x35
        SE_TabBarScrollLeftButton: QStyle.SubElement = ... # 0x36
        SE_TabBarScrollRightButton: QStyle.SubElement = ... # 0x37
        SE_TabBarTearIndicatorRight: QStyle.SubElement = ... # 0x38
        SE_PushButtonBevel       : QStyle.SubElement = ... # 0x39
        SE_CustomBase            : QStyle.SubElement = ... # 0xf0000000

    def __init__(self) -> None: ...


class QStyleFactory(Shiboken.Object):

    def __init__(self) -> None: ...


class QStyleHintReturn(Shiboken.Object):
    SH_Default               : QStyleHintReturn.HintReturnType = ... # 0xf000
    SH_Mask                  : QStyleHintReturn.HintReturnType = ... # 0xf001
    SH_Variant               : QStyleHintReturn.HintReturnType = ... # 0xf002
    Type                     : QStyleHintReturn.StyleOptionType = ... # 0xf000
    Version                  : QStyleHintReturn.StyleOptionVersion = ... # 0x1

    class HintReturnType(Shiboken.Enum):
        SH_Default               : QStyleHintReturn.HintReturnType = ... # 0xf000
        SH_Mask                  : QStyleHintReturn.HintReturnType = ... # 0xf001
        SH_Variant               : QStyleHintReturn.HintReturnType = ... # 0xf002

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleHintReturn.StyleOptionType = ... # 0xf000

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleHintReturn.StyleOptionVersion = ... # 0x1

    def __init__(self, version: int = ..., type: int = ...) -> None: ...


class QStyleHintReturnMask(PySide2.QtWidgets.QStyleHintReturn):
    Type                     : QStyleHintReturnMask.StyleOptionType = ... # 0xf001
    Version                  : QStyleHintReturnMask.StyleOptionVersion = ... # 0x1

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleHintReturnMask.StyleOptionType = ... # 0xf001

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleHintReturnMask.StyleOptionVersion = ... # 0x1

    def __init__(self) -> None: ...


class QStyleHintReturnVariant(PySide2.QtWidgets.QStyleHintReturn):
    Type                     : QStyleHintReturnVariant.StyleOptionType = ... # 0xf002
    Version                  : QStyleHintReturnVariant.StyleOptionVersion = ... # 0x1

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleHintReturnVariant.StyleOptionType = ... # 0xf002

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleHintReturnVariant.StyleOptionVersion = ... # 0x1

    def __init__(self) -> None: ...


class QStyleOption(Shiboken.Object):
    SO_Default               : QStyleOption.OptionType = ... # 0x0
    SO_FocusRect             : QStyleOption.OptionType = ... # 0x1
    SO_Button                : QStyleOption.OptionType = ... # 0x2
    SO_Tab                   : QStyleOption.OptionType = ... # 0x3
    SO_MenuItem              : QStyleOption.OptionType = ... # 0x4
    SO_Frame                 : QStyleOption.OptionType = ... # 0x5
    SO_ProgressBar           : QStyleOption.OptionType = ... # 0x6
    SO_ToolBox               : QStyleOption.OptionType = ... # 0x7
    SO_Header                : QStyleOption.OptionType = ... # 0x8
    SO_DockWidget            : QStyleOption.OptionType = ... # 0x9
    SO_ViewItem              : QStyleOption.OptionType = ... # 0xa
    SO_TabWidgetFrame        : QStyleOption.OptionType = ... # 0xb
    SO_TabBarBase            : QStyleOption.OptionType = ... # 0xc
    SO_RubberBand            : QStyleOption.OptionType = ... # 0xd
    SO_ToolBar               : QStyleOption.OptionType = ... # 0xe
    SO_GraphicsItem          : QStyleOption.OptionType = ... # 0xf
    SO_CustomBase            : QStyleOption.OptionType = ... # 0xf00
    SO_Complex               : QStyleOption.OptionType = ... # 0xf0000
    SO_Slider                : QStyleOption.OptionType = ... # 0xf0001
    SO_SpinBox               : QStyleOption.OptionType = ... # 0xf0002
    SO_ToolButton            : QStyleOption.OptionType = ... # 0xf0003
    SO_ComboBox              : QStyleOption.OptionType = ... # 0xf0004
    SO_TitleBar              : QStyleOption.OptionType = ... # 0xf0005
    SO_GroupBox              : QStyleOption.OptionType = ... # 0xf0006
    SO_SizeGrip              : QStyleOption.OptionType = ... # 0xf0007
    SO_ComplexCustomBase     : QStyleOption.OptionType = ... # 0xf000000
    Type                     : QStyleOption.StyleOptionType = ... # 0x0
    Version                  : QStyleOption.StyleOptionVersion = ... # 0x1

    class OptionType(Shiboken.Enum):
        SO_Default               : QStyleOption.OptionType = ... # 0x0
        SO_FocusRect             : QStyleOption.OptionType = ... # 0x1
        SO_Button                : QStyleOption.OptionType = ... # 0x2
        SO_Tab                   : QStyleOption.OptionType = ... # 0x3
        SO_MenuItem              : QStyleOption.OptionType = ... # 0x4
        SO_Frame                 : QStyleOption.OptionType = ... # 0x5
        SO_ProgressBar           : QStyleOption.OptionType = ... # 0x6
        SO_ToolBox               : QStyleOption.OptionType = ... # 0x7
        SO_Header                : QStyleOption.OptionType = ... # 0x8
        SO_DockWidget            : QStyleOption.OptionType = ... # 0x9
        SO_ViewItem              : QStyleOption.OptionType = ... # 0xa
        SO_TabWidgetFrame        : QStyleOption.OptionType = ... # 0xb
        SO_TabBarBase            : QStyleOption.OptionType = ... # 0xc
        SO_RubberBand            : QStyleOption.OptionType = ... # 0xd
        SO_ToolBar               : QStyleOption.OptionType = ... # 0xe
        SO_GraphicsItem          : QStyleOption.OptionType = ... # 0xf
        SO_CustomBase            : QStyleOption.OptionType = ... # 0xf00
        SO_Complex               : QStyleOption.OptionType = ... # 0xf0000
        SO_Slider                : QStyleOption.OptionType = ... # 0xf0001
        SO_SpinBox               : QStyleOption.OptionType = ... # 0xf0002
        SO_ToolButton            : QStyleOption.OptionType = ... # 0xf0003
        SO_ComboBox              : QStyleOption.OptionType = ... # 0xf0004
        SO_TitleBar              : QStyleOption.OptionType = ... # 0xf0005
        SO_GroupBox              : QStyleOption.OptionType = ... # 0xf0006
        SO_SizeGrip              : QStyleOption.OptionType = ... # 0xf0007
        SO_ComplexCustomBase     : QStyleOption.OptionType = ... # 0xf000000

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOption.StyleOptionType = ... # 0x0

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOption.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOption) -> None: ...
    @typing.overload
    def __init__(self, version: int = ..., type: int = ...) -> None: ...


class QStyleOptionButton(PySide2.QtWidgets.QStyleOption):
    None_                    : QStyleOptionButton.ButtonFeature = ... # 0x0
    Flat                     : QStyleOptionButton.ButtonFeature = ... # 0x1
    HasMenu                  : QStyleOptionButton.ButtonFeature = ... # 0x2
    DefaultButton            : QStyleOptionButton.ButtonFeature = ... # 0x4
    AutoDefaultButton        : QStyleOptionButton.ButtonFeature = ... # 0x8
    CommandLinkButton        : QStyleOptionButton.ButtonFeature = ... # 0x10
    Type                     : QStyleOptionButton.StyleOptionType = ... # 0x2
    Version                  : QStyleOptionButton.StyleOptionVersion = ... # 0x1

    class ButtonFeature(Shiboken.Enum):
        None_                    : QStyleOptionButton.ButtonFeature = ... # 0x0
        Flat                     : QStyleOptionButton.ButtonFeature = ... # 0x1
        HasMenu                  : QStyleOptionButton.ButtonFeature = ... # 0x2
        DefaultButton            : QStyleOptionButton.ButtonFeature = ... # 0x4
        AutoDefaultButton        : QStyleOptionButton.ButtonFeature = ... # 0x8
        CommandLinkButton        : QStyleOptionButton.ButtonFeature = ... # 0x10

    class ButtonFeatures(object): ...

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionButton.StyleOptionType = ... # 0x2

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionButton.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionButton) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionComboBox(PySide2.QtWidgets.QStyleOptionComplex):
    Type                     : QStyleOptionComboBox.StyleOptionType = ... # 0xf0004
    Version                  : QStyleOptionComboBox.StyleOptionVersion = ... # 0x1

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionComboBox.StyleOptionType = ... # 0xf0004

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionComboBox.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionComboBox) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionComplex(PySide2.QtWidgets.QStyleOption):
    Type                     : QStyleOptionComplex.StyleOptionType = ... # 0xf0000
    Version                  : QStyleOptionComplex.StyleOptionVersion = ... # 0x1

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionComplex.StyleOptionType = ... # 0xf0000

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionComplex.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionComplex) -> None: ...
    @typing.overload
    def __init__(self, version: int = ..., type: int = ...) -> None: ...


class QStyleOptionDockWidget(PySide2.QtWidgets.QStyleOption):
    Type                     : QStyleOptionDockWidget.StyleOptionType = ... # 0x9
    Version                  : QStyleOptionDockWidget.StyleOptionVersion = ... # 0x2

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionDockWidget.StyleOptionType = ... # 0x9

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionDockWidget.StyleOptionVersion = ... # 0x2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionDockWidget) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionFocusRect(PySide2.QtWidgets.QStyleOption):
    Type                     : QStyleOptionFocusRect.StyleOptionType = ... # 0x1
    Version                  : QStyleOptionFocusRect.StyleOptionVersion = ... # 0x1

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionFocusRect.StyleOptionType = ... # 0x1

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionFocusRect.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionFocusRect) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionFrame(PySide2.QtWidgets.QStyleOption):
    None_                    : QStyleOptionFrame.FrameFeature = ... # 0x0
    Flat                     : QStyleOptionFrame.FrameFeature = ... # 0x1
    Rounded                  : QStyleOptionFrame.FrameFeature = ... # 0x2
    Type                     : QStyleOptionFrame.StyleOptionType = ... # 0x5
    Version                  : QStyleOptionFrame.StyleOptionVersion = ... # 0x3

    class FrameFeature(Shiboken.Enum):
        None_                    : QStyleOptionFrame.FrameFeature = ... # 0x0
        Flat                     : QStyleOptionFrame.FrameFeature = ... # 0x1
        Rounded                  : QStyleOptionFrame.FrameFeature = ... # 0x2

    class FrameFeatures(object): ...

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionFrame.StyleOptionType = ... # 0x5

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionFrame.StyleOptionVersion = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionFrame) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionGraphicsItem(PySide2.QtWidgets.QStyleOption):
    Type                     : QStyleOptionGraphicsItem.StyleOptionType = ... # 0xf
    Version                  : QStyleOptionGraphicsItem.StyleOptionVersion = ... # 0x1

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionGraphicsItem.StyleOptionType = ... # 0xf

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionGraphicsItem.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionGraphicsItem) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionGroupBox(PySide2.QtWidgets.QStyleOptionComplex):
    Type                     : QStyleOptionGroupBox.StyleOptionType = ... # 0xf0006
    Version                  : QStyleOptionGroupBox.StyleOptionVersion = ... # 0x1

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionGroupBox.StyleOptionType = ... # 0xf0006

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionGroupBox.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionGroupBox) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionHeader(PySide2.QtWidgets.QStyleOption):
    Beginning                : QStyleOptionHeader.SectionPosition = ... # 0x0
    Middle                   : QStyleOptionHeader.SectionPosition = ... # 0x1
    End                      : QStyleOptionHeader.SectionPosition = ... # 0x2
    OnlyOneSection           : QStyleOptionHeader.SectionPosition = ... # 0x3
    NotAdjacent              : QStyleOptionHeader.SelectedPosition = ... # 0x0
    NextIsSelected           : QStyleOptionHeader.SelectedPosition = ... # 0x1
    PreviousIsSelected       : QStyleOptionHeader.SelectedPosition = ... # 0x2
    NextAndPreviousAreSelected: QStyleOptionHeader.SelectedPosition = ... # 0x3
    None_                    : QStyleOptionHeader.SortIndicator = ... # 0x0
    SortUp                   : QStyleOptionHeader.SortIndicator = ... # 0x1
    SortDown                 : QStyleOptionHeader.SortIndicator = ... # 0x2
    Type                     : QStyleOptionHeader.StyleOptionType = ... # 0x8
    Version                  : QStyleOptionHeader.StyleOptionVersion = ... # 0x1

    class SectionPosition(Shiboken.Enum):
        Beginning                : QStyleOptionHeader.SectionPosition = ... # 0x0
        Middle                   : QStyleOptionHeader.SectionPosition = ... # 0x1
        End                      : QStyleOptionHeader.SectionPosition = ... # 0x2
        OnlyOneSection           : QStyleOptionHeader.SectionPosition = ... # 0x3

    class SelectedPosition(Shiboken.Enum):
        NotAdjacent              : QStyleOptionHeader.SelectedPosition = ... # 0x0
        NextIsSelected           : QStyleOptionHeader.SelectedPosition = ... # 0x1
        PreviousIsSelected       : QStyleOptionHeader.SelectedPosition = ... # 0x2
        NextAndPreviousAreSelected: QStyleOptionHeader.SelectedPosition = ... # 0x3

    class SortIndicator(Shiboken.Enum):
        None_                    : QStyleOptionHeader.SortIndicator = ... # 0x0
        SortUp                   : QStyleOptionHeader.SortIndicator = ... # 0x1
        SortDown                 : QStyleOptionHeader.SortIndicator = ... # 0x2

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionHeader.StyleOptionType = ... # 0x8

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionHeader.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionHeader) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionMenuItem(PySide2.QtWidgets.QStyleOption):
    NotCheckable             : QStyleOptionMenuItem.CheckType = ... # 0x0
    Exclusive                : QStyleOptionMenuItem.CheckType = ... # 0x1
    NonExclusive             : QStyleOptionMenuItem.CheckType = ... # 0x2
    Normal                   : QStyleOptionMenuItem.MenuItemType = ... # 0x0
    DefaultItem              : QStyleOptionMenuItem.MenuItemType = ... # 0x1
    Separator                : QStyleOptionMenuItem.MenuItemType = ... # 0x2
    SubMenu                  : QStyleOptionMenuItem.MenuItemType = ... # 0x3
    Scroller                 : QStyleOptionMenuItem.MenuItemType = ... # 0x4
    TearOff                  : QStyleOptionMenuItem.MenuItemType = ... # 0x5
    Margin                   : QStyleOptionMenuItem.MenuItemType = ... # 0x6
    EmptyArea                : QStyleOptionMenuItem.MenuItemType = ... # 0x7
    Type                     : QStyleOptionMenuItem.StyleOptionType = ... # 0x4
    Version                  : QStyleOptionMenuItem.StyleOptionVersion = ... # 0x1

    class CheckType(Shiboken.Enum):
        NotCheckable             : QStyleOptionMenuItem.CheckType = ... # 0x0
        Exclusive                : QStyleOptionMenuItem.CheckType = ... # 0x1
        NonExclusive             : QStyleOptionMenuItem.CheckType = ... # 0x2

    class MenuItemType(Shiboken.Enum):
        Normal                   : QStyleOptionMenuItem.MenuItemType = ... # 0x0
        DefaultItem              : QStyleOptionMenuItem.MenuItemType = ... # 0x1
        Separator                : QStyleOptionMenuItem.MenuItemType = ... # 0x2
        SubMenu                  : QStyleOptionMenuItem.MenuItemType = ... # 0x3
        Scroller                 : QStyleOptionMenuItem.MenuItemType = ... # 0x4
        TearOff                  : QStyleOptionMenuItem.MenuItemType = ... # 0x5
        Margin                   : QStyleOptionMenuItem.MenuItemType = ... # 0x6
        EmptyArea                : QStyleOptionMenuItem.MenuItemType = ... # 0x7

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionMenuItem.StyleOptionType = ... # 0x4

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionMenuItem.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionMenuItem) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionProgressBar(PySide2.QtWidgets.QStyleOption):
    Type                     : QStyleOptionProgressBar.StyleOptionType = ... # 0x6
    Version                  : QStyleOptionProgressBar.StyleOptionVersion = ... # 0x2

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionProgressBar.StyleOptionType = ... # 0x6

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionProgressBar.StyleOptionVersion = ... # 0x2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionProgressBar) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionRubberBand(PySide2.QtWidgets.QStyleOption):
    Type                     : QStyleOptionRubberBand.StyleOptionType = ... # 0xd
    Version                  : QStyleOptionRubberBand.StyleOptionVersion = ... # 0x1

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionRubberBand.StyleOptionType = ... # 0xd

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionRubberBand.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionRubberBand) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionSizeGrip(PySide2.QtWidgets.QStyleOptionComplex):
    Type                     : QStyleOptionSizeGrip.StyleOptionType = ... # 0xf0007
    Version                  : QStyleOptionSizeGrip.StyleOptionVersion = ... # 0x1

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionSizeGrip.StyleOptionType = ... # 0xf0007

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionSizeGrip.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionSizeGrip) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionSlider(PySide2.QtWidgets.QStyleOptionComplex):
    Type                     : QStyleOptionSlider.StyleOptionType = ... # 0xf0001
    Version                  : QStyleOptionSlider.StyleOptionVersion = ... # 0x1

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionSlider.StyleOptionType = ... # 0xf0001

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionSlider.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionSlider) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionSpinBox(PySide2.QtWidgets.QStyleOptionComplex):
    Type                     : QStyleOptionSpinBox.StyleOptionType = ... # 0xf0002
    Version                  : QStyleOptionSpinBox.StyleOptionVersion = ... # 0x1

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionSpinBox.StyleOptionType = ... # 0xf0002

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionSpinBox.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionSpinBox) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionTab(PySide2.QtWidgets.QStyleOption):
    NoCornerWidgets          : QStyleOptionTab.CornerWidget = ... # 0x0
    LeftCornerWidget         : QStyleOptionTab.CornerWidget = ... # 0x1
    RightCornerWidget        : QStyleOptionTab.CornerWidget = ... # 0x2
    NotAdjacent              : QStyleOptionTab.SelectedPosition = ... # 0x0
    NextIsSelected           : QStyleOptionTab.SelectedPosition = ... # 0x1
    PreviousIsSelected       : QStyleOptionTab.SelectedPosition = ... # 0x2
    Type                     : QStyleOptionTab.StyleOptionType = ... # 0x3
    Version                  : QStyleOptionTab.StyleOptionVersion = ... # 0x3
    None_                    : QStyleOptionTab.TabFeature = ... # 0x0
    HasFrame                 : QStyleOptionTab.TabFeature = ... # 0x1
    Beginning                : QStyleOptionTab.TabPosition = ... # 0x0
    Middle                   : QStyleOptionTab.TabPosition = ... # 0x1
    End                      : QStyleOptionTab.TabPosition = ... # 0x2
    OnlyOneTab               : QStyleOptionTab.TabPosition = ... # 0x3

    class CornerWidget(Shiboken.Enum):
        NoCornerWidgets          : QStyleOptionTab.CornerWidget = ... # 0x0
        LeftCornerWidget         : QStyleOptionTab.CornerWidget = ... # 0x1
        RightCornerWidget        : QStyleOptionTab.CornerWidget = ... # 0x2

    class CornerWidgets(object): ...

    class SelectedPosition(Shiboken.Enum):
        NotAdjacent              : QStyleOptionTab.SelectedPosition = ... # 0x0
        NextIsSelected           : QStyleOptionTab.SelectedPosition = ... # 0x1
        PreviousIsSelected       : QStyleOptionTab.SelectedPosition = ... # 0x2

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionTab.StyleOptionType = ... # 0x3

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionTab.StyleOptionVersion = ... # 0x3

    class TabFeature(Shiboken.Enum):
        None_                    : QStyleOptionTab.TabFeature = ... # 0x0
        HasFrame                 : QStyleOptionTab.TabFeature = ... # 0x1

    class TabFeatures(object): ...

    class TabPosition(Shiboken.Enum):
        Beginning                : QStyleOptionTab.TabPosition = ... # 0x0
        Middle                   : QStyleOptionTab.TabPosition = ... # 0x1
        End                      : QStyleOptionTab.TabPosition = ... # 0x2
        OnlyOneTab               : QStyleOptionTab.TabPosition = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionTab) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionTabBarBase(PySide2.QtWidgets.QStyleOption):
    Type                     : QStyleOptionTabBarBase.StyleOptionType = ... # 0xc
    Version                  : QStyleOptionTabBarBase.StyleOptionVersion = ... # 0x2

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionTabBarBase.StyleOptionType = ... # 0xc

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionTabBarBase.StyleOptionVersion = ... # 0x2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionTabBarBase) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionTabWidgetFrame(PySide2.QtWidgets.QStyleOption):
    Type                     : QStyleOptionTabWidgetFrame.StyleOptionType = ... # 0xb
    Version                  : QStyleOptionTabWidgetFrame.StyleOptionVersion = ... # 0x2

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionTabWidgetFrame.StyleOptionType = ... # 0xb

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionTabWidgetFrame.StyleOptionVersion = ... # 0x2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionTabWidgetFrame) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionTitleBar(PySide2.QtWidgets.QStyleOptionComplex):
    Type                     : QStyleOptionTitleBar.StyleOptionType = ... # 0xf0005
    Version                  : QStyleOptionTitleBar.StyleOptionVersion = ... # 0x1

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionTitleBar.StyleOptionType = ... # 0xf0005

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionTitleBar.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionTitleBar) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionToolBar(PySide2.QtWidgets.QStyleOption):
    Type                     : QStyleOptionToolBar.StyleOptionType = ... # 0xe
    Version                  : QStyleOptionToolBar.StyleOptionVersion = ... # 0x1
    None_                    : QStyleOptionToolBar.ToolBarFeature = ... # 0x0
    Movable                  : QStyleOptionToolBar.ToolBarFeature = ... # 0x1
    Beginning                : QStyleOptionToolBar.ToolBarPosition = ... # 0x0
    Middle                   : QStyleOptionToolBar.ToolBarPosition = ... # 0x1
    End                      : QStyleOptionToolBar.ToolBarPosition = ... # 0x2
    OnlyOne                  : QStyleOptionToolBar.ToolBarPosition = ... # 0x3

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionToolBar.StyleOptionType = ... # 0xe

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionToolBar.StyleOptionVersion = ... # 0x1

    class ToolBarFeature(Shiboken.Enum):
        None_                    : QStyleOptionToolBar.ToolBarFeature = ... # 0x0
        Movable                  : QStyleOptionToolBar.ToolBarFeature = ... # 0x1

    class ToolBarFeatures(object): ...

    class ToolBarPosition(Shiboken.Enum):
        Beginning                : QStyleOptionToolBar.ToolBarPosition = ... # 0x0
        Middle                   : QStyleOptionToolBar.ToolBarPosition = ... # 0x1
        End                      : QStyleOptionToolBar.ToolBarPosition = ... # 0x2
        OnlyOne                  : QStyleOptionToolBar.ToolBarPosition = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionToolBar) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionToolBox(PySide2.QtWidgets.QStyleOption):
    NotAdjacent              : QStyleOptionToolBox.SelectedPosition = ... # 0x0
    NextIsSelected           : QStyleOptionToolBox.SelectedPosition = ... # 0x1
    PreviousIsSelected       : QStyleOptionToolBox.SelectedPosition = ... # 0x2
    Type                     : QStyleOptionToolBox.StyleOptionType = ... # 0x7
    Version                  : QStyleOptionToolBox.StyleOptionVersion = ... # 0x2
    Beginning                : QStyleOptionToolBox.TabPosition = ... # 0x0
    Middle                   : QStyleOptionToolBox.TabPosition = ... # 0x1
    End                      : QStyleOptionToolBox.TabPosition = ... # 0x2
    OnlyOneTab               : QStyleOptionToolBox.TabPosition = ... # 0x3

    class SelectedPosition(Shiboken.Enum):
        NotAdjacent              : QStyleOptionToolBox.SelectedPosition = ... # 0x0
        NextIsSelected           : QStyleOptionToolBox.SelectedPosition = ... # 0x1
        PreviousIsSelected       : QStyleOptionToolBox.SelectedPosition = ... # 0x2

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionToolBox.StyleOptionType = ... # 0x7

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionToolBox.StyleOptionVersion = ... # 0x2

    class TabPosition(Shiboken.Enum):
        Beginning                : QStyleOptionToolBox.TabPosition = ... # 0x0
        Middle                   : QStyleOptionToolBox.TabPosition = ... # 0x1
        End                      : QStyleOptionToolBox.TabPosition = ... # 0x2
        OnlyOneTab               : QStyleOptionToolBox.TabPosition = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionToolBox) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionToolButton(PySide2.QtWidgets.QStyleOptionComplex):
    Type                     : QStyleOptionToolButton.StyleOptionType = ... # 0xf0003
    Version                  : QStyleOptionToolButton.StyleOptionVersion = ... # 0x1
    None_                    : QStyleOptionToolButton.ToolButtonFeature = ... # 0x0
    Arrow                    : QStyleOptionToolButton.ToolButtonFeature = ... # 0x1
    Menu                     : QStyleOptionToolButton.ToolButtonFeature = ... # 0x4
    MenuButtonPopup          : QStyleOptionToolButton.ToolButtonFeature = ... # 0x4
    PopupDelay               : QStyleOptionToolButton.ToolButtonFeature = ... # 0x8
    HasMenu                  : QStyleOptionToolButton.ToolButtonFeature = ... # 0x10

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionToolButton.StyleOptionType = ... # 0xf0003

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionToolButton.StyleOptionVersion = ... # 0x1

    class ToolButtonFeature(Shiboken.Enum):
        None_                    : QStyleOptionToolButton.ToolButtonFeature = ... # 0x0
        Arrow                    : QStyleOptionToolButton.ToolButtonFeature = ... # 0x1
        Menu                     : QStyleOptionToolButton.ToolButtonFeature = ... # 0x4
        MenuButtonPopup          : QStyleOptionToolButton.ToolButtonFeature = ... # 0x4
        PopupDelay               : QStyleOptionToolButton.ToolButtonFeature = ... # 0x8
        HasMenu                  : QStyleOptionToolButton.ToolButtonFeature = ... # 0x10

    class ToolButtonFeatures(object): ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionToolButton) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionViewItem(PySide2.QtWidgets.QStyleOption):
    Left                     : QStyleOptionViewItem.Position = ... # 0x0
    Right                    : QStyleOptionViewItem.Position = ... # 0x1
    Top                      : QStyleOptionViewItem.Position = ... # 0x2
    Bottom                   : QStyleOptionViewItem.Position = ... # 0x3
    Type                     : QStyleOptionViewItem.StyleOptionType = ... # 0xa
    Version                  : QStyleOptionViewItem.StyleOptionVersion = ... # 0x4
    None_                    : QStyleOptionViewItem.ViewItemFeature = ... # 0x0
    WrapText                 : QStyleOptionViewItem.ViewItemFeature = ... # 0x1
    Alternate                : QStyleOptionViewItem.ViewItemFeature = ... # 0x2
    HasCheckIndicator        : QStyleOptionViewItem.ViewItemFeature = ... # 0x4
    HasDisplay               : QStyleOptionViewItem.ViewItemFeature = ... # 0x8
    HasDecoration            : QStyleOptionViewItem.ViewItemFeature = ... # 0x10
    Invalid                  : QStyleOptionViewItem.ViewItemPosition = ... # 0x0
    Beginning                : QStyleOptionViewItem.ViewItemPosition = ... # 0x1
    Middle                   : QStyleOptionViewItem.ViewItemPosition = ... # 0x2
    End                      : QStyleOptionViewItem.ViewItemPosition = ... # 0x3
    OnlyOne                  : QStyleOptionViewItem.ViewItemPosition = ... # 0x4

    class Position(Shiboken.Enum):
        Left                     : QStyleOptionViewItem.Position = ... # 0x0
        Right                    : QStyleOptionViewItem.Position = ... # 0x1
        Top                      : QStyleOptionViewItem.Position = ... # 0x2
        Bottom                   : QStyleOptionViewItem.Position = ... # 0x3

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionViewItem.StyleOptionType = ... # 0xa

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionViewItem.StyleOptionVersion = ... # 0x4

    class ViewItemFeature(Shiboken.Enum):
        None_                    : QStyleOptionViewItem.ViewItemFeature = ... # 0x0
        WrapText                 : QStyleOptionViewItem.ViewItemFeature = ... # 0x1
        Alternate                : QStyleOptionViewItem.ViewItemFeature = ... # 0x2
        HasCheckIndicator        : QStyleOptionViewItem.ViewItemFeature = ... # 0x4
        HasDisplay               : QStyleOptionViewItem.ViewItemFeature = ... # 0x8
        HasDecoration            : QStyleOptionViewItem.ViewItemFeature = ... # 0x10

    class ViewItemFeatures(object): ...

    class ViewItemPosition(Shiboken.Enum):
        Invalid                  : QStyleOptionViewItem.ViewItemPosition = ... # 0x0
        Beginning                : QStyleOptionViewItem.ViewItemPosition = ... # 0x1
        Middle                   : QStyleOptionViewItem.ViewItemPosition = ... # 0x2
        End                      : QStyleOptionViewItem.ViewItemPosition = ... # 0x3
        OnlyOne                  : QStyleOptionViewItem.ViewItemPosition = ... # 0x4

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionViewItem) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStylePainter(PySide2.QtGui.QPainter):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, pd: PySide2.QtGui.QPaintDevice, w: PySide2.QtWidgets.QWidget) -> None: ...
    @typing.overload
    def __init__(self, w: PySide2.QtWidgets.QWidget) -> None: ...


class QStyledItemDelegate(PySide2.QtWidgets.QAbstractItemDelegate):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QSwipeGesture(PySide2.QtWidgets.QGesture):
    NoDirection              : QSwipeGesture.SwipeDirection = ... # 0x0
    Left                     : QSwipeGesture.SwipeDirection = ... # 0x1
    Right                    : QSwipeGesture.SwipeDirection = ... # 0x2
    Up                       : QSwipeGesture.SwipeDirection = ... # 0x3
    Down                     : QSwipeGesture.SwipeDirection = ... # 0x4

    class SwipeDirection(Shiboken.Enum):
        NoDirection              : QSwipeGesture.SwipeDirection = ... # 0x0
        Left                     : QSwipeGesture.SwipeDirection = ... # 0x1
        Right                    : QSwipeGesture.SwipeDirection = ... # 0x2
        Up                       : QSwipeGesture.SwipeDirection = ... # 0x3
        Down                     : QSwipeGesture.SwipeDirection = ... # 0x4

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QSystemTrayIcon(PySide2.QtCore.QObject):
    Unknown                  : QSystemTrayIcon.ActivationReason = ... # 0x0
    Context                  : QSystemTrayIcon.ActivationReason = ... # 0x1
    DoubleClick              : QSystemTrayIcon.ActivationReason = ... # 0x2
    Trigger                  : QSystemTrayIcon.ActivationReason = ... # 0x3
    MiddleClick              : QSystemTrayIcon.ActivationReason = ... # 0x4
    NoIcon                   : QSystemTrayIcon.MessageIcon = ... # 0x0
    Information              : QSystemTrayIcon.MessageIcon = ... # 0x1
    Warning                  : QSystemTrayIcon.MessageIcon = ... # 0x2
    Critical                 : QSystemTrayIcon.MessageIcon = ... # 0x3

    class ActivationReason(Shiboken.Enum):
        Unknown                  : QSystemTrayIcon.ActivationReason = ... # 0x0
        Context                  : QSystemTrayIcon.ActivationReason = ... # 0x1
        DoubleClick              : QSystemTrayIcon.ActivationReason = ... # 0x2
        Trigger                  : QSystemTrayIcon.ActivationReason = ... # 0x3
        MiddleClick              : QSystemTrayIcon.ActivationReason = ... # 0x4

    class MessageIcon(Shiboken.Enum):
        NoIcon                   : QSystemTrayIcon.MessageIcon = ... # 0x0
        Information              : QSystemTrayIcon.MessageIcon = ... # 0x1
        Warning                  : QSystemTrayIcon.MessageIcon = ... # 0x2
        Critical                 : QSystemTrayIcon.MessageIcon = ... # 0x3

    @typing.overload
    def __init__(self, icon: PySide2.QtGui.QIcon, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QTabBar(PySide2.QtWidgets.QWidget):
    LeftSide                 : QTabBar.ButtonPosition = ... # 0x0
    RightSide                : QTabBar.ButtonPosition = ... # 0x1
    SelectLeftTab            : QTabBar.SelectionBehavior = ... # 0x0
    SelectRightTab           : QTabBar.SelectionBehavior = ... # 0x1
    SelectPreviousTab        : QTabBar.SelectionBehavior = ... # 0x2
    RoundedNorth             : QTabBar.Shape = ... # 0x0
    RoundedSouth             : QTabBar.Shape = ... # 0x1
    RoundedWest              : QTabBar.Shape = ... # 0x2
    RoundedEast              : QTabBar.Shape = ... # 0x3
    TriangularNorth          : QTabBar.Shape = ... # 0x4
    TriangularSouth          : QTabBar.Shape = ... # 0x5
    TriangularWest           : QTabBar.Shape = ... # 0x6
    TriangularEast           : QTabBar.Shape = ... # 0x7

    class ButtonPosition(Shiboken.Enum):
        LeftSide                 : QTabBar.ButtonPosition = ... # 0x0
        RightSide                : QTabBar.ButtonPosition = ... # 0x1

    class SelectionBehavior(Shiboken.Enum):
        SelectLeftTab            : QTabBar.SelectionBehavior = ... # 0x0
        SelectRightTab           : QTabBar.SelectionBehavior = ... # 0x1
        SelectPreviousTab        : QTabBar.SelectionBehavior = ... # 0x2

    class Shape(Shiboken.Enum):
        RoundedNorth             : QTabBar.Shape = ... # 0x0
        RoundedSouth             : QTabBar.Shape = ... # 0x1
        RoundedWest              : QTabBar.Shape = ... # 0x2
        RoundedEast              : QTabBar.Shape = ... # 0x3
        TriangularNorth          : QTabBar.Shape = ... # 0x4
        TriangularSouth          : QTabBar.Shape = ... # 0x5
        TriangularWest           : QTabBar.Shape = ... # 0x6
        TriangularEast           : QTabBar.Shape = ... # 0x7

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QTabWidget(PySide2.QtWidgets.QWidget):
    North                    : QTabWidget.TabPosition = ... # 0x0
    South                    : QTabWidget.TabPosition = ... # 0x1
    West                     : QTabWidget.TabPosition = ... # 0x2
    East                     : QTabWidget.TabPosition = ... # 0x3
    Rounded                  : QTabWidget.TabShape = ... # 0x0
    Triangular               : QTabWidget.TabShape = ... # 0x1

    class TabPosition(Shiboken.Enum):
        North                    : QTabWidget.TabPosition = ... # 0x0
        South                    : QTabWidget.TabPosition = ... # 0x1
        West                     : QTabWidget.TabPosition = ... # 0x2
        East                     : QTabWidget.TabPosition = ... # 0x3

    class TabShape(Shiboken.Enum):
        Rounded                  : QTabWidget.TabShape = ... # 0x0
        Triangular               : QTabWidget.TabShape = ... # 0x1

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QTableView(PySide2.QtWidgets.QAbstractItemView):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QTableWidget(PySide2.QtWidgets.QTableView):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, rows: int, columns: int, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QTableWidgetItem(Shiboken.Object):
    Type                     : QTableWidgetItem.ItemType = ... # 0x0
    UserType                 : QTableWidgetItem.ItemType = ... # 0x3e8

    class ItemType(Shiboken.Enum):
        Type                     : QTableWidgetItem.ItemType = ... # 0x0
        UserType                 : QTableWidgetItem.ItemType = ... # 0x3e8

    @typing.overload
    def __init__(self, icon: PySide2.QtGui.QIcon, text: str, type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QTableWidgetItem) -> None: ...
    @typing.overload
    def __init__(self, text: str, type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, type: int = ...) -> None: ...


class QTableWidgetSelectionRange(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QTableWidgetSelectionRange) -> None: ...
    @typing.overload
    def __init__(self, top: int, left: int, bottom: int, right: int) -> None: ...


class QTapAndHoldGesture(PySide2.QtWidgets.QGesture):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QTapGesture(PySide2.QtWidgets.QGesture):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QTextBrowser(PySide2.QtWidgets.QTextEdit):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QTextEdit(PySide2.QtWidgets.QAbstractScrollArea):
    AutoNone                 : QTextEdit.AutoFormattingFlag = ... # 0x0
    AutoBulletList           : QTextEdit.AutoFormattingFlag = ... # 0x1
    AutoAll                  : QTextEdit.AutoFormattingFlag = ... # -0x1
    NoWrap                   : QTextEdit.LineWrapMode = ... # 0x0
    WidgetWidth              : QTextEdit.LineWrapMode = ... # 0x1
    FixedPixelWidth          : QTextEdit.LineWrapMode = ... # 0x2
    FixedColumnWidth         : QTextEdit.LineWrapMode = ... # 0x3

    class AutoFormatting(object): ...

    class AutoFormattingFlag(Shiboken.Enum):
        AutoNone                 : QTextEdit.AutoFormattingFlag = ... # 0x0
        AutoBulletList           : QTextEdit.AutoFormattingFlag = ... # 0x1
        AutoAll                  : QTextEdit.AutoFormattingFlag = ... # -0x1

    class ExtraSelection(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, ExtraSelection: PySide2.QtWidgets.QTextEdit.ExtraSelection) -> None: ...


    class LineWrapMode(Shiboken.Enum):
        NoWrap                   : QTextEdit.LineWrapMode = ... # 0x0
        WidgetWidth              : QTextEdit.LineWrapMode = ... # 0x1
        FixedPixelWidth          : QTextEdit.LineWrapMode = ... # 0x2
        FixedColumnWidth         : QTextEdit.LineWrapMode = ... # 0x3

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QTileRules(Shiboken.Object):

    @typing.overload
    def __init__(self, QTileRules: PySide2.QtWidgets.QTileRules) -> None: ...
    @typing.overload
    def __init__(self, horizontalRule: PySide2.QtCore.Qt.TileRule, verticalRule: PySide2.QtCore.Qt.TileRule) -> None: ...
    @typing.overload
    def __init__(self, rule: PySide2.QtCore.Qt.TileRule = ...) -> None: ...


class QTimeEdit(PySide2.QtWidgets.QDateTimeEdit):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, time: PySide2.QtCore.QTime, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QToolBar(PySide2.QtWidgets.QWidget):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, title: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QToolBox(PySide2.QtWidgets.QFrame):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., f: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...


class QToolButton(PySide2.QtWidgets.QAbstractButton):
    DelayedPopup             : QToolButton.ToolButtonPopupMode = ... # 0x0
    MenuButtonPopup          : QToolButton.ToolButtonPopupMode = ... # 0x1
    InstantPopup             : QToolButton.ToolButtonPopupMode = ... # 0x2

    class ToolButtonPopupMode(Shiboken.Enum):
        DelayedPopup             : QToolButton.ToolButtonPopupMode = ... # 0x0
        MenuButtonPopup          : QToolButton.ToolButtonPopupMode = ... # 0x1
        InstantPopup             : QToolButton.ToolButtonPopupMode = ... # 0x2

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QToolTip(Shiboken.Object): ...


class QTreeView(PySide2.QtWidgets.QAbstractItemView):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QTreeWidget(PySide2.QtWidgets.QTreeView):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QTreeWidgetItem(Shiboken.Object):
    ShowIndicator            : QTreeWidgetItem.ChildIndicatorPolicy = ... # 0x0
    DontShowIndicator        : QTreeWidgetItem.ChildIndicatorPolicy = ... # 0x1
    DontShowIndicatorWhenChildless: QTreeWidgetItem.ChildIndicatorPolicy = ... # 0x2
    Type                     : QTreeWidgetItem.ItemType = ... # 0x0
    UserType                 : QTreeWidgetItem.ItemType = ... # 0x3e8

    class ChildIndicatorPolicy(Shiboken.Enum):
        ShowIndicator            : QTreeWidgetItem.ChildIndicatorPolicy = ... # 0x0
        DontShowIndicator        : QTreeWidgetItem.ChildIndicatorPolicy = ... # 0x1
        DontShowIndicatorWhenChildless: QTreeWidgetItem.ChildIndicatorPolicy = ... # 0x2

    class ItemType(Shiboken.Enum):
        Type                     : QTreeWidgetItem.ItemType = ... # 0x0
        UserType                 : QTreeWidgetItem.ItemType = ... # 0x3e8

    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QTreeWidgetItem) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QTreeWidgetItem, after: PySide2.QtWidgets.QTreeWidgetItem, type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QTreeWidgetItem, strings: typing.Sequence[str], type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QTreeWidgetItem, type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, strings: typing.Sequence[str], type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, treeview: PySide2.QtWidgets.QTreeWidget, after: PySide2.QtWidgets.QTreeWidgetItem, type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, treeview: PySide2.QtWidgets.QTreeWidget, strings: typing.Sequence[str], type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, treeview: PySide2.QtWidgets.QTreeWidget, type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, type: int = ...) -> None: ...


class QTreeWidgetItemIterator(Shiboken.Object):
    All                      : QTreeWidgetItemIterator.IteratorFlag = ... # 0x0
    Hidden                   : QTreeWidgetItemIterator.IteratorFlag = ... # 0x1
    NotHidden                : QTreeWidgetItemIterator.IteratorFlag = ... # 0x2
    Selected                 : QTreeWidgetItemIterator.IteratorFlag = ... # 0x4
    Unselected               : QTreeWidgetItemIterator.IteratorFlag = ... # 0x8
    Selectable               : QTreeWidgetItemIterator.IteratorFlag = ... # 0x10
    NotSelectable            : QTreeWidgetItemIterator.IteratorFlag = ... # 0x20
    DragEnabled              : QTreeWidgetItemIterator.IteratorFlag = ... # 0x40
    DragDisabled             : QTreeWidgetItemIterator.IteratorFlag = ... # 0x80
    DropEnabled              : QTreeWidgetItemIterator.IteratorFlag = ... # 0x100
    DropDisabled             : QTreeWidgetItemIterator.IteratorFlag = ... # 0x200
    HasChildren              : QTreeWidgetItemIterator.IteratorFlag = ... # 0x400
    NoChildren               : QTreeWidgetItemIterator.IteratorFlag = ... # 0x800
    Checked                  : QTreeWidgetItemIterator.IteratorFlag = ... # 0x1000
    NotChecked               : QTreeWidgetItemIterator.IteratorFlag = ... # 0x2000
    Enabled                  : QTreeWidgetItemIterator.IteratorFlag = ... # 0x4000
    Disabled                 : QTreeWidgetItemIterator.IteratorFlag = ... # 0x8000
    Editable                 : QTreeWidgetItemIterator.IteratorFlag = ... # 0x10000
    NotEditable              : QTreeWidgetItemIterator.IteratorFlag = ... # 0x20000
    UserFlag                 : QTreeWidgetItemIterator.IteratorFlag = ... # 0x1000000

    class IteratorFlag(Shiboken.Enum):
        All                      : QTreeWidgetItemIterator.IteratorFlag = ... # 0x0
        Hidden                   : QTreeWidgetItemIterator.IteratorFlag = ... # 0x1
        NotHidden                : QTreeWidgetItemIterator.IteratorFlag = ... # 0x2
        Selected                 : QTreeWidgetItemIterator.IteratorFlag = ... # 0x4
        Unselected               : QTreeWidgetItemIterator.IteratorFlag = ... # 0x8
        Selectable               : QTreeWidgetItemIterator.IteratorFlag = ... # 0x10
        NotSelectable            : QTreeWidgetItemIterator.IteratorFlag = ... # 0x20
        DragEnabled              : QTreeWidgetItemIterator.IteratorFlag = ... # 0x40
        DragDisabled             : QTreeWidgetItemIterator.IteratorFlag = ... # 0x80
        DropEnabled              : QTreeWidgetItemIterator.IteratorFlag = ... # 0x100
        DropDisabled             : QTreeWidgetItemIterator.IteratorFlag = ... # 0x200
        HasChildren              : QTreeWidgetItemIterator.IteratorFlag = ... # 0x400
        NoChildren               : QTreeWidgetItemIterator.IteratorFlag = ... # 0x800
        Checked                  : QTreeWidgetItemIterator.IteratorFlag = ... # 0x1000
        NotChecked               : QTreeWidgetItemIterator.IteratorFlag = ... # 0x2000
        Enabled                  : QTreeWidgetItemIterator.IteratorFlag = ... # 0x4000
        Disabled                 : QTreeWidgetItemIterator.IteratorFlag = ... # 0x8000
        Editable                 : QTreeWidgetItemIterator.IteratorFlag = ... # 0x10000
        NotEditable              : QTreeWidgetItemIterator.IteratorFlag = ... # 0x20000
        UserFlag                 : QTreeWidgetItemIterator.IteratorFlag = ... # 0x1000000

    class IteratorFlags(object): ...

    @typing.overload
    def __init__(self, it: PySide2.QtWidgets.QTreeWidgetItemIterator) -> None: ...
    @typing.overload
    def __init__(self, item: PySide2.QtWidgets.QTreeWidgetItem, flags: PySide2.QtWidgets.QTreeWidgetItemIterator.IteratorFlags = ...) -> None: ...
    @typing.overload
    def __init__(self, widget: PySide2.QtWidgets.QTreeWidget, flags: PySide2.QtWidgets.QTreeWidgetItemIterator.IteratorFlags = ...) -> None: ...


class QUndoCommand(Shiboken.Object):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QUndoCommand] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[PySide2.QtWidgets.QUndoCommand] = ...) -> None: ...


class QUndoGroup(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QUndoStack(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QUndoView(PySide2.QtWidgets.QListView):

    @typing.overload
    def __init__(self, group: PySide2.QtWidgets.QUndoGroup, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, stack: PySide2.QtWidgets.QUndoStack, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QVBoxLayout(PySide2.QtWidgets.QBoxLayout):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget) -> None: ...


class QWhatsThis(Shiboken.Object): ...


class QWidget(PySide2.QtCore.QObject, PySide2.QtGui.QPaintDevice):
    DrawWindowBackground     : QWidget.RenderFlag = ... # 0x1
    DrawChildren             : QWidget.RenderFlag = ... # 0x2
    IgnoreMask               : QWidget.RenderFlag = ... # 0x4

    class RenderFlag(Shiboken.Enum):
        DrawWindowBackground     : QWidget.RenderFlag = ... # 0x1
        DrawChildren             : QWidget.RenderFlag = ... # 0x2
        IgnoreMask               : QWidget.RenderFlag = ... # 0x4

    class RenderFlags(object): ...

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., f: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...


class QWidgetAction(PySide2.QtWidgets.QAction):

    def __init__(self, parent: PySide2.QtCore.QObject) -> None: ...


class QWidgetItem(PySide2.QtWidgets.QLayoutItem):

    def __init__(self, w: PySide2.QtWidgets.QWidget) -> None: ...


class QWizard(PySide2.QtWidgets.QDialog):
    NoButton                 : QWizard.WizardButton = ... # -0x1
    BackButton               : QWizard.WizardButton = ... # 0x0
    NextButton               : QWizard.WizardButton = ... # 0x1
    CommitButton             : QWizard.WizardButton = ... # 0x2
    FinishButton             : QWizard.WizardButton = ... # 0x3
    CancelButton             : QWizard.WizardButton = ... # 0x4
    HelpButton               : QWizard.WizardButton = ... # 0x5
    CustomButton1            : QWizard.WizardButton = ... # 0x6
    NStandardButtons         : QWizard.WizardButton = ... # 0x6
    CustomButton2            : QWizard.WizardButton = ... # 0x7
    CustomButton3            : QWizard.WizardButton = ... # 0x8
    NButtons                 : QWizard.WizardButton = ... # 0x9
    Stretch                  : QWizard.WizardButton = ... # 0x9
    IndependentPages         : QWizard.WizardOption = ... # 0x1
    IgnoreSubTitles          : QWizard.WizardOption = ... # 0x2
    ExtendedWatermarkPixmap  : QWizard.WizardOption = ... # 0x4
    NoDefaultButton          : QWizard.WizardOption = ... # 0x8
    NoBackButtonOnStartPage  : QWizard.WizardOption = ... # 0x10
    NoBackButtonOnLastPage   : QWizard.WizardOption = ... # 0x20
    DisabledBackButtonOnLastPage: QWizard.WizardOption = ... # 0x40
    HaveNextButtonOnLastPage : QWizard.WizardOption = ... # 0x80
    HaveFinishButtonOnEarlyPages: QWizard.WizardOption = ... # 0x100
    NoCancelButton           : QWizard.WizardOption = ... # 0x200
    CancelButtonOnLeft       : QWizard.WizardOption = ... # 0x400
    HaveHelpButton           : QWizard.WizardOption = ... # 0x800
    HelpButtonOnRight        : QWizard.WizardOption = ... # 0x1000
    HaveCustomButton1        : QWizard.WizardOption = ... # 0x2000
    HaveCustomButton2        : QWizard.WizardOption = ... # 0x4000
    HaveCustomButton3        : QWizard.WizardOption = ... # 0x8000
    NoCancelButtonOnLastPage : QWizard.WizardOption = ... # 0x10000
    WatermarkPixmap          : QWizard.WizardPixmap = ... # 0x0
    LogoPixmap               : QWizard.WizardPixmap = ... # 0x1
    BannerPixmap             : QWizard.WizardPixmap = ... # 0x2
    BackgroundPixmap         : QWizard.WizardPixmap = ... # 0x3
    NPixmaps                 : QWizard.WizardPixmap = ... # 0x4
    ClassicStyle             : QWizard.WizardStyle = ... # 0x0
    ModernStyle              : QWizard.WizardStyle = ... # 0x1
    MacStyle                 : QWizard.WizardStyle = ... # 0x2
    AeroStyle                : QWizard.WizardStyle = ... # 0x3
    NStyles                  : QWizard.WizardStyle = ... # 0x4

    class WizardButton(Shiboken.Enum):
        NoButton                 : QWizard.WizardButton = ... # -0x1
        BackButton               : QWizard.WizardButton = ... # 0x0
        NextButton               : QWizard.WizardButton = ... # 0x1
        CommitButton             : QWizard.WizardButton = ... # 0x2
        FinishButton             : QWizard.WizardButton = ... # 0x3
        CancelButton             : QWizard.WizardButton = ... # 0x4
        HelpButton               : QWizard.WizardButton = ... # 0x5
        CustomButton1            : QWizard.WizardButton = ... # 0x6
        NStandardButtons         : QWizard.WizardButton = ... # 0x6
        CustomButton2            : QWizard.WizardButton = ... # 0x7
        CustomButton3            : QWizard.WizardButton = ... # 0x8
        NButtons                 : QWizard.WizardButton = ... # 0x9
        Stretch                  : QWizard.WizardButton = ... # 0x9

    class WizardOption(Shiboken.Enum):
        IndependentPages         : QWizard.WizardOption = ... # 0x1
        IgnoreSubTitles          : QWizard.WizardOption = ... # 0x2
        ExtendedWatermarkPixmap  : QWizard.WizardOption = ... # 0x4
        NoDefaultButton          : QWizard.WizardOption = ... # 0x8
        NoBackButtonOnStartPage  : QWizard.WizardOption = ... # 0x10
        NoBackButtonOnLastPage   : QWizard.WizardOption = ... # 0x20
        DisabledBackButtonOnLastPage: QWizard.WizardOption = ... # 0x40
        HaveNextButtonOnLastPage : QWizard.WizardOption = ... # 0x80
        HaveFinishButtonOnEarlyPages: QWizard.WizardOption = ... # 0x100
        NoCancelButton           : QWizard.WizardOption = ... # 0x200
        CancelButtonOnLeft       : QWizard.WizardOption = ... # 0x400
        HaveHelpButton           : QWizard.WizardOption = ... # 0x800
        HelpButtonOnRight        : QWizard.WizardOption = ... # 0x1000
        HaveCustomButton1        : QWizard.WizardOption = ... # 0x2000
        HaveCustomButton2        : QWizard.WizardOption = ... # 0x4000
        HaveCustomButton3        : QWizard.WizardOption = ... # 0x8000
        NoCancelButtonOnLastPage : QWizard.WizardOption = ... # 0x10000

    class WizardOptions(object): ...

    class WizardPixmap(Shiboken.Enum):
        WatermarkPixmap          : QWizard.WizardPixmap = ... # 0x0
        LogoPixmap               : QWizard.WizardPixmap = ... # 0x1
        BannerPixmap             : QWizard.WizardPixmap = ... # 0x2
        BackgroundPixmap         : QWizard.WizardPixmap = ... # 0x3
        NPixmaps                 : QWizard.WizardPixmap = ... # 0x4

    class WizardStyle(Shiboken.Enum):
        ClassicStyle             : QWizard.WizardStyle = ... # 0x0
        ModernStyle              : QWizard.WizardStyle = ... # 0x1
        MacStyle                 : QWizard.WizardStyle = ... # 0x2
        AeroStyle                : QWizard.WizardStyle = ... # 0x3
        NStyles                  : QWizard.WizardStyle = ... # 0x4

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...


class QWizardPage(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


# eof
