#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtXml, except for defaults which are replaced by "...".
"""

# Module PySide2.QtXml
import PySide2
try:
    import typing
except ImportError:
    from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

from shiboken2 import Shiboken

import PySide2.QtCore
import PySide2.QtXml


class QDomAttr(PySide2.QtXml.QDomNode):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: PySide2.QtXml.QDomAttr) -> None: ...


class QDomCDATASection(PySide2.QtXml.QDomText):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: PySide2.QtXml.QDomCDATASection) -> None: ...


class QDomCharacterData(PySide2.QtXml.QDomNode):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: PySide2.QtXml.QDomCharacterData) -> None: ...


class QDomComment(PySide2.QtXml.QDomCharacterData):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: PySide2.QtXml.QDomComment) -> None: ...


class QDomDocument(PySide2.QtXml.QDomNode):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, doctype: PySide2.QtXml.QDomDocumentType) -> None: ...
    @typing.overload
    def __init__(self, name: str) -> None: ...
    @typing.overload
    def __init__(self, x: PySide2.QtXml.QDomDocument) -> None: ...


class QDomDocumentFragment(PySide2.QtXml.QDomNode):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: PySide2.QtXml.QDomDocumentFragment) -> None: ...


class QDomDocumentType(PySide2.QtXml.QDomNode):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: PySide2.QtXml.QDomDocumentType) -> None: ...


class QDomElement(PySide2.QtXml.QDomNode):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: PySide2.QtXml.QDomElement) -> None: ...


class QDomEntity(PySide2.QtXml.QDomNode):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: PySide2.QtXml.QDomEntity) -> None: ...


class QDomEntityReference(PySide2.QtXml.QDomNode):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: PySide2.QtXml.QDomEntityReference) -> None: ...


class QDomImplementation(Shiboken.Object):
    AcceptInvalidChars       : QDomImplementation.InvalidDataPolicy = ... # 0x0
    DropInvalidChars         : QDomImplementation.InvalidDataPolicy = ... # 0x1
    ReturnNullNode           : QDomImplementation.InvalidDataPolicy = ... # 0x2

    class InvalidDataPolicy(Shiboken.Enum):
        AcceptInvalidChars       : QDomImplementation.InvalidDataPolicy = ... # 0x0
        DropInvalidChars         : QDomImplementation.InvalidDataPolicy = ... # 0x1
        ReturnNullNode           : QDomImplementation.InvalidDataPolicy = ... # 0x2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtXml.QDomImplementation) -> None: ...


class QDomNamedNodeMap(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtXml.QDomNamedNodeMap) -> None: ...


class QDomNode(Shiboken.Object):
    EncodingFromDocument     : QDomNode.EncodingPolicy = ... # 0x1
    EncodingFromTextStream   : QDomNode.EncodingPolicy = ... # 0x2
    ElementNode              : QDomNode.NodeType = ... # 0x1
    AttributeNode            : QDomNode.NodeType = ... # 0x2
    TextNode                 : QDomNode.NodeType = ... # 0x3
    CDATASectionNode         : QDomNode.NodeType = ... # 0x4
    EntityReferenceNode      : QDomNode.NodeType = ... # 0x5
    EntityNode               : QDomNode.NodeType = ... # 0x6
    ProcessingInstructionNode: QDomNode.NodeType = ... # 0x7
    CommentNode              : QDomNode.NodeType = ... # 0x8
    DocumentNode             : QDomNode.NodeType = ... # 0x9
    DocumentTypeNode         : QDomNode.NodeType = ... # 0xa
    DocumentFragmentNode     : QDomNode.NodeType = ... # 0xb
    NotationNode             : QDomNode.NodeType = ... # 0xc
    BaseNode                 : QDomNode.NodeType = ... # 0x15
    CharacterDataNode        : QDomNode.NodeType = ... # 0x16

    class EncodingPolicy(Shiboken.Enum):
        EncodingFromDocument     : QDomNode.EncodingPolicy = ... # 0x1
        EncodingFromTextStream   : QDomNode.EncodingPolicy = ... # 0x2

    class NodeType(Shiboken.Enum):
        ElementNode              : QDomNode.NodeType = ... # 0x1
        AttributeNode            : QDomNode.NodeType = ... # 0x2
        TextNode                 : QDomNode.NodeType = ... # 0x3
        CDATASectionNode         : QDomNode.NodeType = ... # 0x4
        EntityReferenceNode      : QDomNode.NodeType = ... # 0x5
        EntityNode               : QDomNode.NodeType = ... # 0x6
        ProcessingInstructionNode: QDomNode.NodeType = ... # 0x7
        CommentNode              : QDomNode.NodeType = ... # 0x8
        DocumentNode             : QDomNode.NodeType = ... # 0x9
        DocumentTypeNode         : QDomNode.NodeType = ... # 0xa
        DocumentFragmentNode     : QDomNode.NodeType = ... # 0xb
        NotationNode             : QDomNode.NodeType = ... # 0xc
        BaseNode                 : QDomNode.NodeType = ... # 0x15
        CharacterDataNode        : QDomNode.NodeType = ... # 0x16

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtXml.QDomNode) -> None: ...


class QDomNodeList(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtXml.QDomNodeList) -> None: ...


class QDomNotation(PySide2.QtXml.QDomNode):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: PySide2.QtXml.QDomNotation) -> None: ...


class QDomProcessingInstruction(PySide2.QtXml.QDomNode):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: PySide2.QtXml.QDomProcessingInstruction) -> None: ...


class QDomText(PySide2.QtXml.QDomCharacterData):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: PySide2.QtXml.QDomText) -> None: ...


class QXmlAttributes(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtXml.QXmlAttributes) -> None: ...


class QXmlContentHandler(Shiboken.Object):

    def __init__(self) -> None: ...


class QXmlDTDHandler(Shiboken.Object):

    def __init__(self) -> None: ...


class QXmlDeclHandler(Shiboken.Object):

    def __init__(self) -> None: ...


class QXmlDefaultHandler(PySide2.QtXml.QXmlContentHandler, PySide2.QtXml.QXmlErrorHandler, PySide2.QtXml.QXmlDTDHandler, PySide2.QtXml.QXmlEntityResolver, PySide2.QtXml.QXmlLexicalHandler, PySide2.QtXml.QXmlDeclHandler):

    def __init__(self) -> None: ...


class QXmlEntityResolver(Shiboken.Object):

    def __init__(self) -> None: ...


class QXmlErrorHandler(Shiboken.Object):

    def __init__(self) -> None: ...


class QXmlInputSource(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, dev: PySide2.QtCore.QIODevice) -> None: ...


class QXmlLexicalHandler(Shiboken.Object):

    def __init__(self) -> None: ...


class QXmlLocator(Shiboken.Object):

    def __init__(self) -> None: ...


class QXmlNamespaceSupport(Shiboken.Object):

    def __init__(self) -> None: ...


class QXmlParseException(Shiboken.Object):

    @typing.overload
    def __init__(self, name: str = ..., c: int = ..., l: int = ..., p: str = ..., s: str = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtXml.QXmlParseException) -> None: ...


class QXmlReader(Shiboken.Object):

    def __init__(self) -> None: ...


class QXmlSimpleReader(PySide2.QtXml.QXmlReader):

    def __init__(self) -> None: ...


# eof
