#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtXmlPatterns, except for defaults which are replaced by "...".
"""

# Module PySide2.QtXmlPatterns
import PySide2
try:
    import typing
except ImportError:
    from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

from shiboken2 import Shiboken

import PySide2.QtCore
import PySide2.QtXmlPatterns


class QAbstractMessageHandler(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QAbstractUriResolver(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QAbstractXmlNodeModel(Shiboken.Object):
    InheritNamespaces        : QAbstractXmlNodeModel.NodeCopySetting = ... # 0x1
    PreserveNamespaces       : QAbstractXmlNodeModel.NodeCopySetting = ... # 0x2
    Parent                   : QAbstractXmlNodeModel.SimpleAxis = ... # 0x0
    FirstChild               : QAbstractXmlNodeModel.SimpleAxis = ... # 0x1
    PreviousSibling          : QAbstractXmlNodeModel.SimpleAxis = ... # 0x2
    NextSibling              : QAbstractXmlNodeModel.SimpleAxis = ... # 0x3

    class NodeCopySetting(Shiboken.Enum):
        InheritNamespaces        : QAbstractXmlNodeModel.NodeCopySetting = ... # 0x1
        PreserveNamespaces       : QAbstractXmlNodeModel.NodeCopySetting = ... # 0x2

    class SimpleAxis(Shiboken.Enum):
        Parent                   : QAbstractXmlNodeModel.SimpleAxis = ... # 0x0
        FirstChild               : QAbstractXmlNodeModel.SimpleAxis = ... # 0x1
        PreviousSibling          : QAbstractXmlNodeModel.SimpleAxis = ... # 0x2
        NextSibling              : QAbstractXmlNodeModel.SimpleAxis = ... # 0x3

    def __init__(self) -> None: ...


class QAbstractXmlReceiver(Shiboken.Object):

    def __init__(self) -> None: ...


class QSourceLocation(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtXmlPatterns.QSourceLocation) -> None: ...
    @typing.overload
    def __init__(self, uri: PySide2.QtCore.QUrl, line: int = ..., column: int = ...) -> None: ...


class QXmlFormatter(PySide2.QtXmlPatterns.QXmlSerializer):

    def __init__(self, query: PySide2.QtXmlPatterns.QXmlQuery, outputDevice: PySide2.QtCore.QIODevice) -> None: ...


class QXmlItem(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, atomicValue: typing.Any) -> None: ...
    @typing.overload
    def __init__(self, node: PySide2.QtXmlPatterns.QXmlNodeModelIndex) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtXmlPatterns.QXmlItem) -> None: ...


class QXmlName(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, namePool: PySide2.QtXmlPatterns.QXmlNamePool, localName: str, namespaceURI: str = ..., prefix: str = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtXmlPatterns.QXmlName) -> None: ...


class QXmlNamePool(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtXmlPatterns.QXmlNamePool) -> None: ...


class QXmlNodeModelIndex(Shiboken.Object):
    Precedes                 : QXmlNodeModelIndex.DocumentOrder = ... # -0x1
    Is                       : QXmlNodeModelIndex.DocumentOrder = ... # 0x0
    Follows                  : QXmlNodeModelIndex.DocumentOrder = ... # 0x1
    Attribute                : QXmlNodeModelIndex.NodeKind = ... # 0x1
    Comment                  : QXmlNodeModelIndex.NodeKind = ... # 0x2
    Document                 : QXmlNodeModelIndex.NodeKind = ... # 0x4
    Element                  : QXmlNodeModelIndex.NodeKind = ... # 0x8
    Namespace                : QXmlNodeModelIndex.NodeKind = ... # 0x10
    ProcessingInstruction    : QXmlNodeModelIndex.NodeKind = ... # 0x20
    Text                     : QXmlNodeModelIndex.NodeKind = ... # 0x40

    class DocumentOrder(Shiboken.Enum):
        Precedes                 : QXmlNodeModelIndex.DocumentOrder = ... # -0x1
        Is                       : QXmlNodeModelIndex.DocumentOrder = ... # 0x0
        Follows                  : QXmlNodeModelIndex.DocumentOrder = ... # 0x1

    class NodeKind(Shiboken.Enum):
        Attribute                : QXmlNodeModelIndex.NodeKind = ... # 0x1
        Comment                  : QXmlNodeModelIndex.NodeKind = ... # 0x2
        Document                 : QXmlNodeModelIndex.NodeKind = ... # 0x4
        Element                  : QXmlNodeModelIndex.NodeKind = ... # 0x8
        Namespace                : QXmlNodeModelIndex.NodeKind = ... # 0x10
        ProcessingInstruction    : QXmlNodeModelIndex.NodeKind = ... # 0x20
        Text                     : QXmlNodeModelIndex.NodeKind = ... # 0x40

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtXmlPatterns.QXmlNodeModelIndex) -> None: ...


class QXmlQuery(Shiboken.Object):
    XQuery10                 : QXmlQuery.QueryLanguage = ... # 0x1
    XSLT20                   : QXmlQuery.QueryLanguage = ... # 0x2
    XmlSchema11IdentityConstraintSelector: QXmlQuery.QueryLanguage = ... # 0x400
    XmlSchema11IdentityConstraintField: QXmlQuery.QueryLanguage = ... # 0x800
    XPath20                  : QXmlQuery.QueryLanguage = ... # 0x1000

    class QueryLanguage(Shiboken.Enum):
        XQuery10                 : QXmlQuery.QueryLanguage = ... # 0x1
        XSLT20                   : QXmlQuery.QueryLanguage = ... # 0x2
        XmlSchema11IdentityConstraintSelector: QXmlQuery.QueryLanguage = ... # 0x400
        XmlSchema11IdentityConstraintField: QXmlQuery.QueryLanguage = ... # 0x800
        XPath20                  : QXmlQuery.QueryLanguage = ... # 0x1000

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, np: PySide2.QtXmlPatterns.QXmlNamePool) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtXmlPatterns.QXmlQuery) -> None: ...
    @typing.overload
    def __init__(self, queryLanguage: PySide2.QtXmlPatterns.QXmlQuery.QueryLanguage, np: PySide2.QtXmlPatterns.QXmlNamePool = ...) -> None: ...


class QXmlResultItems(Shiboken.Object):

    def __init__(self) -> None: ...


class QXmlSchema(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtXmlPatterns.QXmlSchema) -> None: ...


class QXmlSchemaValidator(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, schema: PySide2.QtXmlPatterns.QXmlSchema) -> None: ...


class QXmlSerializer(PySide2.QtXmlPatterns.QAbstractXmlReceiver):

    def __init__(self, query: PySide2.QtXmlPatterns.QXmlQuery, outputDevice: PySide2.QtCore.QIODevice) -> None: ...


# eof
